/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.distributed.propertyeditors.ErrorExpressionPanel;
import org.openide.compiler.ExternalCompiler;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class ErrorExpressionEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static Collection sharedList;
    public static final String ALPHA_VMS_ERROR_EXPR = "[ \\t]*[A|a]t line number ([0-9]+) in file (.*)$";
    public static final String ANT_JAVA_ERROR_EXPR = "^(file\\:)?([^ ][^ ]+):([0-9]+): (.*)";
    FeatureDescriptor fd;
    public static ExternalCompiler.ErrorExpression errorExpression;
    public static ExternalCompiler.ErrorExpression antErrorExpression;
    private Collection list;
    private ExternalCompiler.ErrorExpression value;

    public ErrorExpressionEditor() {
        this.list = new HashSet(17);
        this.list.add(errorExpression);
        this.list.add(ExternalCompiler.JAVAC);
        this.list.add(antErrorExpression);
    }

    public ErrorExpressionEditor(Collection list) {
        this.list = list;
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object value) {
        ErrorExpressionEditor errorExpressionEditor = this;
        synchronized (errorExpressionEditor) {
            this.value = (ExternalCompiler.ErrorExpression)value;
            this.list.add(value);
        }
        this.firePropertyChange();
    }

    public String getAsText() {
        return this.value.getName();
    }

    public void setAsText(String string) {
        ExternalCompiler.ErrorExpression[] exprs = this.getExpressions();
        for (int i = 0; i < exprs.length; ++i) {
            if (!string.equals(exprs[i].getName())) continue;
            this.setValue(exprs[i]);
            break;
        }
    }

    public String getJavaInitializationString() {
        return "new ExternalCompiler.ErrorExpression (" + this.value.getName() + ", " + this.value.getErrorExpression() + ", " + this.value.getFilePos() + ", " + this.value.getLinePos() + ", " + this.value.getColumnPos() + ", " + this.value.getDescriptionPos() + ")";
    }

    public String[] getTags() {
        ExternalCompiler.ErrorExpression[] exprs = this.getExpressions();
        String[] tags = new String[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            tags[i] = exprs[i].getName();
        }
        return tags;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new ErrorExpressionPanel(this);
    }

    synchronized ExternalCompiler.ErrorExpression[] getExpressions() {
        return this.list.toArray(new ExternalCompiler.ErrorExpression[this.list.size()]);
    }

    Collection getExpressionsVector() {
        return this.list;
    }

    public void attachEnv(PropertyEnv env) {
        this.fd = env.getFeatureDescriptor();
    }

    public String getHelpID() {
        return (String)this.fd.getValue("helpID");
    }

    static {
        errorExpression = new ExternalCompiler.ErrorExpression(NbBundle.getMessage((Class)ErrorExpressionEditor.class, (String)"ALPHA_VMS_ERROR_FILTER"), ALPHA_VMS_ERROR_EXPR, 2, 1, -1, -1);
        antErrorExpression = new ExternalCompiler.ErrorExpression(NbBundle.getMessage((Class)ErrorExpressionEditor.class, (String)"ANT_JAVA_ERROR_EXPR"), ANT_JAVA_ERROR_EXPR, 2, 3, -1, 4);
    }
}

