/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.explorer;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.modules.distributed.actions.ConnectAction;
import org.netbeans.modules.distributed.actions.ConnectCtxCookie;
import org.netbeans.modules.distributed.actions.DisconnectAction;
import org.netbeans.modules.distributed.actions.DisconnectCtxCookie;
import org.netbeans.modules.distributed.property.RemoteRuntimeProperty;
import org.netbeans.modules.distributed.propertyeditors.PasswordEditor;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.services.DistConnectionListener;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenLocalExplorerAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class RemoteRuntimeNode
extends AbstractNode
implements DisconnectCtxCookie,
ConnectCtxCookie,
DistConnectionListener,
Node.Cookie {
    private RemoteRuntimeType rrt;
    private int state = 2;
    private SystemAction action;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public RemoteRuntimeNode(RemoteRuntimeType rrt) {
        super(Children.LEAF);
        this.rrt = rrt;
        rrt.addConnectionListener(this);
        this.setConnectedState(2);
        this.setName(rrt.getHostName() + ":" + rrt.getUserName());
        this.setDisplayName(rrt.getHostName() + ":" + rrt.getUserName());
        this.setShortDescription(NbBundle.getMessage((Class)RemoteRuntimeNode.class, (String)"HINT_remote_runtime_node"));
        this.getCookieSet().add((Node.Cookie)this);
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public void connected() {
        this.setConnectedState(0);
    }

    public void connecting() {
        this.setConnectedState(1);
    }

    public void disconnected() {
        this.setConnectedState(2);
    }

    public void setIcon(String icon) {
        this.setIconBase(icon);
    }

    public void setConnectedState(int state) {
        if (state == 1) {
            this.state = 1;
            this.setIcon("org/netbeans/modules/distributed/resources/distConnecting");
        } else if (state == 0) {
            this.state = 0;
            this.setIcon("org/netbeans/modules/distributed/resources/connected");
        } else {
            this.state = 2;
            this.setIcon("org/netbeans/modules/distributed/resources/disconnected");
        }
    }

    protected Sheet createSheet() {
        ResourceBundle bundle = NbBundle.getBundle((Class)RemoteRuntimeNode.class);
        Sheet sheet = super.createSheet();
        Sheet.Set props = sheet.get("properties");
        if (props == null) {
            props = Sheet.createPropertiesSet();
            sheet.put(props);
        }
        RemoteRuntimeProperty prop = new HostNameProperty("hostName", this.rrt);
        prop.setName("hostName");
        prop.setDisplayName(bundle.getString("PROP_hostName"));
        prop.setShortDescription(bundle.getString("HINT_hostName"));
        props.put((Node.Property)prop);
        prop = new PasswordProperty("password", this.rrt);
        prop.setName("password");
        prop.setDisplayName(bundle.getString("PROP_password"));
        prop.setShortDescription(bundle.getString("HINT_password"));
        props.put((Node.Property)prop);
        prop = new PortProperty("port", this.rrt);
        prop.setName("port");
        prop.setDisplayName(bundle.getString("PROP_port"));
        prop.setShortDescription(bundle.getString("HINT_port"));
        props.put((Node.Property)prop);
        prop = new SvrTimeOutProperty("svrTimeOut", this.rrt);
        prop.setName("svrTimeOut");
        prop.setDisplayName(bundle.getString("PROP_svrTimeOut"));
        prop.setShortDescription(bundle.getString("HINT_svrTimeOut"));
        props.put((Node.Property)prop);
        prop = new UserNameProperty("userName", this.rrt);
        prop.setName("userName");
        prop.setDisplayName(bundle.getString("PROP_userName"));
        prop.setShortDescription(bundle.getString("HINT_userName"));
        props.put((Node.Property)prop);
        prop = new JDKVersionProperty("JDKVersion", this.rrt);
        prop.setName("JDKVersion");
        prop.setDisplayName(bundle.getString("PROP_JDKVersion"));
        prop.setShortDescription(bundle.getString("HINT_JDKVersion"));
        props.put((Node.Property)prop);
        prop = new RemoteOSProperty("RemoteOS", this.rrt);
        prop.setName("RemoteOS");
        prop.setDisplayName(bundle.getString("PROP_remoteOS"));
        prop.setShortDescription(bundle.getString("HINT_remoteOS"));
        props.put((Node.Property)prop);
        prop = new ConnectAtStartupProperty("ConnectAtStartup", this.rrt);
        prop.setName("ConnectAtStartup");
        prop.setDisplayName(bundle.getString("PROP_connectAtStartup"));
        prop.setShortDescription(bundle.getString("HINT_connectAtStartup"));
        props.put((Node.Property)prop);
        prop = new ServerVersionProperty("ServerVersion", this.rrt);
        prop.setName("ServerVersion");
        prop.setDisplayName(bundle.getString("PROP_ServerVersion"));
        prop.setShortDescription(bundle.getString("HINT_ServerVersion"));
        props.put((Node.Property)prop);
        prop = new SetupCommandProperty("setupCommand", this.rrt);
        prop.setName("setupCommand");
        prop.setDisplayName(bundle.getString("PROP_setupCommand"));
        prop.setShortDescription(bundle.getString("HINT_setupCommand"));
        props.put((Node.Property)prop);
        return sheet;
    }

    private void disconnectImpl() {
        this.setConnectedState(1);
        this.rrt.stopRemoteProcesses();
        this.rrt.disconnect(false);
        this.setConnectedState(2);
    }

    public void disconnect() {
        if (this.rrt != null) {
            if (this.rrt.remoteProcessCount() > 0) {
                Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)"There are active remote operations still underway.\nDisconnecting will abort those operations", "Warning", 2, 2));
                if (NotifyDescriptor.OK_OPTION.equals(obj)) {
                    this.disconnectImpl();
                }
            } else {
                this.disconnectImpl();
            }
        }
    }

    public void connect() {
        if (this.rrt != null) {
            this.setConnectedState(1);
            this.rrt.setConnectNow(true);
            RemoteRuntime rt = this.rrt.getRemoteRuntimeServerSafe();
            if (rt != null) {
                this.setConnectedState(0);
            } else {
                this.setConnectedState(2);
            }
        }
    }

    public int connectionState() {
        return this.state;
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)OpenLocalExplorerAction.class), null, SystemAction.get((Class)ConnectAction.class), SystemAction.get((Class)DisconnectAction.class), SystemAction.get((Class)DeleteAction.class), null, SystemAction.get((Class)ToolsAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    }

    public void destroy() throws IOException {
        super.destroy();
        this.rrt.disconnect(false);
        this.rrt.removeConnectionListener(this);
        DistributedSettings.getDefault().removeRemoteRuntime(this.rrt);
    }

    public boolean canDestroy() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private class ConnectAtStartupProperty
    extends RemoteRuntimeProperty {
        public ConnectAtStartupProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RemoteRuntimeNode.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().isConnectAtStartup() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            if (((Boolean)o).booleanValue()) {
                this.getRemoteRuntimeType().setConnectAtStartup(true);
            } else {
                this.getRemoteRuntimeType().setConnectAtStartup(false);
            }
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class PasswordProperty
    extends RemoteRuntimeProperty {
        public PasswordProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getPassword();
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setPassword((String)o);
        }

        public boolean canWrite() {
            return RemoteRuntimeNode.this.state == 2;
        }

        public boolean canRead() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            return PasswordEditor.getInstance();
        }
    }

    private class SvrTimeOutProperty
    extends RemoteRuntimeProperty {
        public SvrTimeOutProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt, class$java$lang$Integer == null ? (class$java$lang$Integer = RemoteRuntimeNode.class$("java.lang.Integer")) : class$java$lang$Integer);
        }

        public Object getValue() {
            return new Integer(this.getRemoteRuntimeType().getSvrTimeOut());
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            Integer svrTimeOut = (Integer)o;
            this.getRemoteRuntimeType().setSvrTimeOut(svrTimeOut);
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class PortProperty
    extends RemoteRuntimeProperty {
        public PortProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt, class$java$lang$Integer == null ? (class$java$lang$Integer = RemoteRuntimeNode.class$("java.lang.Integer")) : class$java$lang$Integer);
        }

        public Object getValue() {
            return new Integer(this.getRemoteRuntimeType().getPort());
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            Integer portNum = (Integer)o;
            this.getRemoteRuntimeType().setPort(portNum);
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class UserNameProperty
    extends RemoteRuntimeProperty {
        public UserNameProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getUserName();
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setUserName((String)o);
            RemoteRuntimeNode.this.setDisplayName(RemoteRuntimeNode.this.rrt.getHostName() + ":" + RemoteRuntimeNode.this.rrt.getUserName());
        }

        public boolean canWrite() {
            return RemoteRuntimeNode.this.state == 2;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class JDKVersionProperty
    extends RemoteRuntimeProperty {
        public JDKVersionProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getJDKVersion();
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class ServerVersionProperty
    extends RemoteRuntimeProperty {
        public ServerVersionProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getServerVersion();
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class RemoteOSProperty
    extends RemoteRuntimeProperty {
        public RemoteOSProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt);
        }

        public Object getValue() {
            String OS = "";
            try {
                if (this.getRemoteRuntimeType().isConnected()) {
                    OS = this.getRemoteRuntimeType().getRemoteRuntime().getOperatingSystem();
                }
            }
            catch (Exception re) {
                OS = "";
            }
            return OS;
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class SetupCommandProperty
    extends RemoteRuntimeProperty {
        public SetupCommandProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getSetupCommand();
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setSetupCommand((String)o);
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class HostNameProperty
    extends RemoteRuntimeProperty {
        public HostNameProperty(String propName, RemoteRuntimeType rrt) {
            super(propName, rrt);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getHostName();
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setHostName((String)o);
            RemoteRuntimeNode.this.setDisplayName(RemoteRuntimeNode.this.rrt.getHostName() + ":" + RemoteRuntimeNode.this.rrt.getUserName());
        }

        public boolean canWrite() {
            return RemoteRuntimeNode.this.state == 2;
        }

        public boolean canRead() {
            return true;
        }
    }
}

