/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.netbeans.modules.distributed.execute.RemoteExecutor;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.property.RemoteNbClassPath;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.java.JavaExternalCompilerType;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.compiler.CompilerType;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

public class RemoteJavaCompiler
extends RemoteExecutor {
    private static final long serialVersionUID = 4921782425419448314L;
    private static final int F_WARNINGS = 4;
    private static final int F_DEBUG_LINES = 4096;
    private static final int F_DEBUG_VARS = 8192;
    private static final int F_DEBUG_SOURCE = 262144;
    private static final int F_OPT = 16384;
    private static final int F_OPT_INTERCLASS = 32768;
    private static final int F_DEPENDENCIES = 32;
    private static final int F_DEPRECATION = 512;
    private static final String DEFAULT_ENCODING = "null";
    public static final FileSystem TARGET_INVALID = new LocalFileSystem();
    private static final String DEFAULT_BOOTCLASSPATH_REPLACE = "-bootclasspath ";
    private static final String PROP_SOURCE_14ENABLED = "source14Enabled";
    static final String ATTR_FILE_ENCODING = "Content-Encoding";
    private int flag = 274436;
    private static final String PROP_USE_CLASSIC_VM = "useClassicVM";
    private RemoteNbClassPath classPath;
    private RemoteNbClassPath bootClassPath;
    private transient RemoteNbClassPath defaultBootClassPath;
    private transient RemoteNbClassPath defaultClassPath;
    private transient R repoL;
    private transient boolean listenerRegistered;
    private transient FileSystem targetFileSystem;
    protected NbProcessDescriptor externalCompiler;
    private String optimizeReplace = "-O";
    private String debuginfoReplace = "-g";
    private String deprecationReplace = "-deprecation";
    private String encodingReplace = "-encoding";
    private String dReplace = "-d";
    private String bootclasspathReplace = "-bootclasspath ";
    private String[] envp = null;
    private File cwd = null;
    private boolean classPathCleared = true;
    private boolean source14Enabled;
    private String localizedNameKey;
    private boolean useLocal = true;
    private String targetFSName;
    private String charEncoding;
    private boolean useClassicVM;

    public static String getFileEncoding0(FileObject someFile) {
        return (String)someFile.getAttribute(ATTR_FILE_ENCODING);
    }

    public static String getFileEncoding(FileObject someFile) {
        String enc = RemoteJavaCompiler.getFileEncoding0(someFile);
        if (enc == null) {
            enc = JavaSettings.getDefault().getDefaultEncoding();
        }
        if ("".equals(enc)) {
            return null;
        }
        return enc;
    }

    public RemoteJavaCompiler() {
        this.setUseLocal(false);
        this.setRemoteExecutor(this.getExternalExecutor());
        this.setErrorExpression(ExternalCompiler.JAVAC);
    }

    protected void finalize() throws Throwable {
    }

    protected void createDefaultMapFormat(DataObject obj) throws IOException {
        String encoding = null;
        encoding = this.getCharEncoding();
        if (encoding == null || "".equals(encoding)) {
            encoding = RemoteJavaCompiler.getFileEncoding(obj.getPrimaryFile());
        }
        AbstractNetworkFileSystem nfs = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
            Map map = super.createMapFormat(obj, nfs).getMap();
            String fileName = (String)map.get("file");
            fileName = FileUtility.openVMSPathToUnixPath(fileName, false);
            map.put("file", fileName);
            String fileSystemRoot = FileUtility.openVMSPathToUnixPath(nfs.getRemoteRoot(), true);
            this.format = new JFormat(new String[]{fileName}, fileSystemRoot, this, encoding, obj);
        }
        catch (FileStateInvalidException exp) {
        }
        catch (IOException e) {
            throw e;
        }
    }

    public ExecutorTask execute(DataObject obj) throws IOException {
        this.createDefaultMapFormat(obj);
        return super.execute(obj);
    }

    private JavaExternalCompilerType getJavaExternalCompilerType() {
        Class c = JavaExternalCompilerType.class;
        JavaExternalCompilerType type = (JavaExternalCompilerType)Lookup.getDefault().lookup(c);
        return type == null ? (JavaExternalCompilerType)CompilerType.getDefault() : type;
    }

    private FileSystem findFileSystem() {
        Repository repo = Repository.getDefault();
        Enumeration en = repo.fileSystems();
        FileSystem target = null;
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            if (!fs.getSystemName().equals(this.targetFSName) || !(fs instanceof AbstractNetworkFileSystem)) continue;
            target = fs;
            break;
        }
        return target;
    }

    private void makeReadOnly() {
        if (this.getUseLocal()) {
            String msg = "Selected property is a property of the External Compilation.\n";
            msg = msg + "To change the property, change the property from Compiler Type\\External Compilation.\n";
            msg = msg + "To change the corresponding remote property, set Use Local Copy to false";
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        }
    }

    public int flag() {
        return this.flag;
    }

    private void orFlag(int f) {
        int oldflag = this.flag;
        this.flag |= f;
        this.firePropertyChange("flag", new Integer(oldflag), new Integer(this.flag));
    }

    private void andFlag(int f) {
        int oldflag = this.flag;
        this.flag &= f;
        this.firePropertyChange("flag", new Integer(oldflag), new Integer(this.flag));
    }

    public static String getString(String name) {
        ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.java.Bundle");
        return bundle.getString(name);
    }

    public boolean getUseLocal() {
        return this.useLocal;
    }

    public void setUseLocal(boolean useLocal) {
        this.useLocal = useLocal;
        this.resetToLocal();
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        if (this.remoteExecutor == null) {
            this.remoteExecutor = new RemoteProcessDescriptor(this.getExternalCompiler().getProcessName(), this.getExternalCompiler().getArguments(), this.getExternalCompiler().getInfo());
        }
        return this.remoteExecutor;
    }

    public RemoteProcessDescriptor getRemoteExecutor() {
        return this.getExternalExecutor();
    }

    public void setRemoteExecutor(RemoteProcessDescriptor re) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        this.remoteExecutor = re;
        this.firePropertyChange("remoteExecutor", null, re);
    }

    public RemoteNbClassPath getClassPath() {
        if (this.getUseLocal()) {
            return new RemoteNbClassPath(this.getJavaExternalCompilerType().getClassPath());
        }
        RemoteNbClassPath p = this.classPath;
        if (p != null) {
            return p;
        }
        return this.createDefaultClassPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteNbClassPath createDefaultClassPath() {
        if (this.defaultClassPath != null) {
            return this.defaultClassPath;
        }
        RemoteJavaCompiler remoteJavaCompiler = this;
        synchronized (remoteJavaCompiler) {
            if (this.defaultClassPath == null) {
                this.defaultClassPath = new RemoteNbClassPath("");
            }
        }
        return this.defaultClassPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassPath(RemoteNbClassPath path) {
        RemoteNbClassPath old;
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        RemoteJavaCompiler remoteJavaCompiler = this;
        synchronized (remoteJavaCompiler) {
            if (path == this.getClassPath() || path != null && path.equals(this.getClassPath())) {
                return;
            }
            old = this.classPath;
            this.classPath = path;
        }
        this.firePropertyChange("classPath", old, this.classPath);
    }

    public RemoteNbClassPath getBootClassPath() {
        if (this.getUseLocal()) {
            return new RemoteNbClassPath(this.getJavaExternalCompilerType().getBootClassPath());
        }
        RemoteNbClassPath bcp = this.bootClassPath;
        if (bcp != null) {
            return bcp;
        }
        return this.bootClassPath == null ? this.getDefaultBootClassPath() : this.bootClassPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteNbClassPath getDefaultBootClassPath() {
        if (this.defaultBootClassPath != null) {
            return this.defaultBootClassPath;
        }
        RemoteJavaCompiler remoteJavaCompiler = this;
        synchronized (remoteJavaCompiler) {
            if (this.defaultBootClassPath != null) {
                return this.defaultBootClassPath;
            }
        }
        this.defaultBootClassPath = new RemoteNbClassPath("");
        return this.defaultBootClassPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBootClassPath(RemoteNbClassPath path) {
        RemoteNbClassPath old;
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        RemoteJavaCompiler remoteJavaCompiler = this;
        synchronized (remoteJavaCompiler) {
            if (path == this.getBootClassPath() || path != null && path.equals(this.getBootClassPath())) {
                return;
            }
            old = this.bootClassPath;
            this.bootClassPath = path;
        }
        this.firePropertyChange("bootClassPath", old, this.bootClassPath);
    }

    public void setWarnings(boolean x) {
        boolean old;
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        boolean bl = old = (this.flag & 4) != 0;
        if (x) {
            if (!old) {
                this.orFlag(4);
            }
        } else if (old) {
            this.andFlag(-5);
        }
        if (x != old) {
            this.firePropertyChange("warnings", old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getWarnings() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getWarnings();
        }
        return (this.flag & 4) != 0;
    }

    public void setDebug(boolean x) {
        boolean old;
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        boolean bl = old = (this.flag & 0x43000) != 0;
        if (x) {
            if (!old) {
                this.orFlag(274432);
            }
        } else if (old) {
            this.andFlag(-274433);
        }
        if (x != old) {
            this.firePropertyChange("debug", old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getDebug() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getDebug();
        }
        return (this.flag & 0x43000) != 0;
    }

    public void setOptimize(boolean x) {
        boolean old;
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        boolean bl = old = (this.flag & 0xC000) != 0;
        if (x) {
            if (!old) {
                this.orFlag(49152);
            }
        } else if (old) {
            this.andFlag(-49153);
        }
        if (x != old) {
            this.firePropertyChange("optimize", old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getOptimize() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getOptimize();
        }
        return (this.flag & 0xC000) != 0;
    }

    public void setDeprecation(boolean x) {
        boolean old;
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        boolean bl = old = (this.flag & 0x200) != 0;
        if (x) {
            if (!old) {
                this.orFlag(512);
            }
        } else if (old) {
            this.andFlag(-513);
        }
        if (x != old) {
            this.firePropertyChange("deprecation", old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getDeprecation() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getDeprecation();
        }
        return (this.flag & 0x200) != 0;
    }

    public void setCharEncoding(String enc) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        if (enc != null) {
            if ((enc = enc.trim()).equals("")) {
                enc = null;
            } else if (DEFAULT_ENCODING.equalsIgnoreCase(enc)) {
                enc = null;
            }
        }
        String old = this.charEncoding;
        this.charEncoding = enc;
        this.firePropertyChange("charEncoding", old, this.charEncoding);
    }

    public String getCharEncoding() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getCharEncoding();
        }
        return this.charEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetFileSystem(FileSystem target) {
        FileSystem fs;
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        RemoteJavaCompiler remoteJavaCompiler = this;
        synchronized (remoteJavaCompiler) {
            fs = this.getTargetFileSystem();
            if (target == fs || target != null && fs != null && target.equals(fs)) {
                return;
            }
            if (target != null) {
                if (target != TARGET_INVALID) {
                    this.targetFSName = target.getSystemName();
                }
                this.registerRepositoryListener();
            } else {
                this.targetFSName = null;
            }
            this.targetFileSystem = target;
        }
        this.firePropertyChange("targetFileSystem", fs, target);
    }

    private void registerRepositoryListener() {
        if (!this.listenerRegistered) {
            Repository repo = Repository.getDefault();
            this.repoL = new R();
            repo.addRepositoryListener(WeakListener.repository((RepositoryListener)this.repoL, (Object)repo));
            this.listenerRegistered = true;
        }
    }

    public void assureValidTargetFSBase() throws IOException {
        FileSystem fs = this.getTargetFileSystem();
        if (fs == null) {
            return;
        }
        String key = null;
        if (fs == TARGET_INVALID) {
            key = "MSG_FS_Invalid";
        } else {
            Enumeration en = Repository.getDefault().fileSystems();
            boolean match = false;
            while (en.hasMoreElements()) {
                FileSystem xfs = (FileSystem)en.nextElement();
                if (xfs != fs) continue;
                match = true;
                break;
            }
            if (!match) {
                key = "MSG_FS_NotMounted";
            }
        }
        if (key == null) {
            if (fs.isReadOnly()) {
                key = "MSG_FS_ReadOnly";
            } else {
                return;
            }
        }
        String msg = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.distributed.execute").getString(key), fs.getDisplayName());
        throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(msg), 256, null, msg, null, null);
    }

    public void assureValidTargetFS() throws IOException {
        this.assureValidTargetFSBase();
        FileSystem fs = this.getTargetFileSystem();
        if (fs == null) {
            return;
        }
        File f = RemoteNbClassPath.toFile(fs.getRoot());
        if (f == null || !f.exists() || !f.isDirectory()) {
            String message = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.distributed.execute").getString("MSG_FS_NonLocal"), fs.getDisplayName());
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(message), 256, message, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getTargetFileSystem() {
        if (this.getUseLocal()) {
            if (this.getJavaExternalCompilerType().getTargetFileSystem() instanceof AbstractNetworkFileSystem) {
                return this.getJavaExternalCompilerType().getTargetFileSystem();
            }
            return TARGET_INVALID;
        }
        RemoteJavaCompiler remoteJavaCompiler = this;
        synchronized (remoteJavaCompiler) {
            if (this.targetFileSystem == null) {
                FileSystem f = this.findFileSystem();
                this.targetFileSystem = f == null ? TARGET_INVALID : f;
                this.registerRepositoryListener();
            }
        }
        return this.targetFileSystem;
    }

    public void setSource14Enable(boolean enable) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        boolean old = this.source14Enabled;
        if (enable == old) {
            return;
        }
        this.source14Enabled = enable;
        this.firePropertyChange(PROP_SOURCE_14ENABLED, enable ? Boolean.FALSE : Boolean.TRUE, enable ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getSource14Enable() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getSource14Enable();
        }
        return this.source14Enabled;
    }

    public NbProcessDescriptor getExternalCompiler() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getExternalCompiler();
        }
        if (this.externalCompiler == null) {
            this.externalCompiler = this.createDescriptor();
        } else if (!this.classPathCleared) {
            String arguments = this.externalCompiler.getArguments();
            String searched = "{classpath}";
            String searched2 = "{:}";
            int pos = arguments.indexOf(searched);
            if (pos != -1) {
                int after = pos + searched.length();
                if (arguments.length() >= after + searched2.length() && searched2.regionMatches(0, arguments, after, searched2.length())) {
                    after += searched2.length();
                }
                StringBuffer sb = new StringBuffer(arguments);
                sb.delete(pos, after);
                this.externalCompiler = new NbProcessDescriptor(this.externalCompiler.getProcessName(), sb.toString(), this.externalCompiler.getInfo());
            }
            this.classPathCleared = true;
        }
        return this.externalCompiler;
    }

    protected NbProcessDescriptor createDescriptor() {
        return new NbProcessDescriptor("{jdk.home}{/}bin{/}javac", "{debuginfo} {deprecation} {optimize} {outputdir} {encoding} {source.opt} {bootclasspath.opt} {bootclasspath} -classpath {filesystems}{:}{classpath} {files}", RemoteJavaCompiler.getAdditionalHint());
    }

    static final String getAdditionalHint() {
        ResourceBundle bundle = NbBundle.getBundle((String)"org.openide.compiler.Bundle");
        String hint0 = bundle.getString("MSG_ExternalCompilerHint");
        bundle = NbBundle.getBundle((Class)JavaExternalCompilerType.class);
        String hint1 = bundle.getString("MSG_ExternalCompilerHint");
        return hint0 + hint1;
    }

    public void setExternalCompiler(NbProcessDescriptor compiler) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        NbProcessDescriptor old = this.externalCompiler;
        this.externalCompiler = compiler;
        this.firePropertyChange("externalCompilerType", old, this.externalCompiler);
        this.setRemoteExecutor(new RemoteProcessDescriptor(this.externalCompiler.getProcessName(), this.externalCompiler.getArguments(), this.externalCompiler.getInfo()));
    }

    public void setOptimizeReplace(String x) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        String old = this.optimizeReplace;
        this.optimizeReplace = x;
        this.firePropertyChange("optimizeReplace", old, this.optimizeReplace);
    }

    public void setDebuginfoReplace(String x) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        String old = this.debuginfoReplace;
        this.debuginfoReplace = x;
        this.firePropertyChange("debuginfoReplace", old, this.debuginfoReplace);
    }

    public void setDeprecationReplace(String x) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        String old = this.deprecationReplace;
        this.deprecationReplace = x;
        this.firePropertyChange("deprecationReplace", old, x);
    }

    public void setEncodingReplace(String x) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        String old = this.encodingReplace;
        this.encodingReplace = x;
        this.firePropertyChange("encodingReplace", old, x);
    }

    public void setBootClassPathReplace(String x) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        String old = this.bootclasspathReplace;
        this.bootclasspathReplace = x;
        this.firePropertyChange("bootclasspathReplace", old, x);
    }

    public void setDReplace(String x) {
        this.dReplace = x;
    }

    public String getOptimizeReplace() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getOptimizeReplace();
        }
        return this.optimizeReplace;
    }

    public String getDebuginfoReplace() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getDebuginfoReplace();
        }
        return this.debuginfoReplace;
    }

    public String getDeprecationReplace() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getDeprecationReplace();
        }
        return this.deprecationReplace;
    }

    public String getEncodingReplace() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getEncodingReplace();
        }
        return this.encodingReplace;
    }

    public String getDReplace() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getDReplace();
        }
        return this.dReplace;
    }

    public String getBootClassPathReplace() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getBootClassPathReplace();
        }
        return this.bootclasspathReplace;
    }

    public RemoteNbClassPath getRepositoryPath() {
        return RemoteNbClassPath.createRepositoryPath(FileSystemCapability.ALL);
    }

    public String[] getEnvironmentVariables() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getEnvironmentVariables();
        }
        return this.envp;
    }

    public synchronized void setEnvironmentVariables(String[] nue) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        String[] old = this.envp;
        this.envp = nue;
        this.firePropertyChange("environmentVariables", old, nue);
    }

    public File getWorkingDirectory() {
        if (this.getUseLocal()) {
            return this.getJavaExternalCompilerType().getWorkingDirectory();
        }
        return this.cwd;
    }

    public synchronized void setWorkingDirectory(File nue) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        File old = this.cwd;
        this.cwd = nue;
        this.firePropertyChange("workingDirectory", old, nue);
    }

    private void resetToLocal() {
        this.firePropertyChange("flag", null, new Integer(this.flag));
        this.firePropertyChange("debug", null, this.getDebug() ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("classPath", null, this.getClassPath());
        this.firePropertyChange("bootClassPath", null, this.getBootClassPath());
        this.firePropertyChange("warnings", null, this.getWarnings() ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("debug", null, this.getDebug() ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("optimize", null, this.getOptimize() ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("deprecation", null, this.getDeprecation() ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("charEncoding", null, this.getCharEncoding());
        this.firePropertyChange("targetFileSystem", null, this.getTargetFileSystem());
        this.firePropertyChange(PROP_SOURCE_14ENABLED, null, this.getSource14Enable() ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("externalCompilerType", null, this.getExternalCompiler());
        this.firePropertyChange("optimizeReplace", null, this.getOptimizeReplace());
        this.firePropertyChange("debuginfoReplace", null, this.getDebuginfoReplace());
        this.firePropertyChange("deprecationReplace", null, this.getDeprecationReplace());
        this.firePropertyChange("encodingReplace", null, this.getEncodingReplace());
        this.firePropertyChange("bootclasspathReplace", null, this.getBootClassPathReplace());
        this.firePropertyChange("environmentVariables", null, this.getEnvironmentVariables());
        this.firePropertyChange("workingDirectory", null, this.getWorkingDirectory());
    }

    private class R
    extends RepositoryAdapter {
        private R() {
        }

        public void fileSystemAdded(RepositoryEvent ev) {
            String fsName = RemoteJavaCompiler.this.targetFSName;
            if (fsName == null || RemoteJavaCompiler.this.targetFileSystem != TARGET_INVALID) {
                return;
            }
            FileSystem fs = ev.getFileSystem();
            if (fs.getSystemName().equals(fsName)) {
                RemoteJavaCompiler.this.setTargetFileSystem(fs);
            }
        }

        public void fileSystemRemoved(RepositoryEvent ev) {
            if (ev.getFileSystem() != RemoteJavaCompiler.this.targetFileSystem) {
                return;
            }
            RemoteJavaCompiler.this.setTargetFileSystem(TARGET_INVALID);
        }
    }

    public static class JFormat
    extends ExternalCompilerGroup.Format {
        public static final String TAG_OPTIMIZE = "optimize";
        public static final String TAG_DEBUGINFO = "debuginfo";
        public static final String TAG_DEPRECATION = "deprecation";
        public static final String TAG_ENCODING = "encoding";
        public static final String TAG_OUTDIR = "outputdir";
        public static final String TAG_IDEHOME = "ide.home";
        public static final String TAG_NBHOME = "netbeans.home";
        public static final String TAG_FORTEHOME = "forte.home";
        public static final String TAG_OPTION_BOOTCLASSPATH = "bootclasspath.opt";
        public static final String TAG_QUOTE = "q";
        public static final String TAG_SYSTEMBOOTCLASSPATH = "sun.boot.class.path";
        public static final String TAG_SOURCE = "source.opt";
        static final long serialVersionUID = -8630048324703405233L;

        public JFormat(String[] files, String fsSystemRoot, RemoteJavaCompiler jext, String encoding, DataObject dobj) throws IOException {
            super(files, new NbClassPath(jext.getClassPath().getRemoteClassPath(dobj)), new NbClassPath(jext.getBootClassPath().getRemoteClassPath()), new NbClassPath(jext.getRepositoryPath().getRemoteClassPath()), new NbClassPath(""));
            Map map = this.getMap();
            map.put(TAG_OPTIMIZE, jext.getOptimize() ? jext.getOptimizeReplace() : "");
            map.put(TAG_DEBUGINFO, jext.getDebug() ? jext.getDebuginfoReplace() : "");
            map.put(TAG_DEPRECATION, jext.getDeprecation() ? jext.getDeprecationReplace() : "");
            map.put(TAG_OUTDIR, JFormat.createOutputReplace(jext));
            map.put(TAG_ENCODING, this.createEncodingReplace(jext, encoding));
            map.put(TAG_QUOTE, "\"");
            String nb = System.getProperty(TAG_NBHOME);
            nb = new File(nb).getCanonicalPath();
            map.put(TAG_FORTEHOME, nb);
            map.put(TAG_NBHOME, nb);
            map.put(TAG_IDEHOME, nb);
            map.put(TAG_OPTION_BOOTCLASSPATH, this.createBootClassPathReplace(jext));
            map.put(TAG_SYSTEMBOOTCLASSPATH, JFormat.createSystemBootClassPath());
            map.put(TAG_SOURCE, this.createSourceReplace(jext));
            map.remove("java.home");
            map.remove("jdk.home");
            map.put("/", "/");
            map.put(":", ":");
        }

        private String createSourceReplace(RemoteJavaCompiler jext) {
            if (!jext.getSource14Enable()) {
                return "";
            }
            return "-source 1.4 ";
        }

        protected String createBootClassPathReplace(RemoteJavaCompiler t) {
            RemoteNbClassPath bcp = t.getBootClassPath();
            if (bcp == null) {
                return "";
            }
            String classPath = bcp.getClassPath();
            if (!"".equals(classPath)) {
                return t.getBootClassPathReplace();
            }
            return "";
        }

        private static int getClassPathEntriesEnd(int idx, String searched) {
            boolean slashed = false;
            boolean inToken = false;
            int slen = searched.length();
            block5: for (int i = idx; i < slen; ++i) {
                switch (searched.charAt(i)) {
                    case ' ': {
                        if (inToken) continue block5;
                        return i;
                    }
                    case '\\': {
                        slashed = !slashed;
                        continue block5;
                    }
                    case '\"': {
                        if (!slashed) {
                            inToken = !inToken;
                        }
                    }
                    default: {
                        slashed = false;
                    }
                }
            }
            return -1;
        }

        String createEncodingReplace(RemoteJavaCompiler jext, String encoding) {
            if (encoding == null || "".equals(encoding)) {
                return "";
            }
            return jext.getEncodingReplace() + " " + encoding;
        }

        static String createOutputReplace(RemoteJavaCompiler jext) {
            boolean hasSpace;
            FileSystem fs = jext.getTargetFileSystem();
            if (fs == TARGET_INVALID) {
                return "";
            }
            StringBuffer sb = new StringBuffer(fs.getSystemName().length() + 4);
            sb.append(jext.getDReplace());
            String localName = ((AbstractNetworkFileSystem)fs).getRemoteRoot();
            boolean bl = hasSpace = localName.indexOf(32) > -1;
            if (hasSpace) {
                sb.append(" \"");
            } else {
                sb.append(" ");
            }
            sb.append(localName);
            if (hasSpace) {
                sb.append('\"');
            }
            return sb.toString();
        }

        static String createSystemBootClassPath() {
            String bcp = System.getProperty(TAG_SYSTEMBOOTCLASSPATH);
            StringTokenizer tukac = new StringTokenizer(bcp, File.pathSeparator);
            boolean hasSpaces = false;
            StringBuffer sb = new StringBuffer(bcp.length());
            boolean first = true;
            while (tukac.hasMoreElements()) {
                String s = tukac.nextToken();
                File f = new File(s);
                if (!f.exists()) continue;
                if (s.indexOf(32) > -1) {
                    hasSpaces = true;
                }
                if (!first) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append(s);
                first = false;
            }
            if (sb.length() == 0) {
                return "\"\"";
            }
            if (hasSpaces) {
                sb.insert(0, '\"');
                sb.append('\"');
            }
            return sb.toString();
        }
    }
}

