/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.distributed.execute.RemoteExecutor;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.property.RemoteNbClassPath;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.java.JavaProcessExecutor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.Executor;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class RemoteJarExecutor
extends RemoteExecutor {
    private static final long serialVersionUID = 4921782425419448314L;
    private static final RemoteNbClassPath EMPTY_CLASSPATH = new RemoteNbClassPath("");
    public static final String PROP_LIBRARYPATH = "libraryPath";
    public static final String PROP_REPOSPATH = "repositoryPath";
    public static final String PROP_EXTERNAL_EXECUTOR2 = "externalExecutor2";
    public static final String PROP_CLASSPATH = "classPath";
    public static final String PROP_BOOTCLASSPATH = "bootClassPath";
    public static final String PROP_WORKDIR = "workingDirectory";
    public static final String PROP_ENVVARS = "environmentVariables";
    public static final String PROP_APPENDENVVARS = "appendEnvironmentVariables";
    public static final String PROP_ASSERT_ENABLED = "assertEnabled";
    public static final String PROP_USELOCAL = "useLocal";
    public static final String PROP_USE_CLASSIC_VM = "useClassicVM";
    protected NbProcessDescriptor externalExecutor2;
    private boolean assertEnabled = false;

    public RemoteJarExecutor() {
        this.setChangeWorkingDir(false);
        this.setRemoteExecutor(this.getExternalExecutor());
        this.setErrorExpression(ExternalCompiler.JAVAC);
    }

    protected void finalize() throws Throwable {
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        if (this.remoteExecutor == null) {
            this.remoteExecutor = new RemoteProcessDescriptor(this.getExternalExecutor2().getProcessName(), this.getExternalExecutor2().getArguments(), this.getExternalExecutor2().getInfo());
        }
        return this.remoteExecutor;
    }

    public RemoteProcessDescriptor getRemoteExecutor() {
        return this.getExternalExecutor();
    }

    public void setRemoteExecutor(RemoteProcessDescriptor re) {
        this.remoteExecutor = re;
        this.firePropertyChange("remoteExecutor", null, this.remoteExecutor);
    }

    private JavaProcessExecutor getJavaProcessExecutor() {
        Class c = JavaProcessExecutor.class;
        JavaProcessExecutor type = (JavaProcessExecutor)Lookup.getDefault().lookup(c);
        return type == null ? (JavaProcessExecutor)Executor.getDefault() : type;
    }

    public NbProcessDescriptor getExternalExecutor2() {
        if (this.externalExecutor2 == null) {
            this.externalExecutor2 = this.createDescriptor();
        }
        return this.externalExecutor2;
    }

    public void setExternalExecutor2(NbProcessDescriptor exec) {
        NbProcessDescriptor old = this.externalExecutor2;
        this.externalExecutor2 = exec;
        this.firePropertyChange(PROP_EXTERNAL_EXECUTOR2, old, this.externalExecutor2);
        this.setRemoteExecutor(new RemoteProcessDescriptor(this.externalExecutor2.getProcessName(), this.externalExecutor2.getArguments(), this.externalExecutor2.getInfo()));
    }

    protected NbProcessDescriptor createDescriptor() {
        return new NbProcessDescriptor("{java.home}{/}bin{/}java", "{assertEnabled} -Dsun.java2d.pmoffscreen=false -jar {jarfile} {arguments}", NbBundle.getBundle((Class)RemoteJarExecutor.class).getString("MSG_JarExecutorHint"));
    }

    public void setWorkingDirectory(File buildDir) throws IOException {
        boolean found = false;
        if (buildDir != null) {
            FileObject[] fobjs = FileUtil.fromFile((File)buildDir);
            for (int j = 0; j < fobjs.length; ++j) {
                try {
                    if (!(fobjs[j].getFileSystem() instanceof FTPFileSystem) && !(fobjs[j].getFileSystem() instanceof NetworkFileSystem)) continue;
                    found = true;
                    break;
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
            }
        }
        if (found || buildDir == null) {
            File old = this.workingDirectory;
            this.workingDirectory = buildDir;
            this.firePropertyChange(PROP_WORKDIR, old, this.workingDirectory);
        } else {
            String msg = "You can only add Remote File System";
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        }
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isAssertEnabled() {
        return this.assertEnabled;
    }

    public void setAssertEnabled(boolean assertFlag) {
        boolean old = this.assertEnabled;
        this.assertEnabled = assertFlag;
        this.firePropertyChange(PROP_ASSERT_ENABLED, old ? Boolean.TRUE : Boolean.FALSE, this.assertEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void createDefaultMapFormat(DataObject obj) throws IOException {
        AbstractNetworkFileSystem nfs = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
            Map map = super.createMapFormat(obj, nfs).getMap();
            String arg = (String)map.get("arguments");
            String fileName = (String)map.get("file");
            fileName = FileUtility.openVMSPathToUnixPath(fileName, false);
            map.put("file", fileName);
            String remoteRoot = FileUtility.openVMSPathToUnixPath(nfs.getRemoteRoot(), true);
            this.format = new JFormat(fileName, new String[]{arg}, this.isAssertEnabled(), obj);
        }
        catch (FileStateInvalidException exp) {
        }
        catch (IOException e) {
            throw e;
        }
    }

    public ExecutorTask execute(DataObject obj) throws IOException {
        this.createDefaultMapFormat(obj);
        if (this.getWorkingDirectory() != null) {
            this.setChangeWorkingDir(true);
        } else {
            this.setChangeWorkingDir(false);
        }
        return super.execute(obj);
    }

    public static class JFormat
    extends MapFormat {
        public static final String TAG_ASSERT_ENABLED = "assertEnabled";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        public static final String TAG_JARFILE = "jarfile";
        static final long serialVersionUID = -1524637220865300001L;

        public JFormat(String jarfile, String[] args, boolean isAssertEnabled, DataObject dobj) {
            super(new HashMap());
            Map map = this.getMap();
            map.put(TAG_SEPARATOR, TAG_SEPARATOR);
            map.put(TAG_PATHSEPARATOR, TAG_PATHSEPARATOR);
            map.put(TAG_JARFILE, jarfile);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                sb.append('\"');
                sb.append(args[i]);
                sb.append('\"');
                sb.append(' ');
            }
            map.put(TAG_ARGUMENTS, sb.toString());
            map.put("assertEnabled", isAssertEnabled ? "-ea " : "");
        }
    }
}

