/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.client;

import java.net.InetAddress;
import java.rmi.RMISecurityManager;
import java.util.HashMap;
import org.netbeans.modules.distributed.client.RemoteLoginClient;
import org.netbeans.modules.distributed.rmi.protocol.Admin;
import org.netbeans.modules.distributed.rmi.protocol.RemoteData;
import org.netbeans.modules.distributed.rmi.protocol.RemoteInputStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteProcess;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;

public class TestClientServerRMI {
    public static final String VERSION_TAG = "VERSION";
    public static final String USER_TAG = "USER";
    public static final String PASSWD_TAG = "PASSWD";

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            TestClientServerRMI.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            System.setSecurityManager(new RMISecurityManager());
            RemoteLoginClient rlc = new RemoteLoginClient();
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put(VERSION_TAG, "1.0");
            hm.put(USER_TAG, args[0]);
            hm.put(PASSWD_TAG, args[1]);
            if (!rlc.connect(hm, "openapi.zko.dec.com", 1099)) {
                String msg = rlc.getErrorMessage();
                System.out.println(msg);
                return;
            }
            Admin admin = rlc.getAdminInterface("VMSRULES");
            System.out.println("testclientserverrmi login done");
            byte[] ticket = rlc.getTicket();
            RemoteRuntime rt = rlc.findRemoteRuntime();
            if (rt == null) {
                String msg = rlc.getErrorMessage();
                System.out.println(msg);
                return;
            }
            for (int i = 0; i < 10; ++i) {
                int j;
                RemoteProcess rp = rt.exec("/efs$/isao/isao", false, InetAddress.getLocalHost().getHostAddress(), ticket);
                RemoteInputStream rst = rp.getInputStream();
                byte[] bd = new byte[10];
                RemoteData rd = rst.read(bd, 0, 10);
                while (rd.getReturn() > 0) {
                    byte[] bf = rd.getData();
                    for (j = 0; j < rd.getReturn(); ++j) {
                        System.out.print((char)bf[j]);
                    }
                    rd = rst.read(bd, 0, 10);
                }
                if (i % 10 == 0) {
                    System.out.println("Admin:Active Connections:" + admin.getActiveUserConnectionCount() + " Active User Processes:" + admin.getUserProcessCount());
                    System.out.println("Active Users Count:" + admin.getUserCount());
                    System.out.println("List of users");
                    String[] users = admin.getListOfUsers();
                    for (j = 0; j < users.length; ++j) {
                        System.out.println(users[j]);
                    }
                }
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            rlc.close();
            rlc.close();
            rlc = null;
        }
        catch (Exception e) {
            System.out.println("dist nb exception: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

