/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.execute.RemoteExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.settings.DistributedProjectSettings;
import org.netbeans.modules.distributed.util.RemoteBuildCookie;
import org.netbeans.modules.distributed.util.RemoteCookie;
import org.openide.ServiceType;
import org.openide.actions.AbstractCompileAction;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.enum.ArrayEnumeration;

public class RemoteBuildAction
extends NodeAction {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public String getName() {
        return "Remote Build";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/distributed/resources/rembuild.gif";
    }

    protected Class[] cookieClasses() {
        return new Class[]{RemoteCookie.class};
    }

    private static void refreshFS() {
        Enumeration fss = FileSystemCapability.COMPILE.fileSystems();
        FileSystem defaultFS = Repository.getDefault().getDefaultFileSystem();
        while (fss.hasMoreElements()) {
            FileSystem fs = (FileSystem)fss.nextElement();
            if (fs.isReadOnly() || fs == defaultFS || !(fs instanceof AbstractNetworkFileSystem)) continue;
            fs.refresh(false);
        }
    }

    protected void performAction(Node[] pactivatedNodes) {
        final Node[] activatedNodes = pactivatedNodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                DistributedModule.logger.info("Invoking remote build command ");
                RemoteBuildAction.refreshFS();
                RemoteBuildAction.this.build3GL(activatedNodes);
                DistributedModule.logger.info("Invoking remote build java command ");
                for (int i = 0; i < activatedNodes.length; ++i) {
                    if (activatedNodes[i].getCookie(class$org$netbeans$modules$distributed$util$RemoteCookie == null ? RemoteBuildAction.class$("org.netbeans.modules.distributed.util.RemoteCookie") : class$org$netbeans$modules$distributed$util$RemoteCookie) != null) continue;
                    DataObject dobj = (DataObject)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteBuildAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    RemoteExecutor ret = null;
                    Object obj = dobj.getPrimaryFile().getAttribute("remoteCompilerType");
                    if (obj == null) {
                        ret = (RemoteExecutor)DistributedProjectSettings.getDefault().getRemoteCompilerType();
                    } else {
                        ServiceType.Handle handle = (ServiceType.Handle)obj;
                        ret = (RemoteExecutor)handle.getServiceType();
                    }
                    if (ret == null) {
                        DistributedModule.err.notify((Throwable)new Exception("Remote Build Action Failed"));
                        return;
                    }
                    try {
                        ret.execute(dobj);
                        continue;
                    }
                    catch (IOException ioe) {
                        DistributedModule.err.notify((Throwable)ioe);
                    }
                }
                RemoteBuildAction.refreshFS();
            }
        });
    }

    public void actionPerformed(ActionEvent ev) {
        DistributedModule.logger.info("Invoking remote build command ");
        Object s = ev == null ? null : ev.getSource();
        Node[] nodes = null;
        if (s instanceof Node) {
            Node node = (Node)s;
            nodes = new Node[]{node};
        } else {
            nodes = s instanceof Node[] ? (Node[])s : super.getActivatedNodes();
        }
        final Node[] anodes = nodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteBuildAction.this.performAction(anodes);
            }
        });
    }

    private void build3GL(Node[] nodes) {
        DistributedModule.logger.info("Invoking remote build 3gl command ");
        HashSet<CompilerCookie> compile = new HashSet<CompilerCookie>();
        for (int i = 0; i < nodes.length; ++i) {
            CompilerCookie comp = (CompilerCookie)nodes[i].getCookie(class$org$netbeans$modules$distributed$util$RemoteBuildCookie == null ? RemoteBuildAction.class$("org.netbeans.modules.distributed.util.RemoteBuildCookie") : class$org$netbeans$modules$distributed$util$RemoteBuildCookie);
            if (comp == null) continue;
            compile.add(comp);
        }
        if (compile.size() == 0) {
            return;
        }
        this.compileNodes2(nodes);
    }

    static String findName(Node[] nodes) {
        String name = "";
        if (nodes.length > 0) {
            Node n = nodes[0];
            Node.Cookie ck = null;
            do {
                if ((ck = n.getCookie(class$org$openide$loaders$DataObject == null ? RemoteBuildAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null) continue;
                DataObject d = (DataObject)ck;
                name = d.isValid() ? d.getNodeDelegate().getDisplayName() : "";
                break;
            } while ((n = n.getParentNode()) != null);
        }
        return NbBundle.getMessage((Class)Compiler.class, (String)"FMT_Compile", (Object)new Integer(nodes.length), (Object)name);
    }

    protected boolean enable(Node[] node) {
        int nodeCnt = 0;
        if (node.length == 0) {
            return false;
        }
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteBuildAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dobj == null) {
                return false;
            }
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            try {
                if (!(dobj.getPrimaryFile().getFileSystem() instanceof FTPFileSystem) && !(dobj.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem)) {
                    return false;
                }
                if (dobj.getPrimaryFile().getFileSystem() instanceof RemoteFileSystem && !((RemoteFileSystem)dobj.getPrimaryFile().getFileSystem()).isConnected()) {
                    return false;
                }
            }
            catch (FileStateInvalidException e) {
                return false;
            }
            if (dobj.getCookie(class$org$netbeans$modules$distributed$util$RemoteBuildCookie == null ? RemoteBuildAction.class$("org.netbeans.modules.distributed.util.RemoteBuildCookie") : class$org$netbeans$modules$distributed$util$RemoteBuildCookie) != null) {
                ++nodeCnt;
            }
            if (!dobj.getPrimaryFile().getExt().toLowerCase().equals("java")) continue;
            ++nodeCnt;
        }
        return nodeCnt == node.length;
    }

    protected String message() {
        return NbBundle.getMessage((Class)Compiler.class, (String)"CTL_CompilationStarted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileNodes2(Node[] nodes) {
        CompilerJob job;
        StatusDisplayer.getDefault().setStatusText(this.message());
        try {
            job = new CompilerJob(Compiler.DEPTH_ONE);
            AbstractCompileAction.prepareJobFor((CompilerJob)job, (Enumeration)new ArrayEnumeration((Object[])nodes), (Class)RemoteBuildCookie.class, (Compiler.Depth)Compiler.DEPTH_ONE);
            DataObject[] objects = new DataObject[nodes.length];
            boolean useNodes = false;
            for (int i = 0; i < nodes.length; ++i) {
                objects[i] = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteBuildAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (objects[i] != null) continue;
                useNodes = true;
                break;
            }
        }
        finally {
            StatusDisplayer.getDefault().setStatusText("");
        }
        job.setDisplayName(RemoteBuildAction.findName(nodes));
        job.start();
    }

    protected boolean asynchronous() {
        return false;
    }
}

