/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.util;

import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;

public class Compatibility {
    private static final boolean CHAR_SEQUENCE_EXISTS = Compatibility.charSequenceExistsImpl();

    private static boolean charSequenceExistsImpl() {
        try {
            return Class.forName("java.lang.CharSequence") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean charSequenceExists() {
        return CHAR_SEQUENCE_EXISTS;
    }

    public static int getLength(Token token) {
        if (Compatibility.charSequenceExists()) {
            return token.getText().length();
        }
        return ((CharSeq)((Object)token)).charSeqLength();
    }

    public static char charAt(Token token, int n) {
        if (Compatibility.charSequenceExists()) {
            return token.getText().charAt(n);
        }
        return ((CharSeq)((Object)token)).charSeqCharAt(n);
    }

    public static String toString(Token token) {
        if (Compatibility.charSequenceExists()) {
            return ((Object)token.getText()).toString();
        }
        return ((CharSeq)((Object)token)).charSeqToString();
    }

    public static TextBuffer getReadText13(LexerInput lexerInput, int n, int n2, TextBuffer textBuffer) {
        if (textBuffer != null) {
            textBuffer.reset();
        } else {
            textBuffer = new TextBuffer();
        }
        if (n < 0) {
            throw new IllegalArgumentException("startIndex=" + n + " < 0");
        }
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException("endIndex=" + n2 + " < startIndex=" + n);
        }
        int n4 = lexerInput.getReadLength();
        int n5 = n4 - n;
        lexerInput.backup(n5);
        while (--n3 >= 0) {
            textBuffer.append((char)lexerInput.read());
        }
        lexerInput.backup(-n5 + (n2 - n));
        if (n4 != lexerInput.getReadLength()) {
            throw new IllegalStateException();
        }
        return textBuffer;
    }

    public static Object getCompatibleReadText(LexerInput lexerInput, int n, int n2, Object object) {
        if (Compatibility.charSequenceExists()) {
            return lexerInput.getReadText(n, n2);
        }
        return Compatibility.getReadText13(lexerInput, n, n2, (TextBuffer)object);
    }

    public static final class TextBuffer {
        private StringBuffer text = new StringBuffer();
        private int hash;

        public void reset() {
            this.text.setLength(0);
            this.hash = 0;
        }

        public void append(char c) {
            this.text.append(c);
            this.hash = 31 * this.hash + c;
        }

        public char charAt(int n) {
            return this.text.charAt(n);
        }

        public int length() {
            return this.text.length();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                int n = this.text.length();
                if (n == string.length()) {
                    while (n-- != 0) {
                        if (this.charAt(n) == string.charAt(n)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (object instanceof TextBuffer) {
                TextBuffer textBuffer = (TextBuffer)object;
                int n = this.text.length();
                if (n == textBuffer.length()) {
                    while (n-- != 0) {
                        if (this.charAt(n) == textBuffer.charAt(n)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public static interface CharSeq {
        public int charSeqLength();

        public char charSeqCharAt(int var1);

        public String charSeqToString();
    }
}

