/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.spi.lexer.AbstractLexerInterfaces;
import org.netbeans.spi.lexer.util.Compatibility;
import org.netbeans.spi.lexer.util.LexerUtilities;

public abstract class AbstractLexer
extends AbstractLexerInterfaces
implements Lexer,
AbstractLexerInterfaces.TokenData,
AbstractLexerInterfaces.OrdinaryTokenData,
AbstractLexerInterfaces.ExtendedTokenData {
    private static final int DEFAULT_STATUS = 0;
    private static final int IN_EXTENDED_TOKEN_STATUS = 1;
    private static final int LAST_TOKEN_EXCLUDED_FROM_EXTENDED_STATUS = 2;
    private static final int NO_MORE_TOKENS = 4;
    private int status = 4;
    private int tokenIntId;
    private int tokenLength;
    private int extendedTokenIntId;
    private int extendedTokenLength;
    private Object lastState;

    protected abstract boolean fetchToken(AbstractLexerInterfaces.TokenData var1);

    protected abstract void ordinaryToken(AbstractLexerInterfaces.OrdinaryTokenData var1);

    protected abstract void extendedToken(AbstractLexerInterfaces.ExtendedTokenData var1, boolean var2);

    protected abstract LexerInput getLexerInput();

    protected abstract Language getLanguage();

    public void restart(LexerInput lexerInput, Object object) {
        this.status = 0;
        this.tokenIntId = -1;
        this.tokenLength = -1;
    }

    protected Object getLexerState() {
        return null;
    }

    public final Object getState() {
        return this.status == 2 ? this.lastState : this.getLexerState();
    }

    protected Token createToken(int n, int n2) {
        return this.getLexerInput().createToken(this.getLanguage().getValidId(n), n2);
    }

    public final int getDefaultTokenLength() {
        return this.inExtendedToken() ? this.getLexerInput().getReadLength() - this.extendedTokenLength : this.getLexerInput().getReadLength();
    }

    public final int getTextLookahead() {
        LexerInput lexerInput = this.getLexerInput();
        int n = lexerInput.getReadLookahead();
        if (lexerInput.isEOFLookahead()) {
            --n;
        }
        if (this.inExtendedToken()) {
            n -= this.extendedTokenLength;
        }
        return n;
    }

    public final boolean inExtendedToken() {
        return this.status == 1;
    }

    /*
     * Unable to fully structure code
     */
    public Token nextToken() {
        if (this.status == 4) {
            return null;
        }
        do lbl-1000:
        // 3 sources

        {
            block13: {
                block14: {
                    if (this.status != 1) break block13;
                    this.lastState = this.getLexerState();
                    this.tokenLength = -1;
                    this.tokenIntId = -1;
                    var1_1 = this.fetchToken(this);
                    this.extendedToken(this, var1_1);
                    if (!var1_1) break block14;
                    if (this.tokenLength == -1) {
                        throw new IllegalStateException(" tokenLength not assigned for current token with extendedTokenIntId=" + this.extendedTokenIntId + " during fetchToken() or extendedToken();" + " tokenIntId=" + this.tokenIntId);
                    }
                    this.extendedTokenLength += this.tokenLength;
                    if (this.status == 1) ** GOTO lbl-1000
                    if (this.status == 2) {
                        if (this.tokenIntId == -1) {
                            throw new IllegalStateException("tokenIntId not assigned for current token with extendedTokenIntId=" + this.extendedTokenIntId + " during fetchToken() or extendedToken();" + " tokenLength=" + this.tokenLength);
                        }
                        this.extendedTokenLength -= this.tokenLength;
                    }
                    return this.createToken(this.extendedTokenIntId, this.extendedTokenLength);
                }
                if (this.status != 2) {
                    if (this.status == 1) {
                        throw new IllegalStateException("Extended token must be finished when there are no more fetched tokens.");
                    }
                    throw new IllegalStateException("ExtendedTokenData.finishExtendedToken(true) was called but there was no token fetched.");
                }
                this.status = 4;
                return this.createToken(this.extendedTokenIntId, this.extendedTokenLength);
            }
            if (this.status == 2) {
                this.status = 0;
                if (this.tokenIntId == -1) {
                    throw new IllegalStateException();
                }
                if (this.tokenLength == -1) {
                    throw new IllegalStateException();
                }
            } else {
                this.tokenLength = -1;
                this.tokenIntId = -1;
                if (!this.fetchToken(this)) {
                    this.status = 4;
                    return null;
                }
            }
            this.ordinaryToken(this);
            if (this.tokenIntId == -1) {
                throw new IllegalStateException("tokenIntId not assigned for current token during fetchToken() or ordinaryToken(); tokenLength=" + this.tokenLength);
            }
            if (this.tokenLength != -1) continue;
            throw new IllegalStateException(" tokenLength not assigned for current token during fetchToken() or ordinaryToken(); tokenIntId=" + this.tokenIntId);
        } while (this.status == 1);
        return this.createToken(this.tokenIntId, this.tokenLength);
    }

    public final int getTokenIntId() {
        return this.tokenIntId;
    }

    public void setTokenIntId(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("tokenIntId=" + n + " is < 0");
        }
        this.tokenIntId = n;
    }

    public final int getTokenLength() {
        return this.tokenLength;
    }

    public void setTokenLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("tokenLength=" + n + " is < 0");
        }
        this.tokenLength = n;
    }

    public final void startExtendedToken() {
        if (this.status == 1) {
            throw new IllegalStateException("Extended token mode already started.");
        }
        if (this.tokenIntId == -1) {
            throw new IllegalStateException("tokenIntId not assigned for current token during fetchToken() or ordinaryToken() prior to calling startExtendedToken(); tokenLength=" + this.tokenLength);
        }
        if (this.tokenLength == -1) {
            throw new IllegalStateException(" tokenLength not assigned for current token during fetchToken() or ordinaryToken() prior to calling startExtendedToken(); tokenIntId=" + this.tokenIntId);
        }
        this.extendedTokenIntId = this.tokenIntId;
        this.extendedTokenLength = this.tokenLength;
        this.status = 1;
    }

    public final int getExtendedTokenIntId() {
        return this.extendedTokenIntId;
    }

    public final int getExtendedTokenLength() {
        return this.extendedTokenLength;
    }

    public void updateExtendedTokenIntId(int n) {
        this.extendedTokenIntId = n;
    }

    public final void finishExtendedToken(boolean bl) {
        this.status = bl ? 0 : 2;
    }

    public String toString() {
        LexerInput lexerInput = this.getLexerInput();
        int n = lexerInput.getReadLookahead();
        String string = "";
        if (lexerInput.isEOFLookahead()) {
            --n;
            string = "-EOF";
        }
        return "inExtendedToken()=" + this.inExtendedToken() + ", readLength=" + lexerInput.getReadLength() + ", readChars=\"" + LexerUtilities.toSource(Compatibility.getCompatibleReadText(lexerInput, 0, lexerInput.getReadLength(), null).toString()) + "\", readLookahead=" + lexerInput.getReadLookahead() + ", lookaheadChars" + string + "=\"" + LexerUtilities.toSource(Compatibility.getCompatibleReadText(lexerInput, 0, n, null).toString()) + "\" + tokenIntId=" + this.getTokenIntId() + ", tokenLength=" + this.getTokenLength() + ", extendedTokenIntId=" + this.getExtendedTokenIntId() + ", extendedTokenLength=" + this.getExtendedTokenLength();
    }
}

