/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.editor.pascal;

import com.hp.openvms.netbeans.pascalsupport.editor.lang.PascalLanguage;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.IndentInfo;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.StringLexerInput;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenCategory;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;

public class PascalFormatSupport
extends ExtFormatSupport {
    private TokenContextPath tokenContextPath;
    private Language language;
    private LexerInput input;
    private Lexer lex;
    private boolean ansiformat = true;
    private int caserec = 0;
    private boolean iscomment = false;

    public PascalFormatSupport(FormatWriter formatWriter) {
        super(formatWriter);
    }

    private int getNumericId(String image) {
        PascalLanguage language = PascalLanguage.get();
        StringLexerInput input = new StringLexerInput(image);
        Lexer lex = ((Language)language).createLexer();
        lex.restart(input, null);
        Token tok = lex.nextToken();
        return tok.getId().getIntId();
    }

    private TokenId getLexerTokenId(TokenID tokenid) {
        PascalLanguage language = PascalLanguage.get();
        StringLexerInput input = new StringLexerInput(tokenid.getName());
        Lexer lex = ((Language)language).createLexer();
        lex.restart(input, null);
        Token tok = lex.nextToken();
        return tok.getId();
    }

    public int getCaserec() {
        return this.caserec;
    }

    public void setCaserec(int x) {
        this.caserec = x;
    }

    public void setIsComment(boolean x) {
        this.iscomment = x;
    }

    public boolean getIsComment() {
        return this.iscomment;
    }

    public boolean isSingleLineComment(TokenItem token) {
        return token != null && token.getImage().startsWith("!");
    }

    public int getCommentPosition() {
        return 1;
    }

    public int getFormattedIndentPosition() {
        return 0;
    }

    public int getTokenIndent(TokenItem token) {
        FormatTokenPosition tp = this.getPosition(token, 0);
        FormatTokenPosition fnw = this.findLineFirstNonWhitespace(tp);
        if (fnw != null) {
            TokenItem t = fnw.getToken();
            Object object = fnw = t == null && t.getImage().length() > 0 ? null : this.getPosition(t, 0);
            if (fnw != null) {
                tp = fnw;
            }
        }
        return this.getVisualColumnOffset(tp);
    }

    public boolean isPreviousLineBlank(FormatTokenPosition current) {
        FormatTokenPosition lstartnw = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        prev = this.findPreviousEOL(current);
        lstart = this.findLineStart(prev);
        lstartnw = this.getInitialPosition(lstart);
        return lstartnw == null;
    }

    public FormatTokenPosition GetPreviousLinePosition(FormatTokenPosition current) {
        FormatTokenPosition tempPos = current;
        FormatTokenPosition lstartnw = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        prev = this.findPreviousEOL(current);
        lstart = this.findLineStart(prev);
        lstartnw = this.getInitialPosition(lstart);
        return lstartnw;
    }

    public FormatTokenPosition GetMostRecentELSEorIFStatement(FormatTokenPosition current) {
        FormatTokenPosition temppos = current;
        Object temp = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        FormatTokenPosition lstartnw = null;
        boolean flag = true;
        while (temppos != null) {
            prev = this.findPreviousEOL(temppos);
            lstart = this.findLineStart(prev);
            lstartnw = this.getInitialPosition(lstart);
            if (lstartnw.getToken().getImage() == "if" || lstartnw.getToken().getImage() == "else") {
                return lstartnw;
            }
            temppos = prev;
        }
        return temppos;
    }

    public FormatTokenPosition GetMostRecentIFStatement(FormatTokenPosition current) {
        FormatTokenPosition temppos = current;
        Object temp = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        FormatTokenPosition lstartnw = null;
        boolean flag = true;
        while (temppos != null) {
            prev = this.findPreviousEOL(temppos);
            lstart = this.findLineStart(prev);
            lstartnw = this.getInitialPosition(lstart);
            if (lstartnw.getToken().getImage() == "if") {
                return lstartnw;
            }
            temppos = prev;
        }
        return temppos;
    }

    public FormatTokenPosition getPreviousTokenPosition(FormatTokenPosition current, int depth) {
        FormatTokenPosition tempPos = current;
        Object lstartnw = null;
        FormatTokenPosition prev = null;
        Object prev1 = null;
        Object lstart = null;
        for (int i = 0; i < depth; ++i) {
            while (this.isPreviousLineBlank(current)) {
                tempPos = this.findPreviousEOL(current);
                current = prev = this.getPreviousPosition(tempPos);
            }
            current = prev = this.GetPreviousLinePosition(current);
        }
        return current;
    }

    public boolean isStartingWithElse(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 26) {
                    return true;
                }
                if (tok.getId().getIntId() == 1) continue;
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean isStartingWithIf(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean ret = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 32) {
                    ret = true;
                    break;
                }
                if (tok.getId().getIntId() == 26) {
                    ret = false;
                    break;
                }
                if (tok.getId().getIntId() != 1) continue;
            }
            return ret;
        }
        return false;
    }

    public boolean isStartingWithExclaim(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean ret = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 2) {
                    ret = true;
                    break;
                }
                if (tok.getId().getIntId() == 1) continue;
                ret = false;
                break;
            }
            return ret;
        }
        return false;
    }

    public boolean isIfOnlyStatement(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isifonly = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 32) {
                    isifonly = true;
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() != 51) continue;
                        isifonly = true;
                        tok = lex.nextToken();
                        while (tok != null && tok.getId().getIntId() == 5 && tok.getId().getIntId() == 4) {
                            if (tok.getId().getIntId() != 1) {
                                if (tok.getId().getIntId() == 251) {
                                    isifonly = false;
                                    break;
                                }
                                isifonly = false;
                            }
                            tok = lex.nextToken();
                        }
                        return isifonly;
                    }
                    continue;
                }
                isifonly = false;
            }
            return isifonly;
        }
        return false;
    }

    public boolean isIfThenStatement(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isifthen = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 32) {
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() != 51) continue;
                        isifthen = true;
                        tok = lex.nextToken();
                        if (tok == null) {
                            isifthen = false;
                        }
                        return isifthen;
                    }
                    continue;
                }
                isifthen = false;
            }
            return isifthen;
        }
        return false;
    }

    public boolean isIfThenOnlyStatement(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isifthen = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 32) {
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() != 51) continue;
                        isifthen = true;
                        tok = lex.nextToken();
                        if (tok == null) {
                            isifthen = true;
                        }
                        return isifthen;
                    }
                    continue;
                }
                isifthen = false;
            }
            return isifthen;
        }
        return false;
    }

    public boolean isBegin(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isbegin = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 18) {
                    isbegin = true;
                    tok = lex.nextToken();
                    if (tok != null && tok.getId().getIntId() == 251) {
                        isbegin = true;
                    }
                    return isbegin;
                }
                isbegin = false;
            }
            return isbegin;
        }
        return false;
    }

    public boolean isEnd(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isend = false;
            Token tok = lex.nextToken();
            if (tok == null) {
                return isend;
            }
            if (tok.getId().getIntId() == 27) {
                isend = true;
                return isend;
            }
            tok = lex.nextToken();
            if (tok == null) {
                return isend;
            }
            if (tok.getId().getIntId() == 27) {
                isend = true;
                return isend;
            }
            isend = false;
            return isend;
        }
        return false;
    }

    public boolean isWhile(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean iswhile = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 58) {
                    iswhile = true;
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() == 24 || tok.getId().getIntId() == 18) {
                            iswhile = true;
                            continue;
                        }
                        iswhile = false;
                    }
                    continue;
                }
                iswhile = false;
            }
            return iswhile;
        }
        return false;
    }

    public boolean isWith(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean iswith = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 59) {
                    iswith = true;
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() == 24) {
                            iswith = true;
                            continue;
                        }
                        iswith = false;
                    }
                    continue;
                }
                iswith = false;
            }
            return iswith;
        }
        return false;
    }

    public boolean isForOnly(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isfor = false;
            int i = 0;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 29) {
                    ++i;
                    while ((tok = lex.nextToken()) != null) {
                        int x = tok.getId().getIntId();
                        if (x == 52 || x == 25) {
                            ++i;
                            continue;
                        }
                        if (tok.getId().getIntId() != 24 || ++i != 3) continue;
                        isfor = true;
                        tok = lex.nextToken();
                        while (tok != null) {
                            if (tok.getId().getIntId() == 251) {
                                isfor = false;
                            }
                            tok = lex.nextToken();
                        }
                        return isfor;
                    }
                    continue;
                }
                isfor = false;
            }
            return isfor;
        }
        return false;
    }

    public boolean isLineOpenOnly(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            int lp = 0;
            int rp = 0;
            Token tok = lex.nextToken();
            while (tok != null) {
                if (tok.getId().getIntId() == 246 || tok.getId().getIntId() == 247) {
                    ++lp;
                } else if (tok.getId().getIntId() == 248 || tok.getId().getIntId() == 249) {
                    ++rp;
                }
                tok = lex.nextToken();
            }
            return lp > rp;
        }
        return false;
    }

    public int getCountOpenParen(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            int lp = 0;
            int rp = 0;
            Token tok = lex.nextToken();
            while (tok != null) {
                if (tok.getId().getIntId() == 246 || tok.getId().getIntId() == 247) {
                    ++lp;
                } else if (tok.getId().getIntId() == 248 || tok.getId().getIntId() == 249) {
                    ++rp;
                }
                tok = lex.nextToken();
            }
            if (lp > rp) {
                return lp - rp;
            }
            return 0;
        }
        return 0;
    }

    public int getCountClosedParen(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            int lp = 0;
            int rp = 0;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 246 || tok.getId().getIntId() == 247) {
                    ++lp;
                    continue;
                }
                if (tok.getId().getIntId() != 248 && tok.getId().getIntId() != 249) continue;
                ++rp;
            }
            if (rp > lp) {
                return rp - lp;
            }
            return 0;
        }
        return 0;
    }

    public boolean isLineClosedOnly(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            int lp = 0;
            int rp = 0;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 246 || tok.getId().getIntId() == 247) {
                    ++lp;
                    continue;
                }
                if (tok.getId().getIntId() != 248 && tok.getId().getIntId() != 249) continue;
                ++rp;
            }
            return rp > lp;
        }
        return false;
    }

    public int getLineOpenPos(FormatTokenPosition pos) {
        FormatTokenPosition tmpPos = this.getInitialPosition(pos);
        int iPos = 0;
        if (tmpPos != null) {
            String tmpStr = tmpPos.getToken().getImage().trim();
            iPos = tmpStr.indexOf("(");
            if (iPos < 0) {
                iPos = tmpStr.indexOf("[");
            }
            iPos = iPos >= 0 ? iPos + 1 + this.getVisualColumnOffset(tmpPos) : this.getVisualColumnOffset(tmpPos);
        }
        return iPos;
    }

    public boolean isCase(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean iscase = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 20) {
                    iscase = true;
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() == 39) {
                            iscase = true;
                            continue;
                        }
                        iscase = false;
                    }
                    continue;
                }
                iscase = false;
            }
            return iscase;
        }
        return false;
    }

    public boolean isRepeat(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isrep = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 48) continue;
                isrep = true;
                return isrep;
            }
            return isrep;
        }
        return false;
    }

    public boolean isRecord(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 46) {
                    isrec = true;
                    tok = lex.nextToken();
                    if (tok == null) {
                        return isrec;
                    }
                    isrec = false;
                    return isrec;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isArray(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isarray = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 17) {
                    isarray = true;
                    while ((tok = lex.nextToken()) != null && tok.getId().getIntId() != 5) {
                        if (tok.getId().getIntId() == 39) {
                            isarray = true;
                            continue;
                        }
                        isarray = false;
                    }
                    continue;
                }
                isarray = false;
            }
            return isarray;
        }
        return false;
    }

    public boolean isFileOnly(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isfile = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 28) continue;
                isfile = true;
                tok = lex.nextToken();
                if (tok != null) {
                    tok = lex.nextToken();
                }
                if (tok.getId().getIntId() == 39) {
                    tok = lex.nextToken();
                    if (tok != null) {
                        isfile = false;
                    }
                    return isfile;
                }
                isfile = false;
                return isfile;
            }
            return isfile;
        }
        return false;
    }

    public boolean isSet(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isset = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 50) {
                    isset = true;
                    tok = lex.nextToken();
                    if (tok.getId().getIntId() == 39) {
                        return isset;
                    }
                    isset = false;
                    return isset;
                }
                isset = false;
            }
            return isset;
        }
        return false;
    }

    public boolean isUntil(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isuntil = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 54) {
                    isuntil = true;
                    return isuntil;
                }
                isuntil = false;
            }
            return isuntil;
        }
        return false;
    }

    public boolean isVar(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isvar = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 56) continue;
                isvar = true;
                break;
            }
            return isvar;
        }
        return false;
    }

    public boolean isType(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean istype = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 53) continue;
                istype = true;
                break;
            }
            return istype;
        }
        return false;
    }

    public boolean isProgram(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isprog = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 45) {
                    isprog = true;
                    return isprog;
                }
                isprog = false;
            }
            return isprog;
        }
        return false;
    }

    public boolean isProcedure(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isproc = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 44) {
                    isproc = true;
                    return isproc;
                }
                isproc = false;
            }
            return isproc;
        }
        return false;
    }

    public boolean isFunction(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isfunc = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 30) continue;
                isfunc = true;
                return isfunc;
            }
            return isfunc;
        }
        return false;
    }

    public boolean isLabel(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean islbl = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 34) {
                    islbl = true;
                    continue;
                }
                islbl = false;
            }
            return islbl;
        }
        return false;
    }

    public boolean isConst(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            boolean isconst = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 21) {
                    isconst = true;
                    continue;
                }
                isconst = false;
            }
            return isconst;
        }
        return false;
    }

    public boolean isBeginInSameLineAsEnd(FormatTokenPosition pos) {
        pos = this.getInitialPosition(pos);
        PascalLanguage language = PascalLanguage.get();
        StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
        Lexer lex = ((Language)language).createLexer();
        lex.restart(input, null);
        Token tok = lex.nextToken();
        boolean ret = false;
        while (tok != null) {
            if (tok.getId().getIntId() == 18) {
                Token tmp = lex.nextToken();
                while (tmp != null) {
                    if (tmp.getId().getIntId() == 27) {
                        ret = true;
                    }
                    tmp = lex.nextToken();
                }
                return ret;
            }
            if (tok.getId().getIntId() != 1) {
                ret = false;
            }
            tok = lex.nextToken();
        }
        return ret;
    }

    public boolean isRepeatInSameLineAsUntil(FormatTokenPosition pos) {
        pos = this.getInitialPosition(pos);
        PascalLanguage language = PascalLanguage.get();
        StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
        Lexer lex = ((Language)language).createLexer();
        lex.restart(input, null);
        Token tok = lex.nextToken();
        boolean ret = false;
        int r = 0;
        int u = 0;
        while (tok != null) {
            if (tok.getId().getIntId() == 48) {
                r = 1;
                Token tmp = lex.nextToken();
                while (tmp != null) {
                    if (tmp.getId().getIntId() == 54) {
                        ++u;
                    } else if (tmp.getId().getIntId() == 48) {
                        ++r;
                    }
                    tmp = lex.nextToken();
                }
                ret = r == u;
                return ret;
            }
            if (tok.getId().getIntId() != 1) {
                ret = false;
            }
            tok = lex.nextToken();
        }
        return ret;
    }

    public boolean isIfInSameLineAsElse(FormatTokenPosition pos) {
        pos = this.getInitialPosition(pos);
        PascalLanguage language = PascalLanguage.get();
        StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
        Lexer lex = ((Language)language).createLexer();
        lex.restart(input, null);
        Token tok = lex.nextToken();
        boolean ret = false;
        int i = 0;
        int e = 0;
        while (tok != null) {
            if (tok.getId().getIntId() == 32) {
                i = 1;
                Token tmp = lex.nextToken();
                while (tmp != null) {
                    if (tmp.getId().getIntId() == 26) {
                        ++e;
                    } else if (tmp.getId().getIntId() == 32) {
                        ++i;
                    } else if (tmp.getId().getIntId() == 18) {
                        e += 100;
                    }
                    tmp = lex.nextToken();
                }
                ret = i == e;
                return ret;
            }
            if (tok.getId().getIntId() != 1) {
                ret = false;
            }
            tok = lex.nextToken();
        }
        return ret;
    }

    public FormatTokenPosition getPreviousUnbalancedLine(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        FormatTokenPosition prev = this.getPreviousNonEmptyLine(pos);
        int i = 0;
        int j = 0;
        int k = 0;
        int rec = 0;
        while (prev != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            if (!this.isBeginInSameLineAsEnd(prev) && !this.isComment(prev)) {
                if (this.isEnd(prev)) {
                    ++i;
                } else if (this.isRecord(prev)) {
                    if (i > 0) {
                        --i;
                    } else if (rec > 0) {
                        --rec;
                    } else if (i == 0) {
                        return this.getNextNonEmptyLine(prev);
                    }
                } else if (this.isLineOpenOnly(prev)) {
                    if (k > 0) {
                        --k;
                    } else if (k == 0) {
                        return this.getNextNonEmptyLine(prev);
                    }
                } else if (this.isCase(prev)) {
                    if (k <= 0) {
                        if (k == 0 && i == 0) {
                            return this.getNextNonEmptyLine(prev);
                        }
                        if (k == 0 && i >= 1) {
                            --i;
                            ++rec;
                        }
                    }
                } else if (this.isBegin(prev)) {
                    if (i > 0) {
                        --i;
                    } else if (i == 0) {
                        return this.getNextNonEmptyLine(prev);
                    }
                } else {
                    if (this.isVar(prev) || this.isType(prev) || this.isProgram(prev) || this.isConst(prev)) {
                        return this.getNextNonEmptyLine(prev);
                    }
                    if ((this.isFunction(prev) || this.isProcedure(prev)) && !this.isEndingWithSemicolon(prev)) {
                        return this.getNextNonEmptyLine(prev);
                    }
                    if (this.isUntil(prev)) {
                        if (!this.isRepeatInSameLineAsUntil(prev)) {
                            ++j;
                        }
                    } else if (this.isRepeat(prev)) {
                        if (!this.isRepeatInSameLineAsUntil(prev)) {
                            if (j > 0) {
                                --j;
                            } else if (j == 0) {
                                return this.getNextNonEmptyLine(prev);
                            }
                        }
                    } else if (this.isLineClosedOnly(prev)) {
                        ++k;
                    }
                }
            }
            prev = this.getPreviousNonEmptyLine(prev);
        }
        return this.getPreviousNonEmptyLine(pos);
    }

    public int getIndentationInfo(FormatTokenPosition pos, IndentInfo idf) {
        int indent = 0;
        FormatTokenPosition firstNWS = this.findLineFirstNonWhitespace(pos);
        if (firstNWS != null) {
            Token tok;
            PascalLanguage language = PascalLanguage.get();
            StringLexerInput input = new StringLexerInput(firstNWS.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            block5: while ((tok = lex.nextToken()) != null) {
                switch (tok.getId().getIntId()) {
                    case 1: {
                        continue block5;
                    }
                    case 32: {
                        boolean onlyIf = true;
                        indent = this.getVisualColumnOffset(firstNWS);
                        idf.setIndent(indent);
                        idf.setType(31);
                        while ((tok = lex.nextToken()) != null) {
                            if (tok.getId().getIntId() != 51) continue;
                            indent = this.getVisualColumnOffset(firstNWS);
                            idf.setIndent(indent);
                            idf.setType(5);
                            onlyIf = false;
                        }
                        break block5;
                    }
                    case 26: {
                        indent = this.getVisualColumnOffset(firstNWS);
                        idf.setIndent(indent);
                        idf.setType(30);
                        break block5;
                    }
                    default: {
                        indent = this.getVisualColumnOffset(firstNWS);
                        idf.setIndent(indent);
                        idf.setType(3);
                        break block5;
                    }
                }
            }
        }
        return indent;
    }

    public boolean getFreeFormat() {
        return true;
    }

    public int getIndent(FormatTokenPosition pos) {
        if (pos != null) {
            return this.getVisualColumnOffset(pos);
        }
        return 0;
    }

    public FormatTokenPosition getInitialPosition(FormatTokenPosition pos) {
        if (pos == null) {
            return pos;
        }
        FormatTokenPosition firstNWS = this.findLineFirstNonWhitespace(pos);
        return firstNWS;
    }

    public boolean isPreviousLineEmpty(FormatTokenPosition pos) {
        FormatTokenPosition temp = this.getPreviousLine(pos);
        if (temp == null) {
            return false;
        }
        return this.findLineFirstNonWhitespace(temp) == null;
    }

    public boolean isPreviousLineComment(FormatTokenPosition pos) {
        FormatTokenPosition temp = this.getPreviousLine(pos);
        if (temp == null) {
            return false;
        }
        if ((temp = this.getInitialPosition(temp)) == null) {
            return false;
        }
        if (this.isComment(temp)) {
            this.iscomment = false;
            return true;
        }
        if (this.isCommentPresent(temp, "}", "*)")) {
            if (this.isCommentPresent(temp, "{", "(*")) {
                return false;
            }
            this.iscomment = true;
            return true;
        }
        return this.iscomment;
    }

    public boolean isNextLineEmpty(FormatTokenPosition pos) {
        FormatTokenPosition temp = this.getNextLine(pos);
        if (temp == null) {
            return false;
        }
        return this.findLineFirstNonWhitespace(temp) == null;
    }

    public boolean isNextLineComment(FormatTokenPosition pos) {
        FormatTokenPosition temp = this.getNextLine(pos);
        if (temp == null) {
            return false;
        }
        return this.isComment(temp);
    }

    public FormatTokenPosition getPreviousLine(FormatTokenPosition current) {
        FormatTokenPosition temp = this.findLineStart(current);
        if (temp == null) {
            return null;
        }
        FormatTokenPosition prev = this.getPreviousPosition(temp);
        if (prev == null) {
            return null;
        }
        return this.findLineStart(prev);
    }

    public FormatTokenPosition getPreviousNonEmptyLine(FormatTokenPosition current) {
        FormatTokenPosition temp = current;
        while (this.isPreviousLineEmpty(current) | this.isPreviousLineComment(current)) {
            current = this.getPreviousLine(current);
        }
        temp = this.getPreviousLine(current);
        if (temp != null && this.isWhite(temp)) {
            temp = this.getInitialPosition(temp);
        }
        return temp;
    }

    public FormatTokenPosition getNextLine(FormatTokenPosition current) {
        FormatTokenPosition temp = this.findLineEnd(current);
        FormatTokenPosition prev = this.getNextPosition(temp);
        if (prev == null) {
            return null;
        }
        return prev;
    }

    public FormatTokenPosition getNextNonEmptyLine(FormatTokenPosition current) {
        FormatTokenPosition temp = current;
        while (this.isNextLineEmpty(current) | this.isNextLineComment(current)) {
            current = this.getNextLine(current);
        }
        return this.getNextLine(current);
    }

    public boolean isWhite(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = true;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 1) continue;
                status = false;
                break;
            }
        }
        return status;
    }

    public boolean isELSEStatement(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null && tok.getId().getIntId() != 18) {
                if (tok.getId().getIntId() != 26) continue;
                status = true;
                tok = lex.nextToken();
                if (tok != null) continue;
                return false;
            }
        }
        return status;
    }

    public boolean isElseIfStatement(FormatTokenPosition pos) {
        if (this.isEndingWithSemicolon(pos)) {
            return false;
        }
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null && tok.getId().getIntId() != 18) {
                if (tok.getId().getIntId() != 26) continue;
                status = true;
                tok = lex.nextToken();
                status = tok == null ? false : tok.getId().getIntId() == 32;
                return status;
            }
        }
        return status;
    }

    public boolean isELSEOnlyStatement(FormatTokenPosition pos) {
        if (this.isEndingWithSemicolon(pos)) {
            return false;
        }
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 26) {
                    status = true;
                    tok = lex.nextToken();
                    if (tok == null) {
                        return status;
                    }
                    if (tok.getId().getIntId() == 1) {
                        tok = lex.nextToken();
                        if (tok.getId().getIntId() == 18) {
                            tok = lex.nextToken();
                            status = tok == null;
                            return status;
                        }
                        status = false;
                    } else if (tok.getId().getIntId() == 251) {
                        status = false;
                    }
                    return status;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isReservedWord(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            TokenCategory reserveCategory = language.getCategory("Reserved Words");
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            Token tok = lex.nextToken();
            status = reserveCategory.isMember(tok.getId());
        }
        return status;
    }

    public boolean isPascalWord(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            TokenCategory reserveCategory = language.getCategory("Pascal Words");
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            Token tok = lex.nextToken();
            status = reserveCategory.isMember(tok.getId());
        }
        return status;
    }

    public boolean isIFStatement(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 32) continue;
                status = true;
            }
        }
        return status;
    }

    public boolean isThenStatement(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 51) {
                    status = true;
                    continue;
                }
                if (tok.getId().getIntId() == 32) {
                    return false;
                }
                if (tok.getId().getIntId() != 251) continue;
                status = false;
            }
        }
        return status;
    }

    public boolean isEndingWithPeriod(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            String temp = pos.getToken().getImage();
            String trimmed = temp.trim();
            String sub = trimmed.trim().substring(trimmed.length() - 1);
            status = sub.equals(".");
        }
        return status;
    }

    public boolean isEndingWithSemicolon(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 251 || (tok = lex.nextToken()) != null) continue;
                return true;
            }
        }
        return status;
    }

    public boolean isEndingWithComma(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 252 || (tok = lex.nextToken()) != null) continue;
                return true;
            }
        }
        return status;
    }

    public boolean isComment(FormatTokenPosition pos) {
        PascalLanguage language = PascalLanguage.get();
        boolean status = false;
        if (pos != null) {
            TokenCategory commentCategory = language.getCategory("Comments");
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            Token tok = lex.nextToken();
            if (tok != null) {
                status = commentCategory.isMember(tok.getId());
            }
            if (status) {
                if (this.isCommentPresent(pos, "!")) {
                    return true;
                }
                this.iscomment = !this.isCommentPresent(pos, "}", "*)");
                return true;
            }
            if (this.isCommentPresent(pos, "}", "*)")) {
                if (this.iscomment) {
                    this.iscomment = false;
                    return true;
                }
                return this.iscomment;
            }
            return this.iscomment;
        }
        return status;
    }

    public String getCommentChar(FormatTokenPosition pos) {
        if (pos != null) {
            String temp = pos.getToken().getImage();
            if (temp.indexOf("{") != -1) {
                return "{";
            }
            if (temp.indexOf("(*") != -1) {
                return "(*";
            }
            if (temp.indexOf("!") != -1) {
                return "!";
            }
        }
        return null;
    }

    public boolean isCommentPresent(FormatTokenPosition pos, String commCh1, String commCh2) {
        if (pos == null) {
            return false;
        }
        if (pos.getToken() == null) {
            return false;
        }
        String temp = pos.getToken().getImage();
        if (temp == null) {
            return false;
        }
        return temp.indexOf(commCh1) != -1 || temp.indexOf(commCh2) != -1;
    }

    public boolean isCommentPresent(FormatTokenPosition pos, String commCh1) {
        String temp = pos.getToken().getImage();
        return temp.indexOf(commCh1) != -1;
    }
}

