 /*  A  * audio_dec.c from Hans Schwengeler's (schweng@astro.unibas.ch)  8  * modified by Mark Berryman to prevent buffer thrashing  */    #include <ssdef.h> #include <sys/types.h> #include <stdio.h> #include <fcntl.h> #include <stdlib.h>  #include <mme/mme_api.h> #include "mpg123.h"   9 /* Written by Oskar Enoksson (osken393@student.liu.se) */   ?     /* Max n.o. shared memory blocks to use at the same time */  #define MAX_BLOCKS 6 #define MAX_STRING 128   static HWAVEOUT dev = 0;  $ static LPPCMWAVEFORMAT oForm = NULL; static LPWAVEHDR wHdr = NULL; ! static LPWAVEOUTCAPS Caps = NULL; & static LPWAVEFORMATINFO info_p = NULL;* static LPACMFORMATDETAILS detail_p = NULL;  ' static const WAVEHDR WAVEHDRTemplate =  ! { NULL, 0, 0, 0, 0, 0, NULL, 0 };    static int buffersInUse = 0; static int nameDisplayed = 0;  static int bdbsInited = 0;   static struct _bdb {   void *address;   int busy;    int size;  } bdb[MAX_BLOCKS];    , static int check_for_mme_error(MMRESULT err) { *     if (err == MMSYSERR_NOERROR) return 0;       LPSTR error_text;   :     if (!(error_text = (LPSTR)mmeAllocMem(MAX_STRING +1)))2 	fprintf(stderr,"Can't allocate shared memory\n");     else 	{7 	    waveOutGetErrorText (err, error_text, MAX_STRING); .             fprintf(stderr,"%s\n",error_text); 	    mmeFreeMem(error_text);	         }   *     if ( mmeServerFileDescriptor() == -1 )+ 	 fprintf(stderr,"Server might be down\n");   
     return 1;  }    static void  wave_callback(HANDLE hWave,  	      UINT uMsg,  	      DWORD dwInstance, 	      LPARAM dwParam1,  	      LPARAM dwParam2)  {    WAVEHDR *wh;   void *ptr;   int i;     if(uMsg == WOM_DONE) {     wh = (WAVEHDR *)dwParam1;      ptr = wh->lpData; "     for (i=0; i<MAX_BLOCKS; i++) { 	if (ptr == bdb[i].address) {  	    bdb[i].busy = 0;  	    buffersInUse--; 	    break;  	}     }    }  }   , int audio_open(struct audio_info_struct *ai) {    int i;     if(!waveOutGetNumDevs()) {2     fprintf(stderr,"No audio devices present!\n");     return -1;   }        6   if(!oForm) oForm=mmeAllocMem(sizeof(PCMWAVEFORMAT));.   if(!wHdr) wHdr=mmeAllocMem(sizeof(WAVEHDR));2   if(!Caps) Caps=mmeAllocMem(sizeof(WAVEOUTCAPS));      if(!oForm || !wHdr || !Caps) {,     fprintf(stderr,"mmeAllocMem failed!\n");     return -1;   }   >   if (check_for_mme_error(waveOutGetDevCaps((UINT) ai->device,	 				Caps,  				sizeof(WAVEOUTCAPS))))     return -1;   else     if (!nameDisplayed) { ;       fprintf(stderr,"Using device %d: %s version %d.%d\n",  	    ai->device, 	    Caps->szPname, & 	    (int)(Caps->vDriverVersion&0xff),, 	    (int)((Caps->vDriverVersion>>8)&0xff));       nameDisplayed = 1;     }      if(ai->rate == -1)     return(0);     switch(ai->format) {   case AUDIO_FORMAT_SIGNED_16:     oForm->wBitsPerSample = 16; +     oForm->wf.wFormatTag = WAVE_FORMAT_PCM; 
     break;   case AUDIO_FORMAT_SIGNED_8:      oForm->wBitsPerSample = 8;+     oForm->wf.wFormatTag = WAVE_FORMAT_PCM; 
     break;   case AUDIO_FORMAT_ULAW_8:      oForm->wBitsPerSample = 8;-     oForm->wf.wFormatTag = WAVE_FORMAT_MULAW; 
   default:B     fprintf(stderr,"Unrecogniced sample format %d!\n",ai->format);     return -1;   }   %   oForm->wf.nChannels = ai->channels; &   oForm->wf.nSamplesPerSec = ai->rate;   oForm->wf.nAvgBytesPerSec = M     oForm->wf.nSamplesPerSec * oForm->wf.nChannels * oForm->wBitsPerSample/8; H   oForm->wf.nBlockAlign = oForm->wf.nChannels * oForm->wBitsPerSample/8;  8   if (check_for_mme_error(waveOutOpen((LPHWAVEOUT)&dev,  			    (UINT)ai->device, 			    &(oForm->wf), 			    wave_callback, 
 			    0, 3 			    (CALLBACK_FUNCTION | WAVE_OPEN_SHAREABLE))))      return -1;  ,   if(check_for_mme_error(waveOutReset(dev)))     return -1;     if(ai->gain>=0) { +     if(Caps->dwSupport & WAVECAPS_VOLUME) { <       check_for_mme_error(waveOutSetVolume((UINT)ai->device, 				   (DWORD)ai->gain));      } else {K       fprintf(stderr,"Volume change not supported by device (ignoring)\n");      }    }      if (!bdbsInited) {"     for (i=0; i<MAX_BLOCKS; i++) {       bdb[i].address = NULL;$       bdb[i].size = bdb[i].busy = 0;     }      bdbsInited = 1;    }      return 0;  }   8 int audio_reset_parameters(struct audio_info_struct *ai) { B   fprintf(stderr,"Unimplemented audio_reset_parameters called\n");   return 0;  }   7 int audio_rate_best_match(struct audio_info_struct *ai)  { A   fprintf(stderr,"Unimplemented audio_rate_best_match called\n");    return 0;  }   0 int audio_set_rate(struct audio_info_struct *ai) { :   fprintf(stderr,"Unimplemented audio_set_rate called\n");   return 0;  }   4 int audio_set_channels(struct audio_info_struct *ai) { >   fprintf(stderr,"Unimplemented audio_set_channels called\n");   return 0;  }   2 int audio_set_format(struct audio_info_struct *ai) { <   fprintf(stderr,"Unimplemented audio_set_format called\n");   return 0;  }   3 int audio_get_formats(struct audio_info_struct *ai)  { F /* The device capability structure does not indicate all the supportedI  * formats so we query for each format as the main program checks for it.   */      int ret=0;  E /* Allocate the necessary data structures if this hasn't been yet. */      if (!detail_p) {/     info_p=mmeAllocMem(sizeof(WAVEFORMATINFO)); 3     detail_p=mmeAllocMem(sizeof(ACMFORMATDETAILS));      if(!info_p || !detail_p) {.       fprintf(stderr,"mmeAllocMem failed!\n");       return 0;      } .     info_p->cbStruct = sizeof(WAVEFORMATINFO);2     detail_p->cbStruct = sizeof(ACMFORMATDETAILS);   }    if (!detail_p->pwfx) {L     if(check_for_mme_error(waveOutGetFormatInfo((UINT) ai->device, info_p)))       return 0; D     if(!(detail_p->pwfx=mmeAllocMem(info_p->dwMaxWaveformatexSize)))       return 0; 4     detail_p->cbwfx = info_p->dwMaxWaveformatexSize;   }   I /* Now fill in the details provided by the main program and check for all I  * wave formats known to be supported by any audio card supported by VMS.   */      detail_p->pwfx->cbSize = 0; &   detail_p->pwfx->nAvgBytesPerSec = 0;"   detail_p->pwfx->nBlockAlign = 0;+   detail_p->pwfx->nChannels = ai->channels; ,   detail_p->pwfx->nSamplesPerSec = ai->rate;  &   detail_p->pwfx->wBitsPerSample = 16;/   detail_p->pwfx->wFormatTag = WAVE_FORMAT_PCM; <   if(MMSYSERR_NOERROR == waveOutFormatDetails(dev, detail_p, 				ACM_FORMATDETAILSF_FORMAT)) "     ret |= AUDIO_FORMAT_SIGNED_16;  %   detail_p->pwfx->wBitsPerSample = 8; /   detail_p->pwfx->wFormatTag = WAVE_FORMAT_PCM; <   if(MMSYSERR_NOERROR == waveOutFormatDetails(dev, detail_p, 				ACM_FORMATDETAILSF_FORMAT)) !     ret |= AUDIO_FORMAT_SIGNED_8;   %   detail_p->pwfx->wBitsPerSample = 8; 1   detail_p->pwfx->wFormatTag = WAVE_FORMAT_MULAW; <   if(MMSYSERR_NOERROR == waveOutFormatDetails(dev, detail_p, 				ACM_FORMATDETAILSF_FORMAT))      ret |= AUDIO_FORMAT_ULAW_8;   
   return ret;  }   O int audio_play_samples(struct audio_info_struct *ai,unsigned char *buf,int len)  {    void *b = NULL;    int i = 0;     /*9     ///////////////////////////////////////////////////// .     //  Make sure at least one buffer is free 9     /////////////////////////////////////////////////////    */%   while(buffersInUse >= MAX_BLOCKS) {      mmeWaitForCallbacks();     mmeProcessCallbacks();   }      /*:     //////////////////////////////////////////////////////4     // Find a free buffer (and resize, if necessary):     //////////////////////////////////////////////////////   */    for (i=0; i<MAX_BLOCKS; i++) {     if (!bdb[i].busy) {        if (bdb[i].size < len) {3 	if (bdb[i].address) mmeFreeBuffer(bdb[i].address); & 	bdb[i].address = mmeAllocBuffer(len);* 	bdb[i].size = (bdb[i].address ? len : 0);       } :       b = bdb[i].address; bdb[i].busy = 1; buffersInUse++;       break;     }    }    if (!b) { :     fprintf(stderr,"Shared memory allocation failure!\n");     return (-1);   }    /*<     ////////////////////////////////////////////////////////E     // Here we can call any modification output functions we want.... =     /////////////////////////////////////////////////////////    */   memcpy(b,buf,len);            /*=     /////////////////////////////////////////////////////////      // Write the header.=     /////////////////////////////////////////////////////////    */     *wHdr=WAVEHDRTemplate;   wHdr->lpData = b;    wHdr->dwBufferLength = len;    wHdr->dwFlags = 0;  C   if(check_for_mme_error(waveOutWrite(dev, wHdr, sizeof(WAVEHDR))))      return (-1);     return(len); }   - int audio_close(struct audio_info_struct *ai)  {    int i;     if(dev) {      while(buffersInUse>0) {        mmeWaitForCallbacks();       mmeProcessCallbacks();     }   B     check_for_mme_error(waveOutReset(dev));	/* reset the device */B     check_for_mme_error(waveOutClose(dev));	/* close the device */
     dev=0;   }           mmeFreeMem(Caps); Caps=NULL;   mmeFreeMem(wHdr); wHdr=NULL;    mmeFreeMem(oForm); oForm=NULL;"   mmeFreeMem(info_p); info_p=NULL;*   if(detail_p) mmeFreeMem(detail_p->pwfx);&   mmeFreeMem(detail_p); detail_p=NULL;      for (i=0; i<MAX_BLOCKS; i++) {"     mmeFreeBuffer(bdb[i].address);     bdb[i].address = NULL;     bdb[i].busy = 0;     bdb[i].size = 0;   }    buffersInUse = 0;    return(0); } 