// Class definition for scriptlink object.  A program only ever has 1 instance
// of the scriptlink object - the global scriptlink ScriptLink.  This global 
// object handles the low-level I/O between the current program (a script) and
// the DECnet communication channel with the initiating HTTP server process.
//
// Member functions:
//	int read(void *buffer, int bufsize, int &read);
//	    Read message from network link into caller's buffer.
//
//	int write(void *buffer, int bufsize[, int frag ]);
//	    Write message to network link, fragmenting into frag-sized blocks
//	    if frag is non-zero.
//
//	int query ( char *tag, void *buffer, int bufsize, int &read );
//	    Write tag to network link and read response.
//
//	int set_rundown ( char *tag );
//	    Specifies the string to send to network link immediately prior
//	    to closing the link.
//
//	operator << [int|char *]
//	    Buffered output, data is converted to text form and added
//	    to buffer.  Buffer is flushed automatically prior to any
//	    reads or link rundown.
//
//	flush
//	    expli
//
#include <rms.h>		// RMS symbolic definitions.

class scriptlink {
  public:
    scriptlink();		// constructor function
    ~scriptlink();		// destructor
    int set_rundown ( char *tag );

    int read(void *buffer, int bufsize, int &read);
    int write(const void *buffer, int bufsize, int frag=0 );
    int query ( const char *tag, void *buffer, int bufsize, int &read );
    int flush ( );
    int set_mode ( int mode );		// binary or text

    scriptlink &operator<<(const char *);	// formatted output
    scriptlink &operator<<(const int);
private:
    char *rundown_tag;			// Final string to send to net link
    int status;
    int bin_mode;			// If non-zero, do binary prinfs
    int buf_used;
    struct FAB fab;			// RMS file access block
    struct RAB rab;			// RMS record access block (rec stream)
    char buffer[8192];			// output buffer
};

extern scriptlink ScriptLink;
char *net_unescape_string ( char *string, int *length );
