/*
 * Define routines to allow programs to run as specialized script servers 
 * that communicate with partner MST loaded on web server via mailbox
 * messages.
 *
 * All functions return a VMS-style condition code as their return value.
 */
#include <descrip.h>
typedef int *INTEGER;
typedef struct dsc$descriptor_s *STRING;
/*
 * Initialize function creates a mailbox that the web server writes
 * service requests to.  The service request is a single message that
 * contains:
 *    Mailbox unit to recieve additional content (if needed).
 *    Mailbox unit to write CGI response to.
 *    prologue strings.
 *    CGI variables.
 *    First segment of content (as much as will fit in remainder of 8K message
 *       limit).
 */
int hpss_initialize ( STRING mbx_logical,	
	INTEGER mbx_type,		/* 0-group table, 1-system table */
	INTEGER context );		/* return value */
/*
 * The accept function waits up to timeout seconds for the next message
 * to arrive and initialize the connext for calls to read/write/getenv/etc.
 * A timeout of zero means no timeout.
 * The disconnect function runs down the current request and prepares the
 * context for the next accept call.
 */
int hpss_accept ( INTEGER context,
	INTEGER timeout,		/* timeout in seconds */
	INTEGER PID,			/* process ID of web server */
	STRING function );		/* script server invocation method */
int hpss_disconnect ( INTEGER context );
/*
 * The getenv function returns the value of a standard CGI variable
 * that was included in the initialze CGI message.
 */
int hpss_getenv ( INTEGER context,
	STRING name,			/* CGI variable name (no WWW_ prefix)*/
	STRING value,
	INTEGER ret_length );
/*
 * The getform function references a table of name/value pairs, which it
 * initializes when needed by reading and decoding the request content.
 */
int hpss_getform ( INTEGER context,
    STRING name,
    STRING value,
    INTEGER ret_length );
/*
 * The read function reads the raw request content.  This function is mutually
 * exclusive with the getform function.
 */
int hpss_read ( INTEGER context,
    STRING buffer,			/* receives content. */
    INTEGER ret_length );		/* number of bytes returned */
/*
 * The write function sends CGI response data to the server.  For
 * efficiency the data is bufferred until a disconnect or explicit flush flag
 * is set.  The data path to the web server is treated as a byte stream,
 * you must set flag bit 0 if you want a record delimiter inserted.
 *
 * Flag bits:
 *    0  	If set, append CRLF to end of data.
 *    1		If set flush buffer after appending current data.
 */
int hpss_write ( INTEGER context,
    STRING buffer,
    INTEGER flags );
/*
 * Dump function formats and write context to stderr.  Flag bits:
 *    0 - show raw message read from service mailbox.
 *    1 - show raw request content.
 *    2 - show CGI symbol table generated from message data.
 *    3 - show form symbol table produced by parse of content.
 */
int hpss_dump ( INTEGER context, INTEGER flags );
/*
 * Define prototypes for wrapper functions that make it more convenient to
 * call the HPSS functions from C.  String descriptors are replaced by
 * by either char * or char *, int.  INTEGER args that are readonly are
 * changed to int.
 */
int hpss_initialize_c ( char *mbx_logical, int mbx_type, INTEGER context );
int hpss_accept_c ( INTEGER context, int timeout, INTEGER PID,
	char *function, int func_size );
int hpss_getenv_c ( INTEGER context, char *name, char *value, int val_size,
	INTEGER ret_length );
int hpss_getform_c ( INTEGER context, char *name, char *value, int val_size,
	INTEGER ret_length );
int hpss_read_c ( INTEGER context, void *buffer, int bufsize, INTEGER ret_len);
int hpss_write_c ( INTEGER context, void *buffer, int bufsize, int flags );

int hpss_printf_c ( INTEGER context, const char *fmt, ... );
/*
 * Special functions for use by a dynamic pool manager, a SS$_BADPARAM status
 * will be returned if the hpps context is not the pool master (/POOL=MASTER).
 * 
 * reset_pool_lock clears the counters in the lock value block and returns
 * the previous setting for waits and accepts (automatically incremented
 * by the worker process's hpss_accept calls).  A worker increments short_waits
 * if the time it waited for a new connection is less than or equal to
 * the short_wait_threshold value in milliseconds.  The manager uses this
 * routine to determine the rate at which the workers are servicing requests
 * and if the HPSS client is being slowed by lack of available workers.
 *
 * Reduce_pool_workers signals the next count number of workers that call
 * hpss_accept to rundown themselve.  The pool manager uses this function
 * to winnow out extra workers created in response to a temporary increase
 * in demand.
 */
int hpss_reset_pool_lock ( INTEGER context, 
	INTEGER short_wait_threshold, INTEGER short_waits, INTEGER accepts );
int hpss_reduce_pool_workers ( INTEGER context, INTEGER count );
