/*
 * This module provides support to determining OS-specific information,
 * such as whether the threads library is kernel level or user level.
 *
 * Date:	17-APR-1997
 */
#ifdef VMS
#include "pthread_1c_np.h"
#include <syidef.h>
#include <jpidef.h>
int LIB$GETJPI(), LIB$GETSYI();
#endif

int os_kernel_threads ()			/* Return 1 if kernel threads 0- user */
{
    int syi_code, syi_value, jpi_code, jpi_value;
    int status, i, kernel_threads;

#ifdef VMS
    kernel_threads = 0;			/* default return value. */
#if !defined(PTHREAD_USE_D4) && defined(__ALPHA)
    /*
     * POSIX threads.  Alpha's only.
     * Determine whether OS and process flags are set for kernel threads.
     */
    syi_code = SYI$_MULTITHREAD;
    status = LIB$GETSYI ( &syi_code, &syi_value, 0, 0, 0 );
    if ( ((status&1)==1) && (syi_value > 0) ) {
	/* 
         * OS support for kernel threads enabled, see if process has it 
	 */
	jpi_code = JPI$_MULTITHREAD;
	jpi_value = 0;
	status = LIB$GETJPI ( &jpi_code, 0, 0, &jpi_value, 0, 0 );
	if ( ((status&1)==1) && (jpi_value > 0) ) kernel_threads = 1;
    }
#endif

#else /* VMS */
    kernel_threads = 1;			/* Digital unix (mach threads) */
#endif
    return kernel_threads;
}
