/*
 * Define prototypes for the mini_server interface.
 */
struct mini_server_parameters 
{
    int port_number;			/* TCP port number */
    int client_limit;
    int client_thread_stacksize;
    int request_time_limit;		/* seconds */
    int response_time_limit;		/* seconds */
    int log_level;
    int (*logger) ( int, char *, ... );
};
/*
 * Format for headers.
 */
typedef struct { int l; char *s; } mini_string;
struct mini_request {
    int local_port;
    void *tcp_ctx;
    int remote_port;
    unsigned char *remote_address;
    char *method;
    char *path;
    char *protocol;
    mini_string *header;	/* terminated by zero-length string */
    mini_string header_overrun;	/* Initial content following header */
};

int mini_server_start ( 
	struct mini_server_parameters *param,
	int (*request_handler) ( struct mini_request * ),
	pthread_t *listen_thread );

int mini_parse_url 
	( char *url, 			/* locator to parse */
	char *info,			/* Scratch area for result pts*/
	char **service,			/* Protocol (e.g. http) indicator */
	char **node,			/* Node name. */
	char **ident,			/* File specification. */
	char **arg );			/* Search argument */
	
char *mini_url_suffix ( char *ident );

int mini_parse_elements (
	int limit, 		    /* Max number of element to delimit */
	char *line,		    /* input line to parse */
	mini_string *elem );	    /* Output array. */

int mini_add_response ( tu_text rsp, char *text, int standard );

int mini_send_response_header ( void *ctx, tu_text rsp );
