$ save_verify = 'f$verify(0)'
$!
$! This procedure links the HTTP_SERVER.EXE from the object files.
$!
$! Parameters:
$!	P1		Keyword for TCP package to use: 
$!				UCXTCP, CMUTCP, TWGTCP, MULTINET, TCPWARE
$!	P2		Option additional link flags (e.g. /TRACE).
$!	P3		Alternate program name instead of http_server,
$!			assumes 'p1'.opt exists.
$!
$! Author:	David Jones
$! Date:	29-JUL-1994
$! Revised:	30-NOV-1994
$! Revised:	16-JUL-1997	Add P3 parameter.
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! First validate P1.
$ say = "WRITE SYS$OUTPUT"
$ P1 = f$edit(P1,"UPCASE")
$ P1_ARG = F$ELEMENT(1,"=",P1)
$ if P1_ARG .EQS. "=" then P1_ARG = ""
$ P1 = F$ELEMENT(0,"=",P1)
$ tcp_list = "/UCXTCP/CMUTCP/TWGTCP/MULTINET/TCPWARE/SHARE/BSDTCP/SSL/"
$ if f$locate("/''P1'/",TCP_LIST) .GE. f$length(tcp_list)
$ then
$    say "Invalid P1 (tcp type), valid values: ",-
	"UCXTCP MULTINET CMUTCP TWGTCP TCPWARE BSDTCP SHARE"
$    save_verify = 'f$verify(save_verify)'
$    exit
$ endif
$ program = "http_server"
$ if p3 .nes. "" then program = p3
$ create TMP_LINK.OPT
$ open/append lopt TMP_LINK.OPT
$ on error then goto cleanup
$ on control_y then goto cleanup
$!
$! Determine our configuration.
$!
$ is_axp = (f$getsyi("CPU") .ge. 128)
$ is_vaxc = (.not.is_axp .and. (f$trnlnm("DECC$CC_DEFAULT") .nes. "/DECC"))
$ is_gcc = (F$EDIT(f$trnlnm("DECC$CC_DEFAULT"),"UPCASE") .eqs "/GCC")
$ is_vmsv5 = ("V5." .eqs. f$extract(0,3,f$getsyi("VERSION")))
$ write lopt "!This file generated by LINK_SERVER.COM, AXP flag: ", is_axp, -
	", VAXC flag: ", is_vaxc, ", TCP: ", P1
$!
$! Add Pthreads libraries.
$  kt_enable = ""			! Assume no kernel threads
$ if f$search("sys$share:pthread$rtl.exe") .eqs. ""
$ then
$!   Classic DECthreads (draft 4).
$   write lopt "sys$share:cma$lib_shr/share,cma$rtl/share
$   if is_axp then write lopt "sys$share:cma$open_lib_shr/share,cma$open_rtl/share
$ else
$!   POSIX-based DECthreads (VMS V7).  Link with flag to enable upcalls, but
$!   only if multithreading upcalls turned on.
$    if is_axp 
$    then
$	if f$getsyi("MULTITHREAD") .gt. 0 then -
		kt_enable = "/THREADS_ENABLE=(UPCALLS,MULTIPLE)"
$    endif
$ endif
$!
$! Add any speical lines needed for TCP package.(None needed for UCX or CMU)
$!
$ if P1 .eqs. "SHARE" then write lopt "sys$disk:[]tserver_tcpshr/share"
$ if P1 .eqs. "SHARE" then write lopt "symbol=TSERVER_TCP_PORT_LIST,0"
$ if P1 .nes. "SHARE" then write lopt "symbol=TS_TCP_PORT_LIST,0"
$ if P1 .eqs. "SSL" then write lopt "sys$disk:[]tserver_ssl.obj"
$ if P1 .nes. "SHARE" .and. P1 .nes. "SSL" then -
	write lopt "sys$disk:[]tserver_tcp.obj"
$ if P1 .eqs. "MULTINET" then write lopt -
"multinet_root:[multinet]multinet_socket_library/share"
$ if P1 .eqs. "TWGTCP" then write lopt "twg$tcp:[netdist.lib]twglib/lib"
$ if P1 .eqs. "TCPWARE" then write lopt "tcpip_socklib/share"
$!
$! Add special stuff for VAXC
$!
$ if is_gcc then write lopt "gnu_cc:[000000]gcclib/lib"
$ if is_vaxc then write lopt "sys$share:vaxcrtl/share"
$ if is_vaxc then write lopt "PSECT_ATTR=$CHAR_STRING_CONSTANTS,NOWRT"
$ if is_vaxc then write lopt "PSECT_ATTR=HTTP_REENTRANT_C_RTL,SHR"
$ if is_vaxc then write lopt "PSECT_ATTR=HTTP_REENTRANT_VMS_RTL,SHR"
$!
$ if P1 .eqs. "SSL" 
$ then
$     ! append options file, but omit lines with message_service or tlogger.
$     if p1_arg .eqs. "" then p1_arg = "tserver_ssl"
$     open/read ssllopt 'f$parse(p1_arg,".OPT")'
$ ssl_opt_append:
$     read ssllopt line/end=ssl_opt_append_done
$     if f$locate("MESSAGE_SERVICE",f$edit(line,"UPCASE")) .ge. f$length(line) -
	.or f$locate("TLOGGER",f$edit(line,"UPCASE")) .ge. f$length(line) then -
$	write lopt line
$     goto ssl_opt_append
$ ssl_opt_append_done:
$     close ssllopt
$ endif
$ close lopt
$ on error then exit $status
$ if P1 .eqs. "SSL" then append/log ssl_libraries.opt tmp_link.opt
$ purge tmp_link.opt
$!
$ link/map='program'.map 'kt_enable' 'P2' 'program'.OPT/OPT,TMP_LINK.OPT/OPT 'P4'
$ save_verify = f$verify(save_verify)
$ exit $status
$!
$ cleanup:
$ final_status = $status
$ close lopt
$ if f$trnlnm("ssllopt") .nes. "" then close ssllopt
$ save_verify = f$verify(save_verify)
$ exit 'final_status'
