/*
 * Define structure of global section for sharing web server's interval 
 * counter blocks (ICBs) with monitoring processes.
 */
struct pool_def {
    int pid;				/* Web server that updates section */
    int image_count;			/* owner processe's image act. count */
    int icb_count;			/* size of icb array */
    int icb_size;			/* Size of icb element */
    int cur_icb;			/* Index of current icb */
    int update_interval;		/* units of seconds */
    struct interval_counter icb[1];	/* variable size */
};
static struct icb_lock_block {
    int status;
    int id;				/* lock ID */
    /*
     * Lock value block.
     */
    int pid;				/* owning web server process */
    int first_valid;			/* index 0...n or -1 for none */
    int last_valid;
    int sequence;
};
/*
 * Define contstants related to mapping the global section.
 * section size must be an integral number of pages.  Version becomes
 * global section ident, bits 24..31 is major ID, 0..23 minor ID.
 */
#define ICB_POOL_SECTION_SIZE 0x010000
#define ICB_POOL_VERSION 0x01000001
#define ICB_POOL_NAME_FMT "WWW_INTERVAL_COUNTER_%x_%d"
