/*
 * Define global structure for setting alternate pages for reporting
 * certain error conditions.  Null pointer indicates default action.
 */
typedef struct {		/* error page definition */
    int type;			/* translation result (ident_map translation) */
    char *ident;		/* page name */
    char *munged_ident;		/* translation */
    char *response_code;	/* HTTP error code (e.g. "404"), "*" or "" */
} http_ep_def;
union {
  http_ep_def def[10];		/* By index number */
  struct {
    http_ep_def protfail;	/* File protected against access. */
    http_ep_def openfail;	/* file_access open failure */
    http_ep_def rulefail;	/* Translation failures. */
    http_ep_def cgiprotocol;	/* Script returned invalid response */
  } def1;
} http_epage;
/*
 * Define macro for compatibility with previous definition of structure.
 */
#define http_error_page http_epage.def1
/*
 * Define prototypes for errorpage-related functions.
 */
int http_define_error_page ( char *name, char *ident, char *opt );
int http_translate_error_pages(void);	/* none */
int http_error_page_ident ( http_ep_def *, char *, char *, int );
int http_process_error ( session_ctx, http_ep_def *, char *, char *, 
	char *, int, char *, string * );
