!
!  MMS description file for builing DECThreads HTTP SERVER
!
!  The default TCP package is UCX.  To change it, invoke mms as
!     $ MMS/MACRO=TCP=xxxx		(UCXTCP,MULTINET,TWGTCP,CMUIP)
!
!  To build a server with traceback information (for debugging), invoke mms as
!     $ MMS/FORCE/MACRO=TRACEBACK=1
!
!  To build a server using a shareable image for the TCP-code, invoke mms as
!     $ MMS/MACRO=(SHARE_TCP=xxxx)	(UCXTCP,MULTINET,...)
!
!  To build a server using  a hard-linked SSL shim, invoke mms as
!     $ MMS/MACRO=(SSL=yyyy)		(SSL_SERVER_DNET,SSL_SERVER_MST)
!
!  To build SSL shareable image shim, invoke mms as
!     $ MMS/MACRO=(SSL=yyyy) TSERVER_SSL.EXE  (SSL_SERVER_DNET,SSL_SERVER_MST)
!
!  To build a server with debugging enabled, invoke mms as 
!     $ MMS/MACRO=DEBUG=1
!
.IFDEF SHARE_TCP
TCP = $(SHARE_TCP)
TCPLINK = SHARE
TCPMODULE = tserver_tcpshr.exe
SSLMODULE = ssl_server_null
.ELSE
.IFDEF SSL
TCPMODULE = tserver_ssl.opt
SSLMODULE = $(SSL)
TCPLINK = SSL=$(SSL)
.ELSE
TCPMODULE = tserver_tcp.obj
SSLMODULE = ssl_server_null
.IFDEF TCP
TCPLINK = $(TCP)
.ELSE
TCPLINK = UCXTCP
.ENDIF
.ENDIF
.ENDIF

.IFDEF DATE_FORMAT
DFMT = /DEFINE=($(DATE_FORMAT))
DFMTMST = /DEFINE=($(DATE_FORMAT),DYNAMIC_MST)
.ELSE
! format 850 versus 1123 refers to RFC numbers
DFMT = /DEFINE=(DATE_FORMAT_1123)
DFMTMST = /DEFINE=(DATE_FORMAT_1123,DYNAMIC_MST)
.ENDIF
!
.IFDEF TCP
TCPOPT = /DEFINE=$(TCP)
.ELSE
TCP = UCXTCP
TCPOPT = /DEFINE=(UCX=1,UCXTCP=1)
.ENDIF
!
.IFDEF TRACEBACK
S_LINKFLAGS = /TRACEBACK/EXEC=$(MM$TARGET_NAME).EXE $(S_SSLLIB)
.ELSE
S_LINKFLAGS = /NOTRACEBACK/EXEC=$(MMS$TARGET_NAME).EXE $(S_SSLLIB)
.ENDIF
LINKFLAGS = /EXEC=$(MMS$TARGET_NAME).EXE

.IFDEF DEBUG
CFLAGS    = $(CFLAGS)/DEBUG/NOOPT
S_LINKFLAGS = $(S_LINKFLAGS)/DEBUG
.ENDIF

.FIRST
  @ if f$environment("DEPTH") .gt. 0 then sv_vfy = f$verify(1)
  EXEDIR = "[-.system]"
  IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
       	THEN prefix_all = "/prefix=all"

.LAST
  @ if f$environment("DEPTH") .gt. 0 then sv_vfy = f$verify(sv_vfy)

ssl_objs = bss_mst.obj ssl_threaded.obj ssl_server_mst.obj ssl_server_null.obj ssl_engine.obj
ssl_cflags = $(CFLAGS)/standard=ANSI89/prefix=all/include=sslinc/define=(VMS,flat_inc)/warn=(disable=(ptrmismatch,dollarid,longlongtype))

CORE_IMAGES : http_server3.exe,http_base_mst.exe,ext_authenticator.exe,privrequest.exe,\
		http_dirserv.exe,mbxnet_acp.exe,mbxnet_server.exe\
		omnimap_mst.exe,dirserv_mst.exe,preproc_mst.exe,\
		testcgi_mst.exe
        @ write sys$output "Base images built"
!	@ curdef = f$environment("DEFAULT")
!       @ set default [-.serverdoc]
!	@ set noverify
!	@ if f$search("indexdemo.idx") .eqs. "" then @indexdemo_sel_idx.com
!       @if f$file("indexdemo.idx","ORG") .nes. "IDX" then @indexdemo_sel_idx.com
!       @ set default 'curdef'

HTTP_SERVER3.EXE : $(TCPMODULE), decnet_access.obj,script_execute.obj,\
	script_cgiexecute.obj,http_session.obj,http_server3.obj,\
	http_base_mst.exe,script_manage.obj,ident_map.obj,user_info.obj,\
	send_document3.obj,link_base_mst.com,errorpage.obj,\
	http_header.obj,suffix_map.obj,multihome.obj,os_info.obj,\
	presentation_map.obj,tlogger.obj,rule_file.obj,client_limit.obj,\
	protect4.obj,HTTP_SERVER3.OPT,authcom2.obj,authcache.obj,\
	link_server.com,decnet_searchlist.obj,manage_request.obj,\
	load_dynamic.obj,peek.obj,interval_counters.obj,\
	mapimage_mst.obj,counters.obj,cgifork_mst.obj,hpss_mst.obj
    @link_server.com $(TCPLINK) "$(S_LINKFLAGS)" http_server3
    COPY http_server3.exe 'EXEDIR'http_server

tserver_ssl.opt : tserver_ssl.obj,$(SSLMODULE).obj,$(SSLMODULE).opt
    copy $(SSLMODULE).opt tserver_ssl.opt
!
! base_mst shareble image provides common functions used by all MST shareable
! images.  Placing in separate image avoids duplicating internal globals.
!
http_base_mst.exe : base_mst.opt,file_access.obj,fast_utc.obj,\
	message_service.obj,mst_share.obj,tutil.obj,tmemory.obj,\
	file_cache.obj,data_cache.obj,mst_parse_form.obj,link_base_mst.com
    @link_base_mst.com
!
! Rename MST shareables to HTTP_'image' when copying files to www_system to
! reduce name collisions on installed images.
MAPIMAGE_MST.EXE : mapimage_mst_d.obj,http_base_mst.exe
    @link_mst.com mapimage_mst,mapimage_init -
	mapimage_mst_d "/share=mapimage_mst.exe"
    COPY mapimage_mst.exe 'EXEDIR'http_mapimage_mst.exe

OMNIMAP_MST.EXE : omnimap_mst.obj,http_base_mst.exe
    @link_mst.com omnimap omnimap_mst
    COPY omnimap_mst.exe 'EXEDIR'http_omnimap_mst.exe

HPSS_MST.EXE : hpss_mst.obj,http_base_mst.exe
    @link_mst.com hpss hpss_mst
    COPY hpss_mst.exe 'EXEDIR'http_hpss_mst.exe

TESTCGI_MST.EXE : testcgi_mst.obj,http_base_mst.exe
    @link_mst.com testcgi testcgi_mst.obj
    COPY testcgi_mst.exe 'EXEDIR'http_testcgi_mst.exe

PREPROC_MST.EXE : preproc_mst.obj,access_db.obj,http_base_mst.exe
    @link_mst preproc preproc_mst,access_db.obj
    COPY preproc_mst.exe 'EXEDIR'http_preproc_mst.exe

FASTCGI_MST.EXE : fastcgi_mst.obj,fastcgi_mux.obj,tclient_tcp.obj,\
	os_info.obj,http_base_mst.exe
    @link_mst fastcgi fastcgi_mst,fastcgi_mux,tclient_tcp,os_info
    COPY fastcgi_mst.exe 'EXEDIR'http_fastcgi_mst.exe

TSERVER_TCPSHR.EXE : tserver_tcp.obj,tutil.obj
    @link_tcpshare.com $(TCP) $(S_LINKFLAGS)

PRIVREQUEST.EXE : privrequest.obj,link_prequest.com
    @link_prequest.com $(TCP)
    COPY privrequest.exe 'EXEDIR'

SAMPLE_AUTHENTICATOR.EXE : sample_authenticator.obj, authlib.obj
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG CC_LIBS CC_LIBS_AXP
    LINK $(LINKFLAGS) SAMPLE_AUTHENTICATOR.OBJ,AUTHLIB.OBJ,CC_LIBS/OPT
    COPY sample_authenticator.exe 'EXEDIR'

CEL_AUTHENTICATOR.EXE : cel_authenticator.obj, authlib.obj,
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG CC_LIBS CC_LIBS_AXP
    LINK $(S_LINKFLAGS) CEL_AUTHENTICATOR.OBJ,AUTHLIB.OBJ,CC_LIBS/OPT
    COPY cel_authenticator.exe 'EXEDIR'

MD5_AUTHENTICATOR.EXE : md5_authenticator.obj,authlib.obj,authacl.obj,\
    md5_dgst.obj,file_access.obj,file_cache.obj,data_cache.obj,fast_utc.obj,\
    tutil.obj,md5_authenticator.opt
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG CC_LIBS CC_LIBS_AXP
    LINK $(S_LINKFLAGS) MD5_AUTHENTICATOR.OPT/OPTION,CC_LIBS/OPT
    COPY md5_authenticator.exe 'EXEDIR'

EXT_AUTHENTICATOR.EXE : ext_authenticator.obj,authlib.obj,authacl.obj,\
	authutil.obj,md5_dgst.obj,file_access.obj,file_cache.obj,\
	data_cache.obj,fast_utc.obj,tutil.obj,ext_authenticator.opt
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG CC_LIBS CC_LIBS_AXP
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG PTHREAD_LIBS PTHREAD_LIBS_AXP
    tlib = ",PTHREAD_LIBS/OPT"
    if f$search("SYS$SHARE:PTHREAD$RTL.EXE") .nes. "" then tlib = ""
    LINK $(S_LINKFLAGS) EXT_AUTHENTICATOR.OPT/option,CC_LIBS/OPT'tlib'
    COPY ext_authenticator.exe 'EXEDIR'

TARGATE.EXE : targate.obj,tlogger.obj,rule_file_ss.obj,tutil.obj,tarscan.obj,\
	client_limit.obj,suffix_map.obj,presentation_map.obj,file_access.obj,\
	tserver_decnet.obj,decnet_access.obj,decnet_searchlist.obj,fast_utc.obj,\
	ident_map.obj,user_info.obj,load_dynamic.obj,targate.opt,counters.obj,\
	message_service.obj,cgifork_mst.obj,mapimage_mst.obj
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG PTHREAD_LIBS PTHREAD_LIBS_AXP
    tlib = ",PTHREAD_LIBS/OPT"
    if f$search("SYS$SHARE:PTHREAD$RTL.EXE") .nes. "" then tlib = ""
    LINK $(S_LINKFLAGS) targate.opt/opt/map=targate.map'tlib'
    COPY targate.exe 'EXEDIR'

dirserv_mst.exe : dirserv_mst.obj,dirserv_rules_d.obj,http_base_mst.exe
    @link_mst.com dirserv dirserv_mst.obj,dirserv_rules_d.obj
    COPY dirserv_mst.exe 'EXEDIR'http_dirserv_mst.exe

http_dirserv.exe : http_dirserv.obj,tlogger.obj,tutil.obj,client_limit.obj,\
	message_service.obj,dirserv_rules.obj,file_access.obj,fast_utc.obj,\
	tserver_decnet.obj,http_dirserv.opt
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG PTHREAD_LIBS PTHREAD_LIBS_AXP
    LINK $(S_LINKFLAGS) http_dirserv/opt,PTHREAD_LIBS/opt
    COPY http_dirserv.exe 'EXEDIR'

session.h : access.h,tutil.h
    SET FILE session.h/ext=0

authcom.obj : authcom.c,authcom.h,pthread_1c_np.h,ctype_np.h,access.h,tutil.h,\
	tserver_tcp.h
    CC $(CFLAGS) authcom.c

authcom2.obj : authcom2.c,authcom.h,pthread_1c_np.h,ctype_np.h,access.h,\
	tutil.h,authcache.h,tserver_tcp.h
    CC $(CFLAGS) authcom2.c

authcache.obj : authcache.c,authcache.h,tutil.h
    CC $(CFLAGS) authcache.c

client_limit.obj : client_limit.c,message_service.h
    CC $(CFLAGS) client_limit.c

decnet_access.obj : decnet_access.c,decnet_access.h,tutil.h,pthread_1c_np.h,mbxnet.h
    CC $(CFLAGS) decnet_access.c

script_execute.obj : script_execute.c,decnet_searchlist.h,decnet_access.h,\
	pthread_1c_np.h,session.h,tserver_tcp.h,message_service.h,\
	script_manage.h,tmemory.h,errorpage.h
    CC $(CFLAGS) script_execute.c

script_cgiexecute.obj : script_cgiexecute.c,session.h,tserver_tcp.h
    CC $(CFLAGS) script_cgiexecute.c

script_manage.obj : script_manage.c,script_manage.h,pthread_1c_np.h,tutil.h,\
	tserver_tcp.h
    CC $(CFLAGS) script_manage.c

decnet_searchlist.obj : decnet_searchlist.c,decnet_searchlist.h,tutil.h,\
	pthread_1c_np.h,decnet_access.h
    CC $(CFLAGS) decnet_searchlist.c

counters.obj : counters.c,counters.h,pthread_1c_np.h
    CC $(CFLAGS) counters.c

interval_counters.obj : counters.c,counters.h,pthread_1c_np.h,icb_pool.h
    CC $(CFLAGS) interval_counters.c

document_cache.obj : document_cache.c,tutil.h,pthread_1c_np.h
    CC $(CFLAGS) document_cache.c

fast_utc.obj : fast_utc.c,fast_utc.h,pthread_1c_np.h
    CC $(CFLAGS) fast_utc.c

file_access.obj : file_access.c,file_access.h,pthread_1c_np.h,fast_utc.h
    CC $(CFLAGS) $(DFMT) file_access.c 'prefix_all'

file_access_d.obj : file_access.c,file_access.h,pthread_1c_np.h,mst_share.h,fast_utc.h
    CC $(CFLAGS) $(DFMTMST) file_access.c 'prefix_all'/object=file_access_d.obj

http_session.obj : http_session.c,session.h,tserver_tcp.h,counters.h,\
	access.h,multihome.h,http_header.h,file_access.h,errorpage.h
    CC $(CFLAGS) http_session.c

http_header.obj : http_header.c,http_header.h,session.h,tutil.h,ctype_np.h
    CC $(CFLAGS) http_header.c

http_server.obj : http_server.c,tutil.h,pthread_1c_np.h,decnet_searchlist.h,\
	tserver_tcp.h,counters.h,script_manage.h,http_header.h,multihome.h,\
	file_access.h,access.h
    CC $(CFLAGS) http_server.c

http_server3.obj : http_server3.c,tutil.h,pthread_1c_np.h,decnet_searchlist.h,\
	tserver_tcp.h,counters.h,script_manage.h,http_header.h,multihome.h,\
	file_access.h,access.h,file_cache.h,data_cache.h
    CC $(CFLAGS) http_server3.c

ident_map.obj : ident_map.c,ident_map.h,tutil.h access.h
    CC $(CFLAGS) ident_map.c

load_dynamic.obj : load_dynamic.c,ident_map.h,access.h,file_access.h,pthread_1c_np.h
    CC $(CFLAGS) load_dynamic.c

user_info.obj : user_info.c,tutil.h,pthread_1c_np.h
    CC $(CFLAGS) user_info.c

send_document.obj : send_document.c,file_access.h,session.h,tserver_tcp.h,\
	http_header.h,ctype_np.h
    CC $(CFLAGS) send_document.c

send_document3.obj : send_document3.c,file_access.h,session.h,tserver_tcp.h,\
	http_header.h,ctype_np.h,file_cache.h,errorpage.h
    CC $(CFLAGS) send_document3.c

file_cache.obj : file_cache.c,file_cache.h,data_cache.h,file_access.h,\
	pthread_1c_np.h,fast_utc.h,fast_utc.h
    CC $(CFLAGS) file_cache.c

data_cache.obj : data_cache.c,data_cache.h,tutil.h,pthread_1c_np.h
    CC $(CFLAGS) data_cache.c

suffix_map.obj : suffix_map.c,tutil.h,ctype_np.h
    CC $(CFLAGS) suffix_map.c

presentation_map.obj : presentation_map.c,tutil.h
    CC $(CFLAGS) presentation_map.c

rule_file.obj : rule_file.c,ident_map.h,access.h,tutil.h,decnet_searchlist.h,\
	tserver_tcp.h,message_service.h,counters.h,script_manage.h,multihome.h,\
	errorpage.h,session.h,file_cache.h,ctype_np.h,file_access.h,authcache.h
    CC $(CFLAGS) rule_file.c

multihome.obj : multihome.c,multihome.h,access.h
    CC $(CFLAGS) multihome.c

rule_file_ss.obj : rule_file.c,ident_map.h,access.h,tutil.h,decnet_searchlist.h,\
	tserver_tcp.h,message_service.h,ctype_np.h
    CC $(CFLAGS)/object=rule_file_ss.obj rule_file.c/define=SCRIPTSERVER

tlogger.obj : tlogger.c,pthread_1c_np.h
    CC $(CFLAGS) tlogger.c 'prefix_all'

cgifork_mst.obj : cgifork_mst.c,message_service.h,tutil.h,file_access.h,\
	pthread_1c_np.h
    CC $(CFLAGS) cgifork_mst.c 'prefix_all'

testcgi_mst.obj : testcgi_mst.c,mst_share.h,tutil.h
    CC $(CFLAGS) testcgi_mst.c

mapimage_mst.obj : mapimage_mst.c,message_service.h,tutil.h,file_access.h
    CC $(CFLAGS) mapimage_mst.c 'prefix_all'

omnimap_mst.obj : omnimap_mst.c,mst_share.h,message_service.h,tutil.h,\
	file_access.h
    CC $(CFLAGS) omnimap_mst.c

hpss_mst.obj : hpss_mst.c,mst_share.h,message_service.h,tutil.h,\
	pthread_1c_np.h,hpss_msg.h
    CC $(CFLAGS) hpss_mst.c

mapimage_mst_d.obj : mapimage_mst.c,message_service.h,tutil.h,file_access.h,\
	mst_share.h
    CC $(CFLAGS) mapimage_mst.c /define=DYNAMIC_MST/object=mapimage_mst_d.obj

mst_share.obj : mst_share.c,mst_share.h,tutil.h
    CC $(CFLAGS) mst_share.c

mst_parse_form.obj : mst_parse_form.c,mst_share.h,tutil.h,mst_parse_form.h,\
	tmemory.h
    CC $(CFLAGS) mst_parse_form.c

message_service.obj : message_service.c,message_service.h,tutil.h,pthread_1c_np.h
    CC $(CFLAGS) message_service.c

targate.obj : targate.c,pthread_np.h,tutil.h,file_access.h,tarscan.h,\
	decnet_searchlist.h
    CC $(CFLAGS) targate.c

dirserv_mst.obj : dirserv_mst.c,mst_share.h,pthread_1c_np.h,tutil.h,\
	file_access.h,dirserv_options.h
    CC $(CFLAGS) dirserv_mst.c 'prefix_all'/define=(ODS5_FIXUP)

http_dirserv.obj : http_dirserv.c,pthread_1c_np.h,tutil.h,tserver_decnet.h,\
	file_access.h,decnet_searchlist.h,dirserv_options.h
    CC $(CFLAGS) http_dirserv.c 'prefix_all'

dirserv_rules.obj : dirserv_rules.c,pthread_1c_np.h,tutil.h,file_access.h,\
	tserver_decnet.h,dirserv_options.h
    CC $(CFLAGS) dirserv_rules.c

dirserv_rules_d.obj : dirserv_rules.c,pthread_1c_np.h,tutil.h,file_access.h,\
	tserver_decnet.h,dirserv_options.h,ctype_np.h,mst_share.h
    CC $(CFLAGS)/object=dirserv_rules_d.obj dirserv_rules.c/define=(DYNAMIC_MST)

tarscan.obj : tarscan.c,tarscan.h,tutil.h
    CC $(CFLAGS) tarscan.c 'prefix_all'

tserver_decnet.obj : tserver_decnet.c,pthread_1c_np.h,tutil.h
   IF F$GETSYI("CPU") .ge. 128 then inc_lib = "sys$share:sys$lib_c/library+sys$disk:[]"
    CC $(CFLAGS)/define=(SINGLE_SHOT_TIMEOUT=0) 'inc_lib'tserver_decnet.c

tserver_tcp.obj : tserver_tcp.c,pthread_1c_np.h,tutil.h,tserver_tcp.h
    IF "$(TCP)" .EQS. "TCPWARE" then prefix_exc = ",except=gethostbyaddr"
    IF ("$(TCP)" .eqs. "BSDTCP" .OR. "$(TCP)" .eqs."TCPWARE") .and. -
	(F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. -
	"/DECC") THEN prefix_all2 = "/prefix=(all''prefix_exc)"
    CC $(CFLAGS) $(TCPOPT) tserver_tcp.c 'prefix_all2'

tutil.obj : tutil.c,tutil.h,ctype_np.h
    CC $(CFLAGS) tutil.c

peek.obj : peek.c
    CC $(CFLAGS) peek.c

os_info.obj : os_info.c pthread_1c_np.h
    CC $(CFLAGS) os_info.c

protect3.obj : protect3.c,file_access.h,session.h,tserver_tcp.h,file_cache.h,\
		data_cache.h
    CC $(CFLAGS) protect3.c                                   

protect4.obj : protect4.c,file_access.h,session.h,tserver_tcp.h,file_cache.h,\
		data_cache.h
    CC $(CFLAGS) protect4.c                                   

sample_authenticator.obj : sample_authenticator.c,authlib.h
    CC $(CFLAGS) sample_authenticator.c

cel_authenticator.obj : cel_authenticator.c,authlib.h,ctype_np.h
    CC $(CFLAGS) cel_authenticator.c

md5_authenticator.obj : md5_authenticator.c,authlib.h,authacl.h,md5.h,ctype_np.h
    scan_intr_flag = ""
    si_ver = "V6.1"
    if f$getsyi("CPU") .ge. 128 then si_ver = "V6.2"
    if f$getsyi("VERSION") .ges. si_ver then scan_intr_flag="/DEFINE=HAS_SCAN_INTRUSION"
    if f$getsyi("CPU") .lt. 128 .and. f$trnlnm("DECC$CC_DEFAULT") .nes. -
		"/DECC" then scan_intr_flag = ""
    CC $(CFLAGS) md5_authenticator.c 'scan_intr_flag'

ext_authenticator.obj : ext_authenticator.c,authlib.h,authacl.h,md5.h,\
	authutil.h,ctype_np.h
    CC $(CFLAGS) ext_authenticator.c

md5_dgst.obj : md5_dgst.c,md5_locl.h,md5.h
    if f$getsyi("CPU") .lt. 128 then optimize_flag = "/optimize=nodisjoint"
    CC $(CFLAGS) md5_dgst.c 'optimize_flag'

authlib.obj : authlib.c,authlib.h,authcom.h,ctype_np.h
    CC $(CFLAGS) authlib.c

authacl.obj : authacl.c,authacl.h
    CC $(CFLAGS) authacl.c

authutil.obj : authutil.c,authutil.h,authlib.h
    scan_intr_flag = ""
    si_ver = "V6.1"
    if f$getsyi("CPU") .ge. 128 then si_ver = "V6.2"
    if f$getsyi("VERSION") .ges. si_ver then scan_intr_flag="/DEFINE=HAS_SCAN_INTRUSION"
    if f$getsyi("CPU") .lt. 128 .and. f$trnlnm("DECC$CC_DEFAULT") .nes. -
		"/DECC" then scan_intr_flag = ""
    CC $(CFLAGS) authutil.c 'scan_intr_flag'

manage_request.obj : manage_request.c,tutil.h,tserver_tcp.h,counters.h,\
	script_manage.h,file_cache.h,data_cache.h
    CC $(CFLAGS) manage_request.c

privrequest.obj : privrequest.c
    CC $(CFLAGS) privrequest.c 'prefix_all'

mbxnet_acp.obj : mbxnet_acp.c,mbxnet.h
    CC $(CFLAGS) mbxnet_acp.c

mbxnet_server.obj : mbxnet_server.c,mbxnet.h
    CC $(CFLAGS) mbxnet_server.c

mbxnet_acp.exe : mbxnet_acp.obj
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG CC_LIBS CC_LIBS_AXP
    LINK $(LINKFLAGS) MBXNET_ACP.OBJ,CC_LIBS/OPT
    COPY mbxnet_acp.exe 'EXEDIR'

mbxnet_server.exe : mbxnet_server.obj
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG CC_LIBS CC_LIBS_AXP
    LINK $(LINKFLAGS) MBXNET_SERVER.OBJ,CC_LIBS/OPT
    COPY mbxnet_server.exe 'EXEDIR'


preproc_mst.obj : preproc_mst.c,tutil.h,tmemory.h,mst_share.h,access_db.h,\
	pthread_1c_np.h,file_cache.h,[-.script_code]html_preproc.c
    CC $(CFLAGS) preproc_mst.c 'prefix_all'

access_db.obj : access_db.c,access_db.h,pthread_1c_np.h
    CC $(CFLAGS) access_db.c

tmemory.obj : tmemory.c,tmemory.h,pthread_1c_np.h
    CC $(CFLAGS) tmemory.c

errorpage.obj : errorpage.c,errorpage.h,session.h,ident_map.h
    CC $(CFLAGS) errorpage.c

fastcgi_mst.obj : fastcgi_mst.c,fastcgi_mux.h,mst_share.h,tutil.h,pthread_1c_np.h
    CC $(CFLAGS) fastcgi_mst.c

fastcgi_mux.obj : fastcgi_mux.c,fastcgi_mux.h,tutil.h,pthread_1c_np.h,\
	tclient_tcp.h
    CC $(CFLAGS) fastcgi_mux.c

tclient_tcp.obj : tclient_tcp.c,tclient_tcp.h,pthread_1c_np.h,tutil.h
    CC $(CFLAGS) tclient_tcp.c

user_script.exe : user_script.obj,tutil.obj,tlogger.obj,tserver_decnet.obj,\
	decnet_access.obj
    IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
	THEN DEFINE/NOLOG PTHREAD_LIBS PTHREAD_LIBS_AXP
    LINK $(S_LINKFLAGS) user_script.obj,tutil,tlogger,tserver_decnet,decnet_access,PTHREAD_LIBS/opt
!
! SSL-related stuff
!
bss_mst.obj : bss_mst.c,message_service.h,pthread_1c_np.h,sslinc:buffer.h
    CC $(ssl_cflags) bss_mst.c

cert_map_manager.obj : cert_map_manager.c,cert_map.h
    CC $(CFLAGS)/include=sslinc cert_map_manager.c

ssl_threaded.obj : ssl_threaded.c,message_service.h,client_cert.h,\
	sslinc:buffer.h,sslinc:e_os.h,sslinc:x509.h,sslinc:ssl.h,sslinc:err.h
    CC $(ssl_cflags) ssl_threaded.c

ssl_engine.obj : ssl_engine.c,pthread_1c_np.h,tutil.h,tserver_decnet.h,\
	ssl_server.h,decnet_access.h
   CC $(CFLAGS) ssl_engine.c

ssl_engine.exe : ssl_engine.obj,ssl_engine.opt,ssl_threaded.obj,bss_mst.obj,\
	ssl_libraries.opt
   link ssl_engine.opt/option,ssl_libraries.opt/option

ssl_server_dnet.obj : ssl_server_dnet.c,pthread_1c_np.h,tutil.h,decnet_access.h
   CC $(CFLAGS) ssl_server_dnet.c

ssl_server_null.obj : ssl_server_dnet.c,pthread_1c_np.h,tutil.h
   CC $(CFLAGS) ssl_server_null.c

ssl_server_mst.obj : ssl_server_mst.c,pthread_1c_np.h,tutil.h,message_service.h
   CC $(CFLAGS) ssl_server_mst.c

ssl_server_mst-hl.obj : ssl_server_mst.c,pthread_1c_np.h,tutil.h,message_service.h
   CC $(CFLAGS) ssl_server_mst.c

tserver_ssl.obj : tserver_ssl.c,pthread_1c_np.h,tutil.h,client_cert.h
   CC $(CFLAGS) tserver_ssl.c

client_cert.obj : client_cert.c,pthread_1c_np.h,tutil.h,client_cert.h,cert_map.h
   CC $(CFLAGS) client_cert.c

cert_map.obj : cert_map.c,cert_map.h,tutil.h,pthread_1c_np.h
   CC $(CFLAGS) cert_map.c

tserver_ssl.exe : ssl_threaded.obj,bss_mst.obj,message_service.obj,tutil.obj,\
	decnet_access.obj,tserver_ssl.obj,client_cert.obj,cert_map.obj,\
	tlogger.obj,$(SSLMODULE).obj,$(SSLMODULE).opt
    @link_tcpshare.com SSL "" $(SSLMODULE).opt/option,ssl_libraries.opt/option/map=sys$disk:[]tserver_ssl
    rename tserver_tcpshr.exe tserver_ssl.exe

tserver_ssl2.exe : descrip.mms,$(SSLMODULE).obj,$(SSLMODULE).opt,tlogger.obj,\
        message_service.obj,tserver_ssl.obj
    @link_tcpshare.com SSL "" $(SSLMODULE).opt/option/map=sys$disk:[]tserver_ssl.map
    rename tserver_tcpshr.exe tserver_ssl2.exe

cert_map_manager.exe : cert_map_manager.obj cert_map.obj cert_map_manager.opt
    link cert_map_manager.opt/option
