/* Prototypes for cert_map functions, which manage a database that maps
 * X509 certificates distinguished names (subject names) to VMS identifiers.
 */
#define certmap_logical_dbname "CERTIFICATE_RIGHTS_MAP"
/*
 * File-level functions, caller recieves an opaque pointer as a handle to
 * the open database.
 */
int certmap_create ( const char *fname, const char *defname, char errmsg[256] );
int certmap_open ( const char *fname, const char *defname, 
	const char *mode, void **db, char errmsg[256] );
int certmap_close ( void *db );
/*
 * Define record format for the map database.
 */
#define CERTMAP_VAR_SIZE 1004
struct certmap_db_var		/* variable length portion of db_rec */
{
    short name_len;		/* Length of subject name from certificate */
    short serial_len;		/* Length of serial number, big-endian */
				/* If length 0, serial number unknown */
    unsigned char s[CERTMAP_VAR_SIZE];	
				/* s[0..name_len-1]: subject name */
				/* s[0..serial_len]: serial_number */
};
struct certmap_db_rec
{
    long rec_num;		/* primary key */
    long rec_hash;		/* Sec. key, hash of var.s[0..var.name_len] */
    long parent;		/* rec_num of certificate's issuer */
    unsigned long identifier;	/* VMS identifier */
    struct certmap_db_var var;	/* Variable-length string data */
};
/*
 * certmap_set_var initialize a certmap_db_var structure given 2 buffers.
 */
struct certmap_db_var *certmap_set_var ( struct certmap_db_var *var, 
	const unsigned char *name, short name_len,
	const unsigned char *serial, short serial_len );
/*
 * Low-level record operations - note no direct 'write record' available.
 */
	
int certmap_get ( void *db, 
	int pkey, 		/* Primary key of record to fetch */
	int for_update,
	struct certmap_db_rec *rec );
int certmap_rewrite ( void *db,		/* Only after get with for_update */
	struct certmap_db_rec *rec );
int certmap_delete ( void *db );	/* only after get with for_update */

/*
 * High level record operations.
 */
int certmap_search ( void *db, struct certmap_db_var *subject, 
	struct certmap_db_var *issuer,
	void **search_context, struct certmap_db_rec *rec );
void certmap_search_end ( void *db, void **search_context );
int certmap_add ( void *db, struct certmap_db_var *subject, 
	struct certmap_db_var *issuer,
	unsigned long identifier, long *rec_num, char errmsg[256] );
/*
 * Convenience functions for rightslist access.
 */
int certmap_asctoid ( const char *name, unsigned long *id, int *attrib,
	char errmsg[256] );
int certmap_idtoasc ( unsigned long id, char *name, size_t name_size,
	unsigned long *result_id, int *attrib, long *context, 
	char errmsg[256] );
int certmap_finish_rdb ( long *context );
