$!
$! This procedure provides a menu-based system for generating X509 client
$! certificates signed by our own root certificate, using the OpenSSL ca 
$! utility.  The ca utility expects a particular directory structure in which 
$! it stores created certificates.
$!
$! Set up error handler to reset terminal in case user control-Y's out
$! of openssl while asking for a paswword (being UNIX-derived, openssl
$! turns echo off on the whole terminal instead of just modifying the read.
$!
$ save_verify = f$verify(0)
$ tt_noecho = 1
$ if f$trnlnm("TT") .nes. "" then tt_noecho = f$getdvi("TT","TT_NOECHO")
$ on control_y then goto menu_done
$ on error then goto menu_done
$!
$ say = "write sys$output"
$ cakey = "cakey.pem"		! private key filename for
$ cacert = "cacert.pem"		! 'root' certificate for CA
$ catoproot = "demoCA"
$ catop = "ca_root:[" + catoproot   ! fragment to construct file specs from
$ default_reqfile = "newreq.pem"
$ default_certfile = "newcert.pem"
$ default_ = ""
$ gosub setup_openssl_commands	! define OpenSSL commands.
$!
$! Make sure ca root present
$!
$ menu_check_root:
$ catop_present = 1
$ if f$search("ca_root:[000000]''catoproot'.dir;1") .eqs. ""
$ then
$    say "''catop'...] does not exist."
$    catop_present = 0
$ else
$    if f$search(catop+"]ca_menu.conf") .eqs. "" then gosub new_conf
$ endif
$!
$! Main loop, present menu and ask for selection
$!
$ choice_map = ",newreq,sign,pkcs12,verify,newcert,days,newca,help"
$ menu_top:
$   on error then goto menu_done
$   cur_reqfile	= ""		! request file for propagating filename
$   cur_certfile = ""
$   say "CA utility menu:"
$   if catop_present
$   then
$   say "  1:  Create a certificate request for signing"
$   say "  2:  Sign a certificate request"
$   say "  3:  Convert signed certificate to PKCS12 format"
$   say "  4:  Verify a certificate."
$   say "  5:  Create a self-signed certificate (with own private key)"
$   endif
$   say "  6:  Change certificate duration (current: ", f$element(1," ",days),-
	")"
$   say "  7:  Create a new ca_root:[''catoproot'...] directory and root certificate"
$   say "  8:  Help"
$   say "  99: Exit"
$   say ""
$   read sys$command choice_list -
	/prompt="Enter comma-separated list of actions to take: "/end=menu_done"
$   choice_list = f$edit(choice_list,"COLLAPSE")
$   if choice_list .eqs. "" then goto menu_top
$!
$!  Loop through comma-separated choices.
$!
$   cnum = 0
$   menu_next_choice:
$	choice = f$element(cnum,",",choice_list)
$	if choice .eqs. "," then goto menu_choice_done
$	cnum = cnum + 1
$	choice = f$integer(choice)
$	if choice .eq. 99 then goto menu_done
$	if choice .lt. 1 .or. choice .gt. 8
$	then
$	    choice = f$element(cnum-1,",",choice_list)
$	    say "Invalid choice (''choice')"
$	else
$	    on error then goto menu_gosub_abort
$	    gosub do_'f$element(choice,",",choice_map)
$	endif
$	goto menu_next_choice
$ menu_choice_done:
$   say ""	! spacer
$   if catop_present then goto menu_top
$   goto menu_check_root
$ menu_done:
$ if .not. tt_noecho then set term/echo
$ save_verify = f$verify(save_verify)
$ exit
$!
$ menu_gosub_abort:
$ set noverify
$ choice_list = ""
$ say "!!Aborted choice ", choice, " (", f$element(choice,",",choice_map), ")"
$ return
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Create a new self-signed certificate.
$!
$ do_newcert:
$   read sys$command reqfile/err=menu_gosub_abort -
	/prompt="output filename [''default_certfile']: "
$   reqfile = f$parse(reqfile,default_certfile)
$   define/user sys$input sys$command
$   req -new -x509 -keyout 'reqfile' -out 'reqfile 'days'
$   write sys$output "Certificate and private key is in ", reqfile
$ return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! Create a certificate request and set cur_reqfile for followon actions.
$!
$ do_newreq:
$   reqfile = cur_reqfile
$   if reqfile .eqs. "" then read sys$command reqfile/err=menu_gosub_abort -
	/prompt="Certificate request filename to output [''default_reqfile']: "
$   reqfile = f$parse(reqfile,default_reqfile)
$!
$   define/user sys$input sys$command
$   req -new -keyout 'reqfile' -out 'reqfile' 'days'
$   if f$search(reqfile) .nes. "" then cur_reqfile = reqfile
$   write sys$output "Request and private key is in ", reqfile
$   cur_reqfile = reqfile
$ return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! Sign the certificate request created by do_newreq
$!
$ do_sign:
$   reqfile = cur_reqfile
$   if reqfile .eqs. "" then read sys$command reqfile/err=menu_gosub_abort -
	/prompt="Certificate request filename to read [''default_reqfile']: "
$   reqfile = f$parse(reqfile,default_reqfile)
$   certfile = cur_certfile
$   if certfile .eqs. "" then read sys$command certfile /err=menu_gosub_abort -
	/prompt="Certificate file to output [''default_certfile']: "
$   certfile = f$parse(certfile,default_certfile,reqfile)
$!
$   say "If asked for passphrase, enter passphrase for CA certificate."
$   define/user sys$input sys$command
$   ca -policy policy_anything -out 'certfile' -infiles 'reqfile'
$   write sys$output "Signed certificate is in ", certfile
$   cur_reqfile = reqfile
$   cur_certfile = certfile
$ return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! Convert certificate to PKCS12 format for import by web browser.
$!
$ do_pkcs12:
$ reqfile = cur_reqfile
$ if reqfile .eqs. "" then read sys$command reqfile/err=menu_gosub_abort -
	/prompt="Certificate request file (with private key) [''default_reqfile']: "
$ reqfile = f$parse(reqfile,default_reqfile)
$ certfile = cur_certfile
$ if certfile .eqs. "" then read sys$command certfile/err=menu_gosub_abort -
	/prompt="Signed certificate file [''default_certfile']: "
$ certfile = f$parse(certfile,default_certfile,reqfile)
$ p12file = f$parse(".P12", certfile)
$!
$ read sys$command cname /err=menu_gosub_abort/prompt="Description: "
$ if cname .eqs. "" then cname = "My Certificate"
$ say "If asked for passphrase, enter passphrase for new cert. private key."
$ define/user sys$input sys$command
$ pkcs12 -in "''certfile'" -inkey "''reqfile'" -certfile 'catop']'cacert' -
  -out "''p12file'" -export -name "''cname'"
$ say "Certificate and key now encoded in ", p12file
$ return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$ do_days:
$    old_days = f$element(1," ", days)
$    read sys$command new_days/err=menu_gosub_abort/prompt=-
	"Enter number of days certificate will be valid [''old_days']: "
$    if new_days .nes. "" then days = "-days " + new_days
$    return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Create a new ca_root:[democa...] directory tree and a CA certificate
$! for it.
$!
$ do_newca:
$   if f$search("ca_root:[000000]''catoproot'.dir;") .eqs. "" then -
	create/director ca_root:[democa]/protection=world
$   if f$search("''catop']certs.dir;") .eqs. "" then create/dir 'catop'.certs]
$   if f$search("''catop']crl.dir;") .eqs. "" then create/dir 'catop'.crl]
$   if f$search("''catop']newcerts.dir;") .eqs. "" then create/dir 'catop'.newcerts]
$   if f$search("''catop']private.dir;") .eqs. "" then create/dir 'catop'.private]
$   if f$search(catop+"]ca_menu.conf") .eqs. "" then gosub new_conf
$   create 'catop']serial.
01
$   create 'catop']index.txt
$ if f$search("''catop'.private]''cakey'") .eqs. ""
$ then
$    say ""
$    say "Enter filename of PEM file containing the certificate and private key for"
$    say "the new CA or hit return to create a new key and self-signed certificate"
$    read sys$command cacert_source /err=menu_gosub_abort /prompt="PEM File: "
$    if cacert_source .nes. ""
$    then
$!	Copy certfile from existing file.
$	call cp_pem 'cacert_source' 'catop'.private]'cakey' "PRIVATE" "RSA PRIVATE"
$	call cp_pem 'cacert_source' 'catop']'cacert' "CERTIFICATE"
$    else
$	write sys$Output "Making new ca certificate and key..."
$	define/user sys$input sys$command
$	req -new -x509 -keyout 'catop'.private]'cakey' -out 'catop']'cacert' 'days'
$    endif
$ else
$     write sys$Output "Making new ca certificate from existing key..."
$     define/user sys$input sys$command
$     req -new -x509 -key 'catop'.private]'cakey' -out 'catop']'cacert' 'days'
$ endif
$ return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$ do_help:
$ page_opt = ""
$ if f$getsyi("version") .ges. "V7" then page_opt = "=save"
$ type/page'page_opt' sys$Input
$ deck
This procedure provide a simple menu-based procedure for managing a private
'certificate authority' (CA), allowing you to issue your own X509 
certificates for use with SSL.  The data used by the CA, along with
a record of created certificates is kept in several files within
the ca_root:[demoCA...] directory tree:

    ca_menu.conf	Configuration file used by OpenSSL commands issued by
			this procedure.  The OpenSSL 'req' command draws the
			defaults for distinguished name fields from this file,
			section "[ req_distinguished_name ]" should be editted
			to provide suitable defaults.

    cacert.pem		Certificate that this CA uses to sign the certificates
			that it issues.  Web browser's need to import this
			certificate as a trusted CA.

    [.private]cakey.pem	Private key for cacert.pem, it is presumed that only
			the CA has this key and is therefore the only one
			that can sign a certificate using cacert.pem.

    serial.		Data file to track the serial number of the last
			certificate issued, which is incremented each time
			a new certificate is issued.

    index.txt		Data file that tracks gives summary of issued
			certificates, including serial number.

    [.newcerts]*.pem	Copies of certificates issued.  Filename is 'nn'.pem,
			where 'nn' is certificate's serial number.

    [.crl]		Directory containing certificate revocation data.

    [.certs]		Directory where issued certs are kept.

The steps involved in creating a certifcate are:

   1. Create a certificate request for signing by the CA.  The request itself
      is signed by an RSA private to the requestor.  Menu item 1 creates both
      a new key and certificate request, placing them in the same output file
      (newreq.pem).

   2. Sign the certificate request with the CA's certificate/key, creating
      a new certificate (newcert.pem).

   3. Produce a PKCS12 format file containing the requestor's new private
      key and the new certificate, encrypted using a one-time export
      password.

$ eod
$ return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$ do_verify:
$   certfile = cur_certfile
$   if certfile .eqs. "" then read sys$command certfile/err=menu_gosub_abort -
	/prompt="Signed certificate file [''default_certfile']: "
$   certfile = f$parse(certfile,default_certfile,cur_reqfile)
$   define/user sys$input sys$command
$   verify "-CAfile" 'catop']'cacert' 'certfile'
$ return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ setup_openssl_commands:
$! Make sure OpenSSL available as command.
$!
$ if f$type(openssl) .eqs. ""
$ then
$    if f$type(ssleay) .nes. ""
$    then
$	openssl = ssleay
$    else
$	write sys$output "OpenSSL command not defined"
$	exit
$    endif
$ endif
$!
$! Construct short commands for utilities used.
$!
$ ssleay_conf = f$trnlnm("SSLEAY_CONF")
$ days = "-days 365"
$ req = openssl + " req -config " + catop + "]ca_menu.conf"
$ ca = openssl + " ca -config " + catop + "]ca_menu.conf"
$ verify = openssl + " verify "
$ x509 = openssl + " x509 -config " + catop + "]ca_menu.conf"
$ pkcs12 = openssl + " pkcs12"
$!
$! Be sure ca_root defined.
$!
$ if f$trnlnm("ca_root") .eqs. ""
$ then
$ type sys$Input
The logical name ca_root must be defined as a concealed-device logical
for the ca_root:[demoCA...] file tree.

$   root_dir_def = f$environment("DEFAULT")
$   read sys$command ca_root_dir -
	/prompt="directory for ca_root [''root_dir_def']: "/end=setup_abort
$   if ca_root_dir .eqs. "" then ca_root_dir = root_dir_def
$   root_dir = f$parse("1.;",ca_root_dir,,,"NO_CONCEAL,SYNTAX_ONLY") - "][" - "]1.;"
$   define/nolog ca_root 'root_dir'.] /trans=(terminal,conceal)
$ else
$    if .not. f$trnlnm("ca_root",,,,,"CONCEALED")
$    then
$	write sys$Output "Logical ca_root improperly defined!"
$    endif
$ endif
$ return
$ setup_abort:
$ exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Copy portion of PEM file named by P1 bounded by P3|P4|P5 to new file P2.
$!
$ cp_pem: SUBROUTINE
$   on error then exit
$   open/read/share inp 'P1'
$   on error then goto cp_pem_cleanup
$   create 'p2'
$   open/append/share out 'p2'
$   in_bounds = 0
$   stag = "-----BEGIN " + P3
$   stag2 = "-----BEGIN " + P4
$   stag3 = "-----BEGIN " + P5
$   etag = "-----END " + P3
$ cp_pem_next:
$   read inp line/end=cp_pem_cleanup
$   if in_bounds
$   then
$	write out line
$	if f$locate(etag,line) .lt. f$length(line) then in_bounds = 0
$   else
$	if f$locate(stag,line) .lt. f$length(line)
$	then
$	    in_bounds = 1
$	    write out line
$	endif
$	if P4 .nes. "" .and. f$locate(stag2,line) .lt. f$length(line)
$	then
$	    in_bounds = 1
$	    write out line
$	    etag = "-----END " + P4
$	endif
$	if P5 .nes. "" .and. f$locate(stag3,line) .lt. f$length(line)
$	then
$	    in_bounds = 1
$	    write out line
$	    etag = "-----END " + P5
$	endif
$   endif
$    goto cp_pem_next
$ cp_pem_cleanup:
$ close inp
$ close out
$ exit
$endsubroutine
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! create new configuration file
$!
$ new_conf:
$ say "Creating new configuration file, ''catop']ca_menu.conf, edit section"
$ say "[ req_distinguished_name ] to change defaults for input fields."
$ create 'catop']ca_menu.conf
$ deck
#
# OpenSSL configuration file customized for use by ca_menu.com.
#

RANDFILE		= "/sys$login/.rnd"
oid_file		= "/sys$Login/.oid"
oid_section		= new_oids

# To use this configuration file with the "-extfile" option of the
# "openssl x509" utility, name here the section containing the
# X.509v3 extensions to use:
# extensions		= 
# (Alternatively, use a configuration file that has only
# X.509v3 extensions in its main [= default] section.)

[ new_oids ]

# We can add new OIDs in here for use by 'ca' and 'req'.
# Add a simple OID like this:
# testoid1=1.2.3.4
# Or use config file substitution like this:
# testoid2=${testoid1}.5.6

####################################################################
[ ca ]
default_ca	= CA_default		# The default ca section

####################################################################
[ CA_default ]

dir		= ca_root:[demoCA	# Where everything is kept
certs		= $dir.certs]		# Where the issued certs are kept
crl_dir		= $dir.crl]		# Where the issued crl are kept
database	= $dir]index.txt	# database index file.
new_certs_dir	= $dir.newcerts]	# default place for new certs.

certificate	= $dir]cacert.pem 	# The CA certificate
serial		= $dir]serial.		# The current serial number
crl		= $dir]crl.pem 		# The current CRL
private_key	= $dir.private]cakey.pem# The private key
RANDFILE	= $dir.private].rand	# private random number file

x509_extensions	= usr_cert		# The extentions to add to the cert

# Extensions to add to a CRL. Note: Netscape communicator chokes on V2 CRLs
# so this is commented out by default to leave a V1 CRL.
# crl_extensions	= crl_ext

default_days	= 365			# how long to certify for
default_crl_days= 30			# how long before next CRL
default_md	= md5			# which md to use.
preserve	= no			# keep passed DN ordering

# A few difference way of specifying how similar the request should look
# For type CA, the listed attributes must be the same, and the optional
# and supplied fields are just that :-)
policy		= policy_match

# For the CA policy
[ policy_match ]
countryName		= match
stateOrProvinceName	= match
organizationName	= match
organizationalUnitName	= optional
commonName		= supplied
emailAddress		= optional

# For the 'anything' policy
# At this point in time, you must list all acceptable 'object'
# types.
[ policy_anything ]
countryName		= optional
stateOrProvinceName	= optional
localityName		= optional
organizationName	= optional
organizationalUnitName	= optional
commonName		= supplied
emailAddress		= optional

####################################################################
[ req ]
default_bits		= 2048
default_keyfile 	= privkey.pem
distinguished_name	= req_distinguished_name
attributes		= req_attributes
x509_extensions	= v3_ca	# The extentions to add to the self signed cert

# This sets the permitted types in a DirectoryString. There are several
# options. 
# default: PrintableString, T61String, BMPString.
# pkix	 : PrintableString, BMPString.
# utf8only: only UTF8Strings.
# nobmp : PrintableString, T61String (no BMPStrings).
# MASK:XXXX a literal mask value.
# WARNING: current versions of Netscape crash on BMPStrings or UTF8Strings
# so use this option with caution!
dirstring_type = nobmp

# req_extensions = v3_req # The extensions to add to a certificate request

[ req_distinguished_name ]
countryName			= Country Name (2 letter code)
countryName_default		= US
countryName_min			= 2
countryName_max			= 2

stateOrProvinceName		= State or Province Name (full name)
stateOrProvinceName_default	= Ohio

localityName			= Locality Name (eg, city)
localityName_default		= Columbus

0.organizationName		= Organization Name (eg, company)
0.organizationName_default	= Ohio State University

# we can do this but it is not needed normally :-)
#1.organizationName		= Second Organization Name (eg, company)
#1.organizationName_default	= World Wide Web Pty Ltd

organizationalUnitName		= Organizational Unit Name (eg, section)
#organizationalUnitName_default	=

commonName			= Common Name (eg, YOUR name)
commonName_max			= 64

emailAddress			= Email Address
emailAddress_max		= 40

# SET-ex3			= SET extension number 3

[ req_attributes ]
challengePassword		= A challenge password
challengePassword_min		= 4
challengePassword_max		= 20

unstructuredName		= An optional company name

[ usr_cert ]

# These extensions are added when 'ca' signs a request.

# This goes against PKIX guidelines but some CAs do it and some software
# requires this to avoid interpreting an end user certificate as a CA.

basicConstraints=CA:FALSE

# Here are some examples of the usage of nsCertType. If it is omitted
# the certificate can be used for anything *except* object signing.

# This is OK for an SSL server.
# nsCertType			= server

# For an object signing certificate this would be used.
# nsCertType = objsign

# For normal client use this is typical
# nsCertType = client, email

# and for everything including object signing:
# nsCertType = client, email, objsign

# This is typical in keyUsage for a client certificate.
# keyUsage = nonRepudiation, digitalSignature, keyEncipherment

# This will be displayed in Netscape's comment listbox.
nsComment			= "OpenSSL Generated Certificate"

# PKIX recommendations harmless if included in all certificates.
subjectKeyIdentifier=hash
authorityKeyIdentifier=keyid,issuer:always

# This stuff is for subjectAltName and issuerAltname.
# Import the email address.
# subjectAltName=email:copy

# Copy subject details
# issuerAltName=issuer:copy

#nsCaRevocationUrl		= http://www.domain.dom/ca-crl.pem
#nsBaseUrl
#nsRevocationUrl
#nsRenewalUrl
#nsCaPolicyUrl
#nsSslServerName

[ v3_req ]

# Extensions to add to a certificate request

basicConstraints = CA:FALSE
keyUsage = nonRepudiation, digitalSignature, keyEncipherment

[ v3_ca ]


# Extensions for a typical CA


# PKIX recommendation.

subjectKeyIdentifier=hash

authorityKeyIdentifier=keyid:always,issuer:always

# This is what PKIX recommends but some broken software chokes on critical
# extensions.
#basicConstraints = critical,CA:true
# So we do this instead.
basicConstraints = CA:true

# Key usage: this is typical for a CA certificate. However since it will
# prevent it being used as an test self-signed certificate it is best
# left out by default.
# keyUsage = cRLSign, keyCertSign

# Some might want this also
# nsCertType = sslCA, emailCA

# Include email address in subject alt name: another PKIX recommendation
# subjectAltName=email:copy
# Copy issuer details
# issuerAltName=issuer:copy

# DER hex encoding of an extension: beware experts only!
# obj=DER:02:03
# Where 'obj' is a standard or added object
# You can even override a supported extension:
# basicConstraints= critical, DER:30:03:01:01:FF

[ crl_ext ]

# CRL extensions.
# Only issuerAltName and authorityKeyIdentifier make any sense in a CRL.

# issuerAltName=issuer:copy
authorityKeyIdentifier=keyid:always,issuer:always
$ eod
$ return
