 /* !++  ! ! ! MODULE:   	    KANJI_CONVERSION  !  ! FACILITY: 	    NEWSRDR ! = ! ABSTRACT: 	    JIS/DEC Kanji character conversion routines.  !  ! MODULE DESCRIPTION:  ! A !   This module contains routines for use by NEWSRDR that convert E !   character strings between DEC Kanji and JIS Kanji character sets. D !   To use these routines with NEWSRDR, compile this module and link !   it with the commands:  ! 9 !   	$ link/share/notrace kanji_conversion,sys$input:/opt E !   	    universal=network_to_local,local_to_network            (VAX) 7 !           symbol_vector=(network_to_local=procedure,- J !                          local_to_network=procedure)             (Alpha) !   	    <ctrl/Z>  ! D !   The UNIVERSAL= linker directive is used only on VAX systems; the; !   SYMBOL_VECTOR= directive is used only on Alpha systems.  ! H !   Then copy it to SYS$LIBRARY and make it available with the commands: ! D !   	$ copy kanji_conversion.exe sys$common:[syslib]/protection=w:reB !   	$ install create sys$share:kanji_conversion/share/open/header8 !   	$ define/system/exec newsrdr_character_conversion -& !   	    	sys$library:kanji_conversion ! 8 !   (You need a suitably privileged account to do this.) !  ! AUTHOR:   	    M. Madison 1 !   	    	    COPYRIGHT  1992, MADGOAT SOFTWARE.  !  ! CREATION DATE:    12-NOV-1990  !  ! MODIFICATION HISTORY:  ! 0 !   12-NOV-1990	V1.0	Madison	    Initial coding.E !   07-MAR-1991	V1.0-1	Togawa	    Fix handling of control characters. 8 !   12-SEP-1992	V2.0	Madison	    Update for NEWSRDR 4.0.G !   07-FEB-1997	V3.0	mako	    Add support for ISO-2022-JP B64 decoding. L !   13-APR-1997	V3.0-1	mako	    Fix for lost characters in network_to_local. !--  */   #include <ctype.h> #include descrip #include str$routines    #define STATE_ASCII 0  #define STATE_AK    1  #define STATE_AKK   2  #define STATE_KANJI 3  #define STATE_KK    4  #define STATE_KA    6  #define STATE_KAA   7  #define STATE_STOP  9    #define STATE_ISO_2022_JP   10 #define STATE_ISO_2022_JP_B 11 #define STATE_ISO_2022_JP_X 12  @ #define append(c)     {if (outc-out < outsize-2) *outc++ = (c);}9 #define flush()       {for (; j <= inc; j++) append(*j);} ( #define ISO_2022_JP_B "=?ISO-2022-JP?B?"  M static char B64a[128], B64b[128], B64c[128], B64d[128], B64e[128], B64f[128]; X static char base[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"; static int  mode = -1;   static void  decode_BASE64_init(){    int i;
   char *c;X   for (i = 0; i<128; i++) B64a[i] = B64b[i] = B64c[i] = B64d[i] = B64e[i] = B64f[i]= -1;   for (c = base; *c; c++) { (     B64a[*c] =  (c - base)         << 2;(     B64b[*c] = ((c - base) & 0x30) >> 4;(     B64c[*c] = ((c - base) & 0x0f) << 4;(     B64d[*c] = ((c - base) & 0x3c) >> 2;(     B64e[*c] = ((c - base) & 0x03) << 6;(     B64f[*c] =  (c - base)             ;   }  }    void5 network_to_local (char *in, char *out, int outsize) {        char *inc, *outc, *j, ch;      int state;       state = STATE_ASCII;
     inc = in;      outc = out;   !     for (inc = in; *inc; inc++) {      	switch (state) {      	    case STATE_ASCII:6     	    	if (*inc == 27) {j = inc; state = STATE_AK;}X                 else if (*inc == ISO_2022_JP_B[0]) {j = inc; state = STATE_ISO_2022_JP;}     	    	else append(*inc);     	    	break;     	    case STATE_AK: ,     	    	if (*inc == 36) state = STATE_AKK;.     	    	else {flush(); state = STATE_ASCII;}     	    	break;     	    case STATE_AKK:<     	    	if (*inc == 66 || *inc == 64) state = STATE_KANJI;.     	    	else {flush(); state = STATE_ASCII;}     	    	break;     	    case STATE_KANJI:6     	    	if (*inc == 27) {j = inc; state = STATE_KA;}F     	    	else if (*inc <= 32) {append(*inc);}	/* added by H.Togawa */7     	    	else {state = STATE_KK; append(*inc | 0x80);}      	    	break;     	    case STATE_KK:      	    	append (*inc | 0x80);      	    	state = STATE_KANJI;     	    	break;     	    case STATE_KA: ,     	    	if (*inc == 40) state = STATE_KAA;.     	    	else {flush(); state = STATE_KANJI;}     	    	break;     	    case STATE_KAA:J     	    	if (*inc == 72 || *inc == 66 || *inc == 74) state = STATE_ASCII;.     	    	else {flush(); state = STATE_KANJI;}     	    	break;#             case STATE_ISO_2022_JP: Z                 if (toupper(*inc) != ISO_2022_JP_B[inc-j]) {flush(); state = STATE_ASCII;}W                 else if (inc-j+2 == sizeof(ISO_2022_JP_B)) state = STATE_ISO_2022_JP_B;                  break;%             case STATE_ISO_2022_JP_B: R                 if (*inc == '?') {mode = 0; j = inc; state = STATE_ISO_2022_JP_X;}                 else {!                   switch (mode) { ?                   case -1: decode_BASE64_init(); /* no break */ U                   case  0:                          ch = B64a[*inc]; mode = 1; break; U                   case  1: append(ch | B64b[*inc]); ch = B64c[*inc]; mode = 2; break; U                   case  2: append(ch | B64d[*inc]); ch = B64e[*inc]; mode = 3; break; U                   case  3: append(ch | B64f[*inc]);                  mode = 0; break;                    }                  }                  break;%             case STATE_ISO_2022_JP_X: )                 if (*inc != '=') flush(); $                 state = STATE_ASCII;                 break;     	}     }   !     if ((state != STATE_ASCII) && !         (state != STATE_KANJI) && '         (state != STATE_ISO_2022_JP_B))        flush();       *outc = '\0';    } /* network_to_local */   void5 local_to_network (char *in, char *out, int outsize) {        char *inc, *outc;      int state;       state = STATE_ASCII;
     inc = in;      outc = out;   !     for (inc = in; *inc; inc++) { ,     	if (state == STATE_ASCII && *inc < 0) {     	    state = STATE_KANJI; ,     	    append(27); append(36); append(64);3     	} else if (state == STATE_KANJI && *inc > 0) {      	    state = STATE_ASCII; ,     	    append(27); append(40); append(74);     	}     	append(*inc & 0x7f);      }   =     if (state == STATE_KANJI) {			/* added by H.Togawa	    */ :     	state = STATE_ASCII;			/* The mode should be ASCII */C     	append(27); append(40); append(74);	/* when terminates.	    */      }						/*			    */       *outc = '\0';    } /* local_to_network */