#include <stdio.h>
#include <string.h>
#include "sysdep.h"
#include "search.h"
#include "window.h"
#include "file.h"
#include "keym.h"
#include "externs.h"
#include "display.h"

/* returns zero if not quit */
  
int do_extended_key()
{
    char ch;
    static int next = 1;
    int quit = 0, n;
    unsigned char *save;
    
    select_minibuffer();  putc(':',stdout); fflush(stdout);
    ch = getkey();
    putc(ch,stdout); fflush(stdout);
    if (ch == 'n')
      {
          if (!NUM_FILES)
            {
                message("File ring is empty.",1);
            }
          quit = next_file(&next);
          if (next == -1) quit = 1;
      }
    else if ((ch == 'c') || (ch == 'C'))   /* toggle case sensitive search */
      {
          CASE_SENSITIVE = !CASE_SENSITIVE;
          if (CASE_SENSITIVE)
            message("Searches now respect case.",0);
          else
            message("Searches nolonger respect case.",0);
      }
    else if ((ch == 'D') && MOST_D_OPT) /* delete file */
      {
          /* notice the missing D. */
	 send_string_to_term("elete ");
	 send_string_to_term(BUF->file);
	 send_string_to_term("? [n]:");
	 
          ch = getkey();
          if (ch == 'y')
            {
                if (!sys_delete_file(BUF->file))
                  message("File could not be deleted.",1);
                else
                  message("File deleted.",0);
            }
          else
            message("File not deleted.",0);
      }
    else if (ch == 'o')
      {
          send_string_to_term("\rToggle option: b d t v w");
          ch = getkey();
          if ((ch == 'd') || (ch == 'w') || (ch == 'b') || (ch == 't') || (ch == 'v') || (ch == 's'))
            {
                if (ch == 'b')
                  {
                      MOST_B_OPT = !MOST_B_OPT;
                      NUM_LINES = count_lines(BEG,EOB);
                  }
                else if (ch == 'd')
                  {
                      if (DIGIT_ARG == NULL)
                        {
                            message("Selective Display off.",0);
                            n = 0;
                        }
                      else n = abs( *DIGIT_ARG );
                      if (MOST_S_OPT != n)
                        {
                            MOST_S_OPT = n;
                            NUM_LINES = count_lines(BEG,EOB);
                        }
                  }
                else if ((ch == 's') && !MOST_B_OPT)
                  {
                      SQUEEZE_LINES = !SQUEEZE_LINES;
                      NUM_LINES = count_lines(BEG,EOB);
                  }
                else if (ch == 'w')
                  {
                      MOST_W_OPT = !MOST_W_OPT;
                      NUM_LINES = count_lines(BEG,EOB);
                  }
                else if (ch == 'v') MOST_V_OPT = !MOST_V_OPT;
                else if (ch == 't') MOST_T_OPT = !MOST_T_OPT;

                if (!NUM_LINES) NUM_LINES = 1;
                
                save_win_flags(WIN);
                save = C_POS;
                C_POS = BEG;
                C_LINE = 1;
                C_LINE = what_line(save);
                C_POS = save;
                WIN->beg_line = C_LINE;
                tt_erase_line();
                exit_minibuffer();
                redraw_window();
                update_status(0);
                return(quit);
            }
      }
    else
      {
	 beep();
	 tt_erase_line();
      }
    fflush(stdout);
    
    exit_minibuffer();
    return(quit);
}

/* returns zero if not quit */

int do_extended_cmd()
{
    char cmd[80];
    int quit = 0;
    cmd[0] = 0;
    if (!read_from_minibuffer("Cmd",cmd)) return 0;
    
    if (!strcmp(cmd,"cd"))
      {
          cd();
      }
    else if ((!strncmp(cmd,"quit",strlen(cmd))) || 
	     (!strncmp(cmd,"exit",strlen(cmd))))
      {
          quit = -1;
      }
    else
      {
          strcat(cmd," not understood.");
          message(cmd,1);
      }
    return(quit);
}

