   J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \>  *                %% |              DORMANT             %%   \@  *                %% |          utility.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *?  *  Copyright (C) 1998, 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *B  *  DORMANT is a tool to display SYSUAF info about inactive users,=  *  specifically users which have not logged in, for example,   *  in the past 95 days.A  *  Command qualifiers are present to specify a particular group, C  *  the idle interval, and interactive and/or noninteractive usage.   *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #include "version.h" #pragma module UTILITY VERSION    #include <stdio.h> #include <ctype.h> #include <descrip.h> #include <jpidef.h>  #include <prvdef.h>  #include <rms.h> #include <rmsdef.h>  #include <ssdef.h> #include <string.h>  #include <syidef.h>  #include "version.h" #include "sysuaf.h"     #define PRV$M_SYSPRV 0x10000000  #define PRV$M_BYPASS 0x20000000     globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;    F extern char GroupStr[32];       /* group name from /GROUP qualifier */ extern char CmdVerb[32];9 extern char UafEsa[NAM$C_MAXRSS]; /* extended filespec */ : extern char UafRsa[NAM$C_MAXRSS]; /* resultant filespec */   < extern int  GroupBin;           /* Uic group number (hex) */ extern int  NumIdleDays;H extern int  RmsStat;            /* return status for direct rms calls */ extern int  status;  extern int  iosb[2];    extern short GroupFlg; extern short NoninterFlg;  extern short OwnerFlg;   E extern FILE *output_fp;         /* file pointer to output log file */     extern struct FAB UafFab;  extern struct NAM UafNam;  extern struct RAB UafRab;  extern struct UAF UafRec;     globalvalue DORMANT_CLD;         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: OpenSysUafE  * Description: Initialize and open the SYSUAF.DAT file. Since we are E  *              specifying the logical name SYSUAF, rms should locate E  *              the file even if not in SYS$SYSROOT:[SYSEXE]. Because H  *              the uaf fab, nam and rab stuctures are global, we simplyG  *              open the file and return, permitting the caller to read ;  *              all user records using the SYS$GET service.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void OpenSysUaf()  {      char UafStr[] = "SYSUAF";         UafFab = cc$rms_fab;     UafNam = cc$rms_nam;     UafRab = cc$rms_rab;   D     UafFab.fab$l_dna = UafStr;             /* address of filename */B     UafFab.fab$b_dns = strlen(UafStr);     /* Assign the length */L     UafFab.fab$l_nam = &UafNam;            /* Assign address of NAM block */$     UafFab.fab$b_shr = FAB$M_SHRPUT;!     UafFab.fab$b_fac = FAB$M_GET;    F     UafNam.nam$l_esa = UafEsa;             /* Address of the UafEsa */E     UafNam.nam$b_ess = sizeof(UafEsa);     /* length of the UafEsa */ F     UafNam.nam$l_rsa = UafRsa;             /* Address of the UafRsa */E     UafNam.nam$b_rss = sizeof(UafRsa);     /* Length of the UafRsa */         UafRab.rab$l_fab = &UafFab; (     UafRab.rab$l_ubf = (char *) &UafRec;$     UafRab.rab$w_usz = UAF$K_LENGTH;!     UafRab.rab$b_rac = RAB$C_SEQ; !     UafRab.rab$l_rop = RAB$M_NXT;      UafRab.rab$b_krf = 0;    '     RmsStat = sys$parse(&UafFab, 0, 0); -     if(RmsStat != RMS$_NORMAL) exit(RmsStat); $     UafEsa[UafNam.nam$b_esl] = '\0';   &     RmsStat = sys$search(&UafFab,0,0);-     if(RmsStat != RMS$_NORMAL) exit(RmsStat); $     UafRsa[UafNam.nam$b_rsl] = '\0';         RmsStat = sys$open(&UafFab);-     if(RmsStat != RMS$_NORMAL) exit(RmsStat);    #     RmsStat = sys$connect(&UafRab); -     if(RmsStat != RMS$_NORMAL) exit(RmsStat);     }    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: DispStats C  * Description: This routine displays environmental statistics as a I  *              header prior to displaying user idle account information. G  *              It provides current date-time values, node info and the :  *              idle inverval used to generate the report.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void DispStats() {      char    AscTime[32];$     char    Boldoff[] = {"\033[0m"};#     char    Boldon[] = {"\033[1m"};      char    NodeName[16];      short   length; #     $DESCRIPTOR(Dsc_Time, AscTime); @     struct  {short len, code; int *bufadr, *retlen;} SyiItem[2];   2     status = sys$asctim(&length, &Dsc_Time, 0, 0);     AscTime[20] = '\0';    &     SyiItem[0].len = sizeof(NodeName);$     SyiItem[0].code = SYI$_NODENAME;"     SyiItem[0].bufadr = &NodeName;      SyiItem[0].retlen = &length;     SyiItem[1].len = 0;      SyiItem[1].code = 0;   9     status = sys$getsyiw(0, 0, 0, &SyiItem, &iosb, 0, 0);      NodeName[length] = '\0';C     fprintf(output_fp, "\n\n\tNode %s on %s\n", NodeName, AscTime); H     fprintf(output_fp, "\tInactivity Period: %d days\n\n", NumIdleDays);   ?     if(GroupFlg) fprintf(output_fp, "%s %-24s", Boldon, "Uic"); <     else fprintf(output_fp, "%s %-13s", Boldon, "Username");6     if(OwnerFlg) fprintf(output_fp, "%-21s", "Owner");%     fprintf(output_fp, "%4c ", 0X49); 5     if(NoninterFlg) fprintf(output_fp, "%4c ", 0X4e); 1     fprintf(output_fp, " Default %s\n", Boldoff);  }    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckPrvJ  * Description: Verify the user activating this image has sufficient privsE  *              to read the entire sysuaf.dat file. If not, then exit ,  *              with the SS$_NOPRIV message.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckPrv() {      int enabflg = 1;     int prmflg = 0;      int PrvStat;     int PrivMask1 = 0;     int PrivMask2 = 0;     int ProcPriv[2] = 0;   @     struct  {short len, code; int *bufadr, *retlen;} JpiItem[2];   &     JpiItem[0].len = sizeof(ProcPriv);$     JpiItem[0].code = JPI$_PROCPRIV;"     JpiItem[0].bufadr = &ProcPriv;     JpiItem[0].retlen = 0;     JpiItem[1].len = 0;      JpiItem[1].code = 0;        PrivMask2 |= PRV$M_SYSPRV;     PrivMask1 |= PRV$M_SETPRV;   6     PrvStat = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);,     if(PrvStat != SS$_NORMAL) exit(PrvStat);B     if((ProcPriv[0] & PrivMask2) == PrivMask2) return(SS$_NORMAL);!     if(PrivMask1 & ProcPriv[0]) { !         ProcPriv[0] |= PrivMask2; <         PrvStat = sys$setprv(enabflg, &ProcPriv, prmflg, 0);         return(PrvStat);     }      return(SS$_NOPRIV);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowVersD  * Description: Display image version, creation (link) date, and req  *              priv info.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 ShowVers() { 3     printf("\n\n\t\t%s by Lyle W West\n", CmdVerb); 0     printf("\t\tVersion: %s (DecC)\n", VERSION);.     printf("\t\tImage Build: %s\n", __DATE__);9     printf("\t\tRequired Privs: SYSPRV (or BYPASS)\n\n");      exit(1); }    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowHelpI  * Description: Display a brief combination of DORMANT.README and the cdu J  *              DORMANT.CLD file. It provides a command line glance at the:  *              optional implementations of DORMANT usage.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 ShowHelp() { 2     printf("\n\n  %s (%s)\n\n", CmdVerb, VERSION);K     printf("\t%s is a tool to display SYSUAF info about inactive users,\n",          CmdVerb); L     printf("\tspecifically users which have not logged in, for example,\n");'     printf("\tin the past 95 days.\n"); P     printf("\tCommand qualifiers are present to specify a particular group,\n");T     printf("\tthe idle interval, and interactive and/or noninteractive usage.\n\n");#     printf("     Parameters:\n\n");      printf("       None\n\n");#     printf("     Qualifiers:\n\n"); O     printf("\t/GROUP - if present, inactivity info displayed pertains only\n"); P     printf("\t\tto the specified group of users. The group can be specified\n");O     printf("\t\tas a rightslist symbol, such as SUPPORT, or numerically as\n"); K     printf("\t\tan octal value, 225. (/GROUP=225 or /GROUP=SUPPORT).\n\n"); O     printf("\t/IDLEDAYS=nn - if present, and a value is entered, the value\n"); I     printf("\t\tis used as the idle delta time for comparison to the\n"); '     printf("\t\tlogin information.\n"); D     printf("\t\tIf omitted, the interval defaults to 90 days.\n\n");J     printf("\t/NOOWNER - if present, %s does NOT display the uaf owner\n",             CmdVerb); M     printf("\t\tinformation. Note that the owner field is also inhibited\n"); ;     printf("\t\tif the /GROUP qualifier is specified\n\n"); J     printf("\t/NONINTERACTIVE - if present %s also displays the number\n",             CmdVerb); D     printf("\t\tof days since a non-interactive login occurred.\n");R     printf("\t\tIf omitted, only interactive login information is displayed\n\n");P     printf("\t/NOSTATISTICS - if present, %s suppresses the display of node,\n",             CmdVerb); P     printf("\t\tdate, column labels and summary information. The default is\n");3     printf("\t\tto display this information.\n\n"); L     printf("\t/OUTPUT=filespec - if present %s output is directed to the\n",             CmdVerb); R     printf("\t\tspecified filespec. The default places output to the display.\n");A     printf("\t\tA filespec is required with this qualifier\n\n"); H     printf("\t/USER_FILTER - if present, %s will parse each username\n",             CmdVerb); P     printf("\t\tfor an exact match of the filter string. A filter string of\n");P     printf("\t\t'MIT' will match usernames 'SMITH' and 'KERMIT'. The filter\n");I     printf("\t\tstring must be alphanumeric characters, '_' and '$'.\n"); M     printf("\t\tAny other characters will display an error message and %s\n",              CmdVerb);      printf("\t\twill exit.\n"); M     printf("\t\tThis qualifier is ignored if /GROUP is also specified.\n\n"); /     printf("\t/HELP - Displays this text\n\n"); J     printf("\t/VERSION - if present %s displays version, build", CmdVerb);1     printf(" date,\n\t\tand required privs\n\n");         exit(1); }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetGroupEntry C  * Description: User entered a group identifier, either symbolic or C  *              numeric. Determine identifier format, then validate E  *              the identifier. If valid identifier, copy numeric uic D  *              longword to 'GroupBin' and if entry was with numericH  *              identifier in ascii, copy identifier name to 'GroupStr'.?  *              If user supplied group info invalid, then exit.   *G  *              In the event there is no identifier associated with the C  *              /GROUP qualifier used, we compare the entered group E  *              value with group value of each uaf record. If a match F  *              occurs, save that value in GroupBin, else exit with an9  *              error, stating we have invalid UIC group.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetGroupEntry(char *Ident)  {      int GrpStat = 0;     int BinIdent = 0;      int BinMask = 0;     int GroupId = 0;     int group = 0;     short length = 0;      char IdentStr[32];"     $DESCRIPTOR(Dsc_Id, IdentStr);   +     memset(&GroupStr, 0, sizeof(GroupStr));      GroupBin = 0;    5         /* first test if valid symbolic identifier */         strcpy(IdentStr, Ident);+     Dsc_Id.dsc$w_length = strlen(IdentStr); 8     GrpStat = sys$asctoid(&Dsc_Id, &BinIdent, &BinMask);   I         /* if status is not SS$_NORMAL, check for valid octal group id */    >     if(GrpStat != SS$_NORMAL) { /* not an identifier string */*         sscanf(IdentStr, "%o", &BinIdent);         GroupId = BinIdent; -         BinIdent = 0xffff | (BinIdent << 16); /         Dsc_Id.dsc$w_length = sizeof(IdentStr); J         GrpStat = sys$idtoasc(BinIdent, &length, &Dsc_Id, 0, &BinMask, 0);#         if(GrpStat == SS$_NORMAL) { !             IdentStr[length] = 0; '             strcpy(GroupStr, IdentStr);              GroupBin = GroupId; 	         } N         else {      /* probably 0x21ec, NOSUCHID, unknown rights identifier */             OpenSysUaf(); +             while(RmsStat == RMS$_NORMAL) { +                 RmsStat = sys$get(&UafRab); .                 if(RmsStat == RMS$_EOF) break;9                 if(RmsStat != RMS$_NORMAL) exit(RmsStat); )                 group = UafRec.uaf$w_grp; +                 if(group == GroupId) break; 
             } /             if(RmsStat == RMS$_EOF) exit(3826);              GroupBin = group; )             RmsStat = sys$close(&UafFab); 	         }      } 
     else {0         GroupId = (BinIdent & 0xffff0000) >> 16;         GroupBin = GroupId; #         strcpy(GroupStr, IdentStr);      }  }          H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */    D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr; 0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */  _A         /* here we use recall allocation to determine the size of B            the recall buffer length field, changed at vms 7.3.2 */  %E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;   B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */          else {             *length = -1;_"             return(SS$_BUFFEROVF);	         }      }y2     else *length = *Sptr;       /*  8 bit value */   C         /* get buffer length and copy cmd line to callers buffer */1  h     Sptr -= *length;!     strncpy(Dptr, Sptr, *length);a     return(SS$_NORMAL);n }p  g  e  oN /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ParseFilterpF  * Description: User has entered /USER_FILTER=xxx, where xxx is filterG  *              string. DORMANT will look for string xxx in each sysuafgK  *              username record, and if a match is found, will process thateE  *              record. This routine checks for any characters in thecH  *              filter string which are not valid, and if any are found,F  *              the image exits. Valid characters are any alphanumeric-  *              char, dollar, and underscore.*  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */I, int ParseFilter(char *inpbuf, char *filtbuf) {p     int done = 0;c     char *ptr3;<  d     ptr3 = inpbuf;     while(!done) {          status = isalnum(*ptr3);         if(status) ptr3++;         else {             switch(*ptr3) {s                 case '\0':                      done = TRUE;                     break;                 case '$':                  case '_':u                     ptr3++;u                     break;                 default:P                     fprintf(output_fp, "%%%s-E-INVWILD, filter string %s%s\n\n",H                         CmdVerb, inpbuf, " contains invalid character");                     exit(1);
             }l	         }      }n     strcpy(filtbuf, inpbuf);     return TRUE; }    