  #module LOOKUP "BOL-V1.0/AUG-94"   #include <ctype.h> #include <errno.h> #include <stdio.h> #include <stdlib.h>  #include <string.h>    #include <descrip.h> #include <psldef.h>  #include <sor$routines.h>  #include <ssdef.h>   #include "lnmlookupdef.h"    #define LNMB$M_NO_ALIAS 1  #define LNMB$M_CONFINE  2  #define LNMB$M_CRELOG   4  #define LNMB$M_TABLE    8  #define LNMB$M_NODELETE 16   #define LNMX$M_CONCEALED 1 #define LNMX$M_TERMINAL  2   #define LNMX$C_HSHFCN    -128  #define LNMX$C_BACKPTR   -127  #define LNMX$C_TABLE     -126  #define LNMX$C_IGNORE    -125    #define LNMTH$M_SHAREABLE 1  #define LNMTH$M_DIRECTORY 2  #define LNMTH$M_GROUP     4  #define LNMTH$M_SYSTEM    8    #define SS$_NOMOREITEMS  1777    #define SOR$M_MULTI	 4 #define SOR$M_NOSIGNAL	 8    int   get_args (int, char**);  void  point (int, char*);  void  upper (char*);# char* get_namattr (unsigned short); # char* get_equattr (unsigned short);  char* get_tabattr (char);  char* get_mode (unsigned char);  void  prt_hlp ();   4 char in_logbuf [40], in_tabbuf [40], in_qui, in_nam;  - unsigned in_attrib, in_accmod = -1, in_index;    FILE* f_out;   struct f_equ {   struct f_equ *equ_ptr;   struct lnmlookup_equi s_equ;   char   equbuf [256];  };   struct f_nam { 
  int    type;   struct lnmlookup_name s_nam;   struct f_equ *equ_ptr;   char   tabbuf [32];  char   nambuf [256];  };   /***  ***/   F /* Small example program to show the usage of the SYS$LNMLOOKUP systemG    service. It also shows you how to sort the returned names (using the     OpenVMS SORT/MERGE utility).  */   main (int argc, char** argv) { $  char equbuf [256], cmp_tabbuf [32];    short lrl, keybuf [18];  '  int stat, opts, names = 0, tables = 0;     unsigned int contxt [4];   !  $DESCRIPTOR (lognam, in_logbuf);   !  $DESCRIPTOR (tabnam, in_tabbuf);     $DESCRIPTOR (rec, equbuf);     struct lnmlookup_equi equ;     struct f_nam nam;    struct f_equ *e_ptr, *e_last;   /***  ***/   (  /* Perform some initialization tasks */  &  contxt [0] = 0;				/* Init context */  ,  f_out = stdout;				/* Set default stdout */  :  if (!get_args (argc, argv)) return 1;		/* Get all args */  J  lognam.dsc$w_length = strlen (in_logbuf);	/* Setup descriptors used as */D  tabnam.dsc$w_length = strlen (in_tabbuf);	/* input to $LNMLOOKUP */  K  nam.s_nam.LNMLOOKUP$A_TABSTR = nam.tabbuf;	/* Setup string addresses in */ L  nam.s_nam.LNMLOOKUP$A_NAMSTR = nam.nambuf;	/* name and equivalence block */!  equ.LNMLOOKUP$A_EQUSTR = equbuf;   A  rec.dsc$w_length = sizeof nam;			/* Setup descriptor for SORT */ 2  rec.dsc$a_pointer = (char*) &nam;		/* routines */  ,  /* Setup key descriptor fort SORT routines.     Number of keys: 4 */    keybuf [0] = 4;  "  /* First key: Type of name table:     0: process-private; "     1: process-private, directory;     2: shareable;      3: shareable, directory. */   6  keybuf [1] = DSC$K_DTYPE_L;			/* Type of sort data */3  keybuf [2] = 0;				/* 0=ascending, 1=descending */ 1  keybuf [3] = 0;				/* Offset of key in buffer */ %  keybuf [4] = 4;				/* Size of key */   $  /* Second key: table name string */    keybuf [5] = DSC$K_DTYPE_T;  keybuf [6] = 0;  keybuf [7] = 32;   keybuf [8] = 16;   %  /* Third key: logical name string */     keybuf [9] = DSC$K_DTYPE_T;  keybuf [10] = 0;   keybuf [11] = 64;  keybuf [12] = 20;    /* Last key: access mode */    keybuf [13] = DSC$K_DTYPE_W; 5  keybuf [14] = 1;				/* Reverse (descending) order */ +  keybuf [15] = 10;				/* for access mode */   keybuf [16] = 2;   1  lrl = sizeof nam;				/* Longest record length */   E  opts = SOR$M_MULTI|SOR$M_NOSIGNAL;		/* These are our sort options */   N  if ((stat = sor$begin_sort (keybuf, &lrl, &opts)) != SS$_NORMAL) return stat;! 						/* Initiate sort utility */   K  memset (nam.tabbuf, 0x20, sizeof nam.tabbuf);	/* Cleanup return buffers */ F  memset (nam.nambuf, 0x20, sizeof nam.nambuf);	/* (for proper sort) */     /* Now call $LNMLOOKUP first */  K  stat = sys$lnmlookup (&in_attrib, &tabnam, &lognam, &in_accmod, &in_index, # 		       contxt, &nam.s_nam, &equ);    /***  ***/   D  /* Obtain name and equivalence information and pass them to sort */    while (stat == SS$_NORMAL)   {  D   /* If this is the next name (NAMLEN > 0), clear equivalence ptr */  D   if (nam.s_nam.LNMLOOKUP$L_NAMLEN) nam.equ_ptr = (struct f_equ*) 0;  E   /* Process equivalence strings. The field nam.equ_ptr points to the E      first equi buffer (usually index 0). This equi buffer contains a H      pointer to the next equi buffer (if one) and all equivalence string)      information for the current index */      if (equ.LNMLOOKUP$L_EQULEN)    { @    e_ptr = malloc (sizeof (struct f_equ));		/* Allocate space */     K    if (e_ptr == (struct f_equ*) 0) return vaxc$errno;	/* Error if failed */   0    e_ptr -> s_equ = equ;				/* Copy equi info */  N    e_ptr -> s_equ.LNMLOOKUP$A_EQUSTR = e_ptr -> equbuf;	/* Setup string ptr */  E    memcpy (e_ptr -> s_equ.LNMLOOKUP$A_EQUSTR, equ.LNMLOOKUP$A_EQUSTR, 4 	   equ.LNMLOOKUP$L_EQULEN);			/* and copy string */  N /* If this is the first equivalence string, set the pointer in the name block,I    else write the address of this equi buffer to the previous equi buffer )    (whose address was saved in e_last) */   =    if (nam.equ_ptr == (struct f_equ*) 0) nam.equ_ptr = e_ptr;   "    else e_last -> equ_ptr = e_ptr;  B    e_ptr -> equ_ptr = (struct f_equ*) 0;		/* Init next equi ptr */  /    e_last = e_ptr;					/* Save this equi add */    } G   /* If the name length is > 0, this is a new name. We must process it. M      Otherwise, only the equi buffer is of interest (we have process already) :      and we can continue with the next call to $LNMLOOKUP.  J      We simply set the type field which is used as primary key in the sortJ      (see initialization part) and pass the record to the sort utility for      further processing    */$   if (nam.s_nam.LNMLOOKUP$L_NAMLEN)    {     /* Setup the type field */   H    nam.type = nam.s_nam.LNMLOOKUP$W_TABATTR & LNMTH$M_SHAREABLE ? 2 : 0;  E    if (nam.s_nam.LNMLOOKUP$W_TABATTR & LNMTH$M_DIRECTORY) nam.type++;   8    /* Now call the sort utility to receive the record */  B    if ((stat = sor$release_rec (&rec)) != SS$_NORMAL) return stat;     }    /* OK, get next name */   L   stat = sys$lnmlookup (&in_attrib, &tabnam, &lognam, &in_accmod, &in_index,$ 		        contxt, &nam.s_nam, &equ);  }A  if (stat != SS$_NOMOREITEMS) return stat;	/* If error, return */   K  if (stat = sor$sort_merge () != SS$_NORMAL) return stat; /* Do the sort */   :  cmp_tabbuf [0] = '\0';				/* Initialize compare table. */   /***  ***/   F  /* Obtain the sorted records and print the containing information. */  7  stat = sor$return_rec (&rec);			/* Get first record */     while (stat == SS$_NORMAL)   {.   if (!in_qui)					/* If -q, skip this part */   { 4    nam.tabbuf [nam.s_nam.LNMLOOKUP$L_TABLEN] = '\0';  I    if (strcmp (nam.tabbuf, cmp_tabbuf))		/* If new table, print header */     {A     strcpy (cmp_tabbuf, nam.tabbuf);		/* Update old table name */   K     fprintf (f_out, "%s\n\nTable \"%s\":\n\n", f_out != stdout ? "\f" : "",  	     nam.tabbuf);       fprintf (f_out, "Logical Name                      MxInd   Mode   Attributes\n--------------------------------------------------------------------------\n");     }D    if (nam.s_nam.LNMLOOKUP$L_NAMLEN > 34)	/* Truncate name string */    {=     nam.nambuf [34] = '|';			/* to 34 chars so it will not */ :     nam.nambuf [35] = '\0';			/* exceed the column size */  F     nam.s_nam.LNMLOOKUP$L_NAMLEN = 34;		/* Update descriptor length */    }O    else nam.nambuf [nam.s_nam.LNMLOOKUP$L_NAMLEN] = '\0'; /* Prepare for output  							     with printf */  4    point (nam.s_nam.LNMLOOKUP$L_NAMLEN, nam.nambuf);  L    fprintf (f_out, "%-34s %4d   %s  %s\n", nam.nambuf, /* Print name info */ 	nam.s_nam.LNMLOOKUP$W_MAXIND,) 	get_mode (nam.s_nam.LNMLOOKUP$W_ACCMOD), . 	get_namattr (nam.s_nam.LNMLOOKUP$W_NAMATTR));  @    if (!in_nam) e_ptr = nam.equ_ptr;		/* Get first equ string */  A    else e_ptr = (struct f_equ*) 0;		/* unless -n was specified */    /***  ***/   L    /* Now print equivalence string information. An equivalence string may be
       one of:   H       o - Normal name string, established with $CRELNM (index = 0...127).       o - A hash function value (index = -128)E       o - A backpointer, created by $CREMBX and $MOUNT (index = -127) ,       o - A name table header (index = -126)  J       For index -128 and -127, we display the translation attributes only;K       for -126, we display the name table attributes. All other indexes are E       displayed as they are, except that non-printable characters are        converted to dots.    */     while (e_ptr)    {-     switch (e_ptr -> s_equ.LNMLOOKUP$W_INDEX)      {       case LNMX$C_HSHFCN:      {B       fprintf (f_out, "     %-42s  %s\n", "(Hash function value)",4 		get_equattr (e_ptr -> s_equ.LNMLOOKUP$W_EQUATTR));         break;      }      case LNMX$C_BACKPTR:       {;       fprintf (f_out, "     %-42s  %s\n", "(Back pointer)", 4 		get_equattr (e_ptr -> s_equ.LNMLOOKUP$W_EQUATTR));         break;      }      case LNMX$C_TABLE:       {9       fprintf (f_out, "     %-42s  %s\n", "(Name Table)", * 	      get_tabattr (e_ptr -> equbuf [0]));       break;      }
      default:       {0       if (e_ptr-> s_equ.LNMLOOKUP$L_EQULEN > 42)       { >        e_ptr -> equbuf [42] = '|';		/* Truncate equivalence */B        e_ptr -> equbuf [43] = '\0';		/* string to 42 characters */  .        e_ptr -> s_equ.LNMLOOKUP$L_EQULEN = 42;       } F       else e_ptr -> equbuf [e_ptr -> s_equ.LNMLOOKUP$L_EQULEN] = '\0';  A       point (e_ptr -> s_equ.LNMLOOKUP$L_EQULEN, e_ptr -> equbuf);   J       /* If we have one equivalence string only, do not display the index,H          otherwise, preceede every equivalence string with its index. */  (       if (nam.s_nam.LNMLOOKUP$W_MAXIND)   K       fprintf (f_out," [%d] %-42s  %s\n", e_ptr -> s_equ.LNMLOOKUP$W_INDEX, E 	 e_ptr -> equbuf, get_equattr (e_ptr -> s_equ.LNMLOOKUP$W_EQUATTR));   ?       else fprintf (f_out, "     %-42s  %s\n", e_ptr -> equbuf, 7 		   get_equattr (e_ptr -> s_equ.LNMLOOKUP$W_EQUATTR));       }     } :     e_ptr = e_ptr -> equ_ptr;			/* Try next equi string */    }   }    /* Update counters */   =   if (nam.s_nam.LNMLOOKUP$W_NAMATTR & LNMB$M_TABLE) tables++;      else names++;   5   stat = sor$return_rec (&rec);			/* Get next name */   }G  if (stat != SS$_ENDOFFILE) return stat;	/* All ok? If not, exit now */   1  stat = sor$end_sort ();			/* Cleanup the sort */   E  /* Print final info. If name table names were listed, print count of E     ordinary names and table names, else print ordinary names only */     if (tables)  N  fprintf (f_out, "\n%d logical Nam%s and %d Name Table Nam%s found.\n", names,? 	   names == 1 ? "e" : "es", tables, tables == 1 ? "e" : "es");   M  else fprintf (f_out, "\n%d Nam%s found.\n", names, names == 1 ? "e" : "es");   '  return SS$_NORMAL;				/* Finish !!! */  }    /***  ***/   $ int get_args (int argc, char** argv) {   char i, opt, *ptr;     if (argc < 2)  {&   printf ("Insufficient arguments\n");     return 0;   }  in_logbuf [0] = '\0';    for (i = 1; i != argc; i++)  {   upper (argv [i]);      if (argv [i] [0] != '-')   {     if (in_logbuf [0])     {%     printf ("Too many parameters\n");   
     return 0;     }    else     {!     strcpy (in_logbuf, argv [i]);   
     continue;     }   }    opt = argv [i] [1];      ptr = &argv [i] [2];     if (*ptr == '=') ptr++;      switch (opt)   {     case 'A':    {     switch (*ptr)      { 1      case 'K': {in_accmod = PSL$C_KERNEL; break;}   /      case 'E': {in_accmod = PSL$C_EXEC; break;}   0      case 'S': {in_accmod = PSL$C_SUPER; break;}  /      case 'U': {in_accmod = PSL$C_USER; break;}   E      default: {printf ("Unknown Access mode: %c\n", *ptr); return 0;}      }      break;      }:    case 'C': {in_attrib |= LNMLOOKUP$M_CASE_BLIND; break;}  8    case 'E': {in_attrib |= LNMLOOKUP$M_ALL_EQUI; break;}  ,    case 'I': {in_index = atoi (ptr); break;}      case 'H':$    case '?': {prt_hlp (); return 0;}  !    case 'N': {in_nam = 1; break;}       case 'O':    {;     if ((f_out = fopen (ptr, "w", "dna=test.out")) == NULL)      { 4      printf ("Error opening output file %s\n", ptr);        return vaxc$errno;      } 
     break;    }9    case 'P': {in_attrib |= LNMLOOKUP$M_SKIP_PROC; break;}   !    case 'Q': {in_qui = 1; break;}   8    case 'S': {in_attrib |= LNMLOOKUP$M_SKIP_SYS; break;}  .    case 'T': {strcpy (in_tabbuf, ptr); break;}  6    case 'X': {in_attrib |= LNMLOOKUP$M_TABLES; break;}      case 'Z':    {(     in_attrib |= LNMLOOKUP$M_CASE_BLIND;  &     in_attrib |= LNMLOOKUP$M_ALL_EQUI;       strcpy (in_tabbuf, "*");  $     in_attrib |= LNMLOOKUP$M_TABLES;  
     break;    }    default:     {+     printf ("Unknown option '-%c'\n", opt);   
     return 0;     }   }   }  if (!in_logbuf [0])  {*   printf ("Missing required parameter\n");     return 0;   };  if (!in_tabbuf [0]) strcpy (in_tabbuf, "LNM$DCL_LOGICAL");   -  if (in_accmod == -1) in_accmod = PSL$C_USER;   
  return 1; }    /***  ***/   " void point (int len, char* buffer) {   while (len--)  0  if (buffer [len] < 0x20 || buffer [len] > 0x7E)    buffer [len] = '.'; }    /***  ***/    void upper (char *ptr) {   do *ptr = _toupper (*ptr);     while (*ptr++); }    /***  ***/   ) char* get_namattr (unsigned short attrib)  {   static char buffer [30];     buffer [0] = '\0';   =  if (attrib & LNMB$M_NO_ALIAS) strcat (buffer, "No_Alias  "); <  if (attrib & LNMB$M_CONFINE)  strcat (buffer, "Confine  ");;  if (attrib & LNMB$M_CRELOG)   strcat (buffer, "CreLog  "); :  if (attrib & LNMB$M_TABLE)    strcat (buffer, "Table  ");=  if (attrib & LNMB$M_NODELETE) strcat (buffer, "NoDelete  ");   5  if (buffer [0]) buffer [strlen (buffer) - 2] = '\0';     else strcpy (buffer, " ");     return buffer;  }    /***  ***/   ) char* get_equattr (unsigned short attrib)  {   static char buffer [30];     buffer [0] = '\0';   ?  if (attrib & LNMX$M_CONCEALED) strcat (buffer, "Concealed  "); >  if (attrib & LNMX$M_TERMINAL)  strcat (buffer, "Terminal  ");  5  if (buffer [0]) buffer [strlen (buffer) - 2] = '\0';     else strcpy (buffer, " ");     return buffer;  }    /***  ***/    char* get_tabattr (char attrib)  {   static char buffer [30];     buffer [0] = '\0';   ?  if (attrib & LNMTH$M_SHAREABLE) strcat (buffer, "Shareable "); >  if (attrib & LNMTH$M_DIRECTORY) strcat (buffer, "Directory");:  if (attrib & LNMTH$M_GROUP)     strcat (buffer, "Group");;  if (attrib & LNMTH$M_SYSTEM)    strcat (buffer, "System");   1  if (buffer [0]) buffer [strlen (buffer)] = '\0';     else strcpy (buffer, " ");     return buffer;  }    /***  ***/   # char* get_mode (unsigned char mode)  {   static char buffer [6];    switch (mode)  {7   case PSL$C_USER:   {strcpy (buffer, "User "); break;}   7   case PSL$C_SUPER:  {strcpy (buffer, "Super"); break;}   7   case PSL$C_EXEC:   {strcpy (buffer, "Exec "); break;}   7   case PSL$C_KERNEL: {strcpy (buffer, "Krnl "); break;}   (   default: sprintf (buffer, "%d", mode);  }  return buffer;  }    /***  ***/    void prt_hlp ()  { F  printf ("\nLOOKUP - returns information about logical name(s).\n\n");5  printf ("Syntax: lnmlookup <name> [<opts...>]\n\n"); >  printf ("  <name>...logical name (may contain wildcards)\n");)  printf ("  <opts>...one or more of:\n"); O  printf ("   -a<acmod>...select names with same or higher access mode only\n"); <  printf ("   -c..........perform case-blind translation\n");=  printf ("   -e..........display all equivalence strings\n"); 4  printf ("   -h or -?....display this help page\n");H  printf ("   -i<index>...display equivalence string with this index\n");F  printf ("   -n..........list names only (no equivalence strings)\n");4  printf ("   -o<file>....write output to <file>\n");9  printf ("   -p..........skip per-process hash table\n"); N  printf ("   -q..........quiet mode (display count of matched names only)\n");9  printf ("   -s..........skip system-wide hash table\n"); N  printf ("   -t<table>...use names in this name table (wildcards allowed)\n");L  printf ("   -x..........display info for name table names additionally\n");=  printf ("   -z..........same as -c -e -t* -x together\n\n"); L  printf ("   Options -e, -i, -n, -z and -t, -z are mutually exclusive\n\n");  printf ("Help complete.\n\n");s } 