 /* **++ **  FACILITY:	MMK_COMPILE_RULES  **K **  ABSTRACT:	Code to generate the C code for the initialization structures  **  	    	for compiled rules.  ** **  MODULE DESCRIPTION:  **> **  	Generates C structure definitions for symbols, rules, and< **  suffixes for use as the default rules compiled into MMK. ** **  AUTHOR: 	    M. Madison P **  	    	    COPYRIGHT  1993,1996,1998 MADGOAT SOFTWARE.  ALL RIGHTS RESERVED. ** **  CREATION DATE:  30-APR-1993  ** **  MODIFICATION HISTORY:  **1 **  	30-APR-1993 V1.0    Madison 	Initial coding. ; **  	04-JUN-1993 V1.1    Madison 	Add default rule support. 7 **  	22-DEC-1996 V1.2    Madison 	Support for MMK V3.6. 2 **  	27-DEC-1998 V1.2-1  Madison 	General cleanup. **-- */
 #ifdef __DECC   #pragma module GENSTRUC "V1.2-1" #else  #module GENSTRUC "V1.2-1"  #endif #include "mmk.h" #include "globals.h" #include <stdio.h>   /* **  Forward declarations */-     void Generate_Structures(char *, char *); +     static void fix_string(char *, char *);    /* **  External references  */%     extern char *Version, *Copyright;   F #define PUT(str) {char *cp = (str); file_write(unit, cp, strlen(cp));}     /* **++  **  ROUTINE:	Generate_Structures ** **  FUNCTIONAL DESCRIPTION:  **> **  	Generates C structure definitions for symbols, rules, and< **  suffixes for use as the default rules compiled into MMK. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **- **  	Generate_Structures(char *in, char *out)  **1 **  in:	    ASCIZ_string, read only, by reference 1 **  out:    ASCIZ_string, read only, by reference  **5 **  IMPLICIT INPUTS:	suffixes, rules, global_symbols.  ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */7 void Generate_Structures(char *infile, char *outfile) {   J     static $DESCRIPTOR(hdr1, "** generated by MMK_COMPILE_RULES !AD !%D");C     char tmp[256], tmp2[256], tmp3[256], tmp4[256], tmp5[256], *cp;      struct dsc$descriptor dsc;     struct SYMBOL *sym;      struct RULE *rule, *xrule;     struct CMD *cmd;     struct SFX *sfx;     FILEHANDLE unit;     unsigned int status;%     int i, j, realcount, lastrealidx;        INIT_DYNDESC(dsc);       if (outfile[0] == '\0') {       	cp = "MMK_DEFAULT_RULES.H";     } else {     	cp = outfile;     }   (     status = file_create(cp, &unit, "");&     if (!OK(status)) lib$stop(status);  '     status = file_write(unit, "/*", 2); =     lib$sys_fao(&hdr1, 0, &dsc, strlen(Version), Version, 0); C     status = file_write(unit, dsc.dsc$a_pointer, dsc.dsc$w_length); !     strcpy(tmp, "** from file ");      strcat(tmp, infile);0     status = file_write(unit, tmp, strlen(tmp));     strcpy(tmp, "** ");      strcat(tmp, Copyright); 0     status = file_write(unit, tmp, strlen(tmp));'     status = file_write(unit, "*/", 2); %     status = file_write(unit, "", 0);   ,     PUT("static struct SFX sfx_init[] = {");F     for (sfx = suffixes.flink, i = 0; sfx != (struct SFX *) &suffixes;"     	    	sfx = sfx->flink, i++) {5     	static $DESCRIPTOR(fao, "    !AD{0,0,\"!AD\"}"); !     	fix_string(sfx->value, tmp); D     	lib$sys_fao(&fao, 0, &dsc, (i > 0 ? 1 : 0), (i > 0 ? "," : ""),     	    strlen(tmp), tmp); D     	status = file_write(unit, dsc.dsc$a_pointer, dsc.dsc$w_length);     }      PUT("};");2     sprintf(tmp, "#define SFX_INIT_COUNT  %d", i);
     PUT(tmp);   0     PUT("static struct SYMBOL gsym_init[] = {");
     i = 0;/     for (j = 0; j < MMK_K_SYMTABLE_SIZE; j++) { /     	for (sym = global_symbols.symlist[j].head; >     	    	sym != (struct SYMBOL *) &global_symbols.symlist[j];     	    	sym = sym->flink) { A     	    static $DESCRIPTOR(fao, "    !AD{0,0,\"!AD\",\"!AD\"}"); $     	    fix_string(sym->name, tmp);&     	    fix_string(sym->value, tmp2);H     	    lib$sys_fao(&fao, 0, &dsc, (i > 0 ? 1 : 0), (i > 0 ? "," : ""),0     	    	strlen(tmp), tmp, strlen(tmp2), tmp2);H     	    status = file_write(unit, dsc.dsc$a_pointer, dsc.dsc$w_length);     	    i += 1;     	}     }      PUT("};");3     sprintf(tmp, "#define GSYM_INIT_COUNT  %d", i); 
     PUT(tmp);   $     for (xrule = rules.flink, i = 0;*     	    	xrule != (struct RULE *) &rules;!     	    	xrule = xrule->flink) { 7     	for (rule = xrule; rule != 0; rule = rule->next) { 3     	    if (rule->cmdque.flink != &rule->cmdque) { B     	    	sprintf(tmp, "static struct CMD cmdq_init_%d[] = {", i);     	    	PUT(tmp); E     	    	for (cmd = rule->cmdque.flink, j = 0; cmd != &rule->cmdque; '     	    	    	cmd = cmd->flink, j++) { D     	    	    static $DESCRIPTOR(fao, "    !AD{0,0,0X!XL,\"!AD\"}");(     	    	    fix_string(cmd->cmd, tmp);M     	    	    lib$sys_fao(&fao, 0, &dsc, (j > 0 ? 1 : 0), (j > 0 ? "," : ""), -     	    	    	cmd->flags, strlen(tmp), tmp); M     	    	    status = file_write(unit, dsc.dsc$a_pointer, dsc.dsc$w_length);      	    	}      	    	PUT("};");!     	    	rule->cmdque.flags = j; (     	    	rule->cmdque.cmd = (char *) i;     	    	i += 1; 
     	    }     	}     }        if (default_rule != 0) {?     	if (default_rule->cmdque.flink != &default_rule->cmdque) { A     	    sprintf(tmp, "static struct CMD cmdq_init_%d[] = {", i);      	    PUT(tmp);T     	    for (cmd = default_rule->cmdque.flink, j = 0; cmd != &default_rule->cmdque;&     	    	    cmd = cmd->flink, j++) {@     	    	static $DESCRIPTOR(fao, "    !AD{0,0,0X!XL,\"!AD\"}");$     	    	fix_string(cmd->cmd, tmp);I     	    	lib$sys_fao(&fao, 0, &dsc, (j > 0 ? 1 : 0), (j > 0 ? "," : ""), ,     	    	    cmd->flags, strlen(tmp), tmp);I     	    	status = file_write(unit, dsc.dsc$a_pointer, dsc.dsc$w_length); 
     	    }     	    PUT("};"); (     	    default_rule->cmdque.flags = j;/     	    default_rule->cmdque.cmd = (char *) i;      	    i += 1;     	}     }   .     PUT("static struct RULE rule_init[] = {");0     for (xrule = rules.flink, i = realcount = 0;*     	    	xrule != (struct RULE *) &rules;.     	    	xrule = xrule->flink, realcount++) {y     	static $DESCRIPTOR(fao, "    !AD{0,0,(struct RULE *) !UL,0,!UL,!UL,\"!AD\",\"!AD\",\"!AD\",\"!AD\",{!AD,0,!UL,0}}");      	lastrealidx = i; 7     	for (rule = xrule; rule != 0; rule = rule->next) { J     	    sprintf(tmp, "(void *)&cmdq_init_%d[0]", (int) rule->cmdque.cmd);%     	    fix_string(rule->src, tmp2); %     	    fix_string(rule->trg, tmp3); (     	    fix_string(rule->srcpfx, tmp4);(     	    fix_string(rule->trgpfx, tmp5);H     	    lib$sys_fao(&fao, 0, &dsc, (i > 0 ? 1 : 0), (i > 0 ? "," : ""),$     	    	(rule->next == 0 ? 0 : 1),+     	    	rule->srcpfxlen, rule->trgpfxlen, 0    	    	strlen(tmp2), tmp2, strlen(tmp3), tmp3,1     	    	strlen(tmp4), tmp4, strlen(tmp5), tmp5, B     	    	(rule->cmdque.flink == &rule->cmdque ? 0 : strlen(tmp)),;     	    	(rule->cmdque.flink == &rule->cmdque ? "" : tmp), J     	    	(rule->cmdque.flink == &rule->cmdque ? 0 : rule->cmdque.flags));H     	    status = file_write(unit, dsc.dsc$a_pointer, dsc.dsc$w_length);
     	    i++;      	}     }      PUT("};");3     sprintf(tmp, "#define RULE_INIT_COUNT  %d", i); 
     PUT(tmp); @     sprintf(tmp, "#define RULE_INIT_COUNT_REAL  %d", realcount);
     PUT(tmp); @     sprintf(tmp, "#define RULE_REAL_LAST_IDX  %d", lastrealidx);
     PUT(tmp);      if (default_rule != 0) {C     	static $DESCRIPTOR(fao, "    0,0,0,0,0,0,0,0,{!AD,0,!UL,0}}"); *     	PUT("#define DEFAULT_RULE_EXISTS 1");5     	PUT("static struct RULE default_rule_init = {"); N     	sprintf(tmp, "(void *)&cmdq_init_%d[0]", (int) default_rule->cmdque.cmd);     	lib$sys_fao(&fao, 0, &dsc, Q     	    (default_rule->cmdque.flink == &default_rule->cmdque ? 0 : strlen(tmp)), J     	    (default_rule->cmdque.flink == &default_rule->cmdque ? "" : tmp),a     	    (default_rule->cmdque.flink == &default_rule->cmdque ? 0 : default_rule->cmdque.flags)); D     	status = file_write(unit, dsc.dsc$a_pointer, dsc.dsc$w_length);     }        file_close(unit);        return;    } /* Generate_Structures */    /* **++ **  ROUTINE:	fix_string  ** **  FUNCTIONAL DESCRIPTION:  **B **  	Fixes up special characters appearing in character strings by" **  quoting them with a backslash. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **$ **  	fix_string(char *in, char *out) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */- static void fix_string(char *in, char *out) {        register char *cp, *cp1;  )     for (cp = in, cp1 = out; *cp; cp++) { 2     	if (*cp == '\\' || *cp == '"') *cp1++ = '\\';     	*cp1++ = *cp;     }      *cp1 = '\0';       return;    } /* fix_string */