 /*#         Defintions for LISTEN table   ; 	Any changes or bugs contact me at miller@encompasserve.org     COPYRIGHT NOTICE   5  This software is COPYRIGHT  1997,2005, Ian Miller.    D  This software released under the license described in aaareadme.txt    DISCLAIMER   J  This software is provided "AS IS". The author makes no representations orN  warranties with respect to the software and specifically disclaim any impliedE  warranties of merchantability or fitness for any particular purpose.    History	 ======= - 29-Jan-1997,2005 I.Miller  V1.0-000  Created. C 04-Feb-1997,2005 I.Miller  V1.0-001  Add IEE802E MOP SYSID message. 8 21-Mar-1997,2005 I.Miller  V1.0-002  Add name subrecord.L 09-Apr-1997,2005 I.Miller  V1.0-003  Add node timestamp. Mop message buffersJ                                 now allocated at run time. Add node index.@                                 Add LAVC group to address table.C 14-Apr-1997,2005 I.Miller  V1.0-004  Add node attributes subrecord. = 24-Apr-1997,2005 I.Miller  V1.0-005  Add routes and services. = 06-Jun-1997,2005 I.Miller  V1.0-006  Add more stuff about SMB R 17-Jun-1997,2005 I.Miller  V1.0-007  Add timestamps to address,service,route,name. */   #define MAX_NODES       1000 #define MAX_PROTOCOLS	30 #define MAX_ADDRESSES   20 #define MAX_NAMES       20 #define MAX_ROUTES      100  #define MAX_SERVICES    40   #define NODE_BUFSIZE 1500    /* format of protocol entry	*/
 typedef union  {  	struct  	{/ 		unsigned char format;	/* ethernet,802,802e	*/ * 		unsigned short type;	/* protocol type	*/K                 unsigned short time[4]; /* when this protocol was seen   */  	} ethernet_protocol;  	struct  	{/ 		unsigned char format;	/* ethernet,802,802e	*/   		unsigned char sap;	/* SAP			*/K                 unsigned short time[4]; /* when this protocol was seen   */  	} iee802_protocol;  	struct  	{/ 		unsigned char format;	/* ethernet,802,802e	*/ * 		unsigned char pid[5];	/* protocol ID		*/K                 unsigned short time[4]; /* when this protocol was seen   */  	} iee802e_protocol; } PROTOCOL;    typedef struct { 5 	unsigned char	type;		/* type - IP,DECNET,IPX etc 	*/ 6 	unsigned char	addr[10];	/* address - format varies	*/J         unsigned short time[4];         /* when this address was seen   */
 } ADDRESS;  " /* route data for a IPX route   */ typedef struct { J         unsigned long network;          /* IPX network number           */J         unsigned short hops;            /* number of hops               */J         unsigned short ticks;           /* how long it takes            */ } ROUTE_IPX;   typedef struct { J         unsigned short  id;     /* node address (area and node)         */         unsigned short cost;         unsigned short hops; } ROUTE_DECNET;    typedef struct { J         unsigned char addr[4];  /* IP address                           */C         long metric;   		/* routing metric value                 */  } ROUTE_IP;    typedef struct { J         unsigned char addr[4];  /* IP address                           */J         unsigned char mask[4];  /* subnet mask                          */< 	long metric;   		/* routing metric value                 */ } ROUTE_IP2;   typedef struct { P         unsigned char   type;           /* route type                         */P                                         /* route data                         */
         union 	         {                  void *data;                  ROUTE_IPX *ipx; #                 ROUTE_DECNET *dnet;          }r; P         unsigned short rlen;            /* route data length                  */H         unsigned short time[4];         /* when this route was seen   */ } ROUTE;   /* service definition   */ typedef struct {       J         unsigned char   type;           /* service type                 */J         unsigned char   name_len;       /* service name length          */J         unsigned short  data_len;       /* service data length          */J         unsigned short time[4];         /* when this service was seen   */K         char *name;                     /* service name - null terminated*/ J         void *data;                     /* service data                 */
 } SERVICE;   typedef struct { :         unsigned short type;            /* service type */N         unsigned short socket;          /* socket number for this service   */N         unsigned long network;          /* network number                   */N         unsigned char addr[6];          /* address of server                */ } SERVICE_SAP;   typedef struct {          unsigned char   type; !         unsigned char   name_len;           unsigned short  time[4];"         char            name[256]; } NAME;   " /* format of node table entry   */ typedef struct { P         unsigned long attributes;               /* node attributes            */D 	PROTOCOL protocols[MAX_PROTOCOLS];	/* protocols used by this node*/C 	ADDRESS addresses[MAX_ADDRESSES];	/* addresses used by this node*/ P         NAME names[MAX_NAMES];                  /* names used by this node    */P         ROUTE routes[MAX_ROUTES];               /* routes advertised          */P         SERVICE services[MAX_SERVICES];         /* services advertising       */P         unsigned char *mop_sysid;               /* last seen MOP SYSID msg    */P         unsigned char *mope_sysid;              /* IEE802E MOP SYSID msg      */P         unsigned short index;                   /* node table index           */P         unsigned short mop_sysid_length;        /* size of mop_sysid msg      */P         unsigned short mope_sysid_length;       /* size of mope_sysid msg     */P         unsigned short time[4];                 /* time of last message       */P         unsigned short mop_sysid_time[4];       /* when it was received       */P         unsigned short mope_sysid_time[4];     	/* when it was received       */P         unsigned char addr[6];                  /* ethernet address           */P         unsigned char inuse;                    /* TRUE if entry in use       */ } NODE;    extern NODE nodes[MAX_NODES];   * /* LISTEN_TABLE file record types       */N /* each record starts with a one byte record type and may contain subrecords*/  $ #define LT_NODE_RECORD          0x01J /* each node record has a 6 byte ethernet address after the record type */J /* followed by various subrecords                                       */J /* each subrecord starts with a one byte sub-record type, followed by   */J /* a two byte length of the following data (not including the type or   */J /* the sub record length itself).                                       */  : /* LISTEN_TABLE file node record sub-record types       */  * /* MOP SYSID message sub-record         */( #define LT_NODE_MOPSYSID        0x10    J /* this consists of the last MOP SYSID message seen from this node      */J /* preceeded by the time it arrived as VMS format binary time           */  * /* IEE 802E MOP SYSID message sub-record*/' #define LT_NODE_MOPESYSID      0x11     L /* this consists of the last IEE802E MOP SYSID message seen from this node*/J /* preceeded by the time it arrived as VMS format binary time           */E /* This is a seperate record as some nodes broadcast ethernet and 	*/  /* IEE802E SYSID    							*/   * /* protocols sub record                 */) #define LT_NODE_PROTOCOLS       0x20      J /* this consists of one or more protocol defintions recording the       */J /* protocols that this node has been seen to use                        */J /* each protocol defintion consists of a byte indicating the frame      */J /* format followed by the defintion of the protocol                     */J /* followed by a vms format datetime of when the protocol was last seen */B #define LT_PROTOCOL_UNUSED      0       /* unused table entry   */J /* ethernet frame format protocols - two byte protocol type             */$ #define LT_PROTOCOL_ETH         0x21J /* IEE 802.3 format - followed by one byte SAP                          */$ #define LT_PROTOCOL_802         0x22J /* IEE 802.2 format - followed by five byte protocol ID                 */$ #define LT_PROTOCOL_802E        0x23  " /* addresses sub-record         */$ #define LT_NODE_ADDRESSES       0x31J /* these consist of a address type byte followed by the address         */J /* which is two bytes for a DECnet address and 4 bytes for IP           */  /* and 10 bytes for IPX							*/J /* followed by vms time stamp                                           */J /* these contain the protocol specific addresses used by this node      */J #define LT_ADDRESS_UNUSED       0       /* unused table entry           */* /* DECnet - two byte DECnet address     */$ #define LT_ADDRESS_DECNET       0x32! #define LT_ADDRESS_DECNET_LEN   2 * /* IP - 4 byte IP address               */$ #define LT_ADDRESS_IP           0x33$ #define LT_ADDRESS_IP_LEN       4   0 /* IPX - 4 byte network, 6 bytes node address	*/ #define LT_ADDRESS_IPX		0x34$ #define LT_ADDRESS_IPX_LEN      10  * /* LAVC - 2 byte cluster group number   */# #define LT_ADDRESS_LAVC        0x35 ! #define LT_ADDRESS_LAVC_LEN     2   " /* names sub-record             */$ #define LT_NODE_NAMES           0x41J /* these contain any names that the has used. Each name is preceeded by */J /* a name type and a one byte length then the name.                     */! #define LT_NAME_UNUSED          0 C #define LT_NAME_DECNET          0x42    /* DECnet nodename      	*/ C #define LT_NAME_IP              0x43    /* IP nodename          	*/ J #define LT_NAME_NETBUEI         0x44    /* name from NetBuei protocol   */C #define LT_NAME_SYSID           0x45    /* name from MOP sysid  	*/ C #define LT_NAME_LAT_NODE        0x46    /* LAT node name        	*/ C #define LT_NAME_LAT_DESC        0x47    /* LAT node description 	*/ J #define LT_NAME_LAST            0x48    /* Local Area System Transport  */2 #define LT_NAME_NETBIOS		0x49	/* NetBIOS name			*/@ #define LT_NAME_NETBIOSG	0x4A	/* NetBIOS group name           */J #define LT_NAME_DHCP            0x4b    /* Host name from DHCP request  */J #define LT_NAME_WORKGROUP       0x4c    /* WORKGROUP name               */J #define LT_NAME_NOVELLP         0x4d    /* Novell Printer               */  " /* node timestamp subrecord     */$ #define LT_NODE_TIMESTAMP       0x51J /* This is the time of the last message of any type seen for this node. */J /* This contains a VMS format timestamp after the subrecord len.        */  " /* node attributes subrecord    */$ #define LT_NODE_ATTRIBUTES      0x61B /* this is a bitmask - these values define the bit numbers      */= #define LT_NODE_ATT_BRIDGE      0       /* is a bridge     */ K #define LT_NODE_ATT_DECNETL1    1       /* is DECnet Level 1 router      */ K #define LT_NODE_ATT_DECNETL2    2       /* is DECnet Level 1 router      */ K #define LT_NODE_ATT_IPROUTER    3       /* is a IP router                */ P #define LT_NODE_ATT_IPX8023     4       /* has send IPX msgs with no 802.2 hdr*/J #define LT_NODE_ATT_IPDEFAULT   5       /* advertises default IP route  */J #define LT_NODE_ATT_BOOTPC      6       /* node is BOOTP/DHCP client    */J #define LT_NODE_ATT_LAST_SERVER 7       /* node is LAST server          */J #define LT_NODE_ATT_LAST_CLIENT 7       /* node is LAST client          */J #define LT_NODE_ATT_IPXROUTER   8       /* node is IPX router           */J #define LT_NODE_ATT_BOOTPS      9       /* node is BOOTP/DHCP server    */> #define LT_NODE_ATT_MSTBROWSER	10	/* node is master browser	*/J #define LT_NODE_ATT_NAMESERVER  11      /* node is name server          */  ? /* node route sub record - there may be serveral of these    */ $ #define LT_NODE_ROUTE           0x70J /* the contents of these is defined by the ROUTE_xxx structures above   */! #define LT_ROUTE_UNUSED         0 $ #define LT_ROUTE_DECNET_AREA    0x71$ #define LT_ROUTE_DECNET_NODE    0x72$ #define LT_ROUTE_IPX            0x73$ #define LT_ROUTE_IP             0x74$ #define LT_ROUTE_IP2            0x75  N /* node service subrecord - there may be several of these - one per service */$ #define LT_NODE_SERVICE         0x80J /* these consist of 1 byte service type, one byte service name length   */J /* service name, then parhaps service data if                           */' #define LT_SERVICE_UNUSED       0x00    J #define LT_SERVICE_LAT          0x81    /* LAT service                  */J #define LT_SERVICE_LAST         0x82    /* LAST service                 */J #define LT_SERVICE_SAP          0x83    /* Novell SAP annouced service  */  O /* end of file record - contins a VMS format datetime after the record type  */ J /* and is used to check the table was completely written                */ #define LT_EOF_RECORD   0xff   #define MAX_RECORD_LEN  5000   /* functions    */  # int find_node(unsigned char *addr); " int add_node(unsigned char *addr); void write_table(void);  void read_table(void);: void add_protocol_eth(int node_index,unsigned short type);8 void add_protocol_802(int node_index,unsigned char sap);: void add_protocol_802e(int node_index,unsigned char *pid);? void add_address(int node_index,unsigned addr_type,void *addr); S void add_name(int node_index,unsigned name_type,char *name,unsigned char name_len); K void save_mop_message(int node_index,unsigned char *msg,unsigned short len,           unsigned short time[4]);L void save_mope_message(int node_index,unsigned char *msg,unsigned short len,          unsigned short time[4]);8 void add_attribute(int node_index,unsigned char attrib);8 void display_attributes(FILE *fpOut,unsigned long attr);G void add_route(int n,unsigned char type,unsigned short len,void *data); L void add_service(int n,unsigned char type,char *name,unsigned char name_len,,         void *data, unsigned char data_len);A int find_node_by_address(unsigned char *addr,unsigned char type);   < #define TEST_ATTRIBUTE(attmask,attno) ((1<<attno) & attmask)   /* define logging mask  */ #define LT_LOG_NEWNODE 0x01  #define LT_LOG_NEWADDR 0x02  #define LT_LOG_NEWNAME 0x04  #define LT_LOG_NEWATTR 0x08  #define LT_LOG_NEWPROT 0x10  #define LT_LOG_NEWROUTE 0x20 #define LT_LOG_NEWSERVICE 0x40! #define LT_LOG_ALL     0xffffffff    extern unsigned long log_mask;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              