 /*!         Routines for LISTEN table   5 	Any changes or bugs contact miller@encompasserve.org     COPYRIGHT NOTICE   5  This software is COPYRIGHT  1997,2005, Ian Miller.    3  Released under licence described in aaareadme.txt      DISCLAIMER   J  This software is provided "AS IS". The author makes no representations orN  warranties with respect to the software and specifically disclaim any impliedE  warranties of merchantability or fitness for any particular purpose.    History	 ======= ( 29-Jan-1997 I.Miller  V1.0-000  Created.= 04-Feb-1997 I.Miller  V1.0-001	Add IEE802E MOP SYSID message. * 21-Mar-1997 I.Miller  V1.0-002  Add names.G 09-Apr-1997 I.Miller  V1.0-003  Add node timestamp. Mop message buffers J                                 now allocated at run time. Add node index.@                                 add_node now checks table first.C                                 Fix stupid bug in loading of names. C 14-Apr-1997 I.Miller  V1.0-004	Don't load null IP or IPX addresses. 4                                 Add node attributes./ 17-Jun-1997 I.Miller  V1.0-005  Add timestamps. B 04-Jul-2005 I.Miller  V1.0-006	Tidy code a little for new compiler */   #define VERSION "V1.0-006"
 #if __DECC# #pragma module LISTEN_TABLE VERSION  #else  #module LISTEN_TABLE VERSION   #endif   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <unixio.h>  #include <file.h>  #include <assert.h>  #include <descrip.h> #include "listen_table.h"  #include "listen_subs.h"   NODE nodes[MAX_NODES];   unsigned long log_mask;   0 static int write_node_record(int fd,NODE *node);G static void read_node_record(unsigned char *record,int len,NODE *node); $ static int write_eof_record(int fd);; static void read_eof_record(unsigned char *record,int len);  static unsigned long rno;    /*J         find_node - lookup node by address and return table index if known                 or -1 if not.  */ int  find_node(unsigned char *addr) {          int n;  %         for (n=0; n < MAX_NODES; n++) 	         { #                 if (nodes[n].inuse)                  { 9                         if ((addr[0] == nodes[n].addr[0]) 9                         &&  (addr[1] == nodes[n].addr[1]) 9                         &&  (addr[2] == nodes[n].addr[2]) 9                         &&  (addr[3] == nodes[n].addr[3]) 9                         &&  (addr[4] == nodes[n].addr[4]) :                         &&  (addr[5] == nodes[n].addr[5]))                         { &                                 break;                         }                  }                  else                 { M                         n = MAX_NODES;  /* exit loop on first unused entry */                  } 	         }          if (n < MAX_NODES)                 return n;          else                 return -1; }    /*5         add_node - add node to table and return index  */ int  add_node(unsigned char *addr)  {          int n, first_free;  %         for (n=0; n < MAX_NODES; n++) 	         { #                 if (nodes[n].inuse)                  { 9                         if ((addr[0] == nodes[n].addr[0]) 9                         &&  (addr[1] == nodes[n].addr[1]) 9                         &&  (addr[2] == nodes[n].addr[2]) 9                         &&  (addr[3] == nodes[n].addr[3]) 9                         &&  (addr[4] == nodes[n].addr[4]) :                         &&  (addr[5] == nodes[n].addr[5]))                         { :                                 break;  /* eureka !     */                         }                  }                  else                 { B                         /* exit loop on first free entry        */'                         first_free = n; :                         n = -1; /* indicate not found   */                         break;                 } 	         } (         if ((n >= 0) && (n < MAX_NODES))	         { 2                 /* already in table at index n  */	         }          else if (n == -1) 	         { 4                 /* add entry at offset first_free */                 n = first_free; A                 memcpy(nodes[n].addr,addr,sizeof(nodes[0].addr)); &                 nodes[n].inuse = TRUE;  		if (log_mask & LT_LOG_NEWNODE) 		{ ) 			printf("%%LISTEN-I-NEWNODE, Adding ");  			display_addr(stdout,addr);  			putchar('\n');  		} 	         }          else	         { 2                 n = -1; /* indicate table full  */3 		printf("%%LISTEN-E-TFULL, Node table is full\n"); 	         }          return n;  }      /*;         write_table - write node table to file LISTEN_TABLE  */ void   write_table(void)  {  	int fd;
 	int n,count; $         char filespec[256], mrs[30];  "         /* open the file        */& 	sprintf(mrs,"mrs=%d",MAX_RECORD_LEN);B 	fd = creat("LISTEN_TABLE",0,"rfm=var","dna=.DATA","ctx=bin",mrs);         if (fd > 0) 	         { .         	for (n=0,count=0; n < MAX_NODES; n++)
         	{         		if (nodes[n].inuse)          		{  #if 0 * 				printf("writing record %d\n",count+1); #endif  +         			write_node_record(fd,&nodes[n]);  #if 0  				printf("\n");  #endif(                                 count++;         		} 
         	}         	write_eof_record(fd);%                 getname(fd,filespec);          	close(fd);                  if (count > 0)                 { :                         /* tell user how much we know   */T                         printf("%%LISTEN -- %d nodes saved to %s\n",count,filespec);                 }                  else                 { :                         /* no nodes so delete file      */)                         delete(filespec);                  } 	         }          else	         { ;                 perror("failed to open LISTEN_TABLE file"); 	         }  }    /*I         read_table - clear node table then load it from LISTEN_TABLE file  */ void   read_table(void) {  	int fd; 	int n, eof_record_seen,rlen; & 	unsigned char record[MAX_RECORD_LEN]; 	char filespec[256],mrs[30];  %         for (n=0; n < MAX_NODES; n++) 	         { 5                 memset(&nodes[n],0,sizeof(nodes[n])); '                 nodes[n].inuse = FALSE; #                 nodes[n].index = n; 	         }          & 	sprintf(mrs,"mrs=%d",MAX_RECORD_LEN);H 	fd = open("LISTEN_TABLE",O_RDONLY,"rfm=var","dna=.DATA","ctx=bin",mrs); 	if (fd > 0) 	{ 		eof_record_seen = FALSE;                 n = 0;                 rno = 0;3 		while ((rlen=read(fd,record,sizeof(record))) > 0)  		{                          rno++; 			switch(record[0]) 			{ 			case LT_NODE_RECORD: , 				read_node_record(record,rlen,&nodes[n]); 				n++;
 				break; 			case LT_EOF_RECORD:! 				read_eof_record(record,rlen);  				eof_record_seen = TRUE; &                                 break;                          default:/                                 fprintf(stderr, l                                         "%%LISTEN-E-UNKRECTY, unknown record number %u type %d length %d\n",<                                         rno,record[0],rlen); 			} 		}  		getname(fd,filespec);          	close(fd); @ 		printf("%%LISTEN-I-NREAD %d nodes read from %s\n",n,filespec); 		if (!eof_record_seen)  		{ K 			printf("%%LISTEN-W-NOEOF, No EOF record seen file may be incomplete\n");  		}  	} }   
 static int$ write_node_record(int fd,NODE *node) { >         unsigned char record[MAX_RECORD_LEN], *p, *sptr, nlen;          unsigned short len,slen;         int i, srno=0; 	unsigned char *x;  "         /* format a node record */#         record[0] = LT_NODE_RECORD; 9         memcpy(&record[1],node->addr,sizeof(node->addr)); *         p = &record[1+sizeof(node->addr)];  *         /* check for MOP SYSID message  */'         if (node->mop_sysid_length > 0) 	         {  #if 0 5 		printf("  subrecord %d offset %d MOP ETH\n",++srno,  			p - &record[0]);  #endif:                 /* format a MOP SYSID subrecord */        J                 *p++ = LT_NODE_MOPSYSID;        /* subrecord type       */L                 len = node->mop_sysid_length + sizeof(node->mop_sysid_time);J                 memcpy(p,&len,2);               /* subrecord length     */                 p += 2;   :                 /* timestamp of MOP SYSID message       */M                 memcpy(p,&node->mop_sysid_time,sizeof(node->mop_sysid_time)); 2                 p += sizeof(node->mop_sysid_time);         :                 /* MOP SYSID message contents           */A                 memcpy(p,node->mop_sysid,node->mop_sysid_length); ,                 p += node->mop_sysid_length;	         }   2         /* check for IEE802E MOP SYSID message  */(         if (node->mope_sysid_length > 0)	         {  #if 0 5 		printf("  subrecord %d offset %d MOP 802\n",++srno,  			p - &record[0]);  #endifB                 /* format a IEE802E MOP SYSID subrecord */        J                 *p++ = LT_NODE_MOPESYSID;      	/* subrecord type       */N                 len = node->mope_sysid_length + sizeof(node->mope_sysid_time);J                 memcpy(p,&len,2);               /* subrecord length     */                 p += 2;   C                 /* timestamp of IEE 802E MOP SYSID message       */ O                 memcpy(p,&node->mope_sysid_time,sizeof(node->mope_sysid_time)); 3                 p += sizeof(node->mope_sysid_time);          C                 /* IEE 802E MOP SYSID message contents           */ C                 memcpy(p,node->mope_sysid,node->mope_sysid_length); -                 p += node->mope_sysid_length; 	         }   2         /* protocols table                      */         slen = 0; !         *p++ = LT_NODE_PROTOCOLS; B         sptr = p;       /* address of place for subrecord len   */         p += 2;   +         for (i = 0; i < MAX_PROTOCOLS; i++) 	         { C                 switch(node->protocols[i].ethernet_protocol.format)                  { (                 case LT_PROTOCOL_UNUSED:                         break;%                 case LT_PROTOCOL_ETH: J                         *p++ = LT_PROTOCOL_ETH; /* subrecord type       */L                         memcpy(p,&node->protocols[i].ethernet_protocol.type,: 			    sizeof(node->protocols[i].ethernet_protocol.type));O                         p += sizeof(node->protocols[i].ethernet_protocol.type); L                         memcpy(p,&node->protocols[i].ethernet_protocol.time,: 			    sizeof(node->protocols[i].ethernet_protocol.time));O                         p += sizeof(node->protocols[i].ethernet_protocol.time);                          break;%                 case LT_PROTOCOL_802: J                         *p++ = LT_PROTOCOL_802; /* subrecord type       */I                         memcpy(p,&node->protocols[i].iee802_protocol.sap, 7 			    sizeof(node->protocols[i].iee802_protocol.sap)); L                         p += sizeof(node->protocols[i].iee802_protocol.sap);J                         memcpy(p,&node->protocols[i].iee802_protocol.time,8 			    sizeof(node->protocols[i].iee802_protocol.time));M                         p += sizeof(node->protocols[i].iee802_protocol.time);                          break;&                 case LT_PROTOCOL_802E:K                         *p++ = LT_PROTOCOL_802E; /* subrecord type       */ J                         memcpy(p,&node->protocols[i].iee802e_protocol.pid,M                             sizeof(node->protocols[i].iee802e_protocol.pid)); M                         p += sizeof(node->protocols[i].iee802e_protocol.pid); K                         memcpy(p,&node->protocols[i].iee802e_protocol.time, N                             sizeof(node->protocols[i].iee802e_protocol.time));N                         p += sizeof(node->protocols[i].iee802e_protocol.time);                         break;                 default:b                         printf("%%LISTEN-E-UNKPFMT, Unknown protocol format %d found for node %d",L                                 node->protocols[i].ethernet_protocol.format,-                                 node->index);                  } 	         }          slen = p - sptr - 2;         if (slen != 0)	         { J                 memcpy(sptr,&slen,2);   /* write subrecord length       */ #if 0 > 		printf("  subrecord %d offset %d len %d protocols\n",++srno, 			sptr - 2 - &record[0],slen);  #endif	         }          else	         { :                 p -= 3; /* remove subrecord header      */	         }   0         /* address table                      */         slen = 0; !         *p++ = LT_NODE_ADDRESSES; B         sptr = p;       /* address of place for subrecord len   */         p += 2;   +         for (i = 0; i < MAX_ADDRESSES; i++) 	         { /                 switch(node->addresses[i].type)                  { '                 case LT_ADDRESS_UNUSED:                          break;'                 case LT_ADDRESS_DECNET: L                         *p++ = LT_ADDRESS_DECNET; /* subrecord type       */:                         memcpy(p,&node->addresses[i].addr,7                                 LT_ADDRESS_DECNET_LEN); 3                         p += LT_ADDRESS_DECNET_LEN; :                         memcpy(p,&node->addresses[i].time,A                                 sizeof(node->addresses[i].time)); =                         p += sizeof(node->addresses[i].time);                          break;#                 case LT_ADDRESS_IP: H                         *p++ = LT_ADDRESS_IP; /* subrecord type       */:                         memcpy(p,&node->addresses[i].addr,3                                 LT_ADDRESS_IP_LEN); /                         p += LT_ADDRESS_IP_LEN; :                         memcpy(p,&node->addresses[i].time,A                                 sizeof(node->addresses[i].time)); =                         p += sizeof(node->addresses[i].time);                          break;$                 case LT_ADDRESS_IPX:.                         *p++ = LT_ADDRESS_IPX;N                         memcpy(p,&node->addresses[i].addr,LT_ADDRESS_IPX_LEN);0                         p += LT_ADDRESS_IPX_LEN;:                         memcpy(p,&node->addresses[i].time,A                                 sizeof(node->addresses[i].time)); =                         p += sizeof(node->addresses[i].time);                          break;%                 case LT_ADDRESS_LAVC: /                         *p++ = LT_ADDRESS_LAVC; O                         memcpy(p,&node->addresses[i].addr,LT_ADDRESS_LAVC_LEN); 1                         p += LT_ADDRESS_LAVC_LEN; :                         memcpy(p,&node->addresses[i].time,A                                 sizeof(node->addresses[i].time)); =                         p += sizeof(node->addresses[i].time);                          break;                 default:_                         printf("%%LISTEN-E-UNKATYP, Unknown address type %d found for node %d", E                                 node->addresses[i].type,node->index);                          break;                 } 	         }          slen = p - sptr - 2;         if (slen != 0)	         { J                 memcpy(sptr,&slen,2);   /* write subrecord length       */ #if 0 > 		printf("  subrecord %d offset %d len %d addresses\n",++srno, 			sptr - 2 - &record[0],slen);  #endif	         }          else	         { :                 p -= 3; /* remove subrecord header      */	         }   -         /* name table                      */          slen = 0;          *p++ = LT_NODE_NAMES; B         sptr = p;       /* address of place for subrecord len   */         p += 2;   '         for (i = 0; i < MAX_NAMES; i++) 	         { :                 if (node->names[i].type != LT_NAME_UNUSED)                 { N                         *p++ = node->names[i].type; /* subrecord type       */7                         nlen = node->names[i].name_len; $                         *p++ = nlen;;                         memcpy(p,node->names[i].name,nlen); J                         p += nlen;      /* advance subrecord ptr        */5                         memcpy(p,node->names[i].time, =                                 sizeof(node->names[i].time)); 9                         p += sizeof(node->names[i].time);                  } 	         }          slen = p - sptr - 2;           if (slen != 0)	         { J                 memcpy(sptr,&slen,2);   /* write subrecord length       */ #if 0 : 		printf("  subrecord %d offset %d len %d names\n",++srno, 			sptr - 2 - &record[0],slen);  #endif	         }          else	         { :                 p -= 3; /* remove subrecord header      */	         }   &         /* timestamp sub-record     */ #if 0 = 	printf("  subrecord %d offset %d len %d timestamp\n",++srno, & 			p - &record[0],sizeof(node->time)); #endifB         *p++ = LT_NODE_TIMESTAMP;       /* subrecord type       */B         *p++ = sizeof(node->time);      /* subrecord len LO byte*/B         *p++ = 0;                       /* subrecord len HI byte*/0         memcpy(p,node->time,sizeof(node->time));          p += sizeof(node->time);  '         /* attributes sub-record     */ "         if (node->attributes != 0)	         {  #if 0 ? 		printf("  subrecord %d offset %d len %d attributes\n",++srno, , 			p - &record[0],sizeof(node->attributes)); #endifJ                 *p++ = LT_NODE_ATTRIBUTES;      /* subrecord type       */J                 *p++ = sizeof(node->attributes);/* subrecord len LO byte*/J                 *p++ = 0;                       /* subrecord len HI byte*/E                 memcpy(p,&node->attributes,sizeof(node->attributes)); .                 p += sizeof(node->attributes);	         }   /         /* routes table                      */ (         for (i = 0; i < MAX_ROUTES; i++)	         { <                 if (node->routes[i].type != LT_ROUTE_UNUSED)                 {  #if 0 ; 			printf("  subrecord %d offset %d",++srno,p- &record[0]);  #endif-                         *p++ = LT_NODE_ROUTE; 8                         slen = node->routes[i].rlen + 1 ?                                 + sizeof(node->routes[i].time);  #if 0 " 			printf(" len %d route\n",slen); #endif*                         memcpy(p,&slen,2);                         p += 2; 4                         *p++ = node->routes[i].type;N                         memcpy(p,node->routes[i].r.data,node->routes[i].rlen);2                         p += node->routes[i].rlen;6                         memcpy(p,node->routes[i].time,>                                 sizeof(node->routes[i].time));:                         p += sizeof(node->routes[i].time);                 } 	         }   1         /* services table                      */ *         for (i = 0; i < MAX_SERVICES; i++)	         { @                 if (node->services[i].type != LT_SERVICE_UNUSED)                 {  #if 0 ; 			printf("  subrecord %d offset %d",++srno,p- &record[0]);  #endif/                         *p++ = LT_NODE_SERVICE; >                         slen = node->services[i].name_len + 2 <                                 + node->services[i].data_lenA                                 + sizeof(node->services[i].time);  #if 0 $ 			printf(" len %d service\n",slen); #endif*                         memcpy(p,&slen,2);                         p += 2; 6                         *p++ = node->services[i].type;:                         *p++ = node->services[i].name_len;8                         memcpy(p,node->services[i].name,<                                 node->services[i].name_len);8                         p += node->services[i].name_len;8                         memcpy(p,node->services[i].time,@                                 sizeof(node->services[i].time));<                         p += sizeof(node->services[i].time);<                         if (node->services[i].data_len != 0)                         { @                                 memcpy(p,node->services[i].data,D                                         node->services[i].data_len);@                                 p += node->services[i].data_len;                         }                  } 	         }   "         /* total record length  */          len = p - &record[0];    #if 0  	printf(" total len %d",len);  #endif&         if (write(fd,record,len) <= 0)	         { /                 perror("Error writing record");                  return FALSE; 	         }          else	         {                  return TRUE;	         }  }    static void = read_node_record(unsigned char *record,int reclen,NODE *node)  {          short nroute,nservice;         short len,i,slen, n;         short sslen, *tptr; 4         unsigned char *p, type, *q, nlen,ntype, *qs;         unsigned long srno;   *         /* read the node address        */9         memcpy(node->addr,&record[1],sizeof(node->addr));  	node->inuse = TRUE;           nroute = 0;          nservice = 0;          srno = 0;          *         /* scan the subrecords          */B         i = 1 + sizeof(node->addr);     /* sizeof record header */5         for (len = reclen-i,p = &record[i]; len > 0;) 	         {                  srno++; B                 type = *p;              /* subrecord type       */B                 memcpy(&slen,p+1,2);    /* subrecord length     */B                 p += 3;                 /* skip subrecord hdr   */                 len -= 3;                    switch(type)                 { &                 case LT_NODE_MOPSYSID:=                         q = p + sizeof(node->mop_sysid_time); 7                         save_mop_message(node->index,q, B                                 slen-sizeof(node->mop_sysid_time),5                                 (unsigned short *)p);                          break;'                 case LT_NODE_MOPESYSID: >                         q = p + sizeof(node->mope_sysid_time);8                         save_mope_message(node->index,q,C                                 slen-sizeof(node->mope_sysid_time), 5                                 (unsigned short *)p);                          break;'                 case LT_NODE_PROTOCOLS: 2                         /* protocol table       */                         n = 0;                         q = p;%                         sslen = slen; )                         while (sslen > 0)                          { +                                 switch (*q) !                                 { 5                                 case LT_PROTOCOL_ETH: /                                         qs = q; ,                                         q++;S                                         node->protocols[n].ethernet_protocol.format B                                                 = LT_PROTOCOL_ETH;Z                                         memcpy(&node->protocols[n].ethernet_protocol.type,5                                                 q,2); _                                         q += sizeof(node->protocols[n].ethernet_protocol.type); Z                                         memcpy(&node->protocols[n].ethernet_protocol.time,e                                                 q,sizeof(node->protocols[n].ethernet_protocol.time)); _                                         q += sizeof(node->protocols[n].ethernet_protocol.time); ,                                         n++;6                                         sslen -= q-qs;.                                         break;5                                 case LT_PROTOCOL_802: /                                         qs = q; ,                                         q++;Q                                         node->protocols[n].iee802_protocol.format B                                                 = LT_PROTOCOL_802;T                                         node->protocols[n].iee802_protocol.sap = *q;\                                         q += sizeof(node->protocols[n].iee802_protocol.sap);X                                         memcpy(&node->protocols[n].iee802_protocol.time,c                                                 q,sizeof(node->protocols[n].iee802_protocol.time)); ]                                         q += sizeof(node->protocols[n].iee802_protocol.time); ,                                         n++;6                                         sslen -= q-qs;.                                         break;6                                 case LT_PROTOCOL_802E:/                                         qs = q; ,                                         q++;R                                         node->protocols[n].iee802e_protocol.formatC                                                 = LT_PROTOCOL_802E; X                                         memcpy(&node->protocols[n].iee802e_protocol.pid,c                                                 q,sizeof(node->protocols[n].iee802e_protocol.pid)); ]                                         q += sizeof(node->protocols[n].iee802e_protocol.pid); Y                                         memcpy(&node->protocols[n].iee802e_protocol.time, d                                                 q,sizeof(node->protocols[n].iee802e_protocol.time));^                                         q += sizeof(node->protocols[n].iee802e_protocol.time);,                                         n++;6                                         sslen -= q-qs;.                                         break;(                                 default:k                                         printf("%%LISTEN-E-UNKPTY, Unknown protocol type %d for node %d\n", @                                                 *p,node->index);e                                         printf("-LISTEN-I-RNO, record number %d subrecord number %d", :                                                 rno,srno);L                                         len = 0;        /* terminate loop */!                                 }                          }                          break;'                 case LT_NODE_ADDRESSES:                          n = 0;                         q = p;%                         sslen = slen; )                         while (sslen > 0)                          { +                                 switch (*q) !                                 { 7                                 case LT_ADDRESS_UNUSED: .                                         break;7                                 case LT_ADDRESS_DECNET: T                                         node->addresses[n].type = LT_ADDRESS_DECNET;,                                         q++;`                                         memcpy(node->addresses[n].addr,q,LT_ADDRESS_DECNET_LEN);e                                         sslen -= 1 + LT_ADDRESS_DECNET_LEN; /* decrement subrec len*/ l                                         q += LT_ADDRESS_DECNET_LEN;     /* step subrec ptr past dnet addr */j                                         memcpy(node->addresses[n].time,q,sizeof(node->addresses[n].time));M                                         q += sizeof(node->addresses[n].time); Q                                         sslen -= sizeof(node->addresses[n].time); M                                         n++;        /* one more address    */ .                                         break;3                                 case LT_ADDRESS_IP: P                                         node->addresses[n].type = LT_ADDRESS_IP;,                                         q++;\                                         memcpy(node->addresses[n].addr,q,LT_ADDRESS_IP_LEN);`                                         sslen -= 1+LT_ADDRESS_IP_LEN; /* decrement subrec len */f                                         q += LT_ADDRESS_IP_LEN;     /* step subrec ptr past IP addr */j                                         memcpy(node->addresses[n].time,q,sizeof(node->addresses[n].time));M                                         q += sizeof(node->addresses[n].time); Q                                         sslen -= sizeof(node->addresses[n].time); ) 					if (node->addresses[n].addr[0] != 0)  					{N 	                                        n++;        /* one more address    */ 					}	 					else  					{0 						/* don't bother loading zero IP address	*/2 						node->addresses[n].type = LT_ADDRESS_UNUSED; 					}.                                         break;4                                 case LT_ADDRESS_IPX:Q                                         node->addresses[n].type = LT_ADDRESS_IPX; ,                                         q++;]                                         memcpy(node->addresses[n].addr,q,LT_ADDRESS_IPX_LEN); a                                         sslen -= 1+LT_ADDRESS_IPX_LEN; /* decrement subrec len */ h                                         q += LT_ADDRESS_IPX_LEN;     /* step subrec ptr past IPX addr */j                                         memcpy(node->addresses[n].time,q,sizeof(node->addresses[n].time));M                                         q += sizeof(node->addresses[n].time); Q                                         sslen -= sizeof(node->addresses[n].time); + 					if ((node->addresses[n].addr[0] != 0)  + 					&&  (node->addresses[n].addr[1] != 0))  					{N 	                                        n++;        /* one more address    */ 					}	 					else  					{> 						/* don't bother loading IPX address with zero network	*/2 						node->addresses[n].type = LT_ADDRESS_UNUSED; 					}.                                         break;5                                 case LT_ADDRESS_LAVC: R                                         node->addresses[n].type = LT_ADDRESS_LAVC;,                                         q++;^                                         memcpy(node->addresses[n].addr,q,LT_ADDRESS_LAVC_LEN);b                                         sslen -= 1+LT_ADDRESS_LAVC_LEN; /* decrement subrec len */`                                         q += LT_ADDRESS_LAVC_LEN;     /* step subrec ptr past */j                                         memcpy(node->addresses[n].time,q,sizeof(node->addresses[n].time));M                                         q += sizeof(node->addresses[n].time); Q                                         sslen -= sizeof(node->addresses[n].time); M                                         n++;        /* one more address    */ .                                         break;(                                 default:k                                         printf("%%LISTEN-E-UNKATYP, Unknown address type %d for node %d\n", @                                                 *p,node->index);e                                         printf("-LISTEN-I-RNO, record number %d subrecord number %d", :                                                 rno,srno);L                                         len = 0;        /* terminate loop */!                                 }                          }                          break;#                 case LT_NODE_NAMES:                          n = 0;                         q = p;%                         sslen = slen; )                         while (sslen > 0)                          { -                                 ntype = *q++; ,                                 nlen = *q++;C                                 memcpy(node->names[n].name,q,nlen); <                                 node->names[n].type = ntype;A                                 node->names[n].name[nlen] = '\0'; ?                                 node->names[n].name_len = nlen; 0                                 sslen -= 2+nlen;*                                 q += nlen;Z                                 memcpy(node->names[n].time,q,sizeof(node->names[n].time));A                                 q += sizeof(node->names[n].time); E                                 sslen -= sizeof(node->names[n].time);   				switch (node->names[n].type) 				{  				case LT_NAME_DECNET: 				case LT_NAME_IP: 				case LT_NAME_NETBUEI:  				case LT_NAME_SYSID: 6                                 case LT_NAME_LAT_NODE:6                                 case LT_NAME_LAT_DESC:2                                 case LT_NAME_LAST:5                                 case LT_NAME_NETBIOS: 6                                 case LT_NAME_NETBIOSG:2                                 case LT_NAME_DHCP:7                                 case LT_NAME_WORKGROUP: 5                                 case LT_NAME_NOVELLP:  					break;  				default:P 					printf("%%LISTEN-E-INVNAM, Duff name for node %d type %d len %d name %s\n",4                                         node->index, 					node->names[n].type,  					node->names[n].name_len,  					node->names[n].name);e                                         printf("-LISTEN-I-RNO, record number %d subrecord number %d", :                                                 rno,srno); 				} $                                 n++;                         }                          break;'                 case LT_NODE_TIMESTAMP: 2                         /* timestamp record     */7                         if (slen == sizeof(node->time))                          { H                                 memcpy(node->time,p,sizeof(node->time));                         }S                         else                         { _                                 printf("%%LISTEN-W-INVNTIM, Invalid node time stamp length\n");y]                                 printf("-LISTEN-I-RNO, record number %d subrecord number %d", 4                                           rno,srno);                         }1                         break;(                 case LT_NODE_ATTRIBUTES:=                         if (slen == sizeof(node->attributes))                          {m;                                 memcpy(&node->attributes,p,nB                                         sizeof(node->attributes));                         }4                         else                         {d_                                 printf("%%LISTEN-W-INVNATT, Invalid node attributes length\n");d]                                 printf("-LISTEN-I-RNO, record number %d subrecord number %d",f2                                         rno,srno);                         } 	 			break;I#                 case LT_NODE_ROUTE:u]                         node->routes[nroute].rlen = slen-1-sizeof(node->routes[nroute].time);hX                         node->routes[nroute].r.data = malloc(node->routes[nroute].rlen);@                         if (node->routes[nroute].r.data != NULL)                         {o?                                 node->routes[nroute].type = *p;rC                                 memcpy(node->routes[nroute].r.data, ,                                         p+1,C                                         node->routes[nroute].rlen); A                                 memcpy(node->routes[nroute].time, F                                         p+1+node->routes[nroute].rlen,K                                         sizeof(node->routes[nroute].time)); )                                 nroute++;                          }f                         else                         { X                                 printf("%%LISTEN-E-MALLOC, Failed to malloc %d bytes\n",0                                         slen-1);                         }                          break;%                 case LT_NODE_SERVICE:                          q = p;B                         ntype = *q++;   /* service type         */B                         nlen = *q++;    /* service name length  */>                         node->services[nservice].type = ntype;G                         node->services[nservice].name = malloc(nlen+1); E                         memcpy(node->services[nservice].name,q,nlen); A                         node->services[nservice].name_len = nlen;o0                         sslen = slen - 2 - nlen;"                         q += nlen;f                         memcpy(node->services[nservice].time,q,sizeof(node->services[nservice].time));C                         q += sizeof(node->services[nservice].time);]G                         sslen -= sizeof(node->services[nservice].time); &                         if (sslen > 0)                         { N                                 node->services[nservice].data = malloc(sslen);N                                 memcpy(node->services[nservice].data,q,sslen);J                                 node->services[nservice].data_len = sslen;                         }  			nservice++;                         break;                 default:\                        printf("%%LISTEN-E-UNKSUBT, Unknown node subrecord type %d len %d\n",+                                 type,slen); T                        printf("-LISTEN-I-RNO, record number %d subrecord number %d",*                                 rno,srno);;                        len = 0;        /* terminate loop */l                 }                  len -= slen;                 p += slen;	         }a          }f t
 static int write_eof_record(int fd) {_          unsigned char record[9];          extern int SYS$GETTIM();  "         record[0] = LT_EOF_RECORD;         SYS$GETTIM(&record[1]);_  $         if (write(fd,record,9) <= 0)	         {n3                 perror("Error writing eof record");n                 return FALSE; 	         }          else	         {                  return TRUE;	         }"   }T E static voidt. read_eof_record(unsigned char *record,int len) {  	char time[30];  	unsigned short tlen;  	$DESCRIPTOR(time_dsc,"");# 	unsigned long ccode, sys$asctim();    	if (len == 9) 	{7                 time_dsc.dsc$w_length = sizeof(time)-1;*.                 time_dsc.dsc$a_pointer = time;3 		ccode = sys$asctim(&tlen,&time_dsc,&record[1],0);a 		if (ccode & 1) 		{" 			time[tlen] = '\0';>7 			printf("%%LISTEN-I-EOFDT, file was written on %s\n",S
 				time); 		}{ 		else 		{fQ 			printf("%%LISTEN-E-BADEOFT, error 0x%x converting datetime from eof record\n",; 				ccode);  		}  	} 	elsed 	{C 		printf("%%LISTEN-E-BADEOF, incorrect length %d for eof record\n",  			len); 	} }  o /*F         add_protocol_xxx - add specified protocol to node table entry  */ void m4 add_protocol_eth(int node_index,unsigned short type) {f         int i, found;   =         assert((node_index >=0) && (node_index < MAX_NODES));   5         for (i=0,found=FALSE; i < MAX_PROTOCOLS; i++)s	         {nL                 if ((nodes[node_index].protocols[i].ethernet_protocol.format+                         == LT_PROTOCOL_ETH)lJ                 &&  (nodes[node_index].protocols[i].ethernet_protocol.type!                         == type))                  { %                         found = TRUE;                          break;                 }e                 elseK                 if (nodes[node_index].protocols[i].ethernet_protocol.format;.                         == LT_PROTOCOL_UNUSED)                 {L&                         found = FALSE;                         break;                 } 	         }          if (i < MAX_PROTOCOLS)	         {                  if (!found)=                 { O                         nodes[node_index].protocols[i].ethernet_protocol.formatD2                                 = LT_PROTOCOL_ETH;M                         nodes[node_index].protocols[i].ethernet_protocol.type '                                 = type;          		bswap(&type);d(         		if (log_mask & LT_LOG_NEWPROT)         		{ C         			printf("%%LISTEN-I-NEWPROTO, Adding protocol %04x for ",	         				type);7         			display_addr(stdout,nodes[node_index].addr);E         			putchar('\n');c         		}e                 }dM                 memcpy(nodes[node_index].protocols[i].ethernet_protocol.time, O                         nodes[node_index].time,sizeof(nodes[node_index].time)); 	         }  }  % void -2 add_protocol_802(int node_index,unsigned char sap) {n         int i, found;   =         assert((node_index >=0) && (node_index < MAX_NODES));d  5         for (i=0,found=FALSE; i < MAX_PROTOCOLS; i++)N	         {eJ                 if ((nodes[node_index].protocols[i].iee802_protocol.format+                         == LT_PROTOCOL_802)bG                 &&  (nodes[node_index].protocols[i].iee802_protocol.sapd                          == sap))                 {C%                         found = TRUE;i                         break;                 }g                 elseI                 if (nodes[node_index].protocols[i].iee802_protocol.format .                         == LT_PROTOCOL_UNUSED)                 {c&                         found = FALSE;                         break;                 }>	         }e         if (i < MAX_PROTOCOLS)	         {                  if (!found)H                 {-M                         nodes[node_index].protocols[i].iee802_protocol.format 2                                 = LT_PROTOCOL_802;J                         nodes[node_index].protocols[i].iee802_protocol.sap&                                 = sap;(         		if (log_mask & LT_LOG_NEWPROT)         		{t@         			printf("%%LISTEN-I-NEWSAP, Adding 802 sap %02x for ",         				sap);g7         			display_addr(stdout,nodes[node_index].addr);e         			putchar('\n');e         		}                  }(K                 memcpy(nodes[node_index].protocols[i].iee802_protocol.time,tO                         nodes[node_index].time,sizeof(nodes[node_index].time)); 	         }  }    void -4 add_protocol_802e(int node_index,unsigned char *pid) {E         int i, found;   =         assert((node_index >=0) && (node_index < MAX_NODES));   5         for (i=0,found=FALSE; i < MAX_PROTOCOLS; i++)		         {dK                 if ((nodes[node_index].protocols[i].iee802e_protocol.format ,                         == LT_PROTOCOL_802E)]                 &&  (memcmp(nodes[node_index].protocols[i].iee802e_protocol.pid,pid,5) == 0))-                 { %                         found = TRUE;                          break;                 }                  elseJ                 if (nodes[node_index].protocols[i].iee802e_protocol.format.                         == LT_PROTOCOL_UNUSED)                 { &                         found = FALSE;                         break;                 }O	         }s         if (i < MAX_PROTOCOLS)	         {                  if (!found)e                 {)N                         nodes[node_index].protocols[i].iee802e_protocol.format3                                 = LT_PROTOCOL_802E;0Z                         memcpy(nodes[node_index].protocols[i].iee802e_protocol.pid,pid,5);(         		if (log_mask & LT_LOG_NEWPROT)         		{ Z         			printf("%%LISTEN-I-NEWPID, Adding protocol %02x-%02x-%02x-%02x-%02x-%02x for ",7         				pid[0],pid[1],pid[2],pid[3],pid[4],pid[5]);L7         			display_addr(stdout,nodes[node_index].addr);          			putchar('\n');E         		}                  }+L                 memcpy(nodes[node_index].protocols[i].iee802e_protocol.time,O                         nodes[node_index].time,sizeof(nodes[node_index].time));e	         }t }l p
 static int  get_addr_len(unsigned addr_type) {r         int len;  2         /* work out length of this address      */         switch(addr_type)_	         {m         case LT_ADDRESS_DECNET:[,                 len = LT_ADDRESS_DECNET_LEN;                 break;         case LT_ADDRESS_IP:c(                 len = LT_ADDRESS_IP_LEN;                 break;         case LT_ADDRESS_IPX:)                 len = LT_ADDRESS_IPX_LEN;e                 break;         case LT_ADDRESS_LAVC:o*                 len = LT_ADDRESS_LAVC_LEN;                 break;         default:                 len = 0;	         }          return  len; }[ i void9 add_address(int node_index,unsigned addr_type,void *addr)t {l         int i, found, len;  =         assert((node_index >=0) && (node_index < MAX_NODES));   &         len = get_addr_len(addr_type);  5         for (i=0,found=FALSE; i < MAX_ADDRESSES; i++)a	         { F                 if ((nodes[node_index].addresses[i].type == addr_type)N                 &&  (memcmp(nodes[node_index].addresses[i].addr,addr,len)==0))                 {p%                         found = TRUE;                          break;                 } R                 else if (nodes[node_index].addresses[i].type == LT_ADDRESS_UNUSED)                 { &                         found = FALSE;                         break;                 }n	         }o         if (i < MAX_ADDRESSES)	         {                  if (!found)>                 {eH                         nodes[node_index].addresses[i].type = addr_type;M                         memcpy(nodes[node_index].addresses[i].addr,addr,len);d  (         		if (log_mask & LT_LOG_NEWADDR)         		{e#         		        switch(addr_type)a         		        { )         		        case LT_ADDRESS_DECNET: C         				printf("%%LISTEN-I-NEWDNADDR, Adding DECnet address ");).         				display_dnet_address(stdout,addr);         				printf(" for ");8         				display_addr(stdout,nodes[node_index].addr);         				putchar('\n');         				break;%         		        case LT_ADDRESS_IP: ?         				printf("%%LISTEN-I-NEWIPADDR, Adding IP address ");d,         				display_ip_address(stdout,addr);         				printf(" for ");8         				display_addr(stdout,nodes[node_index].addr);         				putchar('\n');          		                break;4                                 case LT_ADDRESS_IPX:A         				printf("%%LISTEN-I-NEWIPXADDR, Adding IPX address ");i-         				display_ipx_address(stdout,addr);a         				printf(" for ");8         				display_addr(stdout,nodes[node_index].addr);         				putchar('\n');          		                break;5                                 case LT_ADDRESS_LAVC:yI         				printf("%%LISTEN-I-NEWLAVCADDR, Adding LAVC cluster group ");C,         				display_lavc_group(stdout,addr);         				printf(" for ");8         				display_addr(stdout,nodes[node_index].addr);         				putchar('\n');          		                break;         		        default:"         		                len = 0;         		        }                          }e 		}D;                 memcpy(nodes[node_index].addresses[i].time,sO                         nodes[node_index].time,sizeof(nodes[node_index].time));,	         }  }    voidJ add_name(int node_index,unsigned name_type,char *n,unsigned char name_len) {          int i, found, len;         char name[256];t  =         assert((node_index >=0) && (node_index < MAX_NODES));i            memcpy(name,n,name_len);         name[name_len] = '\0';$         if (name_type == LT_NAME_IP)!                 lower_case(name);   ;         for (i=0,found=FALSE; i < MAX_NAMES && !found; i++) 	         {cB                 if ((nodes[node_index].names[i].type == name_type)A 		&&  (memcmp(nodes[node_index].names[i].name,name,name_len)==0))&                 {t%                         found = TRUE;i                         break;                 } K                 else if (nodes[node_index].names[i].type == LT_NAME_UNUSED)                  {e&                         found = FALSE;                         break;                 } 	         }&         if (i < MAX_NAMES)	         {_                 if (!found)                  {AD                         nodes[node_index].names[i].type = name_type;N                         memcpy(nodes[node_index].names[i].name,name,name_len);I                         nodes[node_index].names[i].name[name_len] = '\0'; G                         nodes[node_index].names[i].name_len = name_len;N  (         		if (log_mask & LT_LOG_NEWNAME)         		{ V                                 printf("%%LISTEN-I-NEWNAME, Adding name %s type 0x%x",H                                         nodes[node_index].names[i].name,I                                         nodes[node_index].names[i].type);)         			printf(" for "); 7         			display_addr(stdout,nodes[node_index].addr);%         			putchar('\n');s         		}c                 }d7                 memcpy(nodes[node_index].names[i].time, O                         nodes[node_index].time,sizeof(nodes[node_index].time)); 	         }  }  * void  = save_mop_message(int n,unsigned char *msg,unsigned short len,p         unsigned short time[4])u {c         /* sanity check */         assert(len != 0);   +         assert((n >=0) && (n < MAX_NODES));   '         if (nodes[n].mop_sysid == NULL) K                 nodes[n].mop_sysid = (unsigned char *)malloc(NODE_BUFSIZE);b'         if (nodes[n].mop_sysid != NULL) 	         {n3                 memcpy(nodes[n].mop_sysid,msg,len);+0                 nodes[n].mop_sysid_length = len;5                 memcpy(&nodes[n].mop_sysid_time,time,;9                         sizeof(nodes[n].mop_sysid_time)); 	         }y         else	         { T                 printf("%%LISTEN-E-MALLOC,Failed to malloc mop sysid msg buffer\n");	         }o }o > void ]> save_mope_message(int n,unsigned char *msg,unsigned short len,         unsigned short time[4])  {          /* sanity check */         assert(len != 0);   +         assert((n >=0) && (n < MAX_NODES));   (         if (nodes[n].mope_sysid == NULL)L                 nodes[n].mope_sysid = (unsigned char *)malloc(NODE_BUFSIZE);(         if (nodes[n].mope_sysid != NULL)	         {d4                 memcpy(nodes[n].mope_sysid,msg,len);1                 nodes[n].mope_sysid_length = len;%6                 memcpy(&nodes[n].mope_sysid_time,time,:                         sizeof(nodes[n].mope_sysid_time));	         }e         else	         { T                 printf("%%LISTEN-E-MALLOC,Failed to malloc mop sysid msg buffer\n");	         }  }  s void d2 add_attribute(int node_index,unsigned char attrib) {-         unsigned long newattr;  /         assert((attrib >= 0) && (attrib < 32));*  ;         newattr = nodes[node_index].attributes | 1<<attrib;r5         if ((newattr != nodes[node_index].attributes)r(         &&  (log_mask & LT_LOG_NEWATTR))	         {e/                 printf("%%LISTEN-I-NEWATTR, "); <                 display_addr(stdout,nodes[node_index].addr);5                 display_attributes(stdout,1<<attrib); 	         }=/         nodes[node_index].attributes = newattr;e }    void  2 display_attributes(FILE *fpOut,unsigned long attr) {)4         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_BRIDGE))6                 fprintf(fpOut,"  node is a bridge\n");6         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_DECNETL1))H                 fprintf(fpOut,"  node is a DECnet IV Level 1 router\n");6         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_DECNETL2))H                 fprintf(fpOut,"  node is a DECnet IV Level 2 router\n");6         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_IPROUTER))9                 fprintf(fpOut,"  node is a IP router\n");u5         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_IPX8023))n_                 fprintf(fpOut,"  node sends IPX Ethernet_802.3 (without IEEE 802.2 header)\n"); 7         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_IPDEFAULT)) F                 fprintf(fpOut,"  node advertises default IP route\n");4         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_BOOTPC))?                 fprintf(fpOut,"  node is BOOTP/DHCP client\n"); 9         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_LAST_SERVER)) 9                 fprintf(fpOut,"  node is LAST server\n"); 7         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_IPXROUTER)) 8                 fprintf(fpOut,"  node is IPX router\n");4         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_BOOTPS))?                 fprintf(fpOut,"  node is BOOTP/DHCP server\n"); 8         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_MSTBROWSER))<                 fprintf(fpOut,"  node is master browser\n");8         if (TEST_ATTRIBUTE(attr,LT_NODE_ATT_NAMESERVER))9                 fprintf(fpOut,"  node is name server\n");  }    voidA add_route(int n,unsigned char type,unsigned short len,void *data)( {e         int i, found;            /* sanity check */         assert(len != 0);   +         assert((n >=0) && (n < MAX_NODES));          assert(data != NULL);p  ;         for (i=0,found=FALSE; i < MAX_NAMES && !found; i++) 	         { 5                 if ((nodes[n].routes[i].type == type) 6 		&&  (memcmp(nodes[n].routes[i].r.data,data,len)==0))                 { %                         found = TRUE;                          break;                 } D                 else if (nodes[n].routes[i].type == LT_ROUTE_UNUSED)                 { &                         found = FALSE;                         break;                 }n	         }          if (i < MAX_ROUTES) 	         {                  if (!found)s                 { @                         nodes[n].routes[i].r.data = malloc(len);>                         if (nodes[n].routes[i].r.data != NULL)                         { ?                                 nodes[n].routes[i].type = type;gK                                 memcpy(nodes[n].routes[i].r.data,data,len);)>                                 nodes[n].routes[i].rlen = len;?                                 if (log_mask & LT_LOG_NEWROUTE) !                                 { H                                         printf("%%LISTEN-I-NEWROUTE, ");K                                         display_addr(stdout,nodes[n].addr); U                                         printf(" has new route of type 0x%x\n",type); !                                 }q                         }                          else                         { X                                 printf("%%LISTEN-E-MALLOC, failed to malloc %d bytes\n",-                                         len);                          }                  } =                 memcpy(nodes[n].routes[i].time,nodes[n].time, /                         sizeof(nodes[n].time));=	         }  }r r void eG add_service(int n,unsigned char type,char *name,unsigned char name_len,;+         void *data, unsigned char data_len)  {          int i, found;1           /* sanity check */+         assert((n >=0) && (n < MAX_NODES));   ;         for (i=0,found=FALSE; i < MAX_NAMES && !found; i++) 	         {w7                 if ((nodes[n].services[i].type == type)O; 		&&  (memcmp(nodes[n].services[i].name,name,name_len)==0))p                 { %                         found = TRUE;d                         break;                 }sH                 else if (nodes[n].services[i].type == LT_SERVICE_UNUSED)                 { &                         found = FALSE;                         break;                 } 	         }f         if (i < MAX_SERVICES) 	         {                  if (!found)>                 { G                         nodes[n].services[i].name = malloc(name_len+1); >                         if (nodes[n].services[i].name != NULL)                         {aA                                 nodes[n].services[i].type = type; P                                 memcpy(nodes[n].services[i].name,name,name_len);K                                 nodes[n].services[i].name[name_len] = '\0'; I                                 nodes[n].services[i].name_len = name_len; F                                 if ((data_len != 0) && (data != NULL))!                                 { U                                         nodes[n].services[i].data = malloc(data_len); N                                         if (nodes[n].services[i].data != NULL))                                         {TQ                                                 memcpy(nodes[n].services[i].data,eG                                                         data,data_len);,Y                                                 nodes[n].services[i].data_len = data_len;c)                                         } ,                                         else)                                         { h                                                 printf("%%LISTEN-E-MALLOC, failed to malloc %d bytes\n",B                                                         data_len);)                                         } !                                 } A                                 if (log_mask & LT_LOG_NEWSERVICE) !                                 {eJ                                         printf("%%LISTEN-I-NEWSERVICE, ");K                                         display_addr(stdout,nodes[n].addr); V                                         printf(" has new service name %s type 0x%x\n",P                                                 nodes[n].services[i].name,type);!                                 }                          }                          else                         {;X                                 printf("%%LISTEN-E-MALLOC, failed to malloc %d bytes\n",4                                         name_len+1);                         }8                 } ?                 memcpy(nodes[n].services[i].time,nodes[n].time,c/                         sizeof(nodes[n].time)); 	         }  }    int;< find_node_by_address(unsigned char *addr,unsigned char type) {          int n, len, found, i;   !         len = get_addr_len(type);          found = FALSE;  %         for (n=0; n < MAX_NODES; n++) 	         { #                 if (nodes[n].inuse)                  { E                         for (i=0,found=FALSE; i < MAX_ADDRESSES; i++)                          { H                                 if ((nodes[n].addresses[i].type == type)U                                 &&  (memcmp(nodes[n].addresses[i].addr,addr,len)==0)) !                                 {o5                                         found = TRUE; .                                         break;!                                 } Y                                 else if (nodes[n].addresses[i].type == LT_ADDRESS_UNUSED) !                                 { 6                                         found = FALSE;.                                         break;!                                 }o                         } "                         if (found)&                                 break;                 }                  else                         break;	         }          if (found)                 return n;          else                 return -1; }o