#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */

/*
 *	Read an addressee name from the network link
 *
 *	mai$ax_addressee	descriptor to write to for read addressee
 *				name, generally a VMS user name on this node.
 *				A blank name means the end of the list has
 *				been reached.
 *
 * Return: System status code for success/failure
 *
 */

PROTO_IN_CKUSER(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_IN_CKUSER */
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor	*mai$ax_addressee ; /* Returned addressee name */

	mai$ax_addressee =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;

	printf( "* Operation type = %d (LNK_C_IN_CKUSER)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );

	return(SS$_NORMAL) ;			/* Return success to caller */
}
