5       subroutine help ( library , subject, noprompt )       @ c     This routine written by John Stevens-Schlick to facilitateC c     the usage of standard VMS help libraries by regular programs.    B c     Library :  The name of the library to try to open.  This mayD c               be a logical name.  The default file type is ".HLB". c < c     Subject :  The subject line that help will start with.G c               This parameter is optional, however it must be present. 2 c               A 0 may be used if none is wished. c K c     Noprompt : Is a fortran logical that tells whether or not to continue B c               interactively after the first help has been given.N c     Noprompt will be treated as true if the output device is not a terminal.      I c     This routine checks whether or not the output device is a terminal, H c     and if it is, gets the default page length, and the default width.G c     It calls LBR$OUTPUT_HELP with the library name, the subject line, D c     the screen width, and the prompting flags.  It also passes theC c     addresses of the help$put_output and help$get_input routines. 7 c     It is these routines that do the pagination work.     c     ***NOTE***? c     This routine depends upoin an undocumented external value H c     LBR$_ENDTOPIC.  This value must be returned by put_output in orderG c     to inform lbr$output_help that outputting of the present topic is  c     to be discontinued.    )       character * ( * ) library , subject         logical           noprompt          integer*4 flags        integer*4 width        integer*4 status       logical   terminal          include 'help$common.dck'           include '($hlpdef)'        include '($dvidef)'    .       external help$get_input, help$put_output      5 c--   Initialize stuff for input and output routines.        input_present = .false. 5       call lib$getdvi ( dvi$_trm, , 'tt:', terminal ) >       call lib$getdvi ( dvi$_tt_page, , 'tt:', screen_height )&       lines_output = screen_height - 3 c--   Default 80 chars.        width = 80       if ( terminal ) then:         call lib$getdvi ( dvi$_devbufsiz, , 'tt:', width )       end if   ( c--   Set up flags for proper behaviour.0       if ( noprompt .or. (.not. terminal) ) then         flags = hlp$m_help         paging = .false.
       else5         flags = hlp$m_help + hlp$m_prompt+ hlp$m_page          paging = .true.        endif       * c--   Call Help routine to print help out.A       status = lbr$output_help ( help$put_output, width, subject, 4 	1                  library, flags, help$get_input )   ( c--   Make sure that there was no error.8       if ( .not. status ) call lib$signal (%VAL(status))          return	       end                             c--   The output routine1       integer function help$put_output ( output )    K c     This routine is called by LBR$OUTPUT_HELP in order to output one line H c     of text to the output device.  If prompting is in effect then thisM c     routine will prompt for more at the end of every screen, and optionally L c     accept other input for LBR$OUTPUT_HELP.  If there is other input, thenM c     this routine will return the undocumented value LBR$_ENDTOPIC, in order L c     to tell LBR$OUTPUT_HELP to stop outputting the current topic, and callK c     help$get_input for more info.  It also sets the logical input_present G c     to true so that help$get_input knows that there is input present. A c     This routine will also clear the screen after every prompt.           character*(*)     output       integer*4 status          include 'help$common.dck'           external  lbr$_endtopic        external  rms$_eof          if ( paging ) then7         if ( lines_output .lt. screen_height - 4 ) then /                 lines_output = lines_output + 1 ;         elseif ( lines_output .eq. screen_height - 4 ) then +                 call lib$put_output ( ' ' ) <                 input_status = lib$get_input ( input_string,C 	1                  'Press RETURN to continue ... ', input_length ) 4                 if (    ( input_length .gt. 0 ) .or.? 	1                  ( input_status .eq. %loc(rms$_eof) ) ) then .                         input_present = .true.=                         help$put_output = %loc(lbr$_endtopic)                          return                 end if0                 lines_output = screen_height - 3
         endif    + c--     See if we need to clear the screen. 7         if ( lines_output .gt. screen_height - 4 ) then ,                 call lib$erase_page ( 1, 1 )                  lines_output = 1         end if       end if   (       status = lib$put_output ( output )       help$put_output = status          return	       end                             c--   The input routine G       integer function help$get_input ( input, prompt, x_input_length )    E c     Called by LBR$OUTPUT_HELP in order to get input (also passes in J c     a prompt.  This routine checks to see if help$put_output has alreadyL c     gotten input.  If it has, then that input is returned ( along with theI c     status of that input ).  If there is no input, the LIB$GET_INPUT is 
 c     called. 1 c     This routine is unused if noprompt is true.           character*(*)     input        character*(*)     prompt       integer*4 x_input_length          include 'help$common.dck'    < c--   If we already have input then don't bother to get any.       if (input_present) then <         input(1:input_length) = input_string(1:input_length)         input_present = .false. %         help$get_input = input_status 
       elseD         input_status = lib$get_input ( input, prompt, input_length )%         help$get_input = input_status        end if   5 c--   Generate a page break after every input gotten. &       lines_output = screen_height - 3#       x_input_length = input_length           return	       end 