J 92000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+         ! C H E C K   V A L I D   E N T R Y J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! J         !  Given a response in ans$, it checks the rules in valid_element$          !    to see if it is OK.(         !  Allowed validation rules are:K         !       "NUMBER", "ALLOW", "INTEGER", "DATE", "FULLTIME", "RANGE",  4         !       "DIGITS", "CONTAINS", and "REQUIRED"J         !       (digits 2 3  means 2 digits (max) before the decimal pointF         !        and 3 digits (max) after it, negative signs included)	         !          ! Expected: ;         !       fld = the index number of the current field I         !       max_validation() = number of validation elements for that          !               field I         !       valid_element$(fld,el) contains validation element el for H         !               field fld.  Note that in the case of an "allow",M         !               valid_element$(fld,el+1) as the actual allowed stuff. 	         !          ! Result  : G         !       error = true if there is a problem (such as it violates (         !               one of the rules	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine check_valid_entry   7 92020   !if  max_validation(fld) = 0 then exit routine           error = false 4         for valid_element = 1 to max_validation(fld)8           select case valid_element$(fld,valid_element) 2             case 'NUMBER'  : gosub do_number_check3             case 'INTEGER' : gosub do_integer_check 1             case 'ALLOW'   : gosub do_allow_check 0             case 'DATE'    : gosub do_date_check1             case 'RANGE'   : gosub do_range_check 4             case 'REQUIRED': gosub do_required_check1             case 'DIGITS'  : gosub do_digit_check 4             case 'CONTAINS': gosub do_contains_check4             case 'FULLTIME': gosub do_fulltime_check             case else >               message error : "Unknown validation rule:  " + &A                                valid_element$(fld, valid_element)            end select"           if  _error then exit for         next valid_element%         if  _error  then error = true %         if  error  then  exit routine M         !gosub do_format_check ++DJS++ 16-FEB-1993 not a useful check anymore @         ! ++DJS++ 16-FEB-1993 format$ no longer returns an error          92099   end routine       J 93000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! D O   R A N G E   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! M         !  Checks ans$ to see if it is in the proper range.  Expects that the ;         !       valid_element$(fld, valid_element + 1) and  G         !       valid_element$(fld, valid_element + 2) have the allowed 7         !       range limits.  Increments valid_element C         !       extra times so that you do not try to interpert the 5         !       allowed stuff as another valid check. 	         !          ! Expected: $         !       ans$ = user responseN         !       valid_element$(fld, valid_element + 1) has the low range limitI         !       valid_element$(fld, valid_element + 2) has the high limit 	         !          ! Result  : 8         !       error = true if ans$ is not in the range-         !       valid_element is incremented. 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine do_range_check  ) 93020   valid_element = valid_element + 2 .         if  trim$(ans$) = '' then exit routine,         if  not(valid(ans$, 'integer')) then4           message error: "Integer expected: " + ans$           exit routine         end if         <         low$ = trim$(valid_element$(fld, valid_element - 1))9         high$ = trim$(valid_element$(fld, valid_element))                 z = val(ans$) 5         if  z < val(low$)  or  z > val(high$)  then & 7           message error : "Allowed range:  " + low$ + & ,                               " to " + high$   93099   end routine       J 94000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'         ! D O   N U M B E R   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! 8         ! Check ans$ to see if it is a number (or blank)	         !          ! Expected: $         !       ans$ = user response	         !          ! Result  : 4         !       error = true if ans$ is not a number	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine do_number_check   . 94020   if  trim$(ans$) = '' then exit routine-         if  not(valid(ans$, 'number')) then & 3           message error: "Number expected: " + ans$   * 94099   end routine                             J 94500   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)         ! D O   I N T E G E R   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! 8         ! Check ans$ to see if it is an integer or blank	         !          ! Expected: $         !       ans$ = user response	         !          ! Result  : 6         !       error = true if ans$ is not an integer	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine do_integer_check  . 94520   if  trim$(ans$) = '' then exit routine.         if  not(valid(ans$, 'integer')) then &4           message error: "Integer expected: " + ans$                 * 94599   end routine                           J 95000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! D O   A L L O W   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! A         !  Checks ans$ to see if it is allowed.  Expects that the F         !       valid_element$(fld, valid_element + 1) has the allowedI         !       responses, separated by commas.  Increments valid_element E         !       an extra time so that you do not try to interpert the 5         !       allowed stuff as another valid check. 	         !          ! Expected: $         !       ans$ = user response=         !       valid_element$(fld, valid_element+1) has the  L         !               allowed strings.  It shouldn't have leading/trailing         !               spaces. 	         !          ! Result  : /         !       error = true if ans$ is not in  >         !               valid_element$(fld, valid_element + 1)-         !       valid_element is incremented. 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine do_allow_check  ) 95020   valid_element = valid_element + 1 .         if  trim$(ans$) = '' then exit routine/         z$ = valid_element$(fld, valid_element) B         if z$ [1:1] = "'" or z$[1:1] = '"' then z$ = z$[2:len(z$)]         z= len(z$)?         if z$ [z:z] = "'" or z$[z:z] = '"' then z$ = z$[1:z-1]  4         if  fld_uppercase(fld)  then z$ = ucase$(z$)                z1 = match(z$, ans$)         if  z1 = 0  then &4           message error : 'Allowed responses: ' + z$   95099   end routine       J 95100   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+         ! D O   C O N T A I N S   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! I         !  Checks ans$ to see if it has the required character.  Expects  H         !       that the valid_element$(fld, valid_element + 1) has the <         !       required character. Increments valid_elementE         !       an extra time so that you do not try to interpert the 7         !       character stuff as another valid check. 	         ! K         !       this check is used to make sure that a character exists in  K         !       the answer.  For example, a code translation file is set up @         !       as code_prefix:code.  Therefore, a : is required	         !          ! Expected: $         !       ans$ = user response=         !       valid_element$(fld, valid_element+1) has the  N         !               allowed character.  It shouldn't have leading/trailing         !               spaces. 	         !          ! Result  : /         !       error = true if ans$ is not in  >         !               valid_element$(fld, valid_element + 1)-         !       valid_element is incremented. 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine do_contains_check   ) 95120   valid_element = valid_element + 1 .         if  trim$(ans$) = '' then exit routine/         z$ = valid_element$(fld, valid_element) B         if z$ [1:1] = "'" or z$[1:1] = '"' then z$ = z$[2:len(z$)]         z= len(z$)?         if z$ [z:z] = "'" or z$[z:z] = '"' then z$ = z$[1:z-1]  4         if  fld_uppercase(fld)  then z$ = ucase$(z$)                z1 = pos(ans$, z$)         if  z1 = 0  then &M           message error : 'Your answer must contain the character "' + z$ + &                  '"'    95199   end routine       J 95500   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#         ! D O   D A T E   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! >         !  Checks ans$ to see if it has a valid date.  Expects?         !       that, as the user just entered it, it is in MDY          !       format. 	         !          ! Expected: $         !       ans$ = user response	         !          ! Result  : =         !       _error = true if ans$ is not a valid MDY date 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine do_date_check   ) 95520   valid_element = valid_element + 1          ans$ = trim$(ans$)'         if  ans$ = '' then exit routine =         if  not(valid(ans$[5:8] + ans$[1:4], "DATE"))  then & 2           message error : "Invalid data:  " + ans$L                 ! +++ RPR Debug - Intouch cannot handle 8-character DATE:MDY     95599   end routine   J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+         ! D O   F U L L T I M E   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !          ! Brief description:	         !          ! Expected: 	         !          ! Locals: 	         !          ! Results:	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     routine do_fulltime_check   ( 95600   valid_element = valid_element +1         ans$ = trim$(ans$)'         if  ans$ = '' then exit routine I         if len(ans$) = 15 then ans_new$ = ans$[5:8] +ans$[1:4]+ans$[9:15] I         if len(ans$) = 13 then ans_new$ = ans$[3:6] +ans$[1:2]+ans$[7:13]   4         if  not(valid(ans_new$, "FULLTIME"))  then &7           message error : "Invalid fullltime:  " + ans$            end routine           J 96000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+         ! D O   R E Q U I R E D   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! 0         !  checks to see if response is required	         !          ! Expected: $         !       ans$ = user response	         !          ! Result  : 1         !        error = true if no user response 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine do_required_check   # 96020   if  trim$(ans$) = '' then & -           message error: "Response required"     96099   end routine       J 96500   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&         !  D O   D I G I T   C H E C KJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F         !  Check that there are the proper number of digits before and;         !    after the decimal point in ans$.  Expects that :         !       valid_element$(fld, valid_element + 1) andF         !       valid_element$(fld, valid_element + 2) have the numberG         !       of digits (maximum) before and after the decimal point. L         !       Negative numbers ARE allowed (the behavior will be described         !       momentarily)I         !    Also increments valid_element twice so that you don't try to >         !       use the numeric parameters as things to check.	         ! G         !    The convolutions for negative numbers are actually logical H         !       extensions of negative scaling factors in limited-lengthJ         !       fields and scaling factors which are larger than the field         !       length. 	         ! E         !    IF the first parameter is negative, it checks that there J         !       are only negative signs and zeros before the decimal pointB         !       and there are abs(first parameter) zeros after it.F         !    IF the second parameter is negative, it checks that thereH         !       are only zeros after the decimal point (if there is one)E         !       and either the number is zero or there are abs(second H         !       parameter) zeros immediately prior to the decimal point.	         !          ! Expected: $         !       ans$ = user responseK         !       valid_element$(fld, valid_element+1) has the max. number of 7         !               digits before the decimal point M         !       valid_element$(fld, valid_element + 2) has the max. number of 6         !               digits after the decimal point	         !          ! Result  : /         !       error = true if ans$ is not in  >         !               valid_element$(fld, valid_element + 1)-         !       valid_element is incremented. 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine do_digit_check  ) 96520   valid_element = valid_element + 2 8         if  not(valid(ans$,'NUMBER'))  then exit routine=                                 !  No automatic numeric check          nbr$ = ans$ D         if  trim$(nbr$) = ''  or  val(nbr$) = 0.0  then exit routine6                                 !  Zero is always O.K.5         if  pos(ans$,'.') = 0  then nbr$ = nbr$ + "."          dp = pos(nbr$,'.')<         before = val(valid_element$(fld, valid_element - 1))7         after = val(valid_element$(fld, valid_element))           gosub digit_check_before%         if  _error  then exit routine          gosub digit_check_after    96599   end routine       J 96600   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.         !  D I G I T   C H E C K   B E F O R EJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%G         !  Check the number of digits "before" the decimal point.  Only F         !    allow a certain number of digits before the decimal pointH         !    If the number of digits allowed < 0, then force zeros after         !    the decimal point.          !  Expects: K         !    before = # digits before the decimal point (or zeros after the <         !               decimal point if before is negative)P         !    nbr$   = the number you are checking (with a trailing decimal point.         !               if none was indicated)7         !    dp     = the location of the decimal point          !  Result:H         !    _error = true if the number has too many/too few characters(         !       in the proper positions.J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine digit_check_before   96620   if  before > 0  thenO           ! Check that there are not more than before digits before the decimal %           if  dp - 1 > before  then & J             message error: "Maximum digits (including negative sign) " + &C                            "before decimal point:  " + str$(before)          elseG           if  val(nbr$) < 0  then before = before - 1   ! Make it count G                                 !  negative signs - force another zero. J           !  Check that there are at least -before zeros after the decimalG           if  nbr$[dp + 1: dp - before] <> repeat$('0',-before)  then & F             message error:  "Minimum zeros after decimal point:  " + &)                             str$(-before)          end if   96699   end routine       J 96700   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,         !  D I G I T   C H E C K   A F T E RJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F         !  Check the number of digits "after" the decimal point.  OnlyE         !    allow a certain number of digits after the decimal point I         !    If the number of digits allowed < 0, then force zeros before          !    the decimal point.          !  Expects: J         !    after = # digits after the decimal point (or zeros before the;         !               decimal point if after is negative) O         !    nbr$  = the number you are checking (with a trailing decimal point .         !               if none was indicated)6         !    dp    = the location of the decimal point         !  Result:H         !    _error = true if the number has too many/too few characters(         !       in the proper positions.J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine digit_check_after    96720   if  after >= 0 then M           ! Check that there are not more than after digits after the decimal ,           if  len(nbr$) - dp > after  then &K             message error:  "Maximum digits after the decimal point:  " + & '                             str$(after)          elseI           ! Check that there are at least -after zeros before the decimal E           if  ans$[dp + after:dp - 1] <> repeat$('0', -after)  then & K             message error:  "Minimum zeros before the decimal point:  " + & (                             str$(-after)         end if   96799   end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'         ! D O   F O R M A T   C H E C K J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.         !make sure that the data fits the mask	         !          ! Expected: 	         !          ! Result  : 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine do_format_check   >         if  tot_fld_lines(change_field) > 1 then  exit routine         dfc_numeric = false 4         for valid_element = 1 to max_validation(fld)8           select case valid_element$(fld,valid_element) /             case 'NUMBER'  : dfc_numeric = true /             case 'INTEGER' : dfc_numeric = true /             case 'DIGITS'  : dfc_numeric = true              case else            end select         next valid_element         if  dfc_numeric  then "           display_data = val(ans$)         else           display_data = ans$          end if         when exception in =           z$ = format$(display_data, str_mask$(change_field))          use          end when*         if  not _error  then  exit routineQ         message error : "Data doesn't fit print mask: " + str_mask$(change_field) J         error = true              ! To keep it from wiping out the message         default$ = ans$          gosub ask_new_dataI         took_default = false      ! They didn't take the default, or they J                                   !   wouldn't be here in the first place.O         error = (_back or _exit)  ! Fixed the error unless you did one of these              end routine         