 $ create nl:comment   + 	EXPANDV5.DCL -- Template Expansion Utility  	David Cressey    1999-05-21  , 	This is a self extracting DCL command file.2 	To extract, copy this file to an empty directory,& 	then issue the following DCL command:   	$  @EXPANDV5.DCL   7   	This will create the files that compose the package.   6 	The file type is .DCL instead of .COM to avoid mixups) 	when the file is moved through desktops.    $  $ create EXPAND.DOC  $ deck /dollars = #EXPAND.DOC       EXPAND DOCUMENTATION  	David Cressey    1999-05-21  J EXPAND is a utility for generating repetitive scripts,  called expansions.K EXPAND generates an expansion by applying a list to a template.  This works L much the same way as a mail merge facility generates a mailing by applying a  mailing list to a form letter.    L Expansions, lists, and templates are all text files.  This means you can useH a text editor to prepare or revise lists and templates before expanding,@ and you can also use a text editor to revise an expansion after.  H I wrote EXPAND to help me with certain chores that recur in my work as aJ database consultant.  Most of the expansions I generate are scripts in SQLM or DCL.  I have also generated code fragments in languages like C.  You could 9 use it for scripts in just about any text based language.   H You can use the same list with many templates,  and you can use the sameI template with many lists.  For such a small tool, the flexibility you get  is surprising.    B EXPAND is implemented as three small DCL procedures:   EXPAND.COM,B EXTRACT.COM, and XP.COM.  Included in the package are two examples; that illustrate the use:   EXAMPLE_1.COM and EXAMPLE_2.COM. - This file, EXPAND.DOC, completes the package.   I EXPAND will run in any OpenVMS environment.  It is especially useful when F a relational database can be used as a source for the data in a list.  See example 1.  E Lists are an input to EXPAND that provide the ACTUAL PARAMETERS to be H used when an expansion is generated.  Each repetition of the template isF marked by an "XP" command in the data list.  The XP command is defined* in EXPAND.COM and implemented in XP.COM.    I Parameters to the XP command are data that will make up the variable part K of the expansion.  The parameters are matched up with the formal parameters F P1, P2, P3, ... P8 by position.  Different lists use different numbers of parameters.  B Templates are an input to EXPAND that contain a pattern that is toC be repeated in the expansion.  For each copy of the template in the D expansion, certain tokens, called FORMAL PARAMETERS, in the templateG are replaced by actual parameters  from the list. The formal parameters H follow the  convention for DCL, and have the form:  P1, P2, P3, .. P8.    D One of the easiest and most powerful ways to make a list is to use aF relational dataase as the source,  and use the power of SQL to collectF the right data for you.  The procedure EXTRACT.COM fixes up the outputD that comes out of interactive SQL by commenting out text like column headers.  See example 1.  E There are two examples included in this package.  They illustrate how F to generate a list from a relational data source,  and how to generateH an expansion from a template and a list.  In order to make the examples J easier to run,  I used a create command instead of a text editor to create some of the input files.  F In the first example,  a relational database is used as the source forG the list.  The goal is to generate four SQL commands to set up security D for each of the tables in a database,  and four more SQL commands to( set up security for the database itself.  D You need RDB and an RDB database to run example 1.  You also need toD define the logical SQL$DATABASE to specify your default database, orA have the appropriate commands in your SQLINI file so that the SQL D query in example 1 can run.  If you have RDB, but you don't know how1 it works,  send me some e-mail and I'll help you.     G To run example 1,  just enter "@example_1"  to DCL.  After it finishes, H there will be these four files in your directory:  GRANT_PRIVS.TEMPLATE,8 GRANT_PRIVS.LIS,  GRANT_PRIVS.LST,  and GRANT_PRIVS.SQL.  E To run example 2, just enter "@example_2" to DCL.  After it finishes, B there will be four files in your directory:  MAKE_EXPAND.TEMPLATE,6 MAKE_EXPAND.LST, MAKE_EXPAND.COM,  and EXPAND_NEW.DCL.    E These two examples should illustrate how to run EXPAND and EXTRACT.   @ A definition of the parameters to each of these two utilities isB in a comment at the end of the file.  The user doesn't run XP.COM,F the third component,  directly.  It gets called by the list,  once for each list entry.  ? I have also used this tool with Oracle's SQL*PLUS. SQL*Plus has = some handy features that make EXPAND a little less necessary, > but it still comes in handy.   Also,  I've never run EXPAND onC a non VMS platform,  although I'm told that there are DCL emulators 7 out there.  If you know of one,  please send me e-mail.   E The procedures have been stable since version 1.  I renamed the three B procedures,  and I've rewritten the examples and the documentation> a few times.  Otherwise,  it's just like it was 7 years ago,   when I wrote it.  J EXPAND isn't  a perfect tool.  Complicated data items, like "24-APR-1999",D tend to be misinterpreted when they are passed as actual parameters.K I use other tools when EXPAND isn't the right tool. In order to put single  I or double quotes around a formal parameter,  you have to use very strange M syntax in the template, in order to make the formal parameter visible to DCL. 7 Here are the rules for bracketing a formal with quotes:   / 		No Quotes         ''P1'      becomes   ACTUAL 1 		Single quotes     '"'P1'"'   becomes   'ACTUAL' 1 		Double quotes     ""''P1'""  becomes   "ACTUAL"   : It isn't very pretty, but it works with DCL grammer rules.   How it works  F DCL has all the facilities in it required to detect formal parameters,D manage the context,  and substitute actual parameters.  EXPAND makesB use of all that power,  in order to get DCL to do the hard work.  < The heart of the  technique is the line in XP.COM that says:  '      $ CURRENT_LINE = "''CURRENT_LINE'"   D This should be read as "re-evaluate the current line in the current D context."  After this line has been executed,  the actual parametersE have replaced the formal parameters in the current line.  The rest of  the code is routine.   Terms   B I've made EXPAND free to you, so don't charge others for my work. = I'm not asking for a shareware donation. I put more work into D this document and the examples than I did into developing the code. H Once you learn the technique I used to build EXPAND,  you can include it< in your own work.  That is really what I'm sharing with you.  F Apart from that,  I'm hoping that some potential clients will see thisH free sample,  and contact me for professional services.  I invite you toI contact me, whether you need consulting,  or just to make a comment about  EXPAND.    Enjoy!          David Cressey,  Consultant       mailto:david@dcressey.com        www.dcressey.com     #EXPAND.DOC  $  $ create EXPAND.COM  $ deck /dollars = #EXPAND.COM  $ create nl:comment   / 	EXPAND.COM -- Framework for the EXPAND utility  	DGC -- 25-JAN-1997   4 	This generates a script from a list and a template.     Usage:  . 	P1 -- Specifies the data List file to be read- 	P2 -- Specifies the template file to be read 1 	P3 -- Specifies the expansion file to be created   " 	See EXPAND.DOC for documentation.     $ on error then exit7 $ if P1 .eqs. "" then inquire P1 "Data list File Spec:" 7 $ if P2 .eqs. "" then inquire P2 "Template File Spec: " 7 $ if P3 .eqs. "" then inquire P3 "Output File Spec:   "  $  $ open/write XP_OUTPUT 'P3'  $ define/nolog XP_TEMPLATE 'P2' 
 $ XP == "@XP"  $ @'P1'  $ deassign XP_TEMPLATE $ close XP_OUTPUT  $ exit #EXPAND.COM  $  $ create XP.COM  $ deck /dollars = #XP.COM  $ create nl:comment   - 	XP.COM  --  Core component of EXPAND utility  	DGC  25-JAN-1997   - 	This expands one list entry from a template. ' 	Arguments are data for the list entry.   " 	See EXPAND.DOC for documentation.   $ on error then exit  $ open/read XP_INPUT XP_TEMPLATE $ NEXT_LINE:, $ read/end=INPUT_DONE  XP_INPUT CURRENT_LINE" $ CURRENT_LINE = "''CURRENT_LINE'" $ write XP_OUTPUT CURRENT_LINE $ goto NEXT_LINE $ 
 $ INPUT_DONE:  $ close XP_INPUT $ exit #XP.COM  $  $ create EXTRACT.COM $ deck /dollars = #EXTRACT.COM $ create nl:comment   3 	File EXTRACT.COM  -- adjunct to the EXPAND utility  	DGC 25-JAN-1997  9 	This prepares SQL output for running as a DCL procedure. 6 	The lines that are DCL commands must begin with a "$"= 	As the first non blank character.  Other lines are converted  	into DCL comments.    	Usage:    	P1 -- Input file spec 	P2 -- Output file spec   %     See EXPAND.DOC for documentation.    $ on error then exit5 $ if P1 .eqs. "" then inquire P1 "Input File Spec:  " 5 $ if P2 .eqs. "" then inquire P2 "Output File Spec: "  $  $ open/read XT_INPUT 'P1'  $ open/write XT_OUTPUT 'P2'  $  $ NEXT_LINE:+ $ read/end=INPUT_DONE XT_INPUT CURRENT_LINE + $ TRIM_LINE = f$edit (CURRENT_LINE, "trim") A $ if f$extract (0, 1, TRIM_LINE) .nes. "$" then goto COMMENT_LINE  $ write XT_OUTPUT TRIM_LINE  $  $ CONTINUE_LINE:C $ CURRENT_LAST = f$extract (f$length (TRIM_LINE) - 1, 1, TRIM_LINE) / $ if CURRENT_LAST .nes. "-" then goto NEXT_LINE + $ read/end=INPUT_DONE XT_INPUT CURRENT_LINE  $ write XT_OUTPUT CURRENT_LINE+ $ TRIM_LINE = f$edit (CURRENT_LINE, "trim")  $ goto CONTINUE_LINE $  $ COMMENT_LINE: & $ write XT_OUTPUT  "$! ", CURRENT_LINE $ goto NEXT_LINE $ 
 $ INPUT_DONE:  $ close XT_INPUT $ close XT_OUTPUT  $ exit #EXTRACT.COM $  $ create EXAMPLE_1.COM  $ deck /dollars = #EXAMPLE_1.COM $ create nl:comment  	  	EXAMPLE_1.COM  ' 	Example 1 of use of EXPAND and EXTRACT  	David Cressey 	1998-11-30   9 	This illustrates the use of EXPAND with a list generated > 	from a SQL query. You need a default RDB database,  specified; 	by the logical SQL$DATABASE or by your SQLINI file, to run  	this example.     	    	Commentary  follows the code.   $ create GRANT_PRIVS.TEMPLATE       grant all         on ''P1' ''P2'           to XYZ_DBA         position 1;   '    grant select, insert, update, delete          on ''P1' ''P2'           to XYZ_API         position 2;         grant select          on ''P1' ''P2'           to XYZ_USER          position 3;        revoke all         on ''P1' ''P2'         from PUBLIC          position 4;   ( ----------------------------------------
 $ mcr sql$            set transaction read only;     set output GRANT_PRIVS.LIS       select distinct 
 	' $ XP ',	 	'table',  	RDB$RELATION_NAME     from 	RDB$RELATIONS	     union      select distinct 
 	' $ XP ', 	'database', 	'RDB$DBHANDLE'      from 	RDB$DATABASE;       set nooutput
     rollback;   * $ @extract GRANT_PRIVS.LIS GRANT_PRIVS.LST> $ @expand GRANT_PRIVS.LST GRANT_PRIVS.TEMPLATE GRANT_PRIVS.SQL $ exit $  $ create nl:comment       Commentary on Example 1  > This example generates an SQL script with four  grant commands@ for every user table, system table and view in the database, andH four more commands for the database itself.  The database is referenced F by logical name SQL$DATABASE.  See EXPAND.DOC for further explanation.  F The first step creates a template, GRANT_PRIVS.TEMPLATE.  The template> has a prototype of the four commands that will be produced for> each entry in the list.  P1 stands for one of the two keywordsG "TABLE" or "DATABASE".  P2 stands for a table name or a database alias.   A  The next  step is to create a data list with one entry for every B table or view, and an entry for the database. This is done with anE SQL query.  The query prefixes each row of the result with the string F " $ XP ", which makes it a dcl command. The result of the query is putD in file GRANT_PRIVS.LIS.   A union is used to append the extra entry for the database itself.  D  The next step is to clean up the SQL output.  The EXTRACT procedureA does this,  and write the cleaned up version in  GRANT_PRIVS.LST. C GRANT_PRIVS.LST is ready to run under DCL, under control of EXPAND.    A The next step uses EXPAND to apply the data list to the template, C generating the script in file GRANT_PRIVS.SQL. This script is ready % to run,  or it could be edited first.    F Take a look at GRANT_PRIVS.TEMPLATE.  The contents look just like four; SQL commands,  except for the parameters P1 and P2.   These D parameters will be replaced by actual parameters in GRANT_PRIVS.SQL.D The symbols XYX_DBA, XYZ_API, and XYZ_USER are arbitrary rights list0 identifiers I made up  for the sake of example.   E Take a look at GRANT_PRIVS.LIS.  This file was written by interactive D SQL.  It contains the results of a query made on a system table,  toF obtain the name of each of the tables.  The "$ XP" at the head of each: entry flags it a DCL command that can be used with EXPAND.  B Take a look at GRANT_PRIVS.LST.  It's almost identical to the .LISC file,  with two differences:  the XP commands have been trimmed up  G so the dollar sign is in column 1 and the other text has been converted  to DCL comments.  C Now take a look at GRANT_PRIVS.SQL.  This script is ready to run.   @ It contains four SQL commands for each table,  and four more for the database itself.       #EXAMPLE_1.COM $  $ create EXAMPLE_2.COM  $ deck /dollars = #EXAMPLE_2.COM $ create nl:comment   4 	EXAMPLE_2.COM -- Second Example Illustrating EXPAND 	David Cressey 	1998-11-30  	 ; 	This example illustrates using EXPAND without a relational 8 	database.  The purpose is to pack the EXPAND components       into a single file.      	Commentary  follows the code.   $ create MAKE_EXPAND.TEMPLATE  $ deck" $! -------------------------------! $ append SYS$INPUT EXPAND_NEW.DCL  $ deck /dollars = $$ $  $ create ''P1' $ deck /dollars = #''P1' $$ $ append ''P1' EXPAND_NEW.DCL ! $ append SYS$INPUT EXPAND_NEW.DCL  #''P1' $  $ eod  $  $  $ create MAKE_EXPAND.LST $ deck $ create nl:comment   4 	This is a list file to be passed to EXPAND in order5       to generate the commands to pack the components        into a single file.    $ xp EXPAND.DOC  $ xp EXPAND.COM  $ xp XP.COM  $ xp EXTRACT.COM $ xp EXAMPLE_1.COM $ xp EXAMPLE_2.COM   $ eod  $ > $ @expand MAKE_EXPAND.LST MAKE_EXPAND.TEMPLATE MAKE_EXPAND.COM $  $ create EXPAND_NEW.DCL  $ deck $ create nl:comment   + 	EXPANDV5.DCL -- Template Expansion Utility  	David Cressey    1999-05-21  , 	This is a self extracting DCL command file.2 	To extract, copy this file to an empty directory,& 	then issue the following DCL command:   	$  @EXPANDV5.DCL   7   	This will create the files that compose the package.   6 	The file type is .DCL instead of .COM to avoid mixups) 	when the file is moved through desktops.    $ eod  $ @MAKE_EXPAND.COM! $ append SYS$INPUT EXPAND_NEW.DCL  $ deck $ exit $ ! End of EXPAND package  $ eod  $ exit   $  $ create nl:comment        Commentary on Example 2   B This example repackages the EXPAND components into  a single file.D The script to do this is generated from a template and a list,  both created inside the example.   B The first step is to create the template.  This template is prettyG simple,  because it only has one parameter,  the name of the component. H The DCL commands in the template may be ones that many DCL users haven'tG had occasion  to use. The commands package the component,  bracketed by / the commands needed to unpackage the component.   A The second step is to create the list.  In this example, the list D has just one paramter for each entry.  The parameter is the filename of the component of EXPAND.   C The third step is to run EXPAND to generate the script.  The script D contains a series of append DCL commands that will append all of the/ components onto a stub of the new package file.   > The fourth step is to generate a stub of the new package file.  @ The fifth step is to run the script generated in step 3,  above.G this packages the components at the end of the stub created previously.   3 The sixth step is to append the end of the package.   ; Look at the file EXPAND_MAKE.TEMPLATE.  It contains the DCLa> commands needed to append a single component into the package,= together with the command that makes it self extracting.  Thec= Parameter P1 will be replaced by a component name,  supplied ,< in the list.  Don't worry if the DCL seems a little obscure.? It's probably possible to rewrite it to be cleaner and simpler.T  = The file EXPAND_MAKE.LST  is just a list of the components ofi+ EXPAND.  Each entry has just one parameter.e  = The file EXPAND_MAKE.COM results from the expansion.  It willT> append the components of EXPAND onto  the file EXPAND_NEW.DCL.  H Finally, EXPAND_NEW.DCL contains a comment,  and each of the components, in self extracting format.       #EXAMPLE_2.COM $ exit $ ! End of EXPAND packageg