+ 	%title	"Formatted output in ascii and hex"  	%ident	"V1-002"  2 	sub lib_output_seg_tzb (string input_buffer			  &" 				,long alleged_buffer_size		  &! 				,long requested_segment_size)    !+ ! Version:	V1-002  !  ! Facility:	Library routines.  ! D ! Abstract:	To take a buffer and generate a formatted display of the' !		buffer as ascii and hex byte values.  !  ! Environment:	User mode.  ! 
 ! History: ! " !	15-Jun-1990, DBS, Version V1-001 ! 001 -	Original version. " !	18-Dec-1995, DBS; Version V1-002( ! 002 -	Converted from FORTRAN to BASIC. !-   !++  ! Functional Description: D !	Take the buffer as byte values and format them into ascii and hex.A !	Displays are generated from SYS$FAO and directed to sys$output. B !	Output is generated in segments of the specified size and a byteD !	offset from the start of the buffer is included with each segment. !  ! Calling Sequence: = !	call lib_output_seg_tzb (buffer, buffer_size, segment_size)  !		-or-  !	pushal	segment_size  !	pushal	buffer_size !	pushaq	buffer   !	calls	#3, g^lib_output_seg_tzb !  ! Formal Argument(s): @ !	buffer.rt.ds	Address of a string descriptor that points to the !			characters to be displayed. G !	alleged_buffer_size.rl.r  Address of a longword containing the number  !			of bytes to display.C !	requested_segment_size.rl.r  Address of a longword containing the 4 !			number of bytes to be displayed in each segment. !  ! Implicit Inputs: !	None !  ! Implicit Outputs: # !	Output is directed to SYS$OUTPUT.  !  ! Completion Codes:  !	None !  ! Side Effects:  !	None !--       	option	type = explicit,					  &! 		constant type = integer,				  & $ 		size = (integer long, real double)  $ ! External references (and includes)  ) 	external long function	lib$analyze_sdesc & 	external long function	lib$put_output  	external long function	sys$faol  ! ! Type declarations for constants   0 	declare long constant	default_segment_size = 16, 	declare long constant	max_segment_size = 323 	declare long constant	max_array_size = 38	! 32 + 6 D 	declare string constant	fao_data = "  [!#<!AF!>]-!5UL-[!XB!#(3XB)]"  ! ! Type declarations for variables   ) 	declare long	b_byte(1 to max_array_size)  	declare long	buffer_size   	declare long	bytes_this_segment 	declare long	counter  	declare long	fao_len  	declare long	first  	declare long	last 	declare string	fao_line 	declare long	loop  	declare long	number_of_segments 	declare long	segment_size 	declare long	string_address 	declare word	string_size    !+
 ! Mainline !-	 mainline:    	fao_line = space$(512)   3 	call lib$analyze_sdesc (input_buffer by desc			  &  				,string_size by ref			  &  				,string_address by ref)     	buffer_size = len(input_buffer)' 	if ((alleged_buffer_size >= 1)					  & 1 			and (alleged_buffer_size <= buffer_size)) then # 		buffer_size = alleged_buffer_size  	end if   & 	segment_size = requested_segment_size 	if (segment_size < 1) then % 		segment_size = default_segment_size  	end if * 	if (segment_size > max_segment_size) then! 		segment_size = max_segment_size  	end if   C 	number_of_segments = (buffer_size - 1 + segment_size)/segment_size 	 	loop = 0   " 	while (loop < number_of_segments) 		first = loop*segment_size + 1 " 		last  = first + segment_size - 1 		if (last > buffer_size) then 			last = buffer_size  		end if' 		bytes_this_segment = last - first + 1    		b_byte(1) = segment_size  		b_byte(2) = bytes_this_segment( 		b_byte(3) = string_address + first - 1 		b_byte(4) = first - 1 0 		b_byte(5) = ascii(mid(input_buffer, first, 1))$ 		b_byte(6) = bytes_this_segment - 1  ' 		for counter = 2 to bytes_this_segment  			b_byte(counter+5)				  & 5 			    = ascii(mid(input_buffer, first+counter-1, 1))  		next counter  ( 		call sys$faol (fao_data by desc				  & 				,fao_len by ref				  & 				,fao_line by desc			  &  				,b_byte() by ref)   / 		call lib$put_output (left(fao_line, fao_len))    		loop = loop + 1  	next    	end sub