	 [INHERIT( +          'sys$library:pascal$SMG_routines',  	 'pascal$CLI_routines', 	 'sys$library:STARLET',$ 	 'sys$library:pascal$LIB_routines',% 	 'sys$library:pascal$STR_routines'),  IDENT('V2.0')]   PROGRAM EPYT (input, output);    {   1990 Charles van den Ouweland H I wrote this program in my spare time. I would like to express my thanksB to Alcatel Telecom Systems b.v. in the Hague, the Netherlands, for8 supplying the environment to make this program possible.F You can redistribute this program and/or modify it under the terms of A the GNU General Public License as published by the Free Software  D Foundation; either version 2, or (at your option) any later version.? This program is distributed in the hope that it will be useful, > but WITHOUT ANY WARRANTY; without even the implied warranty of= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the , GNU General Public License for more details.   PROGRAM DESCRIPTION:    H     Type a file, starting with the last record, and scrolling backwards.  H     This program was especially designed for very large files, for whichH     it is a bore to start an editor to look at the last lines of a file.         Restrictions: B     o	This program is not guaranteed to work on any file. However,         it may work.= 	Particularly, the program will not work correctly on a file  , 	in which one of the records ends in two NUL0 	characters. However, this is not the only case.       o	Supports only disk-files.   K     o   Supports files with varying record size (most text files, including D 	those usually created with text editors and the DCL CREATE command)  1     o	Supports files with VFC with print control. & 	However the control field is ignored.C 	Files created by the DCL OPEN/WRITE command and log files, created 7 	by the DCL SUBMIT command have VFC with print control.        Parameters       P1: input filespec       Qualifiers:   	     /PAGE > 	Indicates that output should be done page-by-page, requesting* 	the user to press Return after each page.C 	This qualifier is ignored when the output device is not a terminal      /OUTPUT[=filespec]8 	Redirects output to a different device than SYS$OUTPUT.E 	If the output device is a terminal, lines of output are truncated if D 	they would not fit on a terminal's line. Truncation is indicated by 	a diamond-shape.        Key definitions.  L     For EPYT/PAGE, after the prompt "Enter Return to Continue" the following%     keys can be typed (one at a time)   2 Return	        next page	  (or any undefined key) Prev Screen	next page down     Next Screen	next page up       Space Bar	next line& Down Arrow	next line down	    (or KP4)% Up Arrow	next line up	    (or KP5)	   	 S		scroll " F10		exit              (or CTRL/Z) Find           search PF3             find next  Help            give help   ; ) The definitions of Return and Space Bar can be exchanged < by giving the /UNIX qualifier for compatibility with 'more'.H ) The prompt Search: can be answered using wildcards % (matches any oneH character) or * (match zero or more characters. Lower- and uppercase areK not distinct (Bla matches BLA as well as bla). The prompt can be terminated  by pressing:  ' Return		Search in the current direction  PF4/Next screen Search forward PF5/Prev screen Search reverse    	 AUTHORS:         Charles van den Ouweland   CREATION DATE:	29-FEB-1990     	    C H A N G E   L O G  %      Date     |   Name  | Description P --------------+---------+-------------------------------------------------------<  15-apr-1990  |   CvdO  |  reset cursor at last line on exitB               |         |  limited support for carriage=none filesP --------------+---------+-------------------------------------------------------L  20-jun-1990  |   CvdO  |  Remove (CR)LF on end of record of car=none files.M               |         |  Replace all other CR LF FF VT's by SUB (reverse ?) P --------------+---------+-------------------------------------------------------L  17-may-1991  |   CvdO  |  Support for scrolling towards the end of the fileL               |         |  (like TYPE does!). This can be activated in /PAGE<               |         |  mode by entering Prev-screen key.C               |         |  Also other key functions are introduced. @ 	      |         |  I am using SMG routines now but only for the? 	      |         |  keyboard input, not for the display output. P --------------+---------+-------------------------------------------------------J  21-oct-1991  | CvdO    |  /[no]newline[="value"] specifies an alternative> 	      |         |  way of representing the 'reverse linefeed'P --------------+---------+-------------------------------------------------------   %[change_entry]% }    CONST      blocksize = 512;G     maxrecsiz = 180; {maximum width of records before records are	    } ? 		     {truncated. However, when /OUTPUT is a terminal, the   } 0 		     {terminal width takes precedence.			    }   CONST      TAB		= CHR   (9);      LF          = CHR  (10);     VT          = CHR  (11);     FF		= CHR  (12);     CR		= CHR  (13);     SO		= CHR  (14);     SI		= CHR  (15);     SUB         = CHR  (26);     ESC		= CHR  (27);      NEL         = CHR (133);     RI		= CHR (141);     SS3		= CHR (143);      CSI		= CHR (155);      new_line	= CR + LF; &     reverse_lin = CR + RI + CSI + 'K';     diamond	= SS3 + '`';     bold	= CSI+'1m';     reversevid	= CSI+'7m';     sgroff	= CSI+'m';      home        = CSI + 'H';     last_line   = CSI + '99H';+     cls		= home + CSI + 'J'; {clear screen} M     bufsiz      = maxrecsiz+4; {The buffer is taken a little bigger 'cause  } 5 			       {bytes may get lost due to odd record	    } 5 			       {lengths and/or 2 bytes for VFC/print	    }    TYPE     $ubyte = [BYTE] 0 .. 255;      $byte = [BYTE] -128 .. 127;        $uword = [WORD] 0 .. 65535; #     $word = [WORD] -32768 .. 32767;   <     descriptor = {used to build a dynamic string descriptor} 		    RECORD 			dsc$w_length:	$uword; 			dsc$b_dtype:	$ubyte;  			dsc$b_class:	$ubyte;  			dsc$a_pointer:	unsigned; 
 		    END;       record_formats = (Fixed, 		     Stream, 		     Stream_CR,  		     Stream_LF,  		     Undefined,  		     Variable, 		     VFC,  		     VFC_print);"     direction = (forward,reverse);     iosb_t=	    RECORD 			cond_val:   $uword; 			res_length: $uword; 			terminator: $uword; 			term_length:$uword;
 		    END;/     xh_user_data = {user data for exit handler}                      RECORD. 		    old_char_ptr: ^characteristics_buffer_t;'                     io_channel: $uword;                      END;@     desblk_t=       [static] {descriptor block for exit handler} 		    RECORD 			fwd_lnk:        unsigned; 			exh_address :   unsigned; 			arg_cnt:	unsigned;  			cond_val_ptr:	^unsigned;  			user_data:	^xh_user_data;
 		    END;     characteristics_buffer_t=  		    RECORD 			device_class:   $ubyte; 			terminal_type:  $ubyte; 			page_width:	$uword; 			basic_char:	tt$type;  			extended_char:  tt2$type;
 		    END;8     characteristics_pointer = ^characteristics_buffer_t;     mailbox_message_type  =  	RECORD  	    message_type	: $uword;  	    unit_number		: $uword;   	    controller_length	: $ubyte;3 	    controller_name	: packed array[1..15] of char; , 	    broadcast_message	: varying[1] of char; 	END;    VAR 3     output_filespec:	varying[nam$c_maxrss] of char;      page_length:	integer; K     unsolicited_data:	[volatile] boolean; {indicates that the user wants  }  					    {to type something.}   # PROCEDURE set_nowrap (chan: $uword; / 		      old_char_ptr: characteristics_pointer);   !     {sets the terminal to nowrap}        VAR  	stat: unsigned; 	iosb: iosb_t;/ 	new_characteristics: characteristics_buffer_t;  	desblk: desblk_t;  5 	    [ASYNCHRONOUS, UNBOUND]PROCEDURE my_exit_handler  	       (exit_stat:		unsigned;# 	        user_data:		xh_user_data); ( 		{Reset the original terminal settings} 		const # 		    reset_cursor = last_line+LF;   		var  		    iosb: iosb_t;  		    stat: unsigned;  		BEGIN + 		{reset the cursor, last line of terminal} 
 		stat:=$QIOW $ 			 (chan   := user_data.io_channel,+ 			  func   := io$_writevblk+io$m_canctrlo,  			  iosb   := %ref iosb, # 			  p1     := %ref (reset_cursor), - 			  p2     := %immed length (reset_cursor)); ' 		if not odd(stat) then lib$stop(stat); 9 		if not odd(iosb.cond_val) then lib$stop(iosb.cond_val); . 		stat:=$QIOW (chan   := user_data.io_channel, 			     func   := IO$_SETMODE, 			     iosb   := %REF iosb,* 			     p1     := user_data.old_char_ptr^,2 			     p2     := size(characteristics_buffer_t));' 		if not odd(stat) then lib$stop(stat); 9 		if not odd(iosb.cond_val) then lib$stop(iosb.cond_val);  		END { my_exit_handler }; 	     	     BEGIN I     {Establish an exit handler to reset the port characteristics on exit} 5     desblk.exh_address:=  iaddress (my_exit_handler);      desblk.arg_cnt:=      2;     new (desblk.cond_val_ptr);  M     {put the io channel and the address of the old characteristics buffer   } 2     {in the exit handler descriptor block				    }     new (desblk.user_data); (     desblk.user_data^.io_channel:= chan;2     desblk.user_data^.old_char_ptr:= old_char_ptr;     stat:= $DCLEXH (desblk);)     if not odd(stat) then lib$stop(stat);   '     {change terminal's characteristics} (     new_characteristics:= old_char_ptr^;5     new_characteristics.basic_char.tt$v_wrap:= false;       stat:=$QIOW (chan   := chan, 		 func   := IO$_SETMODE,  		 iosb   := %REF iosb, ! 		 p1     := new_characteristics, - 		 p2     := size(characteristics_buffer_t)); )     if not odd(stat) then lib$stop(stat); ;     if not odd(iosb.cond_val) then lib$stop(iosb.cond_val);      END { set_nowrap };   $ PROCEDURE unsolicited_data_detection     (mbx_chan: $uword);    M     { Associates an AST with the event of the user typeing when no read i/o } M     { from the terminal is outstanding. This is called unsolicited data or  } I     { typeahead. When this occurs, the AST sets the global variable	    } )     { unsolicited_data to true						    }              VAR          stat: unsigned; % 	iosb:     [static, volatile] iosb_t; % 	channel:  [static, volatile] $uword; 3 	message:  [static, volatile] mailbox_message_type;   7         [ASYNCHRONOUS, UNBOUND] PROCEDURE terminal_ast;  	             M             {This is the AST (Asynchronous System Trap) that is called when } 0 	    {unsolicited data (type-ahead) is detected}	                        VAR                  stat: unsigned;                BEGIN > 	    if not odd(iosb.cond_val) then lib$signal(iosb.cond_val);. 	    IF message.message_type = msg$_trmunsolic" 	    THEN unsolicited_data:= true;# 	    {Zet de ast opnieuw op scherp}  	    stat:= $QIO 		      (chan   := channel,   		       func   := IO$_READVBLK, 		       iosb   := iosb,' 		       astadr := %immed terminal_ast,   		       p1     := %ref message,0 		       p2     := size (mailbox_message_type));, 	    if not odd(stat) then lib$signal(stat);             END; {terminal_ast} 	           &     BEGIN {unsolicited_data_detection}     channel:= mbx_chan;      {Zet de ast op scherp}     stat:= $QIO  	      (chan   := channel, 	       func   := IO$_READVBLK,  	       iosb   := iosb, & 	       astadr := %immed terminal_ast, 	       p1     := %ref message, / 	       p2     := size (mailbox_message_type)); +     if not odd(stat) then lib$signal(stat); !     END; {watch_typeahead_buffer}      $ PROCEDURE manipulate_terminal_device. 		    (device_name	  : varying[$len1] of char;& 		     var width            : integer;! 		     var page_size	  : integer; ' 		     var terminal         : boolean);    M     { performs a getdvi to get the terminal's page size, i.e. the number of } @     { lines on the terminal screen, usually 24 and width.		    }               VAR  	dev_chan: [volatile] $uword;  	iosb: iosb_t; 	its_a_terminal: integer;  	mbx_chan: [volatile] $uword; @ 	old_characteristics: [volatile,static]characteristics_buffer_t; 	retlen: [volatile] integer; 	stat: unsigned;       	     BEGIN      unsolicited_data:= false;      {test if it is a terminal}:     stat:= lib$getdvi (item_code              := DVI$_TRM,/ 		       device_name            := device_name, 3 		       longword_integer_value := its_a_terminal); 2     terminal:= odd (stat) and odd(its_a_terminal);       IF terminal      THEN 	BEGIN                    # 	{assign a channel to the terminal}  	stat:= LIB$ASN_WTH_MBX ) 		  (device_name          := device_name, 8 		   maximum_message_size := size(mailbox_message_type), 		   buffer_quota         := 0, & 		   device_channel       := dev_chan,' 		   mailbox_channel      := mbx_chan); ( 	if not odd(stat) then lib$signal(stat);  ! 	{get terminal's characteristics} ! 	stat:=$QIOW (chan   := dev_chan,  		     func   := IO$_SENSEMODE,  		     iosb   := %REF iosb, % 		     p1     := old_characteristics, 1 		     p2     := size(characteristics_buffer_t)); & 	if not odd(stat) then lib$stop(stat);8 	if not odd(iosb.cond_val) then lib$stop(iosb.cond_val);  7 	page_size:=  old_characteristics.basic_char.tt$v_page; - 	width:=	     old_characteristics.page_width; 6 	set_nowrap (dev_chan, address (old_characteristics));' 	unsolicited_data_detection (mbx_chan);      END;'     END { manipulate_terminal_device };     FUNCTION locate_tab %    (var buf: varying[$len1] of char;        start_position: integer:= 1;$     character: char:= TAB) :integer;  )     {Locate a tab in a string.						    } *     {Return zero when not found						    }8     {Return start_position when buf[start_position]=TAB}   	VAR 		descriptor : dsc1$type;  		i: [unsafe] integer;  	     BEGIN "     IF start_position > buf.length     THEN 	locate_tab:=0     ELSE 	BEGIN 	WITH descriptor DO 
 	    BEGIN; 	    dsc$w_maxstrlen	   := buf.length - start_position + 1; & 	    dsc$b_dtype		   := dsc$k_dtype_t;& 	    dsc$b_class		   := dsc$k_class_s;4 	    dsc$a_pointer::integer := IADDRESS (buf.body) + 				      start_position - 1; 	 	    END; 
 	i:= LIB$LOCC ' 	       (character_string := character, ' 		source_string    := %ref descriptor);  	IF i=0  	THEN locate_tab:=0 * 	ELSE locate_tab:= start_position + i - 1; 	END;      END { locate_tab };    PROCEDURE truncate_line %    (VAR buf: varying[$len1] of char;       max_length: integer);   /     {Truncate a line, when necessary.					    } #     {Will interpret TABs						    }      {}     LABEL exit;        VAR 2 	offset: integer; {counts extra space due to tabs} 	i: integer; 	buf_len: integer; 	tab_size: 1..8;  	     BEGIN      buf_len:= buf.length;      IF buf_len * 8 > max_length      THEN 	BEGIN 	offset:= 0; 	i:= locate_tab (buf);- 	WHILE (i<>0) AND (i+offset <= max_length) DO 
 	    BEGIN' 	    tab_size:= 8 - (offset+i-1) MOD 8; $ 	    offset:= offset + tab_size - 1; 	    IF i+offset > max_length 	 	    THEN  		BEGIN ! 		offset:= offset - tab_size + 1;  		buf:= SUBSTR (buf, 1, i-1); 6 		buf:= PAD (buf, ' ', max_length-offset-1) + diamond; 		goto exit; 		END; 	    i:= locate_tab (buf, i+1)	 	    END;  	IF buf_len+offset > max_length  	THEN {must truncate} 
 	    BEGIN8 	    buf:= SUBSTR (buf, 1, max_length-offset-1)+diamond;	 	    END;  	END; 	     exit:      END { truncate_line };  P {*****************************************************************************} VAR  	block_nr:	unsigned;  	buffer:		RECORD CASE INTEGER OF; 			    1:  (char_buf: packed array [1..blocksize] of CHAR); 8 			    2:  (byte_buf: array [0..blocksize-1] of $ubyte);@ 			    3:  (word_buf: array [0..blocksize div 2 - 1] of $uword); 			END;  	byte_nr:	integer;0 	carriage_ctrl:	(none, implied, fortran, print); 	current_direction: direction;% 	epyt_cld:	[value,external] unsigned; 8 	default_name:	[volatile] varying[nam$c_maxrss] of char; 	end_block:	unsigned;  	first_free_byte: integer;5 	file_name:	[volatile] varying[nam$c_maxrss] of char; ' 	foreign_command: varying[132] of char; 
 	i:		integer;  	keyboard_id:	unsigned;  	leng:		integer;  - 	line_count:	integer; {lines on current page}  	max_records:	integer;& 	my_fab:		[volatile, static] fab$type;& 	my_rab:		[volatile, static] rab$type;& 	my_xab:		[volatile, static] xab$type;& 	newline_qual:	boolean; {/[NO]NEWLINE} 	num_byt:	integer;(         page_qualifier: boolean; {/page}" 	rec_buf:	varying[bufsiz] of char;R 	rec_len_field:  integer; {points to the buffer where the record length is stored} 	record_format:	record_formats;s  	requested_direction: direction;# 	reverse_line:	varying[20] of char;a 	seek:		integer; 	st:		varying[30] of char; 	stat:		unsigned;w6 	terminal:	boolean; {is the output device a terminal?}(         unix_qualifier: boolean; {/unix}" 	width:		integer; {terminal width}     	PROCEDURE output_line;a             VARi                 stat: unsigned;t! 		terminator,terminator2: $uword;c$ 		searching: [static]boolean:=false;3 		search_string: [static] varying[100] of char:='';i4 		search_pattern: [static] varying[102] of char:=''; 	                  l 		PROCEDURE match_line;                      VARn0                         upcase_desc: descriptor;                      P                     BEGIN $ 		    upcase_desc.dsc$w_length := 0;/ 		    upcase_desc.dsc$b_dtype := DSC$K_DTYPE_T; / 		    upcase_desc.dsc$b_class := DSC$K_CLASS_D; % 		    upcase_desc.dsc$a_pointer := 0;d                       STR$UPCASE?                        (destination_string := %REF upcase_desc,a7                         source_string      := rec_buf); +                     stat:= str$match_wild ( D                                candidate_string := %REF upcase_desc,A                                pattern_string := search_pattern);r: 		    case lib$match_cond (stat, str$_match, str$_nomatch) 		    of	0: lib$signal(stat);r 			1: begin ! 			   line_count:= page_length-1;s 			   searching:= false;
 			   end; 			2: ;e 			end;d                     END;  
 	    BEGIN 	    IF unsolicited_data? 	    THEN {hitting any character interrupts a scroll or search}t 		BEGIN  		page_qualifier:= true; 		line_count:= page_length;  		searching:= false; 		unsolicited_data:= false;  		IF keyboard_id=0 		THEN                     BEGINe( 		    stat:= SMG$CREATE_VIRTUAL_KEYBOARD, 			      (keyboard_id        := keyboard_id,0 			       input_device       := output_filespec,# 			       recall_size        := 0);c- 		    if not odd(stat) then lib$signal(stat);R                     END; 		END; 	    IF page_qualifier	 	    THENt 		BEGINs? 		{ line_count is the number of the line about to be written  }i 		IF searching 		THEN match_linei! 		ELSE line_count:= line_count+1;  		if line_count>=page_length 		THEN 		    BEGINt 		    line_count:= 1; / 		    writeln (PAD ('', ' ', (width-24) div 2), 5 			    reversevid+'Press RETURN to continue'+sgroff); -                     stat:= SMG$READ_KEYSTROKE C                               (keyboard_id          := keyboard_id, C                                word_terminator_code := terminator);r8 		    if lib$match_cond (stat, ss$_normal, smg$_eof) = 0 		    then lib$signal(stat); 		    if (terminator=ord('s')) 		    or (terminator=ord('S'))! 		    then page_qualifier:= falsey
 		    else;                     if (terminator = smg$k_trm_next_screen) ( 		    then requested_direction:= forward
 		    else;                     if (terminator = smg$k_trm_prev_screen)a( 		    then requested_direction:= reverse
 		    else4                     if (terminator = smg$k_trm_down)3                     or (terminator = smg$k_trm_kp4)t 		    then begin" 			 requested_direction:= forward; 			 line_count:= page_length-1;a 			 ende
 		    else2                     if (terminator = smg$k_trm_up)3                     or (terminator = smg$k_trm_kp5)- 		    then begin" 			 requested_direction:= reverse; 			 line_count:= page_length-1;  			 end 
 		    elseN                     if ((terminator = smg$k_trm_space) and not unix_qualifier)J                     or ((terminator = smg$k_trm_ctrlm) and unix_qualifier)% 		    then line_count:= page_length-1O
 		    else5                     if (terminator = smg$k_trm_ctrlz) 3                     or (terminator = smg$k_trm_f10)  		    then $exit
 		    else4                     if (terminator = smg$k_trm_find)3                     or (terminator = smg$k_trm_pf3)r 		    then {search function}                         BEGIN  			searching:= true;# 			IF (terminator = smg$k_trm_find)  			or (search_string='') 			THEN  			    BEGIN4                             stat:= smg$read_string (% 				 keyboard_id      := keyboard_id, 5 				 prompt_string    := CR+CSI+'KWildcard search: ', . 				 resultant_string := %DESCR search_string,( 				 word_terminator_code:= terminator2,- 				 modifiers        := trm$m_tm_trmnoecho); 9 			    IF lib$match_cond (stat, ss$_normal, smg$_eof) = 0  			    THEN lib$signal(stat); &                             STR$UPCASEL                                (destination_string := %DESCR search_pattern,M                                 source_string      := '*'+search_string+'*');i/ 			    if (terminator2 = smg$k_trm_next_screen) ' 			    or (terminator2 = smg$k_trm_kp4)h) 			    then requested_direction:= forward{ 			    elseh/ 			    if (terminator2 = smg$k_trm_prev_screen)C' 			    or (terminator2 = smg$k_trm_kp5) * 			    then requested_direction:= reverse; 			    END;R3 			{The line 'under' Press Return to Continue	    }(' 			{must be checked for a match			    }S+ 			if requested_direction=current_direction; 			then match_line;;                         END 
 		    else4                     if (terminator = smg$k_trm_help)3                     or (terminator = smg$k_trm_pf2)d
 		    then 			BEGIN! 			IF current_direction = reverseI+ 			THEN write (ri+csi,page_length-14:1,'H')t 			ELSE write (lf+csi+'2H'); 			writeln   (	 ( 		       tab+csi+'K'+ESC+'olqq'+				nel+: 		       tab+csi+'Kx'+SI+ ' Key definitions in EPYT'+	nel+% 		       tab+csi+'K'+SS3+'x'+				nel+d3 		       tab+csi+'K'+SS3+'x Return	next page'+	nel+ < 		       tab+csi+'K'+SS3+'x Prev Screen	next page down'+nel+< 		       tab+csi+'K'+SS3+'x Next Screen	next page up'+	nel);6 		write (tab+csi+'K'+SS3+'x Space Bar	next line'+	nel+8 		       tab+csi+'K'+SS3+'x Up Arrow	next line up'+	nel+; 		       tab+csi+'K'+SS3+'x Down Arrow	next line down'+nel+dF 		       tab+csi+'K'+SS3+'x S		scroll - hit any key to interrupt'+nel+/ 		       tab+csi+'K'+SS3+'x Find		search'+	nel+r3 		       tab+csi+'K'+SS3+'x PF3		search next'+	nel+ - 		       tab+csi+'K'+SS3+'x F10		exit'+		nel+ $ 		       tab+csi+'K'+ESC+'omqq',SI); 			line_count:= page_length-1;! 			IF current_direction = reverse; 			THEN writeln (csi+'2H')* 			ELSE writeln (csi,page_length-1:1,'H'); 			END 		    ;t 		    write (CR, CSI, 'K'); 	 		    END  		END;  0 	    IF requested_direction <> current_direction	 	    THEN                  BEGIN 0                 IF requested_direction = reverse%                 THEN write (home, RI)e 		ELSE write (last_line, LF);  		{line_count:= 0;}h                 END;	 	    ELSEt 		BEGINdC 		{For VFC files with Print control, ignore the 2-byte control    } ) 		{field, preceding each record.				    } C 		{This control field specifies carriage conterol to be performed }gC 		{before (1st byte) and after (2nd byte) printing of the record. }pC 		{However, this usually indicates <new-line>, so we won't bother }_+ 		{to interpret the field exactly.				    }  		IF record_format= VFC_print 7 		THEN rec_buf:= SUBSTR (rec_buf, 3, rec_buf.length-2);;  C 		{If the file has carriage_control=none, there will probably be  }m6 		{CR LF combinations in the file - take care of LF's} 		IF carriage_ctrl=nonem 		THEN 		    BEGIN  		    IF rec_buf.length > 0n
 		    THEN 			{remove one trailing LF}c" 			IF rec_buf[rec_buf.length] = LF* 			THEN rec_buf.length:= rec_buf.length-1;' 			{remove one trailing CR - june 1990}r 			IF (rec_buf.length>0)  * 			and_then (rec_buf[rec_buf.length] = CR)* 			THEN rec_buf.length:= rec_buf.length-1;
 		    END;  ! 		{replace other LF, FF's by SUB}d 		STR$TRANSLATE + 		   (destination_string := %DESCR rec_buf,i$ 		    source_string      := rec_buf,, 		    translation_string := SUB+SUB+SUB+SUB,, 		    match_string       := LF +FF +CR +VT);  , 		{Insure consistent maximum record length } 		IF rec_buf.length > maxrecsizt" 		THEN rec_buf.length:= maxrecsiz;  5 		{Truncate the line so that it fits on the terminal}a
 		if terminala& 		then truncate_line (rec_buf, width);  		if requested_direction=forward" 		then writeln (rec_buf, new_line)' 		else writeln (rec_buf, reverse_line);g 		END; 	    END; {output_line}d           PROCEDURE read_block;f	          s:             {perform a $read to read block_nr into buffer}	          e             BEGIN 8 	    my_rab.rab$l_bkt:= block_nr;	    {block nr to read}' 	    stat:= $READ (rab := %ref my_rab);p= 	    if not odd(stat) then lib$stop(stat,0,my_rab.rab$l_stv);n             END; {read_block})	          t   BEGIN.H     {12-sep-1990 CvdO: get command parameters through foreign mechanism}     stat:= LIB$GET_FOREIGN;               (resultant_string := %DESCR foreign_command); +     if not odd(stat) then lib$signal(stat);_     stat:= CLI$DCL_PARSE:               (command_string := 'EPYT '+ foreign_command,/                table          := %ref EPYT_CLD,r6                param_routine  := %immed lib$get_input,- 	       prompt_string  := 'CLI$DCL_PARSE? '); &     if not odd(stat) then $exit(stat);       default_name:= '.LIS';     stat:= CLI$GET_VALUE" 	      (entity_desc := 'FILESPEC'," 	       retdesc     := file_name);)     if not odd(stat) then lib$stop(stat);      stat:= CLI$GET_VALUE  	      (entity_desc := 'OUTPUT',( 	       retdesc     := output_filespec);)     if not odd(stat) then lib$stop(stat);$  &     OPEN (FILE_VARIABLE     := output,( 	  FILE_NAME         := output_filespec, 	  HISTORY           := NEW, 	  CARRIAGE_CONTROL  := NONE,e  	  DEFAULT           := '.LIS');O     manipulate_terminal_device (output_filespec, width, page_length, terminal);D       if terminala     then BEGIN. 	 page_qualifier:= ODD (CLI$PRESENT ('PAGE'));. 	 unix_qualifier:= ODD (CLI$PRESENT ('UNIX')); 	 max_records:= maxint;t 	 END 	     ELSE i 	BEGIND 	page_qualifier:= false; {ignore /PAGE if /OUTPUT is not a terminal}$ 	if odd(cli$get_value('RECORDS',st)) 	then readv (st, max_records)r 	else max_records:= maxint;  	END;        newline_qual:= true;#     stat:= cli$present ('NEWLINE');c     CASE lib$match_cond (stat,     			 cli$_present,c     			 cli$_defaulted,g     			 cli$_negated,Y     			 cli$_absent)     of	0: lib$stop(stat); 
 	1,2:begin3 	    stat:= cli$get_value ('NEWLINE',reverse_line);p* 	    if not odd(stat) then lib$stop(stat);	 	    end;a	 	3: BEGINt 	   reverse_line:= ''; 	   newline_qual:= false;  	   END; 	4: reverse_line:= reverse_lin; 	     	END;d       IF page_qualifier$     THEN BEGIN+          stat:= SMG$CREATE_VIRTUAL_KEYBOARDr5                   (keyboard_id        := keyboard_id, 9                    input_device       := output_filespec, ,                    recall_size        := 0);0          if not odd(stat) then lib$signal(stat);          END     ELSE keyboard_id:=0;       my_fab:= zero;.     my_fab.fab$b_bid:= fab$c_bid;			{block id}2     my_fab.fab$b_bln:= fab$c_bln;			{block length}D     my_fab.fab$b_fac:= fab$m_bio+fab$m_get;		{file access: Block io}I     my_fab.fab$b_shr:= fab$m_shrget+fab$m_shrput+fab$m_upi;{file sharing} =     my_fab.fab$l_fna:= iaddress (file_name.body);	{file name} (     my_fab.fab$b_fns:= file_name.length;H     my_fab.fab$l_dna:= iaddress (default_name.body);	{default file name}+     my_fab.fab$b_dns:= default_name.length;o(     my_fab.fab$l_xab:= iaddress(My_xab);       my_xab:= zero;!     my_xab.xab$b_cod:= xab$c_fhc;r$     my_xab.xab$b_bln:= xab$c_fhclen;  &     stat:= $OPEN (fab := %ref my_fab);F     if not odd(stat) then lib$stop (stat, 0, %immed my_fab.fab$l_stv);       CASE my_fab.fab$b_rfm OF% 	fab$c_fix   : record_format:= Fixed;i& 	fab$c_stm   : record_format:= Stream;) 	fab$c_stmcr : record_format:= Stream_CR; ) 	fab$c_stmlf : record_format:= Stream_LF; ) 	fab$c_udf   : record_format:= Undefined;_( 	fab$c_var   : record_format:= Variable;" 	fab$c_vfc   : IF my_fab.fab$v_prn& 		      THEN record_format:= VFC_print! 		      ELSE record_format:= VFC;e
 	OTHERWISE
 	    BEGINB 	    lib$put_output ('Invalid FAB$B_RFM: '+HEX(my_fab.fab$b_rfm));; 	    lib$stop(%x950000+shr$_openin,1,%stdescr (file_name)); 	 	    END;, 	END;   3     IF NOT (record_format IN [Variable, VFC_print])n     THEN BEGIN 	 WRITEV (st, record_format);e< 	 str$right(%DESCR st,st,str$find_first_not_in_set(st,' '));8 	 lib$put_output ('Record Format '+st+' not supported');8 	 lib$stop(%x950000+shr$_openin,1,%stdescr (file_name)); 	 END;       IF my_fab.fab$v_cr      THEN carriage_ctrl:= implied	     ELSE s     IF my_fab.fab$v_ftnu      THEN carriage_ctrl:= fortran     ELSE     IF my_fab.fab$v_prnb     THEN carriage_ctrl:= print     ELSE carriage_ctrl:= none;     !     end_block:= my_xab.xab$l_ebk;i'     first_free_byte:= my_xab.xab$w_ffb;        my_rab:= zero;!     my_rab.rab$b_bid:= rab$c_bid;o!     my_rab.rab$b_bln:= rab$c_bln;r(     my_rab.rab$l_fab:= iaddress(my_fab);     $     stat:= $CONNECT (rab := my_rab);C     if not odd(stat) then lib$stop (stat, %immed my_rab.rab$l_stv);l  /     block_nr:= end_block; {start in last block}t  D     my_rab.rab$l_ubf:= IADDRESS (buffer);   {identify the io buffer}4     my_rab.rab$w_usz:= blocksize;	    {and its size}       byte_nr:= first_free_byte;          rewrite (output);t?     if newline_qual then writeln (RI, ESC, '+0' ,reverse_line);g       line_count:= 0;       current_direction:= reverse;"     requested_direction:= reverse;       IF byte_nr <> 0s     THEN read_block;  D     WHILE NOT ((block_nr = 1) AND (byte_nr = 0)) AND (max_records>0)     DO 	BEGIN 	max_records:= max_records-1;r( 	    {Invariant for this loop:					    }L 	    {buffer is filled with the block numbered block_nr from the file.	    }F 	    {byte_nr points to the record length of the record just printed }- 	    {byte_nr is even (not odd) >= 0				    }b 	    {}   ! 	IF requested_direction = reverse	 	THENs
 	    BEGIN# 	    IF current_direction = forwardR	 	    THENd 		BEGIN	" 		{Change from forward to reverse}< 		{retrieve (block_nr,byte_nr) of bottom screen-line record} 		byte_nr:= byte_nr - leng - 2;p* 		if odd(leng) then byte_nr:= byte_nr - 1;? 		{ If byte_nr is <= 0 then go to the block containing byte   }t, 		{ (block_nr,byte_nr-1) and read it			    } 		IF byte_nr < 0 		THEN 		    BEGINe 		    REPEAT 			block_nr:= block_nr - 1;h! 			byte_nr:= byte_nr + blocksize;  		    UNTIL byte_nr >= 0;  		    read_block;x
 		    END;: 		{Now: 0 <= byte_nr <= blocksize  AND  byte_nr mod 2 = 0}< 		{retrieve (block_nr,byte_nr) of second screen-line record} 		seek:= (byte_nr div 2); )                 FOR i := 2 TO page_lengthN                 DO  BEGIN= 		    seek:= seek - 1;                     IF seek<0l                     THEN                         BEGINM 			block_nr:= block_nr - 1;+ 			if block_nr = 0 			then $exit; 			read_block; 			seek:= blocksize div 2 - 1;                         END; 		    leng:= 0;-2 		    WHILE NOT ((leng = buffer.word_buf[seek]) OR- 			       (leng = buffer.word_buf[seek] + 1))_ 		    DO  BEGIN  			seek:= seek-1;e 			leng:= leng + 2;  			IF seek < 0 			THEN  			    BEGIN 			    block_nr:= block_nr - 1;t 			    read_block;" 			    seek:= blocksize div 2 - 1; 			    END;a 			END;;> 		    { Seek now points to the word holding the record length}                     END;C 		byte_nr:= 2 * seek; { points into byte_buf, to the record length}( 		current_direction:= reverse; 		END;   	    IF byte_nr = 0y	 	    THENa 		BEGINc 		block_nr:= block_nr - 1;
 		read_block;  		byte_nr:= blocksize; 		END;  < 	    {Now seek backwards to find the previous record length}   	    rec_buf:= '';  	    seek:= (byte_nr div 2) - 1; 	    leng:= 0;1 	    WHILE NOT ((leng = buffer.word_buf[seek]) ORe, 		       (leng = buffer.word_buf[seek] + 1)) 	    DO  		BEGINf 		seek:= seek-1; 		leng:= leng + 2; 		IF seek<0n 		THEN 		    BEGIN : 		    i:= min (leng, blocksize); {number of bytes to copy}% 		    IF i + rec_buf.length <= bufsize= 		    THEN rec_buf:= SUBSTR (buffer.char_buf, 1, i) + rec_bufrC 		    ELSE  {	There is a problem: there are more characters than  }t; 			  {	fit in the buffer. Dispose of some characters.	    }; 			IF i>= bufsiz 			THEN/4 			    rec_buf:= SUBSTR (buffer.char_buf, 1, bufsiz) 			ELSEa1 			    rec_buf:= SUBSTR (buffer.char_buf, 1, i) +c( 				      SUBSTR (rec_buf, 1, bufsiz-i); 		    block_nr:= block_nr - 1; 		    read_block;t! 		    seek:= blocksize div 2 - 1;c 		    byte_nr:= blocksize;
 		    END; 		END; 		J 	    { Seek now points to the word holding the record leng.  Read from   }H 	    { byte 2*seek+2, up to but excluding byte_nr.  Note, that the	    }= 	    { character start position is one more than this.		    }E  < 	    rec_len_field:= 2 * seek;	{ points into byte_buf		    }D 	    i:= byte_nr - rec_len_field - 2; {number of characters to copy} 	    s% 	    IF i + rec_buf.length <= bufsiz 0- 	    THEN rec_buf:= SUBSTR  (buffer.char_buf,r 				    rec_len_field + 3, 				    i) + rec_buf  J 	    ELSE {There is a problem: there are more characters than fit in the }/ 		 {buffer. Dispose of some characters.			    }  		IF i >= bufsiz5 		THEN {dispose bytes from old disk block completely}dA 		    rec_buf:= SUBSTR (buffer.char_buf, rec_len_field+3, bufsiz)=C 		ELSE {take all characters from this block plus some of old block} * 		    rec_buf:=  SUBSTR  (buffer.char_buf, 					rec_len_field + 3,R	 					i) +e* 			       SUBSTR (rec_buf, 1, bufsiz - i);M 	    {When the length turns out to be odd, strip the last byte (MnotBZ)	    } # 	    IF odd (buffer.word_buf[seek])%, 	    THEN rec_buf.length:= rec_buf.length-1; 	    byte_nr:= rec_len_field;t 	    END 	ELSEe
 	    BEGIN) 	    {the requested direction is forward} ! 	    IF current_direction=reversei	 	    THENi                 BEGIN1? 		{to change direction from reverse to forward, we have to    } # 		{advance 24 lines first.				    } % 		{the variable SEEK counts in words}i4 		seek:= byte_nr div 2; {points to word with reclen})                 FOR i := 1 TO page_lengtht                 DO  BEGINnF                     seek:= seek + 1 + (buffer.word_buf[seek]+1) div 2;? 		    {if the next reclen is not in the current block, read   }D? 		    {that block. If the record length is very long (more    }e7 		    {than 512 bytes) don't read intermediate blocks!} U                     IF seek >= blocksize div 2 {seek in words and blocksize in bytes}	
 		    THEN                         BEGIN	I                         block_nr:= block_nr + seek div (blocksize div 2);	% 			seek:= seek mod (blocksize div 2);E: 			if (block_nr=end_block) and (2*seek >= first_free_byte) 			then $exit; 			read_block;                         ENDP {		    ELSE(: 			IF (block_nr=end_block) and (2*seek >= first_free_byte) 			THEN $exit; }                      END; 		byte_nr:= seek * 2;  		current_direction:= forward;                 END;G 	    {direction is forward and block_nr,byte_nr is pointing to the    }o& 	    {next record to output.					    } 	    IF byte_nr>=blocksize	 	    THENs 		BEGINt 		{read the next block}o. 		block_nr:= block_nr + byte_nr div blocksize;" 		byte_nr:= byte_nr mod blocksize;: 		if (block_nr=end_block) and (byte_nr >= first_free_byte)
 		then $exit;h
 		read_block;r 		END=	 	    ELSE	: 		IF (block_nr=end_block) and (byte_nr >= first_free_byte)
 		THEN $exit; + 	    leng:= buffer.word_buf[byte_nr div 2];l" 	    num_byt:= min (leng, bufsiz); 	    byte_nr:= byte_nr+2;  	    rec_buf.length:= 0;F 	    {read successive blocks and transfer the contents of each block }8 	    {to the rec_buf. End when i bytes are transferred }# 	    WHILE rec_buf.length < num_byt=             DO  BEGIN  		IF byte_nr=blocksize 		THEN                     BEGINg 		    {read the next block}                       byte_nr:= 0; 		    block_nr:= block_nr+1; 		    read_block;                      END;0 		{how many bytes to read from this block? -> i}H                 i:= min (num_byt - rec_buf.length, blocksize - byte_nr);K                 rec_buf:= rec_buf + SUBSTR (buffer.char_buf, byte_nr+1, i);s 		byte_nr:= byte_nr+i;                 END;  F 	    {in case the record is very long, only i of the leng bytes are  }8 	    {transferred. Now compensate for that effect		    }F 	    {Note that byte_nr may become (much) larger than 511. In that   }3 	    {case, the $read is performed 'lazily'			    }r( 	    byte_nr:= byte_nr + leng - num_byt; 	    {word-align the byte_nr}G. 	    if odd(byte_nr) then byte_nr:= byte_nr+1;	 	    END;	
 	output_line;  	END;k0     if newline_qual then writeln (reverse_line); END.