 #ifndef LINT3 /* derived from: zooadd.c 2.34 88/08/15 10:53:11 */ F static char sccsid[]="$Source: /usr/home/dhesi/zoo/RCS/zooadd.c,v $\n\4 $Id: zooadd.c,v 1.10 91/07/08 23:48:39 dhesi Exp $"; #endif /* LINT */    /*; Copyright (C) 1986, 1987 Rahul Dhesi -- All rights reserved 5 (C) Copyright 1988 Rahul Dhesi -- All rights reserved 5 (C) Copyright 1991 Rahul Dhesi -- All rights reserved  */ #include "options.h"A /* Adds files specified in parameter-list to archive zoo_path. */   ? #define LONGEST	20					/* assumed length of longest filename */ 6 #include "zoomem.h"             /* to define MAXADD */ #include "zoo.h" #include "zooio.h" #include "various.h" #include "parse.h" #include "debug.h"   #include "portable.h"    #include "zoofns.h"  #include "errors.i"  extern int break_hit;  extern int quiet;   D void show_comment PARMS ((struct direntry *, ZOOFILE, int, char *));& void dosname PARMS ((char *, char *)); void modpath PARMS ((char *));G void opts_add PARMS ((char *, int *, int *, int *, int *, int *, int *, H                int *, int *, int *, int *, int *, int *, int *, int *));/ int ver_too_high PARMS ((struct zoo_header *)); > void get_comment PARMS ((struct direntry *, ZOOFILE, char *));B void copyfields PARMS ((struct direntry *, struct tiny_header *));9 void storefname PARMS ((struct direntry *, char *, int)); . char *choosefname PARMS ((struct direntry *));  $ extern struct zoo_header zoo_header;   extern char file_leader[]; extern unsigned int crccode;  ) void zooadd(zoo_path, argc, argv, option) < char *zoo_path;      /* pathname of zoo archive to add to */6 int argc;            /* how many filespecs supplied */9 char **argv;         /* array of pointers to filespecs */ ( char *option;        /* option string */ { G char *whichname;                          /* which name to show user */ H char **flist;                      			/* list of ptrs to input fnames */J int fptr;                                 /* will point to within flist */; ZOOFILE this_file;                        /* file to add */ J char zoo_fname[LFNAMESIZE];               /* basename of archive itself */H char zoo_bak[LFNAMESIZE];                 /* name of archive's backup */L char this_fname[LFNAMESIZE];              /* just filename of file to add */F char latest_name[LFNAMESIZE];             /* latest name in archive */J long last_old = 0L;                       /* last direntry in old chain */G ZOOFILE zoo_file;                         /* stream for open archive */ G char *this_path;                          /* pathname of file to add */   
 #ifdef NOENUM  #define NEW_ZOO 1  #define OLD_ZOO 2  int zoo_status;  #else D enum {NEW_ZOO, OLD_ZOO} zoo_status;       /* newly created or not */ #endif  J long this_dir_offset;                     /* pointers to within archive */I long save_position;                       /* pointer to within archive */ N long prev_pos;                            /* posn of prev file of same name */? struct direntry direntry;                 /* directory entry */ 5 struct direntry dir2entry;                /* spare */ < int status;                               /* error status */L int success;                              /* successful addition of file? */< int addcount = 0;                         /* number added */M int update=0;                             /* only files already in archive */ D int suppress=0;                           /* suppress compression */M int new=0;                                /* add only files not in archive */ E int zootime = 0;                          /* just set archive time */ ; int add_comment = 0;                      /* add comment */ 5 int add_global_comment = 0;					/* archive comment */ A int pack = 0;                             /* pack after adding */ E int need_dir = 1;                         /* store directories too */ H int delcount = 0;                         /* count of deleted entries */B int exit_status = 0;                      /* exit status to set */  M unsigned int latest_date = 0;             /* to set time on archive itself */ 7 unsigned int latest_time = 0;             /* .. same */ N int move = 0;                             /* delete after adding to archive */P int longest;                              /* length of longest pathname added */G int firstfile = 1;                        /* first file being added? */ H int z_fmt = 0;                            /* look for Z format files? */8 int inargs = 0;									/* read filenames from stdin? */   #ifndef PORTABLEE struct tiny_header tiny_header;           /* for Z format archives */  #endif  = unsigned this_version_no;							/* version no. of old file */ ; unsigned  high_vflag;								/* version flag of old file */ E unsigned high_version_no;							/* highest version no of this file */ = long high_pos;										/* offset of file w/highest ver no */ : unsigned int fgens;								/* gens. to preserve -- file */= unsigned int zgens;								/* gens. to preserve -- archive */ 1 long oldcmtpos;									/* to save old comment */ 7 unsigned int oldcmtsiz;							/* to save old comment */ < int genson = 0;									/* whether to turn generations on */  = int use_lzh = 0;									/* whether to use lzh compression */   , /* on entry option points to first letter */  B opts_add (option, &zootime, &quiet, &suppress, &move, &new, &pack,E           &update, &add_comment, &z_fmt, &need_dir, &inargs, &genson, # 			 &use_lzh, &add_global_comment);   I /* POSSIBLE RACE CONDITION BETWEEN TESTING EXISTENCE AND CREATING FILE */  if (exists (zoo_path)) {' 	zoo_file = zooopen (zoo_path, Z_RDWR);     zoo_status = OLD_ZOO; } else {    if (!zootime)" 		zoo_file = zoocreate (zoo_path);    else D       zoo_file = NOFILE;     /* don't create if just setting time */    zoo_status = NEW_ZOO; }    if (zoo_file == NOFILE) ,    prterror ('f', could_not_open, zoo_path);A basename(zoo_path, zoo_fname);      /* get basename of archive */ @ rootname (zoo_path, zoo_bak);       /* name without extension */H strcat (zoo_bak, BACKUP_EXT);       /* name of backup of this archive */  K /* Now we prepare the archive for adding one or more files.  If the archive 5 has just been created, we write the archive header */   L addfname ("",0L,0,0,0,0); /* initialize table of files already in archive */H if (zoo_status == NEW_ZOO) {                 /* newly-created archive */5 	if (genson)											/* if no generations needed */ ? 		zoo_header.vdata = (VFL_ON|GEN_DEFAULT); /* generations on */ $    fwr_zooh (&zoo_header, zoo_file); 	zgens = GEN_DEFAULT; O    zooseek (zoo_file, zoo_header.zoo_start, 0); /* seek to where data begins */  } else {F    /* read header and rewrite with updated version numbers, preserving 	   header type */'    rwheader (&zoo_header, zoo_file, 1); D 	zgens = zoo_header.vdata & VFL_GEN;			/* get archive generations */.    /* initialize latest_name to null string */> 	/* NOTE:  latest_name is not currently used for anything, but8 		may be used in the future for inserting files into the! 		archive in alphabetic order. */     *latest_name = '\0';   I    /* Skip existing files but add them to a list.  The variable last_old  9    gets the tail of the old chain of directory entries */ @    skip_files (zoo_file, &latest_date, &latest_time, &delcount, '                latest_name, &last_old);  } J /* The file pointer is now positioned correctly to add a file to archive, K unless the null directory entry is too short.  This will be fixed below. */   1 /* If we are just setting time, do it and run. */  if (zootime) { #ifdef NIXTIME    zooclose (zoo_file); 1    setutime (zoo_path, latest_date, latest_time);  #else 0    settime (zoo_file, latest_date, latest_time);    zooclose (zoo_file);  #endif.    prterror ('m', "Archive time adjusted.\n");    zooexit (0);  }   : /* make list of files, excluding archive and its backup */ longest = LONGEST;! flist = (char **) ealloc(MAXADD);  if (!inargs) {L    makelist(argc, argv, flist, MAXADD-2, zoo_fname, zoo_bak, ".", &longest);J    /*                                    ^^         ^^       ^^ exclude */ }   C fptr = 0;	/* ready to get filename (if makelist() was called) or to ; 					begin adding filenames (if reading them from stdin) */    while (1) { %    unsigned int this_date, this_time;     int INLIST; /* boolean */    int RECENT; /* boolean */E    int danger; /* if update requested and disk copy is out of date */  	if (inargs) {J 	again: /* loop back if filename was same as archive name or its backup */E 		this_path = getstdin();			/* pathname from stdin, in static area */  		if (this_path != NULL) {: 			if (samefile (nameptr(zoo_fname),nameptr(this_path)) ||5 						samefile (nameptr(zoo_bak),nameptr(this_path))) 5 				goto again; 				/* don't add archive to itself */  			modpath (this_path); I 		/* if moving files, add to list for later deletion;  if list overflows, 6 			terminate addition loop and give warning message */ 			if (move) { 				if (fptr >= MAXADD-2) { . 					prterror ('w', too_many_files, MAXADD-2); 					this_path = NULL;
 				} else) 					flist[fptr++] = str_dup (this_path);  			} 		} 
 	} else  { 		this_path = flist[fptr++]; 	}= 	/* exit the addition loop when no more pathnames are left */  	if (this_path == NULL) { H 		/* in case stdin was being read, make sure flist is NULL-terminated */ 		flist[fptr] = NULL;  		break; 	}  H    basename (this_path, this_fname);   /* get just filename for later */  *    this_file = zooopen(this_path, Z_READ);    if (this_file == NOFILE) { 0       prterror ('e', could_not_open, this_path);       exit_status++;       continue;     }   #ifndef PORTABLEM    /* Test to see if this is a Z format file.  We assume the file is Z format G       if (a) tag is correct and (b) type is 1 and (c) embedded filename %       is not longer than FNAMESIZE.       */     if (z_fmt) { F       zooread (this_file, (char *) &tiny_header, sizeof(tiny_header));D       if (tiny_header.tinytag == TINYTAG && tiny_header.type == 1 &&@                         strlen (tiny_header.fname) <= FNAMESIZE)           /* ok */ ;       else {          zooclose (this_file);I          prterror ('e', "File %s does not have Z format.\n", this_fname);           exit_status++;           continue;       }     } #endif  &    /* get file time;  also fix name */ #ifndef PORTABLE    if (z_fmt) { '       direntry.date = tiny_header.date; '       direntry.time = tiny_header.time; 1       strcpy (direntry.fname, tiny_header.fname); ,       direntry.dirlen = direntry.namlen = 0;    } else {  #endif  ,       /* Get timstamp of file being added */ #ifdef GETUTIME ;       getutime (this_path, &direntry.date, &direntry.time);  #else :       gettime (this_file, &direntry.date, &direntry.time); #endif   		/* save file attributes */ #ifdef FATTR; 		/* we expect getfattr() to set all attr. bits;  currently , 			only the portable format is recognized */ 		{  # ifdef FATTR_FNAME * 			unsigned long getfattr PARMS ((char *);) 			direntry.fattr = getfattr (this_path);  # else, 			unsigned long getfattr PARMS ((ZOOFILE));) 			direntry.fattr = getfattr (this_file);  # endif /* FATTR_FNAME */  		}  #else ( 			direntry.fattr = NO_FATTR;	/* none */ #endif /* FATTR */   #ifdef FOLD        str_lwr(this_fname); #endifA       dosname (this_fname, direntry.fname);  /* MSDOS filename */       /* J    Store long filename into direntry.lfname iff it is different from MSDOSK    filename.  Also store directory name if need_dir is true.  Moved out of  =    zooadd() so zooadd() doesn't get too big for optimization.     */ /    storefname (&direntry, this_path, need_dir);    #ifndef PORTABLE    } #endif   #ifdef DEBUGE printf ("zooadd:  direntry.lfname = [%s]  direntry.dirname = [%s]\n", 5                   direntry.lfname, direntry.dirname);  #endif  I    /* if update option, then we add file if it is already in the archive  '       AND the archived file is older */   C    /* The following logic was derived from a Karnaugh map so it may A       be hard to understand.  Essentially, if U=update requested, >       N=new files requested, I=file is already in archive, and?       R=file being archived is more recent than file already in ,       archive, then the boolean equation is:  (       add = U' (N' + I') + U (IR  + I'N)    */   4    /* Get the filename to use for this addition.  */&    whichname = choosefname(&direntry);  D    /* Get position in archive of any old file of same name, ignoring= 		any directory prefix if need_dir is not true.  Also get its 2 		date, time, version flag, and version number. */D    prev_pos = inlist (fullpath (&direntry), &this_date, &this_time, 5 				&this_version_no, &high_vflag, &high_version_no,   				&high_pos, !need_dir);  M /* define DBG_INLIST for debugging by printing values returned by inlist() */  #ifdef DBG_INLIST L 	printf ("FROM inlist(): prev_pos=%ld, high_pos=%ld\n", prev_pos, high_pos);D 	printf ("this_version_no=%u, high_vflag=%4x, high_version_no=%u\n",9 				this_version_no,    high_vflag,     high_version_no);  #endif  E    INLIST = prev_pos > 0;  /* already in archive if positive value */     if (INLIST) {       int result; K       result = cmpnum (direntry.date, direntry.time, this_date, this_time);        RECENT = result > 0;       danger = result < 0;	    } else F       danger = 0; /* And RECENT is undefined and should not be used */      if ( (          !update && (!new || !INLIST) ||7          update && (INLIST && RECENT || !INLIST && new)        ) ,          ;  /* then continue and add file */	    else {        if (update && danger) F          prterror ('w', "Archived copy of %s is newer.\n", whichname);       zooclose (this_file); 2       continue;   /* cycle back, skip this file */    }   #ifdef CHEKDIR)    /* Don't add if this is a directory */     if (isadir (this_file)) {       zooclose (this_file);        continue;     } #else  # ifdef CHEKUDIR)    /* Don't add if this is a directory */     if (isuadir (this_path)) {        zooclose (this_file);        continue;     } # endif /* CHEKUDIR */ #endif /* CHEKDIR */  E    /* Create directory entry for new file (but don't add just yet) */ I    /* NOTE:  we already got file date and time above for update option */ A 	/* add tag, type, timezone, struc, system_id, and var_dir_len */  	newdir (&direntry);  ) 	if (!genson && zoo_status == NEW_ZOO ||  ' 				(zoo_header.vdata & VFL_ON) == 0) {  		direntry.vflag = 0;  		direntry.version_no = 0; 	}      /* H    Write a null direntry entry.  Thus, if an error occurs or the programC    is interrupted, the end of the archive will still be meaningful. .    Special check needed for first one written.    */   F    direntry.next = direntry.offset = 0L;     /* trailing null entry */(    this_dir_offset = zootell (zoo_file);    if (!firstfile) {%       writedir (&direntry, zoo_file);     } else {        /*I       Before adding the first file to the archive, we must make sure that I       the previous directory chain (if any) is properly terminated with a H       null entry of the right size.  If this is a new archive, we simplyG       write a new null entry of the right size.  If this is an existing K       archive, we must check the size of the previous trailing null entry.  K       If it is too small, we will back up to the most recent real directory A       entry and change its .next field to point to end of file.          */  "       if (zoo_status == NEW_ZOO) {J          writedir (&direntry, zoo_file);        /* write null dir entry */       } else {"          struct direntry tmpentry;          long tmppos;           int oldlen, newlen;%          tmppos = zootell (zoo_file); '          frd_dir (&tmpentry, zoo_file); F #define  DIRLEN(x)   ((x.type<2) ? SIZ_DIR : (SIZ_DIRL+x.var_dir_len))L          oldlen = DIRLEN(tmpentry);             /* get length of direntry */;          newlen = DIRLEN(direntry);             /* ditto */   =          if (newlen > oldlen) {                 /* trouble */ L             zooseek (zoo_file, last_old, 0);    /* back to previous entry */*             frd_dir (&tmpentry, zoo_file);F             zooseek (zoo_file, 0L, 2);          /* get EOF position */E             tmpentry.next = zootell (zoo_file);    /* point to EOF */ L             zooseek (zoo_file, last_old, 0);    /* back to previous entry */?             writedir (&tmpentry, zoo_file);     /* update it */u@             zooseek (zoo_file, 0L, 2);          /* to EOF ... */1             this_dir_offset = zootell (zoo_file); M             writedir (&direntry, zoo_file);     /* ...write null dir entry */i          } elseeN             zooseek (zoo_file, tmppos, 0);      /* long enough -- let it be */,       } /* if (zoo_status == NEW_ZOO) ... */    } /* if (!firstfile) ... */  H    /* Now `this_dir_offset' is where the next directory entry will go */  C    /* first file added goes at EOF to avoid overwriting comments */c    if (firstfile) {e<       zooseek (zoo_file, 0L, 2);                   /* EOF */6       direntry.offset = zootell (zoo_file) + SIZ_FLDR;    } else {e5       direntry.offset = this_dir_offset + SIZ_DIRL +  )          direntry.var_dir_len + SIZ_FLDR;r    }   	if (use_lzh) {)L 		direntry.major_ver = MAJOR_LZH_VER;    /* minimum version number needed */< 		direntry.minor_ver = MINOR_LZH_VER;    /* .. to extract */	 	} else { L 		direntry.major_ver = MAJOR_EXT_VER;    /* minimum version number needed */< 		direntry.minor_ver = MINOR_EXT_VER;    /* .. to extract */ 	}C    direntry.deleted = 0;               /* not deleted, naturally */u=    direntry.comment = 0L;              /* no comment (yet) */(=    direntry.cmt_size = 0;          /* .. so no size either */t  Q    save_position = direntry.offset;          /* save position in case of error */[  <    (void) zooseek (zoo_file, direntry.offset - SIZ_FLDR, 0);5    (void) zoowrite (zoo_file, file_leader, SIZ_FLDR);    #ifdef PORTABLE/2    prterror ('m', "%-*s -- ", longest, this_path); #elseh
    if (z_fmt) +       prterror ('m', "%-12s <== %-*s -- ", r-          direntry.fname, longest, this_path);*    else;5       prterror ('m', "%-*s -- ", longest, this_path);    #endif /* PORTABLE */       crccode = 0;s #ifndef PORTABLE    if (z_fmt)  	{;       direntry.packing_method = tiny_header.packing_method;sP       zooseek (this_file, (long) (sizeof(tiny_header)+tiny_header.cmt_size), 0);F       status = getfile (this_file, zoo_file, tiny_header.size_now, 1);
    } else  #endif> 	if (suppress) {                    /* suppress compression */A       direntry.packing_method = 0;           /* no compression */s5       status = getfile (this_file, zoo_file, -1L, 1);v    } else {s$ #ifdef UNBUF_IO	/* unbuffered I/O */& 		long lseek PARMS ((int, long, int)); 		long tell PARMS ((int)); 		int this_fd, zoo_fd; #endif 		if (use_lzh) 			direntry.packing_method = 2;p 		else 			direntry.packing_method = 1;U #ifdef UNBUF_IOO+ #include "UNBUF_IO not currently supported"e5 		this_fd = fileno (this_file);						/* get ..					*/y= 		zoo_fd = fileno (zoo_file);						/* ... file descriptors	*/ 8 		zooseek (zoo_file, zootell (zoo_file), 0);	/* synch */: 		zooseek (this_file, zootell (this_file), 0);	/* synch */C       status = lzc(this_fd, zoo_fd);					/* add with compression */e7 		zooseek (zoo_file, tell (zoo_fd), 0);			/* resynch	*/r8 		zooseek (this_file, tell (this_fd), 0);		/* resynch	*/ #elsea 		if (use_lzh), 			status = lzh_encode(this_file, zoo_file); 		else% 			status = lzc(this_file, zoo_file);  #endif /* UNBUF_IO */n      }     if (status != 0) { /* if I */A       ++exit_status;                         /* remember error */        if (status == 1)#          prterror ('F', no_memory);        else if (status == 2)s#          prterror ('F', disk_full);        else if (status == 3)*)          prterror ('F', "Read error.\n");t
       else(          prterror ('F', internal_error);       success = 0;    } else { *       direntry.next  = zootell (zoo_file);:       direntry.size_now = direntry.next - direntry.offset;  @       /* find and store original size of file just compressed */; /*DEBUG VMS*/ zooseek (this_file, 0L, 2);	/* seek to EOF */   K       direntry.org_size = zootell (this_file);  /* should be EOF already */x  6       /* If the compressed one is bigger, just copy */  A       if (direntry.size_now >= direntry.org_size &&   /* if II */h+             direntry.packing_method != 0) { L          zooseek (zoo_file, save_position, 0);  /* ..restore file pointer */E          zootrunc (zoo_file);                   /* ..truncate file */ E          direntry.packing_method = 0;           /* ..and just copy */ I          zooseek (this_file, 0L, 0);            /* (but rewind first!) */ I          crccode = 0;                           /* re-start crc from 0 */e8          status = getfile (this_file, zoo_file, -1L, 1);)          if (status != 0) {  /* if III */r             success = 0;             printf (disk_full);r             exit_status++;          } else {	             success = 1;0             direntry.next  = zootell (zoo_file);@             direntry.size_now = direntry.next - direntry.offset;          } /* end if III */*       } else {          success = 1;        } /* end if II */n      } /* end if I */	  M    if (success) {                               /* file successfully added */eD       addcount++;                               /* how many added */"       direntry.file_crc = crccode;  .       /* remember most recent date and time */M       if (cmpnum (direntry.date,direntry.time,latest_date,latest_time) > 0) {e(             latest_date = direntry.date;(             latest_time = direntry.time;       },   #if 0mH       /* mark any previous version of this file in archive as deleted */M       dir2entry.comment = 0L;       /* for later use assigning to direntry */E       dir2entry.cmt_size = 0;  #endif         if (!z_fmt),U          prterror ('M', " (%2d%%) ", cfactor (direntry.org_size, direntry.size_now));e  3 		oldcmtsiz = 0;								/* assume no old comment */  		oldcmtpos = 0L;t  3       if (prev_pos > 0) {										/* in archive */o- 			int delold = 0;										/* delete old? */_: 			/* if versions active both archive-wide and for file */> 			if ((zoo_header.vdata & VFL_ON) && (high_vflag & VFL_ON)) {; 				/* next test is optimization, to avoid redundant I/O */ 7 				if (high_pos != prev_pos || this_version_no == 1) {r< 					/* prev highest is no longer highest so adjust vflag */4 					long save_pos = zootell (zoo_file);			/*DEBUG*/% 					zooseek (zoo_file, high_pos, 0);l' 					readdir (&dir2entry, zoo_file, 1); # 					oldcmtpos = dir2entry.comment; $ 					oldcmtsiz = dir2entry.cmt_size;? 					dir2entry.vflag &= (~VFL_LAST);				/* no longer highest */r% 					zooseek (zoo_file, high_pos, 0);a% 					writedir (&dir2entry, zoo_file); 2 					zooseek (zoo_file, save_pos, 0);				/*DEBUG*/ 				}o  A 				direntry.version_no = high_version_no + 1; /* ..one higher */   				direntry.vflag = high_vflag;4 				/* now see if we need to delete older version */! 				fgens = high_vflag & VFL_GEN;e 				if (fgens == 0)h 					fgens = zgens;;$ 				if (zgens != 0 && zgens < fgens) 					fgens = zgens;aG 				if (fgens != 0 && direntry.version_no - this_version_no >= fgens) {y 					delold = 1;# 					prterror ('M', "replaced+\n");i
 				} else  					prterror ('M', "added+\n"); 			} else {t! 				prterror ('M', "replaced\n");n 				delold = 1;h 			}  2 			if (delold) {											/* deleting old file */3 				long save_pos = zootell (zoo_file);			/*DEBUG*/ 0 				++delcount;											/* remember to pack */$ 				zooseek (zoo_file, prev_pos, 0);& 				readdir (&dir2entry, zoo_file, 1);B 				if (dir2entry.cmt_size != 0) {		/* propagate latest comment */# 					oldcmtpos = dir2entry.comment; $ 					oldcmtsiz = dir2entry.cmt_size; 				} 6 				dir2entry.deleted = 1;							/* mark as deleted */= 				/* following line is optimization if only 1 generation */ > 				dir2entry.vflag &= (~VFL_LAST);				/* no longer highest */$ 				zooseek (zoo_file, prev_pos, 0);$ 				writedir (&dir2entry, zoo_file);1 				zooseek (zoo_file, save_pos, 0);				/*DEBUG*/t 			}/       } else 														/* not in archive */  			prterror ('M', "added\n");a  J       /* Preserve any old comment if we replaced or superseded the file */#       direntry.comment = oldcmtpos; $       direntry.cmt_size = oldcmtsiz;   #ifndef PORTABLE2       /* Copy comment if any from Z format file *//       if (z_fmt && tiny_header.cmt_size != 0) {dM          zooseek (this_file, (long) sizeof(tiny_header), 0); /* to comment */ /          direntry.comment = zootell (zoo_file); 2          direntry.cmt_size = tiny_header.cmt_size;(          /* 4th param is 0 for no CRC */G          getfile (this_file, zoo_file, (long) tiny_header.cmt_size, 0);a,          direntry.next = zootell (zoo_file);       }  #endif  G       /* if user requested comments, any previous comment in a Z formatm0          file may now be manually overwritten */)       if (add_comment && !feof (stdin)) {i:          show_comment (&direntry, zoo_file, 1, whichname);6          get_comment (&direntry, zoo_file, this_path);F          direntry.next = zootell (zoo_file);    /* update .next ptr */       } /* end if */   #ifndef PORTABLEL       /* if adding Z format archive, copy relevant fields from its header */N       if (z_fmt) {   /* moved out to shorten code & allow optimizer to work */.          copyfields (&direntry, &tiny_header);       }p #endif  J       debug((printf ("zooadd:  our new .next = [%lx].\n", direntry.next)))         {LB          long savepos = zootell (zoo_file);    /* save position */0          zooseek (zoo_file, this_dir_offset, 0);(          writedir (&direntry, zoo_file);B          zooseek (zoo_file, savepos, 0);    /* restore position */       };  K    } else {                               /* file was not properly added */hI       zooseek (zoo_file, save_position, 0);  /* ..restore file pointer */ B       zootrunc (zoo_file);                   /* ..truncate file */    } /* end if */t    zooclose (this_file);
 if (!success)m	    break;n firstfile = 0; } /* end for */A  # save_position = zootell (zoo_file);   ! /* Write a null direntry entry */y% zooseek (zoo_file, save_position, 0);f! writenull (zoo_file, MAXDIRSIZE); $ zootrunc (zoo_file);  /* truncate */   #ifdef NIXTIME zooclose (zoo_file);. setutime (zoo_path, latest_date, latest_time); #else - settime (zoo_file, latest_date, latest_time);' zooclose (zoo_file); #endif  8 if (!addcount) {                    /* no files added */'    prterror ('m', "No files added.\n");     if (zoo_status == NEW_ZOO)/       unlink (zoo_path); } else {M    if (delcount && pack) { /* pack if user asked and found deleted entries */i*       prterror ('M', "-----\nPacking...");       zoopack (zoo_path, "PP");e       prterror ('M', "done\n");s    }  O    /* If files to move & we added some and no error so far, delete originals */u    if (move && !exit_status)+       if (kill_files (flist, longest) != 0)t          exit_status++;  }r  * /* right here we handle archive comment */ if (add_global_comment) {w 	comment(zoo_path, "_A");a 	add_global_comment = 0; }	   if (exit_status)    zooexit (1);e } /* end zoo_add */A