  	PROGRAM ZMENU      *$  *	17 Jul 91  1.000  Initial release  *@  *	18 Jul 91  1.001  Fix problems caused by using INTEGER*2 when  *			   INTEGER*4 is required.  *.  *	22 Jan 92  1.002  Add /INITIAL=n qualifier.  *A  *	23 Apr 92  1.003  Let pointer be displayed correctly even when 6  *			   there are Escape Sequences and/or SI/SO on the)  *			   same line in columns to the left. 1  *			  Add /TEXT, /START0, and /BOUND qualifiers. 1  *			  Remove second field of /POINTER qualifier.   *  *----- Spring 92 VAX SIG TAPE  *E  *	19 Oct 92  1.004  Add /SCROLLING qualifier, which invokes a separ- &  *			   ate program, ZMENU_SCROLL.EXE.  *F  *	 7 Jan 93  1.005  Abort ZMENU if item character is too close to the$  *			   left margin for the pointer.  *  */  *	Alan L. Zirkle		Naval Surface Warfare Center   *				Code K55  *				Dahlgren, Virginia  22448   *     *F  *	ZMENU is a utility designed to display a menu from within a commandG  *	procedure, to select a menu item based on a user's instructions, and F  *	to communicate the user's selection to the procedure so that it can?  *	perform further processing based on which item was selected.   *  *	ZMENU is called as:  *4  *	    $ ZMENU [file] [/SYMBOLS] [/POINTER="text"] -  *?  *		[/ITEM="char"] [/WIDE] [/NOINTERRUPT] [/DEBUG] [/VERSION] -   *!  *		[/INITIAL=n] [/TEXT="string"]   *H  *	If 'file' is omitted, SYS$INPUT is assumed.  If no file type is spec-  *	ified, .MENU is assumed.   *F  *	ZMENU clears the screen, and displays the contents of the specifiedE  *	file (up to 24 lines).  If the /WIDE qualifier is used, the screen "  *	is made 132 columns wide first.  *F  *	Any lines in the file beginning with "!" are assumed to be comments  *	and are not displayed.   *C  *	Occurrences of the ITEM character (default "^") are displayed as F  *	blanks.  A pointer (default "-->") is displayed at the first (upperF  *	leftmost) item location.  The rightmost character of the pointer isE  *	placed over the item character.  Items must not be so close to the F  *	left margin that the pointer will not fit.  You can choose your own(  *	item character and/or pointer string.  *H  *	If the user enters an ARROW key, the pointer is moved to the next key5  *	location in the direction the arrow key specified.   *6  *	If the user enters CTRL/W, the screen is refreshed.  *C  *	If the user enters RETURN, SELECT, DO, or ENTER, then DCL Symbol B  *	CHOICE is set to the number of the item at which the pointer isA  *	currently displayed.  The items are numbered as follows:  item B  *	numbers are 1,2,3,... ; the upper-left-most item is numbered 1;A  *	the search for the next item goes down the screen column, then $  *	down the next screen column, etc.  *@  *	If /SYMBOLS is specified, then occurences of DCL Symbol namesA  *	(in apostrophes) in the file are replaced by the current value C  *	of the symbols.  This allows the displayed text to vary based on &  *	the state of the command procedure.  *E  *	If you use the /NOINTERRUPT qualifier, then if the user CONTROL-Ys C  *	out of MENU, CHOICE will be set to 0 and no other effects of the .  *	interrupt will be visible to the procedure.  *>  *	If /INITIAL=n is specified, then when the menu is initially@  *	displayed, the pointer is positioned at the Nth item, instead?  *	of the first item, which is the default.  If there is no Nth #  *	item, this qualifier is ignored.   *C  *	The /TEXT qualifier enables the entry of text in addition to the B  *	arrow keys.  Somewhere in your menu display, you must designate?  *	an area for the display of the entered text.  You do this by A  *	using a special character; the default is "\".  An example is:   *  *		^ Item 1  *		^ Item 2  *  *		Text: \\\\\   *C  *	This example allows up to five characters of text to be entered. A  *	The text display area must not extend past column 80.  Text is *  *	always displayed in bold reverse video.  *@  *	By default, when no text has been entered, ZMENU will displayA  *	blanks, not "\\\\\", in the text display area.  You can choose D  *	a different character (such as an underscore), or you can specify;  *	a character plus a prefix and a postfix escape sequence.   *C  *	Three text entry options are available:  A, C, and K.  The /TEXT C  *	qualifier must be specified with a character string value, as in >  *	the example:  /TEXT="A|_".  The first character must be theC  *	option.  The second character must be the special character used C  *	in the menu display to designate the text entry area.  The third B  *	and subsequent character(s) must be the desired character [plus>  *	optional escape sequence(s)] to display in blank text entryB  *	columns.  For example, to display boldface minus signs in empty@  *	columns, specify:  /TEXT="A\[1m=[m"  and have a line in the  *	menu display:%  *			Enter text: [1m\\\\\\\\\\\\\[m   *>  *	* The A option allows the input of arbitrary text, up to 80A  *	  characters.  The entered text is displayed in the text entry A  *	  area.  The text is cleared out whenever the pointer is moved C  *	  to another menu item.  When ZMENU exits, DCL Symbol ZMENU_TEXT )  *	  contains the text, or a null string.   *@  *	* The C option allows the input of an item number, giving theB  *	  user the option of using the arrow keys or entering a number.?  *	  when a number is entered, the pointer immediately jumps to ?  *	  the specified item; no carriage return is required.  If an A  *	  illegal input is entered, the pointer moves back to where it   *	  previously was.  *C  *	* The K option allows the input of an item "keyword", giving the C  *	  user the option of using the arrow keys or entering a keyword. D  *	  The text the user enters is uppercased.  Keywords are the char-B  *	  acter strings beginning two columns past the item characters.  *	  For example, in the menu:  *  *			^ PROCESS
  *			^ Delete   *			^ EXIT NOW   *F  *	  The keywords are "PROCESS", "DELETE" (uppercase), and "EXIT NOW".D  *	  When a text entry matches a keyword or even the initial part ofD  *	  a keyword, the pointer immediately jumps to the first item withF  *	  a match; no carriage return is required.  If non-matching text isA  *	  entered, the pointer  moves back to where it previously was.   *  *;  *	The user may include Escape Sequences, and the SI and SO ?  *	characters, within the file to control video attributes.  If =  *	desired, the user can put an upside down question mark "" ;  *	everywhere an ESCAPE character is needed.  Use of escape 9  *	sequences makes screen layout design harder, since the @  *	sequences take up columns in the file, but not on the screen.<  *	The numbering of items is done by screen column, not file;  *	column (i.e. escape sequences are assumed to be absent). @  *	On lines with an escape sequence, tabs must not be used after  *	the sequence.  *?  *	The pointer may be up to 24 characters long.  It may include   *	escape sequences.  *>  *	When no screen I/O is being done, the cursor is left parked@  *	near the lower right-hand corner of the screen (line 22, col-8  *	umn 80 or column 132) where it is less conspicuous.    *@  *	If the string "00:00:00" exists in the file, the current timeC  *	is displayed at that location every five seconds (if this string C  *	appears more than once in the file, only the first occurrence is 	  *	used).   *F  *	If the first non-comment line in the file contains "/" in column 1,F  *	it is not displayed.  Instead, it is assumed to contain some or allC  *	of the qualifiers allowed on the command line (except /DEBUG and F  *	/VERSION).  This line is always examined for DCL symbols regardlessB  *	of whether /SYMBOLS is used on the command line.  Values speci-=  *	fied on this line override qualifiers on the command line. >  *	In many cases it makes more sense to keep these values with  *	the file.  *@  *	If /DEBUG is specified, then the lines are displayed with the?  *	item character visible (they will disappear when the pointer ?  *	covers them), and the item number being currently pointed to /  *	is displayed in the lower right-hand corner.   *?  *	If the user enters "H" or "h" or "?" or PF2 or F15 (HELP), a ?  *	HELP display appears on the bottom five lines of the screen; -  *	it goes away when the user enters a blank.   *?  *	If ZMENU is called from a non-interactive process, or if the >  *	menu contains no selectable items, ZMENU exits with a diag-
  *	nostic.  *     	IMPLICIT NONE      	INTEGER*4 CHOICE,START0  *2D   	LOGICAL BOUND  *2E  *2I   	LOGICAL*4 BOUND  *2E   	CHARACTER*9 PARK(  	COMMON /UTIL/ CHOICE,START0,BOUND,PARK     	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24) /  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99) 5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS      	LOGICAL*1 INPUT_READY #  	CHARACTER*1 INPUT_CHAR,INPUT_FLAG 2  	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY     	INTEGER*4 TEXT,TLEN   	COMMON /TEXT/ TEXT,TLEN      	character*1024 buffer   	common /buffer/ buffer     	INTEGER*4 I,J,DIFF     	CALL INITIALIZE      100	call screen_start(buffer)   =  	DO I=1,MAXL		! Display the lines, minus the item characters      	    CALL DISPLAY_LINE(I,1)     	ENDDO    6  	CALL SCREEN('[J')	    	! Clear remainder of screen.   :  	IF (TLEN.GT.0) CALL TEXTIN(2)	! Refresh the text display   H  120	CALL DISPLAY_POINTER	    ! Display the pointer and park the cursor.     130	call screen_end   C  	CALL GET_TERMINAL_INPUT	    ! Wait for user to enter a character.      	call screen_start(buffer)      	IF (INPUT_FLAG.EQ.'*') THEN    5  	    IF (INPUT_CHAR.EQ.CHAR(23)) GO TO 100		! CTRL-W 6  	    IF (INPUT_CHAR.EQ.CHAR(13)) CALL EXIT_		! RETURN2  	    IF (INPUT_CHAR.EQ.CHAR(127)) THEN			! DELETE  		CALL TEXTIN(0)   		IF (TEXT.GT.1) GO TO 120   	    ENDIF    "  	ELSE IF (INPUT_FLAG.EQ.'~') THEN   5  	    IF (INPUT_CHAR.EQ.CHAR(4)) CALL EXIT_		! SELECT 3  	    IF (INPUT_CHAR.EQ.CHAR(28)) CALL HELP		! HELP 2  	    IF (INPUT_CHAR.EQ.CHAR(29)) CALL EXIT_		! DO   :  	ELSE IF (INPUT_FLAG.EQ.' ') THEN		! Printable characters     	    IF (TEXT.NE.0) THEN   		CALL TEXTIN(1)   		IF (TEXT.GT.1) GO TO 120 
  	    ELSE/  		IF (INPUT_CHAR.EQ.'H' .OR. INPUT_CHAR.EQ.'h' .  	1			       .OR. INPUT_CHAR.EQ.'?') CALL HELP  	    ENDIF.   )  	ELSE IF (INPUT_CHAR.EQ.'A') THEN			! UPn  *  	    IF (BOUND) THENi#  	       IF (CHOICE.EQ.1) GO TO 130NB  	       IF (POINTERS(2,CHOICE-1).NE.POINTERS(2,CHOICE)) GO TO 130  	    ENDIFv  w  	    CHOICE = CHOICE - 1a$  	    IF (CHOICE.EQ.0) CHOICE = MAXP3  140	    CALL TEXTIN(4)			! Delete any entered textE  	    GO TO 120/  N+  	ELSE IF (INPUT_CHAR.EQ.'B') THEN			! DOWN   I  	    IF (BOUND) THEN*&  	       IF (CHOICE.EQ.MAXP) GO TO 130B  	       IF (POINTERS(2,CHOICE).NE.POINTERS(2,CHOICE+1)) GO TO 130  	    ENDIFg  ,  	    CHOICE = CHOICE + 1 $  	    IF (CHOICE.GT.MAXP) CHOICE = 1  	    GO TO 140l   ,  	ELSE IF (INPUT_CHAR.EQ.'C') THEN			! RIGHT   #  	    IF (CHOICE.EQ.MAXP) GO TO 130W  a&  	    J = 0		! Best possibility so far  	    DO I=CHOICE+1,MAXP;  		IF (POINTERS(2,I).GT.POINTERS(2,CHOICE)) THEN      ! col ;  		    IF (POINTERS(1,I).LT.POINTERS(1,CHOICE)) THEN  ! rown	  			J = In-  			DIFF = POINTERS(1,CHOICE) - POINTERS(1,I)s9  		    ELSE IF (POINTERS(1,I).LT.POINTERS(1,CHOICE)) THENr	  			J = I 
  			GO TO 150i  		    ELSEt  			IF (J.NE.0) THEN"  			    IF (DIFF.GT.POINTERS(1,I)-'  	1				       POINTERS(1,CHOICE)) J = I	  			ELSE
  			    J = IN	  			ENDIF 
  			GO TO 150I  		    ENDIF  		ENDIF  	    ENDDOs  n  	    IF (J.NE.0) THEN  150		CHOICE = J  		GO TO 140  	    ENDIFt   +  	ELSE IF (INPUT_CHAR.EQ.'D') THEN			! LEFT*  E   	    IF (CHOICE.EQ.1) GO TO 130  e&  	    J = 0		! Best possibility so far  	    DO I=CHOICE-1,1,-1;  		IF (POINTERS(2,I).LT.POINTERS(2,CHOICE)) THEN      ! col ;  		    IF (POINTERS(1,I).GT.POINTERS(1,CHOICE)) THEN  ! rows	  			J = I -  			DIFF = POINTERS(1,I) - POINTERS(1,CHOICE)c  		    ELSEh  			IF (J.NE.0) THEN'  			    IF (DIFF.GT.POINTERS(1,CHOICE)-    	1					    POINTERS(1,I)) J = I  			ELSE
  			    J = I*	  			ENDIFi
  			GO TO 150T  		    ENDIF  		ENDIF  	    ENDDO      	    IF (J.NE.0) GO TO 150c  .,  	ELSE IF (INPUT_CHAR.EQ.'M') THEN			! ENTER  g  	    CALL EXIT_  i1  	ELSE IF (INPUT_CHAR.EQ.'Q') THEN			! PF2 (help)c     	    CALL HELPr  .  	ENDIFI  h  	GO TO 130   A *2Dk  	END									s *2Ed *2Ih  	END									   *2En  	SUBROUTINE INITIALIZEk  s  	IMPLICIT NONE*     	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24)I/  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)h5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERSt  a *2Dc"  	LOGICAL SYMBOLS,WIDE,DEBUG,NOINT *2E  *2Ii*  	LOGICAL*4 SYMBOLS,WIDE,DEBUG,NOINTERRUPT *2Ea  	INTEGER*2 PLEN,PLEN2  	CHARACTER*32 POINTER  	CHARACTER*1 ITEM *2D A  	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,PLEN,PLEN2,POINTER,ITEM,NOINTs *2E  *2InG  	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,NOINTERRUPT,PLEN,PLEN2,POINTER,ITEMm *2E*  n  	INTEGER*4 CHOICE,START0 / 0 /l *2Db  	LOGICAL BOUND / .FALSE. /h *2Eb *2I   	LOGICAL*4 BOUND / .FALSE. /t *2Ey"  	CHARACTER*9 PARK / '[22;080H' /(  	COMMON /UTIL/ CHOICE,START0,BOUND,PARK  R  	INTEGER*4 TEXT  	COMMON /TEXT/ TEXT   &  	INTEGER*4 I,LEN0,COL,COL2,MAXCOL /0/  	EXTERNAL ABORT  s  	DATA MAXL,MAXP / 0,0 /  e  	CALL PROCESS_QUALIFIERS      	IF (WIDE) THEN'  	    CALL SMGL_SET_TERMINAL_WIDTH(132)l  	    PARK = '[22;132H'  	ENDIFs  o8  	CALL CLI$GET_VALUE('P1',LINES(0),LEN0)	! Get file name  tA  	OPEN (1,FILE=LINES(0)(1:LEN0),DEFAULTFILE='.MENU',STATUS='OLD',d  	1						       READONLY)i  eH  *	Read in the lines; remove comments; substitute DCL symbols if needed.  u)  10	READ (1,1000,END=20) LLEN(0),LINES(0)r  f5  	IF (LLEN(0).GT.0.AND.LINES(0)(1:1).EQ.'!') GO TO 10*  i  	IF (LLEN(0).GT.0) THEN  e4  	    IF (MAXL.EQ.0 .AND. LINES(0)(1:1).EQ.'/') THEN  		CALL PROCESS_QUALIFIERS  		GO TO 10i  	    ENDIFo  u  	    IF (SYMBOLS) THENe1  		IF (LLEN(0).LT.200) LINES(0)(LLEN(0)+1:) = ' 'o%  		CALL SYMBOL_SUBSTITUTE(LINES(0),I)a  		LLEN(0) = I%  		IF (LINES(0)(1:1).EQ.'!') GO TO 10l  	    ENDIFx  a  	ENDIFt  d  	MAXL = MAXL + 1y/  	CALL DETAB(LINES(0)(1:LLEN(0)),LINES(MAXL),I)a  Y  	LLEN(MAXL) = I'  	IF (I.LT.200) LINES(MAXL)(I+1:) = ' 'c  )5  	CALL REMOVE_ESCAPE(LINES(MAXL)(1:I),SLINES(MAXL),I)a(  	IF (I.LT.132) SLINES(MAXL)(I+1:) = ' '   @  	MAXCOL = MAX(MAXCOL,I)		! Record length of longest screen line  m  	IF (MAXL.LT.24) GO TO 10  e
  20	CLOSE (1)   i7  	IF (MAXL.EQ.0) CALL ERROR(2)	! Menu contains no liness  eC  	DO COL=1,MAXCOL		! Find all of the selectable items; record theiru  				!  line and column numberse  	    DO I=1,MAXLt  a'  		IF (SLINES(I)(COL:COL).EQ.ITEM) THENc(  		    IF (COL-PLEN2.LT.0) CALL ERROR(6)  		    MAXP = MAXP + 1  		    POINTERS(1,MAXP) = I   		    POINTERS(2,MAXP) = COLa  		    IF (.NOT.DEBUG) THENu#  		        SLINES(I)(COL:COL) = ' ':  			COL2 = INDEX(LINES(I),ITEM)l  			LINES(I)(COL2:COL2) = ' '*  		    ENDIF  		ENDIF  \  	    ENDDO   *  	ENDDOt   C  	IF (MAXP.LT.2) CALL ERROR(3)	! Menu contains 0-1 selectable itemsn  e   	IF (CHOICE.GT.MAXP) CHOICE = 1     	IF (TEXT) CALL PROCESS_TEXTe  u *2Dn"  	IF (NOINT) CALL CONTROL_Y(ABORT) *2Ee *2Iu(  	IF (NOINTERRUPT) CALL CONTROL_Y(ABORT) *2E   *6  	CALL SET_CLOCK			! Search for "00:00:00" in the file  t  1000	FORMAT (Q,A)    *2De  	END									t *2E* *2Ie  	END									   *2E   	SUBROUTINE PROCESS_QUALIFIERS      	IMPLICIT NONE   e  	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24)d/  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)*5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERSw  e *2D "  	LOGICAL SYMBOLS,WIDE,DEBUG,NOINT *2Eo *2Io*  	LOGICAL*4 SYMBOLS,WIDE,DEBUG,NOINTERRUPT *2E*  	INTEGER*2 PLEN,PLEN2  	CHARACTER*32 POINTER  	CHARACTER*1 ITEM *2DTA  	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,PLEN,PLEN2,POINTER,ITEM,NOINT  *2Er *2InG  	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,NOINTERRUPT,PLEN,PLEN2,POINTER,ITEMt *2En     	INTEGER*4 CHOICE,START0D *2D   	LOGICAL BOUND  *2E  *2IT  	LOGICAL*4 BOUNDO *2E,  	CHARACTER*9 PARK(  	COMMON /UTIL/ CHOICE,START0,BOUND,PARK  t  	INTEGER*4 TEXT /0/  	COMMON /TEXT/ TEXT   
  	INTEGER*4 I  *2De>  	LOGICAL FIRST_CALL,CLI$PRESENT,INTERACTIVE_MODE,OTS$CVT_TI_L *2E  *2In@  	LOGICAL*4 FIRST_CALL,CLI$PRESENT,INTERACTIVE_MODE,OTS$CVT_TI_L *2Es  	EXTERNAL MENU_CLDv  s *2Ds:  	DATA SYMBOLS,WIDE,NOINT,FIRST_CALL / .FALSE. , .FALSE. , *2Ea *2I @  	DATA SYMBOLS,WIDE,NOINTERRUPT,FIRST_CALL / .FALSE. , .FALSE. , *2Ed  	1				     .FALSE. , .TRUE. /  d  	IF (FIRST_CALL) THEN  	    FIRST_CALL = .FALSE.&  	    IF (CLI$PRESENT('VERSION')) THEN  		CALL LIB$PUT_OUTPUT(t<  	1	       'NSWC ZMENU Rev 1.005 Created  7-JAN-1992 12:00')  		CALL EXIT  	    ENDIFe0  	    IF (.NOT.INTERACTIVE_MODE()) CALL ERROR(1)"  	    DEBUG = CLI$PRESENT('DEBUG')  	ELSE   	    LINES(0)(LLEN(0)+1:) = ' '.  	    CALL SYMBOL_SUBSTITUTE(LINES(0),LLEN(0))?  	    CALL CLI$DCL_PARSE('MENU '//LINES(0)(1:LLEN(0)),MENU_CLD)t  	ENDIFa  r2  	IF (CLI$PRESENT('SYMBOLS'))     SYMBOLS = .TRUE.2  	IF (CLI$PRESENT('WIDE'))        WIDE    = .TRUE.2  	IF (CLI$PRESENT('TEXT'))        TEXT    = .TRUE. *2Dr2  	IF (CLI$PRESENT('NOINTERRUPT')) NOINT   = .TRUE. *2El *2Io8  	IF (CLI$PRESENT('NOINTERRUPT')) NOINTERRUPT   = .TRUE. *2Ee.  	IF (CLI$PRESENT('START0'))      START0  = -12  	IF (CLI$PRESENT('BOUND'))       BOUND   = .TRUE.  r"  	IF (CLI$PRESENT('INITIAL')) THEN4  	    CALL CLI$GET_VALUE('INITIAL',LINES(1),LLEN(1))3  	    CALL OTS$CVT_TI_L(LINES(1)(1:LLEN(1)),CHOICE)   	ENDIFn  d"  	IF (CLI$PRESENT('POINTER')) THEN0  	    CALL CLI$GET_VALUE('POINTER',POINTER,PLEN)4  	    CALL REMOVE_ESCAPE(POINTER(1:PLEN),LINES(1),I)  	    PLEN2 = Il  	ENDIFi   :  	IF (CLI$PRESENT('ITEM')) CALL CLI$GET_VALUE('ITEM',ITEM)  h *2Dm  	END									  *2E- *2If  	END									   *2E   	SUBROUTINE PROCESS_TEXTi     	IMPLICIT NONEs   -  	INTEGER*4 TEXT /0/, TLEN, XROW /0/,XCOL /0/t"  	CHARACTER*8 XADDR / '[24;01H' /  	CHARACTER*80 TEXT_/  	COMMON /TEXT/ TEXT,TLEN,XROW,XCOL,XADDR,TEXT_t   +  	INTEGER*4 XFCOL,XLEN / 0 /, XDELLEN / 1 /h  	CHARACTER*16 XDEL /' ' /(  	COMMON /TEXT2/ XFCOL,XLEN,XDELLEN,XDEL  t  	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24)H/  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99) 5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS   *  	CHARACTER*1 FROM / '\' /  e'  	CALL CLI$GET_VALUE('TEXT',TEXT_,TLEN)r  	IF (TLEN.LT.1) CALL ERROR(4)   
  	TEXT = 0!  	IF (TEXT_(1:1).EQ.'A') TEXT = 1N!  	IF (TEXT_(1:1).EQ.'C') TEXT = 3*!  	IF (TEXT_(1:1).EQ.'K') TEXT = 5E  	IF (TEXT.EQ.0) CALL ERROR(4)   "  	IF (TLEN.GE.2) FROM = TEXT_(2:2)   	IF (FROM.EQ.' ') CALL ERROR(4)  N  	IF (TLEN.GE.3) THENO=  	    XDEL = TEXT_(3:TLEN)	! Background character plus escape(&  	    XDELLEN = TLEN - 2		!  sequences  	ENDIF(  9G  	CALL REMOVE_ESCAPE(XDEL(1:XDELLEN),TEXT_,TLEN)	! Background character*1  	IF (TLEN.NE.1) CALL ERROR(4)			!  in TEXT_(1:1)   	)  	DO WHILE (XCOL.EQ.0 .AND. XROW.LT.MAXL)R:  	    XROW = XROW + 1		    ! Screen row of text entry areaH  	    XCOL = INDEX(SLINES(XROW),FROM) ! Screen column of text entry area  	ENDDO      	IF (XCOL.EQ.0) CALL ERROR(5)  cF  	XFCOL = INDEX(LINES(XROW),FROM)	    ! File column of text entry area  cD  *	Insert the background character into the file columns, for use in  *	screen paints.	  l9  	DO WHILE (LINES(XROW)(XFCOL+XLEN:XFCOL+XLEN) .EQ. FROM)25  	    LINES(XROW)(XFCOL+XLEN:XFCOL+XLEN) = TEXT_(1:1)N6  	    XLEN = XLEN + 1		    ! Length of text entry area  	ENDDO   e;  	CALL SYS$FAO('[!2UL;!2ULH',,XADDR,%VAL(XROW),%VAL(XCOL))e&  	IF (XCOL+XLEN-1.GT.80) CALL ERROR(5)  (
  	TEXT_ = ' '	
  	TLEN = 0  E *2D)  	END									  *2EN *2IH  	END									   *2E	6  	SUBROUTINE REMOVE_ESCAPE(OLDSTRING,NEWSTRING,NEWLEN)     	IMPLICIT NONE(  U#  	CHARACTER*(*) OLDSTRING,NEWSTRING   	INTEGER*4 NEWLEN  IF  *	NOTE -- There is currently no test for incomplete escape sequences.  H  	INTEGER*4 COL(9  	CHARACTER*1 TERM1,ESC /27/, CSI /155/, SO /14/, SI /15/U  H  	NEWLEN = 0	  	COL = 1	  H%  10	IF (COL.GT.LEN(OLDSTRING)) RETURN   LB  	IF (OLDSTRING(COL:COL).EQ.ESC.OR.OLDSTRING(COL:COL).EQ.'') THEN  c-  	    IF (OLDSTRING(COL+1:COL+1).EQ.'[') THENE  		TERM1 = '@'				! 4/01  		COL = COL + 1
  	    ELSE  		TERM1 = '0'				! 3/0   	    ENDIF.   *  	ELSE IF (OLDSTRING(COL:COL).EQ.CSI) THEN  P  	    TERM1 = '@'					! 4/0   P(  	ELSE IF (OLDSTRING(COL:COL).EQ.SO .OR.'  	1				  OLDSTRING(COL:COL).EQ.SI) THEN   	    COL = COL + 1I  	    GO TO 10  E  	ELSE  T  	    NEWLEN = NEWLEN + 1	3  	    NEWSTRING(NEWLEN:NEWLEN) = OLDSTRING(COL:COL)(  I  	    COL = COL + 1P  	    GO TO 10  T  	ENDIF   e  20	COL = COL + 1E  	&  	IF (OLDSTRING(COL:COL).LT.TERM1 .OR.-  	1			    OLDSTRING(COL:COL).GT.'~') GO TO 20T  *  	COL = COL + 1O  .
  	GO TO 10  1 *2D	  	END									R *2EH *2I.  	END									   *2EG)  	SUBROUTINE DISPLAY_LINE(LINE_NO,OPTION)C  C  	IMPLICIT NONE(  I  	INTEGER*4 LINE_NO,OPTION  O  	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24)T/  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)	5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS+  A *2D	"  	LOGICAL SYMBOLS,WIDE,DEBUG,NOINT *2E  *2I *  	LOGICAL*4 SYMBOLS,WIDE,DEBUG,NOINTERRUPT *2E1  	INTEGER*2 PLEN,PLEN2  	CHARACTER*32 POINTER  	CHARACTER*1 ITEM *2DEA  	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,PLEN,PLEN2,POINTER,ITEM,NOINTr *2E	 *2I G  	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,NOINTERRUPT,PLEN,PLEN2,POINTER,ITEM. *2EE  1
  	INTEGER*4 L      	L = LLEN(LINE_NO)   	  	IF (OPTION.NE.0) THENN  	:  	    CALL SCREEN('[H[2K'//LINES(LINE_NO)(1:L),LINE_NO)     	ELSE  F6  	    CALL SCREEN('[H'//LINES(LINE_NO)(1:L),LINE_NO)  t  	ENDIFL  I *2DP  	END									H *2E! *2I*  	END									   *2E.  	SUBROUTINE DISPLAY_POINTER  B  	IMPLICIT NONEo  r *2D "  	LOGICAL SYMBOLS,WIDE,DEBUG,NOINT *2E) *2IO*  	LOGICAL*4 SYMBOLS,WIDE,DEBUG,NOINTERRUPT *2EI  	INTEGER*2 PLEN,PLEN2  	CHARACTER*32 POINTER  	CHARACTER*1 ITEM *2DIA  	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,PLEN,PLEN2,POINTER,ITEM,NOINTN *2E	 *2IFG  	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,NOINTERRUPT,PLEN,PLEN2,POINTER,ITEME *2E	     	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24)F/  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99) 5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS	     	INTEGER*4 CHOICE,START0I *2DC  	LOGICAL BOUND	 *2E2 *2Ip  	LOGICAL*4 BOUNDH *2E   	CHARACTER*9 PARK(  	COMMON /UTIL/ CHOICE,START0,BOUND,PARK     	CHARACTER*8 PESC / ' ' /  	CHARACTER*24 BLANKS / ' ' /s  	  	INTEGER*4 LESC,PROW,PCOL,CLEN3  L  	IF (PESC.NE.' ')B  	1     CALL SCREEN(PESC(1:LESC)//SLINES(PROW)(PCOL:PCOL+PLEN2-1))  	  	PROW = POINTERS(1,CHOICE)E'  	PCOL = POINTERS(2,CHOICE) - PLEN2 + 1A  Y<  	CALL SYS$FAO('[!UL;!ULH',LESC,PESC,%VAL(PROW),%VAL(PCOL))  G2  	CALL SCREEN(PESC(1:LESC)//POINTER(1:PLEN)//PARK)  *2  	IF (DEBUG) CALL SCREEN('[2D ',CHOICE + START0)  S *2DS  	END									P *2EP *2IR  	END									   *2E   	SUBROUTINE SET_CLOCK  D  	IMPLICIT NONEP  L  	INTEGER*4   interval  	PARAMETER ( interval = 5 )  T  	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24) /  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)*5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERSO  ,  	INTEGER*4 TROW,TCOLE  	COMMON /TIME/ TROW,TCOL   	  	INTEGER*4 SECC  C  	EXTERNAL CLOCK  E *2DA  	LOGICAL FIRST_CALL / .TRUE. // *2E  *2IL!  	LOGICAL*4 FIRST_CALL / .TRUE. /E *2EN  	  	IF (FIRST_CALL) THEN  W  	    FIRST_CALL = .FALSE.  1  	    DO TROW=1,MAXL  L5  		TCOL = INDEX(LINES(TROW)(1:LLEN(TROW)),'00:00:00')   P  		IF (TCOL.NE.0) GO TO 10  A  	    ENDDOU  T  	    RETURN  	2  10	    SEC = MOD( IFIX( SECNDS(0.) ) , interval )  e(  	    CALL TIMER_SET(interval-SEC,CLOCK)   )  	    CALL TIME(LINES(TROW)(TCOL:TCOL+7))0     	ELSE  L$  	    CALL TIMER_SET(interval,CLOCK)  O  	ENDIF   F *2DN  	END									e *2E  *2I(  	END									   *2E1  	SUBROUTINE CLOCK  L  	IMPLICIT NONEE     	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24) /  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)o5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERSI  	  	INTEGER*4 CHOICE,START0G *2D1  	LOGICAL BOUND  *2E	 *2It  	LOGICAL*4 BOUND  *2E   	CHARACTER*9 PARK(  	COMMON /UTIL/ CHOICE,START0,BOUND,PARK  )  	INTEGER*4 TROW,TCOLI  	COMMON /TIME/ TROW,TCOL   A *2DM  	LOGICAL HELPINGX *2EI *2IN  	LOGICAL*4 HELPING. *2E2  	COMMON /HELP/ HELPING'     	CALL SET_CLOCK  O%  	CALL TIME(LINES(TROW)(TCOL:TCOL+7))   e&  	IF (HELPING .AND. TROW.GE.20) RETURN  L  	CALL DISPLAY_LINE(TROW,0))  L  	CALL SCREEN(PARK)t  s *2Di  	END									L *2EX *2I!  	END									   *2El  	SUBROUTINE TEXTIN(CODE)	     	IMPLICIT NONEu  r  	INTEGER*4 CODE  t  	INTEGER*4 TEXT,TLEN,XROW,XCOLQ  	CHARACTER*8 XADDRI  	CHARACTER*80 TEXT_/  	COMMON /TEXT/ TEXT,TLEN,XROW,XCOL,XADDR,TEXT_R  ,  	INTEGER*4 XFCOL,XLEN,XDELLEN  	CHARACTER*16 XDEL (  	COMMON /TEXT2/ XFCOL,XLEN,XDELLEN,XDEL  C  	LOGICAL*1 INPUT_READYD#  	CHARACTER*1 INPUT_CHAR,INPUT_FLAG:2  	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY     	INTEGER*4 CHOICE,START0P *2D)  	LOGICAL BOUNDM *2Eo *2Is  	LOGICAL*4 BOUNDm *2Ee  	CHARACTER*9 PARK(  	COMMON /UTIL/ CHOICE,START0,BOUND,PARK  T  	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24) /  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)25  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERSh  i  	CHARACTER*80 UPT  	CHARACTER*6 ON / '[1;7m' /	  	CHARACTER*3 OFF / '[m' /	  	INTEGER*4 SAVED_CHOICE,I,COL.  	INTEGER*4 STATUS,LIB$SET_SYMBOL,OTS$CVT_TI_L  *(  	IF (CODE.EQ.0) THEN			! DELETE entered     	    IF (TLEN.EQ.0) RETURNA  	    COL = TLEN + XCOL - 1/>  	    CALL SCREEN(XADDR(1:5)//'H'//XDEL(1:XDELLEN)//PARK,COL)  	    TLEN = TLEN - 1I     	    IF (TEXT.EQ.3) GO TO 20,  	    IF (TEXT.EQ.5) GO TO 40	  E/  	ELSE IF (CODE.EQ.1) THEN		! Character enteredC  *  	    IF (TLEN.EQ.XLEN) RETURN  	    IF (TLEN.EQ.0) THEN2  		SAVED_CHOICE = CHOICE  		IF (START0) SAVED_CHOICE = 1W  	    ENDIFN$  	    IF (TLEN.EQ.LEN(TEXT_)) RETURN;  	    IF (TEXT.EQ.5) CALL STR$UPCASE(INPUT_CHAR,INPUT_CHAR)   	    TLEN = TLEN + 1N#  	    TEXT_(TLEN:TLEN) = INPUT_CHARN  T>  	    CALL SCREEN(XADDR(1:5)//'H'//ON//INPUT_CHAR//OFF//PARK,  	1						    TLEN+XCOL-1)*     	    IF (TEXT.EQ.3) GO TO 20I  	    IF (TEXT.EQ.5) GO TO 40V  I,  	ELSE IF (CODE.EQ.2) THEN		! Screen refresh  T0  	    CALL SCREEN(XADDR//ON//TEXT_(1:TLEN)//OFF)  _*  	ELSE IF (CODE.EQ.3) THEN		! Program exit  _  	    IF (TEXT.NE.1) RETURN2   9  	    STATUS = LIB$SET_SYMBOL('ZMENU_TEXT',TEXT_(1:TLEN)),4  	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  F-  	ELSE IF (CODE.EQ.4) THEN		! Delete all text      	    IF (TLEN.EQ.0) RETURN !  10	    CALL DISPLAY_LINE(XROW,0)	  	    TEXT_ = ' 'R  	    TLEN = 0  -  	ENDIF1  0  	RETURN  XP  *-----	Text is assumed to be a choice number ----------------------------------  $  20	IF (TLEN.EQ.0) THEN   	    CHOICE = SAVED_CHOICE'  	ELSE-  	    IF (OTS$CVT_TI_L(TEXT_(1:TLEN),I)) THEN   		I = I - START0E#  		IF (I.GE.1 .AND. I.LE.MAXP) THEND  		    CHOICE = I	  		ELSER  		    GO TO 30   		ENDIF
  	    ELSE  30		CHOICE = SAVED_CHOICE  		GO TO 10   	    ENDIFF  	ENDIFS  	RETURN   P  *-----	Text is assumed to be a choice keyword ---------------------------------  l  40	IF (TLEN.EQ.0) THEN(  	    CHOICE = SAVED_CHOICE   	ELSE  	    DO I=1,MAXPR  		COL = POINTERS(2,I) + 1  		CALL STR$UPCASE(UP(1:TLEN),.  	1			  SLINES(POINTERS(1,I))(COL+1:COL+TLEN))(  		IF (TEXT_(1:TLEN).EQ.UP(1:TLEN)) THEN  		    CHOICE = I1
  		    RETURN   		ENDIF  	    ENDDOE  	    GO TO 30  	ENDIF   N *2D   	END									S *2EP *2IR  	END									   *2EG  	SUBROUTINE HELPP  T  	IMPLICIT NONEA  R  	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24)l/  	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)L5  	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS2     	LOGICAL*1 INPUT_READY #  	CHARACTER*1 INPUT_CHAR,INPUT_FLAG 2  	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY  / *2DO  	LOGICAL HELPING / .FALSE. / *2E1 *2I   	LOGICAL*4 HELPING / .FALSE. /E *2EE  	COMMON /HELP/ HELPINGE  	VOLATILE HELPING  F  	character*1024 buffer   	common /buffer/ buffer  '
  	INTEGER*2 IE  /  	HELPING = .TRUE.  LB  	CALL SCREEN('[20H[J[20;24r[24H[K------------------------'//B  	1      '------------------------------------------------------')  L*  	CALL SCREEN('E [7m   H E L P   [m  ')   8  	CALL SCREEN('Use arrow keys to move the pointer to '//   	1					    'the desired item.')   :  	CALL SCREEN('E		Type RETURN, ENTER, DO, or SELECT to'//   	1					    ' select the item.')  ::  	CALL SCREEN('E		Type CONTROL-W to refresh the screen.')  (6  	CALL SCREEN('E		[5;7m Type a blank to return to'//   	1					       ' the menu. [m')  	  	call screen_endT  )  10	CALL GET_TERMINAL_INPUTe  p8  	IF (INPUT_FLAG.NE.' ' .OR. INPUT_CHAR.NE.' ') GO TO 10  A  	call screen_start(buffer)E  T  	DO I=20,24  g  	    IF (I.LE.MAXL) THENN  		CALL DISPLAY_LINE(I,1)n
  	    ELSE  		CALL SCREEN('[H[2K',I)  	    ENDIFA  R  	ENDDOR  =  	CALL SCREEN('[1;24r')  f  	CALL DISPLAY_POINTER  L  	HELPING = .FALSE.,  M *2Dc  	END									x *2Er *2Ia  	END									   *2EL  	SUBROUTINE ERROR(CODE)  F  	IMPLICIT NONE(  W  	INTEGER*4 CODE  l!  	CHARACTER*9 PRE / '%ZMENU-F-' /r  h  	IF (CODE.EQ.1) THENi>  	  CALL LIB$PUT_OUTPUT(PRE//'NONINT, ZMENU must be called '//.  	1			      'only from INTERACTIVE processes')  	ELSE IF (CODE.EQ.2) THEN>  	  CALL LIB$PUT_OUTPUT(PRE//'EMPTY, the menu file contains'//   	1					 ' no lines to display')  	ELSE IF (CODE.EQ.3) THEN@  	  CALL LIB$PUT_OUTPUT(PRE//'INSUFF, the menu contains fewer'//'  	1				   ' than two selectable items')=  	ELSE IF (CODE.EQ.4) THEN@  	  CALL LIB$PUT_OUTPUT(PRE//'BADQUAL, invalid /TEXT qualifier')  	ELSE IF (CODE.EQ.5) THENB  	  CALL LIB$PUT_OUTPUT(PRE//'TEXT, missing or invalid text area')  	ELSE IF (CODE.EQ.6) THEN>  	  CALL LIB$PUT_OUTPUT(PRE//'ITEMCOL, the menu contains an'//5  	1		    ' item marker too close to the left margin')   	ENDIF,     	CALL EXIT('10000004'X)  = *2D	  	END										 *2EO *2IL  	END									   *2EL  	SUBROUTINE EXIT_  O  	IMPLICIT NONET  G  	INTEGER*4 CHOICE,START0  *2D   	LOGICAL BOUND+ *2E+ *2I.  	LOGICAL*4 BOUND1 *2E'  	CHARACTER*9 PARK(  	COMMON /UTIL/ CHOICE,START0,BOUND,PARK   &  	IF (START0 .AND. CHOICE.EQ.1) RETURN  L1  10	CALL INT$SET_SYMBOL('CHOICE',CHOICE + START0)   P  	CALL TEXTIN(3)  G&  	CALL SCREEN('[?25h[1;24r[23H[m')  L  	CALL EXITT     	   
  	ENTRY ABORT      O  	CHOICE = 0  E1  	CALL SCREEN_FILE(' ')				! Prevent RMS problemsE  N
  	GO TO 10  T *2DC  	END									  *2E  *2I   	END									   *2E 