  	SUBROUTINE TERMINAL_DATA     **   *	SUBROUTINE TERMINAL_DATA   *  *E  *	Returns information about this process' terminal.  The information   *	returned is:   *5  *	  * The terminal name (and the length of the name)   **  *	  * The terminal type code (see $DCDEF)  *E  *	  * The two longwords of device-dependent characteristics (see the >  *	    I/O User's Guide, page 9-18 ff, and $TTDEF and $TT2DEF)  *B  *	The data are returned in /TERMINAL_DATA_/, which is defined as:  *  *	CHARACTER*8 DEVNAME  *=  *	COMMON /TERMINAL_DATA_/ DEVNAME, DEVTYPE, DEPEND, DEPEND2,   *	1			DEVNAMELEN   */  *	See also routine SMGL_GET_TERMINAL_SETTINGS.   *  *	.INDEX TERMINAL I/O>>  *	.INDEX ENVIRONMENT>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	24 Aug 1983	   Dahlgren, Virginia  22448   *     	IMPLICIT INTEGER (A-Z)   '  	PARAMETER ( DVI$_DEVDEPEND  =  'A'X ) '  	PARAMETER ( DVI$_DEVDEPEND2 = '1C'X ) '  	PARAMETER ( DVI$_DEVNAM     = '20'X ) '  	PARAMETER ( DVI$_DEVTYPE    =  '6'X )      	INTEGER ITMLST(13)     	INTEGER*2 IOSB(4)   	CHARACTER*8 DEVNAME    <  	COMMON /TERMINAL_DATA_/ DEVNAME, DEVTYPE, DEPEND, DEPEND2,  	1			DEVNAMELEN   .  	CALL ITEM_LIST(ITMLST,DVI$_DEVDEPEND,DEPEND,#  	1		      DVI$_DEVDEPEND2,DEPEND2, *  	2		      DVI$_DEVNAM,DEVNAME,DEVNAMELEN,   	3		      DVI$_DEVTYPE,DEVTYPE)   =  	STATUS = SYS$GETDVIW( %VAL(2) ,, 'TT:' , ITMLST , IOSB ,,,)    0  	IF (.NOT.STATUS) CALL LIB$STOP( %VAL(STATUS) )   2  	IF (.NOT.IOSB(1)) CALL LIB$STOP( %VAL(IOSB(1)) )     	END '  	SUBROUTINE CONTROL(CHARACTER,ROUTINE)      ** ,  *	SUBROUTINE CONTROL( character , routine )  *  *E  *	Sets up linkage for subroutine ROUTINE to get control  when  ASCII ,  *	character 'control-CHARACTER' is entered.  *E  *	The argument CHARACTER must be a single alphabetic character,  not :  *	including 'C' OR 'Y'.  It must be an UPPER-CASE letter.  *E  *	The argument ROUTINE must be declared EXTERNAL in the calling pro-   *	gram.  *  *	For example:   *			CALL CONTROL('B',X)  *:  *	causes routine X to be called when a <ctrl-b> is typed.  *E  *	CONTROL can be called multiple times, with different CHARACTER and 3  *	ROUTINE arguments, to set up different linkages.   *5  *	  Reference:  VAX/VMS I/O User's Guide  (Volume 1) >  *		      Terminal Driver Chapter  (Chapter 9 in 6/83 edition)>  *		      Out-of-band AST Function Modifier  (9.4.3.5 in 6/83)  *  *	.INDEX TERMINAL I/O>>  *	.INDEX PROCESS CONTROL>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	4 Feb 1983	   Dahlgren, Virginia  22448  *     	IMPLICIT INTEGER (A-Z)   $  	PARAMETER ( IO$_SETMODE  = '23'X )%  	PARAMETER ( IO$M_OUTBAND = '400'X )      	CHARACTER*(*) CHARACTER   	CHARACTER*1 C   	INTEGER MASK(2)   	INTEGER*2 CHAN,IOSB(4)  	EXTERNAL ROUTINE     	DATA MASK / 2*0 /      	C = CHARACTER    5  	IF (LEN(CHARACTER).NE.1 .OR. C.EQ.'C' .OR. C.EQ.'Y' 7  	1	.OR. C.LT.'A' .OR. C.GT.'Z') CALL EXIT('10000004'X)    *  	MASK(2) = ISHFT(1,ICHAR(C)-ICHAR('A')+1)   @  	STATUS = SYS$ASSIGN('TT',CHAN,,)	! Must assign new channel for  						! 	 each call to CONTROL .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))   ?  	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE+IO$M_OUTBAND),    	1					IOSB,,,ROUTINE,MASK,,,,)   .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))   0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))     	END   	SUBROUTINE CONTROL_Y(ROUTINE)      ** "  *	SUBROUTINE CONTROL_Y( routine )  *  *E  *	Sets up linkage for subroutine ROUTINE to get control  when  ASCII E  *	<control-Y>  or  <control-C>  is entered to abort this image.  The E  *	argument ROUTINE must be declared EXTERNAL in the calling program. E  *	This routine disables CLI interpretation of <ctrl-Y> and <ctrl-C>, E  *	and sets up an exit handler to re-enable them when the image exits E  *	(this is in case the caller does not do it in ROUTINE,  by calling E  *	LIB$ENABLE_CTRL.  The exit handler is the separate  routine  named   *	CONTROL_Y_EXIT.  *E  *	If called with a null argument, the default action of  <control-Y>    *	and <control-C> are restored.  *&  *	22 Feb 85	Added restoration option.  *  *	.INDEX TERMINAL I/O>>  *	.INDEX PROCESS CONTROL>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	4 Feb 1983	   Dahlgren, Virginia  22448  *     	IMPLICIT INTEGER (A-Z)   $  	PARAMETER ( IO$_SETMODE  = '23'X )%  	PARAMETER ( IO$M_CTRLYAST = '80'X ) &  	PARAMETER ( IO$M_CTRLCAST = '100'X )     	INTEGER*2 CHAN,IOSB(4)!  	EXTERNAL ROUTINE,CONTROL_Y_EXIT      	COMMON /TT_CHAN_TT/ CHAN     	DATA CHAN / 0 /      	IF (CHAN.EQ.0) THEN    &  	    STATUS = SYS$ASSIGN('TT',CHAN,,)   2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))     	ENDIF    @  	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE+IO$M_CTRLYAST),  	1						IOSB,,,ROUTINE,,,,,)    .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))   @  	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE+IO$M_CTRLCAST),  	1						IOSB,,,ROUTINE,,,,,)    .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))     	IF (%LOC(ROUTINE).NE.0) THEN   /  	    CALL DECLARE_EXIT_HANDLER(CONTROL_Y_EXIT)    ,  	    STATUS = LIB$DISABLE_CTRL('02000000'X)     	ELSE   .  	    CALL CANCEL_EXIT_HANDLER(CONTROL_Y_EXIT)   +  	    STATUS = LIB$ENABLE_CTRL('02000000'X)      	ENDIF    .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))     	END   	SUBROUTINE CONTROL_Y_EXIT      **   *	SUBROUTINE CONTROL_Y_EXIT  *  *E  *	This routine is not normally called by the user.   It  is  an exit E  *	handler  set  up by routine CONTROL_Y to re-enable CLI interpreta- E  *	tion of <ctrl-Y> and <ctrl-C>.  See routine CONTROL_Y for details.   *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	4 Feb 1983	   Dahlgren, Virginia  22448  *     	IMPLICIT INTEGER (A-Z)   '  	STATUS = LIB$ENABLE_CTRL('02000000'X)    .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))     	END   	SUBROUTINE SET_INPUT_ALARM     **   *	SUBROUTINE SET_INPUT_ALARM   *  *E  *	Sets things up so that when a character is entered at the caller's 8  *	VTxxx terminal keyboard, the following things happen:  *4  *		* The LOGICAL variable INPUT_READY is set .TRUE.  *>  *		* The  value of the character entered is put into variable  *		  INPUT_CHAR  *>  *		* The variable INPUT_FLAG  is set to  ' '  (blank)  if the>  *		  character is a printable character, '*' if it is a  con->  *		  trol character, or '.' if it indicates an escape sequen->  *		  ce (i.e. an arrow key or keypad key was hit).   In  this>  *		  last case, INPUT_CHAR contains the last character of the>  *		  sequence  (for example,  if the  'up arrow'  key is hit,/  *		  INPUT_FLAG is '*' and INPUT_CHAR is 'A').   *>  *		  An exception to the above occurs when the last character>  *		  of the sequence is '~'.  This format is used by function>  *		  keys on VT2xx terminals.  INPUT_FLAG is set to  '~'  and>  *		  INPUT_CHAR  is set to the integer value of the preceding>  *		  one- or two-digit integer.   For example,  if key F10 is8  *		  hit, INPUT_FLAG is '~' and INPUT_CHAR is CHAR(21).  *>  *		* If the program is hibernating (i.e.  it  called  routine%  *		  GO_HIBERNATE) it is wakened up.   *(  *	The definition of these variables is:  *  *		LOGICAL*1 INPUT_READY %  *		CHARACTER*1 INPUT_CHAR,INPUT_FLAG   *4  *		COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY  *E  *	The typed characters are not echoed on the screen; it is up to the )  *	calling program to do this if desired.   *E  *	This routine enables a program to be doing useful work at the same E  *	time an input is expected, and, by testing INPUT_READY,  the input )  *	can be processed as soon as it occurs.   *E  *	When using this routine and the DELETE key  is  hit, it  does  not E  *	delete the last character; its ASCII value is placed in INPUT_CHAR   *	just like any other key.   *- E  *	This is a one-time enable.  After you process the input character, 9  *	you must call SET_INPUT_ALARM again to get more input.   *  *	.INDEX TERMINAL I/O>>  *5  *	 15 Jul 91	Allow input of all 256 character codes.   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	30 Apr 1983	   Dahlgren, Virginia  22448   *     	IMPLICIT INTEGER (A-Z)     	EXTERNAL INPUT_ALARM     	INTEGER*2 CHAN,IOSB(4)  	BYTE BUFFER(16)    +  	INTEGER*4 MASK(10) / 32,0,8*'FFFFFFFF'X /      	LOGICAL*1 INPUT_READY #  	CHARACTER*1 INPUT_CHAR,INPUT_FLAG    2  	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY  	COMMON /TT_CHAN_TT/ CHAN%  	COMMON /ALARM_IOSB/ IOSB,BUFFER,EFN    %  	DATA CHAN,INPUT_READY / 0,.FALSE. /    $  	PARAMETER ( IO$_READVBLK = '31'X )$  	PARAMETER ( IO$M_NOECHO  = '40'X )%  	PARAMETER ( IO$M_NOFILTR = '200'X ) &  	PARAMETER ( IO$M_ESCAPE  = '4000'X )9  	PARAMETER ( FUNCTION     = IO$_READVBLK + IO$M_NOECHO + #  	1				IO$M_NOFILTR + IO$M_ESCAPE )      	INPUT_READY = .FALSE.      	IF (CHAN.EQ.0) THEN &  	    STATUS = SYS$ASSIGN('TT',CHAN,,)2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	    STATUS = LIB$GET_EF(EFN)2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	ENDIF      	MASK(2)=%LOC(MASK(3))    #  *	NOTE FOLLOWING IS QIO, NOT QIOW!    :  	STATUS=SYS$QIO(%VAL(EFN),%VAL(CHAN),%VAL(FUNCTION),IOSB,.  	1			   INPUT_ALARM,,BUFFER,%VAL(16),,MASK,,)   .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))     	END (  	SUBROUTINE GET_TERMINAL_INPUT(TIMEOUT)     ** -  *	SUBROUTINE GET_TERMINAL_INPUT( [timeout] )   *  *E  *	This is  identical to  subroutine  SET_INPUT_ALARM, except that it 0  *	does not allow concurrent processing and I/O.  *E  *	If the optional TIMEOUT argument is present, the read will timeout E  *	after that many seconds.  If nothing has been entered, the calling C  *	program will get an indication that a NUL character was entered.   *  *	.INDEX TERMINAL I/O>>  *5  *	 15 Jul 91	Allow input of all 256 character codes. ,  *	 23 Oct 92	Add optional TIMEOUT argument.  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53/  *	30 Apr 1983        Dahlgren, Virginia  22448U  *  E  	IMPLICIT INTEGER (A-Z)  S  	INCLUDE '($IODEF)'     	EXTERNAL INPUT_ALARM  i  	LOGICAL ARG_EXIST' *2Ii  	INTEGER*4 IARGPTR  *2Er  	INTEGER*2 CHAN,IOSB(4)  	BYTE BUFFER(16)n  h+  	INTEGER*4 MASK(10) / 32,0,8*'FFFFFFFF'X /a  y  	LOGICAL*1 INPUT_READY #  	CHARACTER*1 INPUT_CHAR,INPUT_FLAGp2  	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY  d  	COMMON /TT_CHAN_TT/ CHAN%  	COMMON /ALARM_IOSB/ IOSB,BUFFER,EFNn  i%  	DATA CHAN,INPUT_READY / 0,.FALSE. /:  *A  	FUNCT = IO$_READVBLK + IO$M_NOECHO + IO$M_NOFILTR + IO$M_ESCAPEE  P *2DP  	IF (ARG_EXIST(1)) THEN *2EE *2I*(  	IF (ARG_EXIST(%VAL(IARGPTR()),1)) THEN *2ES   	    FUNCT = FUNCT + IO$M_TIMED  	    TIME = MAX(TIMEOUT,2)   	ELSE  	    TIME = 0  	ENDIFc  a  	INPUT_READY = .FALSE.e  3  	IF (CHAN.EQ.0) THENl&  	    STATUS = SYS$ASSIGN('TT',CHAN,,)2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	    STATUS = LIB$GET_EF(EFN)2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	ENDIF   	  	MASK(2) = %LOC(MASK(3))   '8  	STATUS=SYS$QIOW(%VAL(EFN),%VAL(CHAN),%VAL(FUNCT),IOSB,5  	1		 INPUT_ALARM,,BUFFER,%VAL(16),%VAL(TIME),MASK,,)   N.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))     	RETURN  _  T  M  	ENTRY CANCEL_INPUT_ALARM  	     **I   *	SUBROUTINE CANCEL_INPUT_ALARM  *  *E  *	Cancels  any outstanding  I/O request  queued to the terminal by aS,  *	previous call to routine SET_INPUT_ALARM.  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55/  *	13 Feb 1990        Dahlgren, Virginia  22448C  *  R!  	STATUS = SYS$CANCEL(%VAL(CHAN))   T,  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(CHAN))  n  	ENDr  	SUBROUTINE INPUT_ALARM  n  **   *	SUBROUTINE INPUT_ALARM'  *  *E  *	This routine is not called by the user.   Routine  SET_INPUT_ALARMaE  *	sets up this routine as the I/O completion AST routine for readingEE  *	from the terminal.  This routine checks  the status  of the  read,n5  *	and parses the input (to set variable INPUT_FLAG).	  *,  *	17 Jun 87	Update for VT220 character set.  **  *	13 Feb 91	Don't abort if I/O Cancelled.  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	30 Apr 1983	   Dahlgren, Virginia  22448O  *     	IMPLICIT INTEGER (A-Z)     	INTEGER*2 ESC / '1B'X /h  	INTEGER*2 CSI / '9B'X /*  	INTEGER*2 SS3 / '8F'X /c  n.  	EXTERNAL SS$_BADESCAPE,SS$_ABORT,SS$_TIMEOUT  L  	INTEGER*2 IOSB(4)C  	BYTE BUFFER(16)   A  	LOGICAL*1 INPUT_READYu#  	CHARACTER*1 INPUT_CHAR,INPUT_FLAG3  *2  	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY%  	COMMON /ALARM_IOSB/ IOSB,BUFFER,EFN   	COMMON /HIBER_/ HIBERNATINGA  E  	IF (.NOT.IOSB(1)) THEN   +  	  IF (IOSB(1).NE.%LOC(SS$_BADESCAPE).AND. '  	1     IOSB(1).NE.%LOC(SS$_ABORT).AND.IB  	2     IOSB(1).NE.%LOC(SS$_TIMEOUT)) CALL LIB$STOP(%VAL(IOSB(1)))  E  	ENDIF	  ($  	INPUT_CHAR = CHAR(BUFFER(IOSB(4)))  E  	INPUT_READY = .TRUE.  OB  	IF (IOSB(3).EQ.ESC .OR. IOSB(3).EQ.CSI .OR. IOSB(3).EQ.SS3) THEN  I  	    INPUT_FLAG = '.'  =8  	    IF (INPUT_CHAR.EQ.'~') THEN		! VT2xx function keys  		INPUT_FLAG = '~' +  		I = ZEXT(BUFFER(IOSB(4)-2)) - ICHAR('0')A   		IF (I.GE.0 .AND. I.LE.9) THEN;  		    INPUT_CHAR = CHAR(I*10+BUFFER(IOSB(4)-1)-ICHAR('0')),  		ELSEM6  		    INPUT_CHAR = CHAR(BUFFER(IOSB(4)-1)-ICHAR('0'))  		ENDIF  	    ENDIFS  )   	ELSE IF (IOSB(3).LT.'20'X .OR.5  	1		   (IOSB(3).GE.'7F'X.AND.IOSB(3).LE.'A0'X)) THEN*  B  	    INPUT_FLAG = '*'  )  	ELSE  *  	    INPUT_FLAG = ' '  t  	ENDIFN  o"  	IF (HIBERNATING) CALL GO_WAKE_UP  -  	END   	SUBROUTINE GO_HIBERNATEa  t  ** *  *	Subroutines GO_HIBERNATE and GO_WAKE_UP  *  *E  *	Places the calling process into and out of  hibernation.   See thetE  *	VAX/VMS  System  Services Reference Manual,  Chapter 7 (pages 7-10e1  *	through 7-13) for a discussion of hibernation.s  *E  *	Note that after the process has been  placed  in hibernation,  theT   *	only ways it can wake up are:  *>  *		* If the process receives an AST and the AST routine calls>  *		  GO_WAKE_UP (or calls the SYS$WAKE System Service,  which  *		  is equivalent)  *>  *		* If this process called the SYS$SCHDWK System Service be-5  *		  fore it hibernated, to schedule a wake-up call.a  *>  *		* If another process calls SYS$WAKE or SYS$SCHDWK  on  be-  *		  half of this process  *  *	.INDEX PROCESS CONTROL>>	  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	2 Apr 1983	   Dahlgren, Virginia  22448  *  E  	IMPLICIT INTEGER (A-Z)  L  	LOGICAL HIBERNATING      	COMMON /HIBER_/ HIBERNATING   	  	DATA HIBERNATING / .FALSE. /  .  	HIBERNATING = .TRUE.  =  	STATUS = SYS$HIBER()   .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  )  	HIBERNATING = .FALSE.T  =  	RETURN  A  H  ,  	ENTRY GO_WAKE_UP  T  A  	STATUS = SYS$WAKE(,)  N.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  (  	END)%  !	INTEGER FUNCTION SET_SCREEN(WIDTH)L  !  !**(  !*	INTEGER FUNCTION SET_SCREEN( width )  !*S  !*EF  !*	Sets the width of the terminal screen, in characters, to the valueF  !*	of the integer 'width' parameter,  which must be either 132 or 80.F  !*	If  the terminal  is already  at the desired width,  no setting isF  !*	done.   If the width  is changed,  then an exit handler  is set upF  !*	which resets  the terminal  back to  its original width  when thisC  !*	program exits.  If the width is changed, the screen is blanked.(  !*SF  !*	The function result is the previous value of the screen width.  IfF  !*	this value is not needed, SET_SCREEN may be CALLed as a subroutine  !*	rather than a function.s  !*   !*	.INDEX TERMINAL I/O>>r  !* 3  !*	Alan L. Zirkle     Naval Surface Warfare Center   !*			   Code K53Y,  !*	14 Sep 1984	   Dahlgren, Virginia  22448  !*   !  !  !	IMPLICIT INTEGER (A-Z)a  !&  !	PARAMETER ( IO$_SENSEMODE = '27'X )&  !	PARAMETER ( IO$_SETMODE   = '23'X )&  !	PARAMETER ( IO$_WRITEVBLK = '30'X )  !  !	INTEGER*2 CHAN,IOSB(4)24  !	INTEGER*2 CHARACTERISTICS(4),WIDTH,ORIGINAL_WIDTH  !  !	EXTERNAL SET_SCREEN_EXITE  !   !	LOGICAL FIRST_CALL / .TRUE. /  !  !	COMMON /TT_CHAN_TT/ CHANS  !  !	DATA CHAN / 0 /  !  !	IF (CHAN.EQ.0) THEN/  !	    STATUS = SYS$ASSIGN('SYS$OUTPUT',CHAN,,)o3  !	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))e  !	ENDIF  !  !	IF (FIRST_CALL) THENh  !@  !	    STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SENSEMODE),IOSB,,,!  !	1					   CHARACTERISTICS,,,,,)A  !3  !	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))p  !5  !	    IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))t  !*  !	    ORIGINAL_WIDTH = CHARACTERISTICS(2)  !  !	ENDIF  !"  !	SET_SCREEN = CHARACTERISTICS(2)  !*  !	IF (CHARACTERISTICS(2).EQ.WIDTH) RETURN  !  !	CHARACTERISTICS(2) = WIDTHn  !:  !	IF (WIDTH.EQ.132) CALL LIB$PUT_SCREEN(CHAR(27)//'[?3h'):  !	IF (WIDTH.EQ. 80) CALL LIB$PUT_SCREEN(CHAR(27)//'[?3l')  !:  !	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE),IOSB,,,!  !	1					   CHARACTERISTICS,,,,,)   !/  !	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))i  !1  !	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))e  !  !	IF (FIRST_CALL) THEN*  !  !	    FIRST_CALL = .FALSE.F  !@  !	    CALL DECLARE_EXIT_HANDLER(SET_SCREEN_EXIT,ORIGINAL_WIDTH)  !  !	ENDIF  !  !	END	f9  !	SUBROUTINE SET_SCREEN_EXIT(EXIT_STATUS,ORIGINAL_WIDTH)	  !  !**  !*	SUBROUTINE SET_SCREEN_EXIT  !*d  !*tF  !*	This routine is not called by the user.  Routine SET_SCREEN_132 orF  !*	SET_SCREEN_80 may set up this routine as a VMS exit handler to setF  !*	the terminal screen back to its original width when the program is  !*	exited.h  !**  !*i3  !*	Alan L. Zirkle     Naval Surface Warfare Centern  !*			   Code K53 ,  !*	14 Sep 1984	   Dahlgren, Virginia  22448  !*p  !  !  !	IMPLICIT INTEGER (A-Z)U  !'  !	INTEGER*4 EXIT_STATUS,ORIGINAL_WIDTHs  !"  !	CALL SET_SCREEN(ORIGINAL_WIDTH)  !  !	END  	SUBROUTINE SET_KEYPAD_MODE  o  **o4  *	Subroutines SET_KEYPAD_MODE and RESET_KEYPAD_MODE  *  *E  *	Places the VT100 keypad keys  into or  out of  Keypad  Application E  *	Mode.   Normally, the keys are not in application mode; the keypadIE  *	'7' for instance, is the same as the keyboard '7', and the 'Enter' E  *	key is the same as 'Return'.  When in application mode, the keypadZE  *	keys return unique escape sequences, described in the VT100 manual3  *	and reference card.  *@  *	The calling program should reset keypad mode before it exits.  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	2 Apr 1983	   Dahlgren, Virginia  22448  *  I  	IMPLICIT INTEGER (A-Z)  N  	BYTE BUFFER(2) / 27,0 /P  	INTEGER*2 CHAN,IOSB(4)  T  	COMMON /TT_CHAN_TT/ CHAN  O%  	PARAMETER ( IO$_WRITEVBLK = '30'X )E-  	PARAMETER ( FUNCTION      = IO$_WRITEVBLK )B  =  	BUFFER(2) = ICHAR('=')  N  10	IF (CHAN.EQ.0) THENE$  	    STATUS=SYS$ASSIGN('TT',CHAN,,)2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	ENDIF=  $4  	STATUS=SYS$QIOW(,%VAL(CHAN),%VAL(FUNCTION),IOSB,,,  	1					BUFFER,%VAL(2),,,,)   F.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  S0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))  I  	RETURN  T  S     	ENTRY RESET_KEYPAD_MODEF        	BUFFER(2)=ICHAR('>')  $
  	GO TO 10  S  	ENDN  	SUBROUTINE RING_BELL(COUNT))     ***%  *	SUBROUTINE RING_BELL [ ( count ) ]   *  *E  *	Rings the terminal bell.   The argument COUNT tells how many timesME  *	the bell is to be rung.  If  COUNT  is omitted,  the bell  is rungT.  *	once.  Count should not be greater than 16.  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	3 Nov 1983	   Dahlgren, Virginia  22448  *  d  	IMPLICIT INTEGER (A-Z)  e  	BYTE BUFFER(16) / 16*7 /  	INTEGER*2 CHAN,IOSB(4)  s  	COMMON /TT_CHAN_TT/ CHAN   %  	PARAMETER ( IO$_WRITEVBLK = '30'X )n-  	PARAMETER ( FUNCTION      = IO$_WRITEVBLK )l  e  	IF (CHAN.EQ.0) THENN$  	    STATUS=SYS$ASSIGN('TT',CHAN,,)2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	ENDIFc  a *2Dc#  	LEN = MIN( DEFAULT_ARG(1,1) , 16)M *2Ea *2In3  	LEN = MIN( DEFAULT_ARG(%VAL(IARGPTR()),1,1) , 16)e *2E   	4  	STATUS=SYS$QIOW(,%VAL(CHAN),%VAL(FUNCTION),IOSB,,,  	1					BUFFER,%VAL(LEN),,,,)T  R.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  P0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))     	END   	SUBROUTINE PROMPTH5  	1		(PROMPT_STRING,RESPONSE,RESPONSE_LENGTH,OPTIONS))  3  ***/  *	SUBROUTINE PROMPT ( prompt_string , responseH  *1  *+				       [, response_length ] [, options ] )T  *  *E  *	Displays  a prompt message on the terminal,  then reads the user'sO  *	response.  *E  *	The prompt message is preceded by a blank line, and is accompaniedBE  *	by two rings of the bell.  A colon and one blank character are ap-S$  *	pended to the end of the message.  *E  *	The response is read from the file SYS$COMMAND, so from  within  aIE  *	command procedure, this will still obtain an interactive response.D  *E  *	The prompt message is specified as the character  string  argumentAE  *	PROMPT_STRING.   The response  is returned in the character string=E  *	argument  RESPONSE.    If  the  optional  third  integer  argument	E  *	RESPONSE_LENGTH is present, the length of the entered response  is,  *	returned there.  *E  *	The string RESPONSE must be longer than any expected response;  if(E  *	the string fills up, then the operation completes before  the userNE  *	enters a Carriage Return.  The maximum response is 256 characters.   *E  *	The optional third integer arguement OPTIONS  allows the caller to E  *	change the presentation of the  prompt message and the entered re-LE  *	response.  Each bit in OPTIONS activates one function when set (by %  *	default, none are considered set):n  *5  *		1 -- Do not output a blank line before the prompt)&  *		2 -- Do not ring the terminal bell8  *		4 -- Do not put the colon and blank after the prompt:  *		8 -- Output a blank line after the response is entered?  *	       16 -- Display the response in VT100 'bold' attributesi&  *	       32 -- Uppercase the response(  *	       64 -- Do not echo the response  *  *	IMPORTANT WARNING:t  *	------------------aE  *	If option 16 is used,  ALL attributes are turned off after the re-dE  *	sponse is entered.  Also, incoming broadcast messages will displaylE  *	as bold if they arrive while waiting for response,  and CTRL\Y andfE  *	AST events may leave the screen in BOLD;  the likelihood of screenn  *	damage must be considered.I  *  *	.INDEX TERMINAL I/O>>  *- @  *	 13 Jan 87	Add OPTIONS parameter,  routine PROMPT_CANCEL, use  *			of LIB$GET_EF.D@  *	 12 May 87	If just CTRL\Z is entered,  return ASCII 26 as the
  *			response	$  *	 20 Jun 88	Add options 32 and 64./  *	 18 Mar 91	Limit response to 256 characters.T  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	13 Dec 1983	   Dahlgren, Virginia  22448S  *  H  	IMPLICIT NONEO  1  	INCLUDE '($IODEF)'  A&  	CHARACTER*(*) PROMPT_STRING,RESPONSE#  	INTEGER*4 RESPONSE_LENGTH,OPTIONSI  U  	CHARACTER*1 CR,LF,BEL,ESC)     	PARAMETER ( CR  = CHAR(13) )  	PARAMETER ( LF  = CHAR(10) )  	PARAMETER ( BEL = CHAR( 7) )  	PARAMETER ( ESC = CHAR(27) )  R  	CHARACTER*5 PREFIX  	CHARACTER*6 SUFFIX  	LOGICAL ARG_EXIST( *2I_  	INTEGER*4 IARGPTRV *2Ef  	INTEGER*2 CHAN,IOSB(4):  	INTEGER*4 FUNCTION,STATUS,SYS$ASSIGN,SYS$QIOW,SYS$CANCEL.  	INTEGER*4 OPTIONS_,P1,P2,S1,S2,STATUS2,L1,L2  H  	EXTERNAL SS$_ABORT  -  	DATA CHAN / 0 /S     	OPTIONS_ = 0    *2DB&  	IF (ARG_EXIST(4)) OPTIONS_ = OPTIONS *2E  *2IS6  	IF (ARG_EXIST(%VAL(IARGPTR()),4)) OPTIONS_ = OPTIONS *2E7  .  	IF (CHAN.EQ.0) THENT  *+  	    PREFIX = LF // LF // CR // BEL // BEL    /  	    STATUS = SYS$ASSIGN('SYS$COMMAND',CHAN,,)N  N2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  T  	ENDIF*     	P1 = 1  	P2 = 5  N  	FUNCTION = IO$_READPROMPT*  	SUFFIX = ': 'n  	S2 = 2  o$  	IF (IAND(OPTIONS_, 1).NE.0) P1 = 2$  	IF (IAND(OPTIONS_, 2).NE.0) P2 = 3$  	IF (IAND(OPTIONS_, 4).NE.0) S2 = 0"  	IF (IAND(OPTIONS_,16).NE.0) THEN&  	    SUFFIX(S2+1:S2+4) = ESC // '[1m'  	    S2 = S2 + 4a  	ENDIFi?  	IF (IAND(OPTIONS_,32).NE.0) FUNCTION = FUNCTION + IO$M_CVTLOWt?  	IF (IAND(OPTIONS_,64).NE.0) FUNCTION = FUNCTION + IO$M_NOECHOK  P!  	L1 = MIN( 256 , LEN(RESPONSE) )i/  	L2 = LEN(PROMPT_STRING) + (P2 - P1 + 1) + S2 i  r6  	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(FUNCTION),IOSB,,,  	1	%REF(RESPONSE),%VAL(L1),,,:  	2	     %REF(PREFIX(P1:P2)//PROMPT_STRING//SUFFIX(1:S2)),  	3						       %VAL(L2))	  a.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	  	IF (.NOT.IOSB(1)) THENB  	    IF (IOSB(1).NE.%LOC(SS$_ABORT)) CALL LIB$STOP(%VAL(IOSB(1)))  	ENDIFV  iA  	IF (IOSB(2).EQ.0 .AND.IOSB(3).EQ.26) THEN	! Return EOF (CTRL\Z)T#  	    IOSB(2) = 1					!  indicationN  	    RESPONSE(1:1) = CHAR(26)  	ENDIF.  	:  	IF (IOSB(2).LT.LEN(RESPONSE)) RESPONSE(IOSB(2)+1:) = ' '  T *2DU-  	IF (ARG_EXIST(3)) RESPONSE_LENGTH = IOSB(2)N *2EF *2IT=  	IF (ARG_EXIST(%VAL(IARGPTR()),3)) RESPONSE_LENGTH = IOSB(2)S *2ES  K&  	IF (IAND(OPTIONS_,8+16).EQ.0) RETURN  %  	SUFFIX = LF // ESC // '[m'  	S1 = 1  	S2 = 4  	$  	IF (IAND(OPTIONS_, 8).EQ.0) S1 = 2$  	IF (IAND(OPTIONS_,16).EQ.0) S2 = 1  	;  	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_WRITEVBLK),IOSB,,,v.  	1			  %REF(SUFFIX(S1:S2)),%VAL(S2-S1+1),,,,)  m.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  a0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))  e  	RETURN  d     c  	ENTRY PROMPT_CANCELa  e  **   *	SUBROUTINE PROMPT_CANCEL   *  *E  *	Causes a program which is waiting for user input because of a calldE  *	to routine PROMPT, PROMPT_YES, or PROMPT_INT to continue as if thesE  *	user had entered a carriage  return.   Any text (if any) which hasd4  *	already been typed in is considered the response.  *E  *	PROMPT_CANCEL must be called from an AST routine.  Its use must beiE  *	carefully considered, since many programs (and definitely routines1E  *	PROMPT_YES and PROMPT_INT) may loop when a null string is entered.Z  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	13 Jan 1987	   Dahlgren, Virginia  22448,  *  2  	IF (CHAN.EQ.0) RETURNS  S"  	STATUS2 = SYS$CANCEL(%VAL(CHAN))  A0  	IF (.NOT.STATUS2) CALL LIB$STOP(%VAL(STATUS2))  .  	END 4  	LOGICAL FUNCTION PROMPT_YES(PROMPT_STRING,DEFAULT)     ** >  *	LOGICAL FUNCTION PROMPT_YES ( prompt_string [ , default ] )  *  *E  *	Displays a prompt message (the string PROMPT_STRING) on the  term-FE  *	inal,  then reads the user's response.   The message is assumed toS4  *	be a question which can be answered by YES or NO.  *E  *	If the response was positive,  a  .TRUE.  functional result is re-.,  *	turned; otherwise the result is .FALSE. .  *E  *	The first character of the response must be 'Y' or 'N' (either up- C  *	per case or lower case); if it is not, the question is repeated.!  *E  *	If the optional  DEFAULT  parameter is present,  it must be eitherEE  *	'Y' or 'N' (upper case only); if the user makes a  null  or  blank/-  *	entry, this value is used as his response.%  *E  *	The question is preceded by a blank line, and  is  accompanied  byOE  *	two rings of the bell. The question is followed, on the same line,I  *	by:  *  *	  *  A question markR  *:  *	  *  The string ' (Y/N)', showing the allowable entries  *E  *	  *  (If DEFAULT is present,  one of the strings ' [Y]' or ' [N]',!"  *						      showing the default)  *	  *  A colon and one blank   *E  *	The response is read from the file  SYS$COMMAND,  so from within aoE  *	command procedure, this will still obtain an interactive response.   *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	22 Dec 1983	   Dahlgren, Virginia  22448!  *  L  	IMPLICIT INTEGER (A-Z)  r  	CHARACTER*(*) PROMPT_STRING   !  	BYTE DEFAULT  h$  	CHARACTER*11 ADD / '? (Y/N) [N]' /  I  	CHARACTER RESPONSE*8,R*1  I  	EQUIVALENCE (RESPONSE,R)  I  	LOGICAL ARG_EXIST,DEF,NULO *2IA  	INTEGER*4 IARGPTR  *2ER  I *2DT  	DEF = ARG_EXIST(2) *2ES *2It$  	DEF = ARG_EXIST(%VAL(IARGPTR()),2) *2E      	IF (DEF) THEN   0  	    LADD = 11t  r  	    IF (DEFAULT.EQ.1HY) THEN  M  		ADD(10:10) = 'Y'k   
  	    ELSE  i  		ADD(10:10) = 'N'a     	    ENDIFs  c  	ELSE  a  	    LADD = 7  '  	ENDIFh  E@  10	CALL PROMPT( PROMPT_STRING // ADD(:LADD) , RESPONSE , LRES )  e2  	NUL = LRES .EQ. 0 .OR. RESPONSE(1:LRES) .EQ. ' '  i  	IF (NUL) THENm  a  	    IF (.NOT.DEF) GO TO 10  *#  	    PROMPT_YES = DEFAULT .EQ. 1HYp  m  	ELSE  i&  	    IF (R.EQ.'Y' .OR. R.EQ.'y') THEN     		PROMPT_YES = .TRUE.   +  	    ELSE IF (R.EQ.'N' .OR. R.eq.'n') THEN2  r  		PROMPT_YES = .FALSE.i  2
  	    ELSE  	  		GO TO 10G  (  	    ENDIFY  B  	ENDIF/  ,  	END	<  	INTEGER FUNCTION PROMPT_INT(PROMPT_STRING,DEFAULT,OPTIONS)  A  ** :  *	INTEGER FUNCTION PROMPT_INT( prompt_string [, default ]  *  *+							     [, options ])  *  *E  *	Displays a prompt message (the string PROMPT_STRING) on the  term- E  *	inal, then reads the user's response.   The response is assumed toT  *	be an integer value.V  *:  *	The response may be in either of the following formats:  *  *		i	%i	%Di	%Oj	%Xk  *E  *	where 'i' is one or more decimal digits,  'j' is one or more octalEE  *	digits, and 'k' is one or more hexadecimal digits. If the response(<  *	is not in one of these formats, the question is repeated.  *E  *	The  INTEGER*4  converted value of the response is returned as thet  *	functional result.u  *E  *	If the response is null or blank, then the action taken depends on ;  *	whether the optional INTEGER*4 argument DEFAULT is used:r  *E  *	    If DEFAULT is used, then its value is returned as the functiona  *	    result.  *=  *	    If DEFAULT is not used, then the question is repeated.4  *E  *	The prompt string is preceded by a blank line, and is  accompaniedEE  *	by two rings  of the bell.   The question is followed by a  colon.OE  *	These attributes can be changed by using the optional OPTIONS arg- @  *	ument; see routine PROMPT for a description of this argument.  *E  *	The response is read from the file  SYS$COMMAND,  so from within aEE  *	command procedure, this will still obtain an interactive response.%  *	A  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	15 Apr 1984	   Dahlgren, Virginia  22448   *  P  	IMPLICIT INTEGER (A-Z)  T  	CHARACTER*(*) PROMPT_STRINGS  )  	CHARACTER*32 RAW_VALUE  	CHARACTER*1  RADIX  S  	LOGICAL ARG_EXISTS *2IG  	INTEGER*4 IARGPTR* *2ES  O  	OPTIONS_ = 0 *2D_&  	IF (ARG_EXIST(3)) OPTIONS_ = OPTIONS *2Eo *2Ie6  	IF (ARG_EXIST(%VAL(IARGPTR()),3)) OPTIONS_ = OPTIONS *2E   t6  10	CALL PROMPT(PROMPT_STRING,RAW_VALUE,VLEN,OPTIONS_)  T1  	IF (VLEN.EQ.0.OR.RAW_VALUE(1:VLEN).EQ.' ') THENi  c *2Dn  	    IF (ARG_EXIST(2)) THEN *2E  *2Io,  	    IF (ARG_EXIST(%VAL(IARGPTR()),2)) THEN *2Ee  		PROMPT_INT = DEFAULT 	  		RETURNo
  	    ELSE  		GO TO 10   	    ENDIFs  r&  	ELSE IF (RAW_VALUE(1:1).EQ.'%') THEN  w+  	    CALL STR$UPCASE(RADIX,RAW_VALUE(2:2))*  *  	    IF (RADIX.EQ.'D') THEN1  		STATUS = OTS$CVT_TI_L(RAW_VALUE(3:VLEN),VALUE)T!  	    ELSE IF (RADIX.EQ.'X') THENn1  		STATUS = OTS$CVT_TZ_L(RAW_VALUE(3:VLEN),VALUE)f!  	    ELSE IF (RADIX.EQ.'O') THENg1  		STATUS = OTS$CVT_TO_L(RAW_VALUE(3:VLEN),VALUE)f
  	    ELSE1  		STATUS = OTS$CVT_TI_L(RAW_VALUE(2:VLEN),VALUE)n  	    ENDIFs  e  	ELSE  n4  	    STATUS = OTS$CVT_TI_L(RAW_VALUE(1:VLEN),VALUE)  n  	ENDIFa  n  	IF (.NOT.STATUS) GO TO 10   e  	PROMPT_INT = VALUE     	ENDi'  	SUBROUTINE SMGL_GET_TERMINAL_SETTINGST  o  **a(  *	SUBROUTINE SMGL_GET_TERMINAL_SETTINGS  *  *E  *	Gets the current settings  of the terminal characteristics for theeE  *	device SYS$OUTPUT. This routine is used by other library routines,e>  *	so direct calls by the user should obey the following rule:  *E  *	This routine should only be called once.  It should only be calledaE  *	if CHARBUF.DEVICE_CLASS is zero; if it is not zero, it has already E  *	been called.  Structure  CHARBUF  contains the current settings ofiE  *	the terminal characteristics, and structure  CHARBUF_DEFAULT  con-sE  *	tains the initial settings when this image started.  The structureA*  *	CHARBUF_DEFAULT should NOT be modified!  *6  *	The definitions of CHARBUF and CHARBUF_DEFAULT are:  *  *		STRUCTURE /CHARBUF/A(  *		  BYTE DEVICE_CLASS	/ 0 /	! DC$_TERM.  *		  BYTE DEVICE_TYPE	/ 0 /	! DT$_VT100, etc.-  *		  INTEGER*2 PAGE_WIDTH  / 0 /	! 80 or 132   *		  unione  *		    mapt7  *		      INTEGER*4 BASIC_CHAR	! First 3 bytes ($TTDEF)   *		    end mapM  *		    map*  *		      BYTE %FILL (3)(  *		      BYTE PAGE_LENGTH		! Usually 24  *		    end map_  *		  end union8%  *		  INTEGER*4 EXT_CHAR		! ($TT2DEF)C  *		END STRUCTUREr  *,  *		RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULT  *.  *		COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT  *E  *	See "VAX/VMS I/O User's Reference Manual:  Part I" (for VMS V4.0),   *	Figure 8-8, on page 8-38.  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	19 May 1985	   Dahlgren, Virginia  22448	  *  E  	IMPLICIT INTEGER (A-Z)  A'  	PARAMETER ( IO$_SENSEMODE =   '27'X )F     	LOGICAL*1 HANDLER_ON  	INTEGER*2 CHAN,IOSB(4)  E  	STRUCTURE /CHARBUF/R'  	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERMF-  	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc.G,  	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132	  	  unionN	  	    map$9  	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF)2
  	    end map 	  	    mapN  	      BYTE %FILL (3)'  	      BYTE PAGE_LENGTH			! Usually 24B
  	    end mapS
  	  end union=$  	  INTEGER*4 EXT_CHAR			! ($TT2DEF)  	END STRUCTURE)  P*  	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULT  EA  	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ONT  =  	IF (CHAN.EQ.0) THEND  H.  	    STATUS = SYS$ASSIGN('SYS$OUTPUT',CHAN,,)  A2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	  	ENDIF=  $4  	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SENSEMODE),'  	1				    IOSB,,,CHARBUF,%VAL(12),,,,)O  O.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))   0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))  F  	CHARBUF_DEFAULT = CHARBUF      	ENDS%  	SUBROUTINE SMGL_SET_TERMINAL(DUMMY)2  E  **U  *	SUBROUTINE SMGL_SET_TERMINAL   *  *E  *	This routine  should not be called  by the user.   It is called byNE  *	other  library routines to modify specific characteristics  of the28  *	terminal associated with the logical name SYS$OUTPUT.  *+  *	The procedure for using this routine is:E  *E  *	  1.  If CHARBUF.DEVICE_CLASS is zero  (for a definition of struc- E  *	      ture CHARBUF,  see routine SMGL_GET_TERMINAL_SETTINGS), call(E  *	      SMGL_GET_TERMINAL_SETTINGS to get the  terminal default set-(  *	      tings.i  *=  *	  2.  Modify the relevant fields in the CHARBUF structure.T  *  *	  3.  Call this routine.t  *E  *	Any characteristics set by using  this routine will be set back toS.  *	their original values when the image exits.  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	19 May 1985	   Dahlgren, Virginia  22448S  *  .  	IMPLICIT INTEGER (A-Z)  L%  	PARAMETER ( IO$_SETMODE =   '23'X )	  	  	LOGICAL*1 HANDLER_ON  	INTEGER*2 CHAN,IOSB(4)  S  	STRUCTURE /CHARBUF/ '  	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERMW-  	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc.,,  	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132	  	  union%	  	    map)9  	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF) 
  	    end map 	  	    mapR  	      BYTE %FILL (3)'  	      BYTE PAGE_LENGTH			! Usually 24 
  	    end mapg
  	  end unioni$  	  INTEGER*4 EXT_CHAR			! ($TT2DEF)  	END STRUCTURER  T*  	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULT  hA  	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ONc  a  	LOGICAL ARG_EXISTy *2In  	INTEGER*4 IARGPTRs *2E.  * *2DP1  	IF (ARG_EXIST(1)) THEN		! Called at image exit.t *2E  *2IbA  	IF (ARG_EXIST(%VAL(IARGPTR()),1)) THEN		! Called at image exit.u *2E1  *;  	    IF (CHARBUF.PAGE_WIDTH.NE.CHARBUF_DEFAULT.PAGE_WIDTH)tB  	1      CALL SMGL_SET_TERMINAL_WIDTH(CHARBUF_DEFAULT.PAGE_WIDTH,)  u  	    CHARBUF = CHARBUF_DEFAULTe  3  	ENDIFa  92  	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE),'  	1				    IOSB,,,CHARBUF,%VAL(12),,,,)L  A.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  L0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))  (4  	IF (.NOT.HANDLER_ON) CALL SMGL_ENABLE_EXIT_HANDLER  M  	END(%  	SUBROUTINE SMGL_ENABLE_EXIT_HANDLER   D  **y&  *	SUBROUTINE SMGL_ENABLE_EXIT_HANDLER  *  *E  *	This routine is normally not called by the user.   It is called bysE  *	SMGL_SET_TERMINAL  to declare an exit handler,  which will set any E  *	changed characteristics back to the original settings when the im- E  *	age exits.  The original settings are assumed to be in the CHARBUFr.  *	structure (see SMGL_GET_TERMINAL_SETTINGS).  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	19 May 1985	   Dahlgren, Virginia  22448*  *     	IMPLICIT INTEGER (A-Z)   "  	LOGICAL*1 HANDLER_ON / .FALSE. /  	INTEGER*2 CHAN,IOSB(4)  i  	STRUCTURE /CHARBUF/e'  	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERMd-  	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc.l,  	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132	  	  union*	  	    map 9  	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF)e
  	    end mapi	  	    map   	      BYTE %FILL (3)'  	      BYTE PAGE_LENGTH			! Usually 24!
  	    end map 
  	  end uniona$  	  INTEGER*4 EXT_CHAR			! ($TT2DEF)  	END STRUCTUREs  s*  	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULT  iA  	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ONe  n  	EXTERNAL SMGL_SET_TERMINAL  >  	HANDLER_ON = .TRUE.    .  	CALL DECLARE_EXIT_HANDLER(SMGL_SET_TERMINAL)  2  	END9&  	SUBROUTINE SMGL_DISABLE_LINE_EDITING  	  **C'  *	SUBROUTINE SMGL_DISABLE_LINE_EDITINGM  *  *E  *	Turns off the  'Line Editing'  terminal feature for the SYS$OUTPUT	E  *	device  so the application  has more control  over the  terminal's   *	function keys.  2  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	19 May 1985	   Dahlgren, Virginia  22448   *  =  	IMPLICIT INTEGER (A-Z)  Q'  	PARAMETER ( TT2$M_EDITING = '1000'X )      	LOGICAL*1 HANDLER_ON  	INTEGER*2 CHAN,IOSB(4)  c  	STRUCTURE /CHARBUF/D'  	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERMP-  	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc. ,  	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132	  	  unioni	  	    map)9  	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF)Y
  	    end mapQ	  	    map   	      BYTE %FILL (3)'  	      BYTE PAGE_LENGTH			! Usually 24_
  	    end map 
  	  end union $  	  INTEGER*4 EXT_CHAR			! ($TT2DEF)  	END STRUCTUREL  i*  	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULT  NA  	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ONT  R@  	IF (CHARBUF.DEVICE_CLASS.EQ.0) CALL SMGL_GET_TERMINAL_SETTINGS  t>  	CHARBUF.EXT_CHAR = IAND(CHARBUF.EXT_CHAR,NOT(TT2$M_EDITING))  D  	CALL SMGL_SET_TERMINAL     	ENDP7  	INTEGER FUNCTION SMGL_SET_TERMINAL_WIDTH(WIDTH,DUMMY)r  r  **s4  *	INTEGER FUNCTION SMGL_SET_TERMINAL_WIDTH( width )  *  *E  *	Sets the width of the terminal screen, in characters, to the value	E  *	of the integer 'width' parameter,  which must be either 132 or 80. E  *	If  the terminal  is already  at the desired width,  no setting issE  *	done.   If the width  is changed,  then an exit handler  is set uprE  *	which resets  the terminal  back to  its original width  when thisuB  *	program exits.  If the width is changed, the screen is blanked.  *E  *	The function result is the previous value of the screen width.  IfEE  *	this value is not needed, SMGL_SET_TERMINAL_WIDTH may be CALLed as '  *	a subroutine rather than a function.   *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	19 May 1985	   Dahlgren, Virginia  22448e  *  b  	IMPLICIT INTEGER (A-Z)  h  	INTEGER*2 WIDTHw  b%  	PARAMETER ( IO$_WRITEVBLK = '30'X )e  a  	LOGICAL*1 HANDLER_ON  	INTEGER*2 CHAN,IOSB(4)  e  	STRUCTURE /CHARBUF/d'  	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERMr-  	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc. ,  	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132	  	  uniona	  	    mapa9  	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF)a
  	    end map 	  	    mapc  	      BYTE %FILL (3)'  	      BYTE PAGE_LENGTH			! Usually 24i
  	    end map 
  	  end unionC$  	  INTEGER*4 EXT_CHAR			! ($TT2DEF)  	END STRUCTURE)  	*  	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULT  SA  	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ONI  _  	CHARACTER*5 BUFFER  	LOGICAL ARG_EXISTO *2IS  	INTEGER*4 IARGPTRR *2ES  V@  	IF (CHARBUF.DEVICE_CLASS.EQ.0) CALL SMGL_GET_TERMINAL_SETTINGS  T.  	SMGL_SET_TERMINAL_WIDTH = CHARBUF.PAGE_WIDTH  .)  	IF (CHARBUF.PAGE_WIDTH.EQ.WIDTH) RETURN2     	CHARBUF.PAGE_WIDTH = WIDTH     	IF (WIDTH.EQ.132) THEN!  	    BUFFER = CHAR(27) // '[?3h'	  	ELSE!  	    BUFFER = CHAR(27) // '[?3l'L  	ENDIF   1;  	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_WRITEVBLK),IOSB,,, '  	1				       %REF(BUFFER),%VAL(5),,,,)(  ).  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  T0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))  R@  *	Don't bother setting characteristics if called at image exit.  f *2D /  	IF (.NOT.ARG_EXIST(2)) CALL SMGL_SET_TERMINALV *2EL *2IV?  	IF (.NOT.ARG_EXIST(%VAL(IARGPTR()),2)) CALL SMGL_SET_TERMINALL *2EV  )  	ENDn;  	SUBROUTINE SMGL_CREATE_TERMINATOR_BITS(STRING,TERMSTRING)A  A  **:@  *	SUBROUTINE SMGL_CREATE_TERMINATOR_BITS( string , termstring )  *  *E  *	Creates a Terminator Mask for specifying a non-standard terminator E  *	set for terminal read QIOs and calls to the SMG$READ_STRING screenr  *	management routine.  *E  *	Standard VMS read terminators are all ASCII characters with a codebE  *	in the range 0 through 31 (decimal) except LF, VT, FF, TAB and BS.tE  *	The mask which this routine  creates contains these characters, in E  *	addition to all characters in character string argument TERMSTRINGt  *	which may have any length.   *E  *	The mask is created in character string argument STRING,  which isiE  *	is assumed to be 16 characters long.   The mask created is a 'longeE  *	form' mask,  which should be passed to QIO or  SMG$READ_STRING  byD  *	descriptor.  *E  *	See the "VAX/VMS I/O User's Reference Manual:  Part I", Figure 8-4 @  *	and Section 8.4.1.2 for more information on terminator masks.  *)  *	Example:  Make '?' and '!' terminators   *  *	    CHARACTER*16 STRING4  *	    CALL SMGL_CREATE_TERMINATOR_BITS(STRING,'?!')B  *	    STATUS = SMG$READ_STRING(kb,te,pr,ml,mo,ti,STRING,le,tc,di)A  *	    STATUS = SYS$QIOW(ef,ch,fu,io,aa,ap,p1,p2,p3,STRING,p5,p6)G  *  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	19 May 1985	   Dahlgren, Virginia  22448A  *  F  	IMPLICIT INTEGER (A-Z)  A  	CHARACTER*16 STRINGU  	CHARACTER*(*) TERMSTRING  	1  	CALL LIB$MOVC5(4,'FFFFE0FF'X,0,16,%REF(STRING))F  r  	DO I=1,LEN(TERMSTRING)<  	    CALL LIB$INSV(1,ICHAR(TERMSTRING(I:I)),1,%REF(STRING))  	ENDDOr  e  	END*!  	SUBROUTINE SCREEN(STRING,VALUE)a  r  **i6  *	SUBROUTINE SCREEN( string [ ,value1 ,value2,... ] )  *  *E  *	Writes a string  to the terminal screen,  performing the following   *	translations on the string:  *E  *	    *  Everywhere an upside-down question mark appears,  it is re-0E  *	       placed with an ESCAPE character.  (The upside-down question	E  *	       mark is created on  VTxxx  terminals with U.S. keyboards by($  *	       entering " COMPOSE ? ? ").  *E  *	    *  Everywhere a cent sign appears, it is replaced by the value E  *	       of the corresponding VALUEn integer argument (which must beTE  *	       less than  10000),  converted to ASCII.   (The cent sign isLE  *	       created on VTxxx terminals  with U.S. keyboards by entering.E  *	       " COMPOSE C / ").   The VALUEn  arguments do not need to be E  *	       present unless this feature is used; if the feature IS usedSE  *	       and there are fewer VALUEn arguments than cent signs,  this,5  *	       routine will abort with status SS$_INSFARG.A  *E  *	These translations allow you to send screen formatting commands toRC  *	a VTxxx terminal relatively simply.  For example, the statement:M  *1  *		    CALL SCREEN( '[;H[1mHi[m' , 5 , 20 )*  *@  *	writes 'Hi' in bold video on line 5, column 20 of the screen.  *E  *	By default,  each call to routine SCREEN writes  one record to the E  *	file SYS$OUTPUT using an RMS $PUT, with no carriage control on theoE  *	record.  You can have SCREEN use another file name, or use CR car-SE  *	cariage control, by calling routine SCREEN_FILE first;  see it fortE  *	details.   SCREEN_FILE can also be used  to close the file and re-I%  *	initialize SCREEN to its defaults.   *E  *	You can have SCREEN enter "buffering" mode, where instead of doingrE  *	a write for each call, it stores the text in a buffer until eithersE  *	the buffer is full or the calling program determines that a screensE  *	update should take place; see routines SCREEN_START and SCREEN_ENDrE  *	for more information.   This mode must not be used when writing to 
  *	a file.  *  *	.INDEX TERMINAL I/O>>  *$  *	 10 Jul 91	Allow VALUEs above 99.)  *	 11 Jul 91	Implement "buffering" mode.D  *	 19 Sep 91	Add SCREEN_PUT.)!  *	 19 Oct 92	Add SCREEN_REPAINT.Y.  *	 27 Oct 92	Allow multiple VALUEn arguments.@  *	 16 Dec 92	In buffering mode, limit size of I/O to 1996 bytes/  *			 to meet limit of SYSGEN parameter MAXBUF.N  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	28 Jun 1987	   Dahlgren, Virginia  22448G  *  U  	IMPLICIT NONE    &  	CHARACTER*(*) STRING,FILENAME,BUFFER  	INTEGER*4 VALUE,CR_FILET  T  	INCLUDE '($FABDEF)/LIST'  	INCLUDE '($RABDEF)/LIST'  	  	RECORD /FABDEF/ FABB  	RECORD /RABDEF/ RAB,  B+  	CHARACTER*256 OUTSTRING / 'SYS$OUTPUT:' /   	CHARACTER*4 WORK0  	INTEGER*4 OSL / 11 /,ARG_LONGWORD,ARGNO,VALUE_A  	INTEGER*4 COL,I,STATUS,SYS$CREATE,SYS$CONNECT,SYS$PUT,SYS$CLOSE   	LOGICAL FIRST_CALL / .TRUE. /2A  	LOGICAL CRFILE / .FALSE. /	! If false, use NONE carriage returnt  	LOGICAL BUSY / .FALSE. /1  	LOGICAL QUOTE			! If true, don't process  or  9  	VOLATILE BUSY			! BUSY Prevents problems with AST usageS  	LOGICAL ARG_EXISTL *2IS  	INTEGER*4 IARGPTRI *2E,  	EXTERNAL SS$_INSFARG   7  	INTEGER*4 BUFADD /0/, PREV_BUFADD /0/, BUFSIZ, BUFLEN(I  	INTEGER*4 maxbuf /1996/	! Maximum size of terminal I/O, enforced by VMS   L  	QUOTE = .FALSE.R  M  1	IF (BUSY) RETURNE  	BUSY = .TRUE._  D  	IF (FIRST_CALL) THEN  N  	    FAB.FAB$B_BID = FAB$C_BID*  	    FAB.FAB$B_BLN = FAB$C_BLN   l%  	    FAB.FAB$L_FNA = %LOC(OUTSTRING)S  	    FAB.FAB$B_FNS = OSLe  	    FAB.FAB$B_FAC = FAB$M_PUT   	    FAB.FAB$L_FOP = FAB$M_SQOb  	    FAB.FAB$B_RFM = FAB$C_VAR    *  	    IF (CRFILE) FAB.FAB$B_RAT = FAB$M_CR  a  	    STATUS = SYS$CREATE(FAB)5  	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	N     	    RAB.RAB$B_BID = RAB$C_BIDr  	    RAB.RAB$B_BLN = RAB$C_BLNt     	    RAB.RAB$L_FAB = %LOC(FAB)   a  	    STATUS = SYS$CONNECT(RAB) 5  	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	.  S  	    FIRST_CALL = .FALSE.     	ENDIFU  R  	OSL = LEN(STRING)E  	OUTSTRING(1:OSL) = STRINGR     	IF (QUOTE) GO TO 300  	%  10	COL = INDEX(OUTSTRING(1:OSL),'')W  H  	IF (COL.NE.0) THEN#  	    OUTSTRING(COL:COL) = CHAR(27)E  	    GO TO 10  	ENDIFy  b  	ARGNO = 1e  	%  20	COL = INDEX(OUTSTRING(1:OSL),'')%  L  	IF (COL.NE.0) THEN  E  	    ARGNO = ARGNO + 1   n *2D ;  	    IF (.NOT.ARG_EXIST(ARGNO)) CALL LIB$STOP(SS$_INSFARG)  *2ET *2I K  	    IF (.NOT.ARG_EXIST(%VAL(IARGPTR()),ARGNO)) CALL LIB$STOP(SS$_INSFARG)B *2EA  F *2DU"  	    VALUE_ = ARG_LONGWORD(ARGNO) *2ES *2IE4  	    VALUE_ = ARG_LONGWORD(%VAL(IARGPTR()),ARGNO,0) *2EE  _  	    IF (VALUE_.LT.10) THEN1  		OUTSTRING(COL:COL) = CHAR(VALUE_ + ICHAR('0'))	"  	    ELSE IF (VALUE_.LT.100) THEN9  		OUTSTRING(COL:OSL+1) = CHAR(VALUE_/10 + ICHAR('0')) //m-  	1			   CHAR(MOD(VALUE_,10) + ICHAR('0')) //    	2					    OUTSTRING(COL+1:OSL)  		OSL = OSL + 1
  	    ELSE*  		CALL SYS$FAO('!UL',I,WORK,%VAL(VALUE_));  		OUTSTRING(COL:OSL+I-1) = WORK(1:I)//OUTSTRING(COL+1:OSL)	  		OSL = OSL + I - 1  	    ENDIFl  n  	    GO TO 20     	ENDIF	  L  30	IF (BUFADD.EQ.0) THENA  E%  	    RAB.RAB$L_RBF = %LOC(OUTSTRING)	  	    RAB.RAB$W_RSZ = OSLE  *  	    STATUS = SYS$PUT(RAB)R5  	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	      	ELSE  _$  	    IF (BUFLEN+OSL.GT.BUFSIZ) THEN  		RAB.RAB$L_RBF = BUFADD!
  		I = BUFLEN   		DO WHILE (I.GT.0)$  		    RAB.RAB$W_RSZ = MIN(I,maxbuf)  		    STATUS = SYS$PUT(RAB)6  		      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	  		    I = I - maxbuf2-  		    RAB.RAB$L_RBF = RAB.RAB$L_RBF + maxbuf*  		ENDDO
  		BUFLEN = 0   	    ENDIFR   =  	    CALL LIB$MOVC3(OSL,%REF(OUTSTRING),%VAL(BUFADD+BUFLEN))M  C  	    BUFLEN = BUFLEN + OSLC  ,  	ENDIFL  O  	BUSY = .FALSE.  	RETURN  A  E  )%  	ENTRY SCREEN_FILE(FILENAME,CR_FILE)	  R  **X2  *	SUBROUTINE SCREEN_FILE( filename [ ,cr_file ] )  *  *E  *	Causes routine SCREEN to  write to a file  other than its default,WE  *	which is SYS$OUTPUT.  Argument FILENAME must be a character stringTE  *	containing the desired file name; if the name is blank SCREEN willtE  *	use its default.   If SCREEN_FILE is called after SCREEN has open- ;  *	ed its file, the file it currently is using is closed.  e  *E  *	If the optional argument CR_FILE is supplied and is .TRUE., SCREEN E  *	will use RMS "CR" carriage control attributes for the file; other-rC  *	wise it will write records with no carriage control information.   *E  *	SCREEN_FILE does not actually open any file; the file is opened on '  *	the first subsequent call to SCREEN.n  *	e  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	28 Jun 1987	   Dahlgren, Virginia  22448   *  u  	IF (.NOT.FIRST_CALL) THEN   e  	    STATUS = SYS$CLOSE(FAB)n4  	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	  	    FIRST_CALL = .TRUE.A  E  	ENDIF	  T  	IF (FILENAME.NE.' ') THENA     	    OSL = LEN(FILENAME)N!  	    OUTSTRING(1:OSL) = FILENAMEd  	  	ELSE  C  	    OSL = 11&  	    OUTSTRING(1:OSL) = 'SYS$OUTPUT:'  T  	ENDIFe     	CRFILE = .FALSE. *2DH$  	IF (ARG_EXIST(2)) CRFILE = CR_FILE *2Ea *2I 4  	IF (ARG_EXIST(%VAL(IARGPTR()),2)) CRFILE = CR_FILE *2E   n  	RETURN     c  	  	ENTRY SCREEN_START(BUFFER)  E  **_$  *	SUBROUTINE SCREEN_START( buffer )  *  *E  *	Causes routine SCREEN to enter "buffering" mode,  where instead of	E  *	performing  an  output  to  the screen every time it is called, itBE  *	stores the text in a buffer, performing an I/O  only when the buf-OE  *	fer is full or when routine  SCREEN_END  is called.  One large I/OE.  *	may be more efficient than many small ones.  *E  *	The caller  must supply the buffer, which must be a CHARACTER var-EE  *	iable at least 256 characters long.   This routine will abort withI1  *	status SS$_INSFARG if the buffer is too small.	  *E  *	If SCREEN_START is called two times without an intervening call toQE  *	SCREEN_END,  the  contents of the first buffer are lost.   Calling):  *	SCREEN_END also causes SCREEN to exit "buffering" mode.  *	)  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	11 Jul 1991	   Dahlgren, Virginia  22448T  *  I  	BUFADD = %LOC(BUFFER)I  	BUFSIZ = LEN(BUFFER)  	BUFLEN = 0  	PREV_BUFADD = 0		! 12/16/92S  T/  	IF (BUFSIZ.LT.256) CALL LIB$STOP(SS$_INSFARG)A  	RETURN  _  S  R  	ENTRY SCREEN_END  *  ***  *	SUBROUTINE SCREEN_END  *  *E  *	Causes a buffer full of text, which was created by previous  callssE  *	to  routines SCREEN_START and SCREEN, to be written to the screen. E  *	If SCREEN_START was not previously called to put routine SCREEN ina4  *	"buffering" mode, then this routine does nothing.  *E  *	If it is desired to continue "buffering" mode  after SCREEN_END isnE  *	called, then SCREEN_START must be called again, since each call tor3  *	SCREEN_END causes an exit from "buffering" mode.r  *	r  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	11 Jul 1991	   Dahlgren, Virginia  22448b  *  a4  	IF (BUSY .OR. BUFADD.EQ.0 .OR. BUFLEN.EQ.0) RETURN  s  	BUSY = .TRUE.b  	RAB.RAB$L_RBF = BUFADD  	I = BUFLEN  *  	DO WHILE (I.GT.0)S#  	    RAB.RAB$W_RSZ = MIN(I,maxbuf)M  	    STATUS = SYS$PUT(RAB) 5  	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	o  	    I = I - maxbuf,  	    RAB.RAB$L_RBF = RAB.RAB$L_RBF + maxbuf  	ENDDOR     	PREV_BUFADD = BUFADD"  	BUFADD = 0		! Turn off buffering  *  	BUSY = .FALSE.  D  	RETURN  ,  m  o  	ENTRY SCREEN_REPAINT     **U  *	SUBROUTINE SCREEN_REPAINT  *  *E  *	Re-displays the preceeding buffer full of text which was displayed E  *	by routine SCREEN_END.   This in effect repaints the screen if thelE  *	text stored  in the buffer  between the calls  to SCREEN_START andEE  *	SCREEN_END constitute a full screen display, and if the buffer was0E  *	large enough.   There is no reason not to use a large buffer (8192I  *	bytes or larger).  *	)  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	19 Oct 1992	   Dahlgren, Virginia  22448   *  W9  	IF (BUSY .OR. PREV_BUFADD.EQ.0 .OR. BUFLEN.EQ.0) RETURNl  n  	BUSY = .TRUE.n  	RAB.RAB$L_RBF = PREV_BUFADD   	I = BUFLEN  i  	DO WHILE (I.GT.0) #  	    RAB.RAB$W_RSZ = MIN(I,maxbuf)d  	    STATUS = SYS$PUT(RAB)T5  	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	   	    I = I - maxbuf,  	    RAB.RAB$L_RBF = RAB.RAB$L_RBF + maxbuf  	ENDDO.  *  	BUSY = .FALSE.  e  	RETURN  a  a     	ENTRY SCREEN_PUT(STRING)  *  ** "  *	SUBROUTINE SCREEN_PUT( string )  *  *E  *	This routine is almost identical to subroutine  SCREEN.   The only E  *	difference is that  SCREEN_PUT  does not process the cent sign andbE  *	upside-down question mark characters specially.  SCREEN_PUT should :  *	be used to write general text which may contain  or .  *	;  *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	19 Sep 1991	   Dahlgren, Virginia  22448S  *     	QUOTE = .TRUE.  i	  	GO TO 1o  o *2D   	END									  *2En *2IR  	END									 *2E 