$  	LOGICAL FUNCTION INTERACTIVE_INPUT     ** )  *	LOGICAL FUNCTION INTERACTIVE_INPUT ( )   *  *E  *	Returns a .TRUE. result if and only if  the  file  SYS$INPUT  is a   *	a terminal device.   *  *	.INDEX ENVIRONMENT>>   *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53!  *			   Dahlgren, Virginia  22448   *     	IMPLICIT INTEGER (A-Z)   &  	PARAMETER ( PCB$V_BATCH   =   'E'X )&  	PARAMETER ( PCB$V_NETWRK  =  '15'X )&  	PARAMETER ( DVI$_DEVCLASS =   '4'X )&  	PARAMETER ( DC$_TERM      =  '42'X )&  	PARAMETER ( SS$_IVDEVNAM  = '144'X )     	CHARACTER*12 DEVICE   	INTEGER ITMLST(4)   	LOGICAL TERM   #  	COMMON /USER_DATA_/ PID,PROC_STAT         	DEVICE = 'SYS$INPUT:'      	ASSIGN 10 TO IT    
  	GO TO 30     10	INTERACTIVE_INPUT = TERM     	RETURN           	ENTRY INTERACTIVE_OUTPUT     ** *  *	LOGICAL FUNCTION INTERACTIVE_OUTPUT ( )  *  *E  *	Returns a .TRUE. result if and only if  the file  SYS$OUTPUT  is a   *	a terminal device.   *  *	.INDEX ENVIRONMENT>>   *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53!  *			   Dahlgren, Virginia  22448   *     	DEVICE = 'SYS$OUTPUT:'     	ASSIGN 20 TO IT    
  	GO TO 30     20	INTERACTIVE_OUTPUT = TERM      	RETURN           	ENTRY INTERACTIVE_MODE     ** (  *	LOGICAL FUNCTION INTERACTIVE_MODE ( )  *  *E  *	Returns a .TRUE. result if and only if the file  SYS$COMMAND  is a   *	a terminal device.   *  *	.INDEX ENVIRONMENT>>   *	.INDEX TERMINAL I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	25 Aug 1986	   Dahlgren, Virginia  22448   *     	DEVICE = 'SYS$COMMAND:'      	ASSIGN 25 TO IT    
  	GO TO 30     25	INTERACTIVE_MODE = TERM      	RETURN           	ENTRY BATCH_MODE     ** "  *	LOGICAL FUNCTION BATCH_MODE ( )  *  *E  *	Returns a .TRUE. result if and only if called from a program  run-   *	ning in a batch process.   *  *	.INDEX ENVIRONMENT>>   *	.INDEX BATCH JOBS>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53!  *			   Dahlgren, Virginia  22448   *     	CALL USER_HAS_PRIV(' ')    :  	BATCH_MODE = IAND(PROC_STAT,ISHFT(1,PCB$V_BATCH)) .NE. 0     	RETURN           	ENTRY NETWORK_MODE     ** $  *	LOGICAL FUNCTION NETWORK_MODE ( )  *  *E  *	Returns a .TRUE. result if and only if called from a program  run-   *	ning in a network process.   *  *	.INDEX ENVIRONMENT>>   *	.INDEX NETWORK JOBS>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55!  *			   Dahlgren, Virginia  22448   *     	CALL USER_HAS_PRIV(' ')    =  	NETWORK_MODE = IAND(PROC_STAT,ISHFT(1,PCB$V_NETWRK)) .NE. 0      	RETURN           30	TERM = .FALSE.   /  	CALL ITEM_LIST(ITMLST,DVI$_DEVCLASS,DEVCLASS)    5  	STATUS = SYS$GETDVIW( , , DEVICE , ITMLST , , , , )     *2D F  	IF (STATUS.EQ.SS$_IVDEVNAM) GO TO IT,(10,20) ! Name ASSIGNed to file *2E  *2I >  	IF (STATUS.EQ.SS$_IVDEVNAM) GO TO IT ! Name ASSIGNed to file *2E    .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))     	TERM = DEVCLASS .EQ. DC$_TERM     *2D   	GO TO IT,(10,20) *2E  *2I 
  	GO TO IT *2E      	END -  	LOGICAL FUNCTION USER_HAS_PRIV( PRIV_NAME )      ** .  *	LOGICAL FUNCTION USER_HAS_PRIV( priv_name )  *  *E  *	This function returns a value of .TRUE. if this  process  has  the E  *	named privilege (passed as a character string), or returns a value E  *	of  .FALSE.  if this process does not have the privilege or if the -  *	name is not the name of a known privilege.   *E  *	In addition, other information about this process is  returned  in   *	in common /USER_DATA_/:  *6  *	    The PID, process status flags, UIC (longwords),  *E  *	    The process name, terminal name (if any), user name (strings),   *B  *	    The lengths of the valid parts of the name strings (words).  *&  *	The format of this common block is:  *  *		INTEGER*4 PID,PROC_STAT,UIC   *		CHARACTER*16 PROCNAME   *		CHARACTER*8 TERMNAME  *		CHARACTER*12 USERNAME   *		INTEGER*2 PNLEN,TNLEN,UNLEN   **  *		COMMON /USER_DATA_/ PID,PROC_STAT,UIC,(  *		1		      PROCNAME,TERMNAME,USERNAME,%  *		2		       PNLEN,   TNLEN,   UNLEN   *  *E  *	If you desire to see information in addition to this, you can have E  *	additional data returned by placing your requests  in  the  ITMLST D  *	array in common /USER_PRIV_/.  The format of the common block is:  *  *		INTEGER*4 ITMLST(28)  *		COMMON /USER_PRIV_/ ITMLST  *E  *	Your requests may start in ITMLST(22).  See the  writeup  for  the E  *	$GETJPI  System  Service  in the VAX/VMS System Services Reference E  *	Manual for the format of the request (each request uses 3 elements E  *	of ITMLST; the last request must be followed by a zero word).  You E  *	may define ITMLST to be longer than 28 elements if necessary; rou- 3  *	tine ITEM_LIST can be used to add your requests.   *  *	.INDEX ENVIRONMENT>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53,  *	19 Aug 1983 	   Dahlgren, Virginia  22448  *     	IMPLICIT INTEGER (A-Z)     	CHARACTER*(*) PRIV_NAME   	CHARACTER*6 PRIV  	CHARACTER*186 PRIVS      	INTEGER*4 PID,PROC_STAT,UIC   	CHARACTER*16 PROCNAME   	CHARACTER*8 TERMNAME  	CHARACTER*12 USERNAME   	INTEGER*2 PNLEN,TNLEN,UNLEN    C  	COMMON /USER_DATA_/ PID,PROC_STAT,UIC,PROCNAME,TERMNAME,USERNAME, %  	1				       PNLEN,   TNLEN,   UNLEN    &  	PARAMETER ( JPI$_PID      = '319'X )&  	PARAMETER ( JPI$_PRCNAM   = '31C'X )&  	PARAMETER ( JPI$_PROCPRIV = '204'X )%  	PARAMETER ( JPI$_STS      = '305'X) &  	PARAMETER ( JPI$_TERMINAL = '31D'X )&  	PARAMETER ( JPI$_UIC      = '304'X )&  	PARAMETER ( JPI$_USERNAME = '202'X )     	INTEGER*4 ITMLST(28) / 28*0 /      	COMMON /USER_PRIV_/ ITMLST   B  *	ITMLST(22) through ITMLST(27) can be set by the calling programA  *	before the first call to USER_HAS_PRIV, to get additional data   *	about the process.      	INTEGER*4 PRIVILEGES!  	LOGICAL*1 FIRST_CALL / .TRUE. /    I        DATA PRIVS/'CMKRNLCMEXECSYSNAMGRPNAMALLSPODETACHDIAGNOLOG_IOGROUP  I       1ACNT  PRMCEBPRMMBXPSWAPMALTPRISETPRVTMPMBXWORLD MOUNT OPER  EXQUOT I       2NETMBXVOLPROPHY_IOBUGCHKPRMGBLSYSGBLPFNMAPSHMEM SYSPRVBYPASSSYSLCK 	       3'/      	IF (FIRST_CALL) THEN     	    FIRST_CALL = .FALSE.   =  	    SAVE = ITMLST(22)		! (in case user added items already)    )  	    CALL ITEM_LIST(ITMLST,JPI$_PID,PID, #  	1			  JPI$_PRCNAM,PROCNAME,PNLEN, !  	2			  JPI$_PROCPRIV,PRIVILEGES,   	3			  JPI$_STS,PROC_STAT, %  	4			  JPI$_TERMINAL,TERMNAME,TNLEN,   	5			  JPI$_UIC,UIC, %  	6			  JPI$_USERNAME,USERNAME,UNLEN)      	    ITMLST(22) = SAVE    (  	    STATUS = SYS$GETJPIW(,,,ITMLST,,,)   2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))     	    UNLEN = STR_LEN(USERNAME)      	ENDIF      	PRIV = PRIV_NAME     	I = INDEX(PRIVS,PRIV)      	IF (MOD(I,6).NE.1) GO TO 100   %  	IF (PRIVS(I:I+5).NE.PRIV) GO TO 100    6  	USER_HAS_PRIV = IAND(PRIVILEGES,ISHFT(1,I/6)) .NE. 0     	RETURN     100	USER_HAS_PRIV = .FALSE.     	END -  	LOGICAL FUNCTION GETJPI( FLAGS , SHOWSUSP )      ** 6  *	LOGICAL FUNCTION GETJPI( [ flags ] , [ showsusp ] )  *  *E  *	Returns information about all the processes on the system.  Infor- E  *	mation about one process is returned each time GETJPI  is  called. E  *	A function value of  .FALSE.  is returned after all processes have E  *	been examined; subsequent calls to GETJPI will start  the  process   *	scan again at the beginning.   *E  *	The optional argument FLAGS may be used to select a class of  pro-   *	cesses to be examined:   *A  *	    If FLAGS is not present, or is zero, examine all processes   *?  *	    If FLAGS is one, examine only user interactive processes   *9  *	    If FLAGS is two, examine only user batch processes   *E  *	    If FLAGS is three, examine only  user  interactive  and  batch   *	    processes  *E  *	In addition, if bit 8 of FLAGS is on ('100'X), the process scan is E  *	restarted again at the beginning, even if all processes  have  not E  *	been examined;  only the lower byte of FLAGS is used to select the   *	class of processes.  *E  *	Only if the calling process has  WORLD  privilege  is  information E  *	about  all  processes  returned.   If the calling process has only E  *	GROUP privilege, then only this group's processes are scanned.  If E  *	it has neither  WORLD  or  GROUP privilege, then only THIS process 5  *	process and its subprocesses (if any) are scanned.   *  *	.INDEX ENVIRONMENT>>   *>  *	The following information is returned in common /GETJPI_1/:  *6  *	    The PID, process status flags, UIC (longwords),  *E  *	    The process name, terminal name (if any), user name (strings),   *B  *	    The lengths of the valid parts of the name strings (words).  *&  *	The format of this common block is:  *  *		INTEGER*4 PID,PROC_STAT,UIC   *		CHARACTER*16 PROCNAME   *		CHARACTER*8 TERMNAME  *		CHARACTER*12 USERNAME   *		INTEGER*2 PNLEN,TNLEN,UNLEN   *(  *		COMMON /GETJPI_1/ PID,PROC_STAT,UIC,%  *		1		   PROCNAME,TERMNAME,USERNAME, "  *		2		    PNLEN,   TNLEN,   UNLEN  *-   *E  *	If you desire to see information in addition to this, you can have E  *	additional data returned by placing your requests  in  the  ITMLST A  *	array in common /GETJPI_/.  The format of the common block is:   *  *		INTEGER*4 ITMLST(25)  *		COMMON /GETJPI_/ ITMLST   *E  *	Your requests may start in ITMLST(19).   See the writeup  for  the F  *	$GETJPI  System  Service  in the VAX/VMS System Services Reference E  *	Manual for the format of the request (each request uses 3 elements E  *	elements of  ITMLST;  the last request must be followed by  a zero E  *	word).   You may define  ITMLST  to be longer than  25 elements if A  *	necessary; routine ITEM_LIST can be used to add your requests.   *E  *	If you do request additional information, the information  you re- E  *	quest may not be available for processes which are suspended or in E  *	MWAIT state.   For instance,  the image name is not  available for E  *	suspended jobs.   By default,  if you request such information and E  *	the process being examined is suspended or in MWAIT,  the  processNE  *	is ignored; it is as if it did not exist.  If you wish to see sus- E  *	pended processes, use the optional argument SHOWSUSP.   It must beUE  *	an INTEGER*4 or LOGICAL*4 variable; it will be set  .TRUE.  if theEE  *	process is not suspended and not in MWAIT, .FALSE. if suspended orr  *	in MWAIT.  *  *%  *	14 Dec 83	Added SHOWSUSP argument. *  *	14 Mar 85	Use GETJPIW instead of GETJPI  *	14 Dec 86	Use LIB$GET_EF	  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	18 Nov 1983	   Dahlgren, Virginia  22448A  *     	IMPLICIT INTEGER (A-Z)     	INTEGER*4 PID,PROC_STAT,UICE  	CHARACTER*16 PROCNAMEE  	CHARACTER*8 TERMNAME  	CHARACTER*12 USERNAME   	INTEGER*2 PNLEN,TNLEN,UNLEN   	A  	COMMON /GETJPI_1/ PID,PROC_STAT,UIC,PROCNAME,TERMNAME,USERNAME, %  	1				       PNLEN,   TNLEN,   UNLENA  V"  	PARAMETER ( PCB$V_BATCH = 'E'X )   &  	PARAMETER ( JPI$_PID      = '319'X )&  	PARAMETER ( JPI$_PRCNAM   = '31C'X )&  	PARAMETER ( JPI$_STS      = '305'X )&  	PARAMETER ( JPI$_TERMINAL = '31D'X )&  	PARAMETER ( JPI$_UIC      = '304'X )&  	PARAMETER ( JPI$_USERNAME = '202'X )  	  	INTEGER*4 ITMLST(25) / 25*0 /i  n  	COMMON /GETJPI_/ ITMLSTE  '  	INTEGER*2 IOSB(4)S  N  	LOGICAL FIRST_CALL / .TRUE. /2  	LOGICAL ARG_EXIST= *2I   	INTEGER*4 IARGPTR  *2E   N2  	EXTERNAL SS$_SUSPENDED,SS$_NOPRIV,SS$_NOMOREPROC  E *2DV  	FLAGS_ = DEFAULT_ARG(1,0)s *2ER *2Ie+  	FLAGS_ = DEFAULT_ARG(%VAL(IARGPTR()),1,0)  *2E*  t2  	IF (FIRST_CALL.OR.IAND(FLAGS_,'100'X).NE.0) THEN  E  	    IF (FIRST_CALL) THEN  		STATUS = LIB$GET_EF(EFN) /  		IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))   	    ENDIFi  n  	    FIRST_CALL = .FALSE.  '=  	    SAVE = ITMLST(19)		! (in case user added items already)	  E)  	    CALL ITEM_LIST(ITMLST,JPI$_PID,PID, #  	1			  JPI$_PRCNAM,PROCNAME,PNLEN,L  	2			  JPI$_STS,PROC_STAT,)%  	3			  JPI$_TERMINAL,TERMNAME,TNLEN,   	4			  JPI$_UIC,UIC, %  	5			  JPI$_USERNAME,USERNAME,UNLEN)o  s  	    ITMLST(19) = SAVEM  >  	    PIDADR = -1   S  	ENDIF*  aD  10	STATUS = SYS$GETJPIW( %VAL(EFN) , PIDADR , , ITMLST , IOSB , , )  a  	IF (.NOT.STATUS) THEN    1  	    IF (STATUS.EQ.%LOC(SS$_SUSPENDED)) GO TO 20I1  	    IF (STATUS.EQ.%LOC(SS$_NOPRIV))    GO TO 10E  N.  	    IF (STATUS.EQ.%LOC(SS$_NOMOREPROC)) THEN  		GETJPI = .FALSE.W  		PIDADR = -1	  		RETURNt  	    ENDIF   u!  	    CALL LIB$STOP(%VAL(STATUS))g     	ENDIF*  n  20	IF (.NOT.IOSB(1)) THEN  *.  	    IF (IOSB(1).EQ.%LOC(SS$_SUSPENDED)) THEN  * *2DA"  		IF (.NOT.ARG_EXIST(2)) GO TO 10 *2Ee *2I 2  		IF (.NOT.ARG_EXIST(%VAL(IARGPTR()),2)) GO TO 10 *2E    
  	    ELSE  _  		CALL LIB$STOP(%VAL(IOSB(1)))I  (  	    ENDIFF  ,  	ENDIFW  )  	GETJPI = .TRUE.U     	UNLEN = STR_LEN(USERNAME).    *2DA&  	IF (ARG_EXIST(2)) SHOWSUSP = IOSB(1) *2E  *2I	6  	IF (ARG_EXIST(%VAL(IARGPTR()),2)) SHOWSUSP = IOSB(1) *2E   	  	IF (FLAGS_.EQ.0) RETURN   T
  	MODE = 0  	IF (TNLEN.NE.0) MODE = 19  	IF (IAND(PROC_STAT,ISHFT(1,PCB$V_BATCH)).NE.0) MODE = 2I  d&  	IF (IAND(FLAGS_,MODE).EQ.0) GO TO 10     	ENDP:  	INTEGER FUNCTION SEND_MESSAGE(USERNAME,MESSAGE,FLAGS,ID)     **TB  *	INTEGER FUNCTION SEND_MESSAGE ( user , message [,flags] [,id] )  *  *E  *	Sends a message to a given terminal, to a given logged-in user, or(E  *	to all connected terminals.  This routine requires OPER privilege,s)  *	and works cluster-wide on VAXclusters.a  *E  *	The  first  two arguments are required, and are character strings.r  *E  *	If the first argument contains a colon, it is assumed  to  be  thekC  *	name of a terminal, and the message is sent there.  For example:o  *(  *		CALL SEND_MESSAGE('TTA0:',' Hello ')  *E  *	If the first argument is blank, the message is sent to all termin- E  *	als connected  to the system, whether users are  logged in at them*
  *	or not.  *E  *	Otherwise, the first argument is assumed to be someone's Username.tE  *	The message is sent to all terminals  (if any)  at which the namedE#  *	user is logged in.  For example:A  *  *		INTEGER SEND_MESSAGE  *+  *		N = SEND_MESSAGE('JONES','  Goodbye  ')N  *E  *	In this case, the calling process needs OPER privilege,  and GROUP E  *	privilege  if the user is in the same group, or WORLD privilege if E  *	privilege if the user is not in the same group.  The function res-r@  *	ult is the number of terminals to which the message was sent.  *4  *	The message must not be over 256 characters long.  *E  *	The optional integer argument FLAGS controls the formatting of thes7  *	message.  Each bit controls one formatting function:*  *:  *		Bit 0 -- Ring the recieving terminal's bell four times  *>  *		Bit 1 -- Display the message on the recieving terminal  in7  *			 bold  reverse  video  (valid  for VTxxx terminals 7  *			 only).  For best readability, the message  should 7  *			 be  surrounded by blanks, like in the above exam-a  *			 ples.a  *>  *		Bit 2 -- Do not send this message cluster-wide.   This bit7  *			 only has effect on a VAXcluster,  and only if the*7  *			 message is  being sent to a user or to  all usersL7  *			 (messages sent  to terminal names  are never sentR  *			 cluster-wide).  *  *	.INDEX MESSAGES>>  *- E  *	If FLAGS  is omitted,  the default value of 3 is used  (ring bell,	0  *	display in reverse video, send cluster-wide).  *E  *	The optional integer argument ID controls the class of the messageEE  *	as defined by the SET BROADCAST command.   If omitted, the default 9  *	is GENERAL.  The value 4 is SHUTDOWN, and 5 is URGENT.A  *  *>  *	1 Aug 85	Add carriage return at  beginning of message,  add5  *			option to send to all users, upgrade to VMS 4.0.   *?  *	31 Aug 85	Change meaning of blank first argument from  "send 7  *			to all logged-in users" to  "send to all connectedI  *			terminals".  *&  *	19 Nov 92	Add optional ID argument.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	20 Nov 1983	   Dahlgren, Virginia  22448E  *  R  	IMPLICIT INTEGER (A-Z)  A0  	PARAMETER ( BRK$C_ALLUSERS = '3'x )	! Not used%  	PARAMETER ( BRK$C_ALLTERMS = '4'x )O%  	PARAMETER ( BRK$C_DEVICE   = '1'x )T%  	PARAMETER ( BRK$C_USERNAME = '2'x ) '  	PARAMETER ( BRK$M_CLUSTER  = '800'x )S%  	PARAMETER ( BRK$C_SHUTDOWN = '4'x ) %  	PARAMETER ( BRK$C_URGENT   = '5'x )       	CHARACTER*(*) USERNAME,MESSAGE  E  	INTEGER*2 IOSB(4)c!  	LOGICAL*1 FIRST_CALL / .TRUE. /      	CHARACTER*280 BUFFER  $  	CHARACTER*1 ESC,BEL,CR  	CHARACTER*6 FRTN  	CHARACTER*3 BCKO  	CHARACTER*4 BELS  	  	PARAMETER ( CR   = CHAR(13) )   	PARAMETER ( ESC  = CHAR(27) )	  	PARAMETER ( BEL  = CHAR(7) )#  	PARAMETER ( FRT  = ESC//'[1;7m' )    	PARAMETER ( BCK  = ESC//'[m' ))  	PARAMETER ( BELS = BEL//BEL//BEL//BEL )   (  	LOGICAL ARG_EXIST$ *2I%  	INTEGER*4 IARGPTR  *2EE     	EXTERNAL SS$_DEVOFFLINEN    *2D   	FLAGS_ = DEFAULT_ARG(3,'3'x)  	ID_    = DEFAULT_ARG(4,'0'x) *2EN *2IG.  	FLAGS_ = DEFAULT_ARG(%VAL(IARGPTR()),3,'3'x).  	ID_    = DEFAULT_ARG(%VAL(IARGPTR()),4,'0'x) *2E/     	MLEN = LEN(MESSAGE) + 11   	BUFFER(1:MLEN) = CR // MESSAGE     	IF (IAND(FLAGS_,1).NE.0) THENS"  	    BUFFER(MLEN+1:MLEN+4) = BELS  	    MLEN = MLEN + 4g  	ENDIFh  u  	IF (IAND(FLAGS_,2).NE.0) THENa;  	    BUFFER(1:MLEN+9) = CR // FRT // BUFFER(2:MLEN) // BCKo  	    MLEN = MLEN + 9r  	ENDIFa  t  	BFLAGS = 0  aH  	IF ( INDEX(USERNAME,':') .NE. 0 ) THEN	       ! Send to given terminal     	    SNDTYP = BRK$C_DEVICEt  l   	ELSE IF (USERNAME.EQ.' ') THEN     	    SNDTYP = BRK$C_ALLTERMSg5  	    IF (IAND(FLAGS_,4).EQ.0) BFLAGS = BRK$M_CLUSTERe  t  	ELSE     	    SNDTYP = BRK$C_USERNAMEd5  	    IF (IAND(FLAGS_,4).EQ.0) BFLAGS = BRK$M_CLUSTERm     	ENDIFs     	IF (FIRST_CALL) THEN  	    FIRST_CALL = .FALSE.  	    STATUS = LIB$GET_EF(EF)I2  	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	ENDIF    9  	STATUS = SYS$BRKTHRUW(%VAL(EF),BUFFER(1:MLEN),USERNAME, <  	1	    %VAL(SNDTYP),IOSB,,%VAL(BFLAGS),%VAL(ID_),%VAL(5),,)  '  	SEND_MESSAGE = IOSB(2)   .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  o-  	IF (IOSB(1).EQ.%LOC(SS$_DEVOFFLINE)) RETURN   e0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))  r  	END.(  	SUBROUTINE SEND_SECURITY_MESSAGE(TEXT)  L  **i+  *	SUBROUTINE SEND_SECURITY_MESSAGE( text )e  *  *E  *	Uses the $SNDOPR System Service  to send a message to the OperatorlE  *	Log and to all terminals enabled as SECURITY operators.  The mess-rE  *	age is the character string argument TEXT,  which can be up to 255s  *	characters long.n  *  *?  *	19 Sep 88	Set OPER12 bit as well as SECURITY bit, so messagee7  *			will go to log,  even if no terminals are SECURITY   *			operators. :  *	 4 Oct 88	Do not limit message length to 80 characters.?  *	 4 Jan 90	Remove 19 Sep 88 change; not believed necessary in 
  *			VMS 5.2.m)  *	 4 Mar 90	Re-install 19 Sep 88 change.i  *  *	.INDEX MESSAGES>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	6 Aug 1987	   Dahlgren, Virginia  22448  *  *  	IMPLICIT NONEE     	INCLUDE '($OPCDEF)'1  I  	CHARACTER*(*) TEXT     	STRUCTURE /MESSAGE/R	  	  UNION		  	    MAPN  	      BYTE TYPE   	      BYTE %FILL(3)i  	      INTEGER*4 RQSTID  	      CHARACTER*255 TEXT
  	    END MAPa	  	    MAPr  	      INTEGER*4 TARGET  	    ENDMAP	  	    MAPa  	      CHARACTER*263 STRING
  	    END MAPc
  	  END UNION   	END STRUCTURE*  T  	RECORD /MESSAGE/ MSGBUFI  I"  	INTEGER*4 SLEN,STATUS,SYS$SNDOPR  i>  	MSGBUF.TARGET = ISHFT(OPC$M_NM_SECURITY,8)	! Order dependent6  	1		     + ISHFT(OPC$M_NM_OPER12,8)	! Order dependent  							! Order dependent 0  	MSGBUF.TYPE = OPC$_RQ_RQST			! Order dependent  f  	MSGBUF.RQSTID = 0e  s  	MSGBUF.TEXT = TEXT  z  	SLEN = LEN(TEXT) + 8  e-  	STATUS = SYS$SNDOPR(MSGBUF.STRING(1:SLEN),)   *.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  u  	ENDs7  	INTEGER FUNCTION SYMBOL_SUBSTITUTE(LINE,NEWLEN,FOUND)e  f  **iB  *	INTEGER FUNCTION SYMBOL_SUBSTITUTE( line , [newlen] , [found] )  *  *E  *	Performs DCL symbol substitution on any symbol  names  found  in aaE  *	character  string.   The symbol name must be delimited by apostro-tE  *	phes (single quotes)(').  There should not be two adjacent opening E  *	apostrophes, as in some DCL constructs.   If the substring betweensE  *	apostrophes is not a defined DCL symbol, this is not considered an 	  *	error.*  *E  *	You may also re-define the delimiters to be  characters other thanoE  *	apostrophes.  The opening and closing delimiters can be different, E  *	if desired.   To do this, place the desired characters in the var-e+  *	iables OPEN and CLOSE, as defined below:L  *  *		CHARACTER*1 OPEN,CLOSE$  *		COMMON /SYMBOL_SUBS_/ OPEN,CLOSE  *E  *	This routine is useful for processing lines  read  from  SYS$INPUT	E  *	within command procedures, since these lines do not have automatic*(  *	symbol substitution performed by DCL.  *	EE  *	LINE is the character string to be processed.   The optional inte- E  *	ger  argument  NEWLEN, if supplied, is set upon exit to the lengthTE  *	of LINE, not counting any rightmost blanks or tabs, after any sub- E  *	stitutions have been made. The optional integer argument FOUND, ifAE  *	supplied,  is set upon exit  to the number of symbol substitutionsX  *	made.  *E  *	The functional result is the status value SS$_NORMAL,  unless sym-	E  *	bol  substitution caused non-blank, non-tab characters to be trun- E  *	cated from the right end of LINE, in which case the  status  valueR  *	STR$_TRU is returned.  *  *7  *	21 Mar 1986	Allow delimiters other than apostrophes.O  *  *	.INDEX DCL SYMBOLS>>D  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	16 Feb 1984	   Dahlgren, Virginia  224481  *  E  	IMPLICIT INTEGER (A-Z)  _  	CHARACTER*(*) LINE  I  	CHARACTER*256 VALUE.  .  	EXTERNAL SS$_NORMAL, STR$_TRU)     	LOGICAL ARG_EXIST   I  	CHARACTER*1 OPEN,CLOSE   "  	COMMON /SYMBOL_SUBS_/ OPEN,CLOSE  d  	DATA OPEN,CLOSE / '''','''' /I  _  	GOOD_LEN = STR_LEN(LINE)  	&  	SYMBOL_SUBSTITUTE = %LOC(SS$_NORMAL)
  	SUBS = 0	  	COL = 1   	$  10	COL1 = SUBINDEX(LINE, COL, OPEN)  	IF (COL1.EQ.0) GO TO 30	  P'  20	COL = SUBINDEX(LINE, COL1+1, CLOSE)T  	IF (COL.EQ.0) GO TO 30  I:  	STATUS = LIB$GET_SYMBOL(LINE(COL1+1:COL-1), VALUE, VLEN)  NG  	IF (.NOT.STATUS) THEN	      ! Name between quotes is not a DCL symbol   F  	    COL1 = COL  	    GO TO 20  O  	ENDIF	  F  	SUBS = SUBS + 1$  P!  	DELTA = VLEN - (COL - COL1 + 1)T  S-  	LINE(COL1:) = VALUE(1:VLEN) // LINE(COL+1:)L  W'  	IF (GOOD_LEN+DELTA.GT.LEN(LINE)) THEN   u(  	    SYMBOL_SUBSTITUTE = %LOC(STR$_TRU)  	    GOOD_LEN = LEN(LINE)  	    GO TO 30  	  	ENDIFO  1  	GOOD_LEN = GOOD_LEN + DELTA   	COL = COL + DELTA + 1_
  	GO TO 10    *2D2'  30	IF (ARG_EXIST(2)) NEWLEN = GOOD_LENP *2E, *2IO7  30	IF (ARG_EXIST(%VAL(IARGPTR()),2)) NEWLEN = GOOD_LENO *2E)    *2D	   	IF (ARG_EXIST(3)) FOUND = SUBS *2E= *2IE0  	IF (ARG_EXIST(%VAL(IARGPTR()),3)) FOUND = SUBS *2ER  X  	END "  	INTEGER FUNCTION STR_LEN(STRING)  R  **S%  *	INTEGER FUNCTION STR_LEN( string ))  *  *E  *	Returns, as the functional result, the  length  of  the  character=E  *	string  argument  STRING,  minus any rightmost blanks and/or tabs.F  *  *	.INDEX STRING MANIPULATION>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	26 Feb 1984	   Dahlgren, Virginia  22448   *  g  	IMPLICIT INTEGER (A-Z)  *  	CHARACTER*(*) STRING     	STR_LEN = LEN(STRING)e  n  	DO WHILE (STR_LEN.GT.0)c   /  	    IF ( STRING(STR_LEN:STR_LEN).NE.' ' .AND.s5  	1		     STRING(STR_LEN:STR_LEN).NE.CHAR(9) ) RETURNe  i  	    STR_LEN = STR_LEN - 1e  a  	ENDDOa  t  	ENDn2  	INTEGER FUNCTION SUBINDEX(STRING,COLUMN,PATTERN)     **s:  *	INTEGER FUNCTION SUBINDEX ( string , column , pattern )  *  *E  *	This is very much like the Fortran INDEX built-in function, except E  *	that SUBINDEX begins the search at an arbitrary column within  the 
  *	string.  *E  *	STRING is the character string to be searched.  COLUMN is the col- E  *	umn number at which to begin the search.  PATTERN is the substring   *	for which we are searching.  *E  *	The functional result is zero if the pattern is not found  in  theAE  *	string.   If the pattern is found, the functional result is set tod?  *	the column where the first occurrence of the pattern begins.v  *B  *	The following example shows a common mistake in using SUBINDEX:  *6  *	    INCORRECT:   COL = SUBINDEX(STRING(22:),22,' ')  *1  *	      CORRECT:   COL = SUBINDEX(STRING,22,' ')   *  *	.INDEX STRING MANIPULATION>>n  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	16 Feb 1984	   Dahlgren, Virginia  22448o  *  g  	IMPLICIT INTEGER (A-Z)  i  	CHARACTER*(*) STRING,PATTERN  *  	INTEGER*2 COLUMN   +  	SUBINDEX = INDEX(STRING(COLUMN:),PATTERN)   	5  	IF (SUBINDEX.NE.0) SUBINDEX = SUBINDEX + COLUMN - 1      	ENDo6  	INTEGER FUNCTION STR_REMOVE(STRING,SUBSTRING,LENGTH)  y  **oA  *	INTEGER FUNCTION STR_REMOVE ( string , substring [ ,length ] )l  *  *D  *	Removes the  first occurrence,  if any,  of the  character stringD  *	SUBSTRING from the character string  STRING.   If a matching sub-D  *	string is found and removed,  the functional result is set to theD  *	column where the string occurred, and the INTEGER*4 value  LENGTHD  *	(if present) is decremented by the length of the substring. If noD  *	matching substring is found, the functional result is set to zeroD  *	and the contents of the STRING and LENGTH (if present)  arguments  *	are not altered.a  *1  *	Example:	Before:  STRING = 'AB~DE'  LENGTH = 5c  *-  *				 COLUMN = STR_REMOVE(STRING,'~',LENGTH)   **  *			After:   STRING = 'ABDE '  LENGTH = 4  *				 COLUMN = 3   *  *	.INDEX STRING MANIPULATION>>a  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	12 Jun 1984	   Dahlgren, Virginia  22448n  *     	IMPLICIT INTEGER (A-Z)      	CHARACTER*(*) STRING,SUBSTRING  *  	LOGICAL ARG_EXIST* *2Io  	INTEGER*4 IARGPTRa *2En   &  	STR_REMOVE = INDEX(STRING,SUBSTRING)     	IF (STR_REMOVE.GT.0) THENK     	    L = LEN(SUBSTRING)  i=  	    STRING = STRING(:STR_REMOVE-1) // STRING(STR_REMOVE+L:)E    *2D_+  	    IF (ARG_EXIST(3)) LENGTH = LENGTH - LR *2EL *2IS;  	    IF (ARG_EXIST(%VAL(IARGPTR()),3)) LENGTH = LENGTH - LE *2ER  _  	ENDIF=  '  	END	#  	INTEGER FUNCTION COLLAPSE(STRING)S  	  **E'  *	INTEGER FUNCTION COLLAPSE ( string )E  *  *E  *	Removes all  blanks and tab characters  from the  character stringEE  *	argument STRING.   The resultant  length of the non-blank  part ofU-  *	STRING is returned as the function result.*  *  *	.INDEX STRING MANIPULATION>>E  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	9 Mar 1984	   Dahlgren, Virginia  22448  *     	IMPLICIT NONE;     	CHARACTER*(*) STRING  C
  	INTEGER*4 IA  E  	COLLAPSE = 0  /  	DO I = 1,LEN(STRING)   ?  	    IF (STRING(I:I).NE.' ' .AND. STRING(I:I).NE.CHAR(9)) THEND  F  		COLLAPSE = COLLAPSE + 1  F*  		STRING(COLLAPSE:COLLAPSE) = STRING(I:I)  )  	    ENDIF   L  	ENDDOF  T8  	IF (LEN(STRING).GT.COLLAPSE) STRING(COLLAPSE+1:) = ' '  G  	END4#  	INTEGER FUNCTION COMPRESS(STRING)E     **	'  *	INTEGER FUNCTION COMPRESS ( string )(  *  *E  *	Replaces every string of consecutive blanks and/or tabs in charac-EE  *	ter string argument STRING with exactly one blank.   The resultingMF  *	length of the compressed STRING is returned as the function result.  *  *	.INDEX STRING MANIPULATION>>I  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	17 Jul 1990	   Dahlgren, Virginia  22448N  *  '  	IMPLICIT NONE   N  	CHARACTER*(*) STRING   
  	INTEGER*4 IS  	LOGICAL*4 LASTBLANK$  L  	COMPRESS = 0  	LASTBLANK = .FALSE.B  C  	DO I = 1,LEN(STRING)  F?  	    IF (STRING(I:I).NE.' ' .AND. STRING(I:I).NE.CHAR(9)) THENI  _  		LASTBLANK = .FALSE.  L  		COMPRESS = COMPRESS + 1  G*  		STRING(COMPRESS:COMPRESS) = STRING(I:I)  P#  	    ELSE IF (.NOT.LASTBLANK) THENS  S  		LASTBLANK = .TRUE.F  (  		COMPRESS = COMPRESS + 1  L"  		STRING(COMPRESS:COMPRESS) = ' '  V  	    ENDIF   E  	ENDDOE  I8  	IF (LEN(STRING).GT.COMPRESS) STRING(COMPRESS+1:) = ' '  o  	END(  	INTEGER FUNCTION TRIM(STRING)R  R  **e#  *	INTEGER FUNCTION TRIM ( string )V  *  *E  *	Removes all  leading and trailing  blanks and tabs  from character*E  *	string argument STRING; the resulting length of the trimmed STRING &  *	is returned as the function result.  *  *	.INDEX STRING MANIPULATION>>l  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	17 Jul 1990	   Dahlgren, Virginia  22448*  *  t  	IMPLICIT NONE*  *  	CHARACTER*(*) STRING  s  	INTEGER*4 STR_LEN,     	IF (LEN(STRING).GT.0) THEN  v?  	    DO WHILE (STRING(1:1).EQ.' ' .OR. STRING(1:1).EQ.CHAR(9))D  o  		STRING = STRING(2:)  0  	    ENDDO      	ENDIFR  v  	TRIM = STR_LEN(STRING)  v  	ENDs9  	LOGICAL FUNCTION ELEMENT(N,DELIM,STRING,COL1,COL2,ELEN)   n  ** E  *	LOGICAL FUNCTION ELEMENT (n , delim , string , col1 , col2 , len )r  *  *E  *	Locates the Nth "element" in character string argument STRING.  An E  *	element is a substring between occurrences of the single character E  *	DELIM.   If two delimiters appear consecutively,  they have a null E  *	element between them.   If STRING begins or ends with a delimiter, E  *	it is assumed to actually begin or end with a null element.   Ele-P2  *	ments are numbered 0,1,2,... and an example is:  */  *	  if  STRING = 'A,BCD,,E,'  and  DELIM = ','D  *  *	  then	element 0 = 'A'E  *		element 1 = 'BCD'O  *		element 2 = ''  *		element 3 = 'E'S#  *		element 4 = ''   (last element)   *E  *	Unlike the similar  DCL Lexical Function  F$ELEMENT,  this routine E  *	must, for a given string,  be called in order N=0, N=1, ... , i.e. E  *	it must only be used to parse a string left-to-right,  starting at=E  *	the beginning  of the string.   If this is not followed, no errorsTE  *	will occur,  but the results will be incorrect.   Also,  F$ELEMENT,E  *	considers a null string  to be composed  of one null element; this E  *	routine considers a null string to have no elements.  The functionyE  *	result is .TRUE. unless it is called  with N past the last elementuE  *	in the string.   Integer arguments COL1 and COL2 locate the begin- E  *	ning and ending columns,  within STRING, of the element.   Integer.E  *	argument LEN gives the length of the element (zero for a null ele-l	  *	ment).o  *  *	.INDEX STRING MANIPULATION>>Y  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	23 Jul 1990	   Dahlgren, Virginia  22448   *  d  	IMPLICIT NONE   i
  	INTEGER*4 Ni.  	CHARACTER*1 DELIM	! Note--one character only  	CHARACTER*(*) STRING  	INTEGER*4 COL1,COL2,ELEN  R  	INTEGER*4 LASTCOL*  O  	IF (N.EQ.0) THEN  	    LASTCOL = -1'  	    IF (LEN(STRING).EQ.0) LASTCOL = 0s  	ENDIFr   "  	IF (LASTCOL.GE.LEN(STRING)) THEN  s  	    ELEMENT = .FALSE.t  v  	ELSE  *  	    COL1 = LASTCOL + 2+  	    COL2 = INDEX(STRING(COL1:),DELIM) - 1t  s  	    IF (COL2.LT.0) THENe  		COL2 = LEN(STRING)r
  	    ELSE  		COL2 = COL2 + LASTCOL + 1  	    ENDIFe  n  	    ELEN = COL2 - COL1 + 1  y0  	    LASTCOL = COL2		! For next call to ELEMENT  i  	    ELEMENT = .TRUE.  i  	ENDIFg  a  	END +  	INTEGER FUNCTION CLI_INT(QUALIFIER,VALUE)o  e  **e0  *	INTEGER FUNCTION CLI_INT( qualifier , value )  *  *E  *	Parses a command line parameter or qualifier which has an  integeruE  *	value.   The supplied value may be in either of the following for-h  *	mats:  *  *		i	%Di	%Oj	%Xke  *E  *	where 'i' is one or more decimal digits, 'j' is one or more  octalw5  *	digits, and 'k' is one or more hexadecimal digits.   *E  *	The calling routine specifies in character argument QUALIFIER  the E  *	name of the qualifier (or parameter) whose value is to be fetched.CE  *	The integer value is returned in the INTEGER*4 argument VALUE. The E  *	functional result shows the status of the parse; it is  SS$_NORMALH!  *	(integer value 1) for success./  *E  *	If the parameter or qualifier is not present, and is not defaultedLF  *	present, CLI_INT will return the status value CLI$_ABSENT (current-+  *	ly hex 000381F0) as its function result.   *E  *	The Command Language Definition (CLD) which includes the parameter,D  *	or qualifier being referenced by CLI_INT must include the clause:  *  *		Value( Type=$NUMBER )N  *E  *	and, if a default value is to be defined, it should also be inclu-   *	ed in the CLD.  Examples:  *8  *	    Qualifier A , Value( Type=$NUMBER, Default="10" )  *A  *	    Qualifier B , Default, Value( Type=$NUMBER, Default="10" ):  *E  *	The two examples differ in the following way:  if the qualifier /BTE  *	is omitted entirely, the value "10" will be used;  it is defaultedNE  *	to be present.  If the qualifier  /A  is omitted, CLI_INT will re-OE  *	turn CLI$_ABSENT; if /A is present with no value, 10 will be used.   *	FE  *	If the value is present or is defaulted in, but is not in the for-FE  *	mat of a legal integer, then the functional result will be a fail-)  *	ure status code:2  *E  *	    The value  0  will be returned if the qualifier was present orNE  *	    defaulted, but no value was present or defaulted  (i.e.  "/A", E  *	    not "/A=10", and no default was defined).  Note that the usagen6  *	    /QUAL="" will act as if /QUAL=0 were specified.  *E  *	    The value OTS$_INPCONERR (hex value 0017802C) will be returned	E  *	    if the value is not a legal  decimal/octal/hex integer.   NoteMF  *-	    that this cannot happen if the "Type=$NUMBER" clause was used,E  *	    since in that case the  CLI Parser  will catch  and SIGNAL theT
  *	    error.A  *  *	.INDEX ENVIRONMENT>>N&  *	.INDEX COMMAND LANGUAGE INTERFACE>>  *0  *	20 Nov 87	Completely redefined and rewritten.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	15 Apr 1984	   Dahlgren, Virginia  22448   *  T  	IMPLICIT NONEl     	CHARACTER*(*) QUALIFIERf  	INTEGER*4 VALUE*  a>  	INTEGER*4 STATUS,CLI$PRESENT,CLI$GET_VALUE,VLEN,OTS$CVT_TI_L  	CHARACTER*32 RAW_VALUE  s!  	STATUS = CLI$PRESENT(QUALIFIER)d  C  	IF (.NOT.STATUS) THENn  m  	    CLI_INT = STATUS  e  	ELSE  E2  	    CALL CLI$GET_VALUE(QUALIFIER,RAW_VALUE,VLEN)  *  	    IF (VLEN.EQ.0) THENi  e  		CLI_INT = 0  s
  	    ELSE   2  		CLI_INT = OTS$CVT_TI_L(RAW_VALUE(1:VLEN),VALUE)  n  	    ENDIFs  t  	ENDIFe  l  	ENDr3  	LOGICAL FUNCTION LIST_CHECK(ORDINAL,LIST,LISTLEN)*  e  **o:  *	INTEGER FUNCTION LIST_CHECK( ordinal , list , listlen )  *  *E  *	Searches a list of integer ranges which was constructed by routine E  *	LIST_PARSE  to see if integer ORDINAL is within one of the ranges.*E  *	INTEGER*4 array LIST(2,LISTLEN) is the list which is checked.  For E  *	I from 1 to LISTLEN, each LIST(1,I) is the first value in a range,RE  *	and LIST(2,I) is the last value in the range.   The ranges are NOT E  *	assumed to be in ascending order, but for each I, LIST(1,I) is as-S  *	sumed to be .LE. LIST(2,I).  *E  *	The function result is set to .TRUE. if ORDINAL is withinin one of*E  *	the, ranges, or to .FALSE. if ORDINAL is not in any of the ranges.   *)  *	See routine LIST_PARSE for an example.n  *  *	.INDEX ENVIRONMENT>> &  *	.INDEX COMMAND LANGUAGE INTERFACE>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55*  *	8 Jun 1992	   Dahlgren, Virginia  22448  *  g  	IMPLICIT NONEe  T+  	INTEGER*4 ORDINAL,LISTLEN,LIST(2,LISTLEN)e  t
  	INTEGER*4 Ih     	DO I = 1, LISTLEN   m&  	    IF (ORDINAL .GE. LIST(1,I) .AND.'  	1				ORDINAL .LE. LIST(2,I)) GO TO 10e     	ENDDOR   )  	LIST_CHECK = .FALSE.	! Not in any rangen  	RETURN   $  10	LIST_CHECK = .TRUE.	! In a range    *2DT  	END										 *2EM *2IT  	END									   *2EH9  	INTEGER FUNCTION LIST_PARSE(STRING,LIST,MAXLEN,LISTLEN)C  M  ** B  *	INTEGER FUNCTION LIST_PARSE( string , list , maxlen , listlen )  *  *E  *	Parses a character string which contains a comma-separated list ofn,  *	integers and integer ranges; for example:  *  *		"1,3-5,6-11,13,18-22,25+"G  *E  *	Any blanks within the string are ignored;  ranges like "10-10" areO(  *	accepted; ranges like "10-9" are not.  *F  *	The output from the parse is in the INTEGER*4 array LIST(2,MAXLEN).E  *	For each single integer,  LIST(1,I) and  list(2,I) are both set toSE  *	the integer's value; for each range, LIST(1,I) is set to the firstRE  *	value in the range, and LIST(2,I)  is set to the last value in the E  *	range.  For ranges like "5+", LIST(1,I) is set to 5, and LIST(2,I)r@  *	is set to hexadecimal 7FFFFFFF, the largest positive integer.  *E  *	The calling program must provide the array LIST and integer MAXLENnE  *	which tells LIST_PARSE how may rows LIST has.  LIST_PARSE sets in-*@  *	teger LISTLEN to the number of rows of LIST it actually uses.  *6  *	The function result is one of the following values:  *  *		0 - Syntax error  *		1 - Successful return *  *		2 - More than MAXLEN numbers or ranges>  *		3 - Successful return, but numbers and/or ranges aren't in6  *		     ascending order ("3,2" or "3-6,5-7" or "3,3")  *E  *	Routines LIST_PARSE and LIST_CHECK can be used as in the following)  *	simple example:  *;  *	    A command has a qualifier /SELECT, which is used as:1  *  *		/SELECT=(1,5,6-11,13) 7  *		/SEL=("1,4,6+")		! If + used, the "+" needs quoting   *%  *	    The CLD (fragment) looks like:v  *.  *		Qualifier SELECT , Value( Required, List )  *1  *	    The program (FORTRAN fragment) looks like:a  */  *		INTEGER*4 LIST(2,20),SLEN /0/, S, L, IVALUEI  *		CHARACTER*64 STRINGc	  *		. . ..  *-   *>  *		DO WHILE (CLI$GET_VALUE( 'SELECT' , STRING(SLEN+1:) , S ))  *		    SLEN = SLEN + S + 1   *		    STRING(SLEN:SLEN) = ','r	  *		ENDDOa;  *		STATUS = LIST_PARSE( STRING(1:SLEN-1) , LIST , 20 , L )G  *		IF (.NOT.STATUS) . . .	  *		. . .L  *		IVALUE = . . .2  *		IF (.NOT.LIST_CHECK( IVALUE , LIST ,L )) . . .  *  *	.INDEX ENVIRONMENT>>I&  *	.INDEX COMMAND LANGUAGE INTERFACE>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55*  *	8 Jun 1992	   Dahlgren, Virginia  22448  *  L  	IMPLICIT NONEL  )  	CHARACTER*(*) STRING)  	INTEGER*4 MAXLEN,LIST(2,MAXLEN),LISTLEN    '  	INTEGER*4 ICOL,CCOL,HCOL,OTS$CVT_TI_L	     	INTEGER*4 I,J,K,CVTI  	  CVT(I,J,K) =B  	1    OTS$CVT_TI_L( STRING(I:J-1) , LIST(K,LISTLEN) , , %VAL(1) )  N!  	IF (LEN(STRING).EQ.0) GO TO 100R  N
  	LISTLEN = 0r
  	ICOL = 1   <  10	CCOL = INDEX(STRING(ICOL:),',')		! Find first/next comma  	IF (CCOL.EQ.0) THENu9  	    CCOL = LEN(STRING) + 1		! If no comma, simulate one*  	ELSE5  	    CCOL = CCOL + (ICOL-1)		! Get true comma columnP  	ENDIFl  **  	IF (CCOL.EQ.ICOL) GO TO 100	! Null value  e1  	LISTLEN = LISTLEN + 1		! Assume we have a value "  	IF (LISTLEN.GT.MAXLEN) GO TO 110  N?  	HCOL = INDEX(STRING(ICOL:CCOL-1),'+')	! Is there a plus sign?F  	IF (HCOL.NE.0) THENN&  	    IF (HCOL+ICOL.NE.CCOL) GO TO 100,  	    IF (.NOT.CVT(ICOL,CCOL-1,1)) GO TO 1003  	    LIST(2,LISTLEN) = '7FFFFFFF'x	! Plus infinityR  	    GO TO 20  	ENDIF   N<  	HCOL = INDEX(STRING(ICOL:CCOL-1),'-')	! Is there a hyphen?  	IF (HCOL.EQ.0) THENF  T*  	    IF (.NOT.CVT(ICOL,CCOL,1)) GO TO 100'  	    LIST(2,LISTLEN) = LIST(1,LISTLEN)l  n  	ELSE  c  	    HCOL = HCOL + (ICOL-1)B  	    IF (HCOL.EQ.CCOL .OR. HCOL.EQ.CCOL-1) GO TO 100	! Bad hyphen*  	    IF (.NOT.CVT(ICOL,HCOL,1)) GO TO 100,  	    IF (.NOT.CVT(HCOL+1,CCOL,2)) GO TO 1007  	    IF (LIST(2,LISTLEN).LT.LIST(1,LISTLEN)) GO TO 100r     	ENDIFa  m  20	ICOL = CCOL + 1o#  	IF (ICOL.LE.LEN(STRING)) GO TO 10*  n  	LIST_PARSE = 1  	ICOL = LISTLEN  e  30	IF (ICOL.EQ.1) RETURN 5  	IF (LIST(1,ICOL).LE.LIST(2,ICOL-1)) LIST_PARSE = 3	   	ICOL = ICOL - 1 
  	GO TO 30  	-  100	LIST_PARSE = 0	! Failure -- Syntax errorn  	RETURN  a)  110	LIST_PARSE = 2	! Failure -- OverflowL  x *2DF  	END									T *2Ei *2It  	END									   *2En6  	INTEGER FUNCTION DETAB(IN_STRING,OUT_STRING,OUT_LEN)  u  **l>  *	LOGICAL FUNCTION DETAB ( in_string , out_string , out_len )  *  *E  *	Transforms the input character  string  IN_STRING  to  the  output,E  *	string  OUT_STRING  by  converting ASCII tab characters to blanks.aE  *	The output argument OUT_LEN is set to the  last  valid  column  ofn  *	OUT_STRING.  *E  *	If any tabs are present in IN_STRING, its length must be less thanc<  *	the length of OUT_STRING, or else an overflow will occur.  *E  *	The functional result will be .TRUE. unless an overflow has occur- E  *	red.   A  .FALSE.  result  means that one or more tabs did not geteE  *	converted to blanks; no characters will be missing from the end ofT  *	OUT_STRING.  *E  *	The standard VAX/VMS tab column spacing scheme is assumed, and theKE  *	IN_STRING's first column is assumed to be column 1 of this scheme.N  *,  *	The input and output strings may overlap.  *  *	.INDEX STRING MANIPULATION>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	31 Mar 1984	   Dahlgren, Virginia  22448(  *  .  	IMPLICIT INTEGER (A-Z)   %  	CHARACTER*(*) IN_STRING, OUT_STRING      	CHARACTER*1 TABL  t  	PARAMETER ( TAB = CHAR(9) )L  C#  	CHARACTER*8 BLANKS / '        ' /1  D  	DETAB = .TRUE.  	START = 1L  )  	IN_LEN  = LEN(IN_STRING)  	OUT_LEN = IN_LEN   *  	IF (%LOC(OUT_STRING).NE.%LOC(IN_STRING)).  	1			       OUT_STRING(1:OUT_LEN) = IN_STRING  	3  10	COL = SUBINDEX(OUT_STRING(1:OUT_LEN),START,TAB).  i  	IF (COL.EQ.0) RETURN  N  	COUNT = 8 - MOD(COL-1,8)  R2  	IF ( OUT_LEN+COUNT-1 .GT. LEN(OUT_STRING) ) THEN  i$  	    DETAB = .FALSE.					! Overflow  	    RETURN  r  	ENDIFf   6  	OUT_STRING(COL:OUT_LEN+COUNT-1) = BLANKS(1:COUNT) //'  	1				       OUT_STRING(COL+1:OUT_LEN)*  t  	OUT_LEN = OUT_LEN + COUNT - 1*  e  	START = START + COUNTi     	GO TO 10	s  e  	ENDe#  	INTEGER FUNCTION MONTH_NUM(MONTH)r  r  **a&  *	INTEGER FUNCTION MONTH_NUM( month )  *  *E  *	Converts an alphabetic, three-character month (such as 'FEB', into(E  *	an integer month number (2 for 'FEB').   The alphabetic  month  iseE  *	passed  as  the argument  MONTH;  it can be upper, lower, or mixeds>  *	case.  The month number is returned as the function result.  *E  *	If the argument is not a valid month, the error SS$_IVTIME is sig-iE  *	nalled;  this will abort the  program unless  an exception handler_  *	has been defined.  *  *	.INDEX DATES>>f  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	20 Apr 1984	   Dahlgren, Virginia  22448e  *  b  	IMPLICIT INTEGER (A-Z)  a  	CHARACTER*3 MONTH,MONTH_  E@  	CHARACTER*36 MONTHS / 'JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC' /     	EXTERNAL SS$_IVTIMEe  D  	CALL STR$UPCASE(MONTH_,MONTH)r  ,,  	MONTH_NUM = (INDEX(MONTHS,MONTH_) + 2) / 3  Q1  	IF (MONTH_NUM.EQ.0) CALL LIB$SIGNAL(SS$_IVTIME)"     	END   	SUBROUTINE GO_WAIT(SECONDS)h  o  **n!  *	SUBROUTINE GO_WAIT ( seconds )   *  *E  *	Places the process in a wait state for  the  specified  number  ofeE  *	seconds.   The  process  will show up as being in HIB state in theAE  *	SHOW SYSTEM and MONITOR displays.  The program will become  activeh   *	prematurely if an AST occurs.  *0  *	See also routines TIMER_SET and TIMER_CANCEL.  *?  *	 4 Jan 86	Hibernate,  instead of waiting for event flag,  so   *			it is easier to cancel.  *  *	.INDEX PROCESS CONTROL>>p  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	14 Nov 1983	   Dahlgren, Virginia  22448w  *  *  .  	IMPLICIT INTEGER (A-Z)     	INTEGER*4 DAYTIME(2)  U,  	CALL LIB$EMUL(-SECONDS,10000000,0,DAYTIME)  N!  	STATUS = SYS$SCHDWK(,,DAYTIME,)e  t.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  /  	CALL GO_HIBERNATEN  M  	END /  	SUBROUTINE DECLARE_EXIT_HANDLER(ROUTINE,ARGS)l  e  **uE  *	SUBROUTINE DECLARE_EXIT_HANDLER( routine , [arg2] , ... , [arg9] )   *  *E  *	Enables an 'exit handler' routine,  which is a subroutine providedIE  *	by the user, which VMS calls when the image exits.   More than one*E  *	exit handler can be enabled; at exit time, they are called in rev- E  *	erse order of enabling.  Using DECLARE_EXIT_HANDLER, up to ten ex-   *	it handlers can be enabled.  *E  *	Argument ROUTINE is the name of the subroutine to be enabled as anTE  *	exit handler.  Remember to declare this name EXTERNAL in the call-I  *	ing routine.N  *E  *	The first argument  passed to an exit handler subroutine is alwaysIE  *	the longword VMS condition value  giving the reason for exit.   UpeE  *	to eight  other arguments can  optionally be specified.   RememberUE  *	that if variables are  specified as arguments,  values passed will E  *	be the values  at program  exit time,  not the values  at the timeO#  *	DECLARE_EXIT_HANDLER was called.n  *E  *	If the program decides,  before exiting,  that an exit handler  isoE  *	no longer needed, it can call CANCEL_EXIT_HANDLER  to tell VMS nota  *	to call the exit handler.  *  *	.INDEX PROCESS CONTROL>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	29 Apr 1985	   Dahlgren, Virginia  22448l  *  h  	IMPLICIT INTEGER (A-Z)   !  	INTEGER*4 DESBLK(12,10),STATUS_e  b *2Ir  	INTEGER*4 IARGPTR   S *2Es  	EXTERNAL ROUTINE  I2  	DATA N / 0 /		! Number of exit handlers declared  N  	N = MIN(N+1,10)o     	DESBLK(2,N) = %LOC(ROUTINE)	  D *2Di  	DESBLK(3,N) = MIN(9,NARGS()) *2ES *2Iu-  	DESBLK(3,N) = MIN(9,NARGS(%VAL(IARGPTR())))  *2EO  N  	DESBLK(4,N) = %LOC(STATUS_)E  T  	IF (DESBLK(3,N).GT.1) THEN     	    DO I=2,DESBLK(3,N)  r *2D	!  		DESBLK(I+3,N) = ARG_ADDRESS(I)g *2EV *2Ii1  		DESBLK(I+3,N) = ARG_ADDRESS(%VAL(IARGPTR()),I)  *2EA  I  	    ENDDOL  L  	ENDIF   N#  	STATUS_ = SYS$DCLEXH(DESBLK(1,N))     *2D /  	IF (.NOT.STATUS_) CALL LIB$STOP(%VAL(STATUS)). *2EI *2II0  	IF (.NOT.STATUS_) CALL LIB$STOP(%VAL(STATUS_)) *2E!  t  	RETURN  n  	  U$  	ENTRY CANCEL_EXIT_HANDLER(ROUTINE)  n  ** ,  *	SUBROUTINE CANCEL_EXIT_HANDLER( routine )  *  *E  *	Cancels the enabling of an  exit handler routine  which was previ-ME  *	ously enabled by calling routine  DECLARE_EXIT_HANDLER.   ArgumentnE  *	ROUTINE is the name of the exit handler subroutine to be disabled.eA  *	Remember to declare this name EXTERNAL in the calling routine.1  *5  *	See routine DECLARE_EXIT_HANDLER for more details.n  *  *	.INDEX PROCESS CONTROL>>0  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	29 Apr 1985	   Dahlgren, Virginia  22448L  *  *
  	DO I=1,N  e,  	    IF (DESBLK(2,I).EQ.%LOC(ROUTINE)) THEN  t$  		STATUS_ = SYS$CANEXH(DESBLK(1,I))  e *2DT0  		IF (.NOT.STATUS_) CALL LIB$STOP(%VAL(STATUS)) *2EL *2I,1  		IF (.NOT.STATUS_) CALL LIB$STOP(%VAL(STATUS_))r *2Ee  i  		DESBLK(2,I) = 0  e  	    ENDIFI  2  	ENDDOi  e  	NEW_N = 0m  7
  	DO I=1,N  r%  	    IF (DESBLK(2,I).NE.0) NEW_N = Ii  p  	ENDDOs  r  	N = NEW_Na  I  	ENDi *2Dr$  !	SUBROUTINE WHICH_VAX(NAME,LENGTH)  !  !**+  !*	SUBROUTINE WHICH_VAX( name , [length] )S  !*t  !* F  !*	Determines which TOMAHAWK VAX we are on,  by examining the logical  !*	name 'VAX'.i  !*lF  !*	If the name is defined,  its equivalence name is returned  as  theF  !*	first argument,  and if the second argument is present, the length!  !*	of the name is returned here.c  !*g5  !*	The name will be something like 'OFS VAX-11/782'.I  !*RF  !*	If the name is not defined,  the  first  argument  will  be set toA  !*	blanks and, if present, the second argument will be set to 1.*  !*	  !*	.INDEX ENVIRONMENT>>  !*L3  !*	Alan L. Zirkle     Naval Surface Warfare Center   !*			   Code K53g,  !*	26 Oct 1983	   Dahlgren, Virginia  22448  !*e  !  !	IMPLICIT INTEGER (A-Z)T  !  !	CHARACTER*(*) NAMEt  !  !	LOGICAL ARG_EXIST  !  !	EXTERNAL SS$_NOTRAN  !3  !	STATUS = SYS$TRNLOG( 'VAX' , LENGTH_ , NAME ,,,)   !  !	IF (.NOT.STATUS) THEN  !$  !	    CALL LIB$STOP( %VAL(STATUS) )  !,  !	ELSE IF (STATUS.EQ.%LOC(SS$_NOTRAN)) THEN  !  !	    NAME = ' '   !  !	    LENGTH_ = 1  !  !	ENDIF  !%  !	IF (ARG_EXIST(2)) LENGTH = LENGTH_)  !  !	END *2EL.  	SUBROUTINE DAY_OF_WEEK(TODAY,LENGTH,DAYTIME)  U  **I:  *	SUBROUTINE DAY_OF_WEEK( today , [length]  , [daytime] )  *  *E  *	Sets the character string TODAY to the name of the current day  ofrE  *	the week, in capital letters.   If the optional argument LENGTH is 0  *	present, it is set to the length of the name.  *E  *	If the optional argument DAYTIME is present, it must be a quadwordCE  *	system binary time; the day of the week of this time is  returned,T*  *	instead of the current day of the week.  *  *	.INDEX DATES>>T  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	4 Oct 1983	   Dahlgren, Virginia  22448  *  F  	IMPLICIT INTEGER (A-Z)  L  	CHARACTER*(*) TODAYf  	CHARACTER*10 DAYS(0:6)  L  	INTEGER*4 LENGTH  	INTEGER*4 DAYTIME(2)  m  	LOGICAL ARG_EXIST  *2I	  	INTEGER*4 IARGPTRT *2E	  u9  	DATA DAYS / 'WEDNESDAY','THURSDAY','FRIDAY','SATURDAY',a$  	1				'SUNDAY','MONDAY','TUESDAY' /    *2D	  	IF (ARG_EXIST(3)) THEN *2E) *2I	(  	IF (ARG_EXIST(%VAL(IARGPTR()),3)) THEN *2EN  	   	    CALL LIB$DAY(IDAY,DAYTIME)     	ELSE  N  	    CALL LIB$DAY(IDAY)  1  	ENDIF   T  	IDAY=MOD(IDAY,7)  '  	TODAY=DAYS(IDAY)    *2DTB  	IF (ARG_EXIST(2)) LENGTH=MIN(LEN(TODAY),INDEX(DAYS(IDAY),' ')-1) *2Eh *2I?R  	IF (ARG_EXIST(%VAL(IARGPTR()),2)) LENGTH=MIN(LEN(TODAY),INDEX(DAYS(IDAY),' ')-1) *2ES  N  	ENDT%  	SUBROUTINE BANNER_LINE(UNIT,STRING)L  H  ** +  *	SUBROUTINE BANNER_LINE ( unit , string ).  *  *6  *	Prints a 'banner line' on FORTRAN file number UNIT.  *E  *	The banner line consists of the contents  of  STRING  (up  to  tenLE  *	characters)  printed  in large letters across the page.  Each let-OE  *	ter is 14 print lines tall and thirteen  columns  wide  (includingCE  *	inter-letter spacing).   Two  blank  lines  are printed before theTE  *	banner, and two are printed after.  all lines are printed at eightL1  *	lines per inch (on PRINTRONIX/LXYnn printers).   *E  *	If an asterisk appears in STRING, then that banner  position  will E  *	contain, instead of the asterisk, a block giving the date and timeG  *	of the run.  *2  *	The characters which can appear in banners are:  *+  *		alphabetic characters (upper case only)   *  *		numeric characters  *1  *		special characters  (  )  [  ]  .  -  /  $  _n  *  *		asterisk (see above)  *E  *	You do not have to physically set the printer to 8  lpi;  this  ismE  *	done under  program control.   The 8 lpi printing will cause pagessE  *	containing banners to be prematurely ejected at  the  end  of  ther  *	page.  *  *	 3 May 1988	Add "$" and "_".w  *  *	.INDEX BANNERS>>v  *	.INDEX PRINTING>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	1 Jul 1982	   Dahlgren, Virginia  22448  *  r  	IMPLICIT INTEGER (A-Z)  .(  	CHARACTER*13 PATTERN(14,48),OUTPUT(10)  	CHARACTER*130 BUFFER(14)%  	CHARACTER*1 SYMBOL,PRINTRONIX_8_LPIa%  	CHARACTER*9 DATE_STRING,TIME_STRING   	CHARACTER*(*) STRING     	INTEGER POINTER(0:127)  	LOGICAL CENTER,PRINT  O  	COMMON /CENTER_/ CENTER    ?  	DATA POINTER / 32*0,0,3*0,45,3*0,41,42,48,2*0,40,43,37,27,28, :  	1	       29,30,31,32,33,34,35,36,0,44,5*0,1,2,3,4,5,6,7,9  	2	       8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,E8  	3	       24,25,26,38,0,39,0,46,0,1,2,3,4,5,6,7,8,9,10,8  	4	       11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,  	5	       26,5*0 /   E  N1  	DATA (PATTERN(I,01),I=1,14) /	'             ' ,R  	1				'     MM      ' ,  	1				'    MMMM     ' ,  	1				'   MMMMMM    ' ,  	1				'  MMMM MMM   ' ,  	1				' MMMM   MMM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMMMMMMMMM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				'MMMMM   MMMM ' ,  	1				'             ' /  T1  	DATA (PATTERN(I,02),I=1,14) /	'             ' ,U  	1				'MMMMMMMMM    ' ,  	1				' MMM   MMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM   MMM   ' ,  	1				' MMMMMMMM    ' ,  	1				' MMM   MMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM   MMM   ' ,  	1				'MMMMMMMMM    ' ,  	1				'             ' /  l1  	DATA (PATTERN(I,03),I=1,14) /	'             ' ,M  	1				'    MMMMMM   ' ,  	1				'   MMMMMMMM  ' ,  	1				'  MMM     M  ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				'  MMM     M  ' ,  	1				'   MMMMMMMM  ' ,  	1				'    MMMMMM   ' ,  	1				'             ' /  a1  	DATA (PATTERN(I,04),I=1,14) /	'             ' ,a  	1				'MMMMMMMM     ' ,  	1				' MMM  MMM    ' ,  	1				' MMM   MMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM   MMM   ' ,  	1				' MMM  MMM    ' ,  	1				'MMMMMMMM     ' ,  	1				'             ' /  N1  	DATA (PATTERN(I,05),I=1,14) /	'             ' ,B  	1				'MMMMMMMMMMM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM  MM     ' ,  	1				' MMMMMMM     ' ,  	1				' MMM  MM     ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				'MMMMMMMMMMM  ' ,  	1				'             ' /   1  	DATA (PATTERN(I,06),I=1,14) /	'             ' ,   	1				'MMMMMMMMMMM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM  MM     ' ,  	1				' MMMMMMM     ' ,  	1				' MMM  MM     ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				'MMMMM        ' ,  	1				'             ' /  W1  	DATA (PATTERN(I,07),I=1,14) /	'             ' ,P  	1				'    MMMMMM   ' ,  	1				'   MMMMMMMM  ' ,  	1				'  MMM     M  ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM   MMMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				'  MMM   MMM  ' ,  	1				'   MMMMMMMM  ' ,  	1				'    MMMMMM   ' ,  	1				'             ' /  e1  	DATA (PATTERN(I,08),I=1,14) /	'             ' ,c  	1				'MMMMM  MMMMM ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMMMMMMMMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				'MMMMM  MMMMM ' ,  	1				'             ' /  b1  	DATA (PATTERN(I,09),I=1,14) /	'             ' ,a  	1				'  MMMMMMMM   ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'  MMMMMMMM   ' ,  	1				'             ' /   1  	DATA (PATTERN(I,10),I=1,14) /	'             ' ,   	1				'       MMMMM ' ,  	1				'        MMM  ' ,  	1				'        MMM  ' ,  	1				'        MMM  ' ,  	1				'        MMM  ' ,  	1				'        MMM  ' ,  	1				'        MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				'  MMM  MMM   ' ,  	1				'   MMMMMM    ' ,  	1				'    MMMM     ' ,  	1				'             ' /   1  	DATA (PATTERN(I,11),I=1,14) /	'             ' ,b  	1				'MMMMM   MMMM ' ,  	1				' MMM     MM  ' ,  	1				' MMM    MM   ' ,  	1				' MMM   MM    ' ,  	1				' MMM  MM     ' ,  	1				' MMM MMMM    ' ,  	1				' MMMMMMMM    ' ,  	1				' MMMM MMMM   ' ,  	1				' MMM   MMM   ' ,  	1				' MMM   MMMM  ' ,  	1				' MMM    MMM  ' ,  	1				'MMMMM   MMMM ' ,  	1				'             ' /  g1  	DATA (PATTERN(I,12),I=1,14) /	'             ' ,A  	1				'MMMMM        ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				'MMMMMMMMMMM  ' ,  	1				'             ' /   1  	DATA (PATTERN(I,13),I=1,14) /	'             ' ,   	1				'MMMM     MMM ' ,  	1				' MMMM   MMM  ' ,  	1				' MMMMM MMMM  ' ,  	1				' MMMMMMMMMM  ' ,  	1				' MMMMMMMMMM  ' ,  	1				' MMM MMM MM  ' ,  	1				' MMM  M  MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				'MMMMM   MMMM ' ,  	1				'             ' /  A1  	DATA (PATTERN(I,14),I=1,14) /	'             ' ,	  	1				'MMMM    MMMM ' ,  	1				' MMMM    MM  ' ,  	1				' MMMMM   MM  ' ,  	1				' MMMMMM  MM  ' ,  	1				' MM MMMM MM  ' ,  	1				' MM  MMMMMM  ' ,  	1				' MM   MMMMM  ' ,  	1				' MM    MMMM  ' ,  	1				' MM     MMM  ' ,  	1				' MM      MM  ' ,  	1				' MM       M  ' ,  	1				'MMMM      M  ' ,  	1				'             ' /  I1  	DATA (PATTERN(I,15),I=1,14) /	'             ' ,r  	1				'  MMMMMMMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				'  MMMMMMMM   ' ,  	1				'             ' /  m1  	DATA (PATTERN(I,16),I=1,14) /	'             ' ,   	1				'MMMMMMMMM    ' ,  	1				' MMM   MMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM   MMM   ' ,  	1				' MMMMMMMM    ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,  	1				'MMMMM        ' ,  	1				'             ' /  k1  	DATA (PATTERN(I,17),I=1,14) /	'             ' ,   	1				'  MMMMMMMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM MM MMM  ' ,  	1				' MMM MM MMM  ' ,  	1				' MMM  MMMMM  ' ,  	1				'  MMMMMMMM   ' ,  	1				'        MMM  ' /  A1  	DATA (PATTERN(I,18),I=1,14) /	'             ' ,_  	1				'MMMMMMMMM    ' ,  	1				' MMM   MMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM   MMM   ' ,  	1				' MMMMMMMM    ' ,  	1				' MMM MMM     ' ,  	1				' MMM  MMM    ' ,  	1				' MMM   MMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM     MMM ' ,  	1				'MMMMM     MM ' ,  	1				'             ' /  E1  	DATA (PATTERN(I,19),I=1,14) /	'             ' ,e  	1				'   MMMMMM    ' ,  	1				'  MMMMMMMM   ' ,  	1				' MMMM   MMM  ' ,  	1				' MMM     MM  ' ,  	1				'  MMMM       ' ,  	1				'   MMMMM     ' ,  	1				'    MMMMM    ' ,  	1				'      MMMM   ' ,  	1				' M     MMMM  ' ,  	1				' MM   MMMMM  ' ,  	1				' MMMMMMMMM   ' ,  	1				' MMMMMMM     ' ,  	1				'             ' /   1  	DATA (PATTERN(I,20),I=1,14) /	'             ' ,*  	1				' MMMMMMMMMMM ' ,  	1				' M   MMM   M ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'    MMMMM    ' ,  	1				'             ' /   1  	DATA (PATTERN(I,21),I=1,14) /	'             ' ,N  	1				'MMMMM   MMMM ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMMMMMMMMM  ' ,  	1				'  MMMMMMMM   ' ,  	1				'             ' /  T1  	DATA (PATTERN(I,22),I=1,14) /	'             ' ,t  	1				'MMMMM   MMMM ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMMM   MMM  ' ,  	1				'  MMM   MM   ' ,  	1				'  MMMM MMM   ' ,  	1				'   MMMMMM    ' ,  	1				'   MMMMMM    ' ,  	1				'    MMMM     ' ,  	1				'    MMMM     ' ,  	1				'     MM      ' ,  	1				'     MM      ' ,  	1				'             ' /  *1  	DATA (PATTERN(I,23),I=1,14) /	'             ' ,p  	1				'MMMMM   MMMM ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM  M  MM  ' ,  	1				' MMM MM  MM  ' ,  	1				' MMM MM  MM  ' ,  	1				' MMMMMMMMMM  ' ,  	1				'  MMMMMMMM   ' ,  	1				'  MMMM MMM   ' ,  	1				'   MM  MM    ' ,  	1				'   MM  MM    ' ,  	1				'             ' /  *1  	DATA (PATTERN(I,24),I=1,14) /	'             ' ,s  	1				'MMMMM   MMMM ' ,  	1				' MMM     MM  ' ,  	1				'  MMM   MM   ' ,  	1				'   MMM MM    ' ,  	1				'    MMMM     ' ,  	1				'    MMM      ' ,  	1				'     MMM     ' ,  	1				'    MMMM     ' ,  	1				'   MM MMM    ' ,  	1				'  MM   MMM   ' ,  	1				' MM     MMM  ' ,  	1				'MMMM   MMMMM ' ,  	1				'             ' /   1  	DATA (PATTERN(I,25),I=1,14) /	'             ' ,r  	1				'MMMMM  MMMM  ' ,  	1				' MMM    MM   ' ,  	1				' MMM    MM   ' ,  	1				'  MMM  MM    ' ,  	1				'  MMM  MM    ' ,  	1				'   MMMMM     ' ,  	1				'   MMMMM     ' ,  	1				'    MMM      ' ,  	1				'    MMM      ' ,  	1				'    MMM      ' ,  	1				'    MMM      ' ,  	1				'   MMMMM     ' ,  	1				'             ' /   1  	DATA (PATTERN(I,26),I=1,14) /	'             ' ,E  	1				' MMMMMMMMMM  ' ,  	1				' MM    MMM   ' ,  	1				'      MMM    ' ,  	1				'      MMM    ' ,  	1				'     MMM     ' ,  	1				'     MMM     ' ,  	1				'    MMM      ' ,  	1				'    MMM      ' ,  	1				'   MMM       ' ,  	1				'  MMM    MM  ' ,  	1				' MMM     MM  ' ,  	1				'MMMMMMMMMMM  ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,27),I=1,14) /	'             ' ,	  	1				'     888     ' ,  	1				'    88888    ' ,  	1				'   888 888   ' ,  	1				'  888   888  ' ,  	1				'  888   888  ' ,  	1				'  888   888  ' ,  	1				'  888   888  ' ,  	1				'  888   888  ' ,  	1				'  888   888  ' ,  	1				'   888 888   ' ,  	1				'    88888    ' ,  	1				'     888     ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,28),I=1,14) /	'             ' ,	  	1				'      88     ' ,  	1				'     888     ' ,  	1				'    8888     ' ,  	1				'   88888     ' ,  	1				'  888888     ' ,  	1				'    8888     ' ,  	1				'    8888     ' ,  	1				'    8888     ' ,  	1				'    8888     ' ,  	1				'    8888     ' ,  	1				'    8888     ' ,  	1				'   888888    ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,29),I=1,14) /	'             ' ,	  	1				'   888888    ' ,  	1				'  88888888   ' ,  	1				'  8    8888  ' ,  	1				'        888  ' ,  	1				'        888  ' ,  	1				'      8888   ' ,  	1				'    8888     ' ,  	1				'   8888      ' ,  	1				'  8888       ' ,  	1				' 8888        ' ,  	1				' 8888888888  ' ,  	1				' 8888888888  ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,30),I=1,14) /	'             ' ,	  	1				'  888888     ' ,  	1				' 88888888    ' ,  	1				' 8     888   ' ,  	1				'        888  ' ,  	1				'       888   ' ,  	1				'     8888    ' ,  	1				'       888   ' ,  	1				'        888  ' ,  	1				'        888  ' ,  	1				' 8     888   ' ,  	1				' 88888888    ' ,  	1				'  888888     ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,31),I=1,14) /	'             ' ,	  	1				'       888   ' ,  	1				'      8888   ' ,  	1				'     88888   ' ,  	1				'    888888   ' ,  	1				'   888 888   ' ,  	1				'  888  888   ' ,  	1				'  888  888   ' ,  	1				' 888   888   ' ,  	1				' 8888888888  ' ,  	1				'       888   ' ,  	1				'       888   ' ,  	1				'      88888  ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,32),I=1,14) /	'             ' ,	  	1				' 8888888888  ' ,  	1				' 888         ' ,  	1				' 888         ' ,  	1				' 888         ' ,  	1				' 88888888    ' ,  	1				' 888888888   ' ,  	1				'        888  ' ,  	1				'         888 ' ,  	1				'         888 ' ,  	1				' 8      888  ' ,  	1				' 8888888888  ' ,  	1				'  88888888   ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,33),I=1,14) /	'             ' ,	  	1				'         88  ' ,  	1				'       888   ' ,  	1				'     888     ' ,  	1				'    888      ' ,  	1				'   888       ' ,  	1				'  888888     ' ,  	1				' 8888  888   ' ,  	1				' 888    888  ' ,  	1				' 888    888  ' ,  	1				'  888  888   ' ,  	1				'   888888    ' ,  	1				'    8888     ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,34),I=1,14) /	'             ' ,	  	1				' 8888888888  ' ,  	1				' 88    8888  ' ,  	1				'       888   ' ,  	1				'      8888   ' ,  	1				'      888    ' ,  	1				'     8888    ' ,  	1				'     888     ' ,  	1				'    8888     ' ,  	1				'    888      ' ,  	1				'   8888      ' ,  	1				'   888       ' ,  	1				'   888       ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,35),I=1,14) /	'             ' ,	  	1				'    88888    ' ,  	1				'   888 888   ' ,  	1				'  888   888  ' ,  	1				'  888   888  ' ,  	1				'   888 888   ' ,  	1				'    88888    ' ,  	1				'   8888888   ' ,  	1				'  888   888  ' ,  	1				' 888     888 ' ,  	1				'  888   888  ' ,  	1				'   8888888   ' ,  	1				'    88888    ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,36),I=1,14) /	'             ' ,	  	1				'    8888     ' ,  	1				'   888888    ' ,  	1				'  888  888   ' ,  	1				' 888    888  ' ,  	1				' 888    888  ' ,  	1				'  888  8888  ' ,  	1				'    888888   ' ,  	1				'      888    ' ,  	1				'     888     ' ,  	1				'    888      ' ,  	1				'  888        ' ,  	1				' 88          ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,37),I=1,14) /	'        MMM  ' ,	  	1				'        MMM  ' ,  	1				'       MMM   ' ,  	1				'      MMM    ' ,  	1				'      MMM    ' ,  	1				'     MMM     ' ,  	1				'    MMM      ' ,  	1				'    MMM      ' ,  	1				'   MMM       ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				' MMM         ' ,  	1				'MMM          ' ,  	1				'MMM          ' /  	1  	DATA (PATTERN(I,38),I=1,14) /	'  MMMMMMM    ' ,	  	1				'  MMMMMMM    ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMMMMMM    ' ,  	1				'  MMMMMMM    ' /  	1  	DATA (PATTERN(I,39),I=1,14) /	'   MMMMMMM   ' ,	  	1				'   MMMMMMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'   MMMMMMM   ' ,  	1				'   MMMMMMM   ' /  	1  	DATA (PATTERN(I,40),I=1,14) /	'             ' ,	  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				' MMMMMMMMMM  ' ,  	1				' MMMMMMMMMM  ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,41),I=1,14) /	'     MMM     ' ,	  	1				'    MMM      ' ,  	1				'   MMM       ' ,  	1				'   MMM       ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'  MMM        ' ,  	1				'   MMM       ' ,  	1				'   MMM       ' ,  	1				'    MMM      ' ,  	1				'     MMM     ' /  	1  	DATA (PATTERN(I,42),I=1,14) /	'    MMM      ' ,	  	1				'     MMM     ' ,  	1				'      MMM    ' ,  	1				'      MMM    ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'       MMM   ' ,  	1				'      MMM    ' ,  	1				'      MMM    ' ,  	1				'     MMM     ' ,  	1				'    MMM      ' /  	1  	DATA (PATTERN(I,43),I=1,14) /	'             ' ,	  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'    MMMM     ' ,  	1				'   MMMMMM    ' ,  	1				'   MMMMMM    ' ,  	1				'    MMMM     ' ,  	1				'             ' /  	1  	DATA (PATTERN(I,44),I=1,14) /	'             ' ,	  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'    MMMM     ' ,  	1				'   MMMMMM    ' ,  	1				'    MMMM     ' ,  	1				'             ' ,  	1				'    MMMM     ' ,  	1				'   MMMMMM    ' ,  	1				'    MMMMM    ' ,  	1				'      MMM    ' ,  	1				'      MM     ' ,  	1				'     MM      ' /  	1  	DATA (PATTERN(I,45),I=1,14) /	'     MM      ' ,	  	1				'    MMMM     ' ,  	1				'  MMMMMMMM   ' ,  	1				' MM  MM MMM  ' ,  	1				' MM  MM  MM  ' ,  	1				'  MMMMM      ' ,  	1				'    MMM      ' ,  	1				'     MMMM    ' ,  	1				'     MMMMM   ' ,  	1				' M   MM MMM  ' ,  	1				' MM  MM MMM  ' ,  	1				'  MMMMMMMM   ' ,  	1				'    MMMM     ' ,  	1				'     MM       ' /   A1  	DATA (PATTERN(I,46),I=1,14) /	'             ' ,	  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				' MMMMMMMMMMM ' ,  	1				' MMMMMMMMMMM ' /  A1  	DATA (PATTERN(I,47),I=1,14) /	'             ' ,	  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' /  A1  	DATA (PATTERN(I,48),I=1,14) /	'             ' ,	  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' ,  	1				'             ' /  A  	DATA PRINTRONIX_8_LPI / 6 /   	DATA CENTER / .FALSE. /M     	PRINT = .TRUE.  M
  	GO TO 10  	  	  M   #  	ENTRY BANNER_ARRAY(BUFFER,STRING)   	  **M.  *	SUBROUTINE BANNER_ARRAY ( buffer , string )  *  *E  *	Similar to routine BANNER_LINE, except  that  the  banner  is  not'F  *	written  to  a  file;  it  is placed in the character string array $  *	BUFFER, which must be defined as:  *  *		CHARACTER*130 BUFFER(14)  *E  *	in the calling program.  The first byte of each element  DOES  NOT (  *	contain carriage control information.  *  *	.INDEX BANNERS>>	  *	.INDEX PRINTING>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53!  *			   Dahlgren, Virginia  22448'  *     	PRINT = .FALSE.M     10	CALL DATE(DATE_STRING)  	CALL TIME(TIME_STRING)  (  	IF (PRINT) THEN (  	    WRITE (UNIT,1000) PRINTRONIX_8_LPI(  	    WRITE (UNIT,1000) PRINTRONIX_8_LPI  	ENDIF   	
  	DO I=2,12,4 +  	    PATTERN(I,48)   = '  ' // DATE_STRINGM2  	    PATTERN(I+2,48) = '    ' // TIME_STRING(1:5)  	ENDDO,  	  	LOUT=1  	L=MIN(10,LEN(STRING))      	DO LINE=1,14     	    DO COL=1,L  	  		SYMBOL=STRING(COL:COL)'     		PTR=POINTER(ICHAR(SYMBOL))R  ,  		IF (PTR.NE.0) THEN    $  		    OUTPUT(COL)=PATTERN(LINE,PTR)  M  		ELSE   ,!  		    OUTPUT(COL)='            ''     		ENDIF     	    ENDDOM     	    TAB=3	   #  	    IF (CENTER) TAB=3+(10-L)*13/2'     	    IF (PRINT) THEN,  	7  		WRITE (UNIT,1000) PRINTRONIX_8_LPI,(OUTPUT(I),I=1,L)'  M
  	    ELSE  	.  		WRITE (BUFFER(LINE),1001) (OUTPUT(I),I=1,L)  	  	    ENDIFT  (  	ENDDO,     	IF (PRINT) THEN	(  	    WRITE (UNIT,1000) PRINTRONIX_8_LPI(  	    WRITE (UNIT,1000) PRINTRONIX_8_LPI  	ENDIF   8#  1000	FORMAT (1X,A1,:,T<TAB>,10A13)	  1001	FORMAT (T<TAB-2>,10A13)      	END' *2D	6  !      SUBROUTINE TRNLOG(lognam,devnam,dvsize,permdv)  !  !**=  !*	SUBROUTINE TRNLOG ( lognam , devnam , dvsize , [permdv] )	  !*'  !* @  !*	FROM DECUS FALL 81 TAPE, FILE [VAX81B.MUDD.TRNLOG]TRNLOG.FOR  !*	F  !*	This subroutine will convert the  logical  name  LOGNAM  into  theF  !*	final  device name DEVNAM (length DVSIZE) using the system serviceF  !*	routine SYS$TRNLOG until there is no  more  change  in  the  name.F  !*	PERMDV  is  an  optional  argument; logical variable PERMDV is setB  !*	to .TRUE. if and only if the file is a process-permanent file.  !*=  !*	.INDEX LOGICAL NAMES>>  !*	  !*	Modified by:  !*	3  !*	Alan L. Zirkle     Naval Surface Warfare Center	  !*			   Code K53 "  !*			   Dahlgren, Virginia  22448  !*8  !   !      logical permdv,arg_exist  !      integer i,dvsize  !      integer sys$trnlog#  !      character*(*) lognam,devnam8   !      character*64 name1,name2  !c	   !      parameter ss$_normal = 1*  !      parameter ss$_notran = '00000629'x  !c	*  !      if (arg_exist(4)) permdv = .false."  !      len1 = min(63,len(lognam))  !      name1 = lognam(1:len1)  !c 5  !c     convert the name until ss$_notran is returned,  !c	3  !10    i = sys$trnlog(name1(1:len1),len2,name2,,,)	2  !      if (name2(len2:len2).eq.':') len2 = len2-19  !d     type 2000,name1(1:len1),name2(1:len2),len1,len2,iAB  !d2000 format(' from = ',a,/,' to = ',a,/,' length = ',i5,'/',i5,  !d    1'  error status = ',z8)'$  !      if (i.eq.ss$_normal) goto 20%  !      if (i.ne.ss$_notran) goto 100'&  !      dvsize = min(len(devnam),len2)   !      devnam = name2(1:dvsize)0  !      if (ichar(name2(1:1)).ne.'1B'X) goto 200,  !      if (ichar(name2(2:2)).ne.0) goto 200  !      dvsize = dvsize-4/  !      devnam = name2(5:len2))  !      if (arg_exist(4)) permdv = .true.8  !      goto 200  !c 3  !20    i = sys$trnlog(name2(1:len2),len1,name1,,,) 9  !d     type 2000,name2(1:len2),name1(1:len1),len1,len2,i 2  !      if (name1(len1:len1).eq.':') len1 = len1-1$  !      if (i.eq.ss$_normal) goto 10%  !      if (i.ne.ss$_notran) goto 100 &  !      dvsize = min(len(devnam),len1)   !      devnam = name1(1:dvsize)0  !      if (ichar(name1(1:1)).ne.'1B'X) goto 200,  !      if (ichar(name1(2:2)).ne.0) goto 200  !      dvsize = dvsize-4   !      devnam = name1(5:len1))  !      if (arg_exist(4)) permdv = .true.8  !      goto 200  !c'1  !c     on erroneous return code, bomb out nicely'  !c   !100   continue  !c8  !c     all done, return  !c   !200   return  !	END *2E')  	SUBROUTINE CLUSTER_NODE(NODE_NAME,NLEN)      ** .  *	SUBROUTINE CLUSTER_NODE( node_name , nlen )  *  *C  *	Returns the VAXcluster node name  of the node on which this pro-8C  *	cess is running.   The name is returned  in the character string'C  *	argument  NODE_NAME, and the length  of the name  is returned in "  *	longword integer argument NLEN.  *  *	.INDEX ENVIRONMENT>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	17 Jun 1986	   Dahlgren, Virginia  22448   *  '  	IMPLICIT INTEGER (A-Z)  8'  	PARAMETER ( SYI$_NODENAME = '10D9'X )	  	  	CHARACTER*(*) NODE_NAME'  8  	INTEGER*4 ITMLST(4),IOSB(2)8  '5  	CALL ITEM_LIST(ITMLST,SYI$_NODENAME,NODE_NAME,NLEN)   	(  	STATUS = SYS$GETSYIW(,,,ITMLST,IOSB,,)  ,.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  60  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))  '  	END	,  	LOGICAL FUNCTION CLUSTER_MEMBER(NODE_NAME)  	  **'/  *	LOGICAL FUNCTION CLUSTER_MEMBER( node_name )	  *  *C  *	Returns an indication of whether the specified node is currently	C  *	a member of a VAXcluster.  The NODE_NAME argument is a character,C  *	string  which must  either be blank  (to check the node on whichTC  *	this is running)  or contain the name of the node  to be checked	C  *	(lower case and trailing blanks are allowed).   The node must be''  *	in the same VAXcluster as this node.   *>  *	11 Jun 87	Add blank argument option; allow trailing blanks.  *	'  *	.INDEX ENVIRONMENT>>'  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	17 Jun 1986	   Dahlgren, Virginia  224488  *  4  	IMPLICIT NONE   	  	CHARACTER*(*) NODE_NAME   	  	INTEGER SYI$_CLUSTER_MEMBER -  	PARAMETER ( SYI$_CLUSTER_MEMBER = '10CF'X )	     	CHARACTER*16 NODE	=  	INTEGER*4 NLEN,STR_LEN,ITMLST(4),IOSB(2),STATUS,SYS$GETSYIW   	LOGICAL FLAG  M  	EXTERNAL SS$_NOSUCHNODE      	NLEN = STR_LEN(NODE_NAME)'   )  	CALL STR$UPCASE(NODE(1:NLEN),NODE_NAME)   '1  	CALL ITEM_LIST(ITMLST,SYI$_CLUSTER_MEMBER,FLAG)      	IF (NODE_NAME.NE.' ') THEN  	8  	    STATUS = SYS$GETSYIW(,,NODE(1:NLEN),ITMLST,IOSB,,)     	ELSE   ,  	    STATUS = SYS$GETSYIW(,,,ITMLST,IOSB,,)  ,  	ENDIF'   )  	IF (STATUS.EQ.%LOC(SS$_NOSUCHNODE) .OR.	.  	1			   IOSB(1).EQ.%LOC(SS$_NOSUCHNODE)) THEN  	  	    CLUSTER_MEMBER = .FALSE.  M  	ELSE IF (.NOT.STATUS) THEN  '!  	    CALL LIB$STOP(%VAL(STATUS))4  	  	ELSE IF (.NOT.IOSB(1)) THEN    "  	    CALL LIB$STOP(%VAL(IOSB(1)))  	  	ELSE     	    CLUSTER_MEMBER = FLAG   ,  	ENDIF'     	END .  	INTEGER*4 FUNCTION TIMER_SET(SECONDS,AST,ID)     ** 7  *	INTEGER*4 FUNCTION TIMER_SET( seconds, ast [, id ] )	  *  *E  *	Queues a timer request  which will expire  in the specified number'E  *	of seconds.   When the timer expires, a subroutine provided by the	E  *	user is called at AST level.   The name of the subroutine is given E  *	as the AST argument  (remember to declare it EXTERNAL in the call-ME  *	ing routine).   The subroutine  is called  with one argument,  the	E  *	value of ID.  NOTE THAT THIS ARGUMENT  IS PASSED BY VALUE  TO YOUR   *	SUBROUTINE.  *E  *	The ID value  allows your subroutine  to tell which timer expired, E  *	when more than one is used.   It also allows a program to cancel a	E  *	timer  before it expires,  to prevent  the  subroutine  from being,E  *	called (see routine TIMER_CANCEL).  The ID can be any 32-bit inte-ME  *	ger.   If you omit the ID argument to TIMER_SET,  it will assign a E  *	value, beginning with 1000001 and incremented by one for each call	E  *	to TIMER_SET.   The ID value used is returned as the function res-'  *	ult.	  *  *	.INDEX PROCESS CONTROL>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53$  *	11 May 1987	   Dahlgren, Virginia  *		  	  	IMPLICIT NONE,  	  	INTEGER*4 SECONDS,ID  	EXTERNAL AST     	LOGICAL*4 ARG_EXIST  *2I,  	INTEGER*4 IARGPTR  *2E 7  	INTEGER*4 DEFAULT_ID,ID_,STATUS,SYS$SETIMR,SYS$CANTIM4  	REAL*8 VMSTIME  	  	DATA DEFAULT_ID / 1000000 /	  ',  	CALL LIB$EMUL(-SECONDS,10000000,0,VMSTIME)  	 *2D   	IF (ARG_EXIST(3)) THEN *2E  *2I,(  	IF (ARG_EXIST(%VAL(IARGPTR()),3)) THEN *2E   	    ID_ = ID  	ELSE!  	    DEFAULT_ID = DEFAULT_ID + 1	  	    ID_ = DEFAULT_ID  	ENDIF    -  	STATUS = SYS$SETIMR(,VMSTIME,AST,%VAL(ID_))   M.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))     	TIMER_SET = ID_	  '  	ENDM  	SUBROUTINE TIMER_CANCEL(ID)'     **	$  *	SUBROUTINE TIMER_CANCEL( [ id ] )  *  *E  *	Cancels a timer request  which has not  expired yet.   See the de- E  *	scription for  routine TIMER_SET for information on queueing timerM  *	requests.  *E  *	If the optional ID argument is omitted, then all outstanding timer E  *	requests by the program are cancelled.   If a 32-bit integer ID is E  *	supplied,  then only the timer request with this ID  is cancelled.'E  *	Using an ID for an  already-expired or non-existant request is not	2  *	considered an error; it is effectively a no-op.  *  *	.INDEX PROCESS CONTROL>>   *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53$  *	11 May 1987	   Dahlgren, Virginia  *	7  =  	IMPLICIT NONE      	INTEGER*4 ID   !  	INTEGER*4 ID_,STATUS,SYS$CANTIM,  	LOGICAL*4 ARG_EXIST' *2I	  	INTEGER*4 IARGPTR, *2E	  ' *2D   	IF (ARG_EXIST(1)) THEN *2E  *2I (  	IF (ARG_EXIST(%VAL(IARGPTR()),1)) THEN *2E'  	    ID_ = ID  	ELSE
  	    ID_ = 0   	ENDIF   ,!  	STATUS = SYS$CANTIM(%VAL(ID_),)'   .  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  (  	END(7  	INTEGER*4 FUNCTION INT$SET_SYMBOL(SYMBOL,VALUE,TABLE)'     **	>  *	INTEGER FUNCTION INT$SET_SYMBOL ( symbol , value [,table] )  *  *E  *	Creates a DCL symbol with an integer value.   This routine is much E  *	like LIB$SET_SYMBOL,  except that the VALUE argument is an integer E  *	longword value instead of a character string.  The SYMBOL argument'E  *	is the name of the symbol  to be defined,  and the optional  TABLEFE  *	argument  can be 1  to use the local symbol table  or 2 to use the 8  *	global symbol table (the default is the local table).  *E  *	This routine converts  the integer value to a character string andcE  *	calls LIB$SET_SYMBOL with that string.  The function result is thee$  *	return value from LIB$SET_SYMBOL.  *  *	.INDEX DCL SYMBOLS>>a  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	14 Jul 1987	   Dahlgren, Virginia  22448n  *  r  	IMPLICIT NONEo  t  	CHARACTER*(*) SYMBOL  	INTEGER*4 VALUER  	BYTE TABLE  A  	CHARACTER*16 WORKa  	INTEGER*4 W,LIB$SET_SYMBOL  	LOGICAL ARG_EXIST  *2Ir  	INTEGER*4 IARGPTR  *2E   	(  	CALL SYS$FAO('!UL',W,WORK,%VAL(VALUE))  N *2D	  	IF (ARG_EXIST(3)) THEN *2EF *2IN(  	IF (ARG_EXIST(%VAL(IARGPTR()),3)) THEN *2EL   =  	    INT$SET_SYMBOL = LIB$SET_SYMBOL(SYMBOL,WORK(1:W),TABLE)2  ,  	ELSE  A7  	    INT$SET_SYMBOL = LIB$SET_SYMBOL(SYMBOL,WORK(1:W))8     	ENDIF   E  	END(1  	INTEGER FUNCTION HOLIDAY(MONTH,DAY,DAY_OF_WEEK))     **	8  *	INTEGER FUNCTION HOLIDAY( month , day , day_of_week )  *E  *	Returns an indication of whether  the given day of the given month E  *	is a federal holiday or not.  Returns zero if it is not a holiday,(E  *	or a non-zero integer giving the holiday number (described below).   *E  *	The required integer input arguments are MONTH (1-12), DAY (1-31),	@  *	and DAY_OF_WEEK (1 = Sunday, 2 = Monday, ... , 7 = Saturday).  *6  *	The function result is one of the following values:  *  *		0 = Not a holiday,  *		1 = New Year's DayB  *	       -1 = Fri or Mon off when New Year's Day is on Sat or Sun%  *		2 = Martin Luther King's BirthdayO$  *		3 = George Birthington's Washday  *		4 = Memorial Day)  *		5 = Independence Day (Fourth of July)O  *		6 = Labor Dayi  *		7 = Columbus Day  *		8 = Veterans Day@  *	       -8 = Fri or Mon off when Veterans Day is on Sat or Sun  *		9 = Thanksgiving Day  *	       10 = Christmas DayA  *	      -10 = Fri or Mon off when Christmas Day is on Sat or Sunt  *  *	.INDEX DATES>>c  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	 7 Jul 1992	   Dahlgren, Virginia  22448   *     	IMPLICIT NONEn  p!  	INTEGER*4 MONTH,DAY,DAY_OF_WEEKP  D
  	HOLIDAY = 0o  R*  	GO TO (1,2,3,4,5,6,7,8,9,10,11,12),MONTH  e1  1	IF (DAY.EQ.1) HOLIDAY = 1			  ! New Year's Day!J  	IF (DAY.EQ.2 .AND. DAY_OF_WEEK.EQ.2) HOLIDAY = -1 ! New Year's Day (obs)  	IF (DAY_OF_WEEK.EQ.2) THEND  	    IF (DAY.GE.15 .AND. DAY.LE.21) HOLIDAY = 2	  ! King's Birthday  	ENDIFn  	RETURN  e  2	IF (DAY_OF_WEEK.EQ.2) THEN!I  	    IF (DAY.GE.15 .AND. DAY.LE.21) HOLIDAY = 3	 ! Washington's Birthday   	ENDIFa  	RETURN  o	  3	RETURN!   	  4	RETURN   _  5	IF (DAY_OF_WEEK.EQ.2) THEN 2  	    IF (DAY.GE.25) HOLIDAY = 4			 ! Memorial Day  	ENDIF						 !  (Last Monday)  	RETURN  m	  6	RETURN!   6  7	IF (DAY.EQ.3 .AND. DAY_OF_WEEK.EQ.6) HOLIDAY = -5 !2  	IF (DAY.EQ.4) HOLIDAY = 5			  ! Independence Day5  	IF (DAY.EQ.5 .AND. DAY_OF_WEEK.EQ.2) HOLIDAY = -5 !2  	RETURN  y	  8	RETURNe  :  9	IF (DAY_OF_WEEK.EQ.2) THENA.  	    IF (DAY.LE.7) HOLIDAY = 6			 ! Labor Day  	ENDIF,  	RETURN  !  10	IF (DAY_OF_WEEK.EQ.2) THEN?  	    IF (DAY.GE.8 .AND. DAY.LE.14) HOLIDAY = 7	 ! Columbus Day)  	ENDIF'  	RETURN  i9  11	IF (DAY.EQ.10 .AND. DAY_OF_WEEK.EQ.6) HOLIDAY = -8  !)2  	IF (DAY.EQ.11) HOLIDAY = 8			    ! Veterans' Day7  	IF (DAY.EQ.12 .AND. DAY_OF_WEEK.EQ.2) HOLIDAY = -8  !i  	IF (DAY_OF_WEEK.EQ.5) THEND  	    IF (DAY.GE.22 .AND. DAY.LE.28) HOLIDAY = 9	 ! Thanksgiving Day  	ENDIF   	RETURN   :  12	IF (DAY.EQ.24 .AND. DAY_OF_WEEK.EQ.6) HOLIDAY = -10  !3  	IF (DAY.EQ.25) HOLIDAY = 10			    ! Christmas Day 8  	IF (DAY.EQ.26 .AND. DAY_OF_WEEK.EQ.2) HOLIDAY = -10  !J  	IF (DAY.EQ.31 .AND. DAY_OF_WEEK.EQ.6) HOLIDAY = -1 !New Year's Day (obs)  	RETURN  d *2D)  	END									e *2E= *2I1  	END									 *2Ef