;  	INTEGER*4 FUNCTION TEXT_OPEN_INPUT_(UNIT,F_A,F_L,D_A,D_L)      ** @  *	INTEGER FUNCTION TEXT_OPEN_INPUT_( unit , fa , fl , da , dl )  *  *(  *	This is part of the Text I/O Package.  *E  *	This routine is not called by the user.   It is called by  routine E  *	TEXT_OPEN_INPUT.   This routine  opens  the file;  TEXT_OPEN_INPUT E  *	pre-processes the arguments  and passes five  items of data:   the E  *	integer unit number, the address of the string containing the file E  *	name,  the length of the string containing the file name,  the ad- E  *	dress of the string containing the default file name  (or zero, if E  *	no default file name,  and the length of the string containing the   *	default file name (or zero).   *?  *	See the description of TEXT_OPEN_INPUT for more information.   *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55 )  *	7 Sep 1989	  Dahlgren, Virginia  22448   *     	IMPLICIT NONE      	INCLUDE '($FABDEF)'   	INCLUDE '($RABDEF)'   	INCLUDE '($NAMDEF)'    &  	INTEGER*4 UNIT,F_A,D_A,LLEN,FLEN,RFA  	BYTE	  CC,F_L,D_L   	CHARACTER*(*) LINE,FILE    >  	INTEGER*4 TEXT_OPEN_OUTPUT_,TEXT_CLOSE,TEXT_READ,TEXT_WRITE,;  	1	  TEXT_FILE_NAME,TEXT_CC_TYPE,TEXT_VFC,TEXT_OPEN_ERROR, 2  	2	  TEXT_ERROR,TEXT_ERROR_HANDLER,TEXT_USEROPEN,(  	3	  TEXT_REWIND,TEXT_RFA,TEXT_READ_RFA   !  	CHARACTER*255 TEXT_FILES(10:13) -  	INTEGER*4 UNIT_,TFLEN(10:13),CC_TYPE(10:13)   	INTEGER*2 VFC(10:11)'  	LOGICAL*1 OPEN(10:13) / 4 * .FALSE. /      	RECORD /FABDEF/	FAB(10:13)  	RECORD /RABDEF/ RAB(10:13)  	RECORD /NAMDEF/ NAM      	INTEGER*4 STATUS,MSGVEC(5)  	INTEGER*4 ERROR_ROUTINE / 0 / "  	INTEGER*4 USEROPEN_ROUTINE / 0 /  	CHARACTER*255 TEXT_FILES_ERR   ;  	INTEGER*4 LBYTE,SYS$OPEN,SYS$CREATE,SYS$CONNECT,SYS$CLOSE 0  	INTEGER*4 SYS$GET,SYS$PUT,SYS$REWIND,LIB$CALLG  	EXTERNAL TEXT_MSG_FORMAT      ;  	IF (UNIT.LT.10 .OR. UNIT.GT.11 .OR. OPEN(UNIT)) GO TO 110    (  	CALL RMS_INIT(FAB(UNIT),RAB(UNIT),NAM)   5  	FAB(UNIT).FAB$B_SHR = FAB$M_SHRGET + FAB$M_SHRPUT + '  	1				     FAB$M_SHRDEL + FAB$M_SHRUPD   	FAB(UNIT).FAB$B_DNS = D_L   	FAB(UNIT).FAB$L_DNA = D_A   	FAB(UNIT).FAB$B_FNS = F_L   	FAB(UNIT).FAB$L_FNA = F_A !  	FAB(UNIT).FAB$L_FOP = FAB$M_SQO    5  	RAB(UNIT).RAB$L_RHB = %LOC(VFC(UNIT))	! VFC Support    .  	NAM.NAM$B_RSS = LBYTE(LEN(TEXT_FILES(UNIT)))(  	NAM.NAM$L_RSA = %LOC(TEXT_FILES(UNIT)),  	NAM.NAM$B_ESS = LBYTE(LEN(TEXT_FILES_ERR))&  	NAM.NAM$L_ESA = %LOC(TEXT_FILES_ERR)   @  	IF (USEROPEN_ROUTINE.NE.0) CALL TEXT_USEROPEN_(UNIT,FAB(UNIT),.  	1			       RAB(UNIT),NAM,1,USEROPEN_ROUTINE)     	STATUS = SYS$OPEN(FAB(UNIT))     	IF (STATUS) THEN%  	    STATUS = SYS$CONNECT(RAB(UNIT)) )  	    CC_TYPE(UNIT) = RAB(UNIT).RAB$L_STV   	ELSE)  	    CC_TYPE(UNIT) = FAB(UNIT).FAB$L_STV   	ENDIF      	TEXT_OPEN_INPUT_ = STATUS      	IF (.NOT.STATUS) THEN !  	    TFLEN(UNIT) = NAM.NAM$B_ESL '  	    TEXT_FILES(UNIT) = TEXT_FILES_ERR   	    USEROPEN_ROUTINE = 0  	    RETURN  	ENDIF      	TFLEN(UNIT) = NAM.NAM$B_RSL    ?  	STATUS = FAB(UNIT).FAB$B_RAT		! Compute carriage control type #  	STATUS = IAND(STATUS,'00000007'x)   	CC_TYPE(UNIT) = STATUS3  	IF (STATUS.EQ.1) CC_TYPE(UNIT) = 0	!  0 = Fortran 0  	IF (STATUS.EQ.2) CC_TYPE(UNIT) = 1	!  1 = List0  	IF (STATUS.EQ.0) CC_TYPE(UNIT) = 2	!  2 = None/  	IF (STATUS.EQ.4) CC_TYPE(UNIT) = 3	!  3 = VFC   	OPEN(UNIT) = .TRUE.    !  	IF (USEROPEN_ROUTINE.NE.0) THEN )  	    CALL TEXT_USEROPEN_(UNIT,FAB(UNIT), .  	1			       RAB(UNIT),NAM,2,USEROPEN_ROUTINE)  	    USEROPEN_ROUTINE = 0  	ENDIF      	RETURN         2  	ENTRY TEXT_OPEN_OUTPUT_(UNIT,CC,F_A,F_L,D_A,D_L)     ** E  *	INTEGER FUNCTION TEXT_OPEN_OUTPUT_( unit , c , fa , fl , da , dl )   *  *(  *	This is part of the Text I/O Package.  *E  *	This routine is not called by the user.   It is called by  routine E  *	TEXT_OPEN_OUTPUT.  This routine  opens the file;  TEXT_OPEN_OUTPUT E  *	pre-processes the arguments and passes six items of data:  the in- E  *	teger unit number, the integer carriage control type (default is 1 E  *	for LIST) the address of the string containing the file name,  the E  *	length of the string containing the file name,  the address of the E  *	string containing the default file name  (or zero,  if no  default E  *	file name,  and  the  length  of the string containing the default   *	file name (or zero).   *@  *	See the description of TEXT_OPEN_OUTPUT for more information.  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55 )  *	7 Sep 1989	  Dahlgren, Virginia  22448   *   :  	IF (UNIT.LT.12 .OR. UNIT.GT.13 .OR. CC.LT.0 .OR. CC.GT.2'  	1				      .OR. OPEN(UNIT)) GO TO 110    (  	CALL RMS_INIT(FAB(UNIT),RAB(UNIT),NAM)   !  	FAB(UNIT).FAB$B_RFM = FAB$C_VAR   	FAB(UNIT).FAB$B_DNS = D_L   	FAB(UNIT).FAB$L_DNA = D_A   	FAB(UNIT).FAB$B_FNS = F_L   	FAB(UNIT).FAB$L_FNA = F_A !  	FAB(UNIT).FAB$L_FOP = FAB$M_SQO       	FAB(UNIT).FAB$B_RAT = FAB$M_CR.  	IF (CC.EQ.0) FAB(UNIT).FAB$B_RAT = FAB$M_FTN&  	IF (CC.EQ.2) FAB(UNIT).FAB$B_RAT = 0   .  	NAM.NAM$B_RSS = LBYTE(LEN(TEXT_FILES(UNIT)))(  	NAM.NAM$L_RSA = %LOC(TEXT_FILES(UNIT)),  	NAM.NAM$B_ESS = LBYTE(LEN(TEXT_FILES_ERR))&  	NAM.NAM$L_ESA = %LOC(TEXT_FILES_ERR)   @  	IF (USEROPEN_ROUTINE.NE.0) CALL TEXT_USEROPEN_(UNIT,FAB(UNIT),.  	1			       RAB(UNIT),NAM,1,USEROPEN_ROUTINE)      	STATUS = SYS$CREATE(FAB(UNIT))     	IF (STATUS) THEN%  	    STATUS = SYS$CONNECT(RAB(UNIT)) )  	    CC_TYPE(UNIT) = RAB(UNIT).RAB$L_STV   	ELSE)  	    CC_TYPE(UNIT) = FAB(UNIT).FAB$L_STV   	ENDIF      	TEXT_OPEN_OUTPUT_ = STATUS     	IF (.NOT. STATUS) THEN!  	    TFLEN(UNIT) = NAM.NAM$B_ESL '  	    TEXT_FILES(UNIT) = TEXT_FILES_ERR   	    USEROPEN_ROUTINE = 0  	    RETURN  	ENDIF      	TFLEN(UNIT) = NAM.NAM$B_RSL   	CC_TYPE(UNIT) = CC  	OPEN(UNIT) = .TRUE.    !  	IF (USEROPEN_ROUTINE.NE.0) THEN )  	    CALL TEXT_USEROPEN_(UNIT,FAB(UNIT), .  	1			       RAB(UNIT),NAM,2,USEROPEN_ROUTINE)  	    USEROPEN_ROUTINE = 0  	ENDIF      	RETURN           	ENTRY TEXT_CLOSE(UNIT)     ** &  *	INTEGER FUNCTION TEXT_CLOSE( unit )  *  *(  *	This is part of the Text I/O Package.  *E  *	Closes the file previously  opened by routine  TEXT_OPEN_INPUT  or E  *	TEXT_OPEN_OUTPUT  on the specified unit,  which must be an integer E  *	10, 11, 12, or 13.  After the unit is closed, the same unit number *  *	may be re-used in opening another file.  *?  *	The function result will return the VMS status of the close.   *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55 )  *	7 Sep 1989	  Dahlgren, Virginia  22448   *   @  	IF (UNIT.LT.10 .OR. UNIT.GT.13 .OR. .NOT.OPEN(UNIT)) GO TO 110   #  	TEXT_CLOSE = SYS$CLOSE(FAB(UNIT))      	OPEN(UNIT) = .FALSE.     	RETURN           	ENTRY TEXT_REWIND(UNIT)      ** '  *	INTEGER FUNCTION TEXT_REWIND( unit )   *  *(  *	This is part of the Text I/O Package.  *E  *	Rewinds the file previously opened by routine  TEXT_OPEN_INPUT  or E  *	TEXT_OPEN_OUTPUT  on the specified unit,  which must be an integer   *	10, 11, 12, or 13.   *@  *	The function result will return the VMS status of the rewind.  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55 *  *	17 Sep 1991	  Dahlgren, Virginia  22448  *   @  	IF (UNIT.LT.10 .OR. UNIT.GT.13 .OR. .NOT.OPEN(UNIT)) GO TO 110   %  	TEXT_REWIND = SYS$REWIND(RAB(UNIT))      	RETURN         !  	ENTRY TEXT_READ(UNIT,LINE,LLEN)      ** 3  *	INTEGER FUNCTION TEXT_READ( unit , line , llen )   *  *(  *	This is part of the Text I/O Package.  *E  *	Reads one record from  the file previously opened on the specified F  *	unit by routine TEXT_OPEN_INPUT.  UNIT must be an integer 10 or 11.  *E  *	The function result will be a  TRUE  (odd)  value  if the read was E  *	successful, or a FALSE (even) value if end-of-file was encountered   *	and no record was read.  *E  *	The record is read into character string  LINE,  and the length is   *	returned in integer LLEN.  *E  *	If an error occurs while reading the record  (for  example  if the E  *	string LINE is too short to hold the record) then the program will E  *	abort with a meaningful message, unless routine TEXT_ERROR_HANDLER E  *	was previously called to set up an error handling routine; in this 2  *	case the error handling routine will be called.  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55 )  *	7 Sep 1989	  Dahlgren, Virginia  22448   *   @  	IF (UNIT.LT.10 .OR. UNIT.GT.11 .OR. .NOT.OPEN(UNIT)) GO TO 110   "  	RAB(UNIT).RAB$L_UBF = %LOC(LINE)!  	RAB(UNIT).RAB$W_USZ = LEN(LINE)       	TEXT_READ = SYS$GET(RAB(UNIT))     	LLEN = RAB(UNIT).RAB$W_RSZ     	IF (.NOT.TEXT_READ) THEN'  	    IF (TEXT_READ.EQ.'1827A'x) RETURN '  	    IF (ERROR_ROUTINE.NE.0) GO TO 100 >  	    CALL LIB$STOP(%VAL(TEXT_READ),%VAL(RAB(UNIT).RAB$L_STV))  	ENDIF      	RETURN     100	MSGVEC(1) = 3  	MSGVEC(2) = %LOC(UNIT)'  	MSGVEC(3) = %LOC(RAB(UNIT).RAB$L_STS) '  	MSGVEC(4) = %LOC(RAB(UNIT).RAB$L_STV) %  	MSGVEC(5) = UNIT			! For TEXT_ERROR    3  	TEXT_READ = LIB$CALLG(MSGVEC,%VAL(ERROR_ROUTINE))   	RETURN   6  110	CALL LIB$PUT_OUTPUT('%TEXT_PACKAGE-F-BADCALL, '//5  	1		     'the Text I/O package was used improperly')   	CALL EXIT('10000004'x)         )  	ENTRY TEXT_READ_RFA(UNIT,LINE,LLEN,RFA)      ** =  *	INTEGER FUNCTION TEXT_READ_RFA( unit , line , llen , rfa )   *  *(  *	This is part of the Text I/O Package.  *E  *	This is identical to routine TEXT_READ,  except that the RFA argu- E  *	ment specifies the  Record File Address  of the record to be read. D  *	This provides a basic form of random access to a sequential file.  *D  *	The RFA which is input to TEXT_READ_RFA must have been saved fromD  *	a previous call to TEXT_RFA.  Thus, to randomly access records ofD  *	the file,  the RFA of each record must have been previously saved2  *	when creating or sequentially reading the file.  *D  *	To use TEXT_READ_RFA, routine TEXT_USEROPEN must have been calledD  *	before opening the file, to specify a useropen routine.  The userD  *	must provide this routine,  which must zero out the FAB$M_SQO bitD  *	of the FAB$L_FOP field of the file's FAB before the file is open-  *	ed.  An example is:  *  *		EXTERNAL MYROUTINE#  *		CALL TEXT_USEROPEN( MYROUTINE )a   *		CALL TEXT_OPEN_INPUT(10, ...  *		...y/  *		SUBROUTINE MYROUTINE(UNIT,FAB,RAB,NAM,CODE)P  *		INCLUDE '($FABDEF)'   *		INTEGER*4 UNIT,RAB,NAM,CODE   *		RECORD /FABDEF/	FABg$  *		IF (CODE.EQ.1) FAB.FAB$L_FOP = 0  *		END   *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55 *  *	20 Oct 1992	  Dahlgren, Virginia  22448  *  s@  	IF (UNIT.LT.10 .OR. UNIT.GT.11 .OR. .NOT.OPEN(UNIT)) GO TO 110   "  	RAB(UNIT).RAB$L_UBF = %LOC(LINE)!  	RAB(UNIT).RAB$W_USZ = LEN(LINE)f!  	RAB(UNIT).RAB$B_RAC = RAB$C_RFAS  t+  	CALL LIB$MOVC3(6,RFA,RAB(UNIT).RAB$W_RFA)f  a$  	TEXT_READ_RFA = SYS$GET(RAB(UNIT))  A  	RAB(UNIT).RAB$B_RAC = 0a  W  	LLEN = RAB(UNIT).RAB$W_RSZ     	IF (.NOT.TEXT_READ_RFA) THEN'  	    IF (ERROR_ROUTINE.NE.0) GO TO 100 >  	    CALL LIB$STOP(%VAL(TEXT_READ),%VAL(RAB(UNIT).RAB$L_STV))  	ENDIF   	  	RETURN  T  A  A  	ENTRY TEXT_WRITE(UNIT,LINE),     **H-  *	INTEGER FUNCTION TEXT_WRITE( unit , line )E  *  *(  *	This is part of the Text I/O Package.  *E  *	Writes the contents of character string LINE as one record  on theXE  *	file previously opened by routine TEXT_OPEN_OUTPUT on the specifi-A5  *	ed unit number.  UNIT must be an integer 12 or 13.N  *E  *	If an error occurs while writing the line (for example if the disk1E  *	fills up),  then the program will abort with a meaningful message,DE  *	unless routine TEXT_ERROR_HANDLER  was previously called to set up)E  *	an error handling routine; in this case the error handling routine   *	will be called.  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare CenterN  *			  Code K55Y)  *	7 Sep 1989	  Dahlgren, Virginia  22448_  *  M@  	IF (UNIT.LT.12 .OR. UNIT.GT.13 .OR. .NOT.OPEN(UNIT)) GO TO 110  1!  	RAB(UNIT).RAB$W_RSZ = LEN(LINE)A"  	RAB(UNIT).RAB$L_RBF = %LOC(LINE)   !  	TEXT_WRITE = SYS$PUT(RAB(UNIT))	  	  	IF (.NOT.TEXT_WRITE) THENR'  	    IF (ERROR_ROUTINE.NE.0) GO TO 100(?  	    CALL LIB$STOP(%VAL(TEXT_WRITE),%VAL(RAB(UNIT).RAB$L_STV)).  	ENDIF   _  	RETURN  T  A  _&  	ENTRY TEXT_FILE_NAME(UNIT,FILE,FLEN)     **C2  *	SUBROUTINE TEXT_FILE_NAME( unit , file , flen )  *  *(  *	This is part of the Text I/O Package.  *E  *	This routine obtains the current file name of the specified  unit,$E  *	after  TEXT_OPEN_INPUT or TEXT_OPEN_OUTPUT has been called to openTE  *	the unit.  The unit number must be integer 10, 11, 12, or 13.  TheNE  *	file name is returned  in character string FILE, and the length ofTE  *	the name is returned in integer  FLEN.   String FILE should be 255TB  *	characters long to ensure that it can hold any valid file name.  *E  *	If the file open succeeded, the name returned will be the full ac-NE  *	tual name of the file.  If the open failed, the name returned willS@  *	be the full name of the file on which the open was attempted.  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55()  *	7 Sep 1989	  Dahlgren, Virginia  22448T  *  F+  	IF (UNIT.LT.10 .OR. UNIT.GT.13) GO TO 110a     	FLEN = TFLEN(UNIT)  	FILE = TEXT_FILES(UNIT)   F  	RETURN  )  _  E  	ENTRY TEXT_CC_TYPE(UNIT)  T  **E(  *	INTEGER FUNCTION TEXT_CC_TYPE( unit )  *  *(  *	This is part of the Text I/O Package.  *E  *	If called after a file has been opened by routine  TEXT_OPEN_INPUTNE  *	or TEXT_OPEN_OUTPUT, the function result of this routine is an in-UE  *	teger code  describing the type of carriage control which the file /  *	uses.  The code can be one of the following:   *  *			0   Fortran
  *			1   List*
  *			2   Nonef  *			3   VFC  *E  *	If called  after  a  failure  has occured in opening the file, the E  *	function result will be the RMS STV  value  generated by the fail-NE  *	ure.  This can be used in calls to LIB$STOP or LIB$SIGNAL to print   *	meaningful error messages.   *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55 )  *	7 Sep 1989	  Dahlgren, Virginia  22448n  *  i+  	IF (UNIT.LT.10 .OR. UNIT.GT.13) GO TO 110s  n  	TEXT_CC_TYPE = CC_TYPE(UNIT)     	RETURN        a  	ENTRY TEXT_VFC(UNIT)  h  **n$  *	INTEGER FUNCTION TEXT_VFC( unit )  *  *(  *	This is part of the Text I/O Package.  *E  *	This routine must only be called when reading a file using routine>E  *	TEXT_READ,  and then only when the file's carriage control type is5E  *	VFC.  The function result of this routine will be the VFC carriage2E  *	control  value  from the last record read.  The most common values)D  *	encountered (in hexadecimal), and their Fortran equivalents, are:  *2  *		8D01   blank - one LF+CR before line, CR after/  *		8D02	0    - two LF+CR before line, CR after$(  *		8D8C	1    - FF before line, CR after-  *		8D00	+    - nothing before line, CR after(4  *		0001	$    - one LF+CR before line, nothing after5  *		0000   nul   - nothing before line, nothing afterT  *E  *	See the VAX RMS manual for a full explanation of the fields in the +  *	value.  Note that the bytes are swapped.T  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare CenterN  *			  Code K55L)  *	7 Sep 1989	  Dahlgren, Virginia  22448   *  U  )8  	IF (UNIT.LT.10 .OR. UNIT.GT.11 .OR. CC_TYPE(UNIT).NE.3'  	1				  .OR. .NOT.OPEN(UNIT)) GOTO 110S  S  						! 8D02 = '0' %  	TEXT_VFC = VFC(UNIT)			! 8D8C = '1'_0  	TEXT_VFC = IAND(TEXT_VFC,'FFFF'x)	! 8D00 = '+'  						! 0001 = '$'   	RETURN					! 0000 = nulS     	  ('  	ENTRY TEXT_OPEN_ERROR(UNIT,LINE,FILE)A  A  **S:  *	SUBROUTINE TEXT_OPEN_ERROR( unit , keyword , filetype )  *  *(  *	This is part of the Text I/O Package.  *E  *	This routine is meant to be called  after routine  TEXT_OPEN_INPUT	E  *	or TEXT_OPEN_OUTPUT fails.  It puts out meaningful error messages,I9  *	and aborts the program.  Three arguments are required:   *E  *	     1. The integer unit number  (10-13)  used with the file whichE  *		encountered the failure.  *E  *	     2. A character string keyword which will be used in the first.2  *		error message.  This message is in the format:  *<  *		  %<KEYWORD>-F-OPENERR, error opening <FILETYPE> file...  *4  *		Usually this keyword is the name of the utility.  *E  *	     3. A lower-case character string  describing the type of filea>  *		which was being opened.   This is usually  something  like  *		'input' or 'output'.  *E  *	The first error message also  gives the full name of the file  (as E  *	much as can be determined.  The second message describes the fail-	E  *	ure in standard VMS error message format,  and then the program isE  *	aborted.S  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Center   *			  Code K55 )  *	7 Sep 1989	  Dahlgren, Virginia  22448(  *     	UNIT_ = UNIT  s-  	IF (UNIT_.LT.10 .OR. UNIT_.GT.13) GO TO 110t  f=  	CALL LIB$PUT_OUTPUT('%'//LINE//'-F-OPENERR, error opening '_<  	1	    //FILE//' file '//TEXT_FILES(UNIT_)(1:TFLEN(UNIT_)))  *  120	MSGVEC(1) = 2"  	MSGVEC(2) = FAB(UNIT_).FAB$L_STS  	IF (MSGVEC(2)) THENt&  	    MSGVEC(2) = RAB(UNIT_).RAB$L_STS&  	    MSGVEC(3) = RAB(UNIT_).RAB$L_STV  	ELSE&  	    MSGVEC(3) = FAB(UNIT_).FAB$L_STV  	ENDIF,  r+  	CALL SYS$PUTMSG(MSGVEC,TEXT_MSG_FORMAT,,)N1  	CALL LIB$STOP(%VAL(IOR(MSGVEC(2),'10000000'x)))T  W  	RETURN  I  R  U  	ENTRY TEXT_ERROR     **   *	SUBROUTINE TEXT_ERROR  *  *(  *	This is part of the Text I/O Package.  *E  *	This routine  is meant to be called from a program's error handler.E  *	which was declared using the TEXT_ERROR_HANDLER routine.   It putsfE  *	out  an error message describing the last error encountered duringr?  *	a TEXT_READ or TEXT_WRITE operation, and aborts the program.f  *E  *	Note that errors are more frequent during file opens; these errorsn,  *	are processed by routine TEXT_OPEN_ERROR.  *1  *	Here is an example of how to use this routine:h  *	  *		  ...*  *		EXTERNAL MY_ERROR_HANDLER 	  *		  ...r-  *		CALL TEXT_ERROR_HANDLER(MY_ERROR_HANDLER)l	  *		  ... 	  *		  ...I-  *		SUBROUTINE MY_ERROR_HANDLER(UNIT,STS,STV)o  *		IF (UNIT.EQ.10) THEN5  *		  PRINT *,'%MYPROG-F-INPERR, error on input file'   *		ELSE	  *		  ...a	  *		ENDIF   *		CALL TEXT_ERRORr  *		ENDn  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare CenterO  *			  Code K55.)  *	7 Sep 1989	  Dahlgren, Virginia  22448*  *  d  	UNIT_ = MSGVEC(5)	  	GO TO 120i  n     4   	ENTRY TEXT_ERROR_HANDLER(UNIT)  T  **18  *	SUBROUTINE TEXT_ERROR_HANDLER( handler_routine_name )  *  *(  *	This is part of the Text I/O Package.  *E  *	Defines to the Text I/O Package an  error handling routine provid- E  *	ed by the caller.   The Package will call this routine when an I/O E  *	error occurs while performing a TEXT_READ or TEXT_WRITE operation._  *E  *	The  name  of  the desired routine must be passed as the argument.)E  *	This name must be declared EXTERNAL  in  the  routine  which calls E  *	TEXT_ERROR_HANDLER.  The routine may be changed as often as neces-T  *	sary.  *E  *	If no error handling routine is used, TEXT_READ or TEXT_WRITE will1E  *	abort the program when an error occurs,  displaying the associatedxE  *	VMS error message on  SYS$OUTPUT.   This default action can be re- E  *	stored by caling TEXT_ERROR_HANDLER with an argument of "%VAL(0)".N  *E  *	The default action is fine, except that it does not output any ap-fE  *	lication-specific diagnostic messages;  the default message  tells E  *	what error occurred,  but it  does not tell the user which file it 2  *	occurred on; this may be necessary information.  *E  *	When an error occurs,  the  error  handling routine is called with E  *	three integer arguments:  the file unit number  (10-13),  the  VMSRE  *	status  code  describing the error, and the RMS STV value from the E  *	error.  This allows the routine to take different paths, if neces-y*  *	sary, depending on what error occurred.  *E  *	The error handling routine must be an integer function.  It can doe  *	one of three things:o  *E  *	--- It can abort the program.  It should do any cleaning up neces-BE  *	    sary,  and output any  application-specific messages,  then it E  *	    should either exit the program or call routine TEXT_ABORT; theTE  *	    latter is recommended, since it puts out the VMS error message C  *	    describing the error.   See TEXT_ABORT for more information.E  *E  *	--- It can return  with a function result of 1.   The operation inOE  *	    progress (TEXT_READ or TEXT_WRITE) will appear to have succes-AE  *	    fully completed.  The error handler can output messages or set *  *	    flags as desired before it returns.  *F  *	--- It can return with  any other function result.   This value is E  *	    then used as the function result  of the operation in progressAE  *	    (TEXT_READ or TEXT_WRITE); the calling program then can decideBC  *	    what to do about the error.  Usually, the value used will beA:  *	    the VMS status value passed as the second argument.  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare CenterS  *			  Code K55D)  *	7 Sep 1989	  Dahlgren, Virginia  22448   E  N  	ERROR_ROUTINE = %LOC(UNIT)  	RETURN  ,     *  	ENTRY TEXT_USEROPEN(UNIT)W  E  **t4  *	SUBROUTINE TEXT_USEROPEN( useropen_routine_name )  *  *(  *	This is part of the Text I/O Package.  *E  *	Defines to the  Text I/O Package  a routine provided by the caller_E  *	which will participate  in the next file open  (i.e. the next calleE  *	to routine TEXT_OPEN_INPUT or TEXT_OPEN_OUTPUT).  The Package willmE  *	call this routine twice:  after the FAB,  RAB, and NAM blocks havenE  *	been initialized,  and after the file has been opened.   The firstcE  *	call can be used to modify  information in  the RMS blocks,  or tohE  *	add XAB blocks.   The second call can be used to retrieve informa-A?  *	tion from the blocks which was deposited by RMS on the open.   *E  *	This routine is analogous to using the USEROPEN keyword  on a For-NE  *	tran OPEN statement.  The name of the desired routine is passed asEE  *	the argument.   This name must be declared EXTERNAL in the routineTE  *	which calls  TEXT_USEROPEN.   The routine is only used on the very.*  *	next file open by the Text I/O Package.  *E  *	The useropen routine is called with five arguments:  the file unit E  *	number (integer 10-13), the address of the FAB, the address of theLE  *	RAB, the address of the NAM, and an integer code which is 1 on thea(  *	first call, and 2 on the second call.  *E  *	Unlike Fortran USEROPEN routines, this routine must not perform an_  *	$OPEN, $CREATE, or $CONNECT.e  *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Centerl  *			  Code K55d)  *	7 Sep 1989	  Dahlgren, Virginia  22448o  *  t  	USEROPEN_ROUTINE = %LOC(UNIT)L  	RETURN  F     u  	ENTRY TEXT_RFA(UNIT,RFA)  t  **u$  *	SUBROUTINE TEXT_RFA( unit , rfa )  *  *(  *	This is part of the Text I/O Package.  *E  *	Returns the RFA  (Record File Address)  of the last record read by,E  *	TEXT_READ  or written by  TEXT_WRITE  on the specified unit, whicho(  *	must be an integer 10, 11, 12, or 13.  *E  *	The RFA is returned in the second argument, which must either be a(E  *	BYTE array or six elements,  an INTEGER*2 array of three elements,.<  *	an INTEGER*4 array of two elements, or a REAL*8 variable.  *E  *	The RFA value can be used in a subsequent call to TEXT_READ_RFA toT?  *	directly access this record without searching down the file.   *  *	.INDEX DISK I/O>>  *1  *	Alan L. Zirkle    Naval Surface Warfare Centery  *			  Code K55E*  *	20 Oct 1992	  Dahlgren, Virginia  22448  *  l@  	IF (UNIT.LT.10 .OR. UNIT.GT.13 .OR. .NOT.OPEN(UNIT)) GO TO 110  a+  	CALL LIB$MOVC3(6,RAB(UNIT).RAB$W_RFA,RFA)   	RETURN  n *2Dt  	END									* *2E	 *2IF  	END									   *2E*6  	INTEGER FUNCTION GET_LINE(UNIT,STRING,LENGTH,CCTYPE)  l  **hA  *	INTEGER FUNCTION GET_LINE( unit , string , length , [cctype] )e  *  *E  *	Reads file whose unit number is the argument UNIT, and returns one E  *	'logical' line.   The calling program must have previously  opened*E  *	the file using routine TEXT_OPEN_INPUT. Only unit numbers 10 or 11eE  *	can be used.  These two units can be processed concurrently if de-i	  *	sired.T  *E  *	The line is returned in character string STRING; the length of the 3  *	line is returned in the longword integer LENGTH.n  *E  *	If the file does not have Fortran  Carriage  Control,  the  actual E  *	line read (the 'physical' line) is reformatted so that STRING con-lE  *	tains  a  Fortran-like  line;  i.e. column 1 contains the carriage E  *	control for the line.  In doing this reformatting, it may  be  ne-tE  *	cessary  for  GET_LINE to split the physical line into two or moresE  *	logical lines.  Only one logical line is returned  per  call;  theuE  *	remaining  part(s) of the physical line are returned on subsequent 	  *	calls.   *E  *	The functional result is 1 (.TRUE.) unless end-of-file was reachedtE  *	in which case it is 0 (.FALSE.).  GET_LINE does NOT close the file E  *	when it senses end-of-file.  To close the file, routine TEXT_CLOSEe  *	must be used.  *  *	.INDEX DISK I/O>>  *E  *	This routine cannot handle every type of file.  It is designed  tob
  *	handle:  */  *	    * Any file with Fortran Carriage Controll  *4  *	    * Files output from the DSR or RNO utilities.  *E  *	    * Files with 'List' Carriage Control (i.e.  files  created  asNE  *	      listing files by VMS components, or normal files created us-1E  *	      ing EDT) which have no embedded ASCII control characters ex-	  *	      cept:  *>  *		a.  A Form Feed (page eject) or Line Feed (double spacing).  *		    may appear at the beginning of a line.  *>  *		b.  A Carriage Return may  appear  anywhere  in  the line.>  *		    (This  is  used  for  underlining  and  overprinting.)  *>  *		c.  A Carriage Return/Line Feed pair may  appear  anywhere>  *		    in  the  line.   (This  is used to pack multiple print  *		    lines onto one record.)o  *,  *	    * A subset of VFC/Print Format files.  *-*E  *	Files with records longer than 255 characters are not handled.   A*E  *	file with 'Unknown' Carriage Control is assumed to be a List file;hE  *	this assumption is, of course, not too good if the file is an .OBJt  *	or .EXE file.  *	<E  *	If the first character in a line is the European left quote (asciihE  *	code 171 decimal, looks like '<<'), then this character is used asr/  *	the carriage control character for the line.h  *E  *	If  the  optional  longword  integer  argument  CCTYPE is present,uE  *	GET_LINE returns in it the type of Carriage Control the file  has,   *	as follows:  *  *		FORTRAN  --  0  *		   LIST  --  1/  *		   NONE  --  2	   (DSR or RNO output files)r  *	      VFC/PRINT  --  3n  *#  *	See also routine GET_LINE_RESET.N  *  *A  *	23 Apr 1984	Treat UNKNOWN files same as  LIST;  the assumption	7  *			is that they are VFC/Print Format files created by    *			the VMS OPEN/WRITE command.3  *			Handle double spacing (Line Feed in column 1).L5  *	 3 May 1984	Handle CR/LF in col 1-2 of list files. A  *	20 Jun 1984	Do not  close file  upon EOF;  calling program may1#  *			need to do special processing.N5  *	 8 Mar 1985	Treat V4.0 DSR method of overprinting. A  *	 6 Nov 1985	Add test for European left quote in col 1 of line.LA  *	27 Jan 1988	Handle RNO files, which have formfeeds on lines byS  *			themselves.=  *	 3 Oct 1988	Handle <CR> on line by itself, which can occurx.  *			when using RNO commands .LEFT TITLE, etc.0  *	 7 Dec 1988	Handle <CR> at end of LIST lines.@  *	21 Aug 1989	Handle <CR><LF> and <CR> in middle of NONE lines.;  *	 7 Sep 1989	Use TEXT_IO routines instead of Fortran I/O.s7  *			Handle VFC/Print Format files correctly  (to  somef
  *			degree).r4  *	21 Oct 1992	Handle VFC/Print Format files better.  *		  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	18 Mar 1984	   Dahlgren, Virginia  22448p  *  e  	IMPLICIT NONEe  o  	INTEGER*4 UNIT  	CHARACTER*(*) STRING  	INTEGER*4 LENGTH  	INTEGER*4 CCTYPE  i  	INTEGER*4 GET_LINE_RESET  N!  	CHARACTER CRLF*2,CR*1,LF*1,FF*1*  A+  	PARAMETER ( CRLF = CHAR(13) // CHAR(10) )	  	PARAMETER ( CR   = CHAR(13) )E  	PARAMETER ( LF   = CHAR(10) )   	PARAMETER ( FF   = CHAR(12) )R     	CHARACTER*256 BUFFER(10:11)n   G  	INTEGER*2 BLEN(10:11) / -1,-1 /	! Non-neg means buffer has data in it   					!  from last call G  	BYTE CC_TYPE(10:11) / -1,-1 /	! Minus one means initialization needed '  	LOGICAL THIS_LINE_CRLF,LAST_LINE_CRLF*  	INTEGER*4 LEN,VFC,COL,COL2  	*  	INTEGER*4 TEXT_CC_TYPE,TEXT_VFC,SUBINDEX  	LOGICAL ARG_EXIST,TEXT_READO *2I   	INTEGER*4 IARGPTRa *2E_  t>  	IF (CC_TYPE(UNIT).LT.0) THEN		! First call after file opened(  	    CC_TYPE(UNIT) = TEXT_CC_TYPE(UNIT)  	    THIS_LINE_CRLF = .TRUE.   	ENDIFt  c!  	LAST_LINE_CRLF = THIS_LINE_CRLF   	THIS_LINE_CRLF = .FALSE.  o *2D *  	IF (ARG_EXIST(4)) CCTYPE = CC_TYPE(UNIT) *2Ei *2I ;  	IF (ARG_EXIST(%VAL(IARGPTR()), 4)) CCTYPE = CC_TYPE(UNIT)h *2Eu  t  	IF (BLEN(UNIT).LT.0) THENa   >  	    IF (BLEN(UNIT).EQ.-3) GO TO 100		! Used by RNO <FF> code  h:  	    IF (.NOT.TEXT_READ(UNIT,BUFFER(UNIT),LEN)) GO TO 100  I  	    LEN = MIN(255,LEN)  s1  	    IF (BLEN(UNIT).EQ.-2) THEN			! For V4.0 DSRp  r  		BLEN(UNIT) = -1  		LEN = LEN + 14  		BUFFER(UNIT)(1:LEN) = CR // BUFFER(UNIT)(1:LEN-1)  i  	    ENDIFi  c  	ELSE     	    LEN = BLEN(UNIT)  R  	    BLEN(UNIT) = -1m     	ENDIF0  N  	GET_LINE = 1  t?  	IF (CC_TYPE(UNIT).EQ.2) THEN		! Pre-process DSR and RNO linest  -.  	    IF (LEN.EQ.1) THEN				! Handle RNO <FF>s)  	      IF (BUFFER(UNIT)(1:1).EQ.FF) THEN :  		IF (.NOT.TEXT_READ(UNIT,BUFFER(UNIT)(2:),LEN)) GO TO 90  		LEN = MIN(LEN,254) + 1o
  	      ENDIF   	    ENDIFr#  						! Remove <CR><LF> if presenta  	    IF (LEN.GE.2) THEN1  	      IF (BUFFER(UNIT)(LEN-1:LEN).EQ.CRLF) THEN 8  		THIS_LINE_CRLF = .TRUE.		! We do not handle the case:  		LEN = LEN - 2			!   REC1   	      ENDIF				!   REC2 /  	    ENDIF				! Which is supposed to come out:i  						!   REC1REC2r  	ENDIF   T  	IF (LEN.EQ.0) THEN     	    STRING(1:1) = ' 'o  	    LENGTH = 1  	    RETURN  nC  	ELSE IF (CC_TYPE(UNIT).EQ.0) THEN	  ! Copy Fortran files verbatim   n)  	    STRING(1:LEN) = BUFFER(UNIT)(1:LEN)c  	    LENGTH = LEN  	    RETURN  *?  	ELSE IF (CC_TYPE(UNIT).EQ.3) THEN	  ! Process VFC/PRINT Filesh   +  	    STRING(2:LEN+1) = BUFFER(UNIT)(1:LEN)u.  	    LENGTH = LEN + 1				! We handle only the2  	    VFC = TEXT_VFC(UNIT)			!  cases which trans-6  	    IF (VFC.EQ.'8D02'x) THEN			!  late to Fortran 0,+  		STRING(1:1) = '0'			!  1,+,$,null,blank. "  		RETURN					!  If blank, we pro-8  	    ELSE IF (VFC.EQ.'8D8C'x) THEN		!  cess the line as)  		STRING(1:1) = '1'			!  if it were LIST 	  		RETURNe#  	    ELSE IF (VFC.EQ.'8D00'x) THEN   		STRING(1:1) = '+'	  		RETURNs#  	    ELSE IF (VFC.EQ.'0001'x) THENu  		STRING(1:1) = '$'	  		RETURNn#  	    ELSE IF (VFC.EQ.'0000'x) THEN_  		STRING(1:1) = CHAR(0)	  		RETURNd&  	    ENDIF					! All other cases fall  							!  through to LIST  	ENDIF    #  	IF (BUFFER(UNIT)(1:1).EQ.FF) THEN   o  	    STRING(1:1) = '1'E
  	    COL = 2*  *(  	ELSE IF (BUFFER(UNIT)(1:1).EQ.CR) THEN  eB  	    STRING(1:1) = '+'	! NSWC local convention for LASER -- CR at8  	    COL = 2		!  beginning of LIST line means overprint  N+  	    IF (LAST_LINE_CRLF) STRING(1:1) = ' 'T   4  	    IF (LEN.GE.2.AND.BUFFER(UNIT)(2:2).EQ.LF) THEN  		STRING(1:1) = '0'
  		COL = 3  	    ENDIFn  t(  	ELSE IF (BUFFER(UNIT)(1:1).EQ.LF) THEN  y  	    STRING(1:1) = '0'l
  	    COL = 2i  h)  	ELSE IF (BUFFER(UNIT)(1:1).EQ.'') THENt  o  	    STRING(1:1) = ''T
  	    COL = 2)  T  	ELSE  w  	    STRING(1:1) = ' 'e
  	    COL = 1t  F  	ENDIF    (  ! Check for embedded control characters  f3  	COL2 = SUBINDEX( BUFFER(UNIT)(1:LEN) , COL , CR )a  e  	IF (COL2.NE.0) THENa  nD  	    IF (THIS_LINE_CRLF) LEN = LEN + 2	! Restore CRLF for next call  	    THIS_LINE_CRLF = .FALSE.  tA  	    IF (COL2.EQ.LEN) THEN	! <CR> at end is no-op for LIST files*<  	   	LEN = LEN - 1		! But V4.0 DSR uses it for overprinting*  		IF (CC_TYPE(UNIT).EQ.2) BLEN(UNIT) = -2  		GO TO 80r  	    ENDIFs  a  	    LENGTH = COL2-1 - COL + 2m1  	    STRING(2:LENGTH) = BUFFER(UNIT)(COL:COL2-1)c  s<  	    IF (BUFFER(UNIT)(COL2:COL2+1).EQ.CRLF) COL2 = COL2 + 2   !  	    BLEN(UNIT) = LEN - COL2 + 1    9  	    BUFFER(UNIT)(1:BLEN(UNIT)) = BUFFER(UNIT)(COL2:LEN)   e  	    RETURN     	ENDIF1  3  80	LENGTH = LEN - COL + 2*  	STRING(2:LENGTH) = BUFFER(UNIT)(COL:LEN)  	      	RETURN  r=  90	STRING(1:1) = '1'	! <FF> is last character in a RNO file.l  	LENGTH = 1  	BLEN(UNIT) = -3N  	RETURN  i  100	CC_TYPE(UNIT) = -1m  	BLEN(UNIT) = -1E  ,  	GET_LINE = 0  	RETURN     K  O  	ENTRY GET_LINE_RESET(UNIT)  l  **a$  *	SUBROUTINE GET_LINE_RESET( unit )  *  *E  *	Function GET_LINE will in some instances read ahead and store someNE  *	upcoming lines in a buffer.  This can cause a problem if the call-BE  *	ing program does not sequentially read the file all the way to its E  *	end-of-file.  For example, if the file is read up to its fifteenthcE  *	record,  then rewound, then the next GET_LINE call may return rec- +  *	ord sixteen instead of the first record.2  *E  *	Calling routine GET_LINE_RESET fixes the problem by discarding thehE  *	contents of the buffer.  In the above example, this should be donel  *	when the file is rewound.  *  *	.INDEX DISK I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	21 Oct 1992	   Dahlgren, Virginia  22448o  *  o  	BLEN(UNIT) = -1h  i *2D   	END									K *2E> *2I   	END									   *2El"  	SUBROUTINE PUT_LINE(UNIT,STRING)  5  ***'  *	SUBROUTINE PUT_LINE( unit , string )   *  *E  *	Writes file whose unit number is the argument  UNIT;  one  line is	E  *	processed  per  call.   The  calling  program must have previously	E  *	opened the file using routine TEXT_OPEN_OUTPUT.  Only unit numbersLE  *	12 or 13 can be used. These two units can be processed concurrent-   *	ly is desired.g  *E  *	The line to be written is passed in character string STRING.  ThisNE  *	line must be constructed with  Fortran carriage control  (i.e. theeE  *	first character  should either be a blank,  a plus sign, a zero, an+  *	one, or a nine [NSWC local page eject]).t  *E  *	If the file does not have Fortran  Carriage  Control,  the  actual E  *	line written is reformatted so that the output record has the pro-rE  *	per structure for the file's type  of Carriage Control.   In doingaE  *	this reformatting, it may be necessary for PUT_LINE to combine twoaE  *	or more input strings into one output record.   Output records are 1  *	limited to a maximum length of 256 characters.n  *E  *	It is important to note that subroutine PUT_LINE_END must be call-yE  *	ed after  final call to PUT_LINE,  to cause the  last record to belE  *	written to the file.   This is not necessary if the file  has For-i  *	tran Carriage Control.   *  *?  *	10 Oct 85	Use -1 instead of 0 for default BLEN value so thatt-  *			zero-length lines are handled correctly. 9  *	 7 Sep 89	Use TEXT_IO routines instead of Fortran I/O.e  *  *	.INDEX DISK I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	4 Jan 1985	   Dahlgren, Virginia  22448  *  n  	IMPLICIT NONEy  o  	BYTE UNITs  	CHARACTER*(*) STRING  	  	CHARACTER*256 BUFFER(12:13)r  	INTEGER*2 BLEN(12:13)   	LOGICAL*1 INIT(12:13)m  	BYTE CCTYPE(12:13)  	INTEGER*4 L1,TEXT_CC_TYPE   s  	CHARACTER*1 CC,CR,LF,FFf  s  	PARAMETER ( CR = CHAR(13) )g  	PARAMETER ( LF = CHAR(10) )r  	PARAMETER ( FF = CHAR(12) )   g%  	DATA BLEN,INIT / 2*-1 , 2*.FALSE. /r  c  	IF (.NOT.INIT(UNIT)) THEN:  	    INIT(UNIT) = .TRUE.p'  	    CCTYPE(UNIT) = TEXT_CC_TYPE(UNIT)   	ENDIFa  pE  	IF (CCTYPE(UNIT).EQ.0) THEN	! Fortran is easy case; just copy line.p   "  	    CALL TEXT_WRITE(UNIT,STRING)  	    RETURN  r;  	ELSE IF (CCTYPE(UNIT).EQ.1 .AND. STRING(1:1).EQ.'+') THENt  /B  	    L1 = MAX(BLEN(UNIT),0)	   ! For overprint on LIST files, the9  	    IF (L1.GE.256) RETURN	   !  lines must be appended.c  .0  	    BLEN(UNIT) = MIN( 256 , L1 + LEN(STRING) )6  	    BUFFER(UNIT)(L1+1:BLEN(UNIT)) = CR // STRING(2:)  	    RETURN  dF  	ELSE IF (BLEN(UNIT).GE.0) THEN	   ! Previous line can now be written  e9  	    IF (CCTYPE(UNIT).EQ.1 .OR. STRING(1:1).EQ.'+') THENi3  		CALL TEXT_WRITE(UNIT,BUFFER(UNIT)(1:BLEN(UNIT)))s
  	    ELSE;  		CALL TEXT_WRITE(UNIT,BUFFER(UNIT)(1:BLEN(UNIT))//CR//LF)i  	    ENDIFk-  					! Note that for NONE files, we appendede1  	ENDIF				! CR/LF Unless THIS line is overprint.I  t<  	IF (STRING(1:1).EQ.' ') THEN		! Normal, single-spaced line/  10	    BLEN(UNIT) = MIN( 256 , LEN(STRING)-1 )C-  	    BUFFER(UNIT)(1:BLEN(UNIT)) = STRING(2:)	  	    RETURN0  	ELSE IF (STRING(1:1).EQ.'1') THEN	! Page eject
  	    CC = FFl<  	ELSE IF (STRING(1:1).EQ.'9') THEN	! Page eject, NSWC local
  	    CC = FF*8  	ELSE IF (STRING(1:1).EQ.'0') THEN	! Double spaced line
  	    CC = LF D  	ELSE IF (STRING(1:1).EQ.'+') THEN	! Overprinted (file must be NONE-  	    CC = CR				!  since we did other cases)g#  	ELSE IF (STRING(1:1).EQ.'') THEN   	    CC = ''  	ELSE4  	    GO TO 10		! '$' or 'nul', etc. are not handled  	ENDIFO   #  	BLEN(UNIT) = MIN(256,LEN(STRING)) /  	BUFFER(UNIT)(1:BLEN(UNIT)) = CC // STRING(2:)S  	RETURN  v  r  i     	ENTRY PUT_LINE_END(UNIT)  u  **n"  *	SUBROUTINE PUT_LINE_END( unit )  *  *E  *	Writes any buffered lines  (stored by subroutine PUT_LINE)  to the.8  *	file  whose unit number is the integer argument UNIT.  *E  *	This routine is used with subroutine PUT_LINE; see its descriptionl  *	for further information.   *  *;  *	 7 Sep 1989	Use TEXT_IO routines instead of Fortran I/O.   *  *	.INDEX DISK I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53*  *	4 Jan 1985	   Dahlgren, Virginia  22448  *  l  F  	IF (BLEN(UNIT).GE.0) THEN   	6  	    CALL TEXT_WRITE(UNIT,BUFFER(UNIT)(1:BLEN(UNIT)))  *  	    BLEN(UNIT) = -1a  9  	ENDIFl  n  	INIT(UNIT) = .FALSE.    *2DL  	END										 *2EE *2IN  	END									   *2EG7  	LOGICAL FUNCTION CHECK_ACCESS(USERNAME,FILENAME,MODE)   _  **R>  *	LOGICAL FUNCTION CHECK_ACCESS( username , filename , mode )  *  *E  *	Checks to see if user USERNAME can legally access file FILENAME in E  *	the given MODE.   The user and the file must exist.  The MODE must5E  *	be a string composed of one or more of the characters  R, W, E, D, E  *	or C (in either upper- or lowercase), which stand for Read, Write, E  *	Execute, Delete, and Control.   All of the arguments are character_  *	strings.E  *E  *	The function result is .TRUE. if the access is legal.  If the res-,E  *	ult is  .FALSE.  it contains a VMS status code which describes why2E  *	the access is illegal.  This will be either  SS$_NOPRIV  or an RMS E  *	error code caused by the file not existing.   SS$_NOPRIV will also *  *	be returned if the username is invalid.  *  *	.INDEX ENVIRONMENT>>A  *	.INDEX FILE PROTECTION>>S  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	16 Nov 1987	   Dahlgren, Virginia  22448(  *  I  	IMPLICIT NONE   	&  	CHARACTER*(*) USERNAME,FILENAME,MODE     	INCLUDE '($ACLDEF)'	  	INCLUDE '($ARMDEF)'U  	INCLUDE '($CHPDEF)'G  	INCLUDE '($RMSDEF)'   	INCLUDE '($SSDEF)'   3  	INTEGER*4 ITMLST(4),MODE_,STATUS,SYS$CHECK_ACCESSB  	LOGICAL M1  	CHARACTER*1 C1  	  	M(C) = INDEX(MODE,C) .GT. 0F  (  	MODE_ = 0)  i5  	IF (M('R').OR.M('r')) MODE_ = IOR(MODE_,ARM$M_READ) 6  	IF (M('W').OR.M('w')) MODE_ = IOR(MODE_,ARM$M_WRITE)8  	IF (M('E').OR.M('e')) MODE_ = IOR(MODE_,ARM$M_EXECUTE)7  	IF (M('D').OR.M('d')) MODE_ = IOR(MODE_,ARM$M_DELETE)e8  	IF (M('C').OR.M('c')) MODE_ = IOR(MODE_,ARM$M_CONTROL)   *  	CALL ITEM_LIST(ITMLST,CHP$_ACCESS,MODE_)  T@  	STATUS = SYS$CHECK_ACCESS(ACL$C_FILE,FILENAME,USERNAME,ITMLST)  	  	CHECK_ACCESS = STATUSs  a?  *	Abort if we get an error status code which is neither NOPRIVQB  *	nor any RMS-related status code.  Checking protection of a fileA  *	containing a node name gets SS$_IVLOGNAM; this is unfortunate.   I  	IF (.NOT.CHECK_ACCESS) THENe&  	    IF (STATUS.EQ.SS$_NOPRIV) RETURN(  	    IF (STATUS.EQ.SS$_IVLOGNAM) RETURN?  	    IF (IAND(STATUS,'0FFF0000'x)/'10000'x .EQ. RMS$_FACILITY)Y  	1							  RETURN!  	    CALL LIB$STOP(%VAL(STATUS))n  	ENDIFT  G  	END !  	LOGICAL FUNCTION FILE_PROT(FAB)H  L  **	1  *	LOGICAL FUNCTION FILE_PROT ( funct , protstr )	  *  *E  *	Allows creation of a file (using FORTRAN OPEN) with explicit spec- E  *	ification  of the file's protection.   The following steps must beI
  *	performed:h  *E  *	  1. Call FILE_PROT with  FUNCT  being 0 or 1, and PROTSTR being aNE  *	     character string specifying a file protection expression (for-E  *	     example 'S:RE,O:REWD,G,W').  Blanks or lower-case letters are:E  *	     not allowed in the expression.  If the expression omits clas-'E  *	     ses of users (for example 'S:R,O:RE,G' omits WORLD), then the'E  *	     omitted classes are given NO access if FUNCT=0,  or are given'E  *	     the access of the process default protection if FUNCT=1.   IftE  *	     the function value of FILE_PROT is .FALSE., the expression isU   *	     not syntactally correct.  *E  *	  2. Open files using  FORTRAN  OPEN statements.   The OPEN state- (  *	     ments must include the keywords:  **  *			USEROPEN=FILE_PROT  and  STATUS='NEW'  *E  *	     The name FILE_PROT must be declared EXTERNAL  in all subprog-   *	     rams doing these OPENs.(  *E  *	OPENs which do not use the USEROPEN keyword, and non-FORTRAN opens3E  *	are not affected; they continue to use the process default protec-   *	tion.  *  *	.INDEX DISK I/O>>  *	.INDEX FILE PROTECTION>>:  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	10 Jul 1987	   Dahlgren, Virginia  22448t  *  	E  *	Note that when FILE_PROT is called as the USEROPEN procedure,  itsN=  *	arguments are defined differently than as described above.E   A  *	Our use of ARG_ADDRESS in this routine is required because our D  *	second argument is a character string when the user calls us, butC  *	is a RAB when FORTRAN calls us in OPEN processing.  Note that we.E  *	don't even declare the second argument on the FUNCTION line.  FOR- E  *	TRAN does funny things then you pass a character string as an arg-	E  *	ument when the routine expects something else.  This is one way toUD  *	get around it; other ways are to code in MACRO, or have two separ$  *	ate routines for these two cases.  E  	IMPLICIT NONE(  T  	INCLUDE '($FABDEF)'   	INCLUDE '($XABDEF)'3  	INCLUDE '($XABPRODEF)'     	RECORD /FABDEF/ FABF  (  	STRUCTURE /XABPRO/	  	  UNION 	  	    MAPI  	      RECORD /XABPRODEF1/ PROa
  	    END MAPi	  	    MAPG  	      RECORD /XABDEF/ XAB	
  	    END MAP0
  	  END UNION=  	END STRUCTURE)  -  	RECORD /XABPRO/ XABPRO  U;  	INTEGER*4 ARG_ADDRESS,ARG_LONGWORD,SYS$CREATE,SYS$CONNECTB *2IN  	INTEGER*4 IARGPTRt *2E*  	INTEGER*2 PROTSE#  	LOGICAL ARG_EXIST,FILE_PROT_PARSEe  a *2Do-  	IF (ARG_EXIST(3)) THEN				! Create the filec *2Eu *2Ip;  	IF (ARG_EXIST(%VAL(IARGPTR()),3)) THEN		! Create the filea *2E   e&  	    XABPRO.XAB.XAB$B_COD = XAB$C_PRO)  	    XABPRO.XAB.XAB$B_BLN = XAB$C_PROLENi*  	    XABPRO.XAB.XAB$L_NXT = FAB.FAB$L_XAB"  	    XABPRO.PRO.XAB$W_PRO = PROTS  *"  	    FAB.FAB$L_XAB = %LOC(XABPRO)  d!  	    FILE_PROT = SYS$CREATE(FAB)_  E *2DeB  	    IF (FILE_PROT) FILE_PROT = SYS$CONNECT(%VAL(ARG_ADDRESS(2))) *2Ee *2IpR  	    IF (FILE_PROT) FILE_PROT = SYS$CONNECT(%VAL(ARG_ADDRESS(%VAL(IARGPTR()),2))) *2EA   #  	ELSE						! Parse the protectionse  r *2D	$  	    IF (ARG_LONGWORD(1).EQ.0) THEN *2Ei *2Ia6  	    IF (ARG_LONGWORD(%VAL(IARGPTR()),1,0).EQ.0) THEN *2E	4  		PROTS = 'FFFF'X			! Unspecified means 'No Access'
  	    ELSE>  		CALL SYS$SETDFPROT(,PROTS)	! Unspecified means 'Use Process/  	    ENDIF				!                       Defaultsr  e *2DN=  	    FILE_PROT = FILE_PROT_PARSE(%VAL(ARG_ADDRESS(2)),PROTS)o *2Em *2IaM  	    FILE_PROT = FILE_PROT_PARSE(%VAL(ARG_ADDRESS(%VAL(IARGPTR()),2)),PROTS)u *2EL  *  	ENDIF      	END.1  	LOGICAL FUNCTION FILE_PROT_PARSE(PROTSTR,PROTS)l  s  **r6  *	LOGICAL FUNCTION FILE_PROT_PARSE( protstr , prots )  *  *D  *	Parses a character string (the PROTSTR argument) which contains aD  *	VMS file protection expression  (such as 'S:RE,O:REWD,G:E,W') andD  *	builds from this a binary file protection field,  as used by RMS.D  *	The resultant field is returned as the  INTEGER*2 argument PROTS.D  *	Before calling FILE_PROT_PARSE,  the caller must initialize PROTSD  *	to a default value;  if the protection expression omits any classD  *	(such as GROUP or WORLD), then the default initialized into PROTS'  *	is used (one-bits mean 'no access').n  *D  *	Bits 0-3 of PROTS  control SYSTEM access,  bits 4-7 control OWNERD  *	access,  bits 8-11 control GROUP access,  and bits 12-15  controlD  *	WORLD access.  Within each four-bit subfield, bit 0 controls READD  *	access, bit 1 controls WRITE access,  bit 2 controls EXECUTE acc-)  *	ess, and bit 3 controls DELETE access.e  *D  *	The protection expression must not contain any blanks and must beD  *	upper case.   A .TRUE. function result from FILE_PROT_PARSE meansD  *	that the expression was syntactically correct;  PROTS must not be(  *	used if a .FALSE. result is returned.  *  *	.INDEX DISK I/O>>  *	.INDEX FILE PROTECTION>>D  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	10 Jul 1987	   Dahlgren, Virginia  22448R  *  r  	IMPLICIT NONEN  :=  	CHARACTER*(*) PROTSTR	! 'S:REWD,O:RWE,G:RE,W' (for example)*>  	INTEGER*2 PROTS		! On input, process default protection mask     	INTEGER*2 PLEN,COL,CCOL,SHIFT   	CHARACTER*4 SOGW,RWEDE  	CHARACTER*1 ICHR   5  	FILE_PROT_PARSE = .TRUE.	! Assume successful resultN  	SOGW = 'SOGW'E  	PLEN = LEN(PROTSTR).	  	COL = 0   CF  10	IF (COL.EQ.PLEN) GO TO 100	! Error--empty string or dangling comma  	COL = COL + 1s  	ICHR = PROTSTR(COL:COL)p  	CCOL = INDEX(SOGW,ICHR)(;  	IF (CCOL.EQ.0) GO TO 100	! Error--class not S, O, G, or W.;  	SOGW(CCOL:CCOL) = CHAR(0)	! Prevent duplicate class specs,  	SHIFT = 4 * (CCOL - 1)F  	PROTS = IOR( PROTS, ISHFT( 'F'X , SHIFT ) )	! Init this class to 'No  							!  Access'  	IF (COL.EQ.PLEN) RETURN	  	COL = COL + 1U  	ICHR = PROTSTR(COL:COL)   	IF (ICHR.EQ.',') GO TO 10U  	IF (ICHR.NE.':') GO TO 100  	RWED = 'RWED'r  o8  20	IF (COL.EQ.PLEN) RETURN		! (dangling colons ignored)  	COL = COL + 1)  	ICHR = PROTSTR(COL:COL)T7  	IF (ICHR.EQ.',') GO TO 10	! (dangling colons ignored)C  	CCOL = INDEX(RWED,ICHR)U  	IF (CCOL.EQ.0) GO TO 100  	RWED(CCOL:CCOL) = CHAR(0)t+  	PROTS = IBCLR( PROTS , SHIFT + CCOL - 1 )!
  	GO TO 20  H  100	FILE_PROT_PARSE = .FALSE.  T  	END1)  	LOGICAL FUNCTION MOUNTED_DISK(FILENAME)e  1  ** ,  *	LOGICAL FUNCTION MOUNTED_DISK( filename )  *  *E  *	Given a file name  (or part of one)  in the character string  arg-)E  *	ument FILENAME, this function checks to see if the file resides on9E  *	a valid, mounted, disk device.   If the file name does not include)E  *	an explicit device name,  the current default disk is assumed  (as:E  *	per usual conventions).  Note that the current default disk is noti,  *	necessarily a valid, mounted disk device.  *E  *	The need for this routine  came about  when somebody used the filetE  *	name  "OPA:[dir]fil.typ", where OPA is the logical name  of a disk E  *	which happened to not be currently mounted.   RMS assumed that the 6  *	file was on device OPA0, with strange consequences.  *  *,  *	 27 May 87	Check for status SS$_IVDEVNAM.  *  *	.INDEX DISK I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	20 Mar 1986	   Dahlgren, Virginia  22448t  *  _  	IMPLICIT INTEGER (A-Z)  *+  	PARAMETER ( SS$_IVDEVNAM  =      '144'X ) +  	PARAMETER ( SS$_NOSUCHDEV =      '908'X )I+  	PARAMETER ( DVI$_DEVCHAR  =        '2'X ).+  	PARAMETER ( DEV$M_MNT     =    '80000'X )	+  	PARAMETER ( DEV$M_RND     = '10000000'X )i+  	PARAMETER ( DEV$M_DIR     =        '8'X ))  E  	CHARACTER*(*) FILENAME  	INTEGER*4 IOSB(2),ITMLST(4)I  )  	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)   L5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSG  	  	MOUNTED_DISK = .FALSE.  (%  	STATUS = FILE_NAME_INFO(FILENAME,3)L  C5  	IF (.NOT.STATUS) RETURN			    ! Bad syntax on name?    -  	CALL ITEM_LIST(ITMLST,DVI$_DEVCHAR,DEVCHAR)l  c;  	STATUS = SYS$GETDVIW(,,FULLNAME(FIELDS(2,1):FIELDS(2,2)),   	1						 ITMLST,IOSB,,,)m  5  	IF (.NOT.STATUS) THEN ?  	    IF (STATUS.EQ.SS$_IVDEVNAM)  RETURN	    ! No such device?r?  	    IF (STATUS.EQ.SS$_NOSUCHDEV) RETURN	    ! No such device? !  	    CALL LIB$STOP(%VAL(STATUS))r  	ENDIFr  h0  	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))   <  	IF (IAND(DEVCHAR,DEV$M_MNT).EQ.0) RETURN    ! Not mounted?B  	IF (IAND(DEVCHAR,DEV$M_RND).EQ.0) RETURN    ! Not random access?I  	IF (IAND(DEVCHAR,DEV$M_DIR).EQ.0) RETURN    ! Not directory structured?a  d  	MOUNTED_DISK = .TRUE..  S  	ENDI;  	SUBROUTINE GET_A_FILE_NAME(PARAM_NAME,FILE_NAME,NAME_LEN,   	1						DEFAULT_NAME,*,*)  N  **I8  *	SUBROUTINE GET_A_FILE_NAME ( param_name , file_name ,  **  *+					 name_len , default_name , * , * )  *  *E  *	Processes a DCL parameter value which is a file name or a list  ofSE  *	file  names  (separated  by commas).  The name(s) may contain wildUE  *	card characters.  Each time this subroutine is called,  it returns E  *	the  actual  name  of  one file which matches the parameter value. @  *	When no more matches are found, an alternate return is taken.  *E  *	Another alternate return is taken if no file is found to match theWE  *	value.  If the value is a list, this return is taken each time  noOE  *	file is found which matches the current list element being examin-EE  *	ed; subsequent calls to GET_A_FILE_NAME will check succeeding listOE  *	elements.   (Thus  when this  second alternate return is taken,  aCE  *	diagnostic message may be printed if desired,  but then  the callsSE  *	to  this  subroutine should be continued until the first alternateP  *	return is taken.r  *E  *	Common /GET_FILE_NAME/ contains the current  parameter  list  itemm7  *	being examined.  The format of this common block is:T  *  *		INTEGER*4 PARAM_LENF  *		CHARACTER*255 PARAM_VALUE   *0  *		COMMON /GET_FILE_NAME/ PARAM_LEN,PARAM_VALUE  *	.INDEX FILE NAMES>>  *1  *	The required arguments to GET_A_FILE_NAME are:   *E  *	    PARAM_NAME  ----  Name of the DCL parameter  to  be  examined._7  *			      See  Chapter 5  of the VAX-11 Utilities Ref-c7  *			      erence manual.  This is a  character  stringn$  *			      input to GET_A_FILE_NAME.  *E  *	    FILE_NAME  -----  Actual name of one file  which  matches  thep7  *			      parameter value.  This is a character string '  *			      output from GET_A_FILE_NAME.r  *E  *	    NAME_LEN  ------  Length of non-blank part of FILE_NAME.  This 5  *			      is an integer output from GET_A_FILE_NAME.   *E  *	    DEFAULT_NAME  --  Blank, or a default name to be used  in  de- 7  *			      termining FILE_NAME when the parameter valuet7  *			      is an incomplete file specification. This isF7  *			      a character string input to GET_A_FILE_NAME.   *E  *	    * (RETURN 1)  --  Statement label in the calling routine whichO7  *			      is returned to (instead of the statement im- 7  *			      mediately  following  the  call  to  routinet7  *			      GET_A_FILE_NAME)  when  no  more files existe+  *			      which match the parameter value.   *-SE  *	    * (RETURN 2)  --  Statement label in the calling routine whichl7  *			      is returned to when no file is  found  whichs7  *			      matches  one  element of the parameter valuep7  *			      list (or the entire value if  it  is  not  as7  *			      list).   The calling routine may print a di-*7  *			      agnostic message if desired, but should con-a)  *			      tinue calling GET_A_FILE_NAME.   *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	11 May 1983	   Dahlgren, Virginia  22448N  *  g  	IMPLICIT INTEGER (A-Z)  y1  	CHARACTER*(*) PARAM_NAME,FILE_NAME,DEFAULT_NAMED,  	CHARACTER PARAM_VALUE*255,RELATED_NAME*255  	LOGICAL WITHIN,FOUNDONEh  c.  	COMMON /GET_FILE_NAME/ PARAM_LEN,PARAM_VALUE   ,  	DATA WITHIN,RELATED_NAME / .FALSE. , ' ' /  h  10	IF (.NOT.WITHIN) THENr  h<  	    STATUS=CLI$GET_VALUE(PARAM_NAME,PARAM_VALUE,PARAM_LEN)  y  	    IF (.NOT.STATUS) THENc     		RELATED_NAME = ' 'u  t  		RETURN 1t     	    ENDIFh     	    WITHIN   = .TRUE.U  	    FOUNDONE = .FALSE.  s  	    CONTEXT=0A  ,  	ENDIFt  s5  	STATUS=LIB$FIND_FILE(PARAM_VALUE,FILE_NAME,CONTEXT,C"  	1					DEFAULT_NAME,RELATED_NAME)  	  	IF (.NOT.STATUS) THENN  D  	    WITHIN=.FALSE.  E!  	    IF (.NOT.FOUNDONE) RETURN 2   B  	    GO TO 10  	  	ENDIF    0  	CALL STR$TRIM(RELATED_NAME,FILE_NAME,NAME_LEN)  A  	FOUNDONE = .TRUE.A  F  	END 1  	INTEGER FUNCTION FILE_NAME_INFO(FILENAME,FLAGS)-  	  **D:  *	INTEGER FUNCTION FILE_NAME_INFO( filename [ , flags ] )  *  *E  *	Obtains various items of information about a file name.  The input	E  *	string  FILENAME  contains the name to be interrogated.  Wildcards	E  *	may be present, and parts  (even all)  of the name may be omitted.HE  *	The file  does not have to exist  (but any device,  directory,  orOE  *	node name specified  must exist, or you will  get an error status,T1  *	unless you use the FLAGS argument--see below).S  *E  *	The function result is the status returned by the RMS $PARSE oper-FE  *	ation.   The possible values are documented  under the descriptionDE  *	of the $PARSE service in the VAX RMS Reference Manual. An error isAE  *	most likely to be a syntax error in a part of the name, or a node,r)  *	device, or directory which is unknown.D  *  *	.INDEX FILE NAMES>>  *E  *	The information about FILENAME is returned  in variables in commonF=  *	block /FILE_NAME_INFO_/.  The definition of this block is:$  *  *		INTEGER*4 FNB,FN_LEN  *		CHARACTER*256 FULLNAME  *		INTEGER*2 FIELDS(6,2)   *7  *		COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSV  *  *	The information is:  *E  *	  FNB -- a longword bit string giving status information about the(>  *		 file name.   The definitions of the bits are found in the>  *		 VAX  RMS  Reference Manual,  in the discussion of the FNB>  *		 field of the NAM block (section 6.13).  To get these def-9  *		 initions in your Fortran program, use the statement:f  *  *				INCLUDE '($NAMDEF)'h  *>  *		 An example of one of the bits is NAM$M_WILDCARD, which is6  *		 set if FILENAME contains any wildcard characters.  *E  *	  FULLNAME(1:FN_LEN) -- The  resultant file name  derived from theA0  *				input file name,  after application of de-.  *				faults and translation of logical names.  *E  *	  FIELDS -- An INTEGER*2 6-by-2 array,  giving the character posi-P>  *		    tions, in FULLNAME, of each of the file name's compon->  *		    ents.   FIELDS(n,1) has the start column,  FIELDS(n,2)6  *		    the end column, of the n-th field, as follows:  *		   *  *			1 node		4 file name0  *			2 device	5 file type ("." if no type given)0  *			3 directory	6 version   (";" if none given)  *- >  *		    For fields  which are not present  (this could only be>  *		    the node or file name),  FIELDS(n,2) will be  equal to>  *		    FIELDS(n,1) minus one, indicating  a null string (For-)  *		    tran accepts this without error).c  *  *E  *	If the optional FLAGS argument is provided, it can be used to mod-NE  *	ify the action of FILE_NAME_INFO.   Each bit in FLAGS controls one E  *	function, and can be set in combination as desired.  The bits, andr  *	their functions, are:  *E  *	  Bit 0 -- Do not conceal concealed logical names in the resultantf  *		   file name.E  *E  *	  Bit 1 -- Do not check to see  if any node,  device, or directoryL-  *		   names used in FILENAME actually exist.	  *  *A  *	17 Apr 1992	Do not attempt  to set fields when a bad directoryN7  *			name has been passed;  can be caused  by using SETC'  *			DEFAULT with a search list, as in:-)  *				$ DEFINE TEST DISK:[A.B],DISK:[A.C]   *				$ SET DEFAULT TEST)  *			then calling this routine with '[]'.C  *  *1  *	Alan L. Zirkle	   Naval Surface Warfare CenterW  *			   Code K53+  *	19 Jan 1986	   Dahlgren, Virginia  22448   *  C  	IMPLICIT INTEGER (A-Z)  S  	CHARACTER*(*) FILENAME  n  	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)   O5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSG  O  	INCLUDE '($FABDEF)')  	INCLUDE '($NAMDEF)'W  r  	RECORD /FABDEF/ FABE  	RECORD /NAMDEF/ NAMc  n *2Io  	INTEGER*4 IARGPTR) *2EC  	LOGICAL ARG_EXISTT  	  	FLAGS_ = 0 *2D "  	IF (ARG_EXIST(2)) FLAGS_ = FLAGS *2EL *2ID2  	IF (ARG_EXIST(%VAL(IARGPTR()),2)) FLAGS_ = FLAGS *2EC     	FAB.FAB$B_BID = FAB$C_BIDP  	FAB.FAB$B_BLN = FAB$C_BLN	  T   	FAB.FAB$L_FNA = %LOC(FILENAME)&  	FAB.FAB$B_FNS = LBYTE(LEN(FILENAME))  T  	FAB.FAB$L_NAM = %LOC(NAM)   L  	NAM.NAM$B_BID = NAM$C_BID   	NAM.NAM$B_BLN = NAM$C_BLNa  l   	NAM.NAM$L_ESA = %LOC(FULLNAME)/  	NAM.NAM$B_ESS = LBYTE(MIN(LEN(FULLNAME),255))u  i  	NAM.NAM$B_NOP = 0h:  	IF (IAND(FLAGS_,1).NE.0) NAM.NAM$B_NOP = NAM$M_NOCONCEAL:  	IF (IAND(FLAGS_,2).NE.0) NAM.NAM$B_NOP = NAM.NAM$B_NOP +  	1						    NAM$M_SYNCHKs  s!  	FILE_NAME_INFO = SYS$PARSE(FAB)s     	FN_LEN = ZEXT(NAM.NAM$B_ESL)  i  	FNB = NAM.NAM$L_FNBa  l2  	IF (NAM.NAM$L_NODE.EQ.0) RETURN			! AZ 17 Apr 92  i2  	FIELDS(1,1) = NAM.NAM$L_NODE - NAM.NAM$L_ESA + 16  	FIELDS(1,2) = FIELDS(1,1) + ZEXT(NAM.NAM$B_NODE) - 1  d1  	FIELDS(2,1) = NAM.NAM$L_DEV - NAM.NAM$L_ESA + 1.5  	FIELDS(2,2) = FIELDS(2,1) + ZEXT(NAM.NAM$B_DEV) - 1i  s1  	FIELDS(3,1) = NAM.NAM$L_DIR - NAM.NAM$L_ESA + 1o5  	FIELDS(3,2) = FIELDS(3,1) + ZEXT(NAM.NAM$B_DIR) - 1*  a2  	FIELDS(4,1) = NAM.NAM$L_NAME - NAM.NAM$L_ESA + 16  	FIELDS(4,2) = FIELDS(4,1) + ZEXT(NAM.NAM$B_NAME) - 1  *2  	FIELDS(5,1) = NAM.NAM$L_TYPE - NAM.NAM$L_ESA + 16  	FIELDS(5,2) = FIELDS(5,1) + ZEXT(NAM.NAM$B_TYPE) - 1   1  	FIELDS(6,1) = NAM.NAM$L_VER - NAM.NAM$L_ESA + 1 5  	FIELDS(6,2) = FIELDS(6,1) + ZEXT(NAM.NAM$B_VER) - 1   A  	END   	SUBROUTINE FILE_ERROR(UNIT)i  	  **E"  *	SUBROUTINE FILE_ERROR( [unit] )  *  *E  *	Displays one or more  error messages associated with the last For- E  *	tran I/O statement executed.   This routine should be called afterO:  *	taking an ERR= branch from an I/O statement.  Examples:  *  *		OPEN (1 , ... , ERR=100)
  *		 . . .  *	    100 CALL FILE_ERROR  *  *   *		WRITE (1, ... , ERR=200) ...
  *		 . . .  *	    200 CALL FILE_ERROR(8)D  *E  *	If the optional argument  UNIT  is omitted, the error messages are2E  *	written to the file SYS$OUTPUT; it may also write  the messages to E  *	the file  SYS$ERROR  if  SYS$ERROR is assigned to a different fileTE  *	than SYS$OUTPUT (they normally are the same file) and the error isO  *	severe enough.	  *E  *	If the optional argument UNIT is specified, it is the Fortran unitDE  *	number to which the messages  are to be written.  The messages areDE  *	then written to this file instead of  SYS$OUTPUT.   NOTE THAT THISME  *	UNIT NUMBER IS WHERE THE MESSAGES ARE TO BE WRITTEN; IT IS NOT THE=4  *	UNIT NUMBER OF THE FILE WHERE THE ERROR OCCURRED.  *E  *	In either of the above cases,  a blank line is written to the fileO=  *	before the first line of messages and after the last line.n  *  *	.INDEX DISK I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	21 Feb 1985	   Dahlgren, Virginia  22448c  *     	IMPLICIT INTEGER (A-Z)  U!  	INTEGER*4 MSGVEC(4) / 3,0,0,0 /i  u *2Ii  	INTEGER*4 IARGPTRu *2E   	LOGICAL ARG_EXIST      	EXTERNAL FILE_ERROR_1e  r$  	CALL ERRSNS(,MSGVEC(2),MSGVEC(4),)  r *2Dn  	IF (ARG_EXIST(1)) THEN *2E. *2I (  	IF (ARG_EXIST(%VAL(IARGPTR()),1)) THEN *2E   f  	    WRITE (UNIT,1000)l   0  	    CALL SYS$PUTMSG(MSGVEC,FILE_ERROR_1,,UNIT)  m  	    WRITE (UNIT,1000)w  h  	ELSE  e  	    PRINT 1000      	    CALL SYS$PUTMSG(MSGVEC,,,)  l  	    PRINT 1000  w  	ENDIF   c  1000	FORMAT (' ')  t  	ENDh-  	LOGICAL FUNCTION FILE_ERROR_1(MESSAGE,UNIT),  C  **d2  *	LOGICAL FUNCTION FILE_ERROR_1( message , unit )  *  *E  *	This routine is used by subroutine FILE_ERROR and is not called bye
  *	user code.r  *E  *	FILE_ERROR_1 is called by  SYS$PUTMSG  once for each line of error E  *	message.   This routine writes the line to the Fortran unit number E  *	passed as the second argument, and returns a .FALSE. result, whichOE  *	tells SYS$PUTMSG not to write the line on SYS$OUTPUT or SYS$ERROR.   *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	21 Feb 1985	   Dahlgren, Virginia  22448d  *  	  	IMPLICIT INTEGER (A-Z)     	CHARACTER*(*) MESSAGE*     	WRITE (UNIT,1000) MESSAGEa  h  	FILE_ERROR_1 = .FALSE.  i  1000	FORMAT (1X,A)M     	END	  	LOGICAL FUNCTION FILE_BUSY()     **i   *	LOGICAL FUNCTION FILE_BUSY ()  *  *E  *	When this logical function is called after an unsuccessful attemptFE  *	to do a Fortran OPEN on a file, a determination  is  made  whetherLE  *	the OPEN failed because another user has the file open.  If so, we E  *	wait two seconds and return a .TRUE. result, and the calling prog-e;  *	ram can retry the OPEN.  Otherwise, .FALSE. is returned.   *	  *	Usage:n  *			LOGICAL FILE_BUSY
  *			. . .&  *		     10	OPEN (1 , . . . , ERR=100)
  *			. . .  *			<file is open> 
  *			. . .%  *		    100 IF (FILE_BUSY()) GO TO 10o
  *			. . .)  *			<file is not busy, cannot be opened> 
  *			. . .  *  *	.INDEX DISK I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	14 Nov 1983	   Dahlgren, Virginia  22448e  *  *  v  	IMPLICIT INTEGER (A-Z)  N  	CALL ERRSNS(,STATUS,,,)    "  	FILE_BUSY = STATUS .EQ. '1828A'X  e   	IF (FILE_BUSY) CALL GO_WAIT(2)  c  	END	(  	INTEGER FUNCTION DISK_SPACE(PACK_NAME)     **p+  *	INTEGER FUNCTION DISK_SPACE( pack_name )   *  *E  *	Determines the number of free blocks remaining on  the  disk  unit E  *	whose logical name is PACK_NAME.  The argument must be a characteriE  *	string  containing the logical name of the pack;  a trailing colonr  *	is optional.   *E  *	The routine will abort the program if an incorrect logical name isI,  *	specified, or if the pack is not mounted.  *  *	See also routine FILE_SPACE.A  *  *	.INDEX DISK I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	16 Nov 1983	   Dahlgren, Virginia  22448.  *  ,  	IMPLICIT INTEGER (A-Z)  I  	CHARACTER*(*) PACK_NAMEC  G  	CHARACTER*63 FILE_NAME  U'  	PARAMETER ( DVI$_FREEBLOCKS = '2A'X )T  c  	INTEGER ITMLST(4)      	FILE_NAME = PACK_NAME    
  	GO TO 10  	     H     	ENTRY FILE_SPACE(UNIT_NUMBER)S     **	-  *	INTEGER FUNCTION FILE_SPACE( unit_number )F  *  *E  *	Determines the number of free blocks remaining on the disk unit on	E  *	which the file, whose FORTRAN unit number is UNIT_NUMBER, resides.TE  *	The argument must be an integer constant or variable.   FILE_SPACETA  *	must be declared to be of type INTEGER in the calling program.   *E  *	The routine will abort the program if an incorrect unit number  isT3  *	specified, or if the file is not currently open.   *  *	See also routine DISK_SPACE.n  *  *	.INDEX DISK I/O>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	16 Nov 1983	   Dahlgren, Virginia  22448e  *  )&  	INQUIRE (UNIT_NUMBER,NAME=FILE_NAME)   5  10	CALL ITEM_LIST(ITMLST,DVI$_FREEBLOCKS,FREEBLOCKS)o   .  	STATUS = SYS$GETDVIW(,,FILE_NAME,ITMLST,,,,)  t.  	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  u  	DISK_SPACE = FREEBLOCKST  f  	END "  	INTEGER FUNCTION SD_(PARAM,PRIV)  S  **S(  *	INTEGER FUNCTION SD_( param [,priv] )  *  *E  *	Accepts a parameter string containing one or more  'SD' type oper- E  *	ations, and computes the resultant device and directory.   The op-aE  *	erations in the parameter string must be in upper case and must ben?  *	separated by one or more blanks.   The legal operations are:N  */  *	  ^	 Use directory one subdirectory level upI  *;  *	  ^^	 Use master directory at or above current directoryE  *,  *	  .	 Use login default directory and disk  *@  *	  <n	 Use n'th directory in the SD stack (default for n is 1)  *4  *	  >X	 Use directory [z.X] when currently in [z.y]  *"  *	  .X	 Use directory [current.X]  *!  *	  X.Y.Z	 Use directory [X.Y.Z]h  *3  *	  n	 Use n'th predefined directory (n = 0 to 99)   *9  *	  >	 Traverse horizontally (i.e. from [A.A1] to [A.A2]   *A  *	  \	 Traverse to next node in directory tree (preorder traver-   *								      sal)  *>  *	  #	 Use directory [SYSj.XXX] when currently in [SYSi.XXX],"  *						where j=i+1 in hexadecimalB  *	  #n     Use directory [SYSn.XXX] when currently in [SYSi.XXX],"  *						 where n,i are hexadecimal  *E  *	  @user	 Use specified user's login directory; requires privilegesc  *  *	Example:	  *C  *	  If in USER:[A.B], '^ .C' or '>C' or '^^ .C' selects USER:[A.C]*  *  *	.INDEX ENVIRONMENT>>h1  *	The resultant device and directory must exist.   *E  *	The  function result will be one of the following VMS error statusn
  *	values:  *&  *	  SS$_NORMAL   '00000001'x  Success  *E  *	  RMS$_DIR     '000184CC'x  Error in directory name  (syntax errorp(  *				    or undefined value of n or <n)  *2  *	  RMS$_DNF     '0001C04A'x  Directory not found  *-hE  *	  SS$_NOPRIV   '0024'x  No privilege for attempted operation (user))  *				has no privilege to read directory)I  *5  *	  SS$_NOSUCHDEV  '0908'x  No such device available   *E  *	  SS$_NOMOREFILES  '0930'x  No more files (An \ or > traversal hasm&  *				    exhausted all possibilities)  *E  *	The resultant device and directory are placed in character strings*E  *	DEVICE and DIRECTORY, respectively.  The valid lengths of the str-*E  *	ings are in the INTEGER*4 variables DEVLEN and DIRLEN, respective-c=  *	ly.  These are all in common /SD_LOC/, defined as follows:-  *"  *		CHARACTER*128 DEVICE,DIRECTORY  *2  *		COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  *  *E  *	SD_ always attempts to use a logical name as the resultant device,eE  *	even when the input parameter specifies a physical one.   SD_ usesDE  *	the equivalent of lexical function F$GETDVI(device,"LOGVOLNAM") to:E  *	get  a logical name  when necessary;  SD_  won't use the resulting["  *	name if it begins with "DISK$".  *E  *	The '<n' form of operand requires that the DCL symbols  SD_SP  and E  *	SD_SLOTn (n=0,1,2,...,20)  exist; these are defined by the SD com- E  *	mand.  The 'n' form of operand requires  that the DCL symbol SD__nEE  *	exist for each value of 'n' to be used; see the installation docu-E  *	ment for the SD command.)  *E  *	The second (optional) argument PRIV is a logical quantity (the de-AE  *	fault is .FALSE.).  If true, then certain SD operations work diff-L  *	erently:   *E  *	    SD ^  from DEV:[A] will go to DEV:[000000]  (normally it staysP  *								   at [A])  *E  *	    SD ^  from ROOT:[A] will go to F$TRNLNM(ROOT)  (same as above)T  *E  *	    SD >  from ROOT:[A] will go to [B]             (same as above)   *E  *	    SD @user  is performed  (normally it generates a syntax error)A  *  *-   *	17 Mar 86	Complete rewrite.  *?  *	 5 Jun 86	Don't let SD >  go from ROOT:[A] to [B] unless thei  *			user is privileged.7  *			Allow wildcard characters in directory parameters; -  *			SD will go the FIRST matching directory.N  *?  *	30 Nov 90	Extensive rewrite of this routine and all routinesR  *			which it calls.  *(  *	 1 Feb 91	General rewrite for SD 4.0.  *?  *	 8 Apr 91	Fix problem  of SD<n not showing error when deviceI  *			does not exist.  *?  *	12 Apr 91	Remove extra "." and "]" from right end of operandB  *			beginning with ".."  *?  *	20 Jun 91	Allow "SD," (same as "SD.") since this is a common   *			typing error.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	19 Oct 1984	   Dahlgren, Virginia  22448   *  S  	IMPLICIT NONE_  E  	CHARACTER*(*) PARAM	  	LOGICAL PRIV  S/  	INTEGER*4   NAM$M_CNCL_DEV, NAM$M_NODE		!NODE1,  	PARAMETER ( NAM$M_CNCL_DEV = '00001000'x )2  	PARAMETER ( NAM$M_NODE     = '00020000'x )	!NODE  	#  	INTEGER*4 VALUE,EXPDEV,SLEN / 0 /$  	CHARACTER*256 STRING+  	COMMON /SD_WORK/ VALUE,EXPDEV,SLEN,STRINGA  	  	INTEGER*4 DEVLEN,DIRLENO   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY     	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)t5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSn  R  	INTEGER*4 WLEN  	CHARACTER*256 WORK  	COMMON /WORK/ WLEN,WORK   =/  	INTEGER*4 COL,PCOL,PCOL2,PLEN,VALUE2,SUBINDEX  *2I*  	INTEGER*4 IARGPTR= *2E.@  	LOGICAL SD_GET_SLOT,OTS$CVT_TI_L,SD_LASTDOT,SD_EXIST,SD_SPLIT,B  	1    SD_TRAVERSE,ARG_EXIST,PRIV_,LIB$GET_SYMBOL,SD_NEW_DIRECTORY   B  	SD_ = '184CC'x	    ! Default status is 'Error in Directory Name'  S  	PRIV_ = .FALSE.R *2Ds   	IF (ARG_EXIST(2)) PRIV_ = PRIV *2E  *2IU0  	IF (ARG_EXIST(%VAL(IARGPTR()),2)) PRIV_ = PRIV *2EO  *?  *	If SLEN > 0, the calling program has already put the currente?  *	default device and directory (or the desired baseline point)t/  *	into STRING(1:SLEN).  We assume it is valid.   t  	IF (SLEN.EQ.0) THENS;  	    CALL SD_SPLIT('[]')			! Current default:  SYS$DISK:[]G  	ELSEC  	    CALL SD_SPLIT(STRING(1:SLEN))	! User-specified starting pointR  	ENDIFE)  	CALL SD_CHECK_UNUSUAL(DIRECTORY,DIRLEN)   n,  	IF (IAND(FNB,NAM$M_NODE).NE.0) THEN		!NODE/  	    COL = INDEX(DEVICE(1:DEVLEN),'::')		!NODE *  	    DEVICE = DEVICE(COL+2:DEVLEN)		!NODE'  	    DEVLEN = DEVLEN - COL - 1			!NODE	  	ENDIF						!NODE   1  	EXPDEV = .FALSE.	! No device in any SD operandsC  I
  	PCOL = 1  	PLEN = LEN(PARAM)V  4  10	IF (PCOL.GT.PLEN) THEN:  	    IF (IAND(FNB,NAM$M_CNCL_DEV).EQ.0) CALL SD_TRANSLATE  	    SD_ = SD_EXIST()  	    GO TO 100E  	ENDIFE  )"  	PCOL2 = SUBINDEX(PARAM,PCOL,' ')     	IF (PCOL2.EQ.0) THEN  	    PCOL2 = PLEN + 1  	ELSE IF (PCOL2.EQ.PCOL) THEN  	    PCOL = PCOL + 1L  	    GO TO 10  	ENDIFR  _  	SLEN = PCOL2 - PCOLT  U/  	STRING(1:SLEN+1) = PARAM(PCOL:PCOL2-1) // ' '    L  20	IF (STRING(1:SLEN).EQ.'.' .OR. STRING(1:SLEN).EQ.',') THEN     ! 6/20/91  T!  	    CALL SD_SPLIT('SYS$LOGIN:')I  F$  	ELSE IF (STRING(1:2).EQ.'..') THEN  L!  	    CALL SD_SPLIT('SYS$LOGIN:')g3  	    IF (STRING(SLEN:SLEN).EQ.']') SLEN = SLEN - 1t3  	    IF (STRING(SLEN:SLEN).EQ.'.') SLEN = SLEN - 1 =  	    DIRECTORY(DIRLEN:DIRLEN+SLEN-1) = STRING(2:SLEN) // ']'e   	    DIRLEN = DIRLEN + SLEN - 1  e'  	ELSE IF (STRING(1:SLEN).EQ.'^^') THENe   *  	    COL = INDEX(DIRECTORY(1:DIRLEN),'.')     	    IF (COL.NE.0) THEN  		DIRLEN = COL !  		DIRECTORY(DIRLEN:DIRLEN) = ']'   	    ENDIF   *&  	ELSE IF (STRING(1:SLEN).EQ.'^') THEN  a  	    IF (PRIV_) THENo:  		CALL SD_PARENT(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),1)!  	    ELSE IF (SD_LASTDOT()) THENH  		DIRLEN = VALUE*!  		DIRECTORY(DIRLEN:DIRLEN) = ']'   	    ENDIFR  1#  	ELSE IF (STRING(1:1).EQ.'#') THEN    '  	    CALL SD_INCREMENT(STRING(1:SLEN))   *#  	ELSE IF (STRING(1:1).EQ.'@') THEN    A  	    IF (INDEX(STRING(1:SLEN),'.').NE.0) THEN	! Allow SD @user.xt'  		PCOL2 = SUBINDEX(PARAM,PCOL,'.') - 1,  		SLEN = PCOL2 - PCOL + 1  	    ENDIFt  O,  	    CALL SD_USERHOME(STRING(1:SLEN),PRIV_)  .A  	ELSE IF (STRING(1:SLEN).EQ.'>' .OR. STRING(1:SLEN).EQ.'\') THENh  a3  	    IF (.NOT.SD_TRAVERSE(STRING(1:1),PRIV_)) THEN.&  		SD_ = '00000930'x ! 'no more files'  		GO TO 100  	    ENDIF.  .#  	ELSE IF (STRING(1:1).EQ.'>') THEN0     	    IF (SD_LASTDOT()) THEN8  		DIRECTORY(VALUE+1:VALUE+SLEN) = STRING(2:SLEN) // ']'  		DIRLEN = VALUE + SLEN
  	    ELSE5  		DIRECTORY(1:SLEN+1) = '[' // STRING(2:SLEN) // ']'*  		DIRLEN = SLEN + 1  	    ENDIFc  a#  	ELSE IF (STRING(1:1).EQ.'<') THEN      	    IF (SLEN.EQ.1) THEN   		VALUE = 1<  	    ELSE IF (.NOT.OTS$CVT_TI_L(STRING(2:SLEN),VALUE)) THEN  		GO TO 30B  	    ENDIF.     	    CALL SD_GET_SP(VALUE2)  L+  	    VALUE = MOD( VALUE2-VALUE+021 , 021 )D  _'  	    IF (.NOT.SD_GET_SLOT(VALUE)) THENN  		WORK(1:10) = 'Sys$Login:'  		WLEN = 10  	    ENDIF   bE  	    SD_ = SD_SPLIT(WORK(1:WLEN))   	! Assume this is full dev:[dir]   	    IF (.NOT.SD_) THEN$  		IF (SD_.EQ.'184C4'x) SD_ = '908'x  		GO TO 100  	    ENDIF    3  	ELSE IF (OTS$CVT_TI_L(STRING(1:SLEN),VALUE)) THENe  u5  	    IF (.NOT.LIB$GET_SYMBOL('SD__'//STRING(1:SLEN),e   	1					  STRING,SLEN)) GO TO 30  	    GO TO 20  *  	ELSE  s=  30	     IF (.NOT.SD_NEW_DIRECTORY(STRING(1:SLEN))) GO TO 100.  r  	ENDIFa     	PCOL = PCOL2 + 1
  	GO TO 10  e
  100	SLEN = 0   3 *2Da  	END									  *2E. *2I   	END									   *2E-+  	INTEGER FUNCTION SD_NEW_DIRECTORY(STRING)R  E  **F.  *	INTEGER FUNCTION SD_NEW_DIRECTORY( string )  *  *E  *	This  routine is not called by the user;  it is called by function E  *	SD_ to parse a parameter  which appears to be a device name and/orF  *	directory name.  *  *?  *	17 Jul 85	Save first logical name (if any) used in the input 7  *			string, so it can be used later in the result out-i  *			put string.  *(  *	 1 Feb 91	General rewrite for SD 4.0.  */  *	20 Jun 91	Disallow "[,oct]", "[oct,]", "[,]"e  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	19 Oct 1984	   Dahlgren, Virginia  22448m  *  T>  *	STRING is  LOG:[DIR]  or  LOG:  or  LOG  or  [DIR]  or  DIR  *?  *	LOG could be  DEV  or  DEV:[DIR]  (or even DEV:[DIR]FIL.TYP).  r  	IMPLICIT NONEf     	CHARACTER*(*) STRING  e  	INTEGER*4   NAM$M_ROOT_DIR,  	PARAMETER ( NAM$M_ROOT_DIR = '00002000'x )  B  	INTEGER*4 DEVLEN,DIRLEN	   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  A  	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)I5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSS  P  	INTEGER*4 VALUES  	LOGICAL EXPDEV  	COMMON /SD_WORK/ VALUE,EXPDEV   A  	INTEGER*4 WLEN  	CHARACTER*256 WORK  	COMMON /WORK/ WLEN,WORK   a  	LOGICAL OTS$CVT_TO_L,SD_SPLIT 3  	INTEGER*4 COL,COL1,SUBINDEX,STATUS,FILE_NAME_INFOp  m  	SD_NEW_DIRECTORY = .TRUE.c     	WLEN = LEN(STRING)  	WORK(1:WLEN) = STRINGs   !  10	COL = INDEX(WORK(1:WLEN),':')    *  	IF (WORK(COL:COL+1).EQ.'::') THEN		!NODE+  	    COL = SUBINDEX(WORK,COL+2,':')		! ...u  	    IF (COL.EQ.WLEN) THEN 1  		WORK(WLEN+1:WLEN+DIRLEN) = DIRECTORY(1:DIRLEN)U  		WLEN = WLEN + DIRLENS  	    ENDIFu  	    GO TO 30					! ...  	ENDIF						!NODE  wD  	IF (COL.EQ.0 .OR. COL.EQ.WLEN) THEN	! "XXXX" or "XXXX:" either one%  						!  is a potential logical name*  	    COL1 = WLEN - 1e  	    IF (COL.EQ.0) THEN7  		IF (WORK(1:1).EQ.'[' .OR. WORK(1:1).EQ.'.') GO TO 20[  		COL1 = WLEN  	    ENDIFt  e4  	    STATUS = FILE_NAME_INFO( WORK(1:COL1) // ':' )   (  	    IF (STATUS.EQ.'1C04A'x) STATUS = 1  ]E  	    IF (STATUS) THEN	! We do have a logical name, and it is reason- 1  				!  able (not a MAIL distribution list, etc.)[  iF  !	        If the logical name is rooted, see if the rooting is at the@  !		 first translation, like SYS$SYSROOT, or not, like SYS$HELP./  !		 Fix for SD NSWC$ROOT: EXE (blank between)..  s*  		IF (IAND(FNB,NAM$M_ROOT_DIR).NE.0) THEN3  		    CALL LOG_TRANS(WORK(1:COL1),FN_LEN,FULLNAME)t2  		    IF (FULLNAME(FN_LEN-1:FN_LEN).EQ.'.]') THEN   			DEVICE = WORK(1:COL1) // ':'  			DEVLEN = COL1 + 1A  			EXPDEV = .TRUE.e
  			RETURN  		    ENDIF  		ENDIF  E/  		WLEN = FIELDS(3,2) - FIELDS(1,1) + 1			!NODE 9  		WORK(1:WLEN) = FULLNAME(FIELDS(1,1):FIELDS(3,2))	!NODEC  		EXPDEV = .TRUE.  		GO TO 10      	    ENDIF   2  	    IF (COL.EQ.0) THEN9  20		WORK(1:WLEN+DEVLEN) = DEVICE(1:DEVLEN)//WORK(1:WLEN)c  		WLEN = DEVLEN + WLENC  		COL = DEVLEN   	    ENDIFv  a  	ELSE  *  30	    EXPDEV = .TRUE.'  N  	ENDIFl  (?  	IF (WORK(COL+1:COL+1).EQ.'<') THEN	! Process directory name's .  	    WORK(COL+1:COL+1) = '['		!  left bracket)  	ELSE IF (WORK(COL+1:COL+1).NE.'[') THENI2  	    WORK(COL+1:WLEN+1) = '[' // WORK(COL+1:WLEN)  	    WLEN = WLEN + 1I  	ENDIFv  a=  	IF (WORK(WLEN:WLEN).EQ.'>') THEN	! Process directory name'sc-  	    WORK(WLEN:WLEN) = ']'		!  right bracketH'  	ELSE IF (WORK(WLEN:WLEN).NE.']') THENM  	    WORK(WLEN+1:WLEN+1) = ']'D  	    WLEN = WLEN + 1_  	ENDIFt  p?  	IF (WORK(WLEN-1:WLEN-1).EQ.'.') THEN	! Change [XXX.] to [XXX]t  	    WLEN = WLEN - 1i  	    WORK(WLEN:WLEN) = ']'e  	ENDIFe  u6  	IF (WORK(COL+1:COL+2).EQ.'[.') THEN	! Process [.XXX]  	    IF (COL.GT.0) THEN  		DEVLEN = COLy!  		DEVICE(1:DEVLEN) = WORK(1:COL)*  	    ENDIFe+  	    DIRECTORY(DIRLEN:) = WORK(COL+2:WLEN)p$  	    DIRLEN = DIRLEN + (WLEN-COL-2)  	    EXPDEV = .TRUE.   	    RETURN  	ENDIF;&  						! Check for [octal,octal], each6  	COL1 = INDEX(WORK(1:WLEN),',')		!  3 or fewer digits  	IF (COL1.GT.0) THENrJ  	    IF (WORK(COL1-1:COL1).EQ.'[,'.OR.COL1.GE.WLEN-1) GO TO 100 ! 6/20/916  	    IF (COL1.GT.COL+5 .OR. WLEN.GT.COL1+4) GO TO 100  	    DO WHILE (COL1.LT.COL+5)/  		WORK(COL+2:WLEN+1) = '0' // WORK(COL+2:WLEN)   		WLEN = WLEN + 1  		COL1 = COL1 + 1  	    ENDDO   	    DO WHILE (WLEN.LT.COL1+4)01  		WORK(COL1+1:WLEN+1) = '0' // WORK(COL1+1:WLEN)   		WLEN = WLEN + 1  	    ENDDOo+  	    WORK(COL1:WLEN-1) = WORK(COL1+1:WLEN)   	    WLEN = WLEN - 1w>  	    IF (.NOT.OTS$CVT_TO_L(WORK(COL+2:WLEN-1),COL)) GO TO 100  	ENDIFr   E  	IF (.NOT.SD_SPLIT(WORK(1:WLEN))) THEN	! Fix for SD SYS$HELP:XXX nott'  	    IF (COL.GT.0) THEN			!  aborting.   		DEVICE = WORK(1:COL)]  		DEVLEN = COL	  	    ENDIFi"  	    DIRECTORY = WORK(COL+1:WLEN)  	    DIRLEN = WLEN - COL   	ENDIF   l-  	IF (DIRECTORY(1:DIRLEN).EQ.'[000000]' .AND.o.  	1			     IAND(FNB,NAM$M_ROOT_DIR).NE.0) THEN  iB  	    CALL FILE_NAME_INFO(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),3):  	    IF (EXPDEV .OR. WORK(COL+1:WLEN).NE.'[000000]') THEN  		COL = INDEX(FULLNAME,'.]')x  		FULLNAME(COL:COL) = ']'
  	    ELSE  		COL = INDEX(FULLNAME,':')%  		FULLNAME(COL+1:COL+8) = '[000000]'2  		COL = COL + 8  	    ENDIFS$  	    CALL SD_SPLIT(FULLNAME(1:COL))     	ENDIF*  *  	RETURN  Z  100	SD_NEW_DIRECTORY = .FALSE.e  r *2D	  	END									1 *2E  *2I   	END									   *2E4  	LOGICAL FUNCTION SD_LASTDOT()   H  **E!  *	LOGICAL FUNCTION SD_LASTDOT( )	  *  *E  *	This  routine is not called by the user;  it is called by function'E  *	SD_ to remove the last  subdirectory from a character  string con-	*  *	taining a directory tree specification.  *  *(  *	 1 Feb 91	General rewrite for SD 4.0.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	19 Oct 1984	   Dahlgren, Virginia  22448O  *     	IMPLICIT NONEN  N  	INTEGER*4 VALUEU  	COMMON /SD_WORK/ VALUE  2  	INTEGER*4 DEVLEN,DIRLENO   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  O
  	INTEGER*4 I    (  	VALUE = INDEX(DIRECTORY(1:DIRLEN),'.')  E  	SD_LASTDOT = VALUE .NE. 0=  2  	IF (SD_LASTDOT) THEN  T  	    DO I = VALUE+1, DIRLEN  _'  		IF (DIRECTORY(I:I).EQ.'.') VALUE = I_  B  	    ENDDOD  W  	ENDIFY    *2DD  	END									! *2Eu *2Ia  	END									   *2Ey%  	INTEGER FUNCTION SD_SPLIT(FILENAME)	  (  **X(  *	INTEGER FUNCTION SD_SPLIT( filename )  *  *E  *	This  routine is not called by the user;  it is called by function E  *	SD_ to split a device/directory specification into separate deviceoE  *	and directory parts.  The function result is .FALSE. if the speci-s9  *	fication is not syntactally correct or does not exist.[  *  *(  *	 1 Feb 91	General rewrite for SD 4.0.  *<  *	 8 Apr 91	Compute DEVICE, DIRECTORY even if error occurs.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	19 Oct 1984	   Dahlgren, Virginia  22448(  *  1  	IMPLICIT NONEN     	CHARACTER*(*) FILENAME  :(  	INTEGER*4 NAM$M_EXP_DEV,NAM$M_EXP_DIR	+  	PARAMETER ( NAM$M_EXP_DEV = '00000080'x )D+  	PARAMETER ( NAM$M_EXP_DIR = '00000040'x )      	INTEGER*4 VALUE=  	LOGICAL EXPDEV  	COMMON /SD_WORK/ VALUE,EXPDEV   (  	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)	5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSP  ,  	INTEGER*4 DEVLEN,DIRLEN    	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  	  	INTEGER*4 FILE_NAME_INFO  L%  	SD_SPLIT = FILE_NAME_INFO(FILENAME)+  =  !!!	IF (.NOT.SD_SPLIT) RETURN  20  	DEVLEN = FIELDS(2,2) - FIELDS(1,1) + 1			!NODE<  	DEVICE(1:DEVLEN) = FULLNAME(FIELDS(1,1):FIELDS(2,2))	!NODE   (  	DIRLEN = FIELDS(3,2) - FIELDS(3,1) + 19  	DIRECTORY(1:DIRLEN) = FULLNAME(FIELDS(3,1):FIELDS(3,2))E  L *2DQ  	END									  *2E  *2I   	END									   *2E'  	SUBROUTINE SD_TRANSLATE   E  **(  *	SUBROUTINE SD_TRANSLATE  *  *E  *	This  routine is not called by the user;  it is called by functionLE  *	SD_ to attempt to translate any  physical device  names  to  site-   *	specific logical names.  *  *(  *	 1 Feb 91	General rewrite for SD 4.0.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	19 Oct 1984	   Dahlgren, Virginia  22448/  *  R  	IMPLICIT NONE	     	INCLUDE '($DVIDEF)'T  H  	INTEGER*4 DEVLEN,DIRLENR   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY     	CHARACTER*128 WORK  	CHARACTER*64 VOLNAM*)  	INTEGER*4 WLEN,STATUS,ITMLST(4),IOSB(2)   	INTEGER*2 VNLENI9  	COMMON /WORK/ WLEN,WORK,VOLNAM,ITMLST,STATUS,IOSB,VNLENS  N!  	INTEGER*4 SYS$GETDVIW,LOG_TRANS   L  	VOLATILE VOLNAM,VNLENt  O  	4  	CALL ITEM_LIST(ITMLST,DVI$_LOGVOLNAM,VOLNAM,VNLEN)   9  	STATUS = SYS$GETDVIW(,,DEVICE(1:DEVLEN),ITMLST,IOSB,,,)a  	+  	IF (.NOT.STATUS .OR. .NOT.IOSB(1)) RETURNT  .  	IF (VNLEN.EQ.0) RETURN  m3  	IF (VNLEN.GT.5 .AND. VOLNAM(1:5).EQ.'DISK$') THEN   R;  	    IF (.NOT.LOG_TRANS('SYS$SYSDEVICE',WLEN,WORK)) RETURND  C0  	    IF (WORK(1:WLEN).EQ.DEVICE(1:DEVLEN)) THEN  		DEVLEN = 14"  		DEVICE(1:14) = 'SYS$SYSDEVICE:'  	    ENDIF'     	ELSE  E  	    DEVLEN = VNLEN + 1/  	    DEVICE(1:DEVLEN) = VOLNAM(1:VNLEN) // ':'E  <  	ENDIF     *2D   	END									E *2E	 *2IE  	END									   *2E.  	INTEGER FUNCTION SD_EXIST()U     **   *	INTEGER FUNCTION SD_EXIST( )	  *  *E  *	This  routine is not called by the user;  it is called by function_E  *	SD_ to verify that the resultant device and directory actually ex-'  *	ist.   *  *:  *	 5 Jun 86	Handle wildcards in directory specifications.  *(  *	 1 Feb 91	General rewrite for SD 4.0.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	19 Oct 1984	   Dahlgren, Virginia  22448)  *     	IMPLICIT NONET  B;  	INTEGER*4 NAM$M_WILDCARD,NAM$M_ROOT_DIR,NAM$M_SEARCH_LIST 5  	PARAMETER ( NAM$M_WILDCARD    = '00000100'x )	!WILD./  	PARAMETER ( NAM$M_ROOT_DIR    = '00002000'x ) /  	PARAMETER ( NAM$M_SEARCH_LIST = '00000800'x )      	INTEGER*4 VALUE,EXPDEV,SLEN	  	CHARACTER*256 STRING+  	COMMON /SD_WORK/ VALUE,EXPDEV,SLEN,STRINGS  E  	INTEGER*4 DEVLEN,DIRLEN*   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  l  	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)i5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSm     	LOGICAL SD_WILDCARD				!WILD.  	INTEGER*4 SD_PARENT,OPEN_TEST,FILE_NAME_INFO  n  sA  10	SD_EXIST = SD_PARENT(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),2)*   0  	IF (IAND(FNB,NAM$M_WILDCARD).NE.0) THEN		!WILD)  	    IF (SD_WILDCARD()) GO TO 10			!WILD   	ENDIF						!WILD   <  !	IF (IAND(FNB,NAM$M_SEARCH_LIST).NE.0) RETURN		!AZ 2/20/919  	IF (IAND(FNB,NAM$M_SEARCH_LIST).NE.0) THEN		!AZ 2/20/91:/  	    SD_EXIST = FILE_NAME_INFO(				!AZ 2/20/91 .  	1			  DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN)))  	    IF (SD_EXIST) RETURN				!AZ 2/20/91   	ENDIF							!AZ 2/20/91   N  	IF (.NOT.SD_EXIST) THEN	  A<  	    IF (SD_EXIST.EQ.'1C04A'x) THEN ! 'directory not found'  R:  		IF (.NOT.EXPDEV.AND.IAND(FNB,NAM$M_ROOT_DIR).NE.0) THEN  NB  *	If directory does not exist, and we are looking for ROOT:[DIR],;  *	i.e. DEVICE:[XXX.][DIR], then check to see if there is aO4  *	DEVICE:[DIR] on the same device; if so, go to it.  	  		    CALL FILE_NAME_INFO(W.  	1			DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),3)5  		    DEVLEN = FIELDS(2,2) - FIELDS(1,1) + 1		 !NODEAA  		    DEVICE(1:DEVLEN) = FULLNAME(FIELDS(1,1):FIELDS(2,2)) !NODE_  		    CALL SD_TRANSLATE  		    GO TO 10c     		ENDIF  N  	    ENDIFO  1$  !	184C4 = 'error in device name...'%  !	1829A = 'insufficent privilege...'CD  	    IF (SD_EXIST.EQ.'184C4'x) SD_EXIST = '908'x ! 'no such device'A  	    IF (SD_EXIST.EQ.'1829A'x) SD_EXIST = '24'x	! 'no privilege'E  	    RETURN     	ENDIF   N?  *	Check that this process has read permission in the resultant!
  *	directory.(  ./  	SD_EXIST = OPEN_TEST(FULLNAME(1:FIELDS(6,2)))i  r  	IF (SD_EXIST) THEN.  30	    IF (DIRECTORY(1:8).EQ.'[000000.') THEN  		DIRLEN = DIRLEN - 75  		DIRECTORY(1:DIRLEN) = '[' // DIRECTORY(9:DIRLEN+7)2  		GO TO 30   	    ENDIFND  	ELSE  IF (SD_EXIST.EQ.'1829A'x) THEN ! 'insufficient privilege...'0  	    SD_EXIST = '00024'x		     ! 'no privilege'  !	18292 = 'file not found' '  !	18744 = 'invalid wildcard operation'!E  	ELSE IF (SD_EXIST.EQ.'18292'x .OR. SD_EXIST.EQ.'18744'x) THEN	!WILDi7  	    SD_EXIST = '1C04A'x		     ! 'directory not found'r  	ENDIFa  n *2De  	END									n *2Ei *2IS  	END									   *2ES.  	INTEGER FUNCTION SD_PARENT(FILENAME,OPTIONS)  ,  **_5  *	INTEGER FUNCTION SD_PARENT( filename [, options] ))  *  *E  *	Computes the directory name of the file whose name is in the char-IE  *	acter  string argument FILENAME.   Information about the directory E  *	name is returned  in variables in common block  /FILE_NAME_INFO_/,1E  *	which is described in the documentation of routine FILE_NAME_INFO.N  *E  *	Examples:  After  SD_PARENT('UDISK2:[AA.BB]') is called, character.8  *		   variable FULLNAME contains 'UDISK2:[AA]BB.DIR;1'.  *>  *		   After SD_PARENT('UDISK2:[A]') is called,  FULLNAME con-&  *		   tains 'UDISK2:[000000]A.DIR;1'.  *>  *		   After SD_PARENT('SYS$MANAGER') is called, FULLNAME con->  *		   tains  (for example)  'DUA0:[SYS0]SYSMGR.DIR;1'.   Note>  *		   that device  name is always translated  to physical  in  *		   this case.   *E  *	SD_PARENT calls FILE_NAME_INFO (and SYS$PARSE) two or three times.NE  *	The function result  returned from SD_PARENT is the result it gets	5  *	from FILE_NAME_INFO for the parent directory name.T  *	 E  *	If the optional argument OPTIONS is present,  it contains the fol-   *	lowing bits::  *E  *	  Bit 0 - Also perform the function of routine SD_SPLIT on the re- $  *		  sulting parent directory name.  *E  *	  Bit 1 - The device name in the file name is a search list; don't0>  *		  translate this name.  This allows us to find a directory>  *		  which only exists  in elements of the search list  after  *		  the first.  *E  *	  Bit 2 - Return ROOT:[000000], not DEV:[ROOTXXX] as the parent ofk  *		  ROOT:[EXE].   *  *(  *	 1 Feb 91	General rewrite for SD 4.0.  *  *	.INDEX FILE NAMES>>  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55-  *	14 March 1986	   Dahlgren, Virginia  22448C  *  G  	IMPLICIT NONEO  I  	CHARACTER*(*) FILENAME  	INTEGER*4 OPTIONS   W<  	INTEGER*4 NAM$M_SEARCH_LIST,NAM$M_DIR_LVLS,NAM$M_ROOT_DIR,  	1						  NAM$V_DIR_LVLSL/  	PARAMETER ( NAM$M_SEARCH_LIST = '00000800'x )O/  	PARAMETER ( NAM$M_DIR_LVLS    = '00E00000'x )o/  	PARAMETER ( NAM$M_ROOT_DIR    = '00002000'x )	&  	PARAMETER ( NAM$V_DIR_LVLS    = 21 )  T  	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)(5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   F  	INTEGER*4 DEVLEN,DIRLENi   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  C  	LOGICAL ARG_EXISTL *2IW  	INTEGER*4 IARGPTR  *2E	;  	INTEGER*4 OPTIONS_,SUBINDEX,FILE_NAME_INFO,SUB_LVLS,COL,I(  	INTEGER*4 BITS  E  	OPTIONS_ = 0 *2DA&  	IF (ARG_EXIST(2)) OPTIONS_ = OPTIONS *2E( *2IL6  	IF (ARG_EXIST(%VAL(IARGPTR()),2)) OPTIONS_ = OPTIONS *2E   N
  	BITS = 2  	IF (OPTIONS_.EQ.2) BITS = 0M  O+  	SD_PARENT = FILE_NAME_INFO(FILENAME,BITS)N  ,B  	IF (OPTIONS_.EQ.2 .AND. IAND(FNB,NAM$M_SEARCH_LIST).NE.0) RETURN  N  	IF (.NOT.SD_PARENT) GO TO 100E  C?  	SUB_LVLS = ISHFT( IAND(FNB,NAM$M_DIR_LVLS) , -NAM$V_DIR_LVLS)L  e  	IF (SUB_LVLS.GT.0) THEN1  							! Case 1: DEV:[A.B...]  	    COL = FIELDS(3,1)N  	    DO I=1,SUB_LVLSE%  		COL = SUBINDEX(FULLNAME,COL+1,'.')*  	    ENDDO   u>  	    FULLNAME(COL:) = ']' // FULLNAME(COL+1:FIELDS(3,2)-1) //  	1							'.DIR;1'  s.  	ELSE IF (IAND(FNB,NAM$M_ROOT_DIR).NE.0) THEN  							! Case 2: ROOT:[A]  	    IF (OPTIONS_.NE.4) THEN1  n)  		SD_PARENT = FILE_NAME_INFO(FILENAME,3).   		IF (.NOT.SD_PARENT) GO TO 100  t  		COL = INDEX(FULLNAME,'.]')   4;  		FULLNAME(COL:) = ']' // FULLNAME(COL+3:FIELDS(3,2)-1) //   	1							'.DIR;1'
  	    ELSE  R  		COL = FIELDS(3,1) + 1   		FULLNAME(COL:) = '000000]' //.  	1			 FULLNAME(COL:FIELDS(3,2)-1) // '.DIR;1'  	    ENDIFO     	ELSE  							! Case 3: DEV:[A]N  	    COL = FIELDS(2,2) + 2    ?  	    FULLNAME(COL:) = '000000]' // FULLNAME(COL:FIELDS(3,2)-1)   	1						     // '.DIR;1'_  	  	ENDIFC  Y-  	SD_PARENT = FILE_NAME_INFO(FULLNAME(1:255))   N,  !	186D4 = 'file specification syntax error'$  !	184CC = 'error in directory name'  I4  100	IF (SD_PARENT.EQ.'186D4'x) SD_PARENT = '184CC'x  S#  	IF (IAND(OPTIONS_,1).EQ.0) RETURNu  e0  	DEVLEN = FIELDS(2,2) - FIELDS(1,1) + 1			!NODE<  	DEVICE(1:DEVLEN) = FULLNAME(FIELDS(1,1):FIELDS(2,2))	!NODE  a(  	DIRLEN = FIELDS(3,2) - FIELDS(3,1) + 19  	DIRECTORY(1:DIRLEN) = FULLNAME(FIELDS(3,1):FIELDS(3,2))t  n *2Dl  	END									s *2Ee *2I[  	END									   *2En)  	INTEGER FUNCTION SD_TRAVERSE(TYPE,PRIV)C  u  **V.  *	INTEGER FUNCTION SD_TRAVERSE( type , priv )  *  *E  *	This  routine is not called by the user;  it is called by function9E  *	SD_ to perform a traversal operation (i.e. SD > or SD \).  Charac-C.  *	ter string TYPE must be either '>' or '\').  *9  *	See routine SD_ for a definition of the PRIV argument.	  *  *(  *	 1 Feb 91	General rewrite for SD 4.0.  *  *?  *	 5 Jun 86	Don't let SD >  go from ROOT:[A] to [B] unless the   *			user is privileged.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	17 Mar 1986	   Dahlgren, Virginia  22448E  *  R  	IMPLICIT NONE*     	CHARACTER*(*) TYPE  	LOGICAL PRIV  N8  	INTEGER*4 NAM$M_ROOT_DIR,NAM$M_DIR_LVLS,NAM$V_DIR_LVLS,  	PARAMETER ( NAM$M_ROOT_DIR = '00002000'x ),  	PARAMETER ( NAM$M_DIR_LVLS = '00E00000'x )#  	PARAMETER ( NAM$V_DIR_LVLS = 21 )O     	INTEGER*4 DEVLEN,DIRLENM   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  T  	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)	5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSS  R  	INTEGER*4 WLEN  	CHARACTER*255 WORK  	COMMON /WORK/ WLEN,WORKu  e+  	INTEGER*4 SUB_LVLS,CONTEXT,COL1,COL2,COL3f,  	LOGICAL SD_LASTDOT,SD_PARENT,LIB$FIND_FILE  s'  	IF (TYPE.EQ.'>' .AND. .NOT.PRIV) THENi  oB  	   SUB_LVLS = ISHFT( IAND(FNB,NAM$M_DIR_LVLS) , -NAM$V_DIR_LVLS)   @  	   IF (SUB_LVLS.EQ.0 .AND. IAND(FNB,NAM$M_ROOT_DIR).EQ.0) THEN  		SD_TRAVERSE = 0	  		RETURN 
  	   ENDIF  /=  	ELSE IF (TYPE.EQ.'\') THEN	! Try going down one level firstN  E  	    CONTEXT = 0   H4  	    SD_TRAVERSE = LIB$FIND_FILE(DEVICE(1:DEVLEN)//5  	1		    DIRECTORY(1:DIRLEN)//'*.DIR;1',WORK,CONTEXT)H  CC  	    IF (SD_TRAVERSE) GO TO 20	! Yes, there is a subdirectory here*  NC  	    IF (.NOT.SD_LASTDOT()) GO TO 30	! If no subs under [A], don't   						!  go to [B]I  	ENDIFN   B  	SD_TRAVERSE = SD_PARENT(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),4)  O  	IF (.NOT. SD_TRAVERSE) RETURN=  S
  	CONTEXT = 0C  :C  10	SD_TRAVERSE = LIB$FIND_FILE(FULLNAME(1:FIELDS(3,2))//'*.DIR;1',T  	1						   WORK,CONTEXT)   U   	IF (.NOT.SD_TRAVERSE) GO TO 30  (/  	IF (WORK.NE.FULLNAME(1:FIELDS(6,2))) GO TO 10A  'A  	SD_TRAVERSE = LIB$FIND_FILE(FULLNAME(1:FIELDS(3,2))//'*.DIR;1',E  	1						   WORK,CONTEXT)V     	IF (.NOT.SD_TRAVERSE) THEN  	    IF (TYPE.EQ.'>') GO TO 30L=  	    CALL SD_PARENT(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),1)A5  	    IF (DIRECTORY(1:DIRLEN).EQ.'[000000]') GO TO 30	  	    GO TO 10  	ENDIF	  	  20	COL1 = INDEX(WORK,'[') + 14  	IF (WORK(COL1:COL1+5).EQ.'000000') COL1 = COL1 + 7     	COL2 = INDEX(WORK,']')!  	COL3 = INDEX(WORK,'.DIR;1') - 1l     	WORK(COL2:COL2) = '.'e  y  	DIRLEN = COL3 - COL1 + 3  d5  	DIRECTORY(1:DIRLEN) = '[' // WORK(COL1:COL3) // ']'H  l#  30	CALL LIB$FIND_FILE_END(CONTEXT)n    *2D*  	END									l *2Ei *2Ir  	END									   *2E    	LOGICAL FUNCTION SD_WILDCARD()  e  ** "  *	LOGICAL FUNCTION SD_WILDCARD( )  *  *E  *	This  routine is not called by the user;  it is called by functionDE  *	SD_ to attempt to remove wildcards from a directory specification. E  *	The function result is .TRUE. if a directory exists  which matches   *	the wildcard specification.  *  *)  *	  1 Feb 91	General rewrite for SD 4.0.E  *@  *	 17 Apr 91	Fix problem:  if in ROOT:[A] and SD >B*, should go#  *			to ROOT:[BX], not DISK:[Y.BX].	  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	 5 Jun 1986	   Dahlgren, Virginia  224485  *  A  	IMPLICIT NONEI  S  	INTEGER*4 DEVLEN,DIRLEN_   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  P  	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)E5  	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDSM  L  	INTEGER*4 WLEN  	CHARACTER*256 WORK  	COMMON /WORK/ WLEN,WORK   	"  	INTEGER*4 VALUE					! AZ 4/17/91(  	COMMON /SD_WORK/ VALUE				! AZ 4/17/91  1"  	INTEGER*4 CONTEXT,COL1,COL2,COL30  	LOGICAL LIB$FIND_FILE,SD_LASTDOT		! AZ 4/17/91  I
  	CONTEXT = 00   D  !!!	SD_WILDCARD = LIB$FIND_FILE(FULLNAME(1:FN_LEN),WORK,CONTEXT)	 !  									 !"  	IF (SD_LASTDOT()) THEN						 !AZE  	    SD_WILDCARD = LIB$FIND_FILE(FULLNAME(1:FN_LEN),WORK,CONTEXT) !4H  	ELSE								 !17E  	    SD_WILDCARD = LIB$FIND_FILE(DEVICE(1:DEVLEN)//'[000000]'//	 !91 7  	1		     DIRECTORY(2:DIRLEN-1)//'.DIR',WORK,CONTEXT) !r  	ENDIF								 !e  E  	IF (SD_WILDCARD) THENe  t  	    COL1 = INDEX(WORK,'[')  	    COL2 = INDEX(WORK,']')!  	    COL3 = INDEX(WORK,'.DIR;1')E  M  	    DIRLEN = COL3 - COL1 + 1  I  	    WORK(COL2:COL2) = '.'D  	    WORK(COL3:COL3) = ']'1   +  	    DIRECTORY(1:DIRLEN) = WORK(COL1:COL3)A  F  	ENDIF)  E!  	CALL LIB$FIND_FILE_END(CONTEXT)A  A *2D	  	END									  *2EE *2I   	END									   *2E1   	SUBROUTINE SD_INCREMENT(PARAM)  1  **=#  *	SUBROUTINE SD_INCREMENT( param )F  *  *E  *	This  routine is not called by the user;  it is called by functionTE  *	SD_ to process a parameter of the form "#" or "#nnn",  where "nnn"N  *	is a hexadecimal number.p  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448F  *  I  *	If PARAM is "#":(E  *	  If current directory is [SYSi], or [SYSi.xxx...], then we changeY=  *	  to [SYSj], or [SYSj.xxx...], where j=i+1 in hexadeximal.   *	If PARAM is "#z":E  *	  If current directory is [SYSi], or [SYSi.xxx...], then we change=<  *	  to [SYSz], or [SYSz.xxx...], where i,z are hexadeximal.  !  	IMPLICIT NONE   d,  	CHARACTER*(*) PARAM	! Either '#' or '#xxx'     	INTEGER*4 DEVLEN,DIRLENT   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  e-  	INTEGER*4 COL1,COL2,COL3,VALUE,OTS$CVT_TZ_L   	CHARACTER*8 VALUE_  I.  	IF (DEVICE(1:DEVLEN).EQ.'SYS$SYSROOT:') THEN1  	    CALL LOG_TRANS('SYS$SYSROOT',DEVLEN,DEVICE)*(  	    COL1 = INDEX(DEVICE(1:DEVLEN),'[')(  	    COL2 = INDEX(DEVICE(1:DEVLEN),']')<  	    DIRECTORY = DEVICE(COL1:COL2-1) // DIRECTORY(2:DIRLEN)+  	    DIRLEN = (COL2 - COL1) + (DIRLEN - 1)o  	    DEVLEN = 14_%  	    DEVICE(1:14) = 'SYS$SYSDEVICE:'d  	ENDIFi  o*  	COL1 = INDEX(DIRECTORY(1:DIRLEN),'[SYS')  f  	IF (COL1.EQ.0) RETURNA  ]  	COL1 = COL1 + 4c  .*  	COL2 = INDEX(DIRECTORY(COL1:DIRLEN),'.')  ]  	IF (COL2.LE.1) THENA.  	    COL2 = INDEX(DIRECTORY(COL1:DIRLEN),']')  	    IF (COL2.LE.1) RETURN[  	ENDIFD  1  	COL2 = COL2 + COL1 - 2  T;  	IF (.NOT.OTS$CVT_TZ_L(DIRECTORY(COL1:COL2),VALUE)) RETURNe  p3  	IF (LEN(PARAM).EQ.1) THEN	! Parameter is just '#'e  e/  	    CALL SYS$FAO('!XL',,VALUE_,%VAL(VALUE+1))	  t  	    COL3 = 8$  10	    IF (VALUE_(1:1).EQ.'0') THEN  		VALUE_ = VALUE_(2:)  		COL3 = COL3 - 1  		GO TO 10   	    ENDIF   P  	ELSE				! Parameter is '#nnn'f     	    COL3 = LEN(PARAM) - 1   e  	    VALUE_ = PARAM(2:)     	ENDIFa  m3  	DIRECTORY = DIRECTORY(1:COL1-1) // VALUE_(1:COL3)w'  	1				     // DIRECTORY(COL2+1:DIRLEN) (  	DIRLEN = DIRLEN - (COL2-COL1+1) + COL3    *2D   	END									r *2Ey *2I.  	END									   *2Ev$  	SUBROUTINE SD_USERHOME(PARAM,PRIV)  t  **')  *	SUBROUTINE SD_USERHOME( param , priv )   *  *E  *	This  routine is not called by the user;  it is called by function E  *	SD_ to process a parameter of the form  "@"  or "@username", whereV5  *	"username" is the login username of some VAX user.*  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448t  *  	  	IMPLICIT NONE1  a  	CHARACTER*(*) PARAMi  	LOGICAL PRIV     	INCLUDE '($UAIDEF)'I  	  	INTEGER*4 DEVLEN,DIRLENN   	CHARACTER*128 DEVICE,DIRECTORY0  	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY  	'  	INTEGER*4 STATUS,SYS$GETUAI,ITMLST(7)$  E  	VOLATILE /SD_LOC/'  O  	IF (PARAM.EQ.'@') THEN!  	    CALL SD_SPLIT('SYS$LOGIN:')E  	    RETURN  	ENDIF   0  	IF (.NOT.PRIV) THEN >  	    CALL SD_MESSAGE('Syntax Error')	! Simulate CALL ERROR(1)8  	    CALL EXIT('10000004'x)		! Abort, without a message  	ENDIFO  F2  	CALL ITEM_LIST(ITMLST,UAI$_DEFDEV,DEVICE,DEVLEN,(  	1		      UAI$_DEFDIR,DIRECTORY,DIRLEN)  O,  	STATUS = SYS$GETUAI(,,PARAM(2:),ITMLST,,,)     	IF (.NOT.STATUS) THENWD  	    CALL SD_MESSAGE('No Such User as '//PARAM(2:)) ! CALL ERROR(2)8  	    CALL EXIT('10000004'x)		! Abort, without a message  	ENDIF	  (  	DEVLEN = ICHAR(DEVICE(1:1))S   	DIRLEN = ICHAR(DIRECTORY(1:1))  R  	DEVICE(1:DEVLEN) = DEVICE(2:)2%  	DIRECTORY(1:DIRLEN) = DIRECTORY(2:))  T *2DM  	END									  *2EE *2I_  	END									   *2E '  	INTEGER FUNCTION SD_GET_SLOT(ORDINAL)S  C  **T*  *	INTEGER FUNCTION SD_GET_SLOT( ordinal )  *  *E  *	This  routine is not called by the user;  it is called by function E  *	SD_ to get the current value of DCL Symbol SD_SLOTn,  where "n" isO   *	the value of integer ORDINAL.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  224481  *  	  	IMPLICIT NONE      	INTEGER*4 ORDINALA  	CHARACTER*(*) STRING  	  	INTEGER*4 SD_PUT_SLOT      	INTEGER*4 WLEN  	CHARACTER*256 WORK  	COMMON /WORK/ WLEN,WORKA  3  	CHARACTER*2 ORDP  	INTEGER*4 O,LIB$GET_SYMBOL  D)  	CALL SYS$FAO('!UL',O,ORD,%VAL(ORDINAL))    =  	SD_GET_SLOT = LIB$GET_SYMBOL('SD_SLOT'//ORD(1:O),WORK,WLEN)   E  	RETURN  =  E  (#  	ENTRY SD_PUT_SLOT(ORDINAL,STRING)]  /  **	-  *	SUBROUTINE SD_PUT_SLOT( ordinal , string )   *  *E  *	This  routine is not called by the user;  it is called by function E  *	SD_ to store a new value in DCL Symbol SD_SLOTn,  where "n" is the	E  *	value of integer ORDINAL, and "n" ranges from 0 to 19.  These sym-OE  *	bols record  the last 20 directories  to which SD has moved;  they!E  *	implement a circular buffer; DCL Symbol SD_SP contains the ordinal %  *	of the current slot in the buffer.T  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448L  *  ))  	CALL SYS$FAO('!UL',O,ORD,%VAL(ORDINAL))(  )3  	CALL LIB$SET_SYMBOL('SD_SLOT'//ORD(1:O),STRING,2)E  ( *2Dt  	END										 *2E	 *2I   	END									   *2E	  	SUBROUTINE SD_GET_SP(VALUE)S  R  **E   *	SUBROUTINE SD_GET_SP( value )  *  *E  *	This  routine is not called by the user;  it is called by function E  *	SD_ to get the current value of DCL Symbol SD_SP.   If this symbolrE  *	is undefined,  we assume a value of "0" and we also set DCL Symbol D  *	SD_SLOT0 to the name of the current default device and directory.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448s  *     	IMPLICIT NONEi  e  	INTEGER*4 VALUE,NEWVALUE     	INTEGER*4 WLEN  	CHARACTER*256 WORK  	COMMON /WORK/ WLEN,WORK   l  	INTEGER*4 SD_SP / -1 /  R'  	INTEGER*4 LIB$GET_SYMBOL,OTS$CVT_TI_LY     	IF (SD_SP.GE.0) THEN  E  	    GO TO 10  N2  	ELSE IF (LIB$GET_SYMBOL('SD_SP',WORK,WLEN)) THEN  D4  	    IF (OTS$CVT_TI_L(WORK(1:WLEN),SD_SP)) GO TO 10  0  	ENDIF	  A  	SD_SP = 0_  _#  	CALL DEFAULT_DIRECTORY(WORK,WLEN)D  E"  	CALL SD_PUT_SLOT(0,WORK(1:WLEN))  	  10	VALUE = SD_SPL  D  	RETURN  D  C  Y  	ENTRY SD_PUT_SP(NEWVALUE)   H  **E#  *	SUBROUTINE SD_PUT_SP( newvalue )2  *  *E  *	This  routine is not called by the user;  it is called by functionNE  *	SD_ to store a new value in Global DCL Symbol SD_SP.  VMS does not_E  *	allow us to create an integer symbol, so we create a string symbolI  *	with an integer value.A  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448N  *  (  	SD_SP = NEWVALUE  0+  	CALL SYS$FAO('!UL',WLEN,WORK,%VAL(SD_SP))E  F-  	CALL LIB$SET_SYMBOL('SD_SP',WORK(1:WLEN),2)d    *2De  	END										 *2EO *2I   	END									   *2ES1  	SUBROUTINE SD_CHECK_UNUSUAL(DIRECTORY_,DIRLEN_)C  Y  **R4  *	SUBROUTINE SD_CHECK_UNUSUAL( directory , dirlen )  *  *E  *	This routine is not called by the user; it is called by the SD andOE  *	LET  utilities to check for directory names in legal but "unusual"NE  *	formats, and to normalize them into the regular formats.   UnusualNE  *	formats  include use of angle brackets instead of square brackets,	5  *	and directories in octal UIC format.  For example:.  *2  *		SYS$SYSDEVICE:<AAA>  --->  SYS$SYSDEVICE:[AAA]5  *		SYS$SYSDEVICE:[1,7]  --->  SYS$SYSDEVICE:[001007](5  *		SYS$SYSDEVICE:<1,7>  --->  SYS$SYSDEVICE:[001007]L  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55*  *	1 Feb 1991	   Dahlgren, Virginia  22448  *  3  	IMPLICIT NONE_  E  	CHARACTER*(*) DIRECTORY_  	INTEGER*4 DIRLEN_   F  	INTEGER*4 COLL  	CHARACTER*2 PAD / '00' /  	"  	IF (DIRECTORY_(1:1).EQ.'<') THEN  	    DIRECTORY_(1:1) = '['('  	    DIRECTORY_(DIRLEN_:DIRLEN_) = ']'1  	ENDIF   O,  	COL = INDEX( DIRECTORY_(1:DIRLEN_) , ',' )  '  	IF (COL.EQ.0) RETURN  2  	IF (DIRLEN_-COL.LT.4) THEN4  	    DIRECTORY_(COL+1:) = PAD(1:4-(DIRLEN_-COL)) //'  	1				       DIRECTORY_(COL+1:DIRLEN_)I  	ENDIFN  T  	IF (COL.LT.5) THEN8  	    DIRECTORY_ = '[' // PAD(1:5-COL) // DIRECTORY_(2:)  	ENDIFS  I0  	DIRECTORY_ = DIRECTORY_(1:4) // DIRECTORY_(6:)  )%  	DIRLEN_ = INDEX( DIRECTORY_ , ']' )d    *2Ds  	END									  *2En *2ID  	END									   *2Em"  	SUBROUTINE SD_CONFIGURE_TERMINAL  a  ** #  *	SUBROUTINE SD_CONFIGURE_TERMINAL   *  *E  *	This routine is not called by the user; it is called by the SD and E  *	LET utilities to determine whether the utility is being run inter- "  *	actively from a video terminal.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448   *  6  	IMPLICIT NONEg  a  	INCLUDE '($TTDEF)'  	INCLUDE '($TT2DEF)'E  *  	LOGICAL TOOWIDE	&  	INTEGER*4 SCREEN_LENGTH,SCREEN_WIDTH1  	COMMON /SD_TERMINAL/ SCREEN_LENGTH,SCREEN_WIDTHE  *  	STRUCTURE /CHARBUF/E  	  BYTE DEVICE_CLASSE  	  BYTE DEVICE_TYPE  	  INTEGER*2 PAGE_WIDTH	  	  unionL	  	    mapM  	      INTEGER*4 BASIC_CHAR
  	    end map 	  	    mapO  	      BYTE %FILL (3)  	      BYTE PAGE_LENGTH
  	    end map/
  	  end union	  	  INTEGER*4 EXT_CHAR  	END STRUCTUREO  C  	RECORD /CHARBUF/ CHARBUF  L  	COMMON /SMGL_CHAR/ CHARBUF  	!  	CALL SMGL_GET_TERMINAL_SETTINGS=  B%  	SCREEN_LENGTH = CHARBUF.PAGE_LENGTHE$  	SCREEN_WIDTH  = CHARBUF.PAGE_WIDTH   @  	IF (IAND(CHARBUF.BASIC_CHAR,TT$M_SCOPE).EQ.0) SCREEN_WIDTH = 0  W  	RETURN  !     L  	ENTRY SD_RESTORE_TERMINALC     **$!  *	SUBROUTINE SD_RESTORE_TERMINAL0  *  *E  *	This routine  is not called  by the user;  it is called by  the SD	E  *	utility to set the VTnnn numeric keypad from application mode back)"  *	to numeric mode when necessary.  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448   *   3  	IF (IAND(CHARBUF.EXT_CHAR,TT2$M_APP_KEYPAD).EQ.0)    	1					       CALL SCREEN('>')  D *2DE  	END										 *2E	 *2I	  	END									   *2E	  	SUBROUTINE SD_MESSAGE(TEXT)_  R  **(   *	SUBROUTINE SD_MESSAGE( text )  *  *E  *	This routine is not called by the user; it is called by the SD andsE  *	LET utilities  to display  a message.   If the user  is on a video"E  *	terminal,  the message is displayed in reverse video and the term-Z  *	inal bell is rung twice.r  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448e  *  s  	IMPLICIT NONE.  .  	CHARACTER*(*) TEXT   &  	INTEGER*4 SCREEN_LENGTH,SCREEN_WIDTH1  	COMMON /SD_TERMINAL/ SCREEN_LENGTH,SCREEN_WIDTHu  n  	LOGICAL SD_DEBUG  	COMMON /SD_DEBUG/ SD_DEBUG  g  	CHARACTER*10 PREFIX[6  	PARAMETER (PREFIX = CHAR(10)//CHAR(10)//'[1;7m  ' )  	CHARACTER*8  SUFFIX*;  	PARAMETER (SUFFIX = '  [m'//CHAR(10)//CHAR(7)//CHAR(7) )E     	IF (SD_DEBUG) THEN9  	    CALL LIB$PUT_OUTPUT(CHAR(10)//'  '//TEXT//CHAR(10))Y,  	    CALL LIB$SET_SYMBOL('SD_MESSAGE',TEXT)  	    RETURN  	ENDIFA  _  	CALL SD_CONFIGURE_TERMINAL  S&  	IF (SCREEN_WIDTH.NE.0) THEN		! Video  Y'  	    CALL SCREEN(PREFIX//TEXT//SUFFIX)I  X  	ELSE					! Hardcopy      	    CALL LIB$PUT_OUTPUT(' ')%  	    CALL LIB$PUT_OUTPUT('  '//TEXT)2  	    CALL LIB$PUT_OUTPUT(' ')  I  	ENDIFO  - *2D)  	END									  *2E  *2IN  	END									   *2E)1  	SUBROUTINE DEFAULT_DIRECTORY(DIR_STRING,LENGTH)D  C  **1:  *	SUBROUTINE DEFAULT_DIRECTORY( dir_string , [ length ] )  *  *E  *	Returns, in the character string DIR_STRING, the name of the  cur-)E  *	rent  default device and directory.  The string DIR_STRING must beL?  *	long enough to contain the name, or this routine will abort.N  *E  *	If the optional integer*4 argument LENGTH  is  supplied,  then theE(  *	length of the name is returned there.  *  *3  *	 1 Feb 91	Use LOG_TRANS routine, not SYS$TRNLOG.3  *  *	.INDEX ENVIRONMENT>>.  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55*  *	9 Nov 1983	   Dahlgren, Virginia  22448  *     	IMPLICIT NONEN  R  	CHARACTER*(*) DIR_STRING  	INTEGER*4 LENGTH  a  	LOGICAL ARG_EXISTI *2IR  	INTEGER*4 IARGPTR( *2E32  	INTEGER*4 LEN1,LEN2,STATUS,LOG_TRANS,SYS$SETDDIR  =0  	STATUS = LOG_TRANS('SYS$DISK',LEN1,DIR_STRING)0  	  IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  R1  	STATUS = SYS$SETDDIR(,LEN2,DIR_STRING(LEN1+1:))T0  	  IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  u  	LEN1 = LEN1 + LEN2   8  	IF (LEN1.LT.LEN(DIR_STRING)) DIR_STRING(LEN1+1:) = ' '  e *2Dt!  	IF (ARG_EXIST(2)) LENGTH = LEN1V *2E" *2Ia1  	IF (ARG_EXIST(%VAL(IARGPTR()),2)) LENGTH = LEN1* *2EA    *2Dr  	END									f *2Ea *2I   	END									   *2E ,  	INTEGER FUNCTION LOG_TRANS(NAME,LEN,VALUE)     **	3  *	INTEGER FUNCTION LOG_TRANS( name , len , value )   *  *E  *	Attempts to translate logical name NAME.   If it fails, it returns2E  *	a .FALSE. function result.   If it succeeds,  it returns  a .TRUE.	E  *	result and puts the translation into string VALUE and sets integerO(  *	LEN to the length of the translation.  *  *	.INDEX ENVIRONMENT>>E  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55+  *	30 Nov 1990	   Dahlgren, Virginia  22448E  *  0  	IMPLICIT NONE,  t  	CHARACTER*(*) NAME,VALUE  	INTEGER*4 LENT  M  	INCLUDE '($LNMDEF)'D  E   	INTEGER*4 ITMLST(4),SYS$TRNLNM  D.  	CALL ITEM_LIST(ITMLST,LNM$_STRING,VALUE,LEN)  T
  	LOG_TRANS =(<  	1	SYS$TRNLNM(LNM$M_CASE_BLIND,'LNM$FILE_DEV',NAME,,ITMLST)  A *2D)  	END									  *2E  *2IE  	END									   *2E,#  	INTEGER FUNCTION FPRINT_2(STRING)E  N  **H'  *	INTEGER FUNCTION FPRINT_2 ( string )O  *  *E  *	This routine is not normally called by the user.   It is called byRE  *	routine  FPRINT  to print a line  after the line has been built by   *	the $FAO system service.L  *E  *	You can  provide your own FPRINT_2 routine to replace this one, if ;  *	necessary; see the notes for routine FPRINT for details.f  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	10 Aug 1984	   Dahlgren, Virginia  22448   *     	IMPLICIT INTEGER (A-Z)  a  	CHARACTER*(*) STRING  K  	PRINT 1000,STRING   l  	FPRINT_2 = 1  4  1000	FORMAT (A)  T  	END *  	LOGICAL FUNCTION LOGICAL_NAME(NAME,EXEC)  G  ** 2  *	LOGICAL FUNCTION LOGICAL_NAME( name [ ,exec ] )  *  *E  *	Returns a result of .TRUE. if and only if the logical name  in the*E  *	character string NAME exists.  The translation of the name is  NOT   *	returned.  *E  *	If the optional second argument EXEC is supplied,  then the result E  *	will be .TRUE. if and only if the logical name exists as an Execu-O  *	tive Mode logical name.  *  *	.INDEX LOGICAL NAMES>>l  *?  *	26 Jun 85	Added capability to test for Executive Mode names.u  *  *2  *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53+  *	14 Nov 1983	   Dahlgren, Virginia  22448l  *  *  h  	IMPLICIT INTEGER (A-Z)  c-  	PARAMETER ( LNM$_CASE_BLIND = '02000000'X ) -  	PARAMETER ( LNM$_ACMODE     = '6'X        ) -  	PARAMETER ( PSL$C_EXEC      = '1'X        )   A  	CHARACTER*(*) NAME  u  	INTEGER ITMLST(4)   	 *2Io  	INTEGER*4 IARGPTR0 *2Ea  	LOGICAL ARG_EXIST4     	EXTERNAL SS$_NOLOGNAMU  O+  	CALL ITEM_LIST(ITMLST,LNM$_ACMODE,ACMODE)O  S>  	STATUS = SYS$TRNLNM(LNM$_CASE_BLIND,'LNM$DCL_LOGICAL',NAME,,  	1							 ITMLST)    	LOGICAL_NAME = STATUSE  P  	IF (.NOT.STATUS) THENB  TB  	   IF (STATUS.NE.%LOC(SS$_NOLOGNAM)) CALL LIB$STOP(%VAL(STATUS))  s *2Di  	ELSE IF (ARG_EXIST(2)) THEN_ *2Ee *2I -  	ELSE IF (ARG_EXIST(%VAL(IARGPTR()),2)) THENm *2E   i*  	   LOGICAL_NAME = ACMODE .EQ. PSL$C_EXEC  l  	ENDIFL  m  	END*