/*
 * gv.h -- Main include file for GhostView-VMS. 
 * Copyright (C) 1995  Johannes Plass
 *
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes Gutenberg University, Mainz, Germany
 *
 * Internet: plass@dipmza.physik.uni-mainz.de
 *
*/

/*
   This code is derived from:
*/

/*
 * gv.h -- Main include file for ghostview.
 * Copyright (C) 1992  Timothy O. Theisen
 *
 *   Author: Tim Theisen           Systems Programmer
 * Internet: tim@cs.wisc.edu       Department of Computer Sciences
 *     UUCP: uwvax!tim             University of Wisconsin-Madison
 *    Phone: (608)262-0438         1210 West Dayton Street
 *      FAX: (608)262-9777         Madison, WI   53706
 *
*/

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/

#include <stdio.h>

#ifdef VMS
#   include <X11_DIRECTORY/Xos.h>
#   include <X11_DIRECTORY/Intrinsic.h>
#   include <stat.h>
#else
#   include <X11/Xos.h>
#   include <X11/Intrinsic.h>
#   include <sys/stat.h>
#endif

#include "Ghostview.h"
#include "callbacks.h"
#include "actions.h"
#include "misc.h"


#define REQUEST_TOGGLE_RESIZE		-9
#define REQUEST_REDISPLAY		-8
#define REQUEST_SETUP			-7
#define REQUEST_NEW_MAGSTEP		-6
#define REQUEST_NEW_PAGEMEDIA		-5
#define REQUEST_NEW_ORIENTATION		-4
#define REQUEST_REOPEN			-3
#define REQUEST_NEW_FILE		-2
#define NO_CURRENT_PAGE			-1 /* NO_CURRENT_PAGE must be -1 */

#define SPM_ALL                         (1<<0)
#define SPM_EVEN                        (1<<1)
#define SPM_ODD                         (1<<2)
#define SPM_SELECTION			(1<<3)
#define SPM_CURRENT			(1<<4)
#define SPM_TOGGLE			(1<<5)
#define SPM_MARK			(1<<6)
#define SPM_UNMARK			(1<<7)

#define PAGE_MODE_INVALID		0
#define PAGE_MODE_ALL			(1<<0)
#define PAGE_MODE_MARKED		(1<<1)
#define PAGE_MODE_CURRENT		(1<<2)

#define CHECK_FILE_DATE			(1<<0)
#define CHECK_FILE_VERSION		(1<<1)
			
#define XtSetFloatArg(arg, n, d)		\
    if (sizeof(float) > sizeof(XtArgVal)) {	\
	XtSetArg(arg, n, &(d));			\
    } else {					\
	XtArgVal *ld = (XtArgVal *)&(d);	\
	XtSetArg(arg, n, *ld);			\
    }

/* Application resources */

typedef struct _AppResources {
    Boolean auto_center;	/* whether to automatically center the page */
    int minimum_magstep;	/* smallest magstep allowed */
    int maximum_magstep;	/* largest magstep allowed */
    int magstep;		/* default magstep */
    XtPageOrientation orientation; /* default orientation */
    String page;		/* first page to show */
    String pagemedia;		/* default page media */
    Boolean force_orientation;	/* use default to override document comments */
    Boolean force_pagemedia;	/* use default to override document comments */
#   ifdef USE_SWAP_LANDSCAPE
       Boolean swap_landscape;	/* Landscape comment maps to Seascape */
#   endif
    String print_command;	/* command used to print doc, usually "lpr" */
#   ifndef VMS
       String printer_variable;	/* env variable to use, usually "PRINTER" */
       String default_printer;	/* printer to use if no PRINTER is set*/
#   endif
    String scratch_dir;         /* temporary directory */
    String default_save_dir;    /* default directory for saving */
    Boolean confirm_print;	/* popup dialog on print attempt */
    String version;		/* ghostview version identifier*/
    String maximum_width;	/* maximum width of the application*/
    String maximum_height;	/* maximum height of the application*/
    Boolean auto_resize;        /* should we try to fit the window size to the page size */
    Pixmap document_bitmap;
    Pixmap selected_bitmap;
    Pixmap forced_bitmap;
    String locator_format;
} AppResources;

extern Bool			show_date;
extern Bool			show_locator;
extern Bool			show_title;
extern Bool			show_date;
extern Bool			show_locator;
extern Bool			show_title;
extern Bool			show_toggleCurrentPage;
extern Bool			show_toggleAllPages;
extern Bool			show_toggleEvenPages;
extern Bool			show_toggleOddPages;
extern Bool			show_unmarkAllPages;
extern Bool			show_saveMarkedPages;
extern Bool			show_saveAllPages;
extern Bool			show_printMarkedPages;
extern Bool			show_printAllPages;
extern Bool			show_openFile;
extern Bool			show_autoResize;
extern Bool			show_showThisPage;
extern Bool			show_updateFile;
extern Bool			show_checkFile;
extern Bool			show_panner;

extern float			default_xdpi;
extern float			default_ydpi;
extern int			num_ghosts;
extern FILE			*psfile;
extern String			filename;
extern String			oldfilename;
extern int			current_page;
extern int			current_magstep;
extern XtPageOrientation	current_orientation;
extern int			current_pagemedia;
extern int			current_llx;
extern int			current_lly;
extern int			current_urx;
extern int			current_ury;
extern int			base_papersize;
extern String			toc_text;
extern int			toc_length;
extern int			toc_entry_length;
extern time_t			mtime;
extern struct document 		*doc;
extern struct document 		*olddoc;
extern Atom			wm_delete_window;
extern XErrorHandler		old_Xerror;
extern Boolean			dying;
extern XErrorEvent		bomb;

extern int			gv_force;
extern int			gv_pagemedia;
extern int			gv_forced_pagemedia;
extern int			gv_default_pagemedia;
extern XtPageOrientation	gv_orientation;
extern XtPageOrientation	gv_forced_orientation;
extern XtPageOrientation	gv_default_orientation;

extern String			gv_class;
extern String			gv_name;
extern String			gv_application_name;
extern String			gv_user_defaults_file;
extern int			gv_print_mode;
extern int			gv_save_mode;

extern int			gv_pending_page_request;

extern XtAppContext 		app_con;
extern AppResources 		app_res;

/* Widgets */
extern Widget   toplevel;
extern Widget      control;
extern Widget         titlebutton;
extern Widget            titlemenu;
extern Widget         datebutton;
extern Widget            datemenu;
extern Widget         locator;
extern Widget         fileButton;
extern Widget            fileMenu;
extern Widget               openEntry;
extern Widget               reopenEntry;
extern Widget               printAllEntry;
extern Widget               printMarkedEntry;
extern Widget               saveAllEntry;
extern Widget               saveMarkedEntry;
extern Widget               optionEntry;
extern Widget               copyrightEntry;
extern Widget               quitEntry;
extern Widget         pageButton;
extern Widget            pageMenu;
extern Widget               nextEntry;
extern Widget               showEntry;
extern Widget               prevEntry;
extern Widget               centerEntry;
extern Widget         magstepButton;
extern Widget            magstepMenu;
extern Widget               *magstepEntry;
extern Widget         orientationButton;
extern Widget            orientationMenu;
extern Widget               portraitEntry;
extern Widget               landscapeEntry;
extern Widget               upsidedownEntry;
extern Widget               seascapeEntry;
#ifdef USE_SWAP_LANDSCAPE
extern Widget               swapEntry;
#endif
extern Widget         pagemediaButton;
extern Widget		 pagemediaMenu;
extern Widget		    *pagemediaEntry;
extern Widget         toc3d;
extern Widget            toc;
extern Widget         w_toggleCurrentPage;
extern Widget         w_toggleAllPages;
extern Widget         w_toggleEvenPages;
extern Widget         w_toggleOddPages;
extern Widget         w_unmarkAllPages;
extern Widget         w_saveMarkedPages;
extern Widget         w_saveAllPages;
extern Widget         w_printMarkedPages;
extern Widget         w_printAllPages;
extern Widget         w_openFile;
extern Widget         w_autoResize;
extern Widget         w_showThisPage;
extern Widget         w_checkFile;
extern Widget         w_updateFile;

extern Widget         panner3d;
extern Widget            panner;

extern Widget         pageview;
extern Widget            page;

/* Popup widgets */
extern Widget	infopopup;
extern Widget	optionpopup;
extern Widget	dialogpopup;
extern Widget	notepopup;
extern Widget	versionpopup;

extern Widget	FileSel_popup;
extern Widget		FileSel;

