!### makefile for XFIG  

TARGET = XFIG, FIG2DEV
TARGET_TYPE = executables
TARGET1 = XFIG
TARGET2 = FIG2DEV

CC_DEFINES = target specific 

.ifdef __DECC__
CC_QUALIFIER = /NODEB/STAND=VAXC/EXT=COMM
.endif

.ifdef __VAXC__
CC_QUALIFIER = /NODEB/OPT=(D,I)
.endif

.include X11_ROOT:[COMMAND]X11_RULES.MMS

!### OpenVMS AXP ###############################################################

.ifdef __alpha__
OBJ_FIG2DEV_DEV_EXT = OBJ_FIG2DEV_DEV_Alpha 
OBJ_FIG2DEV_EXT = OBJ_FIG2DEV_Alpha 
.endif

!### OpenVMS VAX ###############################################################

.ifdef __vax__
OBJ_FIG2DEV_DEV_EXT = OBJ_FIG2DEV_DEV 
OBJ_FIG2DEV_EXT = OBJ_FIG2DEV 
.endif

!### First/Last Action #########################################################

.FIRST
   @		write_ sys$output "  defining logical X11R4"
   @ define_/nolog/proc X11R4  X11R4_VMS_DIRECTORY
   @		write_ sys$output "  defining logical X11Xmu"
   @ define_/nolog/proc X11Xmu XMU_DIRECTORY
   @		write_ sys$output "  defining logical X11Xaw"
   @ define_/nolog/proc X11Xaw XAW_DIRECTORY
   @		write_ sys$output "  defining logical X11Inc"
   @ define_/nolog/proc X11inc X11_DIRECTORY
   @		write_ sys$output "  defining logical DPS"
   @ define_/nolog/proc DPS    XDPS$INCLUDE
   @		write_ sys$output "  defining logical SYS"
   @ define_/nolog/proc SYS    SYS$LIBRARY

!### Last Action ###############################################################

.LAST
   @		write_ sys$output "  deassigning logical X11R4"
   @ deassign_  X11R4
   @		write_ sys$output "  deassigning logical X11Xmu"
   @ deassign_  X11Xmu
   @		write_ sys$output "  deassigning logical X11Xaw"
   @ deassign_  X11Xaw
   @		write_ sys$output "  deassigning logical X11Inc"
   @ deassign_  X11inc
   @		write_ sys$output "  deassigning logical DPS"
   @ deassign_  DPS
   @		write_ sys$output "  deassigning logical SYS"
   @ deassign_  SYS

!### Compiler Instructions #####################################################

.SUFFIXES :
.SUFFIXES : .$(EXE_EXT) .$(obj_fig2dev_dev_ext) .$(obj_fig2dev_ext) .$(obj_ext) .c  

.ifdef __MMK__
RULE_1 = {[.XFIG]}.C{[.XFIG]}.$(OBJ_EXT)
RULE_2 = {[.transfig.fig2dev.dev]}.C{[.transfig.fig2dev.dev]}.$(OBJ_FIG2DEV_DEV_EXT)
RULE_3 = {[.transfig.fig2dev]}.C{[.transfig.fig2dev]}.$(OBJ_FIG2DEV_EXT)
.else
RULE_1 = .C.$(OBJ_EXT)
RULE_2 = .C.$(OBJ_FIG2DEV_DEV_EXT)
RULE_3 = .C.$(OBJ_FIG2DEV_EXT)
.endif

$(RULE_1)
 @ write_ sys$output "  compiling: $(MMS$SOURCE)	-> $(MMS$TARGET)"
 @ $(CC_COMMAND)$(CC_QUALIFIER) -
      /INC=(X11Inc,X11R4,DPS,[.XFIG])-
      /DEF=(DPS,VMS)-
      /OBJ=$(MMS$TARGET) $(MMS$SOURCE)

$(RULE_2)
 @ write_ sys$output "  compiling: $(MMS$SOURCE)	-> $(MMS$TARGET)"
 @ $(CC_COMMAND)$(CC_QUALIFIER) -
      /INC=([.TRANSFIG.FIG2DEV],X11Inc,X11R4)-
      /DEF=(DVIPS,A4,VMS)-
      /OBJ=$(MMS$TARGET) $(MMS$SOURCE)

$(RULE_3)
 @ write_ sys$output "  compiling: $(MMS$SOURCE)	-> $(MMS$TARGET)"
 @ $(CC_COMMAND)$(CC_QUALIFIER) -
      /INC=([.TRANSFIG],X11Inc,X11R4)-
      /DEF=(EPIC,IBMGL,LATEX,PIC,PICTEX,PS,PSTEX,TEXTYL,TPIC,VMS)-
      /OBJ=$(MMS$TARGET) $(MMS$SOURCE)

!### Objects ###################################################################

OBJS1=\
[.xfig]d_arc.$(OBJ_EXT),\
[.xfig]d_arcbox.$(OBJ_EXT),\
[.xfig]d_box.$(OBJ_EXT),\
[.xfig]d_ellipse.$(OBJ_EXT),\
[.xfig]d_epsobj.$(OBJ_EXT),\
[.xfig]d_intspline.$(OBJ_EXT),\
[.xfig]d_line.$(OBJ_EXT)
OBJS2=\ 
[.xfig]d_regpoly.$(OBJ_EXT),\
[.xfig]d_spline.$(OBJ_EXT),\
[.xfig]d_text.$(OBJ_EXT),\
[.xfig]e_addpt.$(OBJ_EXT),\
[.xfig]e_align.$(OBJ_EXT),\
[.xfig]e_arrow.$(OBJ_EXT),\
[.xfig]e_break.$(OBJ_EXT)
OBJS3=\ 
[.xfig]e_convert.$(OBJ_EXT),\
[.xfig]e_copy.$(OBJ_EXT),\
[.xfig]e_delete.$(OBJ_EXT),\
[.xfig]e_deletept.$(OBJ_EXT),\
[.xfig]e_edit.$(OBJ_EXT),\
[.xfig]e_flip.$(OBJ_EXT),\
[.xfig]e_glue.$(OBJ_EXT)
OBJS4=\
[.xfig]e_move.$(OBJ_EXT),\
[.xfig]e_movept.$(OBJ_EXT),\
[.xfig]e_rotate.$(OBJ_EXT),\
[.xfig]e_scale.$(OBJ_EXT),\
[.xfig]e_update.$(OBJ_EXT),\
[.xfig]f_load.$(OBJ_EXT),\
[.xfig]f_read.$(OBJ_EXT)
OBJS5=\
[.xfig]f_epsobj.$(OBJ_EXT),\
[.xfig]f_readold.$(OBJ_EXT),\
[.xfig]f_save.$(OBJ_EXT),\
[.xfig]f_util.$(OBJ_EXT),\
[.xfig]f_xbitmap.$(OBJ_EXT),\
[.xfig]main.$(OBJ_EXT),\
[.xfig]mode.$(OBJ_EXT)
OBJS6=\ 
[.xfig]object.$(OBJ_EXT),\
[.xfig]resources.$(OBJ_EXT),\
[.xfig]u_bound.$(OBJ_EXT),\
[.xfig]u_create.$(OBJ_EXT),\
[.xfig]u_drag.$(OBJ_EXT),\
[.xfig]u_draw.$(OBJ_EXT),\
[.xfig]u_elastic.$(OBJ_EXT)
OBJS7=\
[.xfig]u_error.$(OBJ_EXT),\
[.xfig]u_fonts.$(OBJ_EXT),\
[.xfig]u_free.$(OBJ_EXT),\
[.xfig]u_geom.$(OBJ_EXT),\
[.xfig]u_list.$(OBJ_EXT),\
[.xfig]u_markers.$(OBJ_EXT),\
[.xfig]u_pan.$(OBJ_EXT)
OBJS8=\
[.xfig]u_print.$(OBJ_EXT),\
[.xfig]u_redraw.$(OBJ_EXT),\
[.xfig]u_search.$(OBJ_EXT),\
[.xfig]u_translate.$(OBJ_EXT),\
[.xfig]u_undo.$(OBJ_EXT),\
[.xfig]w_canvas.$(OBJ_EXT),\
[.xfig]w_cmdpanel.$(OBJ_EXT)
OBJS9=\
[.xfig]w_cursor.$(OBJ_EXT),\
[.xfig]w_dir.$(OBJ_EXT),\
[.xfig]w_drawprim.$(OBJ_EXT),\
[.xfig]w_export.$(OBJ_EXT),\
[.xfig]w_file.$(OBJ_EXT),\
[.xfig]w_fontbits.$(OBJ_EXT),\
[.xfig]w_fontpanel.$(OBJ_EXT)
OBJS10=\
[.xfig]w_grid.$(OBJ_EXT),\
[.xfig]w_icons.$(OBJ_EXT),\
[.xfig]w_indpanel.$(OBJ_EXT),\
[.xfig]w_modepanel.$(OBJ_EXT),\
[.xfig]w_mousefun.$(OBJ_EXT),\
[.xfig]w_msgpanel.$(OBJ_EXT),\
[.xfig]w_print.$(OBJ_EXT)
OBJS11=\
[.xfig]w_rulers.$(OBJ_EXT),\
[.xfig]w_setup.$(OBJ_EXT),\
[.xfig]w_util.$(OBJ_EXT),\
[.xfig]w_zoom.$(OBJ_EXT)

FIG2DEV_DEV_OBJS1=\
[.transfig.fig2dev.dev]genbox.$(OBJ_FIG2DEV_DEV_EXT),\
[.transfig.fig2dev.dev]genepic.$(OBJ_FIG2DEV_DEV_EXT),\
[.transfig.fig2dev.dev]genibmgl.$(OBJ_FIG2DEV_DEV_EXT)
FIG2DEV_DEV_OBJS2=\
[.transfig.fig2dev.dev]genlatex.$(OBJ_FIG2DEV_DEV_EXT),\
[.transfig.fig2dev.dev]genpic.$(OBJ_FIG2DEV_DEV_EXT),\
[.transfig.fig2dev.dev]genpictex.$(OBJ_FIG2DEV_DEV_EXT)
FIG2DEV_DEV_OBJS3=\
[.transfig.fig2dev.dev]genps.$(OBJ_FIG2DEV_DEV_EXT),\
[.transfig.fig2dev.dev]genpstex.$(OBJ_FIG2DEV_DEV_EXT),\
[.transfig.fig2dev.dev]gentextyl.$(OBJ_FIG2DEV_DEV_EXT)
FIG2DEV_DEV_OBJS4=\
[.transfig.fig2dev.dev]gentpic.$(OBJ_FIG2DEV_DEV_EXT)

FIG2DEV_OBJS1=\
[.transfig.fig2dev]ARROW.$(OBJ_FIG2DEV_EXT),\
[.transfig.fig2dev]BOUND.$(OBJ_FIG2DEV_EXT),\
[.transfig.fig2dev]FIG2DEV.$(OBJ_FIG2DEV_EXT)
FIG2DEV_OBJS2=\
[.transfig.fig2dev]FREE.$(OBJ_FIG2DEV_EXT),\
[.transfig.fig2dev]GETOPT.$(OBJ_FIG2DEV_EXT),\
[.transfig.fig2dev]ISO2TEX.$(OBJ_FIG2DEV_EXT)
FIG2DEV_OBJS3=\
[.transfig.fig2dev]LATEX_LINE.$(OBJ_FIG2DEV_EXT),\
[.transfig.fig2dev]PSFONTS.$(OBJ_FIG2DEV_EXT),\
[.transfig.fig2dev]READ.$(OBJ_FIG2DEV_EXT)
FIG2DEV_OBJS4=\
[.transfig.fig2dev]READ1_3.$(OBJ_FIG2DEV_EXT)


!### Targets ###################################################################

DEFAULT   : $(TARGET1).$(EXE_EXT), $(TARGET2).$(EXE_EXT)
   @  write_ sys$output ""
   @  write_ sys$output "  $(TARGET1).$(EXE_EXT), $(TARGET2).$(EXE_EXT) available"
   @  write_ sys$output ""

$(TARGET1).$(EXE_EXT) : $(OBJS1), $(OBJS2), $(OBJS3), $(OBJS4), $(OBJS5),-
                        $(OBJS6), $(OBJS7), $(OBJS8), $(OBJS9), $(OBJS10),-
                        $(OBJS11),-
                        XMULIBSHR, XAW3DLIBSHR, X11_LIBRARY:XVMSUTILS.OLB 
   @ WRITE_ SYS$OUTPUT "  generating $(TARGET1).$(OPT_EXT)"
   @ OPEN_/WRITE FILE []$(TARGET1).$(OPT_EXT)
   @ WRITE_ FILE "$(OBJS1)"
   @ WRITE_ FILE "$(OBJS2)"
   @ WRITE_ FILE "$(OBJS3)"
   @ WRITE_ FILE "$(OBJS4)"
   @ WRITE_ FILE "$(OBJS5)"
   @ WRITE_ FILE "$(OBJS6)"
   @ WRITE_ FILE "$(OBJS7)"
   @ WRITE_ FILE "$(OBJS8)"
   @ WRITE_ FILE "$(OBJS9)"
   @ WRITE_ FILE "$(OBJS10)"
   @ WRITE_ FILE "$(OBJS11)"
   @ WRITE_ FILE "SYS$SHARE:XDPS$DPSCLIENTSHR/SHARE"
   @ WRITE_ FILE "X11_LIBRARY:XVMSUTILS.OLB/LIBRARY"
   @ CLOSE_ FILE
   @ WRITE_ SYS$OUTPUT "  linking $(TARGET1).$(EXE_EXT) ..."
   @ LINK_/NODEB/NOTRACE/EXE=$(TARGET1).$(EXE_EXT) -
     []$(TARGET1).$(OPT_EXT)/OPT,-
     X11_LIBRARY:XAW3D_Client.OPT/OPT

$(TARGET2).$(EXE_EXT)  : $(FIG2DEV_DEV_OBJS1), $(FIG2DEV_DEV_OBJS2), -
                         $(FIG2DEV_DEV_OBJS3), $(FIG2DEV_DEV_OBJS4), -
                         $(FIG2DEV_OBJS1), $(FIG2DEV_OBJS2), -
                         $(FIG2DEV_OBJS3), $(FIG2DEV_OBJS4), -
                         X11_LIBRARY:XVMSUTILS.OLB
  @ WRITE_ SYS$OUTPUT "  generating $(TARGET2).$(OPT_EXT)"
  @ OPEN_/WRITE FILE []$(TARGET2).$(OPT_EXT)
  @ WRITE_ FILE "$(FIG2DEV_DEV_OBJS1)"
  @ WRITE_ FILE "$(FIG2DEV_DEV_OBJS2)"
  @ WRITE_ FILE "$(FIG2DEV_DEV_OBJS3)"
  @ WRITE_ FILE "$(FIG2DEV_DEV_OBJS4)"
  @ WRITE_ FILE "$(FIG2DEV_OBJS1)"
  @ WRITE_ FILE "$(FIG2DEV_OBJS2)"
  @ WRITE_ FILE "$(FIG2DEV_OBJS3)"
  @ WRITE_ FILE "$(FIG2DEV_OBJS4)"
  @ WRITE_ FILE "$(RTL_LIBRARY)"
  @ WRITE_ FILE "X11_LIBRARY:XVMSUTILS.OLB/LIBRARY"
  @ CLOSE_ FILE
  @ WRITE_ SYS$OUTPUT "  linking $(TARGET2).$(EXE_EXT) ..."
  @ LINK_/NODEB/NOTRACE/EXE=$(TARGET2).$(EXE_EXT) -
    []$(TARGET2).$(OPT_EXT)/OPT

