 #module turbo "1"    /*D  *	Optimize VMS V4.n and V5.n image activations by preactivating andH  *	locking the pages of the chosen images into memory.  Courtesy of Pete1  *	Kaiser, 10:24 pm Monday, May 23rd, 1988 /144/.   *  *	How to use:  *I  *	1. Use INSTALL to install relevant images SHARE'd and HEADER_RESIDENT.   *	2. Submit a batch job:   *,  *         $ set process /name=turbo        ,  *         $ set process /privilege=PSWAPM  ,  *         $ set process /noswap            K  *         $ set working /noadjust /extent=99999 /limit=99999 /quota=99999  ,  *         $ run turbo                      ,  *         sys$system:dcl                   ,  *         sys$system:loginout              ,  *         sys$share:dcltables              ,  *         $ exit                             */    #include <stddef.h>  #include <stdio.h>   #include <descrip.h> #include <ssdef.h> #include <stsdef.h>    #include <iacdef.h>    /*!  *    typedef's and globalvalue's   */   2 typedef struct ADR { char *low; char *high; } ADR;   globalvalue TURBO_ACTERR;  globalvalue TURBO_LOCKERR; globalvalue TURBO_ACTIVATED; globalvalue TURBO_LOCKED;  globalvalue TURBO_PARTLOCKED;  globalvalue TURBO_RESTLOCKED;  globalvalue TURBO_COUNT; globalvalue TURBO_TOTAL; globalvalue TURBO_HIBER;   /*  *    own data ...  */   1 static const char def_spec[] = "SYS$SYSTEM:.EXE";   1 static const struct dsc$descriptor default_spec = E     { sizeof def_spec - 1, DSC$K_DTYPE_T, DSC$K_CLASS_S, &def_spec };    /*  *    routines ...  */    main(int argc, char *argv[]) /*2  *    Get images to be turbo'ed from sys$input ...  */  {      char image_buffer[80];A     int lock_count, lock_total, image_count, image_total, status;        lock_total  = 0;     image_total = 0;  (     while (gets(image_buffer) != NULL) { 	struct dsc$descriptor image =I 	  { strlen(image_buffer), DSC$K_DTYPE_T, DSC$K_CLASS_S, &image_buffer };  	ADR imgadr, lckadr, lrange;  7 	str$upcase(&image, &image);	/* canonical input		    */    	/* @ 	 *    Activate the image into our address space.  If this fails# 	 *    go to process the next file.  	 */1 	status = sys$imgact(&image, &default_spec, NULL, ( 			    IAC$M_MERGE | IAC$M_EXPREG, NULL, 			    &imgadr, NULL, 0);   # 	if ($VMS_STATUS_SUCCESS(status)) { E 	    lib$signal(TURBO_ACTIVATED, 3, &image, imgadr.low, imgadr.high);  	} 	else { 1 	    lib$signal(TURBO_ACTERR, 1, &image, status);  	    continue; 	}   	/* < 	 *    Lock down the pages of the image.  Some pages may not= 	 *    lock, keep trying skipping over unlockable pages until  	 *    we reach the end. 	 */ 	lrange     = imgadr;  	lock_count = 0;# 	while (lrange.low < lrange.high) { % 	    lckadr.low = lckadr.high = NULL; . 	    status = sys$lckpag(&lrange, &lckadr, 0);D 	    if (lckadr.low != lckadr.high) {	/* any pages locked at all? */- 		lock_count += lckadr.high - lckadr.low + 1;   
 		lib$signal( @ 		    (lckadr.low == imgadr.low && lckadr.high == imgadr.high) ? 			   TURBO_LOCKED :$ 		    (lckadr.high == imgadr.high) ? 			   TURBO_RESTLOCKED : 			   TURBO_PARTLOCKED, ! 			   2, lckadr.low, lckadr.high,  			   status);  @ 		lrange.low = lckadr.high + 1 + 512; /* skip unlockable page */ 	    } 	    else {  		if (status == SS$_NOPRIV> 		||  (SS$_NOPRIVSTRT >= status && status >= SS$_NOPRIVEND)) { 		/*= 		 *    We can't lock pages if we get these errors, just give & 		 *    up and go on to the next file. 		 */ + 		    lib$signal(TURBO_LOCKERR, 0, status); > 		    lrange.low = lrange.high;	/* force end of while ()    */ 		    continue;  		}   / 		lrange.low += 512;	/* skip unlockable page */  	    } 	}  0 	image_count = (imgadr.high - imgadr.low) / 512;  	lock_count  = lock_count / 512;   	image_total += image_count; 	lock_total  += lock_count;   5 	lib$signal(TURBO_COUNT, 2, lock_count, image_count);      }   8     lib$signal(TURBO_TOTAL, 2, lock_total, image_total);       if (lock_total > 0) {  	lib$signal(TURBO_HIBER, 1, 0); 
 	sys$hiber();      }  }   