srcroot = appl_srcroot:
cmsflags = /nohist
cmscomment = "TSCON exporting"
vmsshare = $(srcroot)[system.vms_share]
mftu = mcr cam:mftu 
zip = mcr cam:zip

.zip.mftu
        $(mftu) encode $(mms$source)/delerr/out=$(mms$target)

package_source		:	fetch,doc
        if f$search("*.obj") .nes. "" then delete *.obj;*
        if f$search("*.exe") .nes. "" then delete *.exe;*
        if f$search("*.%lb") .nes. "" then delete *.%lb;*
	$(zip) [-]tscon.zip *.*
	rename [-]tscon.zip []
        $(mftu) encode tscon.zip/delerr/out=tscon_zip.mftu
	@$(vmsshare)vms_share tscon_zip.mftu tscon

package_all		:	build,doc
        if f$search("*.obj") .nes. "" then delete *.obj;*
	libr/compress maclib.mlb
	libr/compress ether.mlb
	libr/compress tslib.olb
	$(zip) [-]tscon.zip *.*
	rename [-]tscon.zip []
        $(mftu) encode tscon.zip/delerr/out=tscon_zip.mftu
	@$(vmsshare)vms_share tscon.mftu tscon

package_exe		:	build,doc
        if f$search("*.obj") .nes. "" then delete *.obj;*
        if f$search("*.%lb") .nes. "" then delete *.%lb;*
        if f$search("*.pas") .nes. "" then delete *.pas;*
        if f$search("*.mar") .nes. "" then delete *.mar;*
        if f$search("*.msg") .nes. "" then delete *.msg;*
        if f$search("*.cld") .nes. "" then delete *.cld;*
	$(zip) [-]tscon.zip *.*
	rename [-]tscon.zip []
        $(mftu) encode tscon.zip/delerr/out=tscon_zip.mftu
	@$(vmsshare)vms_share tscon.mftu tscon

doc		:	tscon.hlp,-
			aaareadme.txt
	@- write sys$output "TSCON docs fetched"

build		:	tscon.exe
	@- write sys$output "TSCON executable built"

tscon.exe	:	fetch
	@tsbuild

fetch		:	main,aux,-
			tsbuild.com
	@- write sys$output "All TSCON sources fetched"

! Fetch TSCON main sources
main		:	etherdef.mar,-
			mopdef.mar,-
			set_text.mar,-
			tscon.pas,-
			tsctrl.mar,-
			tsdb.mar,-
			tsdbdef.mar,-
			tsdisp.pas,-
			tsmop.mar,-
			tsmsgdef.msg,-
			tstables.cld,-
			address_psect.mar,-
			code_psect.mar,-
			constants_psect.mar,-
			data_psect.mar
	@- write sys$output "Main TSCON sources fetched"

aaareadme.txt	:	tscon_readme.txt~
	$(cms) fetch $(mms$cms_element) /out=$(mms$target_name).txt $(cmsflags) $(cmscomment)

etherdef.mar	:	etherdef.mar~

mopdef.mar	:	mopdef.mar~

set_text.mar	:	set_text.mar~

tsbuild.com	:	tsbuild.com~

tscon.hlp	:	tscon.hlp~

tscon.pas	:	tscon.pas~

tsctrl.mar	:	tsctrl.mar~

tsdb.mar	:	tsdb.mar~

tsdbdef.mar	:	tsdbdef.mar~

tsdisp.pas	:	tsdisp.pas~

tsmop.mar	:	tsmop.mar~

tsmsgdef.msg	:	tsmsgdef.msg~

tstables.cld	:	tstables.cld~

address_psect.mar :	address_psect.mar~

code_psect.mar :	code_psect.mar~

constants_psect.mar :	constants_psect.mar~

data_psect.mar :	data_psect.mar~


! Fetch TSCON aux. sources
aux		:	maclib.mlb,-
			callimg.mar,-
			err.mar,-
			getdvi.mar,-
			interface.mar,-
			miscs.mar,-
			str.mar	,-
			term.mar,-
			net_info.mar,-
			clidef.pas,-
			datatypes.pas,-
			itmlst.pas,-
			rtldef.pas,-
			smgsizes.pas,-
			smgrtndef.pas,-
			messages.msg
	@- write sys$output "Auxiliary sources fetched"


maclib.mlb	:	appl_maclib:maclib.mlb
	copy $(mms$source) $(mms$target)

callimg.mar	:	$(srcroot)[lib.misc.sources]callimg.mar~

err.mar		:	$(srcroot)[lib.misc.sources]err.mar~

getdvi.mar	:	$(srcroot)[lib.misc.sources]getdvi.mar~

interface.mar	:	$(srcroot)[lib.spec.sources]interface.mar~

miscs.mar	:	$(srcroot)[lib.misc.sources]miscs.mar~

str.mar		:	$(srcroot)[lib.misc.sources]str.mar~

term.mar	:	$(srcroot)[lib.misc.sources]term.mar~

net_info.mar	:	$(srcroot)[lib.util.sources]net_info.mar~

clidef.pas	:	appl_vmsdef:clidef.pas
	copy $(mms$source) $(mms$target)

datatypes.pas	:	appl_vmsdef:datatypes.pas
	copy $(mms$source) $(mms$target)

itmlst.pas	:	appl_vmsdef:itmlst.pas
	copy $(mms$source) $(mms$target)

rtldef.pas	:	appl_vmsdef:rtldef.pas
	copy $(mms$source) $(mms$target)

smgsizes.pas	:	appl_vmsdef:smgsizes.pas
	copy $(mms$source) $(mms$target)

smgrtndef.pas	:	appl_vmsdef:smgrtndef.pas
	copy $(mms$source) $(mms$target)

messages.msg	:	$(srcroot)[lib]messages.msg
	copy $(mms$source) $(mms$target)

! DEC/CMS REPLACEMENT HISTORY, Element TSEXPORT.MMS
! *4     2-MAY-1993 11:23:52 SYSTIMK "Added ZIP"
! *3    30-APR-1993 15:51:01 SYSTIMK "Added packaging"
! *2    30-APR-1993 14:32:47 SYSTIMK "Fixed fetching"
! *1    30-APR-1993 14:26:40 SYSTIMK "Build TSCON for export"
! DEC/CMS REPLACEMENT HISTORY, Element TSEXPORT.MMS
