 /*	socket_netlib.c							*/ " /*	V1.5			20-Jan-1995	IfN/Mey			*/ /*+ %  * SOCKETSHR interface for NETLIB V1.   *D  *	Copyright (c) 1994, 1995 by Eckart Meyer <meyer@ifn.ing.tu-bs.de>  *D  * This module provides a socket interface to NETLIB. SOCKETSHR is a/  * shared image providing the socket interface.   *G  * This is the NETLIB implementation of SOCKETSHR (there are others for N  * native UCX, for Mike O'Malley's LIBCMU and the UNIXSHR library for CMU/IP).  *J  * Note: Most of the code here is stolen from Mike O'Malley's LIBCMU. I'veH  *       made the changes to use NETLIB instead of CMU/IP. Some routines&  *	 have been changed, some are added.'  * 	 Mike's copyright is included here:   */     P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++3  * LIBCMU, Copyright (C) 1993,1994 by Mike O'Malley   *@  * This library is free software; you can redistribute it and/or>  * modify it under the terms of the GNU Library General Public?  * License as published by the Free Software Foundation; either C  * version 2 of the License, or (at your option) any later version.   *  B  * This library is distributed in the hope that it will be useful,A  * but WITHOUT ANY WARRANTY; without even the implied warranty of D  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU3  * Library General Public License for more details.   *  D  * You should have received a copy of the GNU Library General Public=  * License along with this library; if not, write to the Free E  * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   *  */    /*  * Facility:	SOCKETSHR_NETLIB   *2  * Abstract:	Socket interface routines for NETLIB.  *  * Module Description:D  *	This collection of routines provides the standard `C' programming9  *	interface for Matt Madison's NETLIB network transport.   *  * Routine provided:1  *	int socket(int domain, int type, int protocol) 6  *	int bind(int s, struct sockaddr *name, int namelen)9  *	int connect(int s, struct sockaddr *name, int namelen) "  *	int listen (int s, int backlog)9  *	int accept(int s, struct sockaddr *addr, int *addrlen) 1  *	int recv(int s, char *buf, int len, int flags) 5  *	int recvfrom(int s, char *buf, int len, int flags, )  *			struct sockaddr *from, int *fromlen) 1  *	int send(int s, char *msg, int len, int flags) 4  *	int sendto(int s, char *msg, int len, int flags, $  *			struct sockaddr *to, int tolen)  *	int shutdown(int s, int how)   *D  *	int select(int nfds, int *readfds, int *writefds, int *execptfds,  *			struct timeval *timeout)   *>  *	int getsockname(int s, struct sockaddr *name, int *namelen)>  *	int getpeername(int s, struct sockaddr *name, int *namelen)0  *	int getsockopt(int s, int level, int optname,  *			char *optval, int *optlen) 0  *	int setsockopt(int s, int level, int optname,  *			char *optval, int *optlen) +  *	int gethostname(char *name, int namelen) ,  *	struct hostent *gethostbyname(char *name)?  *	struct hostent *gethostbyaddr(char *addr, int len, int type)   *,  *	int ioctl(int s, int request, void *argp))  *	int fcntl(int s, int request, int arg) 3  *	int writev(int s, struct iovec *iov, int iovcnt)   *6  * The following routines also present in the VAXCRTL:  *&  *	int read(int s, char *buf, int len)2  *	int write(int s, char *msg, int len, int flags)  *	int close(int s)   *	FILE *netlib1_fdopen(int s)  *B  * The following routines may be called from outside this library:#  *	short int netlib1_get_sdc(int s) &  *	int *netlib1_stdin_open(char *name)4  *	int netlib1_stdin_read(flags,buf,len,prompt,mask)%  *	int netlib1_get_errno(long status)   *	int isNetlibSocket(int s)!  *	int netlib1_get_fd(FILE *fptr)   *F  * The following routines should not be accessed outside this library:#  *	int netlib1_listen_accept(int s) "  *	int netlib1_queue_listen(int s)  *	void netlib1_read_ast(int s)    *	void netlib1_write_ast(int s)$  *	int netlib1_queue_net_read(int s)?  *	int netlib1_alloc_socket(int domain, int type, int protocol)   * 	int netlib1_assign(int s)  #ifdef UDP_POLL 1  *	int netlib1_check_udp_receive(int s, int flag)  #endif  *  * Acknowledgements::  *	Guidence, concepts, examples derived from the works of:  *		UNIXSHR		- unknown  *		NETLIB		- Matt Madison, RPI   *		LIBCMU		- Mike O'Malley   *  * SOCKETSHR Author:  *	Eckart Meyer "  *	Institute for Telecommunication'  *	Technical University of Braunschweig   *	Schleinitzstr. 23  *	D-38092 Braunschweig 
  *	Germany  *	<meyer@ifn.ing.tu-bs.de>   *  *  * LIBCMU Author: (LIBCMU V1.2) .  *	Mike O'Malley (mlo)				      September 19939  *	Digital Equipment Corp.			Sandia National Laboratories B  *	Digital Consulting	   Scientific Computing Center, User Support  *	Albuquerque, NM;  *      Mike.OMalley@aqo.mts.dec.com			  mlomall@sandia.GOV   *  *      With modifications by:(  *	 Chen He (che) (617)566-0001 Ext.2919  *	 IDX Systems Corp.   *	 he@chen.idx.com   *  */  #ifdef VAXC  #module SOCKETSHR_NETLIB "V1.0"  #endif   /*  * Include files  */    /*K  * If not defined types.h will define it for us.  Don't want to handle more )  * than 32 file descriptors at this time.   */  #define FD_SETSIZE 32    #include <stdio.h> #include <errno.h> #include <string.h>    #include <netdb.h>   #include <types.h> #include <ctype.h> #include <time.h>  #include <file.h>  #include <ioctl.h> #include <socket.h>    /* #include <if.h> /**/  #include <in.h>    #include <ssdef.h> #include <descrip.h> #include <lnmdef.h>  #include <msgdef.h>  #include <iodef.h> #include <ttdef.h> #include <tt2def.h>  #include <syidef.h>    /*  * NETLIB specific definitions  */  #define	NET_K_TCP	1  #define	NET_K_UDP	2  #define NET_M_PUSH	1 #define	NET_M_NOTRM	2    /*  * Common include   */  #include "[-]si_socket.h"    /*  * TRACE  */  /* #undef TRACE /**/  /* #define FTRACE__  stdout /**/ #include "[-]si_trace.h"   /*  * And a NETLIB specific header   */  #include "socket_netlib.h"   /*  * forward declarations   */ # int netlib1_get_errno(long status); G int __trnlnm(char *table, char *name, char *mode, char *buff, int len); ! int netlib1_listen_accept(int s);   int netlib1_queue_listen(int s); void netlib1_read_ast(int s);  void netlib1_write_ast(int s);" int netlib1_queue_net_read(int s);= int netlib1_alloc_socket(int domain, int type, int protocol);  int netlib1_assign(int s); #ifdef UDP_POLL / int netlib1_check_udp_receive(int s, int flag);  #endif! short int netlib1_get_sdc(int s);  int isNetlibSocket(int s); int netlib1_get_fd(FILE *fptr);    FILE *netlib1_fdopen(int s);   #define isSocket isNetlibSocket  #define get_fd netlib1_get_fd    /*  * Global static variables  */    /*$  * Our private file descriptor table  */ ' static struct FD_ENTRY *sd[FD_SETSIZE];    /*2  * for system information call to get MAXBUF size.  */  static int MAXBUF;% static struct ITEM_LIST syinfo[2] = {  	4, SYI$_MAXBUF, &MAXBUF, 0, 	0,           0,       0, 0  };    /*4  * File descriptor mask to keep track of i/o events.  */ . static fd_set sys_validfds;	/* is sd valid		*/4 static fd_set sys_readfds;	/* is sd ready to read	*/6 static fd_set sys_writefds;	/* is sd ready to write */7 static fd_set sys_exceptfds;	/* does sd have an error*/  #ifdef UDP_POLL / static fd_set sys_udpfds;	/* is sd an UDP sd	*/  #endif   #define MAX_INADDR 20     static	struct hostent inet_host;, static	struct in_addr inet_list[MAX_INADDR];, static	struct in_addr *addrlist[MAX_INADDR];B static	char inet_name[128];	/* storage for official name string */ static	char *null_ptr = NULL;    /*7  * Accept event flag so we know when a request comes in   */ " /* static int accept_net_event; */   /*4  * 'NETLIB loaded' flag for the channel number hack.  */ 
 #define CMU 2  static int netlib_loaded = 0;    /*G  * for feof() and ferror() to work we have to set the appropriate flags H  * in the FILE structure. Note these macros depend on the implementationB  * of the structure. However, it seems the _flag item has not beenJ  * modified since ever in VAXC and is still used in the same way in DEC C.  */ N #define SET_FPTR(flg) if (sd[s]->fptr != NULL) (*sd[s]->fptr)->_flag |= (flg);O #define CLR_FPTR(flg) if (sd[s]->fptr != NULL) (*sd[s]->fptr)->_flag &= ~(flg);   P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *?  * int netlib1_alloc_socket(int domain, int type, int protocol)   *  * Description: *  *	Internal routine. Allocates the socket.  *  * Returns: N  *  If successful a socket number is returned, otherwise, a -1 is returned and  *  errno is set.   */ . int netlib1_alloc_socket(domain,type,protocol) int domain,type,protocol;  {    int	s;       /*)      * Verify the address family (domain)       */      if ( domain != AF_INET ) { 	/* . 	 * we don't handle any other address formats. 	 */ 	errno = EAFNOSUPPORT; 	return(-1);     }	       /*;      * Use the dup() routine to aquire a unique discriptor. #      * Make sure it's in our range.       */      s = dup(0);      if (s<0) 	return(-1);+     else if ((s < 0) || (s > FD_SETSIZE)) {  	errno = ENFILE;
 	return (-1);      }      FD_SET(s,&sys_validfds);       /*C      * Allocate a file descriptor data structure and initialize it.       */ 0     sd[s] = calloc( 1, sizeof(struct FD_ENTRY));     sd[s]->domain	= domain;      sd[s]->type		= type;       /*1      * If not specified select a default protocol       */ !     if (protocol == IPPROTO_IP) {  	switch(type) {  	    case SOCK_STREAM :   		sd[s]->protocol	= IPPROTO_TCP; 		break; 	    case SOCK_DGRAM :
 	    default:   		sd[s]->protocol	= IPPROTO_UDP; 	}     }      else 	switch(protocol) {  	    case IPPROTO_TCP: 	    case IPPROTO_UDP: 		sd[s]->protocol = protocol;  		break;
 	    default:  		netlib1_close(s);  		errno = EPROTONOSUPPORT;
 		return(-1);  	}  0     sd[s]->read_dsc.dsc$b_dtype = DSC$K_DTYPE_T;0     sd[s]->read_dsc.dsc$b_class = DSC$K_CLASS_D;%     sd[s]->read_dsc.dsc$w_length = 0; .     sd[s]->read_dsc.dsc$a_pointer = (char *)0;1     sd[s]->write_dsc.dsc$b_dtype = DSC$K_DTYPE_T; 1     sd[s]->write_dsc.dsc$b_class = DSC$K_CLASS_S;        /*O      * grab the OpenVMS SYSGEN parameter MAXBUF and set the default buffer size 2      * to the minimum of *_SO_RCVBUF_DEF or MAXBUF      *      */      if (MAXBUF == 0) {5 	vaxc$errno = sys$getsyi( 0, 0, 0, &syinfo, 0, 0, 0);   	if (vaxc$errno != SS$_NORMAL) { 		netlib1_close(s);  		errno = EVMSERR;
 		return(-1);  	} 	MAXBUF -= 128;      }   '     if (sd[s]->protocol == IPPROTO_TCP)  	sd[s]->rcvbufsize =  ; 			MAXBUF < TCP_SO_RCVBUF_DEF ? MAXBUF : TCP_SO_RCVBUF_DEF;      else 	sd[s]->rcvbufsize =; 			MAXBUF < UDP_SO_RCVBUF_DEF ? MAXBUF : UDP_SO_RCVBUF_DEF;        /*7      * get and clear an event flag and file descriptor.       */      if (sd[s]->ef == 0)  	lib$get_ef(&sd[s]->ef);     sys$clref(sd[s]->ef);      FD_CLR(s, &sys_readfds);       /*,      * get file pointer for stream routines.      */       sd[s]->fptr = fdopen(s,"r");H     (*sd[s]->fptr)->_file = s;	/* backlink, enables standard fileno() */       return(s); }   P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *  * int netlib1_assign(int s)  *  * Description: 6  *	Internal routine. Assigns a channel to the network.  *  * Returns: P  *  If successful the socket number is returned, otherwise, a -1 is returned and  *  errno is set.   */  int netlib1_assign(s)  int s; {  $DESCRIPTOR(dev,"NLA0:");  char name[128];      /*I      * What comes here is really a hack: since NETLIB doesn't give us the E      * VMS channel number, only a NETLIB internal context pointer, we E      * allocate a VMS channel, store it away and release the channel. :      * We then *hope* NETLIB will grab the same channel...I      * If this is the first call to NETLIB, one channel is used to access L      * the NETLIB shared image. In this case we call net_assign/net_deassignF      * only to bring in the image. I've heard there is an undocumentedF      * system service to load a sharable image, but this works too and      * is only called once.       *      */      if (!netlib_loaded) {  	netlib_loaded = 1;  	net_assign(&sd[s]->ctx); = 	__trnlnm( "LNM$FILE_DEV", "NETLIB_SHR", "USER", &name, 128); 6 	if (strstr(name, "CMU") != NULL) netlib_loaded = CMU;/ 	DTRACE("  --",0,"NETLIB: %d",netlib_loaded,0);  	net_deassign(&sd[s]->ctx);      }   (     sys$assign(&dev,&sd[s]->chan,0,0,0);     sys$dassgn(sd[s]->chan);  )     vaxc$errno = net_assign(&sd[s]->ctx); #     if (vaxc$errno != SS$_NORMAL) {  	netlib1_close(s); 	errno = EVMSERR;  	return(-1);     }      return(s); }   P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *1  * int socket(int domain, int type, int protocol)   *  * Description: '  *	Creates an endpoint of a connection.   *H  * domain   - AF_INET is the only address domain supported at this time.'  * type     - SOCK_STREAM or SOCK_DGRAM M  * protocol - IPPROTO_TCP, IPPROTO_UDP.  If IPPROTO_IP (default) is specified 5  *	      protocol will be chosen that matches `type'.   *  * Returns: N  *  If successful a socket number is returned, otherwise, a -1 is returned and  *  errno is set.   */ ( int netlib1_socket(domain,type,protocol) int domain,type,protocol;  {  int	s;       /*      * allocate a socket      */ 4      s = netlib1_alloc_socket(domain,type,protocol);       /*-      * assign a channel to the network device       */       s = netlib1_assign(s); G      STRACE("netlib1_socket",0,s,"returned, chan: %04X",sd[s]->chan,0);       return(s);  }   P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *6  * int bind(int s, struct sockaddr *name, int namelen)  *  * Description: F  *	binds a name (address/port) to a socket.  Socket (s) must have been  * created with call to socket.   *$  * s       - valid socket descriptorJ  * name	   - address of sockaddr structure for local host port information2  * namelen - length of the name structure in bytes  *  * Returns: I  *	0 on success, -1 on error.  Addition error information is specified in   * the global variable errno.   */   int netlib1_bind(s,name,namelen)  int			s;	/* socket to bind to	*/) struct sockaddr		*name;	/* name stuff		*/ ( int			namelen;/* length of name stuff	*/ {  int	status; 
 int	protocol;  struct	sockaddr_in *my = name; struct	sockaddr_in tmp;   5     STRACE("netlib1_bind",0,s,"addr: %08X, port: %d", 1 	ntohl(my->sin_addr.s_addr),ntohs(my->sin_port));      /*)      * Verify the address family (domain)       */ '     if ( name->sa_family != AF_INET ) {  	/* . 	 * we don't handle any other address formats. 	 */ 	errno = EAFNOSUPPORT; 	return(-1);     }	       /*      * check for valid socket.      */      if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }        /*       * see if it's already named      */ !     if (sd[s]->flags & SD_BIND) {  	errno = EINVAL; 	return(-1);     }        /*      * copy/save sockaddr info.       */      sd[s]->mylen = namelen; &     memcpy(&sd[s]->my, name, namelen);     my = &sd[s]->my;       /*H      * If the bind is to a connectionless mode socket (IPPROTO_UDP) then      * OPEN the channel.      */ )     if (sd[s]->protocol == IPPROTO_UDP) {  	/* " 	 * Open the communication channel 	 */H 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_UDP, ntohs(my->sin_port),1,1);  	if (vaxc$errno != SS$_NORMAL) {+ 	    errno = netlib1_get_errno(vaxc$errno);  		/* How to Abort ? */F 	    DTRACE("  --",0,"ERROR status:%08X, errno: %d",vaxc$errno,errno); 	    FD_SET(s,&sys_exceptfds); 	    sys$setef(sd[s]->ef); 	    return(-1); 	}  3 	netlib1_getsockname(s, &sd[s]->my, &sd[s]->mylen); : 	DTRACE("  --",0,"actual port: %d",ntohs(my->sin_port),0);   	FD_SET(s,&sys_writefds);  	FD_CLR(s,&sys_exceptfds);   	sd[s]->flags |= SD_CONNECTED;   	/*  	 * queue a read to the socket 	 */$ 	status = netlib1_queue_net_read(s); 	if (status != 0)  	    return(-1);     } 
     else {7 	if (my->sin_port == 0) my->sin_port = htons(1050 + s);      }      sd[s]->flags |= SD_BIND;     return(0); }c 	P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>t  * #include <socket.h>  *9  * int connect(int s, struct sockaddr *name, int namelen)   *  * Description:E&  *	initiates a connection on a socket.  *$  * s       - valid socket descriptor@  * name	   - pointer to an address structure for the remote port2  * namelen - length of the name structure in bytes  *  * Returns:oI  *	0 on success, -1 on error.  Addition error information is specified in'  * the global variable errno.h  */n# int netlib1_connect(s,name,namelen)S int s; struct sockaddr *name; int namelen; {e int	status;' int	to_addr, to_port, my_port; struct	sockaddr_in *p;         /*?      * Verify the address family (domain) we are to connect to.,      */t'     if ( name->sa_family != AF_INET ) {T 	/*i. 	 * we don't handle any other address formats. 	 */ 	errno = EAFNOSUPPORT; 	return(-1);     }	       /*      * check for valid sockete      */F     if (sd[s] == NULL) { 	errno = EBADF;n 	return(-1);     }        /*$      * see if it's already connected      */r-     if ((sd[s]->flags & SD_CONNECTED) != 0) {e 	errno = EISCONN;T 	return(-1);     }t       /*&      * copy/save remote sockaddr info.      */S     sd[s]->tolen = namelen;S&     memcpy(&sd[s]->to, name, namelen);       p = &sd[s]->to; !     to_addr = p->sin_addr.s_addr; !     to_port = ntohs(p->sin_port);u     p = &sd[s]->my;g!     my_port = ntohs(p->sin_port);o=     STRACE("netlib1_connect",0,s,"local port: %d",my_port,0);gS     STRACE("netlib1_connect",0,s,"-- addr: %08X, port: %d",ntohl(to_addr),to_port);S     /*,      * Open and connect to the remote system      */:)     if (sd[s]->protocol == IPPROTO_TCP) {h< 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_TCP, my_port,1,1); 	if (vaxc$errno == SS$_NORMAL)C 	    vaxc$errno = tcp_connect_addr(&sd[s]->ctx, &to_addr, to_port);      }t
     else {< 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_UDP, my_port,0,1);     }c#     if (vaxc$errno != SS$_NORMAL) {s' 	errno = netlib1_get_errno(vaxc$errno);n 	return(-1);     }*       /*'      *  Get the real local port number.       */i      if (my_port == 0) {( 	sd[s]->mylen = sizeof(struct sockaddr);1 	netlib1_getsockname(s,&sd[s]->my,&sd[s]->mylen);s      }       /*K      * Now queue a read on the socket.  If the connect failed then the read !      * will also fail right away.e      */t!     if (vaxc$errno == SS$_NORMAL)i' 	if ((netlib1_queue_net_read(s)) == -1)i 	    return(-1);       /*L      * could there be a timing problem here?  Will the read AST complete (onN      * error) before the next statement?  Lets wait a sec anyway just in case.      */g /*    sleep(1); /**/  .     vaxc$errno = sd[s]->read_iosb.iosb_status;       /*<      * 0 = read in progress, 1 = read complete data waiting.      */l1     if ((vaxc$errno != 0) && (vaxc$errno != 1)) { 9 	errno = netlib1_get_errno(sd[s]->read_iosb.iosb_status);t 	FD_SET(s,&sys_exceptfds); 	sys$setef(sd[s]->ef); 	return(-1);     }s       FD_SET(s,&sys_writefds);     FD_CLR(s,&sys_exceptfds);t  !     sd[s]->flags |= SD_CONNECTED;o     return(0); }t  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *  "  * int listen (int s, int backlog)  *  * Description:nI  *	Sets the maximum limit of outstanding connection requests for a socketf  * that is connection-oriented.r  *7  * s	   - a valid socket descriptor of type SOCK_STREAM E  * backlog - maximum number of pending connections that may be queuedg  *  * Returns:mI  *	0 on success, -1 on error.  Addition error information is specified in   * the global variable errno.r  */* int netlib1_listen(s,backlog)u int s; int backlog; {e struct sockaddr_in *my;t:      STRACE("netlib1_listen",0,s,"backlog: %d",backlog,0);     /*      * check for valid socket*      */l     if (sd[s] == NULL) { 	errno = EBADF;n 	return(-1);     }t  K     if ((sd[s]->protocol != IPPROTO_TCP) || (sd[s]->type != SOCK_STREAM)) {i 	errno = EOPNOTSUPP; 	return(-1);     }1       sd[s]->backlog = backlog;gD     sd[s]->sock_opts |= SO_ACCEPTCONN;	/* socket has had listen() */       /*B      * Allocate an event flag used to signal a blocked accept call      */*' /*    lib$get_ef(&accept_net_event); */S% /*    sys$clref(accept_net_event); */u     sys$clref(sd[s]->ef);*       /*(      * Clear the listen file descriptor       */      FD_CLR(s,&sys_readfds);G       /*9      * Set socket to passive TCP on specified bound port.M      */      my = &sd[s]->my;K     vaxc$errno = net_bind(&sd[s]->ctx, NET_K_TCP, ntohs(my->sin_port),1,0);t#     if (vaxc$errno != SS$_NORMAL) {n' 	errno = netlib1_get_errno(vaxc$errno);A 	return(-1);     }      /*      * Queue the socket listen      */.%     if (netlib1_queue_listen(s) == 0): 	return(0);      else 	return(-1); }9    P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>f  * #include <socket.h>  *9  * int accept(int s, struct sockaddr *addr, int *addrlen)   *  * Description:m$  *	Accepts a connection on a socket.  *(  * s	   - valid socket that is listeningQ  * addr	   - sockaddr address structure filled with information from the accepted   *           connectionu1  * addrlen - length of returned address structure   *  * Returns:.H  *	Nonnegative integer that is the descriptor for the accepted socket orF  * -1 on error.  Addition error information is specified in the global  * variable errno.  */o% int netlib1_accept( s, addr, addrlen)t int	s; struct	sockaddr *addr;
 int	*addrlen;  {c int	ns, status;  struct	backlogEntry *entry;d  H     STRACE("netlib1_accept",0,s,"backlogSize: %d",sd[s]->backlogSize,0);     /*      * check for valid socketo      */      if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }s       /*!      * see if socket is listening*      */T2     if ((sd[s]->sock_opts & SO_ACCEPTCONN) == 0) { 	errno = EBADF;a 	return(-1);     }        /*      * see if anything is there       */c CHECK_QUEUE:     /*2      * check the socket for incomming connections.      */p+     if (!(FD_ISSET(s,&sys_readfds))) { /**/ + /*      if (sd[s]->backlogSize == 0) { /**/w 	/*a 	 * block if necessary 	 */ e+ 	if ((sd[s]->ioctl_opts & O_NDELAY) == 0) {d' /*	    sys$waitfr(accept_net_event); */l 	    sys$waitfr(sd[s]->ef);P 	    /*n& 	     * see if the socket was shutdown 	     */, 	    if ((sd[s]->ioctl_opts & FREAD) != 0) { 		return(0); 	    } 	} 	else {_ 	    errno = EWOULDBLOCK;E 	    return(-1); 	}     }d       /*      * Clear the event flag       */t' /*    sys$clref(accept_net_event); /**/a     sys$clref(sd[s]->ef);i     FD_CLR(s,&sys_readfds);*       /*4      * remove the first entry from the backlog queue      */t      entry = sd[s]->backlogQueue;'     sd[s]->backlogQueue = entry->flink;L       /*7      * save the socket number and free the backlogEntry       */      ns = entry->sock;c     cfree(entry);        /*6      * queue the first read to the accepted connection      */ (     status = netlib1_queue_net_read(ns);     if (status != 0) 	return(-1);       /*:      * fill in addr with the connecting entity information      */      if (addr != NULL)LD     	memcpy (addr,&(sd[ns]->to), (*addrlen < sizeof(struct sockaddr). 				   ? *addrlen : sizeof(struct sockaddr)));       /*,      * give the user a new socket descriptor      */      return(ns);[ }_ DP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *1  * int recv(int s, char *buf, int len, int flags)   *  * Description: )  *	Receive bytes from a connected socket.h  *  !  * s	 - a valid socket descriptor 9  * buf	 - address of buffer to where input data is placedr  * len	 - max size of buf *  * flags - 0 or MSG_PEEK may be specified.  *  * Returns:mE  *	Number of bytes read from the socket, -1 on error.  Addition errore9  * information is specified in the global variable errno.A  */d! int netlib1_recv(s,buf,len,flags)E int	s;
 char	*buf; int	len, flags;( {s@     STRACE("netlib1_recv",0,s,"len: %d, flags: %08X",len,flags);     /*      * check for valid socket>      */l     if (sd[s] == NULL) { 	errno = EBADF;+ 	return(-1);     }+       /*      * Must be connected      */d+     if ((sd[s]->flags & SD_CONNECTED) != 0)i/ 	return(netlib1_recvfrom(s,buf,len,flags,0,0)); 
     else { 	errno = EBADF;n 	return(-1);     }n }A cP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>u  * #include <socket.h>  *5  * int recvfrom(int s, char *buf, int len, int flags, )  *			struct sockaddr *from, int *fromlen)   *  * Description: 0  *	receives bytes from a socket from any source.  *!  * s	 - a valid socket descriptort9  * buf	 - address of buffer to where input data is placedP  * len	 - max size of buf *  * flags - 0 or MSG_PEEK may be specified.M  * from	 - address of sockaddr structure address of the socket which the data K  *         is received from.  May be specified as 0; no information will beS  *         returned./  * fromlen - length of from structure returned.a  *  * Returns:*E  *	Number of bytes read from the socket, -1 on error.  Addition error 9  * information is specified in the global variable errno.   */d2 int netlib1_recvfrom(s,buf,len,flags,from,fromlen) int	s;
 char	*buf; int	len, flags;t struct	sockaddr *from;
 int	*fromlen;( {t int	size, offset;  struct	sockaddr_in *frm; struct	sockaddr_in *rcv;  D     STRACE("netlib1_recvfrom",0,s,"len: %d, flags: %08X",len,flags);     /*      * check for valid socket;      */      if (sd[s] == NULL) { 	errno = EBADF;s 	return(-1);     }c     CLR_FPTR(_IOERR | _IOEOF);       /*+      * make sure the socket is not shutdownl      */ +     if ((sd[s]->ioctl_opts & FREAD) != 0) {} 	errno = EPIPE;a 	goto recvfrom_ioerr;$     }_       /*5      * if the user want's nothing, return immediatelyr      */s     if (len == 0) return(0);   #ifdef UPD_POLLe     /*      * NETLIB prior to V1.7:E      * Since NETLIB's udp_receive does not support AST's, we must tryCG      * to read here with immediate return if nothing has been received.e      */a)     if (sd[s]->protocol == IPPROTO_UDP) {*H 	netlib1_check_udp_receive(s,0);	/* No AST's with UDP, check manually */     }  #endif  
 CHECKforDATA:n     /*C      * check for a socket error (if the socket read has completed!)n      */R( /*    if (FD_ISSET(s,&sys_readfds)) /**/,     if (sd[s]->read_iosb.iosb_status != 0) {2 	if (sd[s]->read_iosb.iosb_status != SS$_NORMAL) {= 	    errno = netlib1_get_errno(sd[s]->read_iosb.iosb_status);fD 	    STRACE("netlib1_recvfrom",0,s,"ERROR, status: %08X, errno: %d",& 		sd[s]->read_iosb.iosb_status,errno);) /* sd[s]->read_iosb.iosb_status = 0; /**/f: 	    if (sd[s]->read_iosb.iosb_status == SS$_LINKDISCON) { 		SET_FPTR(_IOEOF);C 		return(0); 	    } 	    if (errno == ECONNRESET) {  		SET_FPTR(_IOEOF); 
 		return(-1);d 	    } 	    goto recvfrom_ioerr;d 	}     }>       /*N      * Check the file descriptor for data ready on the socket. Block or return"      * based on data availability.      */+&     if (!(FD_ISSET(s,&sys_readfds))) {$ 	if (sd[s]->ioctl_opts & O_NDELAY) { 	    errno = EWOULDBLOCK;s 	    goto recvfrom_ioerr;r 	} 	else {t #ifdef UDP_POLLc* 	    if (sd[s]->protocol == IPPROTO_UDP) {? 		netlib1_check_udp_receive(s,1);	/* No AST's with UDP, wait */_ 	    } #endif 	    sys$waitfr(sd[s]->ef);: 	    goto CHECKforDATA;  	}     }*       /*3      * move the from data if the user asked for it.       */      if (from != NULL) {l 	rcv = &sd[s]->rcvfrom;x, 	size = (sizeof(struct sockaddr) < *fromlen)) 				? sizeof(struct sockaddr) : *fromlen;  	memcpy(from, rcv, size);w 	*fromlen = size;h     }.       /*A      * data is ready on the socket.  copy it to the users buffer. J      * there could be data remaining in the receive buffer from a previousO      * read or more data in the receive buffer than what would fit in the userss      * buffer.      */h8     STRACE("netlib1_recvfrom",0,s,"available: %d bytes",) 					sd[s]->read_iosb.iosb_byte_count,0);_4     size = len < sd[s]->read_iosb.iosb_byte_count ? , 					len : sd[s]->read_iosb.iosb_byte_count;!     offset = sd[s]->rcvbufoffset;t  .     memcpy(buf, &sd[s]->rcvbuf[offset], size);       /*N      * if this is just a peek then return without fixing up the byte count and      * offset things.>      */0      if ((flags & MSG_PEEK) != 0) 	return (size);=       /*M      * now fix up the byte count in the iosb.  If there is and data left thenr      * set the offset.      */ -     sd[s]->read_iosb.iosb_byte_count -= size;+0     if (sd[s]->read_iosb.iosb_byte_count == 0) { 	/*+= 	 * The receive buffer has been drained; reset the offset andt 	 * queue another read.y 	 */ 	sd[s]->rcvbufoffset = 0;p 	netlib1_queue_net_read(s);t     }o     else 	sd[s]->rcvbufoffset += size;t       /*G      * return the number of bytes that were copied to the users buffer.G      */p>     STRACE("netlib1_recvfrom",0,s,"returned %d bytes",size,0);     return (size);   recvfrom_ioerr:h     SET_FPTR(_IOERR);'     return(-1);s }   P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *1  * int send(int s, char *msg, int len, int flags)   *  * Description:t5  *	Send bytes through a socket to its connected peer.a  *!  * s	 - a valid socket descriptors.  * buf	 - address of buffer of data to be sent  * len	 - size of buf(*  * flags - 0 or MSG_PEEK may be specified.  *  * Returns:,F  *	Number of bytes written to the socket, -1 on error.  Addition error9  * information is specified in the global variable errno.n  */ ! int netlib1_send(s,msg,len,flags)  int	s;
 char	*msg; int	len, flags;r {a@     STRACE("netlib1_send",0,s,"len: %d, flags: %08X",len,flags);     /*      * check for valid socket       */c     if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }i       /*      * Must be connected      */u+     if ((sd[s]->flags & SD_CONNECTED) != 0)n- 	return(netlib1_sendto(s,msg,len,flags,0,0));*
     else { 	errno = EBADF;- 	return(-1);     }  }o nP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>	  * #include <socket.h>  *4  * int sendto(int s, char *msg, int len, int flags, $  *			struct sockaddr *to, int tolen)  *  * Description:c3  *	Send bytes through a socket to any other socket._  *!  * s	 - a valid socket descriptor,.  * buf	 - address of buffer of data to be sent  * len	 - size of bufo  * flags - none supported.H  * to	 - address of sockaddr structure which contains the address of the+ 	   socket which the data is to be written. -  * tolen - length of from structure returned.   *  * Returns: F  *	Number of bytes written to the socket, -1 on error.  Addition error9  * information is specified in the global variable errno.   */*, int netlib1_sendto(s,msg,len,flags,to,tolen) int	s;
 char	*msg; int	len, flags;E struct	sockaddr *to;
 int	tolen; {* struct	sockaddr_in *too; static int write_ef = 0;  B     STRACE("netlib1_sendto",0,s,"len: %d, flags: %08X",len,flags);     /*      * check for valid socket       */o     if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }      CLR_FPTR(_IOERR | _IOEOF);       /*+      * make sure the socket is not shutdownu      */c,     if ((sd[s]->ioctl_opts & FWRITE) != 0) { 	errno = EPIPE;o 	goto sendto_ioerr;;     }v       /*O      * in a UDP environment we could get to this point without actually opening K      * the communication channel via bind.  It might be cause the user only !      * wants a send only channel.       */f-     if ((sd[s]->flags & SD_CONNECTED) == 0) {g7 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_UDP, 0, 0,1);"  	if (vaxc$errno != SS$_NORMAL) {+ 	    errno = netlib1_get_errno(vaxc$errno);_ 	    goto sendto_ioerr;  	}     /*'      *  Get the real local port number.e      */ /         sd[s]->mylen = sizeof(struct sockaddr);;8         netlib1_getsockname(s,&sd[s]->my,&sd[s]->mylen);   	sd[s]->flags |= SD_CONNECTED;   	FD_SET(s,&sys_writefds);  	FD_CLR(s,&sys_exceptfds);     }"       /*/      * check the target domain (address family)*      */c     if (to != NULL)>  	if (to->sa_family != AF_INET) { 	    errno = EAFNOSUPPORT; 	    goto sendto_ioerr;  	}       /*"      * record who we sent it to...      */      if (to != NULL) {r 	sd[s]->tolen = tolen; 	memcpy(&sd[s]->to, to, tolen);{     }o       too = &sd[s]->to;   9 /* My CMUIP doesn't like zero length writes... IfN/Mey */+     if (len == 0) return(0);       /*-      * get an event flag specific for writing       */c     if (write_ef == 0) 	lib$get_ef(&write_ef);	       /*<      * Clear the system write ready fds and queue the write.C      * For UDP, NETLIB does not support AST's, so we simply wait...s      */      FD_CLR(s,&sys_writefds);)     if (sd[s]->protocol == IPPROTO_UDP) { # 	vaxc$errno = udp_send(&sd[s]->ctx,K0 		too->sin_addr.s_addr,	/* address to send to */* 		ntohs(too->sin_port),	/* foreign port */% 		msg,			/* message buffer address */  		len);			/* message length */, 	sd[s]->write_iosb.iosb_status = vaxc$errno;     } 
     else {& 	sd[s]->write_dsc.dsc$a_pointer = msg;% 	sd[s]->write_dsc.dsc$w_length = len; # 	vaxc$errno = tcp_send(&sd[s]->ctx,a- 		&sd[s]->write_dsc,	/* message descriptor */ / 		NET_M_NOTRM,		/* flags: don't append CR/LF */,, 		&sd[s]->write_iosb,	/* I/O status block */ 		netlib1_write_ast, s);     }o!     if (vaxc$errno == SS$_NORMAL)u 	return (len);
     else {: 	errno = netlib1_get_errno(sd[s]->write_iosb.iosb_status);I         DTRACE("  --",0,"ERROR status:%08X, errno: %d",vaxc$errno,errno);      } 
 sendto_ioerr:N     SET_FPTR(_IOERR);s     return(-1);  }c  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <socket.h>  *  * int shutdown(int s, int how)e  *  * Description: 6  *	Shuts down all or part of a connection on a socket.  *  * s - a valid socketi  * how - one of:  *	0 - no more receives0  *	1 - no more sends   *	2 - no more receives or sends  *  * Returns:eI  *	0 on success, -1 on error.  Addition error information is specified inh  * the global variable errno.t  */h int netlib1_shutdown(s,how)  int s, how;- {o  3     STRACE("netlib1_shutdown",0,s,"how: %d",how,0);0     if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }C       /*/      * if not connected the no need to shutdown       */a-     if ((sd[s]->flags & SD_CONNECTED) == 0) {T 	errno = ENOTCONN; 	return(-1);     }a       switch (how) {	 	case 2 :s	 	case 1 :i 		sd[s]->ioctl_opts |= FWRITE; 		if (how != 2) break;	 	case 0 :[ 		sd[s]->ioctl_opts |= FREAD; . 		if ((sd[s]->sock_opts & SO_ACCEPTCONN) != 0)) /*		    sys$setef(accept_net_event); /**/_ 		    sys$setef(sd[s]->ef);d, /*		sys$cancel(sd[s]->chan); 	can't do ?? */ 		break;
 	default : 	    errno = EINVAL; 	    return(-1);     }e     return(0); }  iP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *D  * int select(int nfds, int *readfds, int *writefds, int *execptfds,  *		struct timeval *timeout)  *  * Description:fH  *	Allows the user to poll or check a group of sockets for I/O activity.M  * It can check what sockets are ready to be read or written, or what socketsP  * have a pending exception.  *	  * Notes:)J  *	This routine (and library) only handles 32 file descriptors max (0-31).M  * The `fd_set' type is long int.  To select on file descriptor 0 (stdin) the M  * routine netlib1_stdin_open must be used to setup the file descriptor.  See(N  * routines netlib1_stdin_open and netlib1_stdin_read for further information.  *-  * nfds		- maximum file descriptor +1 to scan C  * readfds	- address of descriptor bit mask to scan for read events E  * writefds	- address of descriptor bit mask to scan for write events*J  * exceptfds	- address of descriptor bit mask to scan for exception eventsG  * timeout	- specifies how long to wait for a read, write, or exceptionsA  *		  event.  If timeout argument is NULL select will block untill0  *		  one of the specified descriptors is ready.  * ,  * Returns:eG  *	Number of socket descriptors ready for I/O or that have exceptions, .L  * 0 if the operation timed out, -1 on error.  Addition error information is*  * specified in the global variable errno.  */s; int netlib1_select(nfds,readfds,writefds,exceptfds,timeout)a	 int	nfds;o$ int	*readfds, *writefds, *exceptfds; struct	timeval *timeout; {  int	i;, int	maxfds, maxfds_mask, ready_fds, all_fds;
 int	readyfds;    int	block, timer_ef, t[2]; #ifdef UDP_POLLf" int	udp_tick_ef, udp_tick_time[2]; #endif char	at[20]; char	*p; struct	tm *lt;# struct dsc$descriptor ascii_time =  ) 	{20, DSC$K_DTYPE_T, DSC$K_CLASS_S, at };t   int	ef_mask; #define EF_BASE 32  1     DTRACE("netlib1_select",0,"nfds: %d",nfds,0);e     readyfds = 0;      FD_ZERO(&ready_fds);     FD_ZERO(&all_fds);     FD_ZERO(&ef_mask);       block = timer_ef = 0;o  5     maxfds = nfds < FD_SETSIZE ? nfds+1 : FD_SETSIZE;_       /*0      * Don't allow more than 32 file descriptors      */v     if (maxfds > 32) { 	errno = EBADF;          readyfds = -1; 	goto EXIT;+     }+       if (maxfds == 32)+ 	maxfds_mask = 0xffffffff;
     else { 	maxfds_mask = 0;# 	for (i=0; i < maxfds; i++)t 	    maxfds_mask |= (1<<i);e     }f       /*L      * Clear extranious bits and check for bad file descriptors.  Gather all9      * file descriptor bits into `all_fds' for use later.b      */d     if (exceptfds != NULL) { 	*exceptfds &= maxfds_mask;_6 	DTRACE("  --",0,"except fd mask: %08X",*exceptfds,0);1 	if ((*exceptfds & sys_validfds) != *exceptfds) {e 	    /*i< 	     * Set the exceptfds mask to indicate which fd was bad. 	     */  	    *exceptfds ^= sys_validfds; 	    errno = EBADF;f 	    return(-1); 	} 	all_fds = *exceptfds;     }l       if (writefds != NULL) {  	*writefds &= maxfds_mask;4 	DTRACE("  --",0,"write fd mask: %08X",*writefds,0);/ 	if ((*writefds & sys_validfds) != *writefds) {e 	    /*d< 	     * Set the exceptfds mask to indicate which fd was bad. 	     */ 	    *writefds ^= sys_validfds;  	    errno = EBADF;E 	    return(-1); 	} 	all_fds |= *writefds;     }+       if (readfds != NULL) { 	*readfds &= maxfds_mask;+2 	DTRACE("  --",0,"read fd mask: %08X",*readfds,0);- 	if ((*readfds & sys_validfds) != *readfds) {, 	    /*s< 	     * Set the exceptfds mask to indicate which fd was bad. 	     */ 	    *readfds ^= sys_validfds; 	    errno = EBADF;s 	    return(-1); 	} 	all_fds |= *readfds;r     }b  2     DTRACE("  --",0,"all_fd mask %08X",all_fds,0);   #ifdef UDP_POLLe     /**      * NETLIB's lack of UDP receive AST's:      * Setup polling interval.      */h%     if((sys_udpfds & all_fds) != 0) {-! 	    sprintf(at,"0 00:00:01.00"); 2 	    p = getenv("SOCKETSHR_UDP_POLLING_INTERVAL");! 	    if (p != NULL) strcpy(at,p);r* 	    ascii_time.dsc$w_length = strlen(at);0 	    i = sys$bintim(&ascii_time,&udp_tick_time); 	    if (!(i&1)) lib$stop(i);h 	    lib$get_ef(&udp_tick_ef);. 	    FD_SET((udp_tick_ef - EF_BASE),&ef_mask);S DTRACE("netlib1_select",0,"udp_tick_ef=%d, mask=%08X",udp_tick_ef-EF_BASE,ef_mask);g     }" #endif       /*5      * if this is a timed event then setup the timer.d      */L     if (timeout == NULL)	 	block++;      else7 	if (timeout->tv_sec != 0  ||  timeout->tv_usec != 0) {t
 	    block++;t 	    /*u( 	     * setup a timer AST to check later 	     */B 	    if (timeout->tv_sec > 86399) { /* not grater than 24 hours */ 		errno = EINVAL;m 		readyfds = -1; 		goto EXIT; 	    }& 	    lt = localtime(&timeout->tv_sec);0 	    sprintf(at,"0 %02.2d:%02.2d:%02.2d.%02.2d",9 		lt->tm_hour, lt->tm_min, lt->tm_sec, timeout->tv_usec);(* 	    ascii_time.dsc$w_length = strlen(at);  	    sys$bintim(&ascii_time,&t); 	    lib$get_ef(&timer_ef);$* 	    sys$setimr(timer_ef,&t,0,timer_ef,0);+ 	    FD_SET((timer_ef - EF_BASE),&ef_mask);eM DTRACE("netlib1_select",0,"timer-ef=%d, mask=%08X",timer_ef-EF_BASE,ef_mask);d 	}   CHECK_DESCRIPTORS:8 DTRACE("netlib1_select",0,"check_descriptors loop",0,0);   #ifdef UDP_POLL[     /*"      * NETLIB's lack of UDP AST's:&      * check all UDP file descriptors.      */ /     if((ready_fds = sys_udpfds & all_fds) != 0)+ 	for (i=0; i < maxfds; i++)+  	    if (FD_ISSET(i,&ready_fds))! 		netlib1_check_udp_receive(i,0);  #endif       /*!      * exception file descriptorsn      */      if (exceptfds != NULL)2 	if((ready_fds = sys_exceptfds & *exceptfds) != 0) 	    for (i=0; i < maxfds; i++)  		if (FD_ISSET(i,&ready_fds))u 		    readyfds++;o       /*      * write file descriptorst      */t     if (writefds != NULL)o0 	if((ready_fds = sys_writefds & *writefds) != 0) 	    for (i=0; i < maxfds; i++)  		if (FD_ISSET(i,&ready_fds))l 		    readyfds++;n       /*      * read file descriptors      */e     if (readfds != NULL)B DTRACE("netlib1_select",0,"sys_readfds mask: %08X",sys_readfds,0);. 	if((ready_fds = sys_readfds & *readfds) != 0) 	    for (i=0; i < maxfds; i++)( 		if (FD_ISSET(i,&ready_fds))T 		    readyfds++;t       /*!      * See if we'er ready to exitr      */O     if (readyfds == 0)
 	if (block) {* 	    if (timer_ef != 0)s( 		if (sys$clref(timer_ef) == SS$_WASSET) 		    goto EXIT; 	    for (i=0; i < maxfds; i++)  		if (FD_ISSET(i,&all_fds)) {e- 		    FD_SET((sd[i]->ef - EF_BASE),&ef_mask);EJ STRACE("netlib1_select",0,i,"ef=%d, mask=%08X",sd[i]->ef-EF_BASE,ef_mask); 		}a   #ifdef UDP_POLLi*     	    if((sys_udpfds & all_fds) != 0) { 		sys$clref(udp_tick_ef);mF DTRACE("netlib1_select",0,"sys$wflor, udp_tick_ef: %d",udp_tick_ef,0);@ 	        sys$setimr(udp_tick_ef,&udp_tick_time,0,udp_tick_ef,0); 	    } #endif  < DTRACE("netlib1_select",0,"sys$wflor, mask=%08X",ef_mask,0);  	    sys$wflor(EF_BASE,ef_mask); {n long mm; sys$readef(EF_BASE,&mm);4 DTRACE("netlib1_select",0,"$READEF mask=%08X",mm,0); }  	    goto CHECK_DESCRIPTORS; 	} 	f EXIT:-     if (timer_ef != 0) { 	sys$cantim(timer_ef,0); 	lib$free_ef(&timer_ef);     }1 #ifdef UDP_POLLr     if (udp_tick_ef != 0) {$ 	sys$cantim(udp_tick_ef,0);s 	lib$free_ef(&udp_tick_ef);      }  #endif     if (exceptfds != NULL), 	*exceptfds = (sys_exceptfds & maxfds_mask);     if (writefds != NULL)O* 	*writefds = (sys_writefds & maxfds_mask);     if (readfds != NULL)( 	*readfds = (sys_readfds & maxfds_mask);> DTRACE("netlib1_select",0,"returns: %d fds ready",readyfds,0);     return(readyfds);r }  tP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *>  * int getsockname(int s, struct sockaddr *name, int *namelen)  *  * Description:M,  *	Returns the name associated with a socket  *#  * s	   - a valid socket descriptordC  * name	   - sockaddr address structure where data is to be written ,  * namelen - number of bytes written to name  *  * Returns:sI  *	0 on success, -1 on error.  Addition error information is specified ini  * the global variable errno.   */=' int netlib1_getsockname(s,name,namelen)  int	s; struct	sockaddr *name;
 int	*namelen;& {a
 int	ret_size;  struct sockaddr_in loc;e struct sockaddr_in rem;b! struct sockaddr_in *local = &loc;s" struct sockaddr_in *remote = &rem;  struct dsc$descriptor host_dsc => 	{sizeof(inet_name), DSC$K_DTYPE_T, DSC$K_CLASS_S, inet_name};   int i; char buf[1024];n unsigned short int iosb[4];+  -     STRACE("netlib1_getsockname",0,s,"",0,0);+     /*      * check for valid sockett      */a     if (sd[s] == NULL) { 	errno = EBADF;a 	return(-1);     }n   /*    local		= &sd[s]->my; /**/e     local->sin_addr.s_addr = 0;d     local->sin_port    = 0;k+     sd[s]->mylen = sizeof(struct sockaddr);g  *     vaxc$errno = net_get_info(&sd[s]->ctx,1 		&remote->sin_addr.s_addr,	/* foreign address */-( 		&remote->sin_port,		/* foreign port */. 		&local->sin_addr.s_addr,	/* local address */& 		&local->sin_port);		/* local port */  #     if (vaxc$errno != SS$_NORMAL) {_' 	errno = netlib1_get_errno(vaxc$errno);sI         DTRACE("  --",0,"ERROR status:%08X, errno: %d",vaxc$errno,errno);l     }f
     else {4 #if 0	/* NETLIB Versions before 1.6 have a bug... */ 	if (netlib_loaded == CMU) {0 	    remote->sin_port = htons(remote->sin_port);. 	    local->sin_port = htons(local->sin_port); 	} #endif@ 	((struct sockaddr_in *)&sd[s]->my)->sin_port = local->sin_port;     }e     /*>      * net_get_info does not always give us the local address.:      * if 0 get the address via gethostname/gethostbyname.      */ &     if (local->sin_addr.s_addr == 0) { 	inet_name[0] = '\0'; 4 	vaxc$errno = net_get_hostname(&host_dsc,&ret_size); 	inet_name[ret_size] = '\0';>         DTRACE("  --",0,"net_get_hostname: {%s}",inet_name,0);' /*	if (vaxc$errno == SS$_NORMAL) { /**/m. 	    vaxc$errno = net_get_address(&sd[s]->ctx,( 		&host_dsc,		/* host name descriptor */( 		1,			/* maximum number of addresses */B 		&local->sin_addr.s_addr,/* array to be written with addresses */2 		&ret_size);		/* returned number of addresses */	J             DTRACE("  --",0,"net_get_address: status: %08X",vaxc$errno,0);	 /*	} /**/+     }+  &     if (local->sin_addr.s_addr != 0) {7 	((struct sockaddr_in *)&sd[s]->my)->sin_addr.s_addr = . 						local->sin_addr.s_addr;r     }k       local = &sd[s]->my;         local->sin_family	= AF_INET;  M     STRACE("netlib1_getsockname",0,s,"-- Local  Port: %d, Local  Addr: %08X",-7 	ntohs(local->sin_port),ntohl(local->sin_addr.s_addr));tM     STRACE("netlib1_getsockname",0,s,"-- Remote Port: %d, Remote Addr: %08X", 9 	ntohs(remote->sin_port),ntohl(remote->sin_addr.s_addr));s       /*3      * determine amount of data to return to callerd      */o3     ret_size = (sizeof(struct sockaddr) < *namelen) ) 				? sizeof(struct sockaddr) : *namelen;a     /*      * make the copy      */;'     memcpy(name, &sd[s]->my, ret_size);t     *namelen = ret_size;       return(0); }b cP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *>  * int getpeername(int s, struct sockaddr *name, int *namelen)  *  * Description:*,  *	Returns the name associated with a socket  *#  * s	   - a valid socket descriptor C  * name	   - sockaddr address structure where data is to be writtenU,  * namelen - number of bytes written to name  *  * Returns:.I  *	0 on success, -1 on error.  Addition error information is specified in-  * the global variable errno.a  */ ' int netlib1_getpeername(s,name,namelen)i int	s; struct	sockaddr *name;
 int	*namelen;f {c
 int	ret_size;; struct sockaddr_in loc;s struct sockaddr_in rem; ! struct sockaddr_in *local = &loc; " struct sockaddr_in *remote = &rem;  -     STRACE("netlib1_getpeername",0,s,"",0,0);      /*      * check for valid sockett      */      if (sd[s] == NULL) { 	errno = EBADF;t 	return(-1);     }    /*     local		= &sd[s]->my; */!      local->sin_family	= AF_INET; "      remote->sin_family	= AF_INET;,      sd[s]->mylen = sizeof(struct sockaddr);  +      vaxc$errno = net_get_info(&sd[s]->ctx,u1 		&remote->sin_addr.s_addr,	/* foreign address */ ( 		&remote->sin_port,		/* foreign port */. 		&local->sin_addr.s_addr,	/* local address */& 		&local->sin_port);		/* local port */  $      if (vaxc$errno != SS$_NORMAL) {' 	errno = netlib1_get_errno(vaxc$errno);1I         DTRACE("  --",0,"ERROR status:%08X, errno: %d",vaxc$errno,errno);f      }      else {c #if 0n 	if (netlib_loaded == CMU) {0 	    remote->sin_port = htons(remote->sin_port);. 	    local->sin_port = htons(local->sin_port); 	} #endif4 	memcpy(&sd[s]->my, local, sizeof(struct sockaddr));      }      local = &sd[s]->my;  M     STRACE("netlib1_getpeername",0,s,"-- Local  Port: %d, Local  Addr: %08X",+7 	ntohs(local->sin_port),ntohl(local->sin_addr.s_addr));hM     STRACE("netlib1_getpeername",0,s,"-- Remote Port: %d, Remote Addr: %08X",s9 	ntohs(remote->sin_port),ntohl(remote->sin_addr.s_addr));        /*3      * determine amount of data to return to callerd      */b3     ret_size = (sizeof(struct sockaddr) < *namelen)i) 				? sizeof(struct sockaddr) : *namelen;      /*      * make the copy      */ #     memcpy(name, remote, ret_size);e     *namelen = ret_size;       return(0); }f  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>a  * #include <socket.h>  *0  * int getsockopt(int s, int level, int optname,  *			char *optval, int *optlen)L  *  * Description:y'  *	Returns the options set on a socket.;  *  * Note:B  *	This routine does nothing.  Always returns -1 with errno set to  * ENOPROTOOPT.!  *$  * Returns: (if it did do something)I  *	0 on success, -1 on error.  Addition error information is specified in   * the global variable errno..  */N5 int netlib1_getsockopt(s,level,optname,optval,optlen)* int	s, level, optname;
 char	*optval;  int	*optlen; {f=     STRACE("netlib1_getsockopt",0,s,"optname: %d",optname,0);e     /*      * check for valid socket       */.     if (sd[s] == NULL) { 	errno = EBADF;S 	return(-1);     }t       /*6      * there are no socket level options at this time.      */P     errno = ENOPROTOOPT;     return(-1);- }x  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *0  * int setsockopt(int s, int level, int optname,  *			char *optval, int *optlen)   *(  * Description: (if it did do something)  *	Set the options on a socket.e  *  * Note:B  *	This routine does nothing.  Always returns -1 with errno set to  * ENOPROTOOPT.   *  * Returns:*I  *	0 on success, -1 on error.  Addition error information is specified in/  * the global variable errno.   */ 5 int netlib1_setsockopt(s,level,optname,optval,optlen)l int	s, level, optname;
 char	*optval;> int	optlen;s {t=     STRACE("netlib1_setsockopt",0,s,"optname: %d",optname,0);v     /*      * check for valid socketr      */E     if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }+       /*6      * there are no socket level options at this time.      */c     errno = ENOPROTOOPT;     return(-1);e }* *P /*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int gethostname(char *name, int namelen)   *  * Description:-5  *	Returns the name currently associated to the host.*  *4  * name	   - address of buffer to write name of host"  * namelen - length of name buffer  *  * Returns:eI  *	0 on success, -1 on error.  Addition error information is specified in"  * the global variable errno.,  */)& int netlib1_gethostname(name, namelen) char	*name;r int	namelen; {  int len;  struct dsc$descriptor host_dsc =/ 	{namelen, DSC$K_DTYPE_T, DSC$K_CLASS_S, name};D  +     DTRACE("netlib1_gethostname",0,"",0,0);r2     vaxc$errno = net_get_hostname(&host_dsc,&len);#     if (vaxc$errno != SS$_NORMAL) {T' 	errno = netlib1_get_errno(vaxc$errno);	J         DTRACE("  --",0,"ERROR status: %08X, errno: %d",vaxc$errno,errno); #if 0  	return(-1); #endif     };     name[len] = '\0';(P     DTRACE("netlib1_gethostname",0,"returned hostname: {%s}, len: %d",name,len);     return(0); };  + #if 0	/* no longer used, see [-]READDB.C */iP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *:  * struct servent *getservbyname(char *name, char *proto);  *  * Description:aC  *	returns a servent structure filled in with information about the*  * requested service.A  *?  * name  - pointer to character string of service to search for J  * proto - pointer to character string of protocol type desired (tcp, udp)  *	  * Notes:eH  *	The usual services text file is not supported.  Instead, services areH  * are logical names defined in the system logical name table.  Services(  * logical names are defined as follows:  *<  *	$ DEFINE /SYSTEM INET$SERVICE_service_name_protocol value  *  * Example:rJ  *   To define the service telnet, protocol tcp, port 23 use the following
  * statement:m-  *	$ DEFINE/SYSTEM INET$SERVICE_TELNET_TCP 23-  *  * Returns:iJ  *	Returns the address of a servent structure on success, the NULL pointer  * on error (see __trnlnm).e  */    static struct servent serv;i  2 struct servent *netlib1_getservbyname(name, proto) char	*name;h char	*proto; {o char	logical[256]; char	port[16];    5     sprintf(logical,"INET$SERVICE_%s_%s",name,proto);i  G     vaxc$errno = __trnlnm( "LNM$SYSTEM", &logical, "Super", &port, 16);*     if (vaxc$errno == 0) { 	serv.s_name = name;" 	serv.s_port = htons(atoi(&port)); 	serv.s_proto = proto;g         DTRACE("netlib1_getservbyname",0,"returned name: %s, port: %d",serv.s_name,ntohs(serv.s_port));e 	return (&serv);     }e     else 	return(NULL); }o nP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++8  * struct servent *getservbyport(int port, char *proto);  *  * Description:2C  *	returns a servent structure filled in with information about ther  * requested port.  *1  * port  - int value of port number to search for{J  * proto - pointer to character string of protocol type desired (tcp, udp)  *	  * Notes:"H  *	The usual services text file is not supported.  Instead, services areH  * are logical names defined in the system logical name table.  Services(  * logical names are defined as follows:  *=  *	$ DEFINE /SYSTEM INET$SERVICE_port_number_protocol serviceh  *  * Example:pJ  *   To define the service telnet, protocol tcp, port 23 use the following
  * statement:T-  *	$ DEFINE/SYSTEM INET$SERVICE_23_TCP TELNETa  *  * Returns: J  *	Returns the address of a servent structure on success, the NULL pointer  * on error (see __trnlnm).   */ 2 struct servent *netlib1_getservbyport(port, proto)	 int	port;  char	*proto; {* char	logical[256]; char	name[32];  5     sprintf(logical,"INET$SERVICE_%d_%s",port,proto);   G     vaxc$errno = __trnlnm( "LNM$SYSTEM", &logical, "Super", &name, 32);p     if (vaxc$errno == 0) { 	serv.s_name = &name;p 	serv.s_port = htons(port);e 	serv.s_proto = proto;g         DTRACE("netlib1_getservbyname",0,"returned name: %s, port: %d",serv.s_name,ntohs(serv.s_port));( 	return (&serv);     }e     else 	return(NULL); }t #endif LP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *,  * struct hostent *gethostbyname(char *name)  *  * Description: ;  *	returns the host address associated with the given name.   *M  * name - pointer to a character string that contains the host/domain name toa  *        search for.   *
  * Return:J  *	Returns the address of a hostent structure on success, the NULL pointerM  * on error.  Additional error information is returned in the global variables	  * errno.e  */ + struct hostent *netlib1_gethostbyname(name)  char	*name;  {e
 void	*namctx;l int	alcount; int	i; unsigned long	laddr;  struct dsc$descriptor host_dsc =& 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  8     DTRACE("netlib1_gethostbyname",0,"name: %s",name,0);     /*O      * If the first character of the hostname is numeric then quit (must be dotf      * notation address).       */a  2     if (isdigit(name[0])  ||  strlen(name) == 0) { 	errno = EBADF;; 	return(NULL);     }t       net_assign(&namctx);       i = strlen(name);t$     str$copy_r(&host_dsc, &i, name);     alcount = 0; DTRACE("  --",0,"**1**",0,0); )     vaxc$errno = net_get_address(&namctx,u( 		&host_dsc,		/* host name descriptor */0 		MAX_INADDR,		/* maximum number of addresses */6 		inet_list,		/* array to be written with addresses */1 		&alcount);		/* returned number of addresses */	d DTRACE("  --",0,"**2**",0,0);N    #     if (vaxc$errno != SS$_NORMAL) {>' 	errno = netlib1_get_errno(vaxc$errno);t 	net_deassign(&namctx);u 	return(NULL);     }        /*D      * Get the official name of the host we just got the address for      */o:     memcpy(&laddr, &inet_list[0], sizeof(struct in_addr));*     vaxc$errno = net_addr_to_name(&namctx, 		laddr,			/* address */5 		&host_dsc);		/* dynamic descriptor for host name */l       net_deassign(&namctx);  #     if (vaxc$errno != SS$_NORMAL) {(' 	errno = netlib1_get_errno(vaxc$errno);  	return(NULL);     })  C     memcpy(inet_name,host_dsc.dsc$a_pointer,host_dsc.dsc$w_length); ,     inet_name[host_dsc.dsc$w_length] = '\0';  %     inet_host.h_name     = inet_name;S%     inet_host.h_aliases  = &null_ptr; #     inet_host.h_addrtype = AF_INET;r2     inet_host.h_length   = sizeof(struct in_addr);:     for (i=0; i<alcount; i++) addrlist[i] = &inet_list[i];     addrlist[alcount] = NULL;e%     inet_host.h_addr_list = addrlist;      str$free1_dx(&host_dsc);I     DTRACE("netlib1_gethostbyname",0,"returned name: %s, first addr: %s",f+ 	inet_host.h_name,INTOA(inet_host.h_addr));n     return(&inet_host);t }  NP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++?  * struct hostent *gethostbyaddr(char *addr, int len, int type)   *  * Description:l7  *	Return official name of host given the host address.(  *H  * addr - a pointer to a series of bytes in network order specifying the,  *        address of the host to search for.%  * len  - number of bytes in the addrr4  * type - address format. Only AF_INET is supported.  *
  * Return:J  *	Returns the address of a hostent structure on success, the NULL pointerM  * on error.  Additional error information is returned in the global variable 	  * errno.f  */t  4 struct hostent *netlib1_gethostbyaddr(addr,len,type) char	*addr;d int	len, type; {o
 void	*namctx;   struct dsc$descriptor host_dsc =& 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; int	alcount; int	i; unsigned long	laddr;  E     DTRACE("netlib1_gethostbyaddr",0,"addr: %08X",*((long *)addr),0);      if (type != AF_INET) { 	errno = EAFNOSUPPORT; 	return(NULL);     }        net_assign(&namctx);  1     memcpy(&laddr, addr, sizeof(struct in_addr));(  *     vaxc$errno = net_addr_to_name(&namctx, 		laddr,			/* address */5 		&host_dsc);		/* dynamic descriptor for host name */c       net_deassign(&namctx);  #     if (vaxc$errno != SS$_NORMAL) {,' 	errno = netlib1_get_errno(vaxc$errno);s 	return(NULL);     }k  C     memcpy(inet_name,host_dsc.dsc$a_pointer,host_dsc.dsc$w_length);$,     inet_name[host_dsc.dsc$w_length] = '\0';       alcount = 1;8     memcpy(&inet_list[0], addr, sizeof(struct in_addr));  %     inet_host.h_name     = inet_name;d%     inet_host.h_aliases  = &null_ptr; #     inet_host.h_addrtype = AF_INET;b2     inet_host.h_length   = sizeof(struct in_addr);:     for (i=0; i<alcount; i++) addrlist[i] = &inet_list[i];     addrlist[alcount] = NULL; %     inet_host.h_addr_list = addrlist;k     str$free1_dx(&host_dsc);C     DTRACE("netlib1_gethostbyaddr",0,"returned name: %s, addr: %s",r+ 	inet_host.h_name,INTOA(inet_host.h_addr));n     return(&inet_host);+ }+ +P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <ioctl.h>   *,  * int ioctl(int s, int request, char *argp)  *  * Description:a  *	control device.  *&  * s       - a valid socket descriptor  * request - one of:*  *		FIOCLEX		- set exclusive use on socket#  *		FIONCLEX	- remove exclusive usea)  *		FIONBIO		- set/clear non-blocking i/ob+  *		FIONREAD	- get # bytes ready to be reado7  * argp    - address of buffer for return information		e  *		  * Returns:gI  *	0 on success, -1 on error.  Addition error information is specified in	  * the global variable errno.	  */l static int sign(val) {      if (val == 0) return(0);      return( (val > 0) ? 1 : -1); }_  ! int netlib1_ioctl(s,request,argp)n int	s; int	request; void	*argp;p {  int	i; unsigned long *n;a  :     STRACE("netlib1_ioctl",0,s,"request: %08X",request,0);     /*      * check for valid socket]      */      if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }f       errno = 0;  *     switch ((request & 0x0000ff00) >> 8) { 	case 't' :r 	case 's' :n 	case 'r' :a 	case 'i' :m 	    errno = EIO;- 	    break;d 	case 'f' :  	    n  = (long *)argp; $ 	    switch (request & 0x000000ff) {6 		case 1 :	/* FIOCLEX - set exclusive use on socket */1 		case 2 :	/* FIONCLEX - remove exclusive use	 */	$ 		    sd[s]->ioctl_opts &= ~FEXLOCK;. 		    sd[s]->ioctl_opts |= FEXLOCK * sign(*n); 		    break;8 		case 126 :	/* FIONBIO - set/clear non-blocking i/o  */% 		    sd[s]->ioctl_opts &= ~O_NDELAY;x/ 		    sd[s]->ioctl_opts |= O_NDELAY * sign(*n);: 		    break;9 		case 127:	/* FIONREAD - get # bytes ready to be read */  		    /*3 		     * if the socket read blocked return an error)	 		     */m+ 		    if ((sd[s]->ioctl_opts & FREAD) != 0)  			errno = EPIPE;h# 		    if (FD_ISSET(s,&sys_readfds))() 			*n = sd[s]->read_iosb.iosb_byte_count; 
 		    else
 			*n = 0; 		    break;
 		default: 		    errno = EIO; 		    break; 	    } 	    break;*     }e  "     return ( errno == 0 ? 0 : -1); }m  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <file.h>  *)  * int fcntl(int s, int request, int arg)'  *  * Description:"  *	file control.  *&  * s       - a valid socket descriptor  * request - One of:  *		F_GETFL - get file flags  *		F_SETFL - set file flags  * arg     - flags to setp  *  * Returns: @  *	Value of flags or -1 on error.  Addition error information is*  * specified in the global variable errno.  *//  int netlib1_fcntl(s,request,arg) int s, request, arg; {-E     STRACE("netlib1_fcntl",0,s,"request: %08X, arg: %d",request,arg);      /*      * check for valid socket{      */c     if (sd[s] == NULL) { 	errno = EBADF;r 	return(-1);     }n       switch (request) { 	case F_GETFL :] 	    return(sd[s]->ioctl_opts);  	case F_SETFL :T 	    if (arg == O_NDELAY) {s 		sd[s]->ioctl_opts = arg; 		return(0);
             }> 	    return(-1);
 	default : 	    errno = EINVAL; 	    return(-1);     }0 }" RP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>*  * #include <socket.h>  *&  * int read(int s, char *buf, int len)  *  * Description:s)  *	Receive bytes from a connected socket.s  *"  * s   - a valid socket descriptor8  * buf - address of buffer to where input data is placed  * len - max size of buf  *  * Returns: E  *	Number of bytes read from the socket, -1 on error.  Addition error+9  * information is specified in the global variable errno.#  */d int netlib1_read(s,buf,len)e int	s;
 char	*buf; int	len; {m0     STRACE("netlib1_read",0,s,"%d bytes",len,0);     /*      * check for valid socket       */      if (sd[s] == NULL) { 	errno = EBADF;c 	return(-1);     }r       /*      * Must be connected      */n+     if ((sd[s]->flags & SD_CONNECTED) != 0)s+ 	return(netlib1_recvfrom(s,buf,len,0,0,0));r
     else { 	errno = EBADF;i 	return(-1);     }i }e rP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *2  * int write(int s, char *msg, int len, int flags)  *  * Description: 5  *	Send bytes through a socket to its connected peer.l  *"  * s   - a valid socket descriptor-  * buf - address of buffer of data to be sentf  * len - size of buf  *  * Returns:rF  *	Number of bytes written to the socket, -1 on error.  Addition error9  * information is specified in the global variable errno.s  */> int netlib1_write(s,msg,len) int	s;
 char	*msg; int	len; {n1     STRACE("netlib1_write",0,s,"%d bytes",len,0);r     /*      * check for valid socket	      */n     if (sd[s] == NULL) { 	errno = EBADF;a 	return(-1);     }l       /*      * Must be connected      */x+     if ((sd[s]->flags & SD_CONNECTED) != 0)t) 	return(netlib1_sendto(s,msg,len,0,0,0));,
     else { 	errno = EBADF;% 	return(-1);     }f }  }P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int close(int s)   *  * Description:=7  *	Closes a connection and deletes a socket descriptor.   *E  * To avoid confusion and link warnings regarding the `close' routineTC  * for other file descriptors this routine name is `netlib1_close'."a  * A "#define close(s) netlib1_close(s)" or direct call to netlib1_close(s) is needed in routines"S  * close sockets managed by this library.   If this routine is called with a socketaN  * descriptor that is not managed by this library it will pass that descriptor  * to the system close routine.s  *   * s - an open socket descriptor  *  * Returns:dI  *	0 on success, -1 on error.  Addition error information is specified inr  * the global variable errno.n  */t int netlib1_close(s) int	s; {  struct	backlogEntry *entry;+  '     STRACE("netlib1_close",0,s,"",0,0);+     /*H      * if this is not one of our channels then pass it on to the systems      * close routine.m      */c     if (sd[s] == NULL) 	return(close(s));       /*M      * Verify that the channel is indeed open -- in some cases it may not be.g      */ -     if ((sd[s]->flags & SD_CONNECTED) != 0) {  	/**$ 	 * close/deallocate the I/O channel 	 */ 	tcp_disconnect(&sd[s]->ctx);      }n       /*'      * Clear all the associated fd bitse      */*     FD_CLR(s,&sys_validfds);     FD_CLR(s,&sys_readfds);      FD_CLR(s,&sys_writefds);     FD_CLR(s,&sys_exceptfds);  #ifdef UDP_POLLe     FD_CLR(s,&sys_udpfds); #endif       /*:      * free the various resources that we have accumulated      */{     if (sd[s]->ef != 0)r 	lib$free_ef(&sd[s]->ef);    #if 0e)     if (sd[s]->protocol == IPPROTO_UDP) {  	if (sd[s]->rcvbuf != NULL)O 	    free(sd[s]->rcvbuf);      }+ #endif.     if (sd[s]->read_dsc.dsc$a_pointer != NULL)  	str$free1_dx(&sd[s]->read_dsc);     /*%      * was this an `accept'ed socket?s      */(J     if (sd[s]->listen_socket != 0  &&  sd[sd[s]->listen_socket] != NULL) {) 	sd[sd[s]->listen_socket]->backlogSize--;t 	/*t) 	 * requeue the listen if it was shutdowno 	 */; 	if ((sd[sd[s]->listen_socket]->flags & SD_LISTENING) == 0)T0 	    netlib1_queue_listen(sd[s]->listen_socket);     }A       /*9      * purge the listen queue if this was a listen socketr      */ 2     if ((sd[s]->sock_opts & SO_ACCEPTCONN) != 0) {& 	while (sd[s]->backlogQueue != NULL) {! 	    entry = sd[s]->backlogQueue;"( 	    sd[s]->backlogQueue = entry->flink; 	    cfree(entry); 	}     }f       net_deassign(&sd[s]->ctx);       cfree(sd[s]);e     sd[s] = 0;A     close(s);	/* this should free up the duped file descriptor */t     return(0); }   P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include "netlib.h"  *&  * int *netlib1_stdin_open(char *name)  *  * Description:iI  *	To have stdin a device that can be selected the descriptor needs to bedM  * allocated within the domain of these routines.  This routine allocates themJ  * file descriptor and returns the address of the FD_ENTRY so the user canO  * control reads/writes and still use select to see if the descriptor is ready.*M  * Optionally the user can use the following routine to queue reads on stdin.   *L  * name - character string device name of the device to assign a channel to.  *  * Returns:AF  *	Address of an FD_ENTRY structure on success, -1 on error.  Addition?  * error information is specified in the global variable errno.n  */1 int *netlib1_stdin_open(name)  char	*name;- {, struct	dsc$descriptor dev_name;a       if (sd[0] != NULL) { 	errno = EBADF;f 	return(-1);     }n0     sd[0] = calloc( 1, sizeof(struct FD_ENTRY));     FD_CLR(0,&sys_readfds);d     FD_SET(0,&sys_validfds);       /*M      * copy the `name' to the `my' sockaddr area (seems like a logical place)+      */+     if (strlen(name) <= 14) {+ 	sd[0]->mylen = strlen(name);e 	sd[0]->my.sa_family = 0;p0 	memcpy(&sd[0]->my.sa_data, name, strlen(name));     }u
     else { 	errno = ENAMETOOLONG; 	goto ERROR_RETURN;r     }        /*C      * setup a discriptor for the device and assign a channel to it-      */t*     dev_name.dsc$w_length  = sd[0]->mylen;+     dev_name.dsc$b_dtype   = DSC$K_DTYPE_T;i+     dev_name.dsc$b_class   = DSC$K_CLASS_S;v0     dev_name.dsc$a_pointer = &sd[0]->my.sa_data;  ;     vaxc$errno = sys$assign(&dev_name, &sd[0]->chan, 0, 0);a  #     if (vaxc$errno != SS$_NORMAL) {T 	errno = EVMSERR;m 	goto ERROR_RETURN;      }p       lib$get_ef(&sd[0]->ef);e     sys$clref(sd[0]->ef);      /*L      * return the address of the socket descriptor so the user can play with
      * it.      */R     return(sd[0]);  
 ERROR_RETURN:t     if (sd[0] != NULL) 	cfree(sd[0]);     sd[0] = NULL;)     return(-1);c }r  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++P  * int netlib1_stdin_read(int flags, char *buf, int len, char *prompt, int mask)  *  * Description:mI  *	queue an i/o to the descriptor described in sd[0].  Since this read ispH  * ment to be used with the select call a non-blocking qio is done.  TheI  * completion routine will set the file descriptor and event flag on reads  * completion.  *  * flags  - qio read modifiers&  * buf    - to receive characters read"  * len    - max characters to read"  * prompt - prompt string for read   * mask   - read terminator mask  *  * Returns:+/  *	Status from the SYS$QIO system service call.a  */o1 int netlib1_stdin_read(flags,buf,len,prompt,mask)r
 int	flags;
 char	*buf; int	len;
 char	*prompt;r	 int	mask;r {        /*!      * Clear these system things.a      */      sys$clref(sd[0]->ef);c     FD_CLR(0, &sys_readfds);       if (prompt != NULL)t@ 	vaxc$errno = sys$qio( 0, sd[0]->chan, flags, &sd[0]->read_iosb, 			netlib1_read_ast,0, 			buf, len,$ 			0, mask, prompt, strlen(prompt));     else@ 	vaxc$errno = sys$qio( 0, sd[0]->chan, flags, &sd[0]->read_iosb, 			netlib1_read_ast,0, 			buf, len, 			0, 0, 0, 0);a     return(vaxc$errno);e }				e lP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int netlib1_get_sdc(int s)   *  * Description:rD  *	Returns the assigned VMS channel for a particular file descriptor  *   * s - a valid socket descriptor  *  * Returns:bT  *  If successful a VMS i/o channel number is returned otherwise a 0 is returned and  *  errno is set.i  *  */a short int netlib1_get_sdc(s) int	s; {      /*      * check for valid socket.      */"     if (sd[s] == NULL) { 	errno = EBADF;  	return(0);_     }&     else 	return(sd[s]->chan);) }  rP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++%  * int netlib1_get_errno(long status))  *  * Description: &  *	returns best guess value for errno.  *  * status - status code+  *  * Returns:+  *	Returns an errno value.  */+ int netlib1_get_errno(status)  long status; {a int netlib1_errno = 0;   #define ERRMAP(vms,unix) \ 	case vms:\t 		netlib1_errno = unix;\ 		break;     /*$      * Choose errno based on status.      */t     switch (status) {    	ERRMAP(SS$_NORMAL	, 0)t* 	ERRMAP(0		, EVMSERR)	/* use vaxc$errno */8 	ERRMAP(SS$_ABORT	, ECONNABORTED)	/* INETACP has died */5 	ERRMAP(SS$_MEDOFL	, ENETDOWN)	/* INETACP has died */lA 	ERRMAP(SS$_BADPARAM	, EINVAL)	/* parameter not valid for call */ @ 	ERRMAP(SS$_EXQUOTA	, EMSGSIZE)	/* buffer allocation problems */> 	ERRMAP(SS$_INSFMEM	, ENOMEM)	/* buffer allocation problems *// 	ERRMAP(SS$_NOPRIV	, EACCES)	/* no privilege */s9 	ERRMAP(SS$_ACCVIO	, EFAULT)	/* buffer access problems */ C 	ERRMAP(SS$_ILLCNTRFUNC	, EOPNOTSUPP)	/* operation not supported */n= 	ERRMAP(SS$_CONNECFAIL	, ECONNRESET)	/* conn reset by peer */t  	ERRMAP(SS$_DEVINACT	, ENETDOWN)# 	ERRMAP(SS$_DEVNOTMOUNT	, ENETDOWN)_@ 	ERRMAP(SS$_DUPLNAM	, EADDRINUSE)	/* bind failed, port in use */1 	ERRMAP(SS$_FILALRACC	, EEXIST)	/* file exists */*8 	ERRMAP(SS$_IVADDR	, EADDRNOTAVAIL)/* invalid address */; 	ERRMAP(SS$_IVBUFLEN	, EINVAL)	/* invalid address buffer */a6 	ERRMAP(SS$_NOLICENSE	, ECONNREFUSED)	/* no license */3 	ERRMAP(SS$_NOLINKS	, ENOTCONN)	/* not connected */e5 	ERRMAP(SS$_NOOPER	, EACCES)	/* OPER priv required */)F 	ERRMAP(SS$_LINKABORT	, ECONNABORTED)	/* software caused conn abort */= 	ERRMAP(SS$_LINKDISCON	, EPIPE)	/* socket closed by remote */ A 	ERRMAP(SS$_PROTOCOL	, EAFNOSUPPORT)	/* TCP/IP and UDP/IP only */e> 	ERRMAP(SS$_REJECT	, ECONNREFUSED)	/* many reasons for this */< 	ERRMAP(SS$_SHUT		, ENETDOWN)	/* network is shutting down */A 	ERRMAP(SS$_SUSPENDED	, EWOULDBLOCK)	/* accept with no request */r: 	ERRMAP(SS$_TIMEOUT	, ETIMEDOUT)	/* operation timed out */@ 	ERRMAP(SS$_TOOMUCHDATA	, EMSGSIZE)	/* IP packet size problem */C 	ERRMAP(SS$_UNREACHABLE	, ENETUNREACH)	/* network not reachable */	eB 	ERRMAP(SS$_BUFFEROVF	, EMSGSIZE)	/* buffer allocation problems */B 	ERRMAP(SS$_RESULTOVF	, EMSGSIZE)	/* buffer allocation problems */B 	ERRMAP(SS$_NOTNETDEV	, ENOTSOCK)	/* socket op. on a non-socket */? 	ERRMAP(SS$_NOSUCHNODE	, EDESTADDRREQ)	/* dest addr required */;: 	ERRMAP(SS$_RESET	, ENETRESET)	/* network dropped conn. */8 	ERRMAP(SS$_NOSUCHDEV	, ENXIO)	/* no such dev or addr */  	 	default:d /*		netlib1_errno = EIO; /**/s 		netlib1_errno = EVMSERR; /**/r 	} 	return(netlib1_errno);n }, OP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#  * int netlib1_listen_accept(int s)+  *  * Description:*G  *	AST completion routine called when a connection completes on an opens  *	listening socket.  *  * s - valid socket descriptor  *  * Returns:*  *	None.  */e int netlib1_listen_accept(s) int	s;	/* socket descriptor */ {  int	ns, tmp;" struct	backlogEntry *backlogQueue; struct	sockaddr_in *to;   V     STRACE("netlib1_listen_accept",0,s,"status: %08X",sd[s]->read_iosb.iosb_status,0);     /*,      * check the stats of the completed open      */r5     if (sd[s]->read_iosb.iosb_status != SS$_NORMAL) {l 	/* # 	 * failed; set exceptfds and eventh 	 */ 	FD_SET(s,&sys_exceptfds); 	sys$setef(sd[s]->ef); 	return(SS$_NORMAL);     }a       /*6      * get a new clean socket like the one we have now      */,K     ns = netlib1_alloc_socket(sd[s]->domain, sd[s]->type, sd[s]->protocol);s&     sd[ns]->chan = sd[s]->accept_chan;     sd[ns]->accept_chan = 0;$     sd[ns]->ctx = sd[s]->accept_ctx;     sd[ns]->accept_ctx = 0;n       /*!      * Get connection information(      */_,     sd[ns]->tolen = sizeof(struct sockaddr);9     netlib1_getpeername(ns, &sd[ns]->to, &sd[ns]->tolen);i       /*&      * copy the local port information      */;?     memcpy(&sd[ns]->my, &sd[s]->my,   sizeof(struct sockaddr));r       /*)      * Set the bound and connected flags.y      */e-     sd[ns]->flags = (SD_BIND | SD_CONNECTED);$       /*3      * indicate which socket this accept came from.       */e     sd[ns]->listen_socket = s;       /*'      * switch the assigned I/O channelse      */  /*    tmp		 = sd[s]->chan; */l% /*    sd[s]->chan  = sd[ns]->chan; */N /*    sd[ns]->chan = tmp;    */s       /*4      * insert this new socket into the backlog queue      */_&     if (sd[s]->backlogQueue == NULL) {= 	sd[s]->backlogQueue = calloc(1,sizeof(struct backlogEntry));t$ 	backlogQueue = sd[s]->backlogQueue;     }"
     else {$ 	backlogQueue = sd[s]->backlogQueue;$ 	while (backlogQueue->flink != NULL)( 	    backlogQueue = backlogQueue->flink;= 	backlogQueue->flink = calloc(1,sizeof(struct backlogEntry)); $ 	backlogQueue = backlogQueue->flink;     }s     backlogQueue->sock = ns;       /*0      * Increment the count of accepted requests.      */e     sd[s]->backlogSize++;o       /*7      * tell someone how cares that something came in...r      */l     FD_SET(s,&sys_readfds);t% /*    sys$setef(accept_net_event); */-     sys$setef(sd[s]->ef);a       /*      * queue another listenr      */o     netlib1_queue_listen(s);       return(SS$_NORMAL);r }  dP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"  * int netlib1_queue_listen(int s)  *  * Description: 1  *	Queue a read that will accept a TCP connectiont  *   * s - a valid socket descriptor  *  * Returns: I  *	0 on success, -1 on error.  Addition error information is specified in%  * the global variable errno.*  */k int netlib1_queue_listen(s) + int	s;	/* socket descriptor to listen on */r {r struct	sockaddr_in *my;n int ns;  $DESCRIPTOR(dev,"NLA0:");0  .     STRACE("netlib1_queue_listen",0,s,"",0,0);     /*G      * if reads are shutdown on this socket then don't queue the listenl      */p+     if ((sd[s]->ioctl_opts & FREAD) != 0) {a 	errno = ESHUTDOWN;e 	return(-1);     }c       /*M      * if there are already 'backlog' number of connections then exit withoutEF      * posting the listen.  The close routine will requeue the listen.      */:.     if (sd[s]->backlogSize < sd[s]->backlog) { 	sd[s]->flags |= SD_LISTENING;       /*1      * get a new NETLIB context for accept socket $      * same hack here as in socket()      */e, 	sys$assign(&dev,&sd[s]->accept_chan,0,0,0);  	sys$dassgn(sd[s]->accept_chan);- 	vaxc$errno = net_assign(&sd[s]->accept_ctx);F  	if (vaxc$errno != SS$_NORMAL) {+ 	    errno = netlib1_get_errno(vaxc$errno);  	    return(-1); 	}       /*      * now post the listen      */aL 	vaxc$errno = tcp_accept(&sd[s]->ctx, &sd[s]->accept_ctx, &sd[s]->read_iosb,C 		netlib1_listen_accept, s);	/* ast completion routine and param */+    	if (vaxc$errno != SS$_NORMAL) {= 	    errno = netlib1_get_errno(sd[s]->read_iosb.iosb_status);i 	    return(-1); 	} 	sd[s]->flags |= SD_CONNECTED;     }o
     else { 	sd[s]->flags ^= SD_LISTENING;     }        return(0); }  	P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int netlib1_read_ast(int s)  *  * Description: ?  *	AST read completion routine.  Sets the global sys_readfds tolH  * indicate the socket is ready to read or sys_exceptfds if there was an	  * error.E  *  * s - valid socket descriptor  *  * Returns:,  *	Nothing.*  */  void netlib1_read_ast(s)+ int	s;	/* file descriptor that is ready. */= {A struct sockaddr_in *rcv;  O     STRACE("netlib1_read_ast",0,s,"iosb: %08X",sd[s]->read_iosb.iosb_status,0);s+     switch (sd[s]->read_iosb.iosb_status) {	 	case SS$_NORMAL:  	    FD_SET(s,&sys_readfds); 	case SS$_ABORT: 	case SS$_CANCEL:  	    /*=E 	     * if the status code is SS$_CANCEL or SS$_ABORT then I/O on the+H 	     * channel was cancled.  Don't set the exception flag in this case. 	     */ 	    break;.	 	default:i 	    /*n2 	     * all other status returns indicate an error 	     */ 	    FD_SET(s,&sys_exceptfds);' 	    FD_SET(s,&sys_readfds);	/* ???? */b     }d         /*I      * check for socket closed by remote. If it was then make if no-read,       * no-write, and invalid.t      */, /*?  *    if ((sd[s]->read_iosb.X.STATUS & 0x0000ff00) == 0x0600) {o)  *	sd[s]->ioctl_opts |= (FREAD & FWRITE);d  *	FD_CLR(s,&sys_validfds);u  *    }e  */m #ifdef UDP_POLLlC     FD_CLR(s,&sys_udpfds);	/* don't wait for UDP read any longer */e #endif)     if (sd[s]->protocol == IPPROTO_UDP) {A 	rcv = &sd[s]->rcvfrom;r& 	rcv->sin_port = htons(rcv->sin_port); 	rcv->sin_family = AF_INET; / 	DTRACE("  --",0,"received addr: %s, port: %d",s1 		inet_ntoa(rcv->sin_addr),ntohs(rcv->sin_port));r     }1     /*?      * now set the event flag to signal the read has completed.+      */+     sys$setef(sd[s]->ef);d }t   hP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++   * void netlib1_write_ast(int s)  *  * Description:tA  *	AST write completion routine.  Sets the global sys_writefds tobN  * indicate the socket is ready to be written or sys_exceptfds if there was an	  * error.e  *  * s - valid socket descriptor  *  * Returns:i  *	Nothing.i  */a void netlib1_write_ast(s)o+ int	s;	/* file descriptor that is ready. */( {s4     if (sd[s]->write_iosb.iosb_status == SS$_NORMAL) 	FD_SET(s,&sys_writefds);s     else 	FD_SET(s,&sys_exceptfds);   }s e #ifdef UDP_POLL P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *2  * int netlib1_check_udp_receive(int s, int flag);  *  * Description:r   *	Check UDP read on socket `s'.*  * On immediate timeout return SS$_NORMAL;E  * On completion call netlib1_read_ast. This replaced the NETLIB lack+  * of AST's on UDP receive.   *  * s - valid socket descriptorH  * flag - wait flag: 0 return immediately, 1 wait for something received  *  * Returns:   *	VMS status.  * the global variable errno.T  */f. int netlib1_check_udp_receive(int s, int wait) {l long timeout[2]; struct sockaddr_in *rcv; struct sockaddr_in *my;  int i;  >     STRACE("netlib1_check_udp_receive",0,s,"wait: %d",wait,0);     /*B      * Check if something has been received already. If so return.      */a>     if (sd[s]->read_iosb.iosb_status != 0) return(SS$_NORMAL);       /*+      * Setup timeout: immediately or never.r      */R     if (wait) {  	timeout[0] = 0;A 	timeout[1] = 0xFFF00000;	/* That's 5212 days and a few hours..*/i     }r
     else { 	timeout[0] = -1;); 	timeout[1] = -1;		/* That's 1 nano-second... immediately*/l     }s       /*      * now try to read...h      */      my = &sd[s]->my;     rcv = &sd[s]->rcvfrom;L     DTRACE("  --",0,"rcvbuf=%08X, size=%d",sd[s]->rcvbuf,sd[s]->rcvbufsize);
     i = 0;)     vaxc$errno = udp_receive(&sd[s]->ctx,e$ 	sd[s]->rcvbuf,		/* receive buffer*/, 	sd[s]->rcvbufsize,	/* receive buffer size*/8 	&sd[s]->read_iosb.iosb_byte_count,	/* received bytes */! 	&i,			/* receive from address */ ) 	&rcv->sin_port,		/* receive from port */a 	timeout); /**/      rcv->sin_addr.s_addr = i;s       /*5      * On timeout return normally. iosb is untouched.       */s$     if (vaxc$errno == SS$_TIMEOUT) {A     DTRACE("  --",0,"UDP read timeout - nothing to receive",0,0);u /*B  * Here is the next hack: on CMU/IP the UDP socket disappears when@  * the read is cancelled. Just setup a new socket and don't care  * for errors.  */ H 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_UDP, ntohs(my->sin_port),1,1);  	if (vaxc$errno != SS$_NORMAL) {7 	    DTRACE("  --",0,"ERROR status:%08X",vaxc$errno,0);* 	    return(SS$_NORMAL); 	} 	else {* 	    return(SS$_NORMAL); 	}     }        /*E      * Either something has been received or error. In any case, call-)      * the AST-routine and return status.s      */ .     sd[s]->read_iosb.iosb_status = vaxc$errno;     netlib1_read_ast(s);     return(vaxc$errno);- }s #endif	/* UPD_POLL */   P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *$  * int netlib1_queue_net_read(int s)  *  * Description:lD  *	Queue a read on socket `s' to be completed by net_read_ast.  ThisL  * routine will also allocate an event flag and receive buffer if necessary.  * #ifdef UDP_POLL I  * We have some problems with UDP here: NETLIB doesn't support AST's withpF  * UDP receive. So we use use a minimum timeout to return immediately. #endif  *  * s - valid socket descriptor  *  * Returns:#I  *	0 on success, -1 on error.  Addition error information is specified inr  * the global variable errno.v  */h int netlib1_queue_net_read(s)o int	s; {b long timeout[2]; struct sockaddr_in *rcv;  0     STRACE("netlib1_queue_net_read",0,s,"",0,0);     /*B      * clear event flag and file descriptor for this read request.      */e     sys$clref(sd[s]->ef);e     FD_CLR(s, &sys_readfds);       /**      * Allocate a receive buffer for reads      */       if (sd[s]->rcvbuf == NULL) {? 	vaxc$errno = str$get1_dx(&sd[s]->rcvbufsize,&sd[s]->read_dsc); 2 /*	sd[s]->rcvbuf = malloc(sd[s]->rcvbufsize); /**/  	if (vaxc$errno != SS$_NORMAL) { /*		How to abort ?	*/n 	    errno = ENOBUFS;o 	    return(-1); 	}/ 	sd[s]->rcvbuf = sd[s]->read_dsc.dsc$a_pointer;-     }t       sys$clref(sd[s]->ef);a       timeout[0] = 0;LE     timeout[1] = 0xFFF00000;		/* That's 5212 days and a few hours..*/z)     sd[s]->read_iosb.iosb_byte_count = 0;e%     sd[s]->read_iosb.iosb_status = 0; L     DTRACE("  --",0,"rcvbuf=%08X, size=%d",sd[s]->rcvbuf,sd[s]->rcvbufsize);)     if (sd[s]->protocol == IPPROTO_UDP) {< #ifdef UDP_POLL> 	FD_SET(s,&sys_udpfds);s- 	vaxc$errno = netlib1_check_udp_receive(s,0);_ #elsea 	rcv = &sd[s]->rcvfrom;u& 	vaxc$errno = udp_receive(&sd[s]->ctx,% 		sd[s]->rcvbuf,		/* receive buffer*/ - 		sd[s]->rcvbufsize,	/* receive buffer size*/g8 		&sd[s]->read_iosb.iosb_byte_count	/* received bytes */ # if 14 		,&rcv->sin_addr.s_addr,	/* receive from address */* 		&rcv->sin_port,		/* receive from port */
 		timeout, 		&sd[s]->read_iosb,< 		netlib1_read_ast, s);	/* AST completion routine and arg */ # else4 		,&rcv->sin_addr.s_addr,	/* receive from address */* 		&rcv->sin_port,		/* receive from port */
 		timeout,	 		0,0,0);d # endife #endif	/* UDP_POLL */e     } 
     else {& 	vaxc$errno = tcp_receive(&sd[s]->ctx,3 		&sd[s]->read_dsc,	/* receive buffer descriptor */  		&sd[s]->read_iosb,; 		netlib1_read_ast, s,	/* AST completion routine and arg */d 		timeout);      }uV     DTRACE("  --",0,"status=%08X, iosb=%08X",vaxc$errno,sd[s]->read_iosb.iosb_status);!     if (vaxc$errno == SS$_NORMAL)a 	return(0);c
     else {9 	errno = netlib1_get_errno(sd[s]->read_iosb.iosb_status);e 	FD_SET(s,&sys_exceptfds); 	sys$setef(sd[s]->ef); /*		Abort??? */  	return(-1);     }t }h eP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int isNetlibSocket(int s)  *  * Description:.K  *	Checks if the socket is a NETLIB socket. If so return 1 if not return 0.   *   * s - a valid socket descriptor  *  * Returns:s2  *  returns 1 if s is a NETLIB socket otherwise 0.C  *  Caution: Never use TRACE routines here, as this routine is usedo#  *  by the trace routines themself!n  *  */a int isNetlibSocket(s)* int	s; {e     /*      * check for valid socket.      */ %     return( (sd[s] != NULL) ? 1 : 0);  }  yP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int netlib1_get_fd(fptr)-  *  * Description:>)  *	return the socket from a file pointer.   *  * s - a file pointert  *  * Returns: 8  *  returns the socket. if no socket is found return -1.C  *  Caution: Never use TRACE routines here, as this routine is useda#  *  by the trace routines themself!l  *  */+ int netlib1_get_fd(fptr) FILE	*fptr;+ {+ int i;      for (i=0;i<FD_SETSIZE;i++) {. 	if (sd[i] != NULL  &&  sd[i]->fptr == fptr) { 	    return(i);  	}     }      return(-1);f }  cP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * FILE *netlib1_fdopen(s)  *  * Description:0   *      return the file pointer.  *   * s - a valid socket descriptor  *  * Returns: C  *  returns the file pointer for the socket. if the socket in not aL  *  netlib socket, return NULL.)  *B  * Note that creating more than one file pointer for one socket isF  * not supported! fdopen always returns the same pointer. This pointer?  * is never used for stream I/O, it only identifies the socket.b  */u FILE *netlib1_fdopen(s)  int s; { (     STRACE("netlib1_fdopen",0,s,"",0,0);     if (sd[s] == NULL) { 	errno = EBADF;n 	return(NULL);     };@     DTRACE("netlib1_fdopen",0,"return fptr=%08X",sd[s]->fptr,0);     return(sd[s]->fptr); }x  * #if 0	/* This routine is in SI_SOCKET.C */P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#  * int netlib1_writev(s,iov,iovcnt)E  *  * Description:N   *      return the file pointer.  *   * s - a valid socket descriptor  * iov - IO vector(  * iovcnt - number of elements in vector  *  * Returns:l1  *  returns the number of bytes actually written.o  *B  * Note that creating more than one file pointer for one socket isF  * not supported! fdopen always returns the same pointer. This pointer?  * is never used for stream I/O, it only identifies the socket.C  */N  int netlib1_writev(s,iov,iovcnt) int s; struct iovec *iov; int iovcnt;O {E int i; int k; int cnt = 0;  /     STRACE("writev",0,s,"iovcnt: %d",iovcnt,0);N 	for(i=0;i<iovcnt;i++) {R /* fprintf(stderr,"  %d: len = %d\n{%s}\n",i,iov[i].iov_len,iov[i].iov_base); /**/ 		k = (sd[s] != NULL ? *0 			send(s, iov[i].iov_base, iov[i].iov_len, 0) :/ 			write(s, iov[i].iov_base, iov[i].iov_len) );a 		if (k == -1) return(-1); 		cnt += k;E 	}
 	return(cnt);	 }n #endif