 /*<  * This software is COPYRIGHT  1991-1997, Stephane Germain.  * ALL RIGHTS RESERVED. O  * Permission is granted for not-for-profit redistribution, provided all source P  * and object code remain unchanged from the original distribution, and that all#  * copyright notices remain intact.   *L  * This software is provided "AS IS". The author makes no representations orP  * warranties with respect to the software and specifically disclaim any impliedG  * warranties of merchantability or fitness for any particular purpose.   *O  ****************************************************************************** $  * ETHERNET <PROBE> TRAFFIC ANALYZER  *  * This is SYS_PROBE:REPLAY.C   * Creator S.Germain p.eng  * Using   VMS 5.4+ (VAXC)H  * History v1.0  28 Jul 91 - Incorporation of basic formatter (FORMAT.C)7  *                           and fundamental structure. >  *	   v1.1     Aug 91 - Unoptimized functional release subset.K  *	   v2.2     Dec 94 - Removed uncompleted internal loading & display code G  *                           portion. Added data formatting capabitity. O  *                           Added manufacturer/logical prefix search (static). N  *         v2.3     May 97 - Added Alpha platform sample (V2.2B+) recognition.N  *                           Added dynamic vendor tables. Static defs removed.*  *			     Added sample filename expansion.5  *			     New default file names are NETWORK (.PRB*). 5  *			     Improved IEEE 802.2 header info extraction.   *
  * CONCEPT  *D  * This image is responsible for all aspects of PROBE post-recordingD  * processing. A network traffic file is provided to the program for  * interpretation and listing.  *  * NOTES  *9  * 1. Conditions are signaled according to VMS standards. .  * Compilation and linking is done as follows:  *  *    $ CC/NODEBUG REPLAY "  *    $ MESSAGE/OBJECT=MSG2 REPLAY$  *    $ SET COMMAND/OBJECT=TBL TABLE9  *    $ LINK/NODEBUG/NOTRACEBACK REPLAY,MSG2,TBL,CRTL/OPT   *E  * 2. Invocation and run-time information parsing is performed by CLI D  * routines. The command definition in file PROBE.CLD is included in(  * the process command table as follows:  *  *    $ SET COMMAND PROBE   *J  * 3. General user help information is contained in the PROBE.HLP library.  *D  * 4. Where convenient, some VMS-specific calls and library routinesK  * (particularly CLI$) are used. As this affects eventual code portability, J  * these extensions are located in low-level portions of the program call-J  * structure as much as possible and treated as black boxes which could be.  * replaced by functionally equivalent others.  *  * CONSTANTS */    # module  REPLAY		"V2.3"? # define  VERSION		0x0203	/* highest known PROBE data format */   Q # define  eth$envelop		18	/* dst(6)+src(6)+ptcl:length(2)+fcs(4); LLC is extra */ * # define  eth$min_data		46	/* IEEE spec */, # define  eth$max_data		1500	/* IEEE spec */3 # define  eth$min_frame		eth$min_data + eth$envelop 3 # define  eth$max_frame		eth$max_data + eth$envelop    # include <ctype.h>  # include <stdio.h>  # include <stdlib.h>; # include <climsgdef.h>			/* CLI$xxx - DCL parsing codes */ 7 # include <descrip.h>			/* DSC$xxx - VMS descriptors */ 6 # include <ssdef.h>			/*  SS$xxx - VMS status codes */D # include <sys_probe:v23$logdef.h>	/* Probe 2.3-x log file layout */B # include <sys_probe:v23$macros.h>	/* Probe 2.3-x macros etc... */  O /****************************************************************************** O  * GLOBALS                                                                    * P  ******************************************************************************/  5  FILE	  *analysis;			/* OUT: analysis file control */ 0  FILE	  *sample;			/* IN: sample file control */.  FILE	  *table;			/* IN: table file control */.  char	  a_file[81];			/* analysis file name */-  char	  s_file[133];			/* sample file name */ +  char	  t_file[81];			/* table file name */   (  char	  adapter[prb$log_adapter_size+1];&  char	  log_node[prb$log_node_size+1];    C_BLOCK  *master_cycle;  N_BLOCK  *node_header;   P_BLOCK  *protocol_header;   V_BLOCK  *vendor_header;   >  unsigned long  frame_count = 0;	/* number of sample frames */7  unsigned long	log_record_size;	/* sample entry size */ E  unsigned long  log_payload_size;	/* maximum recorded payload size */   3  unsigned short patch;			/* revision patch level */   union     { 5     unsigned short level;		/* revision combined id */ 
     struct        {8        unsigned char minor;		/* revision secondary id */6        unsigned char major;		/* revision primary id */        } id;     } revision;     struct      { $     unsigned analysis_specified : 1;%     unsigned analysis_redirected : 1; %     unsigned is_format_collision : 1; $     unsigned is_format_controls : 1;!     unsigned is_format_cycle : 1;       unsigned is_format_data : 1;!     unsigned is_format_frame : 1; "     unsigned is_format_header : 1;!     unsigned is_format_table : 1; (     unsigned process_external_table : 1;%     unsigned sample_was_from_vms : 1; &     unsigned sample_was_extracted : 1;     unsigned platform : 1;     unsigned : 0; :     } command;				/* overall specified & attained state */  O /****************************************************************************** O  * MAIN PROGRAM                                                               * O  *                                                                            * O  * Each routine at this level is responsible for continuing or aborting       * O  * processing directly. No transit error codes are used... return is implied  * O  * to mean success and pursuit.                                               * P  ******************************************************************************/   main() {   globalref RPL_NODISP;   parse_command_line(); 
 open_files();  read_sample_header();  read_table_definitions();  if (command.analysis_specified)     {    format_environment();    format_sample_data();    } else /* interactive */    {    lib$stop(&RPL_NODISP);     } }   O /******************************************************************************1O  * PARSE_COMMAND_LINE                                                         *tO  *                                                                            *nO  * This routine determines the overall user requested action and values based *aO  * on the initial DCL-syntax command and possible logical name specifications.*nP  ******************************************************************************/   parse_command_line() {h"  globalref RPL_INVCID, RPL_ALLCYC;    unsigned short id_size;  unsigned char  id_string[6];*  	  long  new_value;    C_BLOCK *new_cycle;     D_CONSTANT(analyze,"PRB_ANAZ");  D_CONSTANT(sample,"PRB_PLAY");   D_CONSTANT(table,"PRB_TABL");  D_CONSTANT(a_out,"ANAZ_OUT");  D_CONSTANT(a_all,"CLSS_ALL");  D_CONSTANT(a_col,"CLSS_COL");  D_CONSTANT(a_ctl,"CLSS_CTL");  D_CONSTANT(a_cyc,"CLSS_CYC");  D_CONSTANT(a_dat,"CLSS_DAT");  D_CONSTANT(a_frm,"CLSS_FRM");  D_CONSTANT(a_hdr,"CLSS_HDR");  D_CONSTANT(a_tbl,"CLSS_TBL");  D_CONSTANT(e_cyc,"EXTR_CYC");  D_VARIABLE(spec_a,a_file);r  D_VARIABLE(spec_s,s_file);   D_VARIABLE(spec_t,t_file);n"  D_VARIABLE(identifier,id_string);   /* load sample file name */   F if (cli$get_value(&sample,&spec_s,&spec_s.dsc$w_length) == SS$_NORMAL)&    s_file[spec_s.dsc$w_length] = '\0'; else     strcpy(s_file,"NETWORK.PRB");  ' /* load table file name if specified */a  ( if (cli$present(&table) == CLI$_PRESENT)H    if (cli$get_value(&table,&spec_t,&spec_t.dsc$w_length) == SS$_NORMAL)       { )       t_file[spec_t.dsc$w_length] = '\0';t)       command.process_external_table = 1;c       }p  E /* load analysis classes (using defaults) & file name if specified */   * if (cli$present(&analyze) == CLI$_PRESENT)    {"    command.analysis_specified = 1;H    if (cli$get_value(&a_out,&spec_a,&spec_a.dsc$w_length) == SS$_NORMAL)       { )       a_file[spec_a.dsc$w_length] = '\0';E&       command.analysis_redirected = 1;       }LG    command.is_format_collision = (cli$present(&a_col) != CLI$_NEGATED);oG    command.is_format_cycle     = (cli$present(&a_cyc) != CLI$_NEGATED);cG    command.is_format_frame     = (cli$present(&a_frm) != CLI$_NEGATED);NG    command.is_format_header    = (cli$present(&a_hdr) != CLI$_NEGATED);BG    command.is_format_table     = (cli$present(&a_tbl) != CLI$_NEGATED);iI    command.is_format_controls  = (cli$present(&a_ctl) == CLI$_PRESENT) ||oU 				((cli$present(&a_all) == CLI$_PRESENT) && (cli$present(&a_ctl) != CLI$_NEGATED));cI    command.is_format_data      = (cli$present(&a_dat) == CLI$_PRESENT) ||lU 				((cli$present(&a_all) == CLI$_PRESENT) && (cli$present(&a_dat) != CLI$_NEGATED));     }  H /* prepare master cycle (sample) block & load cycle list if specified */  [ master_cycle = calloc(1,sizeof(C_BLOCK));		/* allocate the cycle/sample linked list head */ \ master_cycle->next		  = master_cycle;	/* initially unique member of forward circular list */a master_cycle->previous		  = master_cycle;	/* initially unique member of backward circular list */nR master_cycle->reference_count	  = 0;			/* default - empty list means all cycles */T master_cycle->block.sample.max_id = 0;			/* default - permits id=1 list insertion */  ( if (cli$present(&e_cyc) == CLI$_PRESENT)    {F    while ((cli$get_value(&e_cyc,&identifier,&id_size)) != CLI$_ABSENT)       {u        id_string[id_size] = '\0';"       new_value = atoi(id_string);Y       if ((new_value <= 0) || (new_value > 32767))	/* reject out of bounds cycle entry */G& 	 lib$signal(&RPL_INVCID,1,new_value);.       else						/* accept valid cycle entry */
          {b 	 new_cycle = calloc(1,sizeof(C_BLOCK));		/* prepare new entry block and list-search parameters */) 	 new_cycle->block.object.id = new_value; _          if (valid(c_connect(new_cycle)))		/* attempt insertion of new cycle into cycle list */a( 	    master_cycle->reference_count += 1; 	 else 	    cfree(new_cycle);
          }       }t_    if (master_cycle->reference_count == 0)		/* no entry exists on list... dynamic processing */e       lib$signal(&RPL_ALLCYC);    } }K  O /******************************************************************************gO  * OPEN_FILES                                                                 *rO  *                                                                            *cO  * This routine opens all input files & (as required) the analysis output     *uO  * file. It applies default file types.                                       * P  ******************************************************************************/   open_files() {e2  globalref RPL_NOSAMPLE, RPL_NOACHAN, RPL_EXTABLE;  D /* sample file must be accessible ; expand full VMS specification */  ; if ((sample = fopen(s_file,"r","dna=NETWORK.PRB")) == NULL)1$    lib$stop(&RPL_NOSAMPLE,1,s_file);   fgetname(sample,s_file);  0 /* analysis file must be created if specified */   if (command.analysis_specified)n`    if ((analysis = ((command.analysis_redirected) ? fopen(a_file,"w","dna=NETWORK.PRB_ANALYSIS")V                                                   : fopen("SYS$OUTPUT","w"))) == NULL)       lib$stop(&RPL_NOACHAN);   + /* attempt to access external table file */s  # if (command.process_external_table)*G    if ((table = fopen(t_file,"r","dna=SYS_PROBE:NETWORK.TBL")) == NULL) C       lib$signal(&RPL_EXTABLE), command.process_external_table = 0;  }   O /****************************************************************************** O  * READ_SAMPLE_HEADER                                                         * O  *                                                                            *dO  * Get sample master characteristics and additional imbedded node & protocol  * O  * entry definitions. Give priority to any externally loaded definitions.     **P  ******************************************************************************/   read_sample_header() { H  globalref RPL_NEWLVL, RPL_BADREC, RPL_DATALESS, RPL_EMPTY, RPL_BADTYPE,' 	   RPL_BIGCYC, RPL_CYCOOB, RPL_INCREC;(    int i;l    C_BLOCK *cycle;  P_BLOCK *new_protocol;N  N_BLOCK *new_node;   V_BLOCK *new_vendor;*  7 /* extract and validate type and version information */*  5 if ((get_data(&log.element[0],8)) && (log.type == 1))     {%    patch = log.prb$intro.patch_level; ]    if ((revision.level = ((log.prb$intro.major_id << 8) | log.prb$intro.minor_id)) > VERSION)lH       lib$stop(&RPL_NEWLVL,3,revision.id.major,revision.id.minor,patch);    } else    lib$stop(&RPL_BADREC);i  L /* versions prior to V2.2 have different primary layout than later versions.S    V2.3 flag interpretation is a compatible (but not identical) superset of V2.2 */g   if (revision.level < 0x0202)    {N    command.sample_was_from_vms  = log.prb$intro.specific.v20.flags.from_a_vax;P    command.sample_was_extracted = log.prb$intro.specific.v20.flags.is_extracted;    command.platform = 0;6    log_record_size  = log.prb$intro.specific.v20.size;    if (command.is_format_data)<       lib$signal(&RPL_DATALESS), command.is_format_data = 0;    } else6    if (log.prb$intro.specific.v23.data.flags.map == 0)       {;W       command.sample_was_from_vms  = log.prb$intro.specific.v23.data.flags.is_vms_type;lX       command.sample_was_extracted = log.prb$intro.specific.v23.data.flags.is_extracted;H       command.platform = log.prb$intro.specific.v23.data.flags.platform;9       log_record_size  = log.prb$intro.specific.v23.size;sj       if ((command.is_format_data) && ((log_payload_size = log.prb$intro.specific.v23.data.payload) == 0))5 	 lib$signal(&RPL_EMPTY), command.is_format_data = 0;g       }&    elsee&       command.sample_was_from_vms = 0;! if (!command.sample_was_from_vms)$    lib$stop(&RPL_BADTYPE);  ) /* get remainder of introduction block */   0 if (get_data(&log.element[8],log_record_size-8))    {d    master_cycle->block.sample.max_id	       = ((log.prb$intro.cycle > 0) ? log.prb$intro.cycle : 1);J    master_cycle->block.sample.creation_time[0] = log.prb$intro.abstime[0];J    master_cycle->block.sample.creation_time[1] = log.prb$intro.abstime[1];E    master_cycle->block.sample.activity	       = log.prb$intro.active;nE    master_cycle->block.sample.standby	       = log.prb$intro.standby;s  L    /* build or adjust cycle block list to contain only applicable entries */  I    if (master_cycle->reference_count == 0)			/* all cycles to be built */r=       for (i = master_cycle->block.sample.max_id; i > 0; --i)s 	 {a= 	 cycle = calloc(1,sizeof(C_BLOCK));			/* create new entry */$5 	 cycle->block.object.id		= i;			/* identify cycle */(J 	 cycle->next			= master_cycle->next;	/* place in front of forward list */B 	 master_cycle->next		= cycle;		/* adjust front of forward list */G 	 cycle->previous		= master_cycle;		/* place behind of backward list */LE 	 cycle->next->previous		= cycle;		/* adjust rear of backward list */y@ 	 master_cycle->reference_count += 1;			/* update cycle count */ 	 }/    elsee       {eR       for (cycle = master_cycle->next; cycle != master_cycle; cycle = cycle->next)A 	 if (cycle->block.object.id > master_cycle->block.sample.max_id)  	    {6 	    lib$signal(&RPL_BIGCYC,1,cycle->block.object.id);X 	    cycle->previous->next	   = cycle->next;	/* adjust forward list to skip bad entry */E 	    cycle			   = cycle->previous;	/* step back to last good entry */s@ 	    cfree(cycle->next->previous);			/* destroy useless entry */X 	    cycle->next->previous	   = cycle;		/* adjust backward list to skip removed entry */C 	    master_cycle->reference_count -= 1;			/* update cycle count */f 	    }-       if (master_cycle->reference_count == 0)t 	 lib$stop(&RPL_CYCOOB);       }i      /* load node and adapter */  ,    for (i = 0; i < log.prb$intro.nsize; ++i)*       log_node[i] = log.prb$intro.node[i];(    log_node[log.prb$intro.nsize] = '\0';,    for (i = 0; i < log.prb$intro.asize; ++i),       adapter[i] = log.prb$intro.adapter[i];'    adapter[log.prb$intro.asize] = '\0';f    } else    lib$stop(&RPL_INCREC);s  1 /* prepare master node, protocol, vendor lists */n  S node_header = calloc(1,sizeof(N_BLOCK));			/* allocate the node linked list head */rP node_header->next		 = node_header;			/* initially unique circular list member */@ node_header->reference_count	 = 0;				/* default - empty list */  [ protocol_header = calloc(1,sizeof(P_BLOCK));			/* allocate the protocol linked list head */ W protocol_header->next		 = protocol_header;		/* initially unique circular list member */ C protocol_header->reference_count = 0;				/* default - empty list */t  W vendor_header = calloc(1,sizeof(V_BLOCK));			/* allocate the vendor linked list head */ S vendor_header->next		 = vendor_header;		/* initially unique circular list member */ B vendor_header->reference_count	 = 0;				/* default - empty list */  ^ /* skip sample filler & load non-conflicting imbedded protocol, node and vendor definitions */  C while ((get_data(&log.element,log_record_size)) && (log.type == 3))i!    switch (log.prb$table.subtype)        {i       case 0:  	 break;
       case 1: + 	 new_protocol = calloc(1,sizeof(P_BLOCK));l3 	 new_protocol->object.id       = log.prb$table.id;"I 	 new_protocol->object.value[0] = log.prb$table.object.protocol.value[0]; I 	 new_protocol->object.value[1] = log.prb$table.object.protocol.value[1]; * 	 for (i = 0; i < log.prb$table.size; ++i): 	    new_protocol->object.name[i] = log.prb$table.name[i];7 	 new_protocol->object.name[log.prb$table.size] = '\0'; $ 	 if (valid(p_insert(new_protocol)))+ 	    protocol_header->reference_count += 1;* 	 else 	    cfree(new_protocol);* 	 break;
       case 2:*' 	 new_node = calloc(1,sizeof(N_BLOCK));  	 for (i = 0; i < 6; ++i) H 	    new_node->object.address[i] = log.prb$table.object.node.address[i];* 	 for (i = 0; i < log.prb$table.size; ++i)6 	    new_node->object.name[i] = log.prb$table.name[i];3 	 new_node->object.name[log.prb$table.size] = '\0';a  	 if (valid(n_insert(new_node)))' 	    node_header->reference_count += 1;* 	 else 	    cfree(new_node);* 	 break;
       case 3:m) 	 new_vendor = calloc(1,sizeof(V_BLOCK));L 	 for (i = 0; i < 3; ++i)EJ 	    new_vendor->object.prefix[i] = log.prb$table.object.vendor.prefix[i];* 	 for (i = 0; i < log.prb$table.size; ++i)8 	    new_vendor->object.name[i] = log.prb$table.name[i];5 	 new_vendor->object.name[log.prb$table.size] = '\0';g" 	 if (valid(v_insert(new_vendor)))) 	    vendor_header->reference_count += 1;o 	 else 	    cfree(new_vendor);l 	 break;       default: 	 break;       }r }n  O /******************************************************************************.O  * READ_TABLE_DEFINITIONS                                                     *VO  *                                                                            *oO  * As required, this routine reads the table entry definitions and dispatches *<O  * execution until the end-of-file is reached.                                *sP  ******************************************************************************/   read_table_definitions() {rD  globalref PROBE_TABLE;		/* external Command Table module address */  globalref RPL_TBLFLT;  extern catch();  
  long status;c  unsigned long count = 0;   unsigned char line[134];i  D_VARIABLE(definition,line);p  . /* as required, process the file to its end */  # if (command.process_external_table)a    {(    while (fgets(line,133,table) != NULL)       {g       count += 1;.1       definition.dsc$w_length = strlen(line) - 1;m;       lib$establish(&catch);				/* prevent CLI signaling */_H       if (valid(status = cli$dcl_parse(&definition,&PROBE_TABLE,0,0,0))) 	 {d7 	 lib$revert();					/* resume normal signal behavior */a1          cli$dispatch();				/* execute command */n 	 }f
       else 	 { 7 	 lib$revert();					/* resume normal signal behavior */; 	 if (status != CLI$_NOCOMD)% 	    lib$signal(&RPL_TBLFLT,1,count);* 	 }r       }oR    command.process_external_table = 0;			/* indicate end of external processing */    } }_  O /******************************************************************************eO  * FORMAT_ENVIRONMENT                                                         *;O  *                                                                            *mO  * Output the sample characteristics and node & protocol definitions          *lO  * according to defaults and user specified request.                          * P  ******************************************************************************/   format_environment() {   globalref RPL_ANAPROG;   extern char * display_time();    int i;_  unsigned long entity;  N_BLOCK *node;1  P_BLOCK *protocol;/  V_BLOCK *vendor;*    if (command.analysis_redirected)    lib$signal(&RPL_ANAPROG); if (command.is_format_header)	    {6    fprintf(analysis,"PROBE/PLAYBACK/ANALYZE 2.3\n\n");I    fprintf(analysis,"Input file: %s\nRecording:  %s   (%d.%d-%d)",s_file,lm  	   ((command.sample_was_extracted) ? "extracted" : "original "),revision.id.major,revision.id.minor,patch);yE    if ((command.is_format_data) && (log_payload_size < eth$max_data))/S       fprintf(analysis," with payload data truncated @ %d bytes",log_payload_size);yW    fprintf(analysis,"\n\nMade:       %s\nOn Node:    %-8s\t(%s)\nAdapter:    %-8s\n\n", D 	   display_time(master_cycle->block.sample.creation_time),log_node,9 	   ((command.platform) ? "an Alpha" : "a VAX"),adapter); 0    if (master_cycle->block.sample.activity != 0)T       fprintf(analysis,"Cycles:     %-5d\t(%d sec Standby) + (%d sec Activity)\n\n",q 	      master_cycle->block.sample.max_id,master_cycle->block.sample.standby,master_cycle->block.sample.activity);     else_h       fprintf(analysis,"Cycles:     %-5d\t(manually terminated)\n\n",master_cycle->block.sample.max_id);    } if (command.is_format_table)    {w    for (entity = 0, protocol = protocol_header->next; protocol != protocol_header; ++entity, protocol = protocol->next)eV       fprintf(analysis,"Protocol %-12s\t(%02X-%02X) ID: %-6d%s",protocol->object.name,p 	      protocol->object.value[0],protocol->object.value[1],protocol->object.id,(odd(entity) ? "\n" : "\t\t\t"));_    for (vendor = vendor_header->next; vendor != vendor_header; ++entity, vendor = vendor->next)1       {_@       fprintf(analysis,"Vendor   %-12s\t(",vendor->object.name);       for (i = 0; i < 3; ++i)tL 	 fprintf(analysis,"%02X%c",vendor->object.prefix[i],((i < 2) ? '-' : ')'));?       fprintf(analysis,"%s",(odd(entity) ? "\n" : "\t\t\t\t"));L       }/S    for (node = node_header->next; node != node_header; ++entity, node = node->next)e       {i>       fprintf(analysis,"Node     %-12s\t(",node->object.name);       for (i = 0; i < 6; ++i)mK 	 fprintf(analysis,"%02X%c",node->object.address[i],((i < 5) ? '-' : ')'));v=       fprintf(analysis,"%s",(odd(entity) ? "\n" : "\t\t\t"));e       }i    if (entity != 0)r;       fprintf(analysis,"%s",(odd(entity) ? "\n\n" : "\n"));d    } }e  O /******************************************************************************eO  * FORMAT_SAMPLE_DATA                                                         *(O  *                                                                            * O  * Output the specified cycle sample data. No load occurs.                    *cP  ******************************************************************************/   format_sample_data() {u%  globalref RPL_OUTOFSEQ, RPL_BADDATA;   extern char * display_time();  
  int i, line; *  unsigned long max_index, index, sequence;%  unsigned char payload[eth$max_data];a  C_BLOCK *cycle;  N_BLOCK *source, *target;  P_BLOCK *protocol;'  struct(     {_     unsigned do_this_cycle : 1;o     unsigned p_is_matched : 1;     unsigned s_is_matched : 1;     unsigned t_is_matched : 1;     unsigned : 0;o     } state;   state.do_this_cycle = 0; cycle = master_cycle->next;c do {    switch (log.type)       {o
       case 0:  	 frame_count += 1;. 	 if (state.do_this_cycle) 	    {! 	    cycle->reference_count += 1;e! 	    if (command.is_format_frame)r	 	       {e 	       state.s_is_matched = 0;no 	       for (source = node_header; (source->next != node_header) && !state.s_is_matched; source = source->next)  		  for (i = 5; i >= 0; --i)` 		     if (!(state.s_is_matched = (source->next->object.address[i] == log.prb$frame.source[i])))	 			break;x  	       if (!state.s_is_matched) 		  {e' 		  source = calloc(1,sizeof(N_BLOCK)); , 		  build_node(source,log.prb$frame.source); 		  }. 	       state.t_is_matched = 0;ao 	       for (target = node_header; (target->next != node_header) && !state.t_is_matched; target = target->next); 		  for (i = 5; i >= 0; --i)e 		     if (!(state.t_is_matched = (target->next->object.address[i] == log.prb$frame.destination[i])))_	 			break;I  	       if (!state.t_is_matched) 		  { ' 		  target = calloc(1,sizeof(N_BLOCK)); 1 		  build_node(target,log.prb$frame.destination);  		  } : 	       index = 0;				/* initialize payload array index */& 	       if (log.prb$frame.tag.is_ieee) 		  {dY 		  fprintf(analysis,"%sFrame %010d (IEEE)     @ %08.2f  From: %-17s  To: %-17s  Size: ",*L 			  (log.prb$frame.tag.warning ? "?" : " "),frame_count,log.prb$frame.time,. 			  source->object.name,target->object.name);? 		  if (log.prb$frame.protocol[0] == log.prb$frame.protocol[1]) ) 		     switch (log.prb$frame.protocol[0])  			{H 			case 0xAA:			/* Ethernet SNAP (IPX = AAAA 03 000000 8137 FFFF ...) */ 			   state.p_is_matched = 0; b 			   for (protocol = protocol_header; (protocol->next != protocol_header) && !state.p_is_matched; 				protocol = protocol->next)! 			      for (i = 1; i >= 0; --i) _ 				 if (!(state.p_is_matched = (protocol->next->object.value[i] == log.prb$frame.ctlpi[i+4])))r 				    break; 			   if (state.p_is_matched)i< 			      fprintf(analysis,"%4d/%-4d  Protocol: %s (SNAP)\n",\ 				      log.prb$frame.size,(log.prb$frame.size+log.prb$frame.tag.overhead < eth$min_data ?U 				      eth$min_frame : log.prb$frame.size+log.prb$frame.tag.overhead+eth$envelop),L! 				      protocol->object.name);m
 			   elseC 			      fprintf(analysis,"%4d/%-4d  Protocol: %02X-%02X (SNAP)\n",}\ 				      log.prb$frame.size,(log.prb$frame.size+log.prb$frame.tag.overhead < eth$min_data ?U 				      eth$min_frame : log.prb$frame.size+log.prb$frame.tag.overhead+eth$envelop), 9 				      log.prb$frame.ctlpi[4],log.prb$frame.ctlpi[5]);  			   break;8 			case 0xE0:			/* 802.2 LLC (IPX = E0E0 03 FFFF ...) */D 			   fprintf(analysis,"%4d/%-4d  D-S SAPs: %02X-%02X (IPX802.2)\n",Y 				   log.prb$frame.size,(log.prb$frame.size+log.prb$frame.tag.overhead < eth$min_data ?*R 				   eth$min_frame : log.prb$frame.size+log.prb$frame.tag.overhead+eth$envelop),< 				   log.prb$frame.protocol[0],log.prb$frame.protocol[1]); 			   break;0 			case 0xFF:			/* 802.3 raw (IPX = FFFF ...) */K 			   log.prb$frame.size = log.prb$frame.size + log.prb$frame.tag.overhead;f@ 			   fprintf(analysis,"%4d/%-4d  D-S SAPs: none  (IPX802.3)\n",> 				   log.prb$frame.size,(log.prb$frame.size < eth$min_data ?8 				   eth$min_frame : log.prb$frame.size+eth$envelop));: 			   for ( ; index < log.prb$frame.tag.overhead; ++index) 			      if (index < 2)(4 				 payload[index] = log.prb$frame.protocol[index];
 			      else 3 				 payload[index] = log.prb$frame.ctlpi[index-2];y 			   break; 			default:			/* 802.2 LLC */,9 			   fprintf(analysis,"%4d/%-4d  D-S SAPs: %02X-%02X\n",8Y 				   log.prb$frame.size,(log.prb$frame.size+log.prb$frame.tag.overhead < eth$min_data ?nR 				   eth$min_frame : log.prb$frame.size+log.prb$frame.tag.overhead+eth$envelop),< 				   log.prb$frame.protocol[0],log.prb$frame.protocol[1]); 			   break; 			} 		  else 					/* 802.2 LLC */_: 		     fprintf(analysis,"%4d/%-4d  D-S SAPs: %02X-%02X\n",Z 			     log.prb$frame.size,(log.prb$frame.size+log.prb$frame.tag.overhead < eth$min_data ?S 			     eth$min_frame : log.prb$frame.size+log.prb$frame.tag.overhead+eth$envelop),s= 			     log.prb$frame.protocol[0],log.prb$frame.protocol[1]);e 		  }e+ 	       else 					/* ethernet frame type */o 		  { m 		  fprintf(analysis,"%sFrame %010d (Ethernet) @ %08.2f  From: %-17s  To: %-17s  Size: %4d/%-4d  Protocol: ", L 			  (log.prb$frame.tag.warning ? "?" : " "),frame_count,log.prb$frame.time,@ 			  source->object.name,target->object.name,log.prb$frame.size,D 			  (log.prb$frame.size+log.prb$frame.tag.overhead < eth$min_data ?R 			   eth$min_frame : log.prb$frame.size+log.prb$frame.tag.overhead+eth$envelop)); 		  state.p_is_matched = 0;l` 		  for (protocol = protocol_header; (protocol->next != protocol_header) && !state.p_is_matched;# 		       protocol = protocol->next)  		     for (i = 1; i >= 0; --i)e^ 			if (!(state.p_is_matched = (protocol->next->object.value[i] == log.prb$frame.protocol[i]))) 			   break; 		  if (state.p_is_matched) 6 		     fprintf(analysis,"%s\n",protocol->object.name); 		  else[ 		     fprintf(analysis,"%02X-%02X\n",log.prb$frame.protocol[0],log.prb$frame.protocol[1]);) 		  } D 	       if ((command.is_format_data) && (log.prb$frame.tag.is_data))Q 		  if (log.prb$frame.tag.is_more)	/* store contents until end-of-data block 2 */* 		     { 		     sequence = 0;1 		     if (log.prb$frame.size < log_payload_size) " 			max_index = log.prb$frame.size; 		     else   			max_index = log_payload_size;Q 		     for (i = 0; ((i < prb$log_capacity) && (index < max_index)); ++i, ++index).* 			payload[index] = log.prb$frame.data[i]; 		     }= 		  else					/* no additional data blocks... format output */m 		     {$ 		     max_index = prb$log_capacity;* 		     if (log.prb$frame.size < max_index)" 			max_index = log.prb$frame.size;( 		     if (log_payload_size < max_index)  			max_index = log_payload_size;Q 		     for (i = 0; ((i < prb$log_capacity) && (index < max_index)); ++i, ++index)d* 			payload[index] = log.prb$frame.data[i];0 	             fprintf(analysis,"  Data 0000> "); 		     for (i = 0; i < 25; ++i)n 			if (i < max_index) J 			   fprintf(analysis,"%02X%s",payload[i],(i < max_index-1 ? "," : " ")); 			else  			   fprintf(analysis,"   ");$ 		     fprintf(analysis," ASCII> ");& 		     for (i = 0; i < max_index; ++i)3 			if ((payload[i] < 0x20) || (payload[i] >= 0x7F))  			   fprintf(analysis,"."); 			else ! 			   fputc(payload[i],analysis);o 		     fprintf(analysis,"\n"); 		     }	 	       }u 	    } 	 break;4       case 2:	/* last data block... format output */8 	 if ((command.is_format_data) && (state.do_this_cycle))- 	    if (sequence == log.prb$data.sequence-1)a	 	       {cR 	       for (i = 0; ((i < prb$entry_size-2) && (index < max_index)); ++i, ++index)- 		  payload[index] = log.prb$data.content[i];t4 	       for (line = 0; line*25 < max_index ; ++line) 		  {!. 		  fprintf(analysis,"  Data %04d> ",line*25);, 		  for (i = line*25; i < (line*25)+25; ++i) 		     if (i < max_index)cG 			fprintf(analysis,"%02X%s",payload[i],(i < max_index-1 ? "," : " "));_ 		     else  			fprintf(analysis,"   ");e! 		  fprintf(analysis," ASCII> ");iC 		  for (i = line*25; ((i < (line*25)+25) && (i < max_index)); ++i) 7 		     if ((payload[i] < 0x20) || (payload[i] >= 0x7F))  			fprintf(analysis,".");r 		     elses 			fputc(payload[i],analysis); 		  fprintf(analysis,"\n");  		  }2	 	       }1+ 	    else /* sequence of data block lost */." 	       lib$signal(&RPL_OUTOFSEQ); 	 break;
       case 4: = 	 if ((command.is_format_collision) && (state.do_this_cycle))mo 	    fprintf(analysis," CD report %d from %s - Frames Xmit: %-10d  Deferred: %-10d   C1: %-10d   C2+: %-10d\n",*d 		    log.prb$collision.sequence,display_time(log.prb$collision.abstime),log.prb$collision.fxmitted,W 		    log.prb$collision.fdeferred,log.prb$collision.single,log.prb$collision.multiple);	 	 break;
       case 5:)7 	 if (cycle->block.object.id == log.prb$start.sequence)i 	    {! 	    if (command.is_format_cycle)]m 	       fprintf(analysis,"Cycle %d started %s\n",log.prb$start.sequence,display_time(log.prb$start.abstime));d 	    state.do_this_cycle = 1;  	    } 	 else! 	    if (command.is_format_cycle)gF 	       fprintf(analysis,"Cycle %d ignored\r",log.prb$start.sequence); 	 break;S       case 6:	/* spanning data block... store contents until end-of-data block 2 */	8 	 if ((command.is_format_data) && (state.do_this_cycle))- 	    if (sequence == log.prb$data.sequence-1)i	 	       {$ 	       sequence += 1;U 	       for (i = 0; ((i < prb$entry_size-2) && (index < eth$max_data)); ++i, ++index)a- 		  payload[index] = log.prb$data.content[i];r	 	       }p+ 	    else	/* sequence of data block lost */ " 	       lib$signal(&RPL_OUTOFSEQ); 	 break;
       case 7:  	 if (state.do_this_cycle) 	    {! 	    if (command.is_format_cycle) > 	       fprintf(analysis,"Cycle %d stopped %s (frames: %d)\n",Z 		       log.prb$stop.sequence,display_time(log.prb$stop.abstime),cycle->reference_count); 	    state.do_this_cycle = 0;a 	    cycle = cycle->next;e 	    } 	 break;       default: 	 lib$signal(&RPL_BADDATA);        }.Q    } while ((cycle != master_cycle) && (get_data(&log.element,log_record_size)));  }   P /******************************************************************************/P /*************************** SECOND LEVEL ROUTINES ****************************/P /******************************************************************************/  O /****************************************************************************** O  * CATCH                                                                      *fO  *                                                                            *"O  * Intercept CLI routine signal and replace by SS$_CONTINUE so that messaging *hO  * is explicitely controlled by this program. Since DCL_PARSE also returns an *dO  * error status, use that value to determine command line validity.           * P  ******************************************************************************/   catch()% {- return(SS$_CONTINUE);r }r  O /******************************************************************************tO  * DISPLAY_TIME                                                               * O  *                                                                            *	O  * Converts an input VAX binary time into its equivalent ASCII representation.*eP  ******************************************************************************/   char * display_time(value)  unsigned long *value; {t  static char result[24];   static D_VARIABLE(time,result);  static short length;r  - if (valid(sys$asctim(&length,&time,value,0)))_    result[length] = '\0';  else    result[0] = '\0'; return(result);a }t  O /******************************************************************************rO  * UPDATE_NTABLE                                                              *tO  *                                                                            *oO  * Parses a node definition into a new node block and attempts insertion into *fO  * the sorted master node linked list.                                        *	P  ******************************************************************************/   update_ntable()  { $  globalref RPL_BADNADR, RPL_NULNNAM;  extern x_load();e    unsigned short a_size;.  unsigned short n_size; /  unsigned char  string[prb$object_name_size+1];     N_BLOCK *new_node;     D_CONSTANT(n_nam,"NODE_NAM");  D_CONSTANT(n_adr,"NODE_ADR");  D_VARIABLE(input,string);  % new_node = calloc(1,sizeof(N_BLOCK));zJ if (cli$present(&n_adr) == CLI$_PRESENT)			/* process specified address */@    if (!((cli$get_value(&n_adr,&input,&a_size) == SS$_NORMAL) &&@ 	 (valid(x_load(string, a_size, new_node->object.address, 6)))))       {	       cfree(new_node);       lib$signal(&RPL_BADNADR);a       return(GOOD);        }d( if (cli$present(&n_nam) == CLI$_PRESENT)W    if (cli$get_value(&n_nam,&input,&n_size) == SS$_NORMAL)	/* process specified name */l       {t       string[n_size] = '\0';,       strcpy(new_node->object.name, string);       };    else        lib$signal(&RPL_NULNNAM);00 if (valid(n_insert(new_node)))					/* connect */%    node_header->reference_count += 1;" else								/* release */_    cfree(new_node);;
 return(GOOD);  }p  O /******************************************************************************<O  * UPDATE_PTABLE                                                              *iO  *                                                                            *aO  * Parses a protocol definition into a new protocol block and attempts        *aO  * insertion into the sorted master protocol linked list.                     *eP  ******************************************************************************/   update_ptable()i {20  globalref RPL_OVRPID, RPL_BADPVAL, RPL_NULPNAM;  extern x_load();b    unsigned short i_size;   unsigned short n_size;m  unsigned short v_size;!/  unsigned char  string[prb$object_name_size+1];     P_BLOCK *new_protocol;l    D_CONSTANT(p_nam,"PTCL_NAM");  D_CONSTANT(p_idn,"PTCL_IDN");  D_CONSTANT(p_val,"PTCL_VAL");  D_VARIABLE(input,string);  ) new_protocol = calloc(1,sizeof(P_BLOCK));iO new_protocol->object.id = 0;					/* unspecified protocol IDs default to zero */_( if (cli$present(&p_idn) == CLI$_PRESENT)U    if (cli$get_value(&p_idn,&input,&i_size) == SS$_NORMAL)	/* process specified ID */o       {l       string[i_size] = '\0';-       new_protocol->object.id = atoi(string);c       } 
    else              lib$signal(&RPL_OVRPID);H if (cli$present(&p_val) == CLI$_PRESENT)			/* process specified value */@    if (!((cli$get_value(&p_val,&input,&v_size) == SS$_NORMAL) &&B 	 (valid(x_load(string, v_size, new_protocol->object.value, 2)))))       {.       cfree(new_protocol);       lib$signal(&RPL_BADPVAL);)       return(GOOD);m       }	( if (cli$present(&p_nam) == CLI$_PRESENT)W    if (cli$get_value(&p_nam,&input,&n_size) == SS$_NORMAL)	/* process specified name */k       {d       string[n_size] = '\0';0       strcpy(new_protocol->object.name, string);       }(    else"       lib$signal(&RPL_NULPNAM);a3 if (valid(p_insert(new_protocol)))				/* connect */ )    protocol_header->reference_count += 1;e else								/* release */t    cfree(new_protocol);(
 return(GOOD);  }i  O /******************************************************************************.O  * UPDATE_VTABLE                                                              * O  *                                                                            *$O  * Parses a vendor definition into a new vendor block and attempts insertion  * O  * into the sorted master vendor linked list.                                 * P  ******************************************************************************/   update_vtable()  { $  globalref RPL_BADVPRF, RPL_NULVNAM;  extern x_load();c    unsigned short p_size;   unsigned short n_size;y/  unsigned char  string[prb$object_name_size+1];p    V_BLOCK *new_vendor;t    D_CONSTANT(v_nam,"VEND_NAM");  D_CONSTANT(v_prf,"VEND_OUI");  D_VARIABLE(input,string);  ' new_vendor = calloc(1,sizeof(V_BLOCK));eI if (cli$present(&v_prf) == CLI$_PRESENT)			/* process specified prefix */r@    if (!((cli$get_value(&v_prf,&input,&p_size) == SS$_NORMAL) &&A 	 (valid(x_load(string, p_size, new_vendor->object.prefix, 3)))))*       {        cfree(new_vendor);       lib$signal(&RPL_BADVPRF);*       return(GOOD);        }*( if (cli$present(&v_nam) == CLI$_PRESENT)W    if (cli$get_value(&v_nam,&input,&n_size) == SS$_NORMAL)	/* process specified name */*       {*       string[n_size] = '\0';.       strcpy(new_vendor->object.name, string);       }     else*       lib$signal(&RPL_NULVNAM); 1 if (valid(v_insert(new_vendor)))				/* connect */t'    vendor_header->reference_count += 1;S else								/* release */n    cfree(new_vendor); 
 return(GOOD);h }p  O /******************************************************************************rO  * C_CONNECT                                                                  **O  *                                                                            * O  * Insert a new cycle block into the cycle linked list.                       **P  ******************************************************************************/   c_connect(new)  C_BLOCK *new; {   globalref RPL_DUPCID;    C_BLOCK *cycle;  [ /* first, scan the cycle list until the next item ID is larger or equal to the new entry */*   for (cycle = master_cycle;^      ((cycle->next != master_cycle) && (cycle->next->block.object.id < new->block.object.id));      cycle = cycle->next) {}T if (cycle->next->block.object.id == new->block.object.id)	/* reject duplicated ID */    {2    lib$signal(&RPL_DUPCID,1,new->block.object.id);    return(BAD);0    }" else								/* insert into list */    {5    new->next = cycle->next;					/* connect forward */*4    new->previous = cycle;					/* connect backward */D    new->next->previous = new;					/* link backward chain to entry */C    new->previous->next = new;					/* link forward chain to entry */t    return(GOOD);    } }n  O /****************************************************************************** O  * N_CONNECT                                                                  **O  *                                                                            *UO  * Add node entry in sorted order by name (1) and address (2).                * P  ******************************************************************************/   n_connect(new)  N_BLOCK *new; {(  N_BLOCK *node;;   /* primary sort */   for (node = node_header;^      ((node->next != node_header) && (strcmp(node->next->object.name, new->object.name) < 0));      node = node->next) {}   /* subsort as required */O   for (;`      ((node->next != node_header) && (strcmp(node->next->object.name, new->object.name) == 0) &&a       (compare(&node->next->object.address, &new->object.address, 6) < 0)); node = node->next) {}_   /* reconnect chain */v   new->next = node->next;  node->next = new;r
 return(GOOD);  }e  O /******************************************************************************tO  * N_INSERT                                                                   *nO  *                                                                            *	O  * Inspect the node linked list for an address match.                         **O  * Update found entry & resort list, or insert new block in proper order.     * P  ******************************************************************************/  
 n_insert(new)   N_BLOCK *new; { %  globalref RPL_UPDNDEF, RPL_LOOKATN; c  N_BLOCK *node;o  F for (node = node_header; node->next != node_header; node = node->next)J    if (compare(&node->next->object.address, &new->object.address, 6) == 0)       {*U       if (strlen(new->object.name) != 0)			/* update if name specified & different */L 	 {I= 	 if (strcmp(node->next->object.name, new->object.name) != 0)h 	    { 	    lib$signal(&RPL_UPDNDEF,8,ue 		       new->object.address[0],new->object.address[1],new->object.address[2],new->object.address[3], a 		       new->object.address[4],new->object.address[5],node->next->object.name,new->object.name);V7 	    strcpy(node->next->object.name, new->object.name);P` 	    new->next = node->next;				/* use new as a temporary holder of the updated block pointer */M 	    node->next = node->next->next;			/* break & reconnect shortened chain */eE 	    n_connect(new->next);				/* reinsert updated block */           s9 	    }                                                   c 	 } '       else							/* node status only */P 	 lib$signal(&RPL_LOOKATN,8,` 		    node->next->object.address[0],node->next->object.address[1],node->next->object.address[2],` 		    node->next->object.address[3],node->next->object.address[4],node->next->object.address[5],; 		    node->next->object.name,node->next->reference_count);)E       return(BAD);						/* caller will deallocate unused new block */S       }i n_connect(new);&
 return(GOOD);_ }e  O /******************************************************************************0O  * P_CONNECT                                                                  *iO  *                                                                            * O  * Add protocol entry in sorted order by name (1) and value (2).              *wP  ******************************************************************************/   p_connect(new)  P_BLOCK *new; {*  P_BLOCK *protocol;    /* primary sort */    for (protocol = protocol_header;j      ((protocol->next != protocol_header) && (strcmp(protocol->next->object.name, new->object.name) < 0));"      protocol = protocol->next) {}   /* subsort as required */h   for (;l      ((protocol->next != protocol_header) && (strcmp(protocol->next->object.name, new->object.name) == 0) &&i       (compare(&protocol->next->object.value, &new->object.value, 2) < 0)); protocol = protocol->next) {}o   /* reconnect chain */    new->next = protocol->next;e protocol->next = new;i
 return(GOOD);a }s  O /******************************************************************************_O  * P_INSERT                                                                   *OO  *                                                                            *rO  * Inspect the protocol linked list for a protocol match.                     *aO  * Update found entry & resort list, or insert new block in proper order.     *eP  ******************************************************************************/  
 p_insert(new)=  P_BLOCK *new; {i$  globalref RPL_UPDPDEF, RPL_LOOKATP;  P_BLOCK *protocol;r  ^ for (protocol = protocol_header; protocol->next != protocol_header; protocol = protocol->next)J    if (compare(&protocol->next->object.value, &new->object.value, 2) == 0)       {eC       if ((new->object.id != 0) || (strlen(new->object.name) != 0))  	 {SQ 	 if (((new->object.id != 0) && (protocol->next->object.id != new->object.id)) ||*h 	     ((strlen(new->object.name) != 0) && (strcmp(protocol->next->object.name, new->object.name) != 0))) 	    lib$signal(&RPL_UPDPDEF,6, I 		       protocol->next->object.value[0],protocol->next->object.value[1], ` 		       protocol->next->object.name,protocol->next->object.id,new->object.name,new->object.id); 	 if (new->object.id != 0)0 	    protocol->next->object.id = new->object.id;f 	 if ((strlen(new->object.name) != 0) && (strcmp(protocol->next->object.name, new->object.name) != 0))( 	    {							/* name change... resort */; 	    strcpy(protocol->next->object.name, new->object.name);ed 	    new->next = protocol->next;				/* use new as a temporary holder of the updated block pointer */T 	    protocol->next = protocol->next->next;		/* break & reconnect shortened chain */E 	    p_connect(new->next);				/* reinsert updated block */           - 	    } 	 }.+       else							/* protocol status only */i 	 lib$signal(&RPL_LOOKATP,5,F 		    protocol->next->object.value[0],protocol->next->object.value[1],] 		    protocol->next->object.name,protocol->next->object.id,protocol->next->reference_count);nE       return(BAD);						/* caller will deallocate new unused block */y       }r p_connect(new);}
 return(GOOD);* }*  O /****************************************************************************** O  * V_CONNECT                                                                  * O  *                                                                            *nO  * Add vendor entry in sorted order by name (1) and prefix (2).               **P  ******************************************************************************/   v_connect(new)  V_BLOCK *new; {e  V_BLOCK *vendor;r   /* primary sort */   for (vendor = vendor_header;d      ((vendor->next != vendor_header) && (strcmp(vendor->next->object.name, new->object.name) < 0));      vendor = vendor->next) {}   /* subsort as required */=   for (;f      ((vendor->next != vendor_header) && (strcmp(vendor->next->object.name, new->object.name) == 0) &&e       (compare(&vendor->next->object.prefix, &new->object.prefix, 3) < 0)); vendor = vendor->next) {}    /* reconnect chain */=   new->next = vendor->next;  vendor->next = new;*
 return(GOOD);* }*  O /****************************************************************************** O  * V_INSERT                                                                   * O  *                                                                            *eO  * Inspect the vendor linked list for a prefix match.                         *eO  * Update found entry & resort list, or insert new block in proper order.     **P  ******************************************************************************/  
 v_insert(new)   V_BLOCK *new; {B%  globalref RPL_UPDVDEF, RPL_LOOKATV; ;  V_BLOCK *vendor;_  R for (vendor = vendor_header; vendor->next != vendor_header; vendor = vendor->next)J    if (compare(&vendor->next->object.prefix, &new->object.prefix, 3) == 0)       {aU       if (strlen(new->object.name) != 0)			/* update if name specified & different */a 	 {=? 	 if (strcmp(vendor->next->object.name, new->object.name) != 0)e 	    { 	    lib$signal(&RPL_UPDVDEF,5,>K 		       new->object.prefix[0],new->object.prefix[1],new->object.prefix[2],e5 		       vendor->next->object.name,new->object.name);t9 	    strcpy(vendor->next->object.name, new->object.name);nb 	    new->next = vendor->next;				/* use new as a temporary holder of the updated block pointer */Q 	    vendor->next = vendor->next->next;			/* break & reconnect shortened chain */eE 	    v_connect(new->next);				/* reinsert updated block */           s9 	    }                                                   c 	 } )       else							/* vendor status only */  	 lib$signal(&RPL_LOOKATV,5,c 		    vendor->next->object.prefix[0],vendor->next->object.prefix[1],vendor->next->object.prefix[2], ? 		    vendor->next->object.name,vendor->next->reference_count);eE       return(BAD);						/* caller will deallocate unused new block */e       }o v_connect(new);u
 return(GOOD);* }l  O /******************************************************************************_O  * COMPARE                                                                    **O  *                                                                            * O  * Compare two arbitrary arrays of a given size until divergence.             * O  * Similar to STRNCMP but is not affected by null end-of-string values.       * P  ******************************************************************************/   compare(first,second,size)  unsigned char *first;  unsigned char *second;y  unsigned long size; {   unsigned long i;   long result = 0;x  K for (i = 0; ((i < size) && ((result = first[i] - second[i]) == 0)); ++i) {}  return(result);o }   O /****************************************************************************** O  * X_LOAD                                                                     *0O  *                                                                            * O  * Converts an input character string into its equivalent network hexadecimal *>O  * form. This is used during protocol value, node address and vendor prefix   **O  * processing.                                                                * P  ******************************************************************************/   x_load(input,size,output,max)   unsigned char  *input;s  unsigned short size;d  unsigned char  *output;  unsigned short max; {   long i, offset, nibble;  unsigned char x;t  ) if (max == 0)							/* sanity check... */*    return(GOOD);5 for (i = 0; i < max; ++i)					/* initialise output */     output[i] = 0;BJ for (offset = 0; ((offset < size) && (input[offset] == '0')); ++offset) {}D if (offset == size)						/* string has null value... no more work */    return(GOOD);R if ((nibble = max * 2) < (size-offset))				/* check for sufficient output space */    return(BAD); r for (i = (size-1), --nibble; i >= offset; --i, --nibble)	/* find all characters corresponding hexadecimal value */    {.    if ((input[i] >= '0') && (input[i] <= '9'))       x = input[i] - '0';s    elset1       if ((input[i] >= 'A') && (input[i] <= 'F'))  	 x = input[i] - 'A' + 10;
       else- 	 if ((input[i] >= 'a') && (input[i] <= 'f'))x 	    x = input[i] - 'a' + 10;p0 	 else							/* not a valid hexadecimal digit */ 	    return(BAD);,s    output[nibble/2] = output[nibble/2] | (odd(nibble) ? x : (x<<4));	/* insert in reverse byte order into output */j    }
 return(GOOD);t }p  O /******************************************************************************.O  * BUILD_NODE                                                                 *nO  *                                                                            *cO  * Builds a node name from the provided address if its prefix is from a known *hO  * manufacturer or the logical DECnet Phase IV. Otherwise, construct the hex  * O  * representation of the address. Insert new node into the node list.         *&P  ******************************************************************************/   build_node(new,address)>  N_BLOCK	*new;  unsigned char	*address; {l  union     {c     unsigned short address;;
     struct        {        unsigned number : 10;        unsigned area : 6;}        } logical;*
     } decnet;*    V_BLOCK  *vendor;  unsigned int i;  unsigned found;   for (i = 0; i < 6; ++i) '    new->object.address[i] = address[i]; $ if (odd(address[0]))	/* multicast */    sprintf(new->object.name,"%02X-%02X-%02X-%02X-%02X-%02X",address[0],address[1],address[2],address[3],address[4],address[5]);) elsed    if ((address[0] == 0xAA) && (address[1] == 0x00) && (address[2] == 0x04) && (address[3] == 0x00))       {)8       decnet.address = ((address[5] << 8) | address[4]);Z       sprintf(new->object.name,"DECnet(%d.%d)",decnet.logical.area,decnet.logical.number);       }o    elsee       {j       found = 0;d       for (vendor = vendor_header; (vendor->next != vendor_header) && !found; vendor = vendor->next) 	 for (i = 0; i < 3; ++i)nj 	    if (!(found = (address[2-i] == vendor->next->object.prefix[2-i])))	/* test most variant byte first */ 	       break;       if (found)h 	 sprintf(new->object.name,"%-.8s:%02X-%02X-%02X",vendor->object.name,address[3],address[4],address[5]);
       else; 	 sprintf(new->object.name,"%02X-%02X-%02X-%02X-%02X-%02X",*M 	         address[0],address[1],address[2],address[3],address[4],address[5]);        }  n_connect(new); 
 return(GOOD);  } 