" #pragma module pppd$terminal "X-5" /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *  N  *****************************************************************************      
 	FACILITY:    		ASNDRIVER    
 	ABSTRACT:     >   		This module contains a the terminal class driver emulation 	routines.  They are:   ( 		class$getnext - Class get next routine' 		class$putnxt - Class put next routine * 		class$setupucb - Class setup UCB routine: 		class$data_set_trans - Class data set transition routine- 		class$read_error - Class read error routine - 		class$disconnect - Class disconnect routine ! 		class$fork - Class fork routine , 		class$powerfail - Class power fail routine   	AUTHOR:   ! 		Forrest A. Kenney	01-March-1996     	REVISION HISTORY:   , 	X-5	FAK004		Forrest A. Kenney	04-March-1997< 		There are three places in the class driver emulation layer; 		that make an attempt to see if the UCB we read is the ASN > 		UCB.  They are doing the check incorrectly they are checking? 		against 0.  What they should check against is if the logical  @ 		UCB pointer in the physical UCB points to itself.  As part of A 		changing the test I am adding a bugcheck TTDRVR1 if the logical A 		UCB pointer points to the physical.  The idea here is to crash  > 		as soon as we detect a problem instead of hiding it.  In the8 		future we may want to just silenty ignore these error.  / 	X-4	FAK003		Forrest A. Kenney	04-November-1996 ? 		We are now going to get a write buffer when we start a write  < 		and free it when a write is completed.  This allows us to ; 		clear the write flag when we abort a write or when it is  9 		done.  We loose a little performance in the worse case  = 		allocating and deallocating pool but we simplify the logic  
 		for writes.   . 	X-3	FAK002		Forrest A. Kenney	03-October-1996< 		Do not clear the writing state when the write done fork is< 		queued.  It will be cleared when the write completion fork 		runs.   -   	X-2	FAK001		Forrest A. Kenney	18-July-1996 $ 		Remove MRU check in class$putnext.   */      6 /* Define system data structure types and constants */  7 #include	<acbdef.h>	/* AST control block definitions	*/ : #include	<ccbdef.h>	/* Channel Control Block definitons	*/= #include	<crbdef.h>	/* Controller Request Block definitons	*/ 6 #include	<descrip.h>	/* VMS descriptor definitions		*/0 #include	<devdef.h>	/* Device attribute bits		*/7 #include	<ddbdef.h>	/* Device data block definitions	*/ ; #include	<ddtdef.h>	/* Driver Dispatch table definitions	*/ 9 #include	<dyndef.h>	/* Data structure type definitions	*/ 1 #include	<fkbdef.h>	/* Fork block definitions		*/ 1 #include	<iocdef.h>	/* I/O routines constants		*/ > #include	<idbdef.h>	/* Interrupt Dispatch Block Definitions	*/. #include	<ints.h>	/* interger definitions			*/8 #include	<irpdef.h>	/* I/O Request Packet definitions	*/9 #include	<orbdef.h>	/* Object rights Block definitions	*/ ; #include	<pcbdef.h>	/* Process Control Block definitions	*/ 6 #include	<sbdef.h>	/* System data block definitions	*/3 #include	<splcoddef.h>	/* Spinlock definitions			*/ / #include	<ssdef.h>	/* Status return valuse			*/ 4 #include	<ttdef.h>	/* Terminal attrubutes TT$xxx		*/5 #include	<tt2def.h>	/* Terminal attributes TT2$xx		*/ 5 #include	<tt3def.h>	/* Terminal attributes TT3$xx		*/ 3 #include	<ttydef.h>	/* More terminal defintions		*/ , #include	<ttymdmdef.h>	/* Modem states				*/@ #include	<ttysymdef.h>	/* TTY symbols private to class driver	*/. #include	<ttyucbdef.h>	/* TTY UCB offsets			*/9 #include	<ttyvecdef.h>	/* Terminal vector definitions		*/ ( #include	<ucbdef.h>	/* UCB offsets				*/, #include	<vcrpdef.h>	/* VCRP defnitions			*/  G #define		VCIBDEF	vcibdef	/* This is needed to work around an incorrect  $ 				   definition for VCIB in LIB *.    = /* Define ASN specific data structures types and constants */   1 #include	"asndef.h"		/* ASN public definitions	*/ 5 #include	"asnmiscdef.h"		/* ASN miscellanous items	*/ * #include	"asnvcibdef.h"		/* ASN VCIB 			*/> #include	"pppd$asn_hide_ptrs.h"	/* Hide long paths to items	*/: #include	"pppd$asn_linkages.h"	/* JSR register linkages	*/B #include	"pppd$asn_prototypes.h"	/* Prototypes for ASN routines	*/    4 /* Define function prototypes for system routines */  I #include	<com_routines.h> /* Prototypes for com$ and com_sdt$ routines */ I #include	<exe_routines.h> /* Prototypes for exe$ and exe_std$ routines */ I #include	<ioc_routines.h> /* Prototypes for ioc$ and ioc_std$ routines */ I #include	<sch_routines.h> /* Prototypes for sch$ and sch_std$ routines */     ) /* Define various device driver macros */   F #include	<vms_drivers.h>	/* Device driver support macros, including */3 				/* table initialization macros and prototypes*/ A #include	<vms_macros.h>	/* C definitions for common VMS MACROS */     4 /* Define the DEC C functions used by this driver */  D #include	<builtins.h>	/* OpenVMS AXP specific C builtin functions */C #include	<string.h>	/* String routines provided by "kernel CRTL" */          /* **++) **	class$getnext - Class get next routine  ** ** Functional description: **J **	This routine returns with the next characters to be output on the unit.L ** It is called whenever the terminal port driver has completed the current N ** character or burst. If data is returned by CLASS_GETNXT, a timer is set up F ** (unless explicitly disabled) and the interrupt expected bit is set. ** ** Calling convention: **2 **	unsigned char   class$getnext (TTY_UCB *phyucb) **
 ** Inputs: ** **	R5 - UCB address  ** ** Outputs:  ** **	R5 - UCB address 2 **		UCB$B_TT_OUTYPE - 	Zero - no data to be output$ **					One  - single character in R3  **					Negative - output a burst **	Burst mode only: A **		UCB$L_TT_OUTADR - Address of the first character of the burst ) **		UCB$W_TT_OUTLEN - Length of the burst  **' **	R0 - preserved All others destroyed.  ** ** Returns:  ** **	None  ** ** Environment:  **F **	Called at device IPL holding the device spinlock.  Exit at calling  **	IPL with locks still held ** **-- */. unsigned char   class$getnext(TTY_UCB *phyucb) {    extern		EXE$GL_ABSTIM;   int		length;   unsigned char	out_char;    ASNUCB		*asnucb; ASNWRT		*asnwrt;       /* **' **	Start out assuming nothing to output  ** */
 out_char = 0;  phyucb->ucb$b_tt_outype = 0;  A if ((!phyucb->PHYBASE.ucb$v_int) && (!phyucb->tty$v_st_ctrls) &&        (!phyucb->tty$v_st_lostcts)) {     do     {!       if (phyucb->tty$v_st_multi)        {           /*           ** C          **	We have a special message to send out.  This string can           ** interrupt a write.          **           */ +          if (phyucb->ucb$w_tt_multilen > 0) 
          {             /*             **J             **	Send out a single character and fall out to code to compute!             ** character timeout.              */(             phyucb->ucb$w_tt_outlen = 1;:             out_char = *((char *) phyucb->ucb$l_tt_multi);+             phyucb->ucb$w_tt_multilen -= 1; H             phyucb->ucb$l_tt_multi = (char *)phyucb->ucb$l_tt_multi + 1;(             phyucb->ucb$b_tt_outype = 1;             break;
          }
          else 
          {(              phyucb->tty$v_st_multi = 0;
          }       } &       else if (phyucb->tty$v_st_write)       {           /*           ** I          **	If here we are processing a write we can get here a couple of           ** ways:           ** .          **	1) A new write packet to get going@          **	2) A packet has been sent and we need to complete it          ** I          **	If we are completing a write we just simply fork on the write M          ** packet and it will be completed and if another write is ready it  L          ** get back in here to start again.  If it is a new packet we will M          ** simple make the whole packet a big burst and send it in one shot.           **           */ 5          asnucb = (ASNUCB *) phyucb->ucb$l_tt_logucb; 2          asnwrt =  asnucb->ucb$l_asn_write_buffer;>          if (asnwrt->asnwrt$ps_data == &asnwrt->asnwrt$t_data)
          {=             phyucb->ucb$l_tt_outadr = asnwrt->asnwrt$ps_data; <             phyucb->ucb$w_tt_outlen = asnwrt->asnwrt$l_bcnt;)             phyucb->ucb$b_tt_outype = -1; ]             asnwrt->asnwrt$ps_data = (char *) asnwrt->asnwrt$ps_data + asnwrt->asnwrt$l_bcnt;              break;
          }
          else 
          {-             asnucb->ucb$q_asn_pkts_sent += 1;   	    phyucb->tty$v_st_write = 0;>             __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, 1);/             exe_std$queue_fork((FKB *) asnwrt);  	    break; 
          }       } 
       else       {           /*           ** 4          **	If get here there is nothing left to do           **           */           break;        }     } while (1); $    if (phyucb->ucb$b_tt_outype != 0)    {       /*       **G       **	If we have any characters to output see if we need to compute  M       ** a timeout interval for the character.  Also detrmine what we return  O       ** if a burst or no character return NULL, otherwise return character to         ** be output.        **       */#       if (!phyucb->tty$v_pc_notime)        { *          if (phyucb->ucb$b_tt_outype == 1)
          {             length = 2; 
          }
          else 
          {8             length = 2 + (phyucb->ucb$w_tt_outlen / 4);	
          }?          phyucb->PHYBASE.ucb$l_duetim = length + EXE$GL_ABSTIM;*'          phyucb->PHYBASE.ucb$v_tim = 1;9       } $       phyucb->PHYBASE.ucb$v_int = 1;    } }    return out_char;   }n     n /* **++( **	class$putnxt - Class put next routine ** ** Functional description: **D **	This routine is called by port drivers to pass input characters. D ** Characters received are filtered for immediate control sequences. ** ** ** Calling convention: **> **	unsigned char	class$putnext (unsigned char read_character, 7 **                                     TTY_UCB *phyucb)  ** ** Input parameters: ** **	R3 - Input characterh **	R5 - UCB addressp ** ** Output parameters:s ** **	R5 - UCB address 2 **		UCB$B_TT_OUTYPE - 	Zero - no data to be output$ **					One  - single character in R3  **					Negative - output a burst **	Burst mode only:IA **		UCB$L_TT_OUTADR - Address of the first character of the burst*) **		UCB$W_TT_OUTLEN - Length of the burst* **' **	R0 - preserved All others destroyed.D ** ** Return value: ** **	Noneh ** ** Environment:t **I **	Called at device IPL holding the device spinlock.  Exit at calling IPL  **	with locks still held ** **-- */L unsigned char   class$putnext(unsigned char read_character, TTY_UCB *phyucb) {a   unsigned char	out_char;    int		length; int		status;   ASNUCB		*asnucb; ASNRD		*asnrd;    , asnucb = (ASNUCB *) phyucb->ucb$l_tt_logucb;* asnrd = (ASNRD *) phyucb->ucb$l_tt_typahd;# asnucb->ucb$q_asn_total_chars += 1;    /* **D **	Lets see if this is a special character these are not counted as > ** dropped even though they are not placed in the data buffer. ** */ if ((read_character <= 32) &&y9     (asnucb->ucb$l_asn_rcv_accm & (1 << read_character)))  {     /*.    **aJ    **	Now see if it is an XON or an XOFF character if so and we are doing H    ** software flow control then either stop or start the output stream.    **t    */f0    if (asnucb->ucb$l_asn_flow == ASN$M_XON_XOFF)    {!       if (read_character == 0x11)o       {n          /*s          **eK          **	XON so clear XOFF for output state, tell port to resume.  Then  K          ** call and see if we need to call the port driver with more data.0          **           */e$          phyucb->tty$v_st_ctrls = 0;          port$resume(phyucb);w*          out_char = class$getnext(phyucb);*          if (phyucb->ucb$b_tt_outype != 0)
          {+             port$startio(out_char, phyucb);o
          }       }n&       else if (read_character == 0x13)       {t          /*w          **eH          **	XOFF set state to XOFF and tell port driver to stop sending           ** output.w          **w          */ $          phyucb->tty$v_st_ctrls = 1;          port$stop(phyucb);o       }	    } } 8 else if ((void *) phyucb->ucb$l_tt_typahd != (void *) 0) {cK    length = (char *)asnrd->asnrd$l_putptr - (char *) &asnrd->asnrd$t_frame;n1    if ((read_character == 0x7e) && (length == 0))l    {       /*       **E       **	If character is a frame character and there is no data read dD       ** then we either have a start of frame, or back to back frameL       ** characters.  In both of these cases we can just set the frame seen +       ** character and clear the drop flag.o	       ** o       */'       asnucb->ucb$v_asn_frame_seen = 1;e'       asnucb->ucb$v_asn_drop_chars = 0;D    }5    else if ((read_character == 0x7e) && (length > 0))r    {       /*F       **	We have a frame mark and data in hand so we can just completeM       ** this read and try to start another one.  If the packet is bogus the rD       ** the code to remove quoting, or the FCS check will catch it.       **H       **	We will try to get another read packet if we fail then we will M       ** try to tell the other end to stop sending data.  If we fail the datatI       ** will end up in the bit bucket and a whole frame can get dropped.        **       */&       asnucb->ucb$q_asn_pkts_rcv += 1;8       __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, 1);)       asnrd->asnrd$l_status = SS$_NORMAL; )       asnrd->asnrd$l_fpc = asn$read_done;T(       exe_std$queue_fork((FKB *) asnrd);B       status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_readq_fl, .                              (void *) &asnrd);       if (status == -1)u       {b.          phyucb->ucb$l_tt_typahd = (void *) 0;           asn$input_stop(asnucb);       } 
       else       {*2          phyucb->ucb$l_tt_typahd = (void *) asnrd;       }	    }*    else if (!asnucb->ucb$v_asn_drop_chars)    {       /*       **G       **	If the buffer is full complete the request set the drop flag,  N       ** and try to get another read buffer.  The drop flag is set so we drop N       ** characters we got in a frame that is to large.  This just prevents usK       ** from producing frames with apparent bad checksums that are really t#       ** packtes that are to large.n       **F       **	We have a character to insert into the buffer save it.  We doN       ** no check for overflow as we could get and END of FRAME character and J       ** that would be OK.  We only want to count frames as to long if the$       ** really exceed maximum size.       **       */M       if ((void *) asnrd->asnrd$l_putptr > (void *) asnrd->asnrd$l_end_frame)s       {n.          asnucb->ucb$q_asn_dropped_chars += 1;*          asnucb->ucb$q_asn_long_pkts += 1;;          __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, 1);r1          asnrd->asnrd$l_status = SS$_TOOMUCHDATA; +          exe_std$queue_fork((FKB *) asnrd);yE          status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_readq_fl, *1                                 (void *) &asnrd);d          if (status == -1)
          {1             phyucb->ucb$l_tt_typahd = (void *) 0;<#             asn$input_stop(asnucb); 
          }
          else 
          {5             phyucb->ucb$l_tt_typahd = (void *) asnrd;n
          }       } 
       else       {e          /*e          **e8          **	Save the character and bump the put pointer.          **t          */o  E          *((unsigned char *) asnrd->asnrd$l_putptr) = read_character;_O          asnrd->asnrd$l_putptr = (void *) ((char *) asnrd->asnrd$l_putptr + 1);e       }i    }    elseC    {       /*       **C       **	Just drop the character and add it to the count of dropped        ** characters.       **       */+       asnucb->ucb$q_asn_dropped_chars += 1;     } }o else {b    /*t    **	K    **	There is no read buffer so drop the character and count it as a lost d    ** character.    **T    */d(    asnucb->ucb$q_asn_dropped_chars += 1; }*   phyucb->ucb$b_tt_outype = 0;	 return 0;*   }R     s /* **+++ **	class$setupucb - Class setup UCB routineN ** ** Functional description: **F **	This routine is called at unit init during both system startup and  ** power failure.  ** ** ** Calling convention: **( **	void	class$setupucb (TTY_UCB *phyucb) ** ** Input parameters: ** **	R5 - UCB address	 ** ** Output parameters:c ** **	Nonea ** ** Return value: ** **	Nonea ** ** Environment:t **I **	Called at device IPL holding the device spinlock.  Exit at calling IPLB **	with locks still held ** **-- */$ void	class$setupucb(TTY_UCB *phyucb) {)  $ if (phyucb->PHYBASE.ucb$l_refc == 0) {_  3    phyucb->PHYLOG.ucb$l_tl_phyucb = (UCB *) phyucb; M    phyucb->PHYBASE.ucb$l_devchar = phyucb->PHYBASE.ucb$l_devchar | DEV$M_AVL eN                                                                  & ~DEV$M_RED;4    phyucb->ucb$w_tt_speed = phyucb->ucb$w_tt_despee;5    phyucb->ucb$b_tt_parity = phyucb->ucb$b_tt_depari; ;    phyucb->PHYBASE.ucb$b_devtype = phyucb->ucb$b_tt_detype; =    phyucb->PHYBASE.ucb$w_devbufsiz = phyucb->ucb$w_tt_desize; T    phyucb->PHYBASE.ucb$l_devdepnd3 = phyucb->PHYBASE.ucb$l_devdepnd3 & ~TT3$M_POSIX;E    phyucb->ucb$l_tt_decha2 = phyucb->ucb$l_tt_decha2  & ~TT3$M_POSIX;u'    phyucb->PHYBASE.ucb$l_devdepnd4 = 0;t5    if (phyucb->PHYBASE.ucb$l_devdepend & TT$M_REMOTE)     {N       phyucb->PHYBASE.ucb$l_devdepend = phyucb->ucb$l_tt_dechar | TT$M_REMOTE;    }    elset    {@       phyucb->PHYBASE.ucb$l_devdepend = phyucb->ucb$l_tt_dechar;    }=    phyucb->PHYBASE.ucb$l_devdepnd2 = phyucb->ucb$l_tt_decha1; G    phyucb->ucb$w_tt_prtctl = phyucb->ucb$w_tt_prtctl & ~TTY$M_PC_BREAK; 5    if ((void *)phyucb->ucb$l_tt_wflink == (void *) 0)t    {@       phyucb->ucb$l_tt_wflink = (TWP *)&phyucb->ucb$l_tt_wflink;@       phyucb->ucb$l_tt_wblink = (TWP *)&phyucb->ucb$l_tt_wflink;    } }a return;i   }      t /* **++; **	class$data_set_trans - Class data set transition routine  ** ** Functional description: **B **	This routine handles data set state transitions. The inputs to N ** CLASS_DS_TRANS include a type code indicating what type of transition this L ** is. If it is a transition of modem signals, the changed signals are also  ** provided. ** tG **	It is important to note that this routine should be called with the pN ** MODEM$C_INIT transition type from the unit init routine of the port driver 9 ** if the unit is capable of having data set transitions.w ** ** Calling convention: **B **	void	class$data_set_trans (int modem_event, int modem_signals, 6 **                                    TTY_UCB *phyucb) ** ** Input parameters: **. **	R1 - Transition type (one of the following)/ **		MODEM$C_INIT     	 Initialize modem control @ **		MODEM$C_INIT_NORESET  	 Start modem protocol but don't init  **					 signals < **		MODEM$C_SHUTDWN  	 Shut down the line and disconnect the **					 processnC **		MODEM$C_SHUTDWN_NOHANGUP Stop modem protocol but don't stop the  **					 signals(- **		MODEM$C_DATASET 	 Data set signal changes{ **	R2 - Type specific argument$ **		DATASET - new receive modem mask **	R5 - UCB addresse ** ** Output parameters:r ** **	R0 - R4 Destroyed ** ** Return value: ** **	None  ** ** Environment:h **A **	Kernel mode, system context, device IPL with device lock held.t ** **-- */N void	class$data_set_trans(int modem_event, int modem_signals, TTY_UCB *phyucb) {b   unsigned char	out_char;{    7 if ((phyucb->PHYBASE.ucb$l_devdepend & TT$M_MODEM)  ||  7     (phyucb->PHYBASE.ucb$l_devdepnd2 & TT2$M_COMMSYNC))  {	&    if (modem_event == MODEM$C_SHUTDWN)    {       /*       **"       **	Tear down the connection.       **       */       class$disconnect(phyucb);c    }+    else if (modem_event == MODEM$C_DATASET)     {2       if ((!(modem_signals & TT$M_DS_CARRIER)) || +           (!(modem_signals & TT$M_DS_DSR)))o       {c          /*           **sK          **	Lost CD or DSR hang up the line.  Should really wait 2 seconds oL          ** for lost CD but for time being treat lost CD as instantly fatal.          **c          */a"          class$disconnect(phyucb);       } .       else if (!(modem_signals & TT$M_DS_CTS))       {           /*e          **C0          **	Lost CTS see if need to stop output.          **           */T'          if (!phyucb->tty$v_st_lostcts)*
          {)             phyucb->tty$v_st_lostcts = 1;u             port$stop(phyucb);
          }       }D+       else if (modem_signals & TT$M_DS_CTS)s       {C          /*           **hK          **	Have CTS if state is lost CTS then clear it and restart output.           **           */n&          if (phyucb->tty$v_st_lostcts)
          {)             phyucb->tty$v_st_lostcts = 0;               port$resume(phyucb);-             out_char = class$getnext(phyucb);c-             if (phyucb->ucb$b_tt_outype != 0)	
             {n.                port$startio(out_char, phyucb);
             } 
          }       }     } }c  > phyucb->ucb$b_tt_ds_rcv = (unsigned char)modem_signals & 0xff;   return;_   }_     = /* **++. **	class$read_error - Class read error routine ** ** Functional description: **E **	CLASS_READERROR is called when the terminal port driver detects a aN ** parity, data overrun or framing error on the terminal line. CLASS_READERROR= ** increments the appropriate error counter and just returns.F ** ** Note:B **		Partity errors are counted as framing errors. The line must beH **	no parity.  Thus a parity error really means a framing error occured. ** ** Calling convention: **@ **	unsigned char	class$read_error (unsigned int read_character, . **		                          TTY_UCB *phyucb) ** ** Input parameters: ** **	R3 - Character and flags:1 **			bit 12 - parity error on the given character 2 **			bit 13 - Framing error on the given character **			bit 14 - data overrun.u ** **	R5 - UCB addresst ** ** Output parameters:b ** **	R0 - R3 are destroyed1 **		UCB$B_TT_OUTYPE -	0 if no character to outputt% **					1 if valid character to output  ** ** Return value: ** **	None  ** ** Environment:  **I **	Called at device IPL holding the device spinlock.  Exit at calling IPLe **	with locks still held ** **-- */L unsigned char	class$read_error(unsigned int read_character, TTY_UCB *phyucb) {$   int		original_ipl;   ASNUCB		*asnucb;    , asnucb = (ASNUCB *) phyucb->ucb$l_tt_logucb;  ' if ((void *) asnucb != (void *) phyucb)t { $    if (!(asnucb->ucb$v_asn_delpend))    {)       asnucb->ucb$q_asn_total_chars += 1; 2       if ((read_character >> TERMINAL_PE_BIT) & 1)       {a#          asnucb->ucb$q_asn_fe += 1;        }e2       if ((read_character >> TERMINAL_FE_BIT) & 1)       { #          asnucb->ucb$q_asn_fe += 1;s       } 2       if ((read_character >> TERMINAL_OR_BIT) & 1)       {o*          asnucb->ucb$q_asn_data_lost += 1;       }s    } }e else { #    bug_check(TTDRVR1, FATAL, WARM);0 }    phyucb->ucb$b_tt_outype = 0;  	 return 0;    }t     r /* **++. **	class$disconnect - Class disconnect routine ** ** Functional description: **F **	The port driver calls CLASS_DISCONNECT to indicate to the terminal M ** class driver that the terminal is no longer connected to the system. This  H ** is the preferred way of disconnecting a process from a terminal on a  ** non-modem line. ** ** Calling convention: *** **	void	class$disconnect (TTY_UCB *phyucb) ** ** Input parameters: ** **	R5 - UCB addresst ** ** Output parameters:  ** **	R4 Destroyed$ ** ** Return value: ** **	NoneT ** ** Environment:b **I **	Called at device IPL holding the device spinlock.  Exit at calling IPLa **	with locks still held ** **-- */& void	class$disconnect(TTY_UCB *phyucb) {s   int		original_ipl;   uint64		fr3; uint64		fr4;   ASNUCB		*asnucb;    , asnucb = (ASNUCB *) phyucb->ucb$l_tt_logucb;  ' if ((void *) asnucb != (void *) phyucb)_ {a$    if (!(asnucb->ucb$v_asn_delpend))    {&       fr4 = asnucb->ASNBASE.ucb$q_fr4;!       if (!(fr4 & TTY$M_FD_BUSY))(       {s)          fr3 = asnucb->ASNBASE.ucb$q_fr3;u9          fr4 = fr4 | TTY$M_FD_DISCONNECT | TTY$M_FD_BUSY; ;          fork(asn$fork_dispatch, fr3, fr4, (FKB *) asnucb);        }a
       else       { @           asnucb->ASNBASE.ucb$q_fr4 = fr4 | TTY$M_FD_DISCONNECT;       }i    } }  else {o#    bug_check(TTDRVR1, FATAL, WARM);  }f   return;n   }m       /* **++" **	class$fork - Class fork routine ** ** Functional description: **H **	CLASS_FORK is the routine a port driver calls if it needs to start a N ** driver fork process that would normally use the UCB.  The port driver must G ** never initiate a fork directly -- it must always call this routine.  J ** CLASS_FORK, using the UCB, will set up the fork block and follow other K ** necessary protocol on the port driver's behalf. When the fork has taken nN ** place, the class driver will call the port driver back at the port service  ** routine PORT_FORKRET. ** ** Calling convention: **$ **	void	class$fork (TTY_UCB *phyucb) ** ** Input parameters: ** **	R5 - UCB addresse ** ** Output parameters:  ** **	R4 Destroyed_ ** ** Return value: ** **	Noner ** ** Environment:  **I **	Called at device IPL holding the device spinlock.  Exit at calling IPL{ **	with locks still held ** **-- */  void	class$fork(TTY_UCB *phyucb) {t   int		original_ipl;   uint64		fr3; uint64		fr4;   ASNUCB		*asnucb;    , asnucb = (ASNUCB *) phyucb->ucb$l_tt_logucb;  ' if ((void *) asnucb != (void *) phyucb)e { $    if (!(asnucb->ucb$v_asn_delpend))    {&       fr4 = asnucb->ASNBASE.ucb$q_fr4;!       if (!(fr4 & TTY$M_FD_BUSY))d       {                       )          fr3 = asnucb->ASNBASE.ucb$q_fr3;_7          fr4 = fr4 | TTY$M_FD_PORTFORK | TTY$M_FD_BUSY; ;          fork(asn$fork_dispatch, fr3, fr4, (FKB *) asnucb);J       }t
       else       {i>           asnucb->ASNBASE.ucb$q_fr4 = fr4 | TTY$M_FD_PORTFORK;       }     } }> else {_#    bug_check(TTDRVR1, FATAL, WARM);  }    return;*   }      r /* **++- **	class$powerfail - Class power fail routine  ** ** Functional description: **E **	This routine is called the port driver's unit init routine when a t ** powerfail is detected.  ** ** Calling convention: **) **	void	class$powerfail (TTY_UCB *phyucb)F ** ** Input parameters: ** **	R5 - UCB addresse ** ** Output parameters:s ** **	All registers are preserved" **	UCB$W_STS 	UCB$V_INT is cleared **			UCB$V_TIM is setu **	UCB$L_DUETIM    is clearedp ** ** Return value: ** **	Noner ** ** Environment:a **A **	Kernel mode, system context, device IPL with device lock held.v ** **-- */% void	class$powerfail(TTY_UCB *phyucb)e {e   return;    }a