I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ppp_timer.c  **
 **  ABSTRACT:  **B **      This module implements routines required to provide timing% **      functions for the PPP driver.  ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      29-November-1995 ** **  MODIFICATION HISTORY:  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **, **      24-July-1996      Barry W. Kierstein5 **                        Corrected copyright notice.  **+ **      29-November-1995  Original version.  ** **-- */   /* ** Include files */   /* ** ** import definitions: **        types  ** */ #ifndef _PPPD_H_ #include "pppd.h"  #endif   /* ** ** import definitions:
 **        TQE  ** */ #ifndef __TQE_LOADED #include "tqedef.h"  #endif   /* ** ** import definitions: **        DYN$C_TQE  ** */ #ifndef __DYNDEF_LOADED  #include "dyndef.h"  #endif   /* ** ** import definitions: **        fork_lock  **        fork_unlock  ** */ #ifndef __VMS_DRIVERS_LOADED #include "vms_drivers.h" #endif   /* ** ** import definitions: **        SPL$C_IOLOCK8  ** */ #ifndef __SPLCODDEF_LOADED #include "splcoddef.h  #endif   /* ** ** import definitions: **        exe_std$instimq  ** */ #ifndef __EXE_ROUTINES_LOADED  #include "exe_routines.h"  #endif   /* ** ** import definitions:/ **        prototypes for this module's routines  ** */ #ifndef _PPP_TIMER_H_  #include "ppp_timer.h" #endif   /* ** External variables  */0 extern __int64 EXE$GQ_SYSTIME;	/* system time */   /* ** Global Variables  */B static timerEntry *timerQueue = NULL; /* Global queue of timers */B TQE    sysTimerEntry; /* TQE for implementing a repeating timer */     /* **++ **  FUNCTION NAME: ** **      timeout  ** **  FUNCTIONAL DESCRIPTION:  **I **      This routine is used to have a function execute after a specified  **      interval.    ** **  FORMAL PARAMETERS: **$ **      func     Function to execute1 **      param    Parameter to call function with. I **      delta    Time to wait before executing the function. The time is  ? **               specified in increments of PPP_TIMER_INTERVAL.  ** **  IMPLICIT INPUTS: **8 **      timerQueue    The global queue of timer entries. ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */8 void timeout( void (*func)(), caddr_t param, int delta ) { H     timerEntry *newP;  /* newly allocated time entry                  */H     timerEntry *curP;  /* pointer to timer entry previously examined  */H     timerEntry *prevP; /* pointer to timer entry currently examaining */  %     /* Allocate a timer structure. */ 8     ALLOC_MEM( newP, sizeof(timerEntry), timerEntry * );     if ( newP == NULL )      {  	return;     }   "     /* Set the new timer values */     newP->ticksToFire = delta;     newP->param       = param;     newP->func        = func;      newP->next        = NULL;   D     /* Add the new timer to the list of timers in ascending order */$     for (curP = prevP = timerQueue; ,          curP && curP->ticksToFire <= delta;)          prevP = curP, curP = curP->next) 	         ;      { ( 	/* see if we're at start of the list */    	if ( curP == prevP ) 	{ 	    timerQueue = newP;  	    newP->next = curP;  	} 	else  	{ 	    prevP->next = newP; 	    newP->next  = curP; 	}	        }      return;  }      /* **++ **  FUNCTION NAME: ** **      untimeout  ** **  FUNCTIONAL DESCRIPTION:  **G **      This function removes the specified timer entry from the global  **      queue of timers.   ** **  FORMAL PARAMETERS: **9 **      func     Function field of timer entry to remove. : **      param    Parameter field of timer entry to reomve. ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- *// void untimeout( void (*func)(), caddr_t param )  {      timerEntry *cop, *prevp;   %     /* Remove the matching timeout */ E     for (cop = prevp = timerQueue; cop; prevp = cop, cop = cop->next)      { 5         if (cop->func == func && cop->param == param)  	{ 	    if ( prevp == cop ) 	    { 		timerQueue = NULL; 	    }	 	    else  	    { 		prevp->next = cop->next; 	    }             DEALLOC_MEM( cop );  	    cop = prevp;	 	}     }        return;  }      /* **++ **  FUNCTION NAME: ** **      timerInit  ** **  FUNCTIONAL DESCRIPTION:  **M **      This function is called to initialise the timer functionality of PPP. L **      It queues a TQE that expires every PPP_TIMER_INTERVAL seconds.  WhenI **      the TQE expires the routine timerPoll is called to process timer   **      entries .  ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */ void timerInit() { <     __int64 dueTime;		/* time the entry will first expire */  "     /* initialise TQE structure */)     BZERO( &sysTimerEntry, sizeof(TQE) ); -     sysTimerEntry.tqe$w_size   = sizeof(TQE); +     sysTimerEntry.tqe$b_type   = DYN$C_TQE; .     sysTimerEntry.tqe$b_rqtype = TQE$C_SSREPT;0     sysTimerEntry.tqe$l_fpc    = (int)timerPoll;4     sysTimerEntry.tqe$q_delta  = PPP_TIMER_INTERVAL;  "     /* calculate first due time */2     dueTime = EXE$GQ_SYSTIME + PPP_TIMER_INTERVAL;  (     /* insert into system timer queue */L     exe_std$instimq( (int)(dueTime), (int)(dueTime >> 32), &sysTimerEntry );       return;  }      /* **++ **  FUNCTION NAME: ** **      timerPoll  ** **  FUNCTIONAL DESCRIPTION:  **G **      This routine is called when the TQE queued by PPP expires.  It  4 **      processes the entries on the PPP timerQueue. ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */ void timerPoll() { %     timerEntry *freep, *list, *nextp;      int savedIpl;   .     /* Return if there are no active timers */     if (timerQueue == NULL)          return;        /* take out iolock8 */*     fork_lock( SPL$C_IOLOCK8, &savedIpl );  A     /* Make a pass through the timer list decrementing it by 1 */      nextp = timerQueue;      while (nextp != NULL)      {          nextp->ticksToFire--;          nextp = nextp->next;     }   I     /* Move the expired timers into a separate list to be called later */      list = nextp = timerQueue;  J     /* Move through the timers until the first unexpired timer is found */8     while ((nextp != NULL) && (nextp->ticksToFire == 0))         nextp = nextp->next;  H     /* Set the timers list to now points to the first unexpired timer */     timerQueue = nextp;   C     /* Now call all the timeout routines for the expired timers. */ 2     while ((list != NULL) && (list != timerQueue))     { #         (*list->func)(list->param);          freep = list;          list = list->next;         DEALLOC_MEM( freep );      }           /* release iolock8 */ 8     fork_unlock( SPL$C_IOLOCK8, savedIpl, SMP_RESTORE );       return;  }           