I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      lcp_vms.h. **
 **  ABSTRACT:  **C **      Constant defintions and external defs of variables in lcp.c   **      that are specific to VMS ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      27-November-1995 ** **  MODIFICATION HISTORY:  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **, **      24-July-1996      Barry W. Kierstein5 **                        Corrected copyright notice.  **+ **      27-November-1995  Original version.  ** **-- */ #ifndef _LCP_VMS_H_  #define _LCP_VMS_H_    /* ** ** import definitions: **        prototype macro  **        types  ** */ #ifndef _PPPD_H_ #include "pppd.h"  #endif   /* ** ** import definitions:
 **        FKB  ** */ #ifndef __FKBDEF_LOADED  #include "fkbdef.h"  #endif   /* ** ** import definitions: **        MB_UCB ** */ #ifndef __UCBDEF_LOADED  #include "ucbdef.h"  #endif   /* ** ** import definitions: **        asnvcibdef ** */ #ifndef __ASNVCIBDEF_LOADED  #define _VCIBDEF_H_ B #define VCIBDEF vcibdef /* work around broken vcibdef.h in V7.1 */ #include "asnvcibdef.h"  #endif   /* ** ** import definitions: **        vcibdef  ** */ #ifndef _VCIBDEF_H_  #define _VCIBDEF_H_ B #define VCIBDEF vcibdef /* work around broken vcibdef.h in V7.1 */ #include "vcibdef.h" #endif     /* ** ** import definitions: **        VCIDemuxprotrej  ** */ #ifndef _PPP_VCI_H_  #include "ppp_vci.h" #endif  1 #define DEMUXPROTREJ(u, p)  VCIDemuxprotrej(u, p)    /* ** ** import definitions:
 **        fsm  ** */ #ifndef _FSM_H_  #include "fsm.h" #endif   /* ** ** import definitions: **        PPPD$K_MAX_NAME  ** */ #ifndef _PPP_MGMT_IF_H_  #include "ppp_mgmt_if.h" #endif   /* ** ** import definitions: **        lcp_options  ** */ #ifndef _LCP_H_  #include "lcp.h" #endif   /*$ ** Define the line data structure.   **  > ** It represents a PPP connection over a single communications ** port. */   /* ** Constants used in the line  */O #define MAX_NAME    PPPD$K_MAX_NAME  /* Max. length of a string in the line  */ O #define MAX_LINES   100              /* Max. number of lines on the system   */    /* ** Possible states of the line */ typedef enum _OnOffState {      Off = 0,     On  = 1 
 } OnOffState;    /* ** Types of line */ typedef enum lineType  {      Transient,
     Permanent  } lineType;    /* ** The line structure itself */ typedef struct PPPLine { G     ASNVCIB      vcib;		  /* vcib for the associated com port        */ H     OnOffState   state;		  /* Indicates whether line enabled/disabled */O     lineType     type;            /* Indicates whether perm/transient line   */ E     lineId       id;		  /* line identifier                         */ O     int          delete;          /* TRUE if line is marked for deletion     */ O     int          devClosed;       /* TRUE if device has been closed          */ O     int          devFail;         /* TRUE if a device failure has been seen  */ O     FKB          frkBlck;         /* Block for doing fork on                 */ H     fsm          lcpFsm;	  /* FSM for LCP                             */H     PPPPort      *ports;	  /* Linked list of ports using this line    */H     int          debug;		  /* TRUE if debugging enabled on the line   */O     char         debugMbx[MAX_NAME]; /* the mailbox for debugging            */ O     u_int        debugMbxLen;     /* Length of the debug mailbox             */ O     MB_UCB       *debugMbxUCB;    /* UCB for writing debug messages          */ O     char         name[MAX_NAME];  /* Name of the PPP line                    */ I     u_int        nameLen;	  /* Length of name of PPP line              */ O     char         comPort[MAX_NAME];/* Name of com port line connected to     */ L     u_int        comPortLen;	  /* Length of com port string               */N     int          maxConfigure;	  /* Maximum Configure-Request Transmissions */L     int          maxFailure;	  /* Maximum number of Naks loops permiited  */N     int          maxTerminate;	  /* Maximum Terminate-Request Transmissions */N     int          restartTimer;	  /* Timeout time in milliseconds            */O     lcp_options  lcp_wantoptions; /* Set of options we want peer to accept   */ O     lcp_options  lcp_gotoptions;  /* Set of options negotiated with peer     */ O     lcp_options  lcp_allowoptions;/* Initial set of peers options acceptable */ O     lcp_options  lcp_hisoptions;  /* Set of peer's options we agreed to use  */ O     int          lcp_echos_pending;/* Number of outstanding echo msgs        */ O     int          lcp_echo_number;  /* ID number of next echo frame           */ O     int          lcp_echo_timer_running; /* TRUE if a timer is running       */ O     int	         lcp_echo_interval; /* Interval between LCP echo-requests    */ O     int	         lcp_echo_fails;  /* Tolerance to unanswered echo-requests   */ K     u_int        txAccm[8];	  /* transmit character map                  */ 
 } PPPLine;   /*   **   */ typedef struct _lineEntry  { @     lineId   id;	/* the line identifier for this line         */E     PPPLine *linePtr;	/* pointer to the line structure             */  } lineEntry;     /*! ** Define a global array of lines  */O extern lineEntry lineTbl[MAX_LINES]; /* Global array of lineEntries          */    /*+ ** Macros for accessing the array of lines.  */O #define LINEREFSHIFT          16       /* Number of bits representing refCnt */ O #define LINEINDEXMASK         0xffff   /* Mask to calculate index            */ O #define NULL_LINE             0	       /* An null line pointer               */ ; #define LINE_REF(lineRef)     (((lineRef) >> LINEREFSHIFT ) : #define LINE_INDEX(lineRef)   ((lineRef) & LINEINDEXMASK )   /* ** Macros to manipulate lineIds  */G #define LINE_ENTRY(lineRef)      (lineTbl[LINE_INDEX(lineRef)].linePtr) " #define LINEID_VALID(lineRef)    \C          ( lineTbl[LINE_INDEX(lineRef)].linePtr != NULL_LINE ) && \ 6 	 ( lineTbl[LINE_INDEX(lineRef)].id  == (lineRef) && \= 	 ( lineTbl[LINE_INDEX(lineRef)].linePtr->delete == FALSE ) )     /*K ** Macros to handle relocation of lcp global variables into line structure   */J #define LCP_ECHO_TIMER(lineRef)    ( LINE_ENTRY(lineRef)->lcp_echo_timer )M #define LCP_ECHO_INTERVAL(lineRef) ( LINE_ENTRY(lineRef)->lcp_echo_interval ) M #define LCP_ECHOS_PENDING(lineRef) ( LINE_ENTRY(lineRef)->lcp_echos_pending ) K #define LCP_ECHO_NUMBER(lineRef)   ( LINE_ENTRY(lineRef)->lcp_echo_number ) ) #define LCP_ECHO_TIMER_RUNNING(lineRef) \ R                                    ( LINE_ENTRY(lineRef)->lcp_echo_timer_running )J #define LCP_ECHO_FAILS(lineRef)    ( LINE_ENTRY(lineRef)->lcp_echo_fails )E #define LCP_FSM(lineRef)           ( &(LINE_ENTRY(lineRef)->lcpFsm) ) L #define LCP_ALLOWOPTIONS(lineRef)  ( LINE_ENTRY(lineRef)->lcp_allowoptions )J #define LCP_GOTOPTIONS(lineRef)    ( LINE_ENTRY(lineRef)->lcp_gotoptions )K #define LCP_WANTOPTIONS(lineRef)   ( LINE_ENTRY(lineRef)->lcp_wantoptions ) J #define LCP_HISOPTIONS(lineRef)    ( LINE_ENTRY(lineRef)->lcp_hisoptions )   /*0 ** Macro to process a device failure on the line */ #define LCP_DEVFAIL(lineId) \  { \ )     if ( !LINE_ENTRY(lineId)->devFail ) \      { \ -         LINE_ENTRY(lineId)->devFail = TRUE; \ !         lcp_deviceFail(lineId); \      } \  }  	    /*  ( ** Prototypes for VMS specific functions */ void lcp_deleteLine(lineId); void lcp_deviceFail(lineId); void lcp_down(fsm *);  void lcp_finished(fsm *);  void lcp_init(void); void lcp_shutLine(lineId); void lcp_start(lineId);  void lcp_up(fsm *);    /*4 ** Don't need the link_xxx routines so NULL them out */" #define link_required(x) ((void)0)$ #define link_terminated(x) ((void)0)   #endif /* _LCP_VMS_H_ */