I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  **
 **      fsm.c  **
 **  ABSTRACT:  **< **      This module contains routines specific to VMS which / **      implement the PPP finite state machine.  ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      29-November-1995 ** **  MODIFICATION HISTORY:  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **+ **      29-November-1995  Original version.  ** **-- */   /* ** Include files */   /* ** ** import definitions: **        types  ** */ #ifndef _PPPD_H_ #include "pppd.h"  #endif   /* ** ** import definitions: **        SS$_xxx  ** */ #ifndef __SSDEFLOADED  #include "ssdef.h" #endif   /* ** ** import definitions: **        LineTbl  **        line ** */ #ifndef _LCP_VMS_H #include "lcp_vms.h" #endif   /* ** ** import definitions: **        BUF_ALLOC  **        BUF_DATA_PTR **        BUF_DATA_TRIM  ** */ #ifndef _PPP_BUF_  #include "ppp_buf.h" #endif   /* ** ** import definitions: **        port ** */ #ifndef _PPP_VCI_H_  #include "ppp_vci.h" #endif   /* ** ** import definitions: **        deviceTransmit ** */ #ifndef _PPP_ASYNC_H_  #include "ppp_async.h" #endif   /* ** ** import definitions:0 **        prototypes for this interface routines ** */ #ifndef _FSM_IF_H_ #include "fsm_if.h"  #endif   /* ** ** import definitions:/ **        prototypes for this module's routines  ** */ #ifndef _FSM_VMS_H_  #include "fsm_vms.h" #endif   /*   ** Defines   */2 #define PROTO_NAME(f)	((f)->callbacks->proto_name)   /* ** Global variables  */R protEnt *prottbl = NULL;     /* The list header of registered control protocols */7 /* Define the array of all assigned protocol numbers */  NCPEntry controlProtocols[] =  { S     0x8021, "IPCP",	    /* Internet Protocol Control Protocol                    */ T     0x8023, "OSICP",	    /* OSI Network Layer Control Protocol                    */W     0x8025, "XeroxCP",	    /* Xerox NS IDP Control Protocol                         */  W     0x8027, "DECnetCP",     /* DECnet Phase IV Control Protocol                      */ S     0x8029, "ATCP",	    /* Appletalk Control Protocol                            */ T     0x802b, "IPXCP",	    /* Novell IPX Control Protocol                           */W     0x8031, "BNCP",         /*  Bridging NCP                                         */ S     0x8033, "SPCP",	    /* Stream Protocol Control Protocol                      */ S     0x8035, "BVCP",	    /* Banyan Vines Control Protocol                         */ S     0x803d, "MLCP",	    /* Multi-Link Control Protocol                           */ W     0x803f, "NFCP",         /* NETBIOS Framing Control Protocol                      */ V     0x8041, "CiscoCP",	    /* Cisco Systems Control Protocol                        */W     0x8043, "Timeplex",	    /* Ascom Timeplex                                        */ U     0x8045, "LBLBCP",	    /* Fujitsu LBLB Control Protocol                         */ T     0x8047, "RLNCP",	    /* DCA Remote Lan Network Control Protocol (RLNCP)       */S     0x8049, "SDCP",	    /* Serial Data Control Protocol (PPP-SDCP)               */ W     0x804b, "SNA802CP",	    /* SNA over 802.2 Control Protocol                       */ T     0x804d, "SNACP",	    /* SNA Control Protocol                                  */V     0x804f, "IPv6CCP",	    /* IP6 Header Compression Control Protocol               */S     0x006f, "SBCP",	    /* Stampede Bridging Control Protocol                    */ U     0x80fb, "0x80fb",	    /* compression on single link in multilink group control */ R     0x80fd, "CCP",	    /* Compression Control Protocol                          */ };   /*$ ** Define the vector of fsm routines */   fsmRtns fsmVector =  {      fsm_deregister,      fsm_register,      fsm_start,     fsm_stop };     /* **++ **  FUNCTION NAME: ** **      fsm_isNCPRegistered  ** **  FUNCTIONAL DESCRIPTION:  **O **      The function does not check that a valid control protocol is passed as  ; **      an input argument (i.e. in the range 8xxx to 3xxx )  ** **  FORMAL PARAMETERS: **2 **      ctrlProtocol    Control protocol number.		 ** **  IMPLICIT INPUTS: **B **      prottbl    The linked list of registered control protocols ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **2 **      TRUE    The control protocol is registered6 **      FALSE   The control protocol is not registered ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */0 char fsm_isNCPRegistered( u_short ctrlProtocol ) { D     protEnt *cpPtr = NULL;	 /* pointer to control protocol entry  */F     int     retCode = FALSE;	 /* function return code               */  ?     for ( cpPtr = prottbl; cpPtr != NULL; cpPtr = cpPtr->next )      { + 	if ( cpPtr->ctrlProtocol == ctrlProtocol )  	{ 	    retCode = TRUE; 	    break;  	}     }           return (retCode);  }      /* **++ **  FUNCTION NAME: ** **      fsm_isNCPRequired  ** **  FUNCTIONAL DESCRIPTION:  **S **      This function checks to see if a given protocol requires a control protocol N **      by seeing if a corresponding control protocol is in the table of known **      control protocols. ** ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **> **      coontrolProtocols    Table of known control protocols. ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **B **      TRUE    A control protocol is required to run the protocol\ **      FALSE   A control protocol is required or isn't in table of known control protocols  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */* char fsm_isNCPRequired( u_short protocol ) { V     int match = FALSE;	    /* TRUE if the control protocol in array of assign. NCPs */T     NCPEntry *entry;	    /* pointer to entry in array of assigned NCPs            */O     int index;		    /* loop variable                                         */   /     for ( entry = controlProtocols, index = 0;  6 	 index < (sizeof(controlProtocols)/sizeof(NCPEntry)); 	 index++, entry++ )     { 2 	if ( entry->ctrlProtocol == (protocol | 0x8000) ) 	{ 	    match = TRUE; 	    break;	    /* exit loop */  	}     }           return (match);  }      /* **++ **  FUNCTION NAME: ** **      fsm_register ** **  FUNCTIONAL DESCRIPTION:  **C **      This function adds a control protocol to the linked list of L **      registered control protocols.  The function checks that the suppliedM **      control protocol has a valid value and isn't already in the list.  It K **      also checks that user supplies pointers to open and close callback   **      routines.  ** **  FORMAL PARAMETERS: **5 **      ctrlProtocol       Control protocol number.		 L **      clientCallbacks    Structure containining client's callback routines@ **      error              Reason for failure (return parameter) ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **@ **      TRUE    The control protocol was successfully registered@ **      FALSE   The control protocol couldn't not be registered.C **              The parameter error contains the reason for failure  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */T u_int fsm_register( u_short ctrlProtocol, clientCallbacks *callbacks, u_int *error ) { L     u_int   retCode = TRUE; /* function return code - assume success      */L     protEnt *cpPtr = NULL;  /* pointer to control protocol entry          */I     NCPEntry *entry;	    /* pointer to entry in array of assigned NCPs */ D     int index;		    /* loop variable                              */  :     if ( ctrlProtocol < 0x8000 || ctrlProtocol > 0x3ffff )     {  	retCode = FALSE;  	*error  = SS$_VALNOTVALID;      }   ,     if ( fsm_isNCPRegistered(ctrlProtocol) )     {  	retCode = FALSE;  	*error  = SS$_DEVALLOC;     }        /*  0      ** Check open and close callbacks supplied       */      if ( retCode == TRUE )     { ; 	if ( callbacks->open == NULL || callbacks->close == NULL )  	{ 	    retCode = FALSE;  	    *error  = SS$_INSFARG;  	}     }           /*  ;      ** Allocate a protEnt structure and add to linked list '      ** of registered control protocols       */      if ( retCode == TRUE )     { 0 	ALLOC_MEM( cpPtr, sizeof(protEnt), protEnt * ); 	if ( cpPtr == NULL )  	{ 	    retCode = FALSE;  	    *error  = SS$_INSFMEM;  	} 	else  	{ 	    /* , 	     ** Fill in fields of protEnt stucture. 	     **4 	     ** We fill in the up, down, finished callbacks: 	     ** with routines that we implement.  This is because9 	     ** we need to do some processing before telling the  	     ** client of the event.  	     ** 	     */2 	    cpPtr->ctrlProtocol           = ctrlProtocol;5 	    cpPtr->callbacks.open         = callbacks->open; 6 	    cpPtr->callbacks.close        = callbacks->close;8 	    cpPtr->callbacks.resetci      = callbacks->resetci;8 	    cpPtr->callbacks.cilen        = callbacks->cilen;  =             cpPtr->callbacks.addci        = callbacks->addci;g=             cpPtr->callbacks.ackci        = callbacks->ackci;s6 	    cpPtr->callbacks.nakci        = callbacks->nakci;6 	    cpPtr->callbacks.rejci        = callbacks->rejci;6 	    cpPtr->callbacks.reqci        = callbacks->reqci;3 	    cpPtr->callbacks.clientUp     = callbacks->up;q5 	    cpPtr->callbacks.clientDown   = callbacks->down; , 	    cpPtr->callbacks.up           = fsm_up;. 	    cpPtr->callbacks.down         = fsm_down;* 	    cpPtr->callbacks.starting     = NULL;2 	    cpPtr->callbacks.finished     = fsm_finished;* 	    cpPtr->callbacks.protreject   = NULL;* 	    cpPtr->callbacks.retransmit   = NULL;8 	    cpPtr->callbacks.extcode      = callbacks->extcode;* 	    cpPtr->callbacks.proto_name   = NULL;  2 	    /* find matching protocol string  - if any */0 	    for ( entry = controlProtocols, index = 0; 7 		 index < (sizeof(controlProtocols)/sizeof(NCPEntry));  		 index++, entry++ )  	    {, 		if ( entry->ctrlProtocol == ctrlProtocol ) 		{t0 		    cpPtr->callbacks.proto_name = entry->name;  		    break;	    /* exit loop */ 		}* 	    } 	     = 	    /* add to linked list of registered control protocols */  	    cpPtr->next =  prottbl; 	    prottbl     = cpPtr;* 	}     }I        S     return (retCode);D }    9 /* **++ **  FUNCTION NAME: ** **      fsm_deregister ** **  FUNCTIONAL DESCRIPTION:i **L **      This function removes a control protocol from the list of registeredJ **      control protocols.  Any state machines using this control protocol **      wiil be stopped. ** **  FORMAL PARAMETERS: **0 **      ctrlProtocol    Control protocol number. ** **  IMPLICIT INPUTS: **C **      prottbl    The linked list of registered control protocols.s ** **  IMPLICIT OUTPUTS:* **
 **      None.: **& **  function value or completion codes **
 **      None.H ** **  SIDE EFFECTS:  **
 **      None.* ** **-- */+ void fsm_deregister( u_short ctrlProtocol )A {PK     protEnt *cpPtr   = NULL;	/* pointer to control protocol entry        */"K     protEnt *prevPtr = NULL;	/* pointer to control protocol entry        */PF     u_int   lineIndex;		/* Index for scanning through PPP lines     */B     PPPPort *port;		/* pointer to a port structure              */D     fsm     *fsmPtr;		/* pointer to state machine structure       */  :     /* Find the entry that matches the control protocol */%     for ( cpPtr = prevPtr = prottbl; * 	  cpPtr != NULL; ) 	  prevPtr = cpPtr, cpPtr = cpPtr->next )u     {u+ 	if ( cpPtr->ctrlProtocol == ctrlProtocol )e 	{ 	    /* 6 	     ** Close all state machines using this protocol  	     */> 	    for ( lineIndex = 0; lineIndex < MAX_LINES; lineIndex++ ) 	    {+ 		if ( lineTbl[lineIndex].linePtr != NULL )t 		{r4 		   for ( port = lineTbl[lineIndex].linePtr->ports; 			 port != NULL;E 			 port = port->next )  		   {; 		       if ( port->protocol == (~0x8000 & ctrlProtocol) )  
 		       {" 			   if ( fsmPtr = port->fsmPtr ) 			   {w 			       fsm_stop( fsmPtr ); # 			       fsmPtr->callbacks = NULL;P 			   } ! 			   break; /* exit port loop */ 
 		       } 		   } /* end-for port */   		} /* end-if linePtr != NULL */ 	    } /* end-for lineIndex */ 	     " 	    /* Delete entry from table */ 	    if ( prevPtr == cpPtr ) 	    { 		prottbl = NULL ; 	    }	 	    else  	    { 		prevPtr->next = cpPtr->next; 	    } 	    DEALLOC_MEM( cpPtr ); 	     ! 	    break; /* exit cpPtr loop */  	}	     }          return;  }      /* **++ **  FUNCTION NAME: ** **      fsm_data ** **  FUNCTIONAL DESCRIPTION:  **M **      This routine processes received control protocol packets.  It assumesdK **      the address/control and protocol fields have been removed from the   **      packet.  ** **  FORMAL PARAMETERS: **. **      line        The identifier of the line+ **      protocol    Control protocol numbert6 **      data        Pointer to the start of the packet( **      len         Lenght of the packet ** **  IMPLICIT INPUTS: **
 **      None.	 ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **I **      TRUE   A state machine using this protocol was found on the line.	B **      FALSE  No state machine is using this protocol on the line ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */E char fsm_data( lineId line, u_short protocol, u_char *data, int len )r {cM     u_int match = FALSE; /* function return code - be pessimistic about it */rI     PPPPort  *port;	 /* pointer to a port structure                    */S       /* d=      ** Find a matching control protocol and pass the buffer f-      ** onto the state machine for processingi      */c)     for ( port = LINE_ENTRY(line)->ports;e 	  port != NULL; 	  port = port->next )     {// 	if ( port->protocol == (~0x8000 & protocol) )   	{ 	    match = TRUE;* 	    fsm_input( port->fsmPtr, data, len ); 	    break; /* exit loop */_ 	}     } /* end-for port */          return (match);  }_   R /* **++ **  FUNCTION NAME: ** **      fsm_down ** **  FUNCTIONAL DESCRIPTION:  **D **      The routine handles a transition of the state machine out of **      OPENED state.o ** **  FORMAL PARAMETERS: **7 **      fsmPtr    Pointer to a state machine structure.. ** **  IMPLICIT INPUTS: **
 **      None.t ** **  IMPLICIT OUTPUTS:e **
 **      None.o **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:e **
 **      None.  ** **-- */ void fsm_down( fsm *fsmPtr ) { )     /* tell port control protocol down */ )     VCINCPEvent( fsmPtr->port, NCPDown );   +     /* tell client control protocol down */r&     if (fsmPtr->callbacks->clientDown)     {P0 	(*fsmPtr->callbacks->clientDown)(fsmPtr->unit);     }  		     return;  }S   * /* **++ **  FUNCTION NAME: ** **      fsm_init ** **  FUNCTIONAL DESCRIPTION:p **B **      This routine is called to initialise a fsm structure.  TheK **      routine assumes the required control protocol has been  registered.C ** **  FORMAL PARAMETERS: **1 **      fsmPtr          Pointer to fsm structure. L **      line            Identifier of the line the protocol is running over.C **      port            Pointer to the port the fsm associated withe< **      ctrlProtocol    Control Protocol this fsm is running ** **  IMPLICIT INPUTS: **9 **      prottbl    Table of registered control protocols.P ** **  IMPLICIT OUTPUTS:r **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:i **
 **      None.i ** **-- */O void fsm_init( fsm *fsmPtr, lineId line, PPPPort *port, u_short ctrlProtocol  )  { I     protEnt *cpPtr  = NULL;	     /* pointer to control protocol entry  */        /* EA      ** Find the prottbl entry that matches the control protocol d      */ ?     for ( cpPtr = prottbl; cpPtr != NULL; cpPtr = cpPtr->next )      {l+ 	if ( cpPtr->ctrlProtocol == ctrlProtocol )n 	{' 	    /* initialise the fsm structure */g( 	    fsmPtr->line                = line;( 	    fsmPtr->port                = port;0 	    fsmPtr->protocol            = ctrlProtocol;+ 	    fsmPtr->state               = INITIAL;t% 	    fsmPtr->flags               = 0;e% 	    fsmPtr->id                  = 0;r% 	    fsmPtr->reqid               = 0; % 	    fsmPtr->seen_ack            = 0;eB 	    fsmPtr->timeouttime         = LINE_ENTRY(line)->restartTimer;B 	    fsmPtr->maxconfreqtransmits = LINE_ENTRY(line)->maxConfigure;% 	    fsmPtr->retransmits         = 0;tB 	    fsmPtr->maxtermtransmits    = LINE_ENTRY(line)->maxTerminate;% 	    fsmPtr->nakloops            = 0;c@ 	    fsmPtr->maxnakloops         = LINE_ENTRY(line)->maxFailure;5 	    fsmPtr->callbacks           = &cpPtr->callbacks;  	    e 	    break;i 	}     } /* end-for cpPtr */k       return;t }    * /* **++ **  FUNCTION NAME: ** **      fsm_sdata  ** **  FUNCTIONAL DESCRIPTION:* **I **      This routine is called to transmit a control protocol packet.  A  L **      transmit buffer is allocated to contain the control protocol packet.F **      If a transmit buffer can't be allocated that state machine is P **      terminated.  If the length of data to be transmitted is greater than the6 **      MTU for the line, the data will be truncated.  ** **  FORMAL PARAMETERS: **3 **      f        Pointer to state machine structureoI **      code     Type of control protocol packet (e.g. Configure-Reuqest) * **      id       Identifier for the packet3 **      data     Pointer to the data for the packet)) **      datalen  Length of the data fieldo ** **  IMPLICIT INPUTS: **
 **      None.r ** **  IMPLICIT OUTPUTS:i **
 **      None.t **& **  function value or completion codes **
 **      None.e ** **  SIDE EFFECTS:e **
 **      none.  ** **-- */E void fsm_sdata( fsm *f, int code, int id, u_char *data, int datalen )  {x?     PPPBuffer *bufPtr;		/* Pointer a buffer for the transmit */r=     u_char    *outp;		/* Pointer to data area of buffer    */d>     u_short   outlen;		/* Length of control packet          */  !     outlen = datalen + HEADERLEN;h  ,     /* allocate a buffer for the transmit */H     bufPtr = BUF_ALLOC( datalen + PPP_HDRLEN + HEADERLEN + PPP_FCSLEN );       if ( bufPtr != NULL_BUF )      {e& 	/* leave room for header in buffer */& 	BUF_DATA_TRIM( bufPtr, PPP_HDRLEN );  	a+ 	/* leave room at back of buffer for FCS */ ( 	BUF_DATA_TRIM( bufPtr, -(PPP_FCSLEN) );  ' 	/* adjust data length if neccessary */ - 	if ( datalen > LCP_GOTOPTIONS(f->line).mru )  	{9 	    datalen =  LCP_GOTOPTIONS(f->line).mru  - HEADERLEN;* 	}  / 	/* copy in code, id, length and data fields */   	outp = BUF_DATA_PTR( bufPtr );  	PUTCHAR(code, outp);* 	PUTCHAR(id, outp);o 	PUTSHORT(outlen, outp);   	/* copy in data */a 	BCOPY( data, outp, datalen );   	/* send buffer to device */0 	deviceTransmit( f->line, f->protocol, bufPtr );> 	FSMDEBUG((f, LOG_INFO, "fsm_sdata(%s): Sent code %d, id %d.",( 		            PROTO_NAME(f), code, id));     } /*else-if bufPtr */p     else     {>; 	/* couldn't allocate a buffer - kill this state machine */a 	fsm_finished( f );l     } /* end-if bufPtr */r     return;i }      = /* **++ **  FUNCTION NAME: ** **      fsm_finished ** **  FUNCTIONAL DESCRIPTION:  **@ **      This routine implements the "this layer finished" action! **      of the PPP state machine.s ** **  FORMAL PARAMETERS: **4 **      fsmPtr    Pointer to state machine structure ** **  IMPLICIT INPUTS: **
 **      None.r ** **  IMPLICIT OUTPUTS:c **
 **      None.  **& **  function value or completion codes **
 **      None.> ** **  SIDE EFFECTS:= **
 **      None.r ** **-- */  void fsm_finished( fsm *fsmPtr ) {a     /* inform client */L.     (*fsmPtr->callbacks->close)(fsmPtr->unit);       /* tell ports it's over */-     VCINCPEvent( fsmPtr->port, NCPFinished );m              return;r }a   k /* **++ **  FUNCTION NAME: ** **      fsm_startl ** **  FUNCTIONAL DESCRIPTION:  **M **      This function is called to when a client accepts a request to start a,M **      connection.   The client's identifier for the connection is saved andx' **      the state machine kick started.l ** **  FORMAL PARAMETERS: **= **      fsmRef    State machine reference for this connection;< **      unit      Client's identifier for the connection.    ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:; **
 **      None.= **& **  function value or completion codes ** **      None ** **  SIDE EFFECTS:I **
 **      None.  ** **-- */( void fsm_start( void *fsmRef, int unit ) {                 L     fsm *fsmPtr = fsmRef; /* Pointer to allocated state machine structure */       fsmPtr->unit = unit;     fsm_open( fsmPtr );l     return;l }    e /* **++ **  FUNCTION NAME: ** **      fsm_startNCP ** **  FUNCTIONAL DESCRIPTION:  **O **      This function is called to initiate actions to start a control protocoloM **      The linked list of registered control protocols is scanned to findingeL **      the entry matching this control protocol.  The client is then calledN **      via it's open routine to notify it of the request to start the control **      protocol.; **L **      NOTE:  This function requires that a control protocol is registered 9 **      This function doe snot verify this is the case.  i ** **  FORMAL PARAMETERS: **E **      fsmPtr          Pointer to allocated state machine structure.cA **      line            line control protocol is being started onh9 **      port            Port to start control protocol ons? **      ctrlProtocol    Number of the control protocol to start  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:i **
 **      None.o **& **  function value or completion codes ** **      None ** **  SIDE EFFECTS:o **
 **      None.  ** **-- */S void fsm_startNCP( fsm *fsmPtr, lineId line, PPPPort *port, u_short ctrlProtocol  )e { "     /* initialise fsm structure */1     fsm_init( fsmPtr, line, port, ctrlProtocol );L  3     /* tell client that we have a new connection */t;     (*fsmPtr->callbacks->open)(fsmPtr, fsmPtr->port->vcib);           return;> }      /* **++ **  FUNCTION NAME: ** **      fsm_stop ** **  FUNCTIONAL DESCRIPTION:  **L **      The routine is called by a client to stop a control protocol running **      on a single connection.  ** **  FORMAL PARAMETERS: **< **      fsmRef   State machine reference for this connection ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:t **
 **      None.x **& **  function value or completion codes **
 **      None.e ** **  SIDE EFFECTS:  **
 **      None.u ** **-- */ void fsm_stop( void *fsmRef )  { B     fsm *fsmPtr = fsmRef;       /* pointer to the state machine */A     int state = fsmPtr->state;	/* state of the fsm             */   2     if  ( state == REQSENT || state == ACKRCVD || 0           state == OPENED  || state == ACKSENT )     {P 	fsm_close( fsmPtr );      }      else     {r) 	VCINCPEvent( fsmPtr->port, NCPStopped );r     }n 	e     return;a }      /* **++ **  FUNCTION NAME: ** **      fsm_stopNCP  ** **  FUNCTIONAL DESCRIPTION:L **L **      This routine is terminate a control protocol.  The state machine is  **      called and if the  p ** **  FORMAL PARAMETERS: **6 **      fsmPtr    Pointer to a state machine structureK **      pending   TRUE  The stopping of the control protocol isn't finished < **                FALSE The control protcol has been stopped ** **  IMPLICIT INPUTS: **
 **      None.* ** **  IMPLICIT OUTPUTS:_ **
 **      None./ **& **  function value or completion codes **
 **      None.r ** **  SIDE EFFECTS:o **
 **      None.  ** **-- *// void fsm_stopNCP( fsm *fsmPtr, u_int *pending )o {r5     int state = fsmPtr->state;	/* state of the fsm */c       fsm_close( fsmPtr );         /*  B      ** Depending on the state of the fsm we can inform the clientB      ** immediately that the connection is gone or we have to wait)      ** until the connection is finished.>      */a4     if  ( !(state == REQSENT || state == ACKRCVD || , 	    state == OPENED  || state == ACKSENT) )     {R 	*pending = FALSE;   	/* inform client */+ 	(*fsmPtr->callbacks->close)(fsmPtr->unit);*       }      else     {e 	*pending = TRUE;h     }      return;f }*     /* **++ **  FUNCTION NAME: ** **      fsm_up ** **  FUNCTIONAL DESCRIPTION:e **G **      The routine handles a transition of the state machine into the M **      OPENED state.* ** **  FORMAL PARAMETERS: **7 **      fsmPtr    Pointer to a state machien structure.E ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:) **
 **      None.o **& **  function value or completion codes **
 **      None.P ** **  SIDE EFFECTS:  **
 **      None.o ** **-- */ void fsm_up( fsm *fsmPtr ) {n'     /* tell port control protocol up */e'     VCINCPEvent( fsmPtr->port, NCPUp );e  )     /* tell client control protocol up */:$     if (fsmPtr->callbacks->clientUp)     {S. 	(*fsmPtr->callbacks->clientUp)(fsmPtr->unit);     }a          return;e }T