#include <stdio.h>


char *h_news[] = {
 "                 RELEASE NOTES FOR THE PINE MESSAGE SYSTEM",
"                Version 3.91 (built ___cdate)",
"                         University of Washington",
"                               October, 1994",
" ",
" ",
"TABLE OF CONTENTS",
"        (1) Summary of Recent Changes",
"        (2) PC-Pine Notes",
"        (3) Configuration",
"        (4) Coming Attractions",
"        (5) History",
"        (6) Credits",
"        (7) Legal Notices",
" ",
"---------------------------------",
"| (1) Summary of Recent Changes |                                               ",
"---------------------------------",
" ",
"Changes since pine 3.90.",
" ",
"Pine 3.91 is primarily a bug-fix release, to correct many (but not all)",
"of the problems reported with version 3.90.  ",
" ",
"IMPORTANT NOTE: if you are plagued by messages saying ^X or ^Q not",
"defined, or printers losing parts of messages sent from Pine, then set the",
"new feature:  \"preserve-start-stop-characters\" .  This is needed",
"whenever your printer, modem, or async communications program is",
"configured to use software flow control.  Note that setting this feature",
"will result in Pine appearing to \"hang\" if you accidentally type a ^S. ",
"The remedy for this situation is to type a ^Q.",
" ",
"Some of the more important bug fixes in 3.91:",
" ",
" o Several address book bugs, including one that could destroy data.",
" o Several problems in handling mailcap files.",
" o Found bug that caused pine-debug files to grow forever.",
" o Custom-header entries may now contain colons.",
" o If read-msg-folder is set, Pine no longer crashes.",
" o Several other bugs resulting in program crashes.",
" o Environment variables may be used in Config entries.",
" o Improvements in signal handling to prevent some loops.",
" o Improvements in user-domain processing.",
" o Inability of PC-Pine for Winsock to send mail if timezone set.",
" ",
"In addition to these and more than one hundred other bug fixes, there are ",
"four new features included:",
" ",
" preserve-start-stop-characters",
"    -> Needed when modems or printers use software (XON/XOFF) flow control",
" news-approximates-new-status",
"    -> Marks more-or-less-recent news messages as \"New\"",
" compose-rejects-unqualified-addrs",
"    -> Used to minimize address errors by rejecting unqualified addresses.",
" quell-user-lookup-in-passwd-file",
"    -> Used to avoid incorrect Full Name address info in certain situations.",
" ",
"This last one supersedes a feature that was just introduced in 3.90:",
" ",
"  user-lookup-even-if-domain-mismatch",
" ",
"which is now obsolete.  These new features are all set via the Setup/Config ",
"menu.  For additional information, highlight the feature name in the Config ",
"screen and enter \"?\" for Help.",
" ",
"Finally, two new features for PC-Pine for Winsock (only):",
" ",
" o Improved Windows-style cut/paste (but no drag scrolling).",
" o Ability to use an alternate editor.",
" ",
"Changes since Pine 3.89.",
" ",
" o Finished all the \"Not implemented yet\" commands:",
"        -Bounce             (Remail)",
"        -Flag               (Set message status)",
"        -Pipe               (Pipe msg to external cmd; Unix only)",
"        -Select,Apply,Zoom  (Aggregate operations)",
"        -Setup/Config       (Pinerc configuration screen)",
" o News posting.",
" o News subscription/unsubscription.",
" o Multiple address books.",
" o Postpone multiple messages.",
" o Customizable headers for Composer.",
" o Mailcap support.",
" o Improved support for multiple incoming message folders.",
" o enable-alternate-editor-implicitly feature (except for editing headers).",
" o All .pinerc features now settable from command line.",
" o Way to control which options are user-configurable (Unix only).",
" o Way to have Save *not* implicitly delete.",
" o Way to use current-working-directory for Export, Read File, etc.",
" o A *preliminary* version of PC-Pine for Windows/Winsock.",
"   (Alas, it doesn't work on OS/2 yet.)",
" ",
"Beginning with Pine 3.90 there will also be an additional file created for",
"each address book the first time you use it.  It has the same name as the",
"address book but with the suffix \".lu\" added.  It helps speed up lookups",
"while you are composing messages.  Do not edit or remove any of these",
"\".lu\" files.  If the .lu index file cannot be created in the directory ",
"containing the address book, Pine will attempt to create it in a ",
"temporary directory.",
" ",
"NOTE: Comments in your .pinerc file are now very much out of date. With",
"the advent of the builtin SETUP CONFIGURATION screen, we hope you won't need to",
"look at those comments any more, but we nevertheless encourage you to",
"run the following command to update those comments: pine -pinerc .pinerc",
" ",
"Changes Since Pine 3.07. ",
" ",
"For some of you, Pine 3.90 may be the first version of Pine you have used since ",
"Pine 3.07, which is now quite ancient.  There have been literally hundreds of ",
"changes since then, but a few that may surprise you are listed below.  These ",
"user-interface changes were needed to allow for new features:",
" o Print is now \"Y\" instead of \"L\"",
" o The Folder List is now uniformly accessible via \"L\"",
" o Viewing/saving attachments is now done via \"V\" instead of \"A\"",
" o SortIndex is now \"$\" instead of \"Z\"",
" o pinerc features may now be set via the Setup/Config screen",
" ",
"---------------------",
"| (2) PC-PINE NOTES |",
"---------------------",
" ",
"PC-Pine is now available for Windows/Winsock as well as the following DOS ",
"versions: packet driver, Novell LWP, FTP PC-TCP, Sun PC-NFS.",
"There are several characteristics of PC-Pine that should be noted:",
"   o There is no spelling checker.",
"   o The unix-pipe-cmd function is not available.",
"   o Sorting the Index (by other than Arrival) is slow.",
"   o Performance optimization still needs to be done.",
" ",
"Some specific limitations of the DOS version (these do not apply to",
"the Windows/Winsock version of PC-Pine):",
"   o Alternate editor function is not available.",
"   o Memory: the DOS version needs about 500K out of 640K.",
"   o The DOS version can't run image viewer from within Pine, due to memory.",
"   o Messages (excluding attachments) must fit in DOS memory;",
"        However, attachments may be any size.",
" ",
"Additional notes:",
" ",
"-The Windows/Winsock version of PC-Pine is NOT a full GUI Windows ",
" application.  It has the same character-oriented user interface as",
" Unix Pine and PC-Pine for DOS, but with a few Windows-specific features",
" such as a resizable window.  However, as with PC-Pine for DOS, you ",
" can use the mouse to select commands or messages in the Index, or to",
" move the cursor in the composer.  The big advantage is that PC-Pine ",
" for Winsock runs as a true Windows application, so it doesn't have the ",
" DOS memory limitations, and of course it uses the Winsock network ",
" interface. ",
" ",
"-Performance optimization has still not been done.  This will be most",
" noticeable when using NNTP to access newsgroups, or when Index screens are",
" redrawn while using PC-Pine over low-speed lines (via SLIP or PPP).",
" Encoding a decoding attachments is also very slow in this version.",
" ",
"-While message folders may be either local or remote, several support",
" files must be available on the local disk.  In particular your",
" PINERC config file, ADDRBOOK, NEWSRC, and PINE.SIG your signature file.",
" Other files (postponed and interrupted messages, debug files) are also",
" stored locally.  Some users of both PC-Pine and Unix Pine must worry ",
" about keeping their pinerc, address book, and newsrc files in sync.   ",
" This may be done using remote file system protocols or manual copying.  ",
" (Remote access to these support files is planned for the future.)",
" ",
"-The PC-PINE message folder format is based on byte-counts for maximum",
" efficiency, so they must not be edited. The format is non-standard, but",
" conversion utilities would not be difficult. This format is supported in",
" Unix Pine as well.  PC-Pine can also open Unix-style folders for ",
" READ-ONLY access.",
" ",
"-PC-Pine mouse support is not yet available on some screens",
" ",
"-Don't expect to display a picture without exiting PC-Pine for DOS, due",
" to DOS memory limitations.  In some configurations, there *may* be enough",
" memory for the viewer and a small image, but don't count on it.  With",
" PC-Pine for Windows/Winsock, the memory constraints are greatly",
" diminished, and viewing image attachments seems to work quite well.  We",
" have been testing with the \"lview\" package by Leonardo Loureiro, which",
" can be obtained from oak.oakland.edu or any other SimTel mirror site. ",
" ",
"---------------------",
"| (3) Configuration |",
"---------------------",
" ",
"Configuration precedence.",
" ",
"There are several levels of Pine configuration.  Configuration values at",
"a given level over-ride corresponding values at lower levels.  In order of",
"increasing precedence:",
" ",
" o built-in defaults.",
" o system-wide pine.conf file.",
" o personal .pinerc file (may be set via built-in Setup/Config menu.)",
" o command-line options.",
" o system-wide pine.conf.fixed file.",
" ",
"There is one exception to the rule that configuration values are replaced",
"by the value of the same option in a higher-precedence file:",
"the feature-list variable has values that are additive, but can be",
"negated by prepending \"no-\" in front of an individual feature name.",
" ",
"File name defaults.",
" ",
"Notes:",
" ",
"  <exe dir> = directory where pine.exe found.",
"  <pinerc dir> = directory where pinerc found.",
"  * = default file name is overridable in pinerc.",
"  $HOME, if not explicitly set, defaults to root of the current drive.",
"  $MAILCAPS, if set, is used in lieu of the default mailcap search paths.",
"  + between the mailcap paths implies that the two files are combined.",
"  ; between other default paths implies that the first one found is used.",
" ",
"PC-Pine:",
" executable     <DOS search path>\\pine.exe",
" help index     <exe dir>\\pine.ndx",
" help text      <exe dir>\\pine.hlp",
" ",
" pers config    $PINERC  ;  $HOME\\pine\\pinerc  ;  <exe dir>\\pinerc",
" global cfg     $PINECONF",
" ",
" password       <pinerc dir>\\pine.pwd",
" debug          <pinerc dir>\\pinedebg.txt",
" signature*     <pinerc dir>\\pine.sig",
" addressbook*   <pinerc dir>\\addrbook",
" addrbook lu    <pinerc dir>\\addrbook.lu       (appends .lu to addrbk name.)",
" sentmail*      $HOME\\mail\\sentmail.mtx",
" postponed*     $HOME\\mail\\postpond.mtx",
" interrupted    $HOME\\mail\\intruptd",
" newsrc*        $HOME\\newsrc  ;  <pinerc dir>\\newsrc",
" mailcap        <pinerc dir>\\mailcap  +  <exe dir>\\mailcap  ",
" ",
"Unix Pine:",
" ",
" executable     <Unix search path>/pine",
" persnl cfg     ~/.pinerc",
" global cfg     /usr/local/lib/pine.conf",
" fixed cfg      /usr/local/lib/pine.conf.fixed",
" local help     /usr/local/lib/pine.info",
" ",
" debug          ~/.pine-debug[n]",
" signature*     ~/.signature",
" addressbook*   ~/.addressbook",
" addrbook lu    ~/.addressbook.lu    (appends .lu to actual addrbk name.)",
" sentmail*      ~/mail/sent-mail",
" postponed*     ~/mail/postponed-msgs",
" interrupted    ~/.pine-interrupted-mail",
" newsrc*        ~/.newsrc",
" mailcap        ~/.mailcap  +  /etc/mailcap",
" ",
" lock files     /tmp/.\\usr\\spool\\mail\\xxxx",
" inbox          /usr/spool/mail/xxxx",
" password       /etc/passwd",
" ",
"Mailcap files.",
" ",
"Pine now honors the mailcap configuration system for specifying external",
"programs for handling attachments.  The mailcap file maps MIME attachment",
"types to the external programs loaded on your system which can display",
"and/or print the file.  A sample mailcap file comes bundled with the Pine",
"distribution.  It includes comments which explain the syntax you need to",
"use for mailcap.  With the mailcap file, any program (mail readers,",
"newsreaders, WWW clients) can use the same configuration for handling",
"MIME-encoded data.  ",
" ",
"Environment variables.",
" ",
"PC-Pine uses the following environment variables:",
" ",
"  PINERC      (Optional path to pinerc file.)",
"  PINECONF    (Optional path to global pine config file.)",
"  HOME",
"  TMP or TEMP",
"  COMSPEC",
"  MAILCAPS    (semicolon delimited list of path names to mailcap files)",
" ",
"Unix Pine uses the following environment variables:",
" ",
"  TERM        (Tells Pine what kind of terminal is being used.)",
"  DISPLAY     (Determines if Pine will try to display IMAGE attachments.)",
"  SHELL       (If not set, default is /bin/sh )",
"  MAILCAPS    (A semicolon delimited list of path names to mailcap files)",
" ",
"--------------------------",
"| (4) Coming Attractions |",
"--------------------------",
" ",
"NOT DONE, BUT WE WANT THEM AS MUCH AS YOU DO...",
" ",
" o Additional MIME support, esp. controlling file TYPING",
" o PEM and/or PGP support",
" o External directory services access",
" o Kerberos support",
" o RFC 1522 header encoding for 8bit character sets",
" o Location independence of support files ",
" o Offline support",
" o Hierarchy support (awaits IMAP4)",
" o Answered flag not set if Reply is postponed  (awaits IMAP4)",
" o Faster detection of folders with Recent messages (awaits IMAP4)",
" o Faster fetching of headers (awaits IMAP4)",
" o Determination of which flags are permanent (awaits IMAP4)",
" ",
"---------------",
"| (5) HISTORY |",
"---------------",
" ",
"Pine was originally conceived in 1989 as a simple, easy-to-use mailer for",
"administrative staff at the University of Washington in Seattle.  This",
"constituency had previously been using a very nice mail system derived",
"from UCLA's \"Ben\" mailer for the MVS operating system, but when the cost",
"of maintaining our MVS system became prohibitive, we needed to find a",
"Unix-based mailer that preserved the user-interface strengths of \"Ben\".",
"Our goal was to provide a mailer that naive users could use without fear",
"of making mistakes.  We wanted to cater to users who were less interested",
"in learning the mechanics of using electronic mail than in doing their",
"jobs; users who perhaps had some computer anxiety.  We felt the way to do",
"this was to have a system that didn't do surprising things and provided",
"immediate feedback on each operation; a mailer that had a limited set of",
"carefully-selected functions. ",
" ",
"At that time, we could not find any Unix mailer (commercial or freely",
"available) that met our requirements.  Consequently, we reluctantly",
"concluded that we would need to develop our own.  The Elm mailer seemed",
"like a reasonable starting point since its source code was freely",
"available, so we started modifying it.  Today there is virtually no Elm",
"code left, and Pine has evolved so that many \"power-user\" features may",
"be (optionally) enabled.  We have tried to remain true to our original",
"simplicity and ease-of-use goals by providing *optional* features for",
"sophisticated users.  In fact, if none of Pine's options are enabled, the",
"latest version has almost the same look-and-feel as the very first",
"version. ",
" ",
"One of the greatest problems with most mailers on Unix systems is the",
"editor.  One can normally choose between emacs and vi.  We experimented",
"with some versions of emacs and settled on a hacked version of micro",
"emacs. Eventually it became heavily modified and tightly integrated with",
"the rest of Pine.  One of the main features of having a tightly coupled",
"editor is that it can guide the user through editing the header of the",
"message, and Pine takes great care to do this.  A very simple and",
"efficient interface to the Unix spell command was also added.  The emacs-",
"style key bindings were retained, though most of the other wild and",
"wonderful emacs functions were not.  The Pine composition editor is also",
"available as a very simple stand alone editor named \"pico\". ",
" ",
"Also working at the University of Washington is the original author of the",
"Internet Message Access Protocol (IMAP).  IMAP is a functional superset of",
"POP, and provides a way to manipulate mailboxes on remote servers as if",
"they were local.  Specific advantages of IMAP over POP include: support",
"for inbox access from multiple computers, access to more than one remote",
"folder, selective access to MIME message parts, and support for",
"disconnected operation. ",
" ",
"Not long after the Pine project began, The IMAP author had finished",
"writing the \"c-client\" library as an interface to IMAP and as a switch",
"between drivers for IMAP mailboxes, Berkeley mail files and Tenex mail",
"files.  In time, \"c-client\" became a full messaging API with support for",
"RFC-822 parsing, MIME parsing and decoding, SMTP and NNTP drivers, and so",
"forth.  Great care was taken to make the code writing the mail files",
"robust against disks filling up, and inter-process locking in order to",
"guarantee mail file consistency.  It was clear that Pine would benefit",
"greatly from using the c-client to access mail storage so the original",
"low-level Elm code was replaced by calls to c-client library routines. ",
"Consequently Pine can write and access a variety of different mail file",
"formats and new ones can be added by creating a simple driver.  In",
"addition the c-client does a very careful job of doing all the RFC 822",
"header parsing and achieves the highest compliance with the RFC. ",
" ",
"Most of the work done on Pine from 6/92 to 6/93 focused on changes needed",
"to support a truly distributed electronic messaging environment (e.g.",
"remote folder manipulation), and getting Pine to run on DOS (which was a",
"*lot* of work).  The first version of PC-Pine (3.84) was released in July",
"1993, and included first steps toward integrating news and email access in",
"Pine. Doing the DOS port was very difficult for a variety of reasons, but",
"especially because of DOS memory management (or lack thereof).  However,",
"simply porting Pine 3.07 to DOS was not sufficient.  For a desktop mailer",
"such as PC-Pine to be useful at UW, it was necessary to fully support",
"access to existing *remote* saved-message folders, as well as local",
"(desktop) folders -- and of course, the remote INBOX.  Accomplishing this",
"required extensions to IMAP, a new version of the IMAPd server code, and",
"extensive work in Pine to support multiple collections of folders. ",
" ",
"The principal reason for porting Unix Pine to DOS was to obviate the need",
"for PC users to transfer files between their PC and the Unix system",
"running Pine.  Now it is possible to save messages directly to the PC's",
"filesystem, and to directly include PC files in outgoing messages.  And",
"with Pine's MIME capability, binary files (e.g. word processing documents,",
"spreadsheets, image files, executables) may be directly attached to your",
"messages. ",
" ",
"With Pine 3.90, significant new functionality has been added, notably",
"aggregate operations for manipulating groups of messages at once, the",
"first (alpha) release of PC-Pine for the Winsock network interface",
"standard, and greatly improved Usenet (News) support.  One of the early",
"interpretations of the name \"Pine\" was \"Pine Is No-longer Elm\"; today",
"a \"Program for Internet News and Email\" seems more apropos. ",
" ",
"Chronology of Pine versions:",
"  * denotes a version with major new features",
"  + denotes a version that proved to be long-lived/stable ",
" ",
"  Pine   3.91         Oct 11, 1994",
"* Pine   3.90         Aug 24, 1994   Major release: Winsock, News, AggrOps",
"+ Pine   3.89         Dec  7, 1993   Final bug-fix release of 3.8x series",
"  Pine   3.88         Nov 22, 1993",
"  Pine   3.87         Oct  8, 1993",
"  Pine   3.86         Oct  5, 1993",
"  Pine   3.85         Sep 21, 1993",
"  Pine   3.84         Jul 12, 1993",
"* Pine   3.83         Jun 17, 1993   Major release: includes DOS support",
"  Pine   3.81         Oct 16, 1992",
"  Pine   3.80         Oct  4, 1992   Merge of changes in 3.05, 3.73, 3.52",
" ",
"  Pine   3.73         Sep 17, 1992   Last BWC version, based on 3.5x",
"  Pine   3.52         Sep 17  1992",
"  Pine   3.51         Aug 31  1992   ",
"  Pine   3.51-haifa   Aug 08, 1992 ",
"  Pine   3.50         Jul 23  1992   BWC/Haifa branch, based on 3.03",
" ",
"+ Pine   3.07         Mar 30, 1993   Final bug-fix release of 3.0x series",
"  Pine   3.06         Sep 30, 1992",
"  Pine   3.05         Sep 11, 1992",
"  Pine   3.04         Sep  8, 1992",
"  Pine   3.03         Jul 20, 1992                       ",
"  Pine   3.02         Jul 15, 1992",
"  Pine   3.01         Jul 13, 1992",
"* Pine   3.00         Jul  6, 1992   Second source release; MIME support",
" ",
"  Pine   2.33         Jul  4, 1992",
"  Pine   2.32         Jul  2, 1992           ",
"  Pine   2.31         Jun 30, 1992",
"  Pine   2.30         Jun 29, 1992",
"  Pine   2.29         Jun 12, 1992",
"  Pine   2.28         Jun  2, 1992",
"  Pine   2.27         May 22, 1992",
"  Pine   2.26         May 15, 1992",
"  Pine   2.25         May 12, 1992",
"  Pine   2.24         May  1, 1992                          ",
"  Pine   2.21         Mar 25, 1992                          ",
"  Pine   2.20         Mar 25, 1992   First internal release with MIME",
"  Pine   2.15         Mar 17, 1992",
"  Pine   2.10         Feb 25, 1992      ",
"  Pine   2.4          Feb 28, 1992        ",
"  Pine   2.3          Feb 18, 1992",
"  Pine   2.2          Jan 31, 1992",
"  Pine   2.1          Jan 21, 1992",
"* Pine   2.0          Jan 15, 1992   First public source release; IMAP support",
" ",
"  Pine   1.0.26       Jan 13, 1992",
"  Pine   1.0.25       Jan 10, 1992",
"  Pine   1.0.24.1     Jan     1992",
"  Pine   1.0.23.1     Dec 31, 1991",
"  Pine   1.0.22.1     Nov 20, 1991",
"  Pine   1.0.21.1     Nov 14, 1991",
"  Pine   1.0.20.1     Nov 12, 1991",
"  Pine   1.0.19.1     Oct 26, 1991   Experimental newsreading via IMAP",
"  Pine   1.0.17.1     Sep 25, 1991 ",
"  Pine   1.0.16.100   Sep 23, 1991",
"  Pine   1.0.16.1     Sep 21, 1991",
"  Pine   1.0.15.150   Sep 20, 1991",
"  Pine   1.0.14.100   Sep  6, 1991",
"  Pine   1.0.3,       Apr 17, 1991   1.0 pre-release; has all 1.0 functions",
" ",
"  Pine   0.9.650      Mar 17, 1991",
"  Pine   0.9.650      Feb 25, 1991",
"  Pine   0.9.600      Feb 13, 1991",
"  Pine   0.9.500      Sep 25, 1990",
"  Pine   0.9.439      Aug 27, 1990",
"  Pine   0.9.42x      Jul 30, 1990",
"  Pine   0.9.40x      Jun 25, 1990",
"  Pine   0.9.31x      May 30, 1990   Design evaluation version",
"  Pine   0.6.273      Jan 05, 1990",
" ",
"---------------",
"| (6) CREDITS |",
"---------------",
" ",
"The University of Washington Pine development team (part of the UW Office",
"of Computing & Communications) includes:",
" ",
" Project Leader:           Mike Seibel.",
" Principal authors:        Mike Seibel, Steve Hubert, Laurence Lundblade*.",
" C-Client library & IMAPd: Mark Crispin.",
" Pico, the PIne COmposer:  Mike Seibel.",
" Bug triage, user support: David Miller.",
" Port integration:         David Miller.",
" Documentation:            Sheryl Erez, Kathryn Sharpe.",
" PC-Pine for DOS:          Mike Seibel.",
" PC-Pine for Windows:      Tom Unger.",
" Project oversight:        Terry Gray.",
" Principal Patrons:        Ron Johnson, Mike Bryant.",
" Additional support:       NorthWestNet.",
" Initial Pine code base:   Elm, by Dave Taylor & USENET Community Trust.",
" Initial Pico code base:   MicroEmacs 3.6, by Dave G. Conroy.",
" User Interface design:    Inspired by UCLA's \"Ben\" mailer for MVS.",
" ",
"   * Emeritus  (Laurence is now at Virginia Tech.)",
" ",
"We'd also like to acknowledge the following contributions and contributors:",
" Pine for VMS:  Portia Shao and Yehavi Bourvine",
" Special mention:   Dave Wall",
" Bug reports, bug fixes, ports, suggestions & encouragement:",
" ",
"The world-wide Pine community, including...",
" ",
"  Shoa Aminpour       Gordon Good        Richard Murphy",
"  J.J. Baily          Bob Gregory        Il Oh",
"  Billy Barron        Ed Greshko         Mike Ramey",
"  Chris Beecher       Dmitri L. Gringauz Phil Rand",
"  John Benjamins      David Halliwell    Jochiam Richter",
"  Birko Bergt         Peter Hausken      Thomas Riemer",
"  Ken Bobey           Jeff Hayward       Alexis Rosen",
"  Andy Brager         Ron Johnson        Michael Ross",
"  D.K. Brownlee       William Kreuter    Bob Sandstrom",
"  Brian Burriston     Pekka Kytolaakso   Michael F. Santangelo",
"  Bill Campbell       Barry Landy        Shin-ya Satoh",
"  Russel Campbell     Chris Latham       Corey Satten",
"  Donn Cave           Jon Lebo           Michael Shepard",
"  Richard Cheever     Allen Leonard      Alan Thew",
"  Mike Coghlan        Robert L. Lewis    Jason R. Thorpe",
"  Justine Comer       Bruce Lilly        Marc Unangst",
"  Chuck Cooper        Matthew Lyle       Edward Vielmetti",
"  Barry Cornelius     John Mackin        Ross Wakelin",
"  Tony Flemming       James Matheson     Rich Wales",
"  Matthew Freedman    Mark McNair        David Wall",
"  Richard Fritz       Pete Mellor        Bob Williams",
"  Marcelo A. Gallardo Dave Miller        Steve Woodyatt",
"  Adam Garrett        Robert Morris      Michael A. Crowley",
" ",
"And many others... Our thanks to all! ",
" ",
"Pine files and documentation are available via FTP or WWW: ",
"  ftp://ftp.cac.washington.edu/pine",
"  http://www.cac.washington.edu/pine",
" ",
"In particular, the latest version of Pine source code is available via",
"anonymous FTP from Internet host ftp.cac.washington.edu in the file",
"/pine/pine.tar.Z. ",
" ",
"Please send comments and correspondence to: pine@cac.washington.edu",
" ",
"---------------------",
"| (7) LEGAL NOTICES |",
"---------------------",
" ",
"Pine and Pico are trademarks of the University of Washington. No commercial",
"use of these trademarks may be made without prior written permission of the",
"University of Washington.",
" ",
"Pine and Pico software and its included text are Copyright 1989-1994 by the",
"University of Washington.",
" ",
"Permission to use, copy, modify, and distribute this software and its",
"documentation for any purpose and without fee to the University of",
"Washington is hereby granted, provided that the above copyright notice",
"appears in all copies and that both the above copyright notice and this",
"permission notice appear in supporting documentation, and that the name of",
"the University of Washington not be used in advertising or publicity",
"pertaining to distribution of the software without specific, written prior",
"permission.  This software is made available \"as is\", and",
" ",
"THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,",
"WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED",
"WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN",
"NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,",
"INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM",
"LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT",
"(INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION",
"WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.",
" ",
"<End of Release Notes>",
NULL
};


char *main_menu_tx[] = {
 "          GENERAL INFORMATION ON THE PINE MESSAGE SYSTEM",
"             Version 3.90 (built ___cdate)",
"                        University of Washington",
"                              August, 1994",
" ",
"TABLE OF CONTENTS",
"                ",
"        (1) Introduction",
"        (2) Pine Help",
"        (3) Local Support Contacts",
"        (4) Giving Commands in Pine",
"        (5) Status Line",
"        (6) Main Menu Commands",
"        (7) Command Line Options",
"        (8) Pine Configuration",
"        (9) Reading News",
"        (10) Reporting Problems",
" ",
"--------------------",
"| (1) Introduction |",
"--------------------",
" ",
"PINE(tm) is the University of Washington's \"Program for Internet News and",
"Email\".  It is intended to be an easy-to-use program for sending,",
"receiving, and filing Internet electronic mail messages and bulletin board",
"(Netnews) messages. Pine supports the following Internet protocols and",
"specifications:",
"                SMTP  - Simple Mail Transport Protocol",
"                NNTP  - Network News Transport Protocol",
"                MIME  - Multipurpose Internet Mail Extensions",
"                IMAP  - Internet Message Access Protocol",
" ",
"MIME allows you to attach any kind of file to your message, provided that",
"your recipient also has MIME-capable mail software (which is readily",
"available for most types of computers, although some proprietary mail",
"systems do not yet support MIME).  IMAP allows access to mailboxes on",
"remote mailservers as if they were local.",
" ",
"Although originally designed for novice email users, Pine has evolved to",
"support many advanced features.  There are an ever-growing number of",
"configuration and personal-preference options, though which of them are",
"available to you is determined by your local system managers.",
" ",
"-----------------",
"| (2) Pine Help |",
"-----------------",
" ",
"Pine help is context-sensitive.  In other words, each Pine screen you use",
"will have its own help text, explaining the choices available for that",
"screen.  This particular Help section is unusual in that it will not only",
"describe the specific commands available from the MAIN MENU, but also",
"provide an overview of Pine operation. ",
" ",
"In addition to this general help on Pine, Release Notes on the current",
"Pine version are also available from the MAIN MENU.  Press {F9:R} to",
"browse the release notes.  These include changes since the last release,",
"notes for PC-Pine, the history of the Pine project, credits, and legal",
"notices. ",
" ",
"Pine files and documentation are available via FTP or WWW: ",
"  ftp://ftp.cac.washington.edu/pine",
"  http://www.cac.washington.edu/pine",
" ",
"If you would like to print *all* of Pine's internal help text for a little",
"light bedtime reading, then press {F12:Z} now.  (This assumes that the ",
"copy of Pine you are using has been properly configured for printing ",
"at your site.)",
" ",
"------------------------------",
"| (3) Local Support Contacts |",
"------------------------------",
" ",
"___include /usr/local/lib/pine.info",
" ",
"        [ No local information available. ]",
" ",
"___end_include",
" ",
"-------------------------------",
"| (4) Giving Commands in Pine |",
"-------------------------------",
" ",
"COMMANDS: The bottom two lines of the screen are always used to list the",
"commands you can give.  You press the keys that are highlighted to give",
"the command.  The commands for getting help and going back to the main",
"menu are always present (except when viewing help as you are now). ",
" ",
"{:OTHER COMMANDS: The \"Other Commands\" function changes the keys you see} ",
"{:at the bottom of any screen.  In some cases there are 3 different pages} ",
"{:of keys which it toggles through.  ALL COMMANDS ARE ACTIVE, even if they} ",
"{:are not currently showing at the bottom of your screen.  In other words,} ",
"{:you NEVER need to prefix a command key with the 'O' key.}",
" ",
"{:CONTROL KEY:  When composing mail and in a few other places in Pine you} ",
"{:have to use Control keys which means pressing the control key and the } ",
"{:letter indicated at the same time.  This is usually shown with a \"^\" in} ",
"{:front of the letter.  On some systems, certain control characters are} ",
"{:intercepted before they get to Pine.  As a work-around, you can press} ",
"{:the ESCAPE key twice followed by the desired key.  For example, if } ",
"{:Control-O (^O) does not work on your system, try typing \"ESC ESC O\".}",
" ",
"PAGING UP/DOWN: The \"+\" and \"-\" keys are used for moving to the next",
"or previous page.  The space bar is a synonym for \"+\".  You may also use",
"Ctrl-V to page down and Ctrl-Y to page up as you do in the message",
"composer. ",
" ",
"RETURN KEY: The return key is usually a synonym for a frequently used",
"command.  When viewing a message, there is currently not a default",
"command, so RETURN does nothing; when in the index, it is synonymous with",
"\"view msg\". In the key menu at the bottom of the screen, whatever is",
"enclosed in square brackets [] is the same as the return key. ",
" ",
"CONTROL KEYS NOT USED BY PINE:  Most commands in Pine are single letters, ",
"with --we hope-- some mnemonic value, but in places where Pine is expecting ",
"text input, e.g. in the composer or at prompts for file/folder names, ",
"control keys must be used for editing and navigation functions.",
" ",
"Pine has used nearly all the control keys available.  There are, however,",
"certain control keys that are reserved by other programs or for technical",
"reasons.  Pine does not use any of these keys: ",
"                Ctrl-S    Used by Unix as \"stop output\"",
"                Ctrl-Q    Used by Unix as \"resume output\"",
"                Ctrl-]    Often used by Telnet as escape key",
"                Ctrl-\\   Often used by Unix as \"Abort\" ",
"                ESC       Conflicts with sequences used for arrow keys",
" ",
"Note: by default, Pine treats Ctrl-S or Ctrl-Q (sometimes known as XOFF",
"and XON), as normal characters, even though Pine does not use them. ",
"However, the printer, modem, or communication software you are using may",
"be configured for \"software flow control\" which means that XON/XOFF must",
"be treated as special characters by the operating system.  If you see",
"messages such as \"^X not defined for this screen\", or if messages",
"printed via the \"attached-to-ansi\" option are missing pieces, then your",
"system is probably using software flow control. In this case you will need",
"to set the \"preserve-start-stop-characters\" feature.  If you *do* set this",
"feature, be advised that if you accidentally hit a Ctrl-S, Pine will",
"mysteriously freeze up with no warning.  In this case, try typing a Ctrl-Q",
"and see if that puts things right. ",
" ",
"REPAINTING THE SCREEN: Sometimes what is displayed on the screen will be",
"incorrect due to noise on the phone line or other causes and you will want",
"to repaint the whole screen to make it correct.  You can use the Ctrl-L",
"command to do this.  It never hurts to do it when in doubt. ",
" ",
"-------------------",
"| (5) Status Line |",
"-------------------",
" ",
"The top line of the screen is Pine's status line.  It will always display",
"the current version of Pine and will also convey information about the",
"status of the program.  This is where you look to find out what",
"collection, folder and message number is active. ",
" ",
"If the top line says \"READONLY\" it means that the open folder (typically",
"your INBOX) is \"locked\" by another mail session -- most likely a more",
"recent session of Pine has taken the INBOX lock. ",
" ",
"If the top line says \"CLOSED\" it means that you are trying to access a",
"folder on a remote mail server, and for some reason, communication with",
"the mail server has either been lost, or never successfully established.",
"This can be a result of trying to open a non-existent folder, or one",
"stored on an invalid or non-operational server, or it can mean that Pine",
"has been suspended for more that 30 minutes while accessing a remote mail",
"server. ",
" ",
"--------------------------",
"| (6) Main Menu Commands |",
"--------------------------",
" ",
"{Available Commands -- Group 1          Available Commands -- Group 2   :General Pine Commands  MAIN MENU Screen Commands}",
"{------------------------------         ------------------------------  :---------------------  -------------------------}",
"{F1  Show this help text                F1  Show this help text         :?  Show help text      O  Show all Other available commands}",
"{F2  Show all other available commands  F2  Show other commands         :C  Compose a message   P  Select Previous command up on menu}",
"{F3  Quit Pine                                                          :I  FOLDER INDEX screen N  Select Next command down on menu}",
"{F4  Execute current MAIN MENU command  F4  Compose a message           :L  FOLDER LIST screen  R  Display Pine Release Notes}",
"{F5  Select previous command up on menu F5  FOLDER LIST screen          :A  ADDRESS BOOK screen K  Lock Keyboard }",
"{F6  Select next command down on menu   F6  Goto a specified folder     :S  SETUP functions     G  Goto a specified folder}",
"{                                       F7  FOLDER INDEX screen         :Q  Quit Pine}",
"{F9  Display Pine release notes         F9  SETUP menus :}",
"{F10 Lock keyboard                      F10 ADDRESS BOOK screen :}",
" ",
"NOTE: The availability of certain commands (e.g. some of the options under",
"SETUP) is determined by Pine configuration files and system capabilities.",
"At some sites, certain commands may not be available due to security or",
"support concerns. ",
" ",
"The \"COMPOSE MESSAGE\" command (available on MAIN MENU, FOLDER LIST,",
"FOLDER INDEX, and MESSAGE TEXT screens) takes you into the Pine message",
"composer and permits you to create and send a new message. ",
" ",
"The \"FOLDER INDEX\" command (available on MAIN MENU, FOLDER LIST, and",
"MESSAGE TEXT screens) takes you to the FOLDER INDEX screen which displays",
"a summary caption for each message in the currently-open folder. One",
"message will be highlighted; this is the \"Current\" message.  The message",
"commands available from this screen (e.g. View, Reply, Forward, Delete,",
"Print, Save, etc) apply to the current message. ",
" ",
"The \"FOLDER LIST\" command (available on MAIN MENU, FOLDER INDEX, and",
"MESSAGE TEXT screens) takes you to the FOLDER LIST screen which displays",
"the names of all your message folders and allows you to view, rename,",
"delete, and add folders.  You can open (view) a different folder than the",
"one currently open by highlighting the desired one (using the arrow keys",
"or their control-key equivalents) and pressing RETURN.  If you have",
"multiple folder collections defined (See the Help text for the FOLDER LIST",
"screen to learn more about Collections), you may need to press RETURN to",
"expand the collection and display all of the folders in it. ",
" ",
"The \"ADDRESS BOOK\" command (available only from the MAIN MENU) takes you",
"to the ADDRESS BOOK management screen.  From here, your personal address",
"book(s) may be updated. ",
" ",
"The \"SETUP\" command (available only from the MAIN MENU) prompts you for",
"one of several configuration screens, including the SETUP CONFIGURATION screen,",
"by which you may activate optional Pine features. ",
" ",
"Also available from the Main Menu, but only displayed on the Key Menus at",
"the bottom of the screen, are the following commands. ",
" ",
"The \"Goto\" command (available on MAIN MENU, FOLDER LIST, FOLDER INDEX,",
"and MESSAGE TEXT screens) lets you jump directly to a new folder without",
"having to use the Folder List display. It will prompt you for the name of",
"the desired folder, and if you have multiple folder collections defined,",
"allow you to rotate thru them.  However, if the folder is outside of your",
"defined collections, you are going to have to enter the exact folder",
"location using the correct syntax for a remote folder and/or",
"fully-qualified path name. ",
" ",
"The \"Release Notes\" command displays information about this version of ",
"Pine, as well as historical and legal notes.",
" ",
"The \"Keyboard Lock\" command allows your Pine session to be protected ",
"during a temporary absence from your terminal.",
" ",
"The \"Report Bug\" command does the obvious thing; please see section (10)",
"below.  This command is also available from any help screen (including ",
"this one.)",
" ",
"----------------------------",
"| (7) Command Line Options |",
"----------------------------",
" ",
"Possible Starting Arguments for Pine program:",
" ",
"        Argument                Meaning",
" ",
"        <address>...    Go directly into composer with given address",
"        -a              Special anonymous mode for UWIN*",
"        -d n            Debug - set debug level to 'n'",
"        -f <folder>     Folder - open <folder> in default collection",
"        -F <file>       File - open and view text <file>",
"        -h              Help - give this list of options",
"        -i              Index - Go directly to index, bypassing main menu",
"        -I <key_list>   Initial keystrokes to be executed",
"        -k              Keys - Force use of function keys",
"        -l              List - Expand List of folder collections by default",
"        -n <number>     Entry in index to begin on",
"        -nr             Special restricted mode for UWIN*",
"        -o              ReadOnly - Open first folder read-only",
"        -p <file>       Use <file> in place of .pinerc file",
"        -P <file>       Use <file> in place of pine.conf file ",
"        -r              Restricted/demo mode",
"        -z              Suspend - allow use of ^Z suspension",
"        -sort <sort>    Sort - Specify sort order of Folder Index:",
"                   (Subject, OrderedSubj, Arrival, Date, From, Size, /reverse)",
"        -conf           Configuration - Output fresh global config to stdout",
"        -create_lu <addrbk> <sort>  Create auxiliary look-up file and",
"                        sort <addrbk> by <sort>.  For creating global addrbk.",
"        -pinerc <file>  Configuration - Put fresh pinerc config in <file>",
"        -<option>=<value>       Assign <value> to the pinerc option <option>",
"                                e.g. -signature-file=sig1",
"                                (Note: feature-list is additive)",
" ",
"                     * UWIN = University of Washington Information Navigator",
" ",
"--------------------------",
"| (8) Pine Configuration |",
"--------------------------",
" ",
"Unless it has been administratively disabled, the Setup command on the",
"MAIN MENU has a \"Config\" subcommand which will allow you to modify",
"Pine's behavior by setting or unsetting various features, defining folder",
"collections, etc.  These settings are stored in your personal \"pinerc\"",
"configuration file, but on shared systems these settings may be",
"over-ridden by a system-wide control file (due to local site security or",
"support policies).  A global pine configuration file can also be used to",
"set default values for all Pine users on a particular system. ",
" ",
"--------------------",
"| (9) Reading News |",
"--------------------",
" ",
"BACKGROUND",
" ",
"Pine can read and post Internet news (NetNews or USENET) groups, using the",
"same commands as for mail.  If you do not already have a news state",
"(\"newsrc\") file, Pine will create one for you, and you can add newsgroups",
"to it using the \"Add\" command in the FOLDER LIST screen. Pine can use the",
"same newsrc as other Unix newsreaders, thus allowing you to switch between",
"Pine and other newsreaders; however, Pine uses the information in the file",
"in a slightly different way than other newsreaders.",
" ",
"CONFIGURATION",
" ",
"Pine can access news folders in any one of three different ways: ",
" ",
"        REMOTE NNTP:  Using the Network News Transport Protocol (NNTP) to",
"access news on a remote news server.  In this case the newsrc file is",
"stored on the machine where Pine is running.  Simply specify the name of",
"the news server as your nntp-server: ",
"                nntp-server      = news.nowhere.edu",
"If you do this (and do not explicitly set the news-collections variable),",
"Pine will automatically use *{{:{}news.nowhere.edu}[] for the value of",
"the news-collections variable.",
" ",
"        REMOTE IMAP:  Using the Internet Message Access Protocol (IMAP) to",
"access news on a remote news server.  In this case, your newsrc file is",
"stored on the news server, in your home directory, so you must have an",
"account on the news server, but you would be running Pine on a different",
"machine.  The news server must be running an IMAPd server process. Specify",
"a remote news-collection in the SETUP CONFIGURATION: ",
"                news-collections = News *{{:{}news.nowhere.edu}[]",
" ",
"        LOCAL:  Using local file access to the news database.  In this",
"case, your newsrc file is stored on the news server, in your home",
"directory, so you must have an account on the news server, and you would",
"be running Pine on the same machine.  Specify a local news-collection in",
"the SETUP CONFIGURATION: ",
"                news-collections = News *[]",
" ",
"In the first two examples, the hostname \"news.nowhere.edu\" should be",
"replaced with the domain name of your local news server.  For Unix Pine,",
"these entries can be placed in either the system-wide or your personal",
"configuration file. ",
" ",
"If you are a PC-Pine user, either option 1 (NNTP) or option 2 (IMAP) is",
"possible.  If you don't have an account on the news server, or if the news",
"server is not running an IMAP daemon, then you must use NNTP.  In",
"this case, your Unix .newsrc file can be transferred to your PC.  A good",
"place to put it would be in the same directory as your PINERC file, under ",
"the name \\NEWSRC, but you can specify a different location via Pine's ",
"Setup/Config screen.",
" ",
"A future version of PC-Pine will be able to access and update a newsrc",
"file stored on a Unix host, so that it will be possible to alternate",
"between PC-Pine and Unix-based newsreaders. ",
" ",
"READING NEWS ",
" ",
"Once defined in the .pinerc (or the global pine.conf) file, the news",
"folder collection can be accessed either via the FOLDER LIST screen, or",
"via the GOTO command. ",
" ",
"Pine uses the same commands for manipulating news folders as for mail",
"folders.  This means, for example, that when you are done with a message,",
"you would use \"D\" to mark it as Deleted (or Dismissed, if you prefer.)",
"This \"mail like\" behavior differs from that of most newsreaders, wherein",
"a message is implicitly dismissed after you have looked at it once. We",
"strongly believe that Pine should offer as much consistency as possible",
"between mail and news, so the mail paradigm --wherein a message does not",
"magically disappear without explicit action by the user-- is used for news",
"as well.  ",
" ",
"News folders are actually Read-Only, but the newsrc file allows Pine to",
"keep track of which messages you have dismissed (marked as Deleted) just",
"as in a regular mail folder. The difference is that, although messages",
"marked as Deleted will show up in the Index (just as mail messages do",
"until an eXpunge), you cannot expunge news messages.  However, you can use",
"the \"eXclude\" (X) command in order to suppress from the Folder Index",
"messages that are so marked.  Also, whenever you open a newsgroup folder,",
"messages marked Deleted are already excluded from the Index by default. ",
"The \"unexclude\" (&) command will restore them to the Folder Index. ",
" ",
"If you answer a message in a news folder, the index view will show the",
"\"A\" flag as usual; but the newsrc file has no way of storing this flag,",
"so it will not be preserved across sessions.  The Deleted flag is the only",
"one that is preserved between sessions.  If you Reply to a newsgroup",
"message and say you want to reply to all recipients, Pine will ask if ",
"you want to post the message to all the newsgroups listed in the original ",
"message. ",
" ",
"If you would like Pine to mark more-or-less recent news messages as",
"\"New\", then set the \"news-approximates-new-status\" feature.  This will",
"cause messages since the last one you have marked as Deleted to appear",
"with \"N\" status in the Folder Index, and therefore often makes it easier",
"to distinguish later news articles from those you've previously seen, but",
"not yet disposed of via the \"D\" key.  Note that this is an approximation, ",
"not an exact record of which messages you have not seen. ",
" ",
"A frequent operation in news-reading is \"catching up\"... that is, ",
"getting rid of all the messages in the news group so that you can \"start",
"fresh\".  At the moment, the easiest way to do this in Pine is via the",
"Select command.  You would enter the following four keystrokes: ;aad",
"Note that the \"enable-aggregate-command-set\" feature must be enabled ",
"before you can use the Select command.",
" ",
"--------------------------- ",
"| (10) Reporting Problems | ",
"--------------------------- ",
" ",
"There are now hundreds of thousands of Pine users in over 40 countries.",
"The Pine development team has no funding to provide support to anyone",
"outside of the University of Washington.  However, we certainly want Pine",
"to be the best tool it can be, so we do want to know about problems. We",
"ask that you first read the relevant help screens, if any, and then seek",
"assistance from your own support staff.  Once you are sure that your",
"difficulty is not a local configuration problem, use the \"{F11:B} Report",
"Bug\" command (available from any HELP screen) to let us know about it. ",
" ",
"Please note: the VMS ports of Pine were not done at UW, so you will",
"probably need to contact their authors directly for assistance. ",
" ",
"We also welcome comments and suggestions for improving Pine.  When",
"reporting a bug, please include the type of computer and operating system",
"you are using if at all possible.  ",
" ",
"                        Pine Development Team <pine@cac.washington.edu> ",
"                        Office of Computing & Communications",
"                        University of Washington",
"                        Seattle, WA  98195",
" ",
"<End of Main Menu Help>",
NULL
};


char *h_mail_index[] = {
 "                         FOLDER INDEX COMMANDS",
"{Available  Commands -- Group 1         Available Commands -- Group 2         :Navigating the List of Messages             Operations on the Current Message}",
"{-------------------------------        -----------------------------         :-------------------------------             ---------------------------------}",
"{F1  Show Help Text                     F1  Show Help Text                    : P   Move to the previous message           V  View                 Y  Print}",
"{F2  Toggle to see more commands        F2  Toggle to see more commands       : N   Move to the next message               R  Reply to message     F  Forward}",
"{F3  MAIN MENU Screen                   F3  Quit Pine                         : -   Show previous screen of messages       D  Mark for deletion      }",
"{F4  View current message               F4  Compose a message                 :Spc  Show next screen of messages           U  Undelete (remove deletion mark)}",
"{F5  Move to previous message           F5  FOLDER LIST screen                : J   Jump to a specific message             T  Take Address into Address Book}",
"{F6  Move to next message               F6  Goto a specified folder           : W   Whereis -- search for a                S  Save into an email folder} ",
"{F7  Show previous screen of messages   F7  Zoom                              :     specific message                       E  Export as a plain text file}",
"{F8  Show next screen of messages       F8  Whereis                           : |   Pipe to a Unix Command                 B  Bounce               *  Flag}",
"{F9  Mark message for deletion          F9  Print message                     :Miscellaneous Operations}",
"{F10 Undelete (remove delete mark)      F10 Take address into address book    :----------------------------}",
"{F11 Reply to message                   F11 Save message into an email folder : G   Goto a specified folder     General Pine Commands }",
"{F12 Forward                            F12 Export message into a plain file  : $   Sort order of index         --------------------- }",
"{                                                                             : H   Full header mode            O  Show all other available commands }",
"{Available Commands -- Group 3                                                : X   Expunge/Exclude             ?  Show Help text     Q Quit Pine }",
"{------------------------------                                               : Z   Zoom          A Apply       M  MAIN MENU Screen   L FOLDER LIST screen}",
"{F3  Expunge/Exclude        F7 Jump to message   F10 Bounce (remail) msg      :Tab  Next-New      ; Select      C  Compose a new message }",
"{F4  Select     F5  Apply   F8 Next New          F11 Flag message as important:}",
"{F6  Sort order of index    F9 Full Header Mode  F12 Pipe to a Unix command   :}",
" ",
"NOTE: The presence or absence of the following commands is determined by",
"\"feature-list\" options in your Pine configuration.  Also, some of these",
"commands may be administratively disabled by your system manager; if they",
"don't work, please check with your local help desk before reporting a bug. ",
" ",
"    o Header Mode (toggle between display of full or minimal headers)",
"    o Select (tag messages for aggregate operations)",
"    o Apply (apply a command to multiple previously-selected messages)",
"    o Flag (mark message as important or set other message status flags)",
"    o Zoom (show only pre-selected messages)",
"    o Bounce (re-mail message to correct recipient)",
"    o Pipe message to a Unix command",
" ",
"The \"Pipe message to a Unix command\" command is not available in PC-Pine.",
" ",
"-------------------------------------------",
"| Description of the FOLDER INDEX Screen  |",
"-------------------------------------------",
" ",
"The Folder Index displays the headers or summary information of each",
"message in the current folder.  This is useful if you want to quickly scan",
"new messages, or find a particular message without having to go through",
"the text of each message, or to quickly get rid of junk messages, etc.  If",
"the list is too long to fit on one screen, you can page up and down in the",
"list with the {F7:-}/{F8:SPACE} commands.  The current message is always",
"highlighted, and its message number is shown in the status line.  Each",
"message line contains the following columns: ",
" ",
"  STATUS: The markings on the left side of the message tell you about its",
"status.  You may see one or more of the following codes on any given",
"message: ",
" ",
"   o \"D\" for Deleted.  You have marked this message for deletion but not",
"         yet eXpunged the folder.",
"   o \"N\" for New.  You have not looked at the text of the message yet.",
"   o \"A\" for Answered.  Any time you reply to a message it is considered",
"         to be answered.",
"   o \"+\" for direct-to-you.  The \"+\" indicates that a message was sent ",
"        directly to your account, your copy is not part of a cc: or a ",
"        mailing list.",
"   o \"X\" for selected.  You have selected the message by using the ",
"        \"select\" command.  (Some systems may optionally allow selected ",
"        messages to be denoted by the index line being displayed in bold",
"        type.)",
"   o \"*\" for Important.  You have previously used the \"Flag\" command",
"      to mark this message as \"important\".",
" ",
"  NUMBER: Messages in a folder are numbered, from one through the number",
"of messages in the folder, to help you know where you are in the folder. ",
" ",
"  DATE SENT: The date the message was sent.  By default, messages are",
"ordered by arrival time, not by date sent.  Most of the time arrival time",
"and date sent (effectively departure time) are similar.  Sometimes,",
"however, the index will appear to be out of order because a message took a",
"long time in delivery. ",
" ",
"  SENDER: The name or email address of the sender.  If you are the ",
"          sender, then the first recipient's name is shown here.",
" ",
"  SIZE: The number in parentheses is the number of characters in the message.",
" ",
"  SUBJECT: As much of the message's subject line as will fit on the screen.",
" ",
"------------------------------",
"| Brief Command Explanations |",
"------------------------------",
" ",
"REPLY AND FORWARD",
" ",
"Replying ({F11:R}) and Forwarding ({F12:F}) are your two alternatives for",
"following up on the message you are reading. You would use reply if you",
"want to get email back to the author of the message and/or the other",
"people who have already seen it.  You use forward if you want somebody new",
"to see the message. ",
" ",
"In the normal case, the only thing that you must supply when forwarding a",
"message is the name/email address of the new recipient.  Pine will",
"include the text of the forwarded message.  Pine will also include any",
"attachments to the message if you have requested them.  There is space",
"above the forwarded text for you to include any comments. ",
" ",
"When replying, you usually have to answer some questions.  If the message",
"is to multiple people and/or specified with a Reply-to: header, then you",
"will have to decide who should get the reply.  You also need to decide",
"whether or not to include the previous message in your reply.  Some of",
"this is configurable.  Specifically, see the include-header-in-reply and",
"include-text-in-reply configuration features. ",
" ",
"Both the Reply and Forward commands react to the full header mode toggle.",
"If the full header mode is on, then all the header and delivery lines are",
"included with the text of the message in your reply/forward. ",
" ",
"SAVE AND EXPORT",
" ",
"Export ({F12:E}) and Save ({F11:S}) are the two alternatives Pine gives",
"you to keep a copy of the message you are reading. If you want to keep the",
"message within Pine's email world, use \"save\"; if you want to use the",
"message in another program, use \"export\".  ",
" ",
"When you save a message, it is put into an existing folder or into a new",
"folder in one of your existing folder collections.  The message stays in",
"email format and can be read by Pine again.  Pine may use a special format",
"for its mail folders -- never edit a Pine folder by hand or with any",
"program other than Pine.  The exact behavior of the save command can be",
"configured with the save-will-quote-leading-froms, save-will-not-delete,",
"and save-will-advance feature list settings. ",
" ",
"When you use export, the message is placed in a plain text file in your",
"home directory or current working directory, depending on the",
"use-current-dir configuration setting.  In the normal case, only minimal",
"headers are exported with the message; however, if the full header mode is",
"toggled on, then complete headers are exported along with the message",
"text. ",
" ",
"TAKE ADDRESS",
" ",
"With the Take Address command, you can extract email addresses from an",
"incoming message and save them in an address book.  This is an easy way",
"to add to your address book and avoid having to remember the email",
"addresses of the people who write to you. ",
" ",
"If the message is just to you individually, then you will only need to",
"provide a nickname.  If the message is more complicated (with more than",
"one recipient or an email list involved), then you will see an address",
"selection screen which lets you choose the address you want to save into ",
"your address book, or add several of them to a personal address list. ",
" ",
"HEADER MODE",
" ",
"Every email message comes with some header lines that you normally don't",
"see.  These include anywhere from 3-20 lines added by Internet mail",
"transport system to record the route your message took, for diagnostic",
"purposes.  These are normally of no import and simply add clutter, so Pine",
"suppresses them from MESSAGE TEXT display.  There is, however, a way to",
"reveal them. ",
" ",
"The Header Mode ({F9:H}) command is a toggle which controls Pine's",
"handling of these header lines.  Normally, full headers is \"off\" and you",
"only see a few lines about who a message is to and who it is from.  When",
"you press {F9:\"H\"} to turn full headers on, Pine will show you the",
"normal header lines as well as delivery headers, comment headers and MIME",
"headers. ",
" ",
"Several different Pine commands honor the header mode -- it affects how",
"messages are displayed, how they appear in Forward and Reply email, how",
"they are printed, they are saved, and how they are exported.  In Unix",
"Pine, the Pipe command is also affected.",
" ",
"The presence or absence of the Header Mode command is determined by the",
"\"enable-enable-full-header-cmd\" feature-list option in your Pine",
"configuration.  ",
" ",
"EXPUNGE/EXCLUDE",
" ",
"Expunge/Exclude is the command Pine uses to actually remove all messages",
"marked for deletion.  With regular email files, expunge literally deletes",
"the text from the current folder.  With newsgroups or shared mailboxes,",
"you don't have permission to actually remove the message, so it is an",
"exclude -- Pine removes the message from your view of the folder even",
"though it is not technically gone. ",
" ",
"GOTO",
" ",
"Goto is the command which lets you bypass Pine's folder selection screens",
"and jump directly to a new folder.  You can select any folder in the",
"world: one in your current collection, one in a different collection or",
"one in a collection you've never even used before. ",
" ",
"Pine will help you as much as it can to narrow in on the folder you want. ",
"However, if the folder is outside of your defined collections, you are",
"going to have to enter the exact folder location using the correct syntax",
"for a remote folder and/or fully-qualified path name.",
" ",
"WHEREIS",
" ",
"The WhereIs command lets you search the FOLDER INDEX for a word.  It scans",
"through whatever you see, usually the name of the author and the subject",
"line.  WhereIs has special features to let you \"find\" the beginning of the",
"index (Ctrl-Y -- first message) or the end of the index (Ctrl-V -- last",
"message).  WhereIs can also be used as a quick way to select messages, see",
"below for more information on this. ",
" ",
"JUMP",
" ",
"This is Pine's way of allowing you to go straight to a specific message. ",
"Just press {F7:\"J\"} and then enter the message number.  Pine can also be",
"configured such that typing in any number automatically jumps you to that",
"message (enable-jump-shortcut in the SETUP CONFIGURATION). ",
" ",
"SORT",
" ",
"In Pine's generic configuration, messages are presented in the order in",
"which they arrive.  This default can be changed in the SETUP CONFIGURATION. ",
"You can also re-sort the folder on demand with the sort ({F6:$}) command. ",
"Your sorting options are: Subject, Arrival, From, Date, siZe,",
"OrderedSubject and Reverse. ",
" ",
"Some of the subtleties: sorting by subject will group all messages with",
"the same subject together and then puts the groups in alphabetical order. ",
"Sorting by \"ordered subject\" does a grouping intended to simulate a",
"\"threaded\" sort, and then presents each \"thread\" in order of the date",
"of the first message in the group.  Reverse simply reverses whatever the",
"current sort order is. ",
" ",
"Sorting a folder does not actually rearrange the way the folder is saved,",
"it just re-arranges how the messages are presented to you.  This means",
"that Pine has to do the work of sorting every time you change sort order. ",
"Sometimes, especially with PC-Pine or with large folders, this could take",
"a while. ",
" ",
"BOUNCE",
" ",
"The bounce ({F10:B}) command allows you to re-send, or \"remail\", a",
"message, as if you were never in the loop.  It is analogous to crossing",
"out your address on a postal letter, writing a different address on the",
"envelope, and putting it into the mailbox. Bounce is used primarily to",
"redirect email which was sent to you in error.  Also, some owners of email",
"lists need the bounce command to handle list traffic. ",
" ",
"The presence or absence of the Bounce command is determined by the",
"\"enable-bounce-cmd\" feature-list option in your Pine configuration. Note",
"that Bounce may be administratively disabled by your system manager; if it",
"doesn't work, please check with your local help desk before reporting a",
"bug. ",
" ",
"FLAG",
" ",
"Flag ({F11:*}) is the command which allows users to manipulate the status",
"flags which appear on the left side of the FOLDER INDEX screen.  The most",
"common use of this is to mark a message as important. This is something of",
"a note to yourself to get back to that message.  You can also use the flag",
"command to set (or unset) the flags which indicate that a message is new,",
"read or answered. ",
" ",
"The availability of the flag command is determined by the",
"\"enable-flag-cmd\" feature-list option in your Pine configuration. Also,",
"Flag may be administratively disabled by your system manager; if it",
"doesn't work, please check with your local help desk before reporting a",
"bug. ",
" ",
"NEXT NEW (TAB) COMMAND",
" ",
"When you press the TAB key, Pine advances to the next \"interesting\"",
"message.  When you are using Pine to read email, that message is the next",
"message in the folder which you have not read before, or that you have",
"previously flagged as Important.  When reading news folders, the next",
"\"interesting\" message is the next one that you have not yet deleted. ",
" ",
"SELECTING: SELECT AND WHEREIS/SELECT",
" ",
"Aggregate operations give you the ability to process a group of messages",
"at once.  Acting on multiple messages requires two steps: (1) selecting a",
"set of messages and then (2) applying a command to that set. The first",
"part is handled by the select ({F4:\";\") command.  Select allows you to",
"select messages based on their status (read, answered, etc.), contents",
"(including fielded selections on header lines) or date.  You also get",
"certain quick options to select a specific message or range of messages,",
"to select the current message or to select all messages. ",
" ",
"After you have an initial selection, the select command changes.  It gives",
"you selection \"alteration\" options: unselect all, unselect current,",
"broaden (implements a logical OR), and narrow (implements a logical AND). ",
"You are allowed to use select as many times as you need to get the",
"selected set right. ",
" ",
"Also, the venerable \"WhereIs\" ({F8:W}) command has a new feature",
"(Ctrl-X) to select all the messages which match the WhereIs search. ",
"WhereIs searches through just the text which appears on the FOLDER INDEX. ",
" ",
"The availability of the aggregate operations commands is determined by the",
"\"enable-aggregate-command-set\" feature-list option in your Pine",
"configuration.  Note that aggregate commands may be administratively",
"disabled by your system manager;  if they don't work, please check with",
"your local help desk before reporting a bug. ",
" ",
"APPLY",
" ",
"Apply ({F5:A}) is the second step of most aggregate operations.  Apply",
"becomes active any time there is a defined set of selected messages.  The",
"following commands can be applied to a selected message set: delete,",
"undelete, reply, forward, print, take address, save, export, flag, and (on",
"Unix Pine) pipe to Unix command. ",
" ",
"The behavior of some of these commands in an aggregate sense is not easy to ",
"explain.  Try them out to see what they do.",
" ",
"ZOOM",
" ",
"Another action you might want to take on a set of selected messages is to",
"zoom in on them.  Like Apply, Zoom only becomes active when messages have",
"been selected.  Zoom ({F7:Z}) is a toggle command which allows you to",
"zoom-in (and only to see the selected messages) and zoom-out (to see all",
"messages in the folder).  Neither apply nor zoom removes the markings which",
"define the selected set; you need to use a select (\";\") command in order",
"to do this. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_simple_index[] = {
 "        POSTPONED MESSAGE SELECTION COMMANDS",
" ",
"Navigating the List of Messages               General Pine Commands ",
"-------------------------------               ---------------------",
" {F5 : P }  Move to previous message                {F1 : ? }  Show this help text",
" {F6 : N }  Move to next message",
" {F7 : - }  Show previous screen of messages",
" {F8 :Spc}  Show next screen of messages",
" ",
"Message Selection Commands",
"--------------------------",
" {F3 : E }  Exit the Message Select menu (canceling Send command)",
" {F4 : S }  Select the currently highlighted message",
" ",
"------------------------------------------------------",
"| Description of the Select Postponed Message Screen | ",
"------------------------------------------------------",
" ",
"This screen allows you to select one of several previously postponed",
"messages in order to continue composition.  Your options are very limited",
"-- the screen is not meant to let you manipulate these messages in any",
"way.  Once you choose a message, Pine reads it in and puts you into the",
"regular message composer.",
" ",
"You cannot delete messages from this list.  If you wish to abandon a",
"message, you have to select it and then cancel (Ctrl-C) the message.",
"Similarly, messages do not stay in this postponed state automatically.  If",
"you select a message and then want to postpone it again, use the normal",
"postpone (Ctrl-O) command in the composer. ",
" ",
"If you exit this screen without selecting a message, the Compose command ",
"which got you here is canceled.  No messages will be removed.",
" ",
"<End of help on this topic>",
NULL
};


char *h_mail_view[] = {
 "                        MESSAGE TEXT COMMANDS",
"{Available  Commands -- Group  1        Available Commands -- Group 2   :Navigating the List of Messages        Operations on the Current Message}",
"{-------------------------------        ------------------------------  :-------------------------------        ---------------------------------}",
"{F1  Show Help Text                     F1  Show Help Text              : P     Display previous message        V  View attachment      Y  Print}",
"{F2  Toggle to see more commands        F2  Toggle to see more commands : N     Display next message            R  Reply to message     F  Forward}",
"{F3  MAIN MENU Screen                   F3  Quit Pine                   : -     Show previous page of this msg  D  Mark for deletion      }",
"{F4  View attachment                    F4  Compose a message           :Spc    Show next page of this msg      U  Undelete (remove deletion mark)}",
"{F5  Display previous message           F5  FOLDER LIST screen          : J     Jump to a specific message      T  Take Address into Address Book}",
"{F6  Display next message               F6  Goto a specified folder     :                                       S  Save into an email folder}",
"{F7  Previous screen of this message    F7  FOLDER INDEX screen         :                                       E  Export as a plain text file}",
"{F8  Next screen of this message        F8  Whereis                     :                                       |  Pipe to a Unix Command}",
"{F9  Mark message for deletion          F9  Print message               :MESSAGE TEXT Screen Commands   B  Bounce                       *  Flag}",
"{F10 Undelete (remove delete mark)      F10 Take address into address book      :----------------------------}",
"{F11 Reply to message                   F11 Save message into an email folder  : G   Goto a specified folder     General Pine Commands }",
"{F12 Forward                            F12 Export message into a plain file    : H   Full Header Mode            --------------------- } ",
"{                                                                       :Tab  Next New                    O  Show all other available commands }",
"{Available Commands -- Group 3                                          : W   Whereis -- search for a     ?  Show Help text      Q Quit Pine }",
"{------------------------------                                         :     specific word in message    M  MAIN MENU Screen    L FOLDER LIST screen}",
"{F7             Jump to message    F9  Full header mode      F11 Flag message   :                                   I  FOLDER INDEX Screen C  Compose a message }",
"{F8             Next New           F10 Bounce this message   F12 Pipe to a Unix command :}",
" ",
"NOTE: The presence or absence of the following commands is determined by",
"\"feature-list\" options in your Pine configuration.  Also, some of these ",
"commands may be administratively disabled by your system manager; if they don't ",
"work, please check with your local help desk before reporting a bug.",
"        o Header Mode (toggle between display of full or minimal headers)",
"        o Flag (mark message as important or set other message status flags)",
"        o Bounce (re-mail message)",
"        o Pipe message to a Unix command",
" ",
"The \"Pipe message to a Unix command\" command is not available in PC-Pine.",
" ",
"------------------------------------------",
"| Description of the MESSAGE TEXT Screen |",
"------------------------------------------",
" ",
"The upper right corner of the view message screen displays status",
"information about the currently open collection and folder and about the",
"current message.  It shows the name of the collection in angle brackets",
"and then the name of the folder.  The status line also displays the number",
"of messages in the folder, the number of the current message and the",
"percentage of the current message that has been displayed on the screen.",
"If the message is marked for deletion \"DEL\" will appear in the upper",
"right as well. ",
" ",
"------------------------------",
"| Brief Command Explanations |",
"------------------------------",
" ",
"REPLY AND FORWARD",
" ",
"Replying ({F11:R}) and Forwarding ({F12:F}) are your two alternatives for",
"following up on the message you are reading. You would use reply if you",
"want to get email back to the author of the message and/or the other",
"people who have already seen it.  You use forward if you want somebody new",
"to see the message. ",
" ",
"In the normal case, the only thing that you must supply when forwarding a",
"message is the name/email address of the news recipient.  Pine will",
"include the text of the forwarded message.  Pine will also include any",
"attachments to the message if you have requested them.  There is space",
"above the forwarded text for you to include any comments.",
" ",
"When replying, you usually have to answer some questions.  If the message",
"is to multiple people and/or specified with a Reply-to: header, then you",
"will have to decide who should get the reply.  You also need to decide ",
"whether or not to include the previous message in your reply.  Some of",
"this is configurable.  Specifically, see the include-header-in-reply and",
"include-text-in-reply configuration features.",
" ",
"Both the Reply and Forward commands react to the full header mode toggle.",
"If the full header mode is on, then all the header and delivery lines are",
"included with the text of the message in your reply/forward.",
" ",
"SAVE AND EXPORT",
" ",
"Export ({F12:E}) and Save ({F11:S}) are the two alternatives Pine gives",
"you to keep a copy of the message you are reading. If you want to keep the",
"message within Pine's email world, use \"save\"; if you want to use the",
"message in another program, use \"export\".  ",
" ",
"When you save a message, it is put into an existing folder or into a new",
"folder in one of your existing folder collections.  The message stays in",
"email format and can be read by Pine again.  Pine may use a special format",
"for its mail folders -- never edit a Pine folder by hand or with any",
"program other than Pine.  The exact behavior of the save command can be",
"configured with the save-will-quote-leading-froms, save-will-not-delete,",
"and save-will-advance feature list settings. ",
" ",
"When you use export, the message is placed in a plain text file in your  ",
"home directory or current working directory, depending on the",
"use-current-dir configuration setting.  In the normal case, only minimal",
"headers are exported with the message; however, if the full header mode is",
"toggled on, then complete headers are exported along with the message",
"text.",
" ",
"VIEW ATTACH",
" ",
"The View/Save Attachment ({F4:V}) command allows you to handle MIME",
"attachments on a message you have received.  Pine shows you a list of the",
"message attachments--you just choose the attachment you want.  You may",
"either view or save the selected attachment.",
" ",
"Because many attachments require external programs for display, there is",
"some system configuration that has to happen before you can actually",
"display attachments.  Hopefully much of that will have been done already",
"by your system administrator.  MIME configuration is handled with the",
"\"mailcap\" configuration file.  (See the release notes for more information.)",
" ",
"WHEREIS",
" ",
"The WhereIs ({F8:W}) command does a \"find in current message\" operation. ",
"You type in a word and Pine will try and find it in the message you are",
"reading.  You can also use WhereIs to jump to the beginning (Ctrl-Y) or",
"end (Ctrl-V) of the message. ",
" ",
"NEXT NEW (TAB) COMMAND",
" ",
"When you press the TAB key, Pine advances to the next \"interesting\" ",
"message.  When you are using Pine to read email, that message is the next",
"message in the folder which you have not read before or which you have",
"previously marked \"Important\" via the Flag command.  When reading news",
"folders, the next \"interesting\" message is the next one which you have",
"not yet deleted. ",
" ",
"TAKE ADDRESS",
" ",
"With the Take Address command, you can extract email addresses from an",
"incoming message and save them in an address book.  This is an easy way",
"to add to your address book and avoid having to remember the email",
"addresses of the people who write to you. ",
" ",
"If the message is just to you individually, then you will only need to",
"provide a nickname.  If the message is more complicated (with more than",
"one recipient or an email list involved), then you will see an address",
"selection screen which lets you choose the address you want to save into ",
"your address book, or add several of them to a personal address list. ",
" ",
"HEADER MODE",
" ",
"Every email message comes with some header lines that you normally don't",
"see.  These include anywhere from 3-20 lines added by Internet mail",
"transport system to record the route your message took, for diagnostic",
"purposes.  These are normally of no import and simply add clutter, so Pine",
"suppresses them from MESSAGE TEXT display.  There is, however, a way to",
"reveal them. ",
" ",
"The Header Mode ({F9:H}) command is a toggle which controls Pine's",
"handling of these header lines.  Normally, full headers is \"off\" and you",
"only see a few lines about who a message is to and who it is from.  When",
"you press {F9:\"H\"} to turn full headers on, Pine will show you the",
"normal header lines as well as delivery headers, comment headers and MIME",
"headers. ",
" ",
"Several different Pine commands honor the header mode -- it affects how",
"messages are displayed, how they appear in forward and reply email, how",
"they are printed, they are saved, and how they are exported. In Unix",
"Pine, the Pipe command is also affected.",
" ",
"The presence or absence of the Header Mode command is determined by the",
"\"enable-enable-full-header-cmd\" feature-list option in your Pine",
"configuration.  ",
" ",
"FLAG",
" ",
"Flag ({F11:*}) is the command which allows users to manipulate the status",
"flags which appear on the left side of the FOLDER INDEX screen.  The most",
"common use of this is to mark a message as important. This is something of",
"a note to yourself to get back to that message.  You can also use the flag",
"command to set (or unset) the flags which indicate that a message is new,",
"read or answered. ",
" ",
"The availability of the flag command is determined by the",
"\"enable-flag-cmd\" feature-list option in your Pine configuration. Also,",
"Flag may be administratively disabled by your system manager; if it",
"doesn't work, please check with your local help desk before reporting a",
"bug. ",
" ",
"ALTERNATE CHARACTER SETS",
" ",
"Pine attempts to stay out of the way so that it won't prevent you from",
"viewing mail in any character set.  It will simply send the message to",
"your display device.  If the device is capable of displaying the message",
"as it was written it will do so.  If not, the display may be partially or",
"totally incorrect.  If the message is marked as being in a character set",
"other than \"US-ASCII\" and it is a character set that is different from",
"the set you have indicated with the \"character-set\" variable in your",
"configuration, then a warning message will be printed to your screen at",
"the beginning of the message display. ",
" ",
"In all cases Pine requires that the display device can handle the",
"character set.  For example, most X-terminals will display the ISO-8859-1",
"character set if the right font is selected.  VT220's and higher also",
"display ISO-8859-1.  Displays for other characters sets are less common. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_folder_maint[] = {
 "                        FOLDER LIST COMMANDS",
"{Available Commands -- Group 1        Available Commands -- Group 2     :Navigating the Folder Screen            Operations on the Selected Folder}",
"{-------------------------------      ------------------------------    :----------------------------            ---------------------------------}",
"{F1  Show Help Text                    F1  Show Help Text               : P   Move to previous folder              V  View Index of selected folder}",
"{F2  Toggle to see more commands       F2  Toggle to see more commands  : N   Move to next folder                  D  Delete}",
"{F3  MAIN MENU Screen                  F3  Quit Pine                    : -   Show previous page of listing        R  Rename}",
"{F4  Select folder and view it         F4  Compose a message            :Spc  Show next page of listing}",
"{F5  Move to previous folder                    :}",
"{F6  Move to next folder               F6  Specify a folder to go to    :FOLDER LIST Screen Commands              General Pine Commands}",
"{F7  Show previous screen of listing   F7  Show FOLDER INDEX of current folder :---------------------------              ---------------------}",
"{F8  Show next screen of listing       F8  Whereis (search folder names): A  Add a folder                          O  Show all other available commands}",
"{F9  Delete selected folder            F9  Print folder listing         : G  Specify a folder to go to             ?  Show Help text",
"{F10 Add a new folder                                                   : I  Show FOLDER INDEX of current folder   M  MAIN MENU Screen}",
"{F11 Rename selected folder                                             : W  Whereis (search folder names)         Q  Quit Pine}",
"{                                                                       : Y  Print folder listing                  C  Compose a message}",
" ",
"-----------------------------------------",
"| Description of the FOLDER LIST Screen |",
"-----------------------------------------",
" ",
"The purpose of the FOLDER LIST screen is to display your message folders",
"and allow you to \"open\" or view a new one, or manage your folders using the",
"Rename, Delete, and Add commands.  The status bar shows information about",
"the current folder. ",
" ",
"The appearance of the Folder List depends upon your Pine configuration.",
"The most basic configuration will show a single list of folders, beginning",
"with the three distinguished folders INBOX, sent-mail, and saved-messages. ",
"All other folders will be listed in alphabetical order. ",
" ",
"If you or your system administrator have defined additional collections,",
"e.g. News, then you may see each of your collections listed with a",
"\"Select Here to See Expanded List\" button.  Alternatively, Pine can be",
"configured to always immediately display the complete list of folders in",
"each collection via the \"expanded-view-of-folders\" feature list option. ",
" ",
"-----------------",
"| About Folders |",
"-----------------",
" ",
"What are Folders?",
" ",
"Folders are simply files where messages are kept.  Every message has to be",
"in a folder.  Most every Pine user starts out with 3 folders: an INBOX, a ",
"folder for sent mail and a folder for saved messages.",
" ",
"You may create as many other folders as you wish.  They must be given",
"names that can be filenames on the filesystem.  On DOS that means they",
"must be 8-characters or less; on Unix you shouldn't use special characters",
"such as \"/\".  Normally PC-Pine folders are automatically given the DOS",
"extension \".MTX\" (which stands for Mailbox-text).  The extension is",
"suppressed from FOLDER LIST displays, and should not be entered when",
"typing a folder name at a Save or Goto prompt.  The use of the MTX extension",
"can be overridden by a Setup/Config option, which may be useful when",
"accessing saved-message folders on a Unix host via SMB or NFS.  PC-Pine",
"can understand the normal Unix mail folder format, but can only open",
"those folders READ-ONLY.",
" ",
"You can move messages from one folder to another by opening the original",
"folder and saving messages into the other folder just as you can save",
"message from your INBOX to any other folder.",
" ",
"Folders are just files in the filesystem.  However, the files which are",
"folders have some special formatting in them (so that Pine knows where one",
"message ends and another begins) and should *not* be edited outside of",
"Pine.  If you want copies of your messages in text files that you can edit",
"or otherwise manipulate, use the export command to export them from Pine.",
" ",
"----------------------",
"| Folder Collections |",
"----------------------",
" ",
"Those of you with simple mail configurations will just see a list of all the",
"folders you have.  The special folders for INBOX, sent mail and saved messages  ",
"will appear at the top of the list.  All others are in alphabetical order.",
" ",
"That model wouldn't work for Pine users with multiple collections.  If you",
"or your system administrator have defined more than one collection or if",
"you have a collection (news or otherwise) defined on your system, then you",
"will see each of your collections listed with a \"Select Here to See",
"Expanded List\" button.  Pine can be configured to always show you all",
"folders in all collections with the \"expanded-view-of-folders\" feature",
"list option in your Pine configuration.",
" ",
"Why have Collections?",
" ",
"If a Pine user only got 5 messages a day and used the same computer all the",
"time, then folders would be enough.  For good or bad, that is not the",
"case.  People who use more than one computer account need to have",
"different sets of folders on those different platforms.  People who have  ",
"hundreds or thousands of folders need a way to group folders together.",
"That is where collections come in.  ",
" ",
"Types of Collections.",
" ",
"A collection of folders is just a group of folders in the same directory",
"on the same machine.  In general, all collections of folders are equal in",
"Pine's eye.  However, there are some special collections: ",
" ",
"        INCOMING FOLDERS:  Pine's \"incoming-folders\" configuration is a",
"special collection used to supplement your single INBOX.  All the folders",
"here are those that get incoming messages.  You may have multiple folders",
"like this because you use an external program to filter your email or",
"because you have multiple accounts.",
" ",
"        NEWS:  You can also define a collection specifically for",
"newsgroups.  Pine does this for you implicitly when you define a NNTP ",
"Server in your Pine configuration.  The news collection is presented last",
"and Pine knows not to save messages there.",
" ",
"        DEFAULT COLLECTION FOR SAVES:  Perhaps the most important special",
"collection is the one which you specify as the first item of the",
"configuration for \"folder-collections\".  This is the default collection",
"for your saved and sent messages folders.",
" ",
"There is no limit to the number of collections you can have. Everyone",
"starts with just one collection and few people ever have more than a dozen",
"or so.",
" ",
"Defining Collections.",
" ",
"In the absence of any folder-collection definitions, Pine will assume a",
"single default folder collection, and if necessary, create the directory",
"\"mail\" in your Unix home directory to hold your folders.  Otherwise,",
"Pine will never create any directories.  However, you may create as many",
"mail directories as you would like using the Unix \"mkdir\" command, and",
"then define folder-collection entries to correspond with each one. This is",
"done via the Setup/Config command on the Main Menu. ",
" ",
"----------------------",
"| Valid Folder Names |",
"----------------------",
" ",
"Once your folder collections are defined, you can usually refer to",
"folders by their simple (unqualified) name, or pick from a FOLDER LIST ",
"display.  However, understanding the complete syntax for folder names,",
"both local and remote, is handy when using the Goto command and when",
"you are adding new folder collections via the SETUP CONFIGURATION screen.",
" ",
"Local folders follow the local naming rules.  For example,",
"\"~/mail/september-1994\" might be a reasonable folder name on Unix ",
"and \"\\C:\\PINE\\FOLDERS\\OCT-94\" might exist on a PC. ",
" ",
"Pine users have the option of using folders which are stored on some other",
"computer.  Pine accesses remote folders via IMAP (the Internet Message",
"Access Protocol), or in the case of news, via NNTP (the Network News",
"Transport Protocol).  To be able to access remote folders in Pine, the",
"remote host must be running the appropriate server software (imapd or",
"nntpd) and you must correctly specify the name of the folder to Pine,",
"including the domain name of the remote machine. For example,",
"\"{{:{}monet.art.nowhere.edu}INBOX\" is a remote folder specification, as",
"is \"{{:{}monet.art.nowhere.edu}~/mail/september-1994\".  As you can tell,",
"the name of the computer is in {{:{}} brackets followed immediately by the",
"name of the folder.  If, as in these examples, there is no remote access",
"protocol specified, then IMAP is assumed. ",
" ",
"There are certain markings which have special meanings in folder names:",
"    o A \"*\" in front of the folder specification means that the folder is ",
"      a bulletin board -- shared access and no write privileges.  Examples:",
"           *comp.mail.pine, *{{:{}wharhol.art.nowhere.edu}job-board",
"    o A folder name beginning with \"#mh/\" is an mh format folder.  Examples:",
"           #mh/mail/sep-1994, {{:{}rembrandt.art.nowhere.edu}#mh/mail/sep-1994",
" ",
"There are certain flags within remote folder names:",
"    o An \"/anonymous\" flag means anonymous IMAP access.  Example:",
"      {{:{}wharhol.art.nowhere.edu/anonymous}job-board",
"    o A \"/nntp\" flag means NNTP protocol access.  It cannot be used with",
"      the /anonymous flag.  Example:",
"           *{{:{}news.nowhere.edu/nntp}comp.mail.pine",
" ",
"Note that \"INBOX\" has special meaning in both local and remote folder",
"specifications.  The name INBOX refers to your \"principal incoming",
"message folder\" and will be mapped to the actual file name used for your",
"INBOX on any given host.  Therefore, a name like",
"\"{{:{}xxx.art.nowhere.edu}INBOX\" refers to whatever file is used to",
"store incoming mail for you on that particular host. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_folder_open[] = {
 " ",
"This screen is designed to allow you to quickly and easily survey your",
"folders and select one to open.",
" ",
"Navigating the List of Folders             General Pine Commands",
"------------------------------             ---------------------",
"{F5 : P }  Move to previous folder          {F1 : ? }  Show this help text",
"{F6 : N }  Move to next folder",
"{F7 : - }  Show previous screen of folders",
"{F8 :Spc}  Show next screen of folders",
"{F12: W }  WhereIs (search folder names)",
" ",
"Folder Selection Commands ",
"-------------------------",
"{F3 : E }  Exit the Folder Select menu (without selecting a folder)",
"{F4 : S }  Select the currently highlighted folder",
" ",
"FOR MORE INFORMATION: From the Main Menu, select \"L FOLDER LIST\" and",
"press \"?\" for Help... Look for the section \"About Folders\".",
"        ",
"<End of help on this topic>",
NULL
};


char *h_folder_save[] = {
 " ",
"This screen is designed to allow you to quickly and easily survey your",
"folders and select one to use for saving the current message.",
" ",
"Navigating the List of Folders             General Pine Commands",
"------------------------------             ---------------------",
"{F5 : P }  Move to previous folder          {F1 : ? }  Show this help text",
"{F6 : N }  Move to next folder",
"{F7 : - }  Show previous screen of folders",
"{F8 :Spc}  Show next screen of folders",
"{F12: W }  WhereIs (search folder names)",
" ",
"Folder Selection Commands ",
"-------------------------",
"{F3 : E }  Exit the Folder Select menu (without selecting a folder)",
"{F4 : S }  Select the currently highlighted folder",
" ",
"FOR MORE INFORMATION: From the Main Menu, select \"L FOLDER LIST\" and",
"press \"?\" for Help... Look for the section \"About Folders\".",
"        ",
"<End of help on this topic>",
NULL
};


char *h_folder_fcc[] = {
 " ",
"This screen is designed to allow you to quickly and easily survey your",
"folders and select one to use as the file carbon copy (fcc) for the ",
"current message.",
" ",
"Navigating the List of Folders             General Pine Commands",
"------------------------------             ---------------------",
"{F5 : P }  Move to previous folder          {F1 : ? }  Show this help text",
"{F6 : N }  Move to next folder",
"{F7 : - }  Show previous screen of folders",
"{F8 :Spc}  Show next screen of folders",
"{F12: W }  WhereIs (search folder names)",
" ",
"Folder Selection Commands ",
"-------------------------",
"{F3 : E }  Exit the Folder Select menu (without selecting a folder)",
"{F4 : S }  Select the currently highlighted folder",
" ",
"FOR MORE INFORMATION: From the Main Menu, select \"L FOLDER LIST\" and",
"press \"?\" for Help... Look for the section \"About Folders\".",
"        ",
"<End of help on this topic>",
NULL
};


char *h_address_book[] = {
 "                         ADDRESS BOOK COMMANDS",
"{Available  Commands -- Group 1         Available Commands -- Group 2   :Address Book Navigation        General Pine Commands}",
"{-------------------------------        ------------------------------  :-----------------------        ---------------------}",
"{F1  Show Help Text                      F1  Show Help Text             : P  Prev Address                  ?  Display this help text}",
"{F2  Toggle to see more commands         F2  Toggle to see more commands: N  Next Address                  O  Show all other available commands}",
"{F3  MAIN MENU Screen                    F3  Quit Pine                  : -  Previous page of address book M  MAIN MENU screen}",
"{F4  Edit selected entry                 F4  Compose a message to selected addr  :Spc Next page of address book     Q  Quit Pine}",
"{F5  Move to previous entry              F5  FOLDER LIST screen         : W  WhereIs (search for word/     C  Compose a message to selected addr}",
"{F6  Move to next entry                  F6  Specify a folder to go to  :      or  name in address book)   L  FOLDER LIST screen}",
"{F7  Previous page of address book       F7  FOLDER INDEX screen        : G  Specify a folder to go to}",
"{F8  Next page of address book           F8  Whereis (search through address book):Address Book Commands             I  FOLDER INDEX screen} ",
"{F9  Delete selected entry               F9  Print address book         :---------------------}",
"{F10 Add a single entry                  F10 Edit Fcc or Comment field of entry   : E  Edit selected entry} {F11 Create an entry for a list                                                : D  Delete selected entry} ",
"{F12 Add to a list entry                                                : A  Add a single entry} {: S  Create an entry for a list}",
"{: Z  Add to a list entry}",
"{: Y  Print address book}",
" ",
"------------------------------------------",
"| Description of the Address Book Screen | ",
"------------------------------------------",
" ",
"This screen lets you edit any and all entries in your address book.  It",
"also acts as a short-cut for composing messages to people in the address",
"book.  When, from this screen, you press {F4:\"C\"} for Compose, the",
"message starts \"pre-addressed\" to whatever address book entry is",
"currently selected. ",
" ",
"If you have more than one address book defined for yourself or if your",
"system has a site-wide address book defined, you may see a list of address",
"books and a \"Select Here to See Expanded List\" button for each of them. ",
"Alternatively, Pine can be configured to immediately display all the",
"entries in each address book via the \"expanded-view-of-addressbooks\"",
"feature list option in your Pine configuration. ",
" ",
"Pine's address book helps you keep a list of addresses you send mail to so",
"you do not have to remember addresses that are often complex.  Each entry",
"in the address book has three required fields and two optional fields.",
"The required elements, which are visible on the ADDRESS BOOK display, are:",
" ",
"        NICKNAME: A short easy-to-remember label to identify the entry. ",
"        This is what you type in as you are addressing the message in the",
"        composer.  If there is a matching entry in your address book(s),",
"        Pine will extract the corresponding FullName and Address fields to",
"        generate the actual address for your message. ",
" ",
"        FULLNAME: A longer field where you can put the full name of the",
"        person or organization.  Usually the full names are put in last",
"        name first so they sort nicely in alphabetical order.  Whatever",
"        you put as the name here will appear on the message when it is ",
"        finally delivered. ",
" ",
"        ADDRESS: This is the actual email address itself.  This must be ",
"        a valid Internet address that conforms to the Internet message",
"        header standard, RFC-822.  (There is more information on email",
"        addresses a little later in this section.)",
" ",
"The two optional fields are:",
" ",
"        FCC: The name of the folder you would like a copy of any outgoing",
"        message to this address to be saved in. If this field is set, and",
"        this address is the first one in the message's To: header, then",
"        Pine will use this folder name for the FCC in lieu of the normal",
"        FCC folder name. ",
" ",
"        COMMENTS: This field contains arbitrary text for your convenience.",
" ",
"Due to screen width limitations, these last two fields do not show up in ",
"the normal ADDRESS BOOK display.  You must select the \"Edit\" command to ",
"view or modify them.",
" ",
"---------------------------",
"| Sorting the Address book |",
"---------------------------",
" ",
"By default, address book entries are sorted alphabetically on the full",
"name with distribution lists sorted to the end.  Sorting can be changed by",
"resetting the address book sort rule in the Pine SETUP CONFIGURATION screen",
"--assuming you have \"write\" permission for the address book file.",
" ",
"Unlike the sorting of folders (which only changes presentation), sorting an",
"address book actually changes the file as it is kept on the computer.  For",
"this reason you may not be able to sort a shared or system-wide address",
"book.",
" ",
"----------------------",
"| Distribution Lists | ",
"----------------------",
" ",
"Pine entries can be simple cases of aliases (a single nickname is linked",
"to a single email address) or distribution lists (a single nickname",
"pointing at more than one email address).  Each distribution list has a",
"nickname, a full name and a list of addresses.  The addresses may be",
"actual addresses or they may be other nicknames in your address book. ",
"They may even refer to other distribution lists.  The command to create a",
"distribution list is {F4:\"S\"} and the command to add entries to an",
"existing list is {F5:\"Z\"}.  Delete ({F11:\"D\"}) will delete a single",
"address from the list if the cursor is placed on the address; it will",
"delete the entire distribution list if the cursor is on the",
"nickname/fullname line. ",
" ",
"Address field entries in distribution lists may take any one of three",
"forms: a nickname existing in any of the defined address books, a normal",
"address of the form \"jsmith@art.nowhere.edu\", or a complete",
"fullname/address combination, e.g. \"John Smith",
"<jsmith@art.nowhere.edu>\".  This last form is only valid in distribution",
"list entries, since in the single-address entries the fullname and address",
"components are stored in separate fields.",
" ",
"Distribution lists in Pine address books can only be used by the person or",
"people who have access to that address book.  They are not usually used to",
"implement discussion groups, but can be used to facilitate small",
"discussion groups if all the participants have access to the same shared",
"address book. ",
" ",
"--------------------",
"| FCC and Comments |",
"--------------------",
" ",
"As mentioned above, each entry in the address book also has two optional",
"fields, fcc and comments.  The command to look at or edit either of these",
"is the same Edit command used for all of the fields ({F4:\"E\"}).  The",
"comments field is just for your own use.  The fcc field overrides the",
"default fcc if this address is the first one on the To line.  The WhereIs",
"command may be used to search for particular strings in the address book,",
"including the comment and fcc fields. ",
" ",
"------------------------------------------- ",
"| Multiple and/or Site-Wide Address books |",
"-------------------------------------------",
" ",
"You may have more than one personal address book.  In addition, there may",
"be one or more global addressbooks.  This capability allows you to have",
"multiple personal address books (some of which may be shared) and it also",
"allows system administrators to implement site-wide address books that",
"contain entries for users on multiple machines within the organization. ",
" ",
"Searching.  If you enter a nickname when composing a message, your",
"personal address books will be searched through in order, and then the",
"global address book(s) searched. If more than one address book has an entry",
"for the nickname, Pine uses the first one that it finds, so an entry in",
"your personal address book would override a global address book entry. If",
"after searching all the address books there is still no match, (Unix) Pine",
"then searches the local host password file on the assumption that you have",
"entered a local user name rather than an address book nickname. ",
" ",
"Defining.  You define multiple personal address books via the",
"\"address-book\" option in the SETUP CONFIGURATION screen.  You can add as",
"many as you like. System administrators may specify a site-wide address",
"book by defining the \"global-address-book\" variable in the system-wide",
"Pine configuration file.  You may over-ride this definition using the",
"\"global-address-book\" option in the SETUP CONFIGURATION screen. ",
" ",
"Creating and updating.  Personal address books are normally created empty",
"and populated by explicit additions from within Pine, e.g. via the",
"TakeAddr command. Unlike personal address books, global address books may",
"not be modified/updated from within Pine; that is, they are Read-Only. ",
"Thus, global address books are created, populated and updated outside of",
"Pine. They might be hand-edited, generated by a program from another",
"database, or by copying an existing address book.  See the Pine Technical",
"Notes document (included in the Pine distribution) for more information on",
"this. ",
" ",
"Accessing.  Address books must be accessible via normal file access",
"routines on the machine where Pine is running.  That is, Pine does not yet",
"have the ability to access address books on remote systems, except via",
"low-level file access protocols such as NFS or SMB.  (It is understood",
"that this limits the utility of global address books for PC-Pine users.)",
" ",
"While global address books are explicitly intended to be shared, there is",
"nothing to prevent you from sharing a personal address book with other",
"Pine users. This might be useful in the case of a small workgroup. ",
"However, it is recommended that updates to shared personal address books",
"be done when other Pine users are not accessing the address book. Pine",
"does not do any file-locking to manage concurrent updates to the",
"addressbook, but it does check to see if the file has been modified before",
"making any changes.  Consequently, inadvertent concurrent updates will",
"only cause other Pine users to have to restart their address book",
"operation, which will cause Pine to re-open the updated file. ",
" ",
"------------------------- ",
"| Valid Email Addresses | ",
"------------------------- ",
" ",
"When you enter an email address into the address field of your address",
"book you are giving Pine an address that it must be able to actually",
"reach.  The address you enter here must be a valid address which is",
"reachable from your site.  If it is not, you will get an error message",
"after sending the message. ",
" ",
"A valid email address on the Internet has a user name, an \"@\" sign and",
"then a domain.  For example, jsmith@art.nowhere.edu is the email address",
"of a person with the username \"jsmith\" who has an account with",
"\"art.nowhere.edu\".  The number of segments on the right of the \"@\"",
"sign can vary depending on how the address is structured for the",
"particular host. ",
" ",
"If you are sending to someone on the same system as you are, you can leave",
"the \"@\" and all the information to its right off of the address, and",
"Pine will fill it in automatically.  Sometimes you can also abbreviate the",
"right part of the address if you are at the same domain.  When sending",
"messages across gateways to other networks, the addresses get more",
"complicated.  Ask your local consultants for the correct syntax from your",
"site to the network you are trying to reach. ",
" ",
"<End of help on this topic> ",
NULL
};


char *h_use_address_book[] = {
 "                   COMPOSER: SELECT ADDRESS",
" ",
"Navigating the List of Messages               General Pine Commands ",
"-------------------------------               ---------------------",
"{F5 : P }  Move to previous entry             {F1 : ? }  Show this help text",
"{F6 : N }  Move to next entry",
"{F7 : - }  Show previous screen of address book",
"{F8 :Spc}  Show next screen of address book",
"{F12: W }  WhereIs (search through address book)",
" ",
"Address Selection Commands ",
"--------------------------",
"{F3 : E }  Exit the Address Select screen (without selecting an address)",
"{F4 : S }  Select the currently highlighted entry",
" ",
"This screen is designed to let you easily scan your address book(s) in",
"order to select an entry for the message you are composing.  You cannot",
"edit your address book in any way at this time, for address book",
"maintenance, select the address book command when not composing a message.",
" ",
"If you are composing a message and know the nickname of the person/list you",
"want, you can bypass this screen by simply typing in the nickname on the",
"appropriate header line (To:, Cc:, etc.)  Exiting this screen without",
"selecting an entry does not cancel your message.",
" ",
"FOR MORE INFORMATION on addresses and Pine's address book: From the Main",
"Menu, select \"A ADDRESS BOOK\" and press \"?\" for Help... ",
" ",
"<End of help on this topic>",
NULL
};


char *h_select_nickname[] = {
 "                TAKEADDR: SELECT NICKNAME ",
" ",
"Navigating the List of Messages               General Pine Commands ",
"-------------------------------               ---------------------",
"{F5 : P }  Move to previous entry             {F1 : ? }  Show this help text",
"{F6 : N }  Move to next entry",
"{F7 : - }  Show previous screen of address book",
"{F8 :Spc}  Show next screen of address book",
"{F12: W }  WhereIs (search through address book)",
" ",
"Message Selection Commands ",
"--------------------------",
"{F3 : E }  Exit the Nickname Select screen (without selecting an address)",
"{F4 : S }  Select the currently highlighted entry",
" ",
"This screen is designed to let you modify or add to an existing address",
"book entry.  You have already selected the name(s) and address(es) through",
"\"Take Address\".  This screen simply lets you scan your address books and",
"select the nickname to be changed/augmented.  If you want to add a new",
"entry, then you are in the wrong place-- press {F3:\"E\"} to exit.",
" ",
"FOR MORE INFORMATION on addresses and Pine's address book: From the Main",
"Menu, select \"A ADDRESS BOOK\" and press \"?\" for Help... ",
" ",
"<End of help on this topic>",
NULL
};


char *h_takeaddr_screen[] = {
 "                      TAKE ADDRESS COMMANDS",
" ",
"{Navigating the List of Addresses       Address Selection Commands        :Navigating the List of Addresses       Address Selection Commands}",
"{--------------------------------       --------------------------        :--------------------------------       --------------------------}",
"{ F5  Move to previous entry    F3  Exit without taking address : P  Move to previous entry              E  Exit without taking address}",
"{ F6  Move to next entry        F4  Take current address(es)    : N  Move to next entry                  T  Take address}",
"{ F7  Show previous page of address list                        : -  Show previous page of address list} ",
"{ F8  Show next page of address list -List Mode Only            :spc Show next page of address list     List Mode}",
"{                               --------------                  :                                       ---------}",
"{Mode Toggle            F9  Set/Unset current address           :Single Mode                             X  Set/Unset current address}",
"{-----------            F10 Set all                             :-----------                             A  Set all addresses} ",
"{ F12 Toggle between List and single mode       F11 Unset all   : L  Switch to list mode                 U  Unset all addresses}",
"{                                                               :                                        S  Switch to single mode}",
" ",
"------------------------------------------",
"| Description of the Take Address Screen |",
"------------------------------------------",
" ",
"This screen is designed to let you select one or more address/name",
"combinations from the current message into your address book.  The cursor",
"is initially placed on the line with the message author.  Other lines",
"include the names of people and/or mailing lists who also received the",
"message.  Other people \"involved\" in the message (e.g. the person named as",
"Reply-To:) are also listed here. ",
" ",
"The simple case is adding a new, single entry into your address book. To",
"do this, simply highlight the correct line and press {F4:\"T\"}.  To",
"create a new list or add to an existing list, switch the screen display",
"into List Mode by pressing {F12:\"L\"}.  In List Mode, you select the",
"group of addresses you wish to manipulate by marking them with an \"X\".",
"The Set/Unset ({F9:\"X\"}) command will turn the \"X\" on for the",
"highlighted address if it was off or turn it off if it was previously on. ",
"The SetAll command will select all of the addresses, and the UnSetAll",
"command will turn off all the selections.  Once you've gotten the",
"selection the way you want it, you may create a new list by pressing",
"{F4:\"T\"}. ",
" ",
"In both the simple and list cases, after choosing to take the address,",
"you will be asked for the nickname of the entry.  Typing in a new name",
"creates the new entry/list.  Entering an existing nickname will replace",
"the entry (simple case) or add to the list (list case).  Alternatively,",
"you can press Ctrl-T at the nickname prompt and select an existing",
"nickname from your address book. ",
" ",
"You will normally start in Single Mode, unless you used the Apply command",
"to startup the TakeAddr screen, in which case you will start in List Mode.",
"You may switch between the two modes at any time.  If you've already",
"selected several addresses in List Mode, those will be remembered when you",
"switch to Single Mode and then back to List Mode.  The set of addresses",
"that are pre-selected when you start in List Mode are the From addresses",
"of all of the messages you are operating on.  You may, of course, easily",
"erase those selections with the UnSetAll command. ",
" ",
"If you have more than one writable address book, you will be prompted for",
"the name of the address book you wish to add the new entry to before",
"anything else. You can use ^N and ^P to choose among the defined address",
"books, or type in the address book name. ",
" ",
"FOR MORE INFORMATION on addresses and Pine's address book: From the Main",
"Menu, select \"A ADDRESS BOOK\" and press \"?\" for Help... ",
" ",
"<End of help on this topic>",
NULL
};


char *h_attachment_screen[] = {
 " ",
"{F1 : ? }  Show this help text ",
"{F3 : E }  Exit this screen without displaying or saving any attachments ",
"{F4 : V }  View the currently selected attachment",
"{F5 : P }  Move to previous attachment",
"{F6 : N }  Move to next attachment",
"{F7 : - }  Previous page of the listed attachments",
"{F8 :Spc}  Next page of the listed attachments",
"{F9 : S }  Save the selected attachment to a file",
"{F10: | }  Pipe the selected attachment through a UNIX command (if enabled) ",
"{F12: W }  Find the matching string in the attachment list",
" ",
"The Attachment Index displays a list of the current message's attachments,",
"and provides for the viewing, saving, or piping (if enabled) of each",
"attachment.  The first attachment is usually the message text, but does",
"not include the header portion of the message. ",
" ",
"All attachments can be saved or piped into a UNIX command, but some may",
"not be readily displayed by either pine or an external tool.  In such",
"cases, the reason why the message cannot be displayed is displayed on",
"pine's message line. ",
" ",
"<End of help on this topic>",
" ",
NULL
};


char *h_mail_text_att_view[] = {
 " ",
"This function allows you to view the contents of a text attachment. You",
"can only view one attachment at a time. ",
" ",
" _{F1:? }  Get Help     Display this help text ",
" _{F3:E }  Exit Viewer  Go back to mail viewing.",
" _{F7:- }  Prev Page    Show the previous page of the current attachment.",
"{ F8:Spc}  Next Page    Show the next page of the current attachment by pressing",
" ______                 the space bar.",
" _{F9:Y }  Print        Print the current attachment on paper.  You can select the",
" ______                 printer or the print command via the \"Setup\" command",
" ______                 on the Main menu.",
"{F11:S }   Save         Copy the current attachment to a file.  If you just enter",
" ______                 a filename, the attachment will be saved with that name in",
" ______                 your home/current directory.  You may enter the full",
" ______                 path and filename to save it in another directory.",
"{F12: W }  WhereIs      Search the attachment for a string of letters.  If it is",
"______                  found, move to it.  The string can be one word or a phrase.",
" ______ If there are multiple occurrences, the cursor moves to the",
"______                first occurrence beyond the current cursor position.",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer[] = {
 "                       COMPOSER COMMANDS",
" ",
"CURSOR MOTION KEYS                     |EDITING KEYS",
"  ^B (Left Arrow)   Back character     | ^D       Delete current character  ",
"  ^F (Right Arrow)  Forward character  | ^H (DEL) Delete previous character",
"  ^P (Up Arrow)     Previous line      | ^^       Set a mark",
"  ^N (Down Arrow)   Next line          | {F9:^K}       Cut marked text or",
"  ^A                Beginning of line  |           delete current line",
"  ^E                End of line        | {F10:^U }       Paste text, undelete lines",
"  {F7:^Y}                Previous page      |           cut with ^K, or unjustify",
"  {F8:^V}                Next page          |-------------------------------------",
"  ^@ (Ctrl-SPACE)   Next word          |SCREEN/COMPOSITION COMMANDS",
"---------------------------------------| {F6(^W):^W    }   Whereis (search for string)",
"MESSAGE COMMANDS | GENERAL COMMANDS    | {F12:^T }      Spell checker",
" {F3:^C}   Cancel     |  {F1:^G}    Get help     | {F4:^J}       Justify paragraph  ",
" {F11:^O }  Postpone   |  ^Z    Suspend      | ^L       Redraw Screen",
" {F2:^X}   Send       |  {F6:^_}    Alt. editor  | {F5:^R}       Read in a file",
" ",
" ",
"NOTE: The presence or absence of the following commands is determined by",
"\"feature-list\" options in your Pine configuration.  Also, some of these",
"commands may be administratively disabled by your system manager; if they",
"don't work, please check with your local help desk before reporting a bug.",
"        o Suspend (suspends Pine and gives a system prompt)",
"        o Alternate editor (allows you to compose with your own editor)",
" ",
"The \"Alternate Editor\" and \"Spell Check\" commands are not available in",
"PC-Pine.",
" ",
"Pine does not use the following keys:  Ctrl-S, Ctrl-Q, Ctrl-], Ctrl-\\, ESC",
" ",
"Note: by default, Pine treats Ctrl-S or Ctrl-Q (sometimes known as XOFF",
"and XON), as normal characters, even though Pine does not use them.",
"However, the printer, modem, or communication software you are using may",
"be configured for \"software flow control\" which means that XON/XOFF must",
"be treated as special characters by the operating system.  If you see",
"messages such as \"^X not defined for this screen\", or if messages",
"printed via the \"attached-to-ansi\" option are missing pieces, then your",
"system is probably using software flow control. In this case you will need",
"to set the \"preserve-start-stop-characters\" feature.  If you *do* set",
"this feature, be advised that if you accidentally hit a Ctrl-S, Pine will",
"mysteriously freeze up with no warning.  In this case, try typing a Ctrl-Q",
"and see if that puts things right. ",
" ",
"---------------------------",
"| Description of Composer |",
"---------------------------",
" ",
"Pine has a built-in editing program which allows you to compose messages",
"without having to leave Pine.  The editor is designed to be very simple to",
"use so that you can get started writing email right away. ",
" ",
"Messages are usually just text, about 80 columns wide.  Using upper and",
"lower case is encouraged.  On some systems the size limit of the message",
"is about 100,000 characters, which is about 2,000 lines.  You can include",
"punctuation and special characters found on most keyboards, but you can't",
"include characters with diacritical marks and certain special symbols. ",
" ",
"Text automatically wraps as you type past the end of a line so you do not",
"have to hit return.  Using the {F4:\"Ctrl-J\"} command, you can also",
"reformat text explicitly, perhaps after you have deleted some text. ",
" ",
"You can include other text files with the {F5.:\"Ctrl-R\".} You will be",
"prompted for the file name of the file. ",
" ",
"------------------------------",
"| Brief Command Explanations |",
"------------------------------",
" ",
"MARK, CUT, AND PASTE",
" ",
"You can define a \"block\" of text, which can subsequently be deleted or",
"copied as a unit, by setting a mark at the start of the block (Ctrl-^) and",
"then moving the cursor to the end of the desired text block.  You can then",
"\"cut\" the block out ({F9:Ctrl-K}), move the cursor, and \"paste\" it",
"({F10:Ctrl-U}) in the new location.  You can paste more than once,",
"allowing you to use this feature to copy a block of text also. ",
" ",
"If you press {F9:Ctrl-K} without having marked anything, Pine will delete",
"a single line.  If you delete a group of lines together, Pine keeps them",
"in the same buffer, so {F10:Ctrl-U} will restore them as a block.  About",
"terminology:  Mark is shown as \"^^\".  The first \"^\" means you should",
"hold down the \"Control\" key on your keyboard.  The second \"^\" means",
"\"type the character ^\". ",
" ",
"JUSTIFY ({F4:Ctrl-J})",
" ",
"The justify command reformats the text in the paragraph the cursor is in.",
"Paragraphs are separated by one blank line.  This is useful when you have",
"been editing a paragraph and the lines become uneven.  The text is left",
"aligned or justified and the right is ragged.  If the text is already",
"justified as typed with auto-wrap, no justification will be done. ",
" ",
"READ FILE ({F5:Ctrl-R})  ",
" ",
"This will allow you to copy in text from an existing file. You will be",
"prompted for the name of a file to be inserted into the message.  The file",
"name is relative to your home directory or must be a full path name on",
"your system.  The file will be inserted where the cursor is located.  *The",
"file to be read must be on the same system as Pine.* If you use Pine on a",
"Unix machine but have files on a PC or MAC, the files must be transferred",
"to the system Pine is running on before they can be read.  Please ask your",
"local consultants about the correct way to transfer a file to your Pine",
"system as the method will vary from site to site. ",
" ",
"WHEREIS ({F6:Ctrl-W}) ",
" ",
"WhereIs searches the message body part of your composition and moves the",
"cursor to the first occurrence of the match string appearing after the",
"location of the cursor.  The search will wrap to the beginning of the",
"message when it no longer finds matches in the remainder of the message. ",
" ",
"To search for the same string a second time, press {F12:^W} to begin search",
"and then just press RETURN to accept the previous search string shown in",
"square brackets rather than entering a new search string.",
" ",
"WhereIs can \"search\" for the first line or last line of a message -- this",
"means that WhereIs is a jump-to-top and jump-to-bottom feature, too.",
" ",
"POSTPONE ({F11:Ctrl-O})",
" ",
"Temporarily stop working on the current message so you may read other",
"messages or compose another message.  When you want to resume a message",
"later, start to compose and answer \"yes\" to the \"Continue postponed",
"composition?\" question.  You may postpone as many messages as you like. ",
" ",
"SPELL CHECK ({F12:Ctrl-T})",
" ",
"Pine can call an external spell checking program to look over the message",
"you are composing.  By default, Pine uses the simple Unix spell checker.",
"There are no suggested alternative spellings, but Pine will show you the",
"\"incorrect\" word and let you fix it or move on.  If a word is misspelled",
"more than once, then you will be prompted to confirm the correction of",
"each occurrence of it.  Lines beginning with \">\" ( included messages)",
"will not be checked.  There is no spell check feature with PC-Pine. ",
" ",
"SEND ({F2:Ctrl-X})",
" ",
"Before sending a message, Pine will ask you to confirm that you want the",
"message to go out.  At that confirmation stage, Pine moves the composer",
"back to the top so that you can verify that the right people are getting",
"the message.  After confirmation, the message is sent and copied to the ",
"FCC folder (if any).",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_browse[] = {
 " ",
"Use this to browse files, perhaps created by some other application.  The",
"file name given can be a file in your home directory, an absolute file",
"path name for your system, or a file path relative to your home directory.",
"No wild card characters may be used.  In Unix Pine, you may use \"~\" to",
"refer to your home directory or \"~user\" to refer to another's home",
"directory.  The file must reside on the system running Pine. ",
" ",
"If the \"use-current-dir\" feature is set, names are relative to your",
"current directory at the time you started Pine, rather than to your ",
"home directory.",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_ins[] = {
 " ",
"Use this function to insert a text file into your message. The file name",
"given can be a file in your home directory, an absolute file path name for",
"your system, or a file path relative to your home directory.  No wild card",
"characters may be used.  In Unix Pine, you may use \"~\" to refer to your",
"home directory or \"~user\" to refer to another's home directory.  The",
"file must reside on the system running Pine. ",
" ",
"If the \"use-current-dir\" feature is set, names are relative to your",
"current directory at the time you started Pine, rather than to your ",
"home directory.",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_search[] = {
 " ",
"Search the message for a word or part of a word.  When searching in the",
"composer, only the message part of your mail is searched, and the cursor",
"is put on the first occurrence appearing after the location of the cursor. ",
"The search will wrap to the beginning of the message when it no longer",
"finds matches in the remainder of the message. ",
" ",
"To search for the same string a second time, press {F12:Ctrl-W} to begin",
"search and then just press RETURN to accept the previous search string",
"shown in square brackets rather than entering a new search string. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_to[] = {
 " ",
"Topics:",
" o The \"To:\" field",
" o Email Address Format",
" o Message Header Commands",
" ",
"-------------------",
"| The \"To:\" field |",
"-------------------",
" ",
"The address you enter here must be a valid address which is reachable",
"from your site.  If it is not, you will get an error message after sending",
"the message. ",
" ",
"------------------------",
"| Email Address Format |",
"------------------------",
" ",
"You may enter a full name and address, a local address that Pine will",
"complete for you, the nickname of someone in an address book, or a local",
"mail alias defined by your system administrator.  When you move the cursor",
"out of this field, the nicknames will be expanded to the addresses in your",
"address book, and the local names will be expanded to include the actual",
"user name.  You may enter as many addresses as you wish, but they must be",
"separated by commas.  You can move around this and other header fields",
"with the arrow keys and use many of the usual composer editing keys.",
" ",
"A valid email address on the Internet has a user name, an \"@\" sign and",
"then a domain.  For example, jsmith@art.nowhere.edu is the email address",
"of a person with the username \"jsmith\" who has an account with",
"\"art.nowhere.edu\".  The number of segments on the right of the \"@\"  ",
"sign can vary depending on how the address is structured for the",
"particular host.",
" ",
"If you are sending to someone on the same system as you are, you can leave",
"the \"@\" and all the information to its right off of the address, and",
"Pine will fill it in automatically.  Sometimes you can also abbreviate the",
"right part of the address if you are at the same domain.  When sending",
"messages across gateways to other networks, the addresses get more",
"complicated.  Ask your local consultants for the correct syntax from your",
"site to the network you are trying to reach.",
" ",
"                        MESSAGE HEADER COMMANDS",
" ",
"CURSOR MOTION KEYS----------------------|EDITING KEYS-------------------------",
"^B (Left Arrow)    Back character       | ^D       Delete current character  ",
"^F (Right Arrow)   Forward character    | ^H (DEL) Delete previous character ",
"^P (Up Arrow)      Previous line        | ",
"^N (Down Arrow)    Next line            | {F9:^K}       Cut marked text or",
"^A                 Beginning of line    |            delete current line",
"^E                 End of line          | {F10:^U }      Undelete line(s)",
"{F7:^Y}                 Previous page        |           ",
"{F8:^V}                 Next page            |-------------------------------------",
"^@ (Ctrl-SPACE)    Next word            |SCREEN/COMPOSITION COMMANDS",
"----------------------------------------| ",
"MESSAGE COMMANDS  | GENERAL COMMANDS    | {F12:^T }    To Addressbook/Browser",
"{F3:^C}   Cancel       |  {F1:^G}    Get help     | {F4:^J}     Attach File  ",
"{F11:^O }  Postpone     |  ^Z    Suspend      | ^L     Redraw Screen",
"{F2:^X}   Send         |                     | {F5:^R}     Rich Headers",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_cc[] = {
 " ",
"The Cc: field is just like the To: field, except it is used for addressees",
"that you wish to send a carbon copy to.  That is, the message is not directly",
"addressed to these recipients, but you wanted them to see the message.  The",
"only difference the recipients see is that their name is in the Cc: field,",
"rather than the To: field.",
" ",
"For information on email address format, check the Help for the To: header.",
" ",
"                        MESSAGE HEADER COMMANDS",
" ",
"CURSOR MOTION KEYS----------------------|EDITING KEYS-------------------------",
"^B (Left Arrow)    Back character       | ^D       Delete current character  ",
"^F (Right Arrow)   Forward character    | ^H (DEL) Delete previous character ",
"^P (Up Arrow)      Previous line        | ",
"^N (Down Arrow)    Next line            | {F9:^K}       Cut marked text or",
"^A                 Beginning of line    |            delete current line",
"^E                 End of line          | {F10:^U }      Undelete line(s)",
"{F7:^Y}                 Previous page        |           ",
"{F8:^V}                 Next page            |-------------------------------------",
"^@ (Ctrl-SPACE)    Next word            |SCREEN/COMPOSITION COMMANDS",
"----------------------------------------| ",
"MESSAGE COMMANDS  | GENERAL COMMANDS    | {F12:^T }    To Addressbook/Browser",
"{F3:^C}   Cancel       |  {F1:^G}    Get help     | {F4:^J}     Attach File  ",
"{F11:^O }  Postpone     |  ^Z    Suspend      | ^L     Redraw Screen",
"{F2:^X}   Send         |                     | {F5:^R}     Rich Headers",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_bcc[] = {
 " ",
"Bcc: is just the same as the To: and Cc: fields in the way the addresses",
"are entered.  The recipients listed here will receive a copy of the",
"message, but --assuming your site's mail transport software is properly",
"configured-- there will be nothing in the message header as delivered that",
"indicates a Bcc: was sent.  The To: and Cc: recipients will not know a",
"copy was sent to the Bcc: recipients. ",
"        ",
"For information on email address format, check the Help for the To: header.",
" ",
"                        MESSAGE HEADER COMMANDS",
" ",
"CURSOR MOTION KEYS----------------------|EDITING KEYS-------------------------",
"^B (Left Arrow)    Back character       | ^D       Delete current character  ",
"^F (Right Arrow)   Forward character    | ^H (DEL) Delete previous character ",
"^P (Up Arrow)      Previous line        | ",
"^N (Down Arrow)    Next line            | {F9:^K}       Cut marked text or",
"^A                 Beginning of line    |            delete current line",
"^E                 End of line          | {F10:^U }      Undelete line(s)",
"{F7:^Y}                 Previous page        |           ",
"{F8:^V}                 Next page            |-------------------------------------",
"^@ (Ctrl-SPACE)    Next word            |SCREEN/COMPOSITION COMMANDS",
"----------------------------------------| ",
"MESSAGE COMMANDS  | GENERAL COMMANDS    | {F12:^T }    To Addressbook/Browser",
"{F3:^C}   Cancel       |  {F1:^G}    Get help     | {F4:^J}     Attach File  ",
"{F11:^O }  Postpone     |  ^Z    Suspend      | ^L     Redraw Screen",
"{F2:^X}   Send         |                     | {F5:^R}     Rich Headers",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_from[] = {
 " ",
"This header carries your return address.  It is the address toward which",
"replies (and often, future unrelated correspondence) will be directed,",
"unless you have defined an optional \"Reply-To:\" header.  Make sure this",
"address is correct! ",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_reply_to[] = {
 " ",
"Most people should not need this header. The Reply-To: header is used in",
"cases where you would like replies to your messages to be directed to an",
"address other than your normal \"From:\" address.  This is atypical, but",
"can happen when you use multiple machines and do not have the same account",
"name on each one, or when you wish to direct certain replies to accounts",
"or folders designated for specific classes of correspondence. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_custom_addr[] = {
 " ",
"This is a customized header, i.e. not one that is part of Pine's normal",
"set of Compose headers.",
" ",
"For information on email address format, check the Help for the To: header.",
" ",
"                        MESSAGE HEADER COMMANDS",
" ",
"CURSOR MOTION KEYS----------------------|EDITING KEYS-------------------------",
"^B (Left Arrow)    Back character       | ^D       Delete current character  ",
"^F (Right Arrow)   Forward character    | ^H (DEL) Delete previous character ",
"^P (Up Arrow)      Previous line        | ",
"^N (Down Arrow)    Next line            | {F9:^K}       Cut marked text or",
"^A                 Beginning of line    |            delete current line",
"^E                 End of line          | {F10:^U }      Undelete line(s)",
"{F7:^Y}                 Previous page        |           ",
"{F8:^V}                 Next page            |-------------------------------------",
"^@ (Ctrl-SPACE)    Next word            |SCREEN/COMPOSITION COMMANDS",
"----------------------------------------| ",
"MESSAGE COMMANDS  | GENERAL COMMANDS    | {F12:^T }    To Addressbook/Browser",
"{F3:^C}   Cancel       |  {F1:^G}    Get help     | {F4:^J}     Attach File  ",
"{F11:^O }  Postpone     |  ^Z    Suspend      | ^L     Redraw Screen",
"{F2:^X}   Send         |                     | {F5:^R}     Rich Headers",
" ",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_custom_free[] = {
 " ",
"This is a customized header, i.e. not one that is part of Pine's normal",
"set of Compose headers.",
" ",
"This field consists of arbitrary text.",
" ",
"                        MESSAGE HEADER COMMANDS",
" ",
"CURSOR MOTION KEYS----------------------|EDITING KEYS-------------------------",
"^B (Left Arrow)    Back character       | ^D       Delete current character  ",
"^F (Right Arrow)   Forward character    | ^H (DEL) Delete previous character ",
"^P (Up Arrow)      Previous line        | ",
"^N (Down Arrow)    Next line            | {F9:^K}       Cut marked text or",
"^A                 Beginning of line    |            delete current line",
"^E                 End of line          | {F10:^U }      Undelete line(s)",
"{F7:^Y}                 Previous page        |           ",
"{F8:^V}                 Next page            |-------------------------------------",
"^@ (Ctrl-SPACE)    Next word            |SCREEN/COMPOSITION COMMANDS",
"----------------------------------------| ",
"MESSAGE COMMANDS  | GENERAL COMMANDS    | {F12:^T }    To Addressbook/Browser",
"{F3:^C}   Cancel       |  {F1:^G}    Get help     | {F4:^J}     Attach File  ",
"{F11:^O }  Postpone     |  ^Z    Suspend      | ^L     Redraw Screen",
"{F2:^X}   Send         |                     | {F5:^R}     Rich Headers",
" ",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_news[] = {
 " ",
"Use the Newsgroups line to specify any and all USENET newsgroups to which",
"your message should be posted.  When composing a message from scratch, this",
"line may be hidden.  If so, just press the rich headers command",
"({F5:Ctrl-R}) to make it visible.",
" ",
"Be aware that when you post to a newsgroup thousands of people will be reading",
"your message.  Also, you or your system manager must have defined a \"nntp-",
"server\" in your Pine configuration in order for you to be able to post.",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_fcc[] = {
 " ",
"The FCC (File Carbon Copy) specifies the folder used to keep a copy of",
"each outgoing message.  The default value can be configured with the",
"\"default-fcc\" and \"fcc-name-rule\" options.  You can change or remove",
"the file carbon copy on any message you send by editing the FCC header. ",
" ",
"You may type ^T to get a list of all your folders and select one to use as",
"the FCC for this message. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_subject[] = {
 "                ",
"The subject header provides a place to enter a few words that summarize",
"the topic of the message you are sending.  You may leave this line blank,",
"but it is considered a courtesy to use a meaningful subject. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_attachment[] = {
 " ",
"This field is where you specify what file or files you'd like attached to",
"the message you are composing.  Those files must reside on the machine",
"running Pine. If your file is on a PC or Mac and you run Pine with an",
"account on a Unix machine, you'll have to transfer it before attaching it. ",
"Contact local computer support people for assistance with transferring. ",
" ",
"Pine uses MIME encoding for attachments, so binaries and files of any",
"length can safely be delivered to any MIME capable mail reading program.",
"If you send an attachment to someone who does not have a MIME-capable mail",
"reading program yet, then the main message text will be readable, but",
"attachments (even attachments which are just plain text) are not. ",
" ",
"Typing the filename on the Attchmts: line achieves the same result as using",
"the {F6:Ctrl-J} command.",
" ",
"If you Forward a message with attachments, you may delete them from your",
"Forwarded message by editing the Attchmnt header line.",
" ",
"<End of help on this topic>",
NULL
};


char *h_composer_placeholder[] = {
 " ",
"                           MESSAGE HEADER COMMANDS",
" ",
"CURSOR MOTION KEYS                      |EDITING KEYS",
"^B (Left Arrow)    Back character       | ^D       Delete current character  ",
"^F (Right Arrow)   Forward character    | ^H (DEL) Delete previous character ",
"^P (Up Arrow)      Previous line        | ",
"^N (Down Arrow)    Next line            | {F9:^K}       Cut marked text or",
"^A                 Beginning of line    |               delete current line",
"^E                 End of line          | {F10:^U }     Undelete line(s)",
"{F7:^Y}                 Previous page        |           ",
"{F8:^V}                 Next page            |-------------------------------------",
"^@ (Ctrl-SPACE)    Next word           |SCREEN/COMPOSITION COMMANDS",
"---------------------------------------| MESSAGE COMMANDS | GENERAL COMMANDS    | {F12:^T }    To Addressbook/Browser",
"{F3:^C}   Cancel     |  {F1:^G}    Get help     | {F4:^J}       Attach File  ",
"{F11:^O }  Postpone    |  ^Z    Suspend      | ^L       Redraw Screen",
"{F2:^X}   Send       |                   | {F5:^R}       Rich Headers",
" ",
" ",
"---------------------",
"|  Message Headers  |",
"---------------------",
" ",
"Message headers are the electronic equivalent of the envelope on postal",
"email.  They say who a message is to and who it is from; who should get",
"copies and what the message is about.",
" ",
"Standard headers which you supply include To:, Cc:, Attchmts:, and",
"Subject:.  There are other headers which are called \"rich headers\".  They",
"are present on every message, but are normally filled out automatically and",
"hidden from you.  Rich headers include Fcc:, Bcc:, and Newsgroups:.",
"Pressing the {F5:Ctrl-R} key lets you see and modify any of the rich header",
"lines.",
" ",
"Pine introduced a user-defined headers capabilities into version 3.90.  You",
"may specify which headers should be part of the default set and may also",
"define any arbitrary headers you want added to your email.  This is done",
"with the \"default-composer-hdrs\" and \"customized-hdrs\" configuration",
"settings.",
" ",
"TO, CC, and BCC",
" ",
"These lines specify the various recipients of the message you are about to",
"send.  Anything specified an any of these lines must be a valid email",
"address which your system can recognize (see below).  You can also type in",
"nicknames from the address book for any of these. The distinction between",
"To and Cc is a remnant of the time when a memo would be carbon copied to",
"\"other\" parties.  With email, recipients on the To: and Cc: lines get the",
"message in the same way, but the difference might give recipients clues",
"about who is expected to act on the message.",
" ",
"Bcc stands for \"blind carbon copy\".  People listed on the Bcc line do ",
"get a copy of the message, but their names do not appear anywhere on the ",
"envelope.  Blind carbon copies are used to allow some parties to read email ",
"without the other parties to the message knowing they got it.  It can also be ",
"used when sending email to a large group of people.",
" ",
"ATTACHMENTS",
" ",
"This field is where you specify what file or files should be attached to",
"the current message.  Those files must reside on the machine running Pine.",
"If your file is on a PC or Mac and you run Pine with an account on a Unix",
"machine, you'll have to transfer it before attaching it.  Contact local",
"computer support people for assistance with transferring.",
" ",
"Pine uses MIME encoding for attachments, so binaries and files of any",
"length can safely be delivered to any MIME capable mail reading program.",
"If you send an attachment to someone who doesn't have a MIME mail reading",
"program, then he main text will be readable, but attachments (even",
"attachments which are just plain text) are not.",
" ",
"Typing the filename on the Attchmts: line achieves the same result as using",
"the {F6:Ctrl-J} command.",
" ",
"SUBJECT",
" ",
"The subject is your chance to give a few words which will give context to",
"the message you are sending.  You may leave this line blank, but it is",
"considered a courtesy to use a meaningful subject.",
" ",
"FCC (File Carbon Copy)",
" ",
"Fcc specifies the folder which will keep a copy of this piece of outgoing",
"email.  The default value can be configured with the \"default-fcc\" and",
"\"fcc-name-rule\" variables.  You can change or remove the folder carbon",
"copy on a message by message basis by editing the Fcc line.",
" ",
"NEWSGROUPS",
" ",
"Use the Newsgroups line to specify any and all USENET newsgroups to which",
"your message should be posted.  When composing a message from scratch, this",
"line may be hidden.  If so, just press the rich headers command",
"({F5:Ctrl-R}) to make it visible.",
" ",
"Be aware that when you post to a newsgroup thousands of people will be reading ",
"your message.  Also, you or your system manager must have defined a \"nntp-",
"server\" in your Pine configuration in order for you to be able to post. ",
" ",
"-------------------------",
"| Valid Email Addresses |",
"-------------------------",
" ",
"When you enter an email address into the address field of your address    ",
"book you are giving Pine an address that it must be able to actually",
"reach.  The address you enter here must be a valid address which is ",
"reachable from your site.  If it is not, you will get an error message",
"after sending the message.",
" ",
"A valid email address on the Internet has a user name, an \"@\" sign and",
"then a domain.  For example, jsmith@art.nowhere.edu is the email address",
"of a person with the username \"jsmith\" who has an account with",
"\"art.nowhere.edu\".  The number of segments on the right of the \"@\"   ",
"sign can vary depending on how the address is structured for the",
"particular host.",
" ",
"If you are sending to someone on the same system as you are, you can leave",
"the \"@\" and all the information to its right off of the address, and",
"Pine will fill it in automatically.  Sometimes you can also abbreviate the",
"right part of the address if you are at the same domain.  When sending",
"messages across gateways to other networks, the addresses get more",
"complicated.  Ask your local consultants for the correct syntax from your",
"site to the network you are trying to reach.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_generic[] = {
 " ",
"--------------------------------",
"| Setup Configuration Commands |",
"--------------------------------",
" ",
"To change the current variable, press change ({F4:C}), add ({F9:A}) or",
"delete ({F10:D}) as appropriate.  To exit this configuration screen, press",
"{F3:E}.  Pine will save new configurations as you set them, there is no",
"need to save these settings.  Some changes will not take effect until your",
"next Pine session. ",
" ",
"Message Selection Commands ",
"--------------------------",
"{F3 : E }  Exit the Configuration Screen   {F9:A}  Add Value",
"{F4 : C }  Change the current setting      {F10:D}  Delete Value",
" ",
"Navigating the List of Settings           General Pine Commands ",
"-------------------------------           ---------------------",
"{F5 : P }  Move to previous entry               {F1 : ? }  Show this help text",
"{F6 : N }  Move to next entry                   {F3 : E }  Exit SETUP CONFIGURATION",
"{F7 : - }  Show previous screen of configuration               ",
"{F8 :Spc}  Show next screen of configuration",
"{F12: W }  WhereIs (search through configuration)",
" ",
NULL
};


char *h_config_generic_feature_list[] = {
 "--------------------------------",
"| Setup Configuration Commands |",
"--------------------------------",
" ",
"To change the current variable, press {F4:X}.  To exit this Setup",
"Configuration screen, press {F3:E}.  Pine will save new options as you set",
"them, there is no need to save these settings.  However, some changes will",
"not take effect until your next Pine session. ",
" ",
"Message Selection Commands ",
"--------------------------",
"{F3 : E }  Exit the Setup Config Screen",
"{F4 : X }  Change (set or unset) the currently highlighted setting",
" ",
"Navigating the List of Settings           General Pine Commands ",
"-------------------------------           ---------------------",
"{F5 : P }  Move to previous entry               {F1 : ? }  Show this help text",
"{F6 : N }  Move to next entry                   {F3 : E }  Exit SETUP CONFIGURATION",
"{F7 : - }  Show previous screen of options",
"{F8 :Spc}  Show next screen of options",
"{F12: W }  WhereIs (search through options)",
" ",
NULL
};


char *h_config_generic_radio[] = {
 " ",
"--------------------------------",
"| Setup Configuration Commands |",
"--------------------------------",
" ",
"To change the current variable, press {F4:S}.  To exit this Setup",
"Configuration screen, press {F3:E}.  Pine will save new options as you set",
"them, there is no need to save these settings.  However, some changes will",
"not take effect until your next Pine session. ",
" ",
"Message Selection Commands ",
"--------------------------",
"{F3 : E }  Exit the Setup Config Screen",
"{F4 : S }  Change to the currently highlighted setting",
" ",
"Navigating the List of Settings           General Pine Commands ",
"-------------------------------           ---------------------",
"{F5 : P }  Move to previous entry               {F1 : ? }  Show this help text",
"{F6 : N }  Move to next entry                   {F3 : E }  Exit SETUP CONFIGURATION",
"{F7 : - }  Show previous screen of options",
"{F8 :Spc}  Show next screen of options",
"{F12: W }  WhereIs (search through options)",
" ",
NULL
};


char *h_config_pers_name[] = {
 "        OPTION: Personal-Name",
" ",
"This value is used to determine the full name part of the \"From\" address",
"on messages you send.  If unset, Unix Pine will obtain your full name from",
"the system password file. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_user_id[] = {
 "        OPTION: User-Identification",
" ",
"This value is used as part of the \"From\" address on messages you send.",
"It is also the default login name for remote IMAP server access.  Set this",
"to the username part you want to appear on outgoing email. ",
" ",
"<End of help on this topic> ",
NULL
};


char *h_config_user_dom[] = {
 "        OPTION: User-Domain",
" ",
"This value specifies the domain part (right-hand side) of your return",
"address on outgoing email and is also used as the default domain for email",
"composed to a local user.  If unset, Unix Pine will obtain the domain from",
"the system.  Often this value will be set for your whole site by the",
"system administrator. ",
" ",
"If you set this, see also the \"quell-user-lookup-in-passwd-file\" feature.",
" ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_smtp_server[] = {
 "        OPTION: SMTP-Server",
" ",
"This value specifies the name of one or more SMTP servers for sending",
"mail. You must have an SMTP server for use with PC-Pine.  SMTP servers are",
"normally setup by a system administrator for use by all members of a given",
"campus or department.  Contact your local help desk to ask what SMTP",
"servers you should use.  Unix Pine users do not need to use an SMTP server",
"and can leave this blank. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_nntp_server[] = {
 "        OPTION: NNTP-Server",
" ",
"This value specifies the name of the NNTP (Network News Transfer Protocol)",
"server for reading and posting USENET news.  NNTP servers are normally",
"setup by a system administrator for use by all members of a given campus",
"or department.  Contact your local help desk to ask what NNTP servers you",
"should use.  Often Unix Pine users will find that this variable has been",
"set for the whole system (and you don't have to worry about it).  When you",
"define an NNTP server here, Pine implicitly defines a news collection for",
"you, assuming that server as the news server and assuming that you will",
"use the NNTP protocol and a local newsrc configuration file for reading",
"news.  For more about reading news with Pine, see the release notes. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_inbox_path[] = {
 "        OPTION: Inbox-Path",
" ",
"This value over-rides the default value of your INBOX name/path/location.",
"PC-Pine users must specify an inbox path and it must be a folder on an",
"IMAP server.  Unix and VMS Pine users will often find that this variable",
"has been pre-configured by your system administrator.  You may be able to",
"specify an alternate INBOX which is either a local folder or a folder on",
"an IMAP server. ",
" ",
"A typical remote inbox-path entry would be: {{:{}monet.art.nowhere.edu}INBOX",
"where \"monet.art.nowhere.edu\" is replaced by the name of your IMAP",
"mail server.",
" ",
"FOR MORE INFORMATION: From the Main Menu, select \"L FOLDER LIST\" and",
"press \"?\" for Help... Look for the section \"Valid Folder Names\".",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_folder_spec[] = {
 "        OPTION: Folder-Collections",
" ",
"Folder collections are \"places\" to store folders.  They roughly",
"correspond to a filesystem \"directory\". Pine will normally provide you",
"with one folder collection by default.  Using this option, you may",
"specify additional collections.  These collections may be local or remote, ",
"but they must correspond to a pre-existing filesystem directory, i.e.",
"Pine will not create any directory other than the original default.",
" ",
"The first folder collection listed here is the default collection for the",
"Save command -- the place various folders are put unless you specify",
"otherwise. ",
" ",
"A valid local collection is just the specification of a directory on the",
"local system followed by square brackets.  For example, \"ART-101\\[]\" may",
"be valid on a PC and \"exhibit/[]\" may be valid on Unix.",
" ",
"Pine also allows you to access a collection on a remote computer (provided",
"it supports IMAP and you have the right to store folders on it.)",
"To specify a remote folder collection, you need to give the name of the",
"IMAP mail server, the name of the collection on that server, and the square",
"brackets.  For instance, \"{{:{}wharhol.art.nowhere.edu}art-101/[]\" is a",
"remote collection.  As you can tell, the name of the computer is in {{:{}}",
"brackets followed immediately by the name of the collection. ",
" ",
"Collection syntax: ",
" ",
" optional-label {{:{}optional-imap-hostname}optional-directory-path[]",
" ",
"Additional examples:",
" ",
" Saved-Email {{:{}klee.art.nowhere.edu}mail/[]  <-- Remote collection",
" Widget-Project widget/[]                   <-- Local collection (Unix)",
" Desktop        MAIL\\[]                    <-- Local collection (PC)",
" ",
"Use the following SETUP CONFIGURATION commands to manipulate your folder",
"collections list:",
" ",
" {F9 : A}  Add Value",
" {F10: D}  Delete Value",
" {F4 : C}  Change the current setting    ",
" ",
"FOR MORE INFORMATION: From the Main Menu, select \"L FOLDER LIST\" and",
"press \"?\" for Help... Look for the section on \"Folder Collections\".",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_news_spec[] = {
 "         OPTION: News-Collections",
" ",
"This value defines one or more collections of incoming newsgroup folders;",
"however, most people will not need to use this option since setting the",
"nntp-server option will implicitly define the most common news-collection",
"configuration.",
" ",
"You can use this to set a specific news collection other than that defined",
"implicitly by defining an NNTP server.  News collections defined here can",
"take several forms:",
" ",
"  Partial newsfeeds:            News *{{:{}news.nowhere.edu/nntp}[comp.*] ",
"  News on the local host:       News *[] ",
"  Newsfeeds accessed via IMAP:  News *{{:{}news.nowhere.edu}[]",
" ",
"FOR MORE INFORMATION on collections, check the help for the \"Folder",
"Collections\" option above and the help for the FOLDER LIST screen.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_default_fcc[] = {
 "         OPTION: Default-FCC (File Carbon Copy)",
" ",
"This value specifies where a copy of outgoing mail should be saved.  If",
"this is not a path name, it will be in the default collection for saves. ",
"Any valid folder specification, local or IMAP, is allowed.  This default",
"folder carbon copy only applies when the fcc-rule-name (see later in this",
"configuration screen) is set to use the default folder.  Unix Pine default",
"is normally \"sent-mail\" in the default folder collection. PC-Pine",
"default is \"SENTMAIL\" (normally stored as SENTMAIL.MTX)",
" ",
"To suppress saving of outgoing mail, set: default-fcc=\"\"",
" ",
"FOR MORE INFORMATION: From the Main Menu, select \"L FOLDER LIST\" and",
"press \"?\" for Help... Look for the section \"Valid Folder Names\".",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_postponed_folder[] = {
 "         OPTION: Postponed-Folder",
" ",
"This value over-rides the default name for the folder where postponed",
"messages are saved.  If this is not a path name, it will be in the default",
"collection for message Saves.  Any valid folder specification, local or",
"remote, is allowed.  The Unix Pine default is normally \"postponed-mail\"",
"in the default collection. PC-Pine default is \"POSTPOND\" (stored as",
"POSTPOND.MTX)",
" ",
"FOR MORE INFORMATION: From the Main Menu, select \"L FOLDER LIST\" and",
"press \"?\" for Help... Look for the section \"Valid Folder Names\".",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_read_message_folder[] = {
 "         OPTION: Read-Message-Folder",
" ",
"By virtue of specifying a folder name here, Pine will be configured to",
"save all messages which you have read during a session into the designated",
"\"read messages\" folder.  This allows you to more easily distinguish",
"between your really new email (in your INBOX) and those which you have",
"already read.  Depending on how you define the \"auto-move-read-messages\"",
"setting in the \"feature-list\", you may or may not be asked when you quit",
"Pine if you want read messages to be moved to this folder.  In either",
"case, moving the messages means they will be deleted from your INBOX. ",
" ",
"If this is not a path name, it will be in the default collection for",
"saves.  Any valid folder specification, local or remote (via IMAP), is",
"allowed.  There is no default for the name of the read message folder. ",
" ",
"FOR MORE INFORMATION: From the Main Menu, select \"L FOLDER LIST\" and",
"press \"?\" for Help... Look for the section \"Valid Folder Names\".",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_newsrc_path[] = {
 "        OPTION: newsrc-path",
" ",
"This option over-rides the default name Pine uses for your \"newsrc\" news",
"status and subscription file.  If set, Pine will take this value as the",
"full pathname for the desired newsrc file. ",
" ",
"If this option is not set, Unix Pine looks for the file ~/.newsrc and ",
"PC-Pine looks first for  $HOME\\NEWSRC  (where $HOME defaults to the root ",
"of the current drive, e.g. \"C:\\\" ) and then it looks in the same ",
"directory as your pinerc file for NEWSRC.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_signature_file[] = {
 "        OPTION: Signature-File",
" ",
"This is the name of a file which will be automatically inserted into",
"outgoing messages.  It typically contains information such as your name,",
"email address and organizational affiliation.  Pine adds the signature",
"into the message as soon as you enter the composer so you can choose to",
"remove it on a message by message basis.  Signature file placement in",
"message replies is controlled by the \"signature-at-bottom\" setting in",
"the feature list. ",
" ",
"The default file name on Unix is \".signature\"; on PC-Pine the file is in",
"the same directory as your PINERC file, under the name \"\\PINE.SIG\". ",
"The signature file must be kept on the local system, not a remote IMAP",
"server. ",
" ",
"To create a signature file, use your favorite text editor, such as ",
"pico, vi, or emacs, and enter a *few* lines of text containing your",
"identity and affiliation.  Save this text to the file \".signature\"",
"unless you use this option to specify a different file name.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_addressbook[] = {
 "        OPTION: Address-Book",
" ",
"This value over-rides the default name of your personal address book file.  ",
"You may also define additional personal address books, to which you",
"may add selected addresses from within Pine.",
" ",
"The default is to have a single address book.  On Unix the file is named",
"\"~/.addressbook\" and on PCs the file is in the same directory as your",
"PINERC file, under the name \"\\ADDRBOOK\". ",
" ",
"At this time address books must be kept on the local system, not a remote",
"IMAP server.  If you override the default name for PC-Pine's addressbook,",
"do not add a filename extension, since Pine will use your specified name",
"and add a \".lu\" extension when it generates its auxiliary index (look",
"up) file. ",
" ",
"You may optionally precede the file name with a label that will be used",
"for identification in the ADDRESS BOOK display.  For example: ",
" ",
"   PERSONAL addrbook",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_global_addrbook[] = {
 "        OPTION: Global-Address-Book",
" ",
"This value specifies the name(s) of global (system-wide) address books.",
"Defining these will typically be done in the system-wide Pine",
"configuration file by your system administrator.  This option may be used",
"to specify one for a shared workgroup addressbook, or to over-ride the",
"system-wide default, if it exists. ",
" ",
"You may optionally precede the file name with a label that will be used",
"for identification in the ADDRESS BOOK display.  For example: ",
" ",
"   WORKGROUP wgaddrbk",
" ",
"Global address books must be accessible via normal file access routines ",
"on the machine where Pine is running.  Unlike personal address books,",
"global address books may not be modified/updated from within Pine;",
"that is, they are Read-Only. ",
" ",
"There is no default value for this option. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_init_cmd_list[] = {
 "        OPTION: Initial-Keystroke-List",
" ",
"The initial keystroke --or command-- list option lets you start Pine at",
"any place you like.  Whatever keystrokes you specify here will be executed",
"by Pine upon startup as a macro.  The words SPACE, TAB, DOWN, UP, LEFT, and",
"RIGHT indicate the pressing of those keys.  CR indicates the pressing of",
"the RETURN key.  F1 through F12 represent the function keys.  For example,",
"to view message 1 on startup, you would specify i,j,1,CR,v. ",
" ",
"Restriction: You cannot pre-type into the composer with the initial",
"keystroke list. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_comp_hdrs[] = {
 "        OPTION: Default-Composer-Headers",
" ",
"You can decide which headers you want visible when composing outgoing",
"email using this option.  You can specify any of the regular set, any rich",
"header or any custom header which you have already defined.  If you use",
"this setting at all, you must specify all the headers you want to see, you",
"can't just add to the regular header set.  The default set is To:, Cc:,",
"Attchmnt:, and Subject:. ",
" ",
"Note that the \"Newsgroups:\" header will be abbreviated in the Composer ",
"display, but should be spelled-in-full here.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_custom_hdrs[] = {
 "        OPTION: Customized-Headers",
" ",
"You may add your own custom headers to all outgoing messages.  Each header",
"you specify here must include the header tag (Reply-to:, Approved:, etc.)",
"and may optionally include a value for that header.  If you want to see",
"these custom headers each time you compose a message, you must add them to",
"your default composer headers list (see above), otherwise they become part",
"of the rich header set which you only see when you press the rich header",
"(Ctrl-R) command. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_saved_msg_name_rule[] = {
 "        OPTION: Saved-Msg-Name-Rule",
" ",
"This option determines the default folder name for Saves... Choose either:",
"default-folder, by-sender, by-from, by-recipient, last-folder-used. ",
"Normal default is \"default-folder\", which on Unix means",
"\"saved-messages\" and in PC-Pine means \"SAVEMAIL\". ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_fcc_rule[] = {
 "        OPTION: FCC-Name-Rule",
" ",
"This option determines the default name for folder carbon copy. Choose",
"one: default-fcc, by-recipient, last-fcc-used.  Normal default is",
"\"default-fcc\", the value of which is set in the \"default-fcc\" variable",
"as specified earlier in this configuration.  Note that whatever the fcc",
"specified here, it will be overwridden by any fcc entries you have in your",
"address book. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_sort_key[] = {
 "        OPTION: Sort-Key",
" ",
"This option determines the order in which messages will be displayed in",
"the Folder Index screen.  Choose from: ",
" ",
" o Date -- Sort folders according to the date and time they were",
"     sent. On a folder like INBOX, sorting by \"Date\" should be almost",
"     identical to sorting by \"Arrival\".",
" o Arrival -- Sort messages into the order in which they arrived.",
" o From -- Sort messages by the name of the author of the message.",
"     Messages with the same author are grouped together. Groups of",
"     messages are then put into alphabetical order according to message         ",
"     author.",
" o Subject -- Sort messages by subject. Messages with the same",
"     subject are grouped together. Pine ignores leading \"Re:\" and \"re:\"",
"     and trailing \"(fwd)\" when determining the likeness and",
"     alphabetical order of subject lines. Groups of messages are put",
"     into alphabetical order according to subject.",
" o OrderedSubj -- Grouping of all messages with the same subject",
"     together is done in the same way as sort by subject. With",
"     \"OrderedSubj\" however, groups of messages are put into date order",
"     according to the oldest message on a given subject. This sorting",
"     provides pseudo threading of messages.",
" o ReverseDate -- Like \"Date\" but the newest message is first.",
" o ReverseArrival -- Like \"Arrival\" but the newest message is first.",
" o ReverseFrom -- Like \"From\" but groups of messages are ordered in",
"     reverse alphabetical order (Z-A).",
" o ReverseSubject -- Like \"Subject\" but groups of messages are",
"     ordered in reverse alphabetical order (Z-A).",
" o ReverseOrderedSubj -- Like \"OrderedSubj\" but groups of messages",
"     are ordered with the newest groups first (according to the first",
"     message of each group)",
" ",
"Normal default is \"arrival\".",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_ab_sort_rule[] = {
 "        OPTION: Address-Book-Sort-Rule",
" ",
"This option controls the order in which address book entries will be",
"presented.  Choose one of the following: ",
" ",
"fullname                  use fullname field, lists mixed in ",
"fullname-with-lists-last  use fullname field, but put lists at end",
"nickname                  use nickname field, lists mixed in ",
"nickname-with-lists-last  use nickname field, but put lists at end ",
"dont-sort                 don't change order of file",
" ",
"The normal default is \"fullname-with-lists-last\".",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_char_set[] = {
 "        OPTION: Character-Set",
" ",
"The character set is used primarilly to mark outgoing email appropriately.",
"Set it to whatever character set you might use to compose messages.",
"Whenever you actually send a message, Pine checks it to see if it is, in",
"fact, US-ASCII (a subset of the other sets allowable). If it is US-ASCII,",
"the outgoing message will be marked as such no matter what you have set as",
"your character set. Normal default is US-ASCII.  Typical alternatives",
"include ISO-8859-x, where x is a number between 1 and 9. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_editor[] = {
 "        OPTION: Alternate-Editor",
" ",
"Editor specifies the program invoked by ^_ in the Composer. This is",
"normally an alternative to Pine's internal composer (Pico).  You could use",
"this setting to specify an alternate editor to use occasionally or if you",
"have a favorite editor and want to use it all the time (see the \"enable-",
"alternate-editor-implicitly\" setting).  In either case, the",
"\"enable-alternate-editor\" feature must be turned on too. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_image_viewer[] = {
 "        OPTION: Image-Viewer",
" ",
"This option specifies the program Pine should call to view MIME",
"attachments of type IMAGE (e.g. GIF or TIFF).  The Image Viewer setting is",
"no longer needed, but remains for backward compatibility.  The more",
"general method for associating external printing and viewing programs with",
"specific MIME data types is to use the system's (or your personal)",
"\"mailcap\" configuration file. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_domain_name[] = {
 "        OPTION: Use-Only-Domain-Name",
" ",
"This option is used only if the \"user-domain\" option is *not* set.  If set",
"to \"Yes\" (and user-domain is not used), then Pine strips the hostname from",
"your return (\"From\") address and when completing unqualified addresses",
"that you enter into the composer. ",
" ",
"If you set this, see also the \"quell-user-lookup-in-passwd-file\" feature.",
" ",
"Not applicable to PC-Pine. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_prune_date[] = {
 "        OPTION: Last-Time-Prune Question",
" ",
"This value records the last time you were asked about deleting old",
"sent-mail. It is set automatically by Pine at the beginning of each",
"month. If you wish to suppress the monthly sent-mail pruning feature, set",
"this to a date in the future, e.g. 99.12",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_full_hdr[] = {
 "        FEATURE: enable-full-header-cmd",
" ",
"This feature enables the \"H Full Headers\" command which toggles between",
"the display of all headers in the message and the normal edited view of",
"headers.  The Full Header command also controls which headers are included",
"for Export, Pipe, Print, Forward, and Reply functions.  (For Reply, the",
"Full Header mode will respect the \"include-headers-in-reply\" feature",
"setting.)",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_pipe[] = {
 "        FEATURE: enable-unix-pipe-cmd",
" ",
"This feature enables the \"| Pipe\" command that sends the current message",
"to the specified Unix command for external processing.  Not available on",
"PC-Pine.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_tab_complete[] = {
 "        FEATURE: enable-tab-completion",
" ",
"This feature enables the TAB key when at a prompt for a filename. In this",
"case, TAB will cause the partial name already entered to be automatically",
"completed, provided the partial name is unambiguous.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_quit_wo_confirm[] = {
 "         FEATURE: quit-without-confirm",
" ",
"This feature controls whether or not Pine will ask for confirmation when a",
"Quit command is received.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_jump[] = {
 "         FEATURE: enable-jump-shortcut",
" ",
"Setting this feature will allow you to enter a number (followed by RETURN)",
"and jump to that message number, when in the FOLDER INDEX or MESSAGE TEXT",
"screens.  In other words, it obviates the need for typing the \"J\" for the",
"Jump command.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_alt_ed[] = {
 "        FEATURE: enable-alternate-editor-cmd",
" ",
"If this feature is set, and the \"editor\" variable is not set, entering",
"the ^_ (Control-underscore) key while composing a message will prompt you",
"for the name of the editor you would like to use.",
" ",
"If the environment variable $EDITOR is set, this value will be offered as",
"a default.  If \"editor\" variable is set, the ^_ key will activate the",
"specified editor without prompting, in which case it is not necessary to",
"set the \"enable-alternate-editor\" feature.  This feature is not",
"available in PC-Pine. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_alt_ed_now[] = {
 "         FEATURE: enable-alternate-editor-implicitly",
" ",
"If this feature and the \"editor\" variable are both set, Pine will",
"automatically activate the specified editor when the cursor is moved from",
"the header of the message being composed into the message text.  For",
"replies, the alternate editor will be activated immediately.  This feature",
"is not available in PC-Pine.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_bounce[] = {
 "         FEATURE: enable-bounce-cmd",
" ",
"Setting this feature enables the \"B Bounce\" command, which will prompt",
"for an address and *remail* the message to the new recipient.  This command",
"is used to re-direct messages that you have received in error, or need to ",
"be redirected for some other reason (e.g. list moderation).  The final",
"recipient will see a header indicating that you have Resent the msg, but",
"the message's From: header will show the original author of the message,",
"and replies to it will go back to that author, and not to you.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_agg_ops[] = {
 "         FEATURE: enable-aggregate-command-set",
" ",
"Setting this feature enables the commands and subcommands that relate to",
"performing operations on more than one message at a time.  We call these",
"\"aggregate operations\".  In particular, the \"; Select\", \"A Apply\",",
"and \"Z Zoom\" commands are enabled by this feature.  Select is used to",
"\"tag\" one or more messages meeting the specified criteria.  Apply can",
"then be used to apply any message command to all of the selected/tagged",
"messages.  Further, the Zoom command allows you to toggle the Folder Index",
"view between just those Selected and all messages in the folder. ",
" ",
"This feature also enables the \"^X\" sub-command in the FOLDER INDEX WhereIs ",
"command which causes all messages matching the WhereIs argument to become",
"selected.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_flag[] = {
 "         FEATURE: enable-flag-cmd",
" ",
"Setting this feature enables the \"* Flag\" command which allows you to",
"manipulate the status flags associated with a message.  By default, Flag",
"will set the \"Important\" flag, which results in an asterisk being",
"displayed in column one of the FOLDER INDEX for such messages.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_can_suspend[] = {
 "         FEATURE: enable-suspend",
" ",
"Setting this feature will allow you to type ^Z (Control Z) and temporarily",
"suspend Pine.  Not available on PC-Pine.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_expanded_folders[] = {
 "         FEATURE: expanded-view-of-folders",
" ",
"If multiple folder collections are defined, and you wish to have them all",
"expanded implicitly upon entering the FOLDER LIST screen, then set this ",
"feature.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_expanded_addrbooks[] = {
 "         FEATURE: expanded-view-of-addressbooks",
" ",
"If multiple address books (either personal or global) are defined, and you",
"wish to have them all expanded implicitly upon entering the ADDRESS BOOK",
"screen, then set this feature. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_compose_news_wo_conf[] = {
 "         FEATURE: compose-sets-newsgroup-without-confirm",
" ",
"This feature controls one aspect of Pine's Composer.  If you enter the",
"composer while reading a news group, you will normally be prompted to",
"determine whether you intend the new message to be posted to the current",
"newsgroup or not.  If this feature is set, Pine will not prompt you",
"in this situation, and will assume that you do indeed wish to post",
"to the newsgroup you are reading.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_compose_rejects_unqual[] = {
 "     FEATURE: compose-rejects-unqualified-addrs",
" ",
"This feature controls one aspect of the message composer; in particular, ",
"what happens when an unqualified name is entered into an address header.",
"If set, unqualified names entered as addresses will be treated as errors",
"unless they match an addressbook nickname.  Pine will not attempt to turn",
"them into complete addresses by adding your local domain.",
" ",
"A complete (fully qualified) address is one containing a username followed",
"by an \"@\" symbol, followed by a host or domain name (e.g. ",
"\"jsmith@nowhere.edu\").  An unqualified name is one *without* the \"@\"",
"symbol and host or domain name (e.g. \"jsmith\"),",
" ",
"When you enter a fully qualified address, Pine does not interpret or",
"modify it, but simply passes it on to the mail-transport-agent (MTA) for",
"your system.  Pine conforms to the Internet standards governing message",
"headers and will not send an unqualifed name to the MTA.  Therefore, when",
"you enter an unqualified name, Pine will normally attempt to turn it into",
"a fully qualified address, first by checking to see if you have entered a",
"matching nickname in your addressbook, or failing that, by simply adding",
"your own domain to the name entered.  So if your address is",
"\"jsmith@nowhere.edu\" and you enter \"fred\", then (assuming \"fred\" is ",
"not a valid nickname), Pine will turn that into \"fred@nowhere.edu\". ",
" ",
"There are situations where it is not desirable for Pine to interpret such",
"unqualified names as valid (local) addresses.  For example, if \"fred\"",
"turned out to be a typo (intended to be an addressbook nickname), but",
"there actually was a \"fred\" in your local domain, the message might be",
"mis-delivered without your realizing it.  In order to reduce the liklihood",
"of such accidents, setting this feature will cause Pine to treat such",
"addresses as errors, and require that you explicitly enter the full local",
"address (e.g. \"fred@nowhere.edu\") or correct the name so that it matches",
"an address book nickname. ",
" ",
"Consider this a safety feature against mis-directed mail.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_quell_local_lookup[] = {
 "         FEATURE: quell-user-lookup-in-passwd-file",
" ",
"This feature controls an aspect of Pine's Composer, and if needed, will",
"usually be set by your system manager in Pine's system-wide configuration",
"file. Specifically, if this feature is set, Pine will not attempt to look",
"in the system password file to find a Full Name for the entered address.",
" ",
"Normally, names you enter into address fields (e.g. To: or Cc:) are",
"checked against your address book(s) to see if they match an address book",
"nickname.  Failing that, (in Unix Pine) the name is then checked against",
"the Unix password file.  If the entered name matches a username in the",
"system password file, Pine extracts the corresponding Full Name information ",
"for that individual, and adds that to the address being entered. ",
" ",
"However, password file matching can have surprising (incorrect) results if",
"other users of the system do not receive mail at the domain you are using.",
"That is, if either the \"user-domain\" or \"use-only-domain-name\" option",
"is set such that the administrative domain of other users on the system",
"isn't accurately reflected, Pine should be told that a passwd file match",
"is coincidental, and Full Name info will be incorrect.  For example, a",
"personal name from the password file could get falsly paired with the",
"entered name as it is turned into an address in the configured domain. ",
" ",
"If you are seeing this behavior, enabling this feature will prevent Unix",
"Pine from looking up names in the password file to find the Full Name",
"for incomplete addresses you enter.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_preserve_start_stop[] = {
 "         FEATURE: preserve-start-stop-characters",
" ",
"This feature controls how special control key characters, typically",
"Ctrl-S and Ctrl-Q, are interpreted when input to Pine.  These characters",
"are known as the \"start\" and \"stop\" characters and are sometimes used in",
"communications paths to control data flow.",
" ",
"By default, Pine turns the system's handling of these special characters",
"off.  However, if you see Pine reporting input errors such as:",
" ",
"            [ Command \"^Q\" not defined for this screen. ]",
" ",
"and, at the same time, see your display become garbled, then it is",
"likely setting this option will solve the problem.  Be aware, though,",
"that enabling this feature will also cause Pine to ostensibly \"hang\"",
"whenever the Ctrl-S key combination is entered as the system is now",
"interpreting such input as a \"stop output\" command.  To \"start output\"",
"again, simply type Ctrl-Q.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_enable_incoming[] = {
 "         FEATURE: enable-incoming-folders",
" ",
"If set, this feature defines a pseudo-folder collection called",
"\"INCOMING MESSAGE FOLDERS\".  Initially, the only folder included",
"in this collection will be your INBOX, which will no longer show up in ",
"your default saved-message folder collection.",
" ",
"You may add more folders to the Incoming Message Folders collection by",
"using the \"{F10:A} Add\" command in the FOLDER LIST screen.  You will ",
"be prompted for the host the folder is stored on (which defaults to the",
"same host used for your INBOX), a nickname, and the actual folder name.  ",
"Once a set of Incoming Message Folders are defined, the TAB key (in",
"FOLDER INDEX or MESSAGE TEXT screens) may be used to scan the folders",
"for those with Recent messages.",
" ",
"NOTE: Pine does not do \"delivery filtering\"; this is the province of",
"other programs such as \"filter\" or \"procmail\".  Pine's Incoming",
"Message Folders collection provides a convenient way to access multiple",
"incoming folders, once they are created by other programs.  It is also",
"useful if you have accounts on multiple computers.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_attach_in_reply[] = {
 "         FEATURE: include-attachments-in-reply",
" ",
"This feature controls an aspect of Pine's Reply command. If set, any MIME",
"attachments that were part of the original message will automatically be",
"included in the Reply.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_include_header[] = {
 "         FEATURE: include-header-in-reply",
" ",
"This feature controls an aspect of Pine's Reply command. If set, and the",
"original message is being included in the reply, then headers from that",
"message will also be part of the reply.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_sig_at_bottom[] = {
 "        FEATURE: signature-at-bottom",
" ",
"This feature controls an aspect of Pine's Reply command.  If this feature",
"is set, and the original message is being included in the reply, then the",
"contents of your signature file (if any) will be inserted after the included",
"message, and the cursor will also be positioned after the included text.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_use_fk[] = {
 "        FEATURE: use-function-keys",
" ",
"This feature specifies that Pine will respond to function keys instead of",
"the normal single-letter commands. In this mode, the key menus at the",
"bottom of each screen will show function key designations instead of the",
"normal mnemonic key. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_del_skips_del[] = {
 "        FEATURE: delete-skips-deleted",
" ",
"This feature controls an aspect of Pine's Delete command.  If set, this",
"feature will cause the Delete command to advance past other messages that",
"are marked deleted.  In other words, pressing \"D\" will both mark the",
"current message deleted and advance to the next message that is not marked",
"deleted.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_auto_expunge[] = {
 "        FEATURE: expunge-without-confirm",
" ",
"This features controls an aspect of Pine's eXpunge command.  If set, you",
"will not be prompted to confirm your intent before the expunge takes place.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_auto_read_msgs[] = {
 "        FEATURE: auto-move-read-msgs",
" ",
"This feature controls an aspect of Pine's behavior upon quitting.  If set,",
"and the \"read-message-folder\" variable is also set, then Pine will",
"automatically transfer all read messages to the designated folder and mark",
"them as deleted in the INBOX.  Messages in the INBOX marked with an \"N\"",
"(meaning New, or unseen) are not affected.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_read_in_newsrc_order[] = {
 "        FEATURE: news-read-in-newsrc-order",
" ",
"This feature controls the order that news groups will be presented.  If",
"set, they will be presented in the same order as they occur in your .newsrc",
"file (or \\NEWSRC file in the case of PC-Pine).  If not set, the newsgroups",
"will be presented in alphabetical order.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_post_wo_validation[] = {
 "        FEATURE: news-post-without-validation",
" ",
"This feature controls whether the NNTP server is queried as news groups",
"are entered for posting.  Validation over slow links (e.g. dialup using ",
"SLIP or PPP) can cause delays.  Set this feature to eliminate such delays. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_select_wo_confirm[] = {
 "        FEATURE: select-without-confirm",
" ",
"This feature controls an aspect of Pine's Save, Export, and Goto commands.",
"These commands all take text input to specify the name of the folder or",
"file to be used, but allow you to press ^T for a list of possible names.",
"If set, the selected name will be used immediately, without further",
"opportunity to confirm or edit the name.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_use_current_dir[] = {
 "           FEATURE: use-current-dir",
" ",
"This feature controls an aspect of several commands. If set, your \"current",
"working directory\" will be used instead of your home directory for all of",
"the following operations: ",
" ",
"    o Export in the FOLDER INDEX and MESSAGE TEXT screens",
"    o Attachment Save in the MESSAGE TEXT and ATTACHMENT TEXT screens",
"    o Ctrl-R file inclusion in the COMPOSER",
"    o Ctrl-J file attachment in the COMPOSER",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_save_wont_delete[] = {
 "          FEATURE: save-will-not-delete",
" ",
"This feature controls one aspect of the Save command.  If set, Save will",
"not mark the message \"deleted\" (its default behavior) after it has been",
"copied to the designated folder.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_save_advances[] = {
 "          FEATURE: save-will-advance",
" ",
"This feature controls one aspect of the Save command.  If set, Save will",
"(in addition to copying the current message to the designated folder) also",
"advance to the next message.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_force_low_speed[] = {
 "          FEATURE: assume-slow-link",
" ",
"This feature affects Pine's display routines.  If set, the normal",
"inverse-video cursor (used to highlight the current item in a list) will be",
"replaced by an \"arrow\" cursor and other screen update optimizations for",
"low-speed links (e.g. 2400 bps dialup connections) will be activated.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_show_delay_cue[] = {
 "          FEATURE: enable-mail-check-cue",
" ",
"If set, this feature will cause an asterisk to appear in the upper",
"left-hand corner of the screen whenever Pine checks for new mail, and two",
"asterisks whenever Pine saves (checkpoints) the state of the current",
"mailbox to disk.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_auto_open_unread[] = {
 "          FEATURE: auto-open-next-unread",
" ",
"This feature controls the behavior of the TAB key when traversing folders",
"in the optional \"incoming-folders\" collection or in optional",
"\"news-collections\".  When the TAB (Next New) key is pressed, and there",
"are no more unseen messages in the current (incoming message or news)",
"folder, Pine will search the list of folders in the current collection for",
"one containing New or Recent (new since the last time the folder was",
"opened) messages.  Normally, when such a folder is found, Pine will ask",
"whether you wish to open the folder.  If this feature is set, Pine will",
"automatically open the folder without prompting.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_auto_include_reply[] = {
 "          FEATURE: include-text-in-reply",
" ",
"This feature controls an aspect of Pine's Reply command.  Normally, Pine",
"will ask whether you wish to include the original message in your reply.",
"If this feature is set, the original message will be included in the reply",
"automatically, without prompting.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_select_in_bold[] = {
 "         FEATURE: show-selected-in-boldface",
" ",
"This feature controls an aspect of Pine's aggregate operation commands; in",
"particular, the Select and WhereIs commands. Select and WhereIs (with the",
"^X subcommand) will search the current folder for messages meeting a",
"specified criteria, and \"tag\" the resulting messages with an \"X\" in the",
"first column of the applicable lines in the FOLDER INDEX.  If this feature",
"is set, instead of using the \"X\" to denote a selected message, Pine will",
"attempt to display those index lines in boldface. Whether this is",
"preferable to the \"X\" will depend on personal taste and the type of",
"terminal being used.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_folder_extension[] = {
 " ",
"Normally PC-Pine appends the extension \"MTX\" to all local (PC) folder",
"names and suppresses that extension when listing those folders.  By",
"setting this option, you over-ride this behavior.  In particular, you may",
"set \"folder-extension\" to the \"null string\" which tells PC-Pine to",
"neither add nor hide-from-view *any* folder name extension. ",
" ",
"The reason you might wish to over-ride the MTX default is that recent",
"versions of PC-Pine have the ability to open (albeit READ-ONLY) normal",
"Unix mail folders. Since it might be inconvenient to rename all of them to",
"have an MTX extension, it is possible with this option to switch PC-Pine's",
"behavior so that such folders can be seen and accessed without changing",
"their names. However, doing this means that your existing PC-Pine local",
"folders will have apparently changed their names.  For example, if you had",
"a local folder named \"FOO\" it will now appear in the Folder List as",
"\"FOO.MTX\". If you wish to save additional messages to that folder, you",
"will need to enter the full name, \"FOO.MTX\" at the Save prompt. ",
"Likewise for GOTO. ",
" ",
"If you wish to permanently avoid having to deal with folder name extensions,",
"you will need to set this option to the null string by entering two double-",
"quote marks, and you will need to rename your existing local folders to ",
"not have an MTX extension.  In DOS this can be done in one command, once",
"you have changed to your mail directory:  RENAME  *.MTX  *.",
" ",
"We don't know why you might wish to, but you could also use this option",
"to tell PC-Pine to use an extension other than MTX.  In this case, enter",
"the three characters you desire to use in lieu of \"MTX\".  Note that",
"your existing folders will need to be renamed to correspond to this new",
"extension.",
" ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_disable_config_screen[] = {
 "         FEATURE: disable-config-screen",
" ",
"This feature is intended for use by system managers who wish to provide a",
"specific Pine configuration to their users in order to reduce confusion",
"about Pine's growing set of optional features.  If set, the configuration",
"screen (Main/Setup/Config) will not be available.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_disable_password_cmd[] = {
 "        FEATURE: disable-password-cmd",
" ",
"This feature is intended for use by system managers who wish to globally",
"disable Pine's password-changing command (Main/Setup/Password) at sites",
"where it is inappropriate.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_disable_update_cmd[] = {
 "        FEATURE: disable-update-cmd",
" ",
"This feature is intended for use by system managers who wish to globally",
"disable Pine's update command (Main/Setup/Update).  The Update command",
"allows PC-Pine users to fetch new releases of the program.  Tech notes",
"and other information may also be available via the Update function.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_disable_kblock_cmd[] = {
 "        FEATURE: disable-kblock-cmd",
" ",
"This feature is intended for use by system managers who wish to globally",
"disable the keyboard lock command (Main/KBlock).",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_quote_all_froms[] = {
 "        FEATURE: save-quotes-leading-froms",
" ",
"This feature controls an aspect of the Save command (and also the way ",
"outgoing messages are saved to an FCC folder).  If set, Pine will add",
"a leading \">\" character in front of message lines beginning with \"From",
"\" when they are saved to another folder, including lines syntactically",
"distinguishable from the type of message separator line commonly used on",
"Unix systems.",
" ",
"The default behavior is that a \">\" will be prepended only to lines",
"beginning with \"From \" that might otherwise be confused with a message",
"separator line on Unix systems.  If pine is the only mail program you use,",
"this default is reasonable.  If another program you use has trouble",
"displaying a message with an unquoted \"From \" saved by Pine, you should",
"enable this feature.  This feature only applies to the common Unix mailbox",
"format that uses message separator lines beginning with \"From \".  If",
"Pine has been configured to use a different mailbox format (possibly",
"incompatible with other mail programs), then this issue does not arise,",
"and the feature is irrelevant. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_normal_fg[] = {
 "        OPTION: normal-foreground-color",
" ",
"Sets PC-Pine's foreground (the actual character) color.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_normal_bg[] = {
 "        OPTION: normal-background-color",
" ",
"Sets PC-Pine's background (the area behind the character) color.",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_reverse_fg[] = {
 "        OPTION: reverse-foreground-color",
" ",
"Sets PC-Pine's foreground (the actual character) color for reverse video",
"characters. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_reverse_bg[] = {
 "        OPTION: reverse-background-color",
" ",
"Sets PC-Pine's background (the area behind the character) color for",
"reverse video characters. ",
" ",
"<End of help on this topic>",
NULL
};


char *h_config_news_uses_recent[] = {
 "         FEATURE: news-approximates-new-status",
" ",
"This feature causes certain messages to be marked as \"New\" in the",
"Folder Index of news groups.",
" ",
"When opening a news group, Pine will consult your \"newsrc\" file and",
"determine the last message you have previously disposed of via the \"D\"",
"key.  If this feature is set, any subsequent messages will be shown in the",
"Index with an \"N\", and the first of these messages will be highlighted. ",
"Although this is only an approximation of true \"New\" or \"unseen\"",
"status, it provides a useful cue to distinguish more-or-less recent ",
"messages from those you have seen previously, but are not yet ready to",
"mark deleted.",
" ",
"Background: your \"newsrc\" file (used to store message status information",
"for news groups) is only capable of storing a single flag, and Pine uses  ",
"this to record whether or not you are \"done with\" a message, as",
"indicated by marking the message as \"Deleted\".  Unfortunately, this",
"means that Pine has no way to record exactly which messages you have ",
"previously seen, so it normally does not show the \"N\" status flag for",
"any messages in a news group. This feature enables a starting",
"*approximation* of seen/unseen status that may be useful.",
" ",
"<End of help on this topic>",
NULL
};


char *h_oe_detach_no[] = {
 "Enter the attachment number from the list above, or if none, enter \"1\",",
"then press RETURN.  Then you'll be able to Save or process that attachment. ",
NULL
};


char *h_os_index_whereis[] = {
 "Enter ^V or ^Y to go immediately to the last or first message in the index.",
"Or, enter the match string followed by RETURN.",
NULL
};


char *h_os_index_whereis_agg[] = {
 "Enter ^V or ^Y to go immediately to the last or first message in the index,",
"Or, enter the match string followed by RETURN (or ^X to select all matches). ",
NULL
};


char *h_oe_add_full[] = {
 "Type the full name of the person being added and press the RETURN key.",
"Press ^C to cancel addition. ",
NULL
};


char *h_oe_add_nick[] = {
 "Type a short nickname and press RETURN.  A nickname is a short easy-to-",
"remember word, name or initials like \"joe\", or \"wcfields.\"  ^C to cancel. ",
NULL
};


char *h_oe_add_addr[] = {
 "Type the e-mail address and press RETURN.",
"Press ^C to cancel addition.",
NULL
};


char *h_oe_crlst_full[] = {
 "Type a long name or description for the list that you are creating and",
"press RETURN.  Press ^C to cancel creation of list. ",
NULL
};


char *h_oe_crlst_nick[] = {
 "Type a nickname (short, easy-to-remember name or single word) for the list",
"you are creating and press RETURN.  Press ^C to cancel. ",
NULL
};


char *h_oe_crlst_addr[] = {
 "Type an e-mail address, or a nickname already in the address book that you",
"want to be part of this list and press RETURN. ",
NULL
};


char *h_oe_adlst_addr[] = {
 "Type an e-mail address or a nickname already in the address book that you",
"want to add to this list and press RETURN. ",
NULL
};


char *h_oe_editab_nick[] = {
 "Change the nickname using the arrow keys and delete key.  Press RETURN",
"when done.  Press ^C to cancel editing and leave the nickname as it was. ",
NULL
};


char *h_oe_editab_full[] = {
 "Change the full name using the arrow keys and delete key.  Press RETURN",
"when done.  Press ^C to cancel editing and leave the full name as it was. ",
NULL
};


char *h_oe_editab_addr[] = {
 "Change the address using the arrow keys and delete key.  Press RETURN ",
"when done.  Press ^C to cancel editing and leave the address as it was. ",
NULL
};


char *h_oe_editab_fcc[] = {
 "Change the fcc using the arrow keys and delete key.  Press RETURN when",
"done.  Press ^C to cancel editing and leave the fcc as it was. ",
NULL
};


char *h_oe_editab_comment[] = {
 "Change the comment field using the arrow keys and delete key.  Press RETURN ",
"when done.  Press ^C to cancel editing and leave the comment as it was. ",
NULL
};


char *h_ab_edit_a_field[] = {
 "Edit any of the fields of the currently selected entry by typing one of the ",
"letters at the bottom of the screen.  Press ^C to cancel edit.",
NULL
};


char *h_oe_editab_al[] = {
 "Change the address using the arrow keys and delete key.  Press RETURN ",
"when done.  Press ^C to cancel editing and leave the address as it was. ",
NULL
};


char *h_oe_searchab[] = {
 "Type the word or name you want to search for and press RETURN.  If you press ",
"RETURN without entering anything the word in [] will be searched for. ",
NULL
};


char *h_oe_searchrl[] = {
 "Type the word, name or address you want to search for and press RETURN.  If you ",
"press RETURN without entering anything the word in [] will be searched for. ",
NULL
};


char *h_oe_save[] = {
 "Type the name of the folder you want to save the message in and press RETURN.  ",
"Press ^T to get a list of your folders.  Press ^C to cancel saving this mail. ",
NULL
};


char *h_oe_chooseabook[] = {
 "Choose the address book you want to save the new entry in.",
"Use ^N or ^P to change address books.  ^C to cancel.",
NULL
};


char *h_oe_takeaddr[] = {
 "Edit the e-mail address using the arrow and delete keys.  Press RETURN",
"when done.  Press ^C to cancel adding this entry to the address book. ",
NULL
};


char *h_oe_take_or_replace[] = {
 "Press R to replace the old entry with this new list.  Press A to add the",
"selected addresses to the old existing list.  Press ^C to cancel addition. ",
NULL
};


char *h_oe_takename[] = {
 "Edit the full name to be correct using the arrow and delete keys.  Press RETURN ",
"when done.  Press ^C to cancel adding this entry to the address book. ",
NULL
};


char *h_oe_takenick[] = {
 "Type a nickname (short easy-to-remember name, initials or single word) for this ",
"entry in the address book and press RETURN.  Press ^C to cancel addition. ",
NULL
};


char *h_oe_jump[] = {
 "Type the number of the message number you want to jump to and press",
"RETURN.  Press ^C if you want to cancel jumping to another message. ",
NULL
};


char *h_oe_broach[] = {
 "Type the name of the folder you want to open and press RETURN.  Press ^T to ",
"get a list of all your folders and make a selection.  Press ^C to cancel open. ",
NULL
};


char *h_oe_foldsearch[] = {
 "Type the word, name or address you want to search for and press RETURN.  If you ",
"press RETURN without entering anything the word in [] will be searched for. ",
NULL
};


char *h_oe_foldadd[] = {
 "Type the name of the folder you want to add and press RETURN.  Press ^C to",
"cancel adding a new folder. ",
NULL
};


char *h_oe_foldrename[] = {
 "Change the old name of the folder to the new name using the arrow and",
"delete keys and press RETURN.  Press ^C to cancel rename. ",
NULL
};


char *h_oe_login[] = {
 "Enter your login name for the host you are opening the mailbox on.  Just press ",
"RETURN to use your login from this host as is, or edit it with delete key. ",
NULL
};


char *h_oe_passwd[] = {
 "Type your password for the host and login shown as part of the prompt. ",
"Press ^C to cancel opening folder. ",
NULL
};


char *h_oe_choosep[] = {
 "Enter the number associated with the printer you want to select.  Press ^C to ",
"cancel the printer selection.  The current selection is highlighted. ",
NULL
};


char *h_oe_customp[] = {
 "Type the name of the Unix print command and press RETURN.  Press ^C to",
"cancel the printer selection. ",
NULL
};


char *h_oe_searchview[] = {
 "Type the word or name you want to search for and press RETURN.  If you press ",
"RETURN without entering anything the word in [] will be searched for. ",
NULL
};


char *h_oe_keylock[] = {
 "The keyboard is in use and locked by another user.  Only that user can",
"unlock this keyboard by typing the password. ",
NULL
};


char *h_oe_export[] = {
 "Type the name of file in your home directory to write the message into and ",
"press RETURN.  You may also give an absolute path or use \"~\".  Use ^C to cancel ",
NULL
};


char *h_wt_expire[] = {
 "At the beginning of each month Pine offers to rename your current sent-mail ",
"folder to one named for the month so you have a sent-mail folder for each month ",
NULL
};


char *h_wt_delete_old[] = {
 "It is the beginning of the month, and we need to conserve disk",
"space.  Please delete any sent-mail that you do not need. ",
NULL
};


char *h_wt_auger_in[] = {
 "This emergency cancel is used when Pine is completely stuck.  It'll dump a core ",
"file for debugging and will NOT SAVE message under composition or status. ",
NULL
};


char *h_select_sort[] = {
 "Select the order for sorting the index by typing the capitalized letter. ",
"Arrival is by arrival in your mailbox; Date is by time/day message was sent. ",
NULL
};


char *h_mini_setup[] = {
 "Select one of the setup tasks by typing the capitalized letter. ",
NULL
};


char *h_sticky_personal_name[] = {
 "Type in your name as you want it to appear on outgoing email.  This entry",
"will be saved into your Pine configuration file. ",
NULL
};


char *h_sticky_inbox[] = {
 "INBOX syntax is usually {{:{}complete.machine.name}INBOX",
"This entry will be saved into your Pine configuration file. ",
NULL
};


char *h_sticky_smtp[] = {
 "The name of the computer on your campus which relays your outgoing email",
"to the Internet.  This entry will be saved into your Pine configuration file. ",
NULL
};


char *h_sticky_user_id[] = {
 "The username or login-id part of your email address.  This entry will be",
"saved into your Pine configuration file. ",
NULL
};


char *h_sticky_domain[] = {
 "The domain part of your email address, NOT the name of your PC.  This",
"entry will be saved into your Pine configuration file. ",
NULL
};


char *h_bounce[] = {
 "Enter the address or nickname of the intended recipient.  Pine will resend",
"the message, which will retain the original author's From: address.",
NULL
};


char *h_incoming_add_folder_host[] = {
 "Enter RETURN if the folder is on the machine where Pine is running;",
"otherwise enter the host name of the mail server, or ^X if same as INBOX.",
NULL
};


char *h_incoming_add_folder_name[] = {
 "Enter the name of the desired folder. Pine will attempt to create this",
"folder on the previously specified mail server. ",
NULL
};


char *h_incoming_add_folder_nickname[] = {
 "Enter an (optional) nickname that will be used in lieu of the actual ",
"host and folder names in the FOLDER LIST display.",
NULL
};


char *h_anon_forward[] = {
 "Enter the address of your intended recipient, or ^C to cancel.",
"Example: jsmith@somewhere.edu",
NULL
};


char *h_news_subscribe[] = {
 "Enter the name of the news group to which you wish to subscribe,",
"or ^C to cancel.  Example: comp.mail.pine",
NULL
};


char *h_pipe_msg[] = {
 "Enter the name of the Unix command to which you wish to send this",
"message, or ^C to cancel.",
NULL
};


char *h_pipe_attach[] = {
 "Enter the name of the Unix command to which you wish to sent this",
"attachment, or ^C to cancel.",
NULL
};


char *h_select_by_num[] = {
 "Enter a list of numbers (or number ranges), or ^C to cancel.  The messages ",
"corresponding to the numbers will be selected.  Example: 2-5,7-9,11,19",
NULL
};


char *h_select_txt_from[] = {
 "Messages with From: headers containing the entered string will be selected.",
"^C to cancel. ^R enters current msg From: address.  ^T enters To: address.",
NULL
};


char *h_select_txt_to[] = {
 "Messages with To: headers containing the entered string will be selected.",
"^C to cancel. ^R enters current msg From: address.  ^T enters To: address.",
NULL
};


char *h_select_txt_cc[] = {
 "Messages with From: headers containing the entered string will be selected.",
"^C to cancel. ^R enters current msg From: address.  ^T enters To: address.",
NULL
};


char *h_select_txt_subj[] = {
 "Messages with Subject: headers containing the entered string will be selected.",
"^C to cancel.  ^X enters Subject: line of current message.",
NULL
};


char *h_select_txt_all[] = {
 "All messages containing the entered string will be selected.  Headers, ",
"but not encoded attachments, will be compared.  Enter ^C to cancel.",
NULL
};


char *h_attach_index_whereis[] = {
 "Enter some text that appears in the Attachment Index entry for the desired",
"attachment.  The first attachment containing that text will be highlighted.",
NULL
};


char *h_kb_lock[] = {
 "Keystrokes entered here (up to a RETURN) comprise a password that must",
"be entered again later in order to unlock the keyboard.",
NULL
};


char *h_config_whereis[] = {
 "To move quickly to a particular option or feature, enter a search string or",
"^C to cancel.",
NULL
};


char *h_config_add[] = {
 "Enter desired value; use normal editing keys to modify (e.g. ^K, ^D).  Just",
"pressing RETURN sets the Empty Value (this turns off any global default).",
NULL
};


char *h_config_change[] = {
 "Edit the existing value using arrow keys, ^K to delete entire entry, ^D to ",
"delete current (highlighted) character, etc.  Enter ^C to cancel change.",
NULL
};

char **h_texts[] = {
h_news,
main_menu_tx,
h_mail_index,
h_simple_index,
h_mail_view,
h_folder_maint,
h_folder_open,
h_folder_save,
h_folder_fcc,
h_address_book,
h_use_address_book,
h_select_nickname,
h_takeaddr_screen,
h_attachment_screen,
h_mail_text_att_view,
h_composer,
h_composer_browse,
h_composer_ins,
h_composer_search,
h_composer_to,
h_composer_cc,
h_composer_bcc,
h_composer_from,
h_composer_reply_to,
h_composer_custom_addr,
h_composer_custom_free,
h_composer_news,
h_composer_fcc,
h_composer_subject,
h_composer_attachment,
h_composer_placeholder,
h_config_generic,
h_config_generic_feature_list,
h_config_generic_radio,
h_config_pers_name,
h_config_user_id,
h_config_user_dom,
h_config_smtp_server,
h_config_nntp_server,
h_config_inbox_path,
h_config_folder_spec,
h_config_news_spec,
h_config_default_fcc,
h_config_postponed_folder,
h_config_read_message_folder,
h_config_newsrc_path,
h_config_signature_file,
h_config_addressbook,
h_config_global_addrbook,
h_config_init_cmd_list,
h_config_comp_hdrs,
h_config_custom_hdrs,
h_config_saved_msg_name_rule,
h_config_fcc_rule,
h_config_sort_key,
h_config_ab_sort_rule,
h_config_char_set,
h_config_editor,
h_config_image_viewer,
h_config_domain_name,
h_config_prune_date,
h_config_enable_full_hdr,
h_config_enable_pipe,
h_config_enable_tab_complete,
h_config_quit_wo_confirm,
h_config_enable_jump,
h_config_enable_alt_ed,
h_config_alt_ed_now,
h_config_enable_bounce,
h_config_enable_agg_ops,
h_config_enable_flag,
h_config_can_suspend,
h_config_expanded_folders,
h_config_expanded_addrbooks,
h_config_compose_news_wo_conf,
h_config_compose_rejects_unqual,
h_config_quell_local_lookup,
h_config_preserve_start_stop,
h_config_enable_incoming,
h_config_attach_in_reply,
h_config_include_header,
h_config_sig_at_bottom,
h_config_use_fk,
h_config_del_skips_del,
h_config_auto_expunge,
h_config_auto_read_msgs,
h_config_read_in_newsrc_order,
h_config_post_wo_validation,
h_config_select_wo_confirm,
h_config_use_current_dir,
h_config_save_wont_delete,
h_config_save_advances,
h_config_force_low_speed,
h_config_show_delay_cue,
h_config_auto_open_unread,
h_config_auto_include_reply,
h_config_select_in_bold,
h_config_folder_extension,
h_config_disable_config_screen,
h_config_disable_password_cmd,
h_config_disable_update_cmd,
h_config_disable_kblock_cmd,
h_config_quote_all_froms,
h_config_normal_fg,
h_config_normal_bg,
h_config_reverse_fg,
h_config_reverse_bg,
h_config_news_uses_recent,
h_oe_detach_no,
h_os_index_whereis,
h_os_index_whereis_agg,
h_oe_add_full,
h_oe_add_nick,
h_oe_add_addr,
h_oe_crlst_full,
h_oe_crlst_nick,
h_oe_crlst_addr,
h_oe_adlst_addr,
h_oe_editab_nick,
h_oe_editab_full,
h_oe_editab_addr,
h_oe_editab_fcc,
h_oe_editab_comment,
h_ab_edit_a_field,
h_oe_editab_al,
h_oe_searchab,
h_oe_searchrl,
h_oe_save,
h_oe_chooseabook,
h_oe_takeaddr,
h_oe_take_or_replace,
h_oe_takename,
h_oe_takenick,
h_oe_jump,
h_oe_broach,
h_oe_foldsearch,
h_oe_foldadd,
h_oe_foldrename,
h_oe_login,
h_oe_passwd,
h_oe_choosep,
h_oe_customp,
h_oe_searchview,
h_oe_keylock,
h_oe_export,
h_wt_expire,
h_wt_delete_old,
h_wt_auger_in,
h_select_sort,
h_mini_setup,
h_sticky_personal_name,
h_sticky_inbox,
h_sticky_smtp,
h_sticky_user_id,
h_sticky_domain,
h_bounce,
h_incoming_add_folder_host,
h_incoming_add_folder_name,
h_incoming_add_folder_nickname,
h_anon_forward,
h_news_subscribe,
h_pipe_msg,
h_pipe_attach,
h_select_by_num,
h_select_txt_from,
h_select_txt_to,
h_select_txt_cc,
h_select_txt_subj,
h_select_txt_all,
h_attach_index_whereis,
h_kb_lock,
h_config_whereis,
h_config_add,
h_config_change,
NULL
};

