 /*M - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -      E     These routines convert various standard i/o library routine calls C     used by the server into the corresponding socket calls. This is G     necessary for VMS as, unlike unix, the I/O routines for network and H     non-network reads/writes are not integrated. That is, you can't do aJ     standard write to a network socket or a socket write to a file withoutO     chaos ensuing. Thus, we need extra code to determine how to handle a printf L     when we don't necessarily know to what device stdout is connected (ditto     for stdin).   M - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  */  1 #undef getchar			/* Remove the intercept calls */  #undef fgets #undef putchar #undef puts  #undef fputs
 #undef printf 
 #undef fwrite 
 #undef fflush   5 #ifndef LOG			/* In case, main prog has no logging */  #  define LOG(n,fmt,a,b,c,d) {}  #endif  8 #include <ctype.h>		/* Additional declarations needed */ #include <string.h>  #include <jpidef.h>  #include <stdarg.h>  #include <errno.h>    D #define BUFFERSIZE 4096		/* Define local input/output buffer size */    static char *InputBuffer = NULL;$ static int  InputBufferLength   = 0;' static char OutputBuffer[BUFFERSIZE+1]; $ static int  OutputBufferCounter = 0;  > static int isserver = 0;	/* .. server or interactive flag   */@ TCPSTREAM *NETstream = NULL;	/* I/O stream for network server */G TCPSTREAM *tcp_server_init();	/* .. Set up stdio as a server channel */   J /* -----------------------------------------------------------------------
    __openio()   3    Initializes the special input / output routines: )      - Sets up the server (if we are one)        - Decides if we're a server  M    ----------------------------------------------------------------------- */ C void __openio(int port)			/* Assign channels to network/terminal */   {      int  LIB$GETJPI(); -      int status, modeflag, fcode = JPI$_MODE;   I      LOG(10,"__openio: initiating special I/O (port %d)\r\n",port,0,0,0);   K   /* See if we are a NETWORK or OTHER process; only then are we a server */ 8      status = LIB$GETJPI(&fcode, 0, 0, &modeflag, 0, 0);#      if (!(status&1)) exit(status);   B      if ((modeflag == JPI$K_OTHER) || (modeflag == JPI$K_NETWORK))        {           isserver = 1; D           NETstream = tcp_server_init(port);	/* initialize server */            if (NETstream == NULL)R             {LOG(1,"__openio: unable to init network server channel\r\n",0,0,0,0);B              mm_fatal("Unable to init network channel"); exit(1);}        }  1      InputBuffer = (char *) malloc(BUFFERSIZE+1);   }  J /* -----------------------------------------------------------------------    __ReadBuffer()   L    Fill up the internal buffer with data from the input file, either network0    or stdin, depending on whether we're a server      Returns: 3 	Pointer to input buffer, or NULL if any read error   M    ----------------------------------------------------------------------- */  char *__ReadBuffer()   { :    /*  We need to fill up the buffer, so read next line */1      LOG(10,"__ReadBuffer: Entered\r\n",0,0,0,0);       if (isserver)        {           char *s;C           LOG(10,"__ReadBuffer: Entering tcp_getline\r\n",0,0,0,0); *           fs_give((void **) &InputBuffer);  1           if ((s=tcp_getline(NETstream)) == NULL) 
             { b               LOG(10,"__ReadBuffer: tcp_getline = NULL (eof/Error), errno = %d\r\n", errno,0,0,0);               return NULL;
             } .          /* Have to copy to add end of line */,           InputBufferLength = strlen(s) + 2;<           InputBuffer = (char *)fs_get(InputBufferLength+1);            strcpy(InputBuffer,s);%           strcat(InputBuffer,"\r\n");             fs_give((void **) &s);a           LOG(10,"__ReadBuffer: Exiting tcp_getline, retlen = %d\r\n", InputBufferLength, 0,0,0);         }	      else         {=           LOG(10,"__ReadBuffer: Entering fgets\r\n",0,0,0,0); <           if (fgets(InputBuffer, BUFFERSIZE, stdin) == NULL)
             { b               LOG(10,"__ReadBuffer: fgets status = NULL (EOF/Error), errno = %d\r\n",errno,0,0,0);               return NULL;
             } 2           InputBufferLength = strlen(InputBuffer);[           LOG(10,"__ReadBuffer: Exiting fgets, retlen = %d\r\n", InputBufferLength, 0,0,0);         }0     LOG(10,"__ReadBuffer: Exiting\r\n",0,0,0,0);     return InputBuffer;    }   J /* -----------------------------------------------------------------------    special_getchar()  J    Reads next character from input buffer, calling __ReadBuffer() when the    input buffer is empty.       Returns: . 	the ASCII character, or EOF if any read errorM    ----------------------------------------------------------------------- */  int special_getchar()   {     static char *IB;       if (InputBufferLength <= 0)        { *         if ((IB = __ReadBuffer()) == NULL)           return EOF;        }        InputBufferLength--;     return *IB++;    }                  J /* -----------------------------------------------------------------------    special_fgets()  $    Reads a newline terminated record  
    Inputs:' 	buffer	- Pointer to a character buffer > 	size	- Maximum size of buffer (allow one for '\0' terminator) 	file	- file from which to read       Returns: > 	pointer to the supplied input buffer, or NULL if a read errorM    ----------------------------------------------------------------------- */ E char *special_fgets(buffer, size, file)		/* Read from net/terminal */ 
 char *buffer; 	 int size;  FILE *file;    {      char *b = buffer; 
     int c;       if (file != stdin)%       return fgets(buffer,size,file);        while (size-- > 0)       { -          if ( (c = special_getchar()) == EOF)              return NULL;  !          if ( (*b++ = c) == '\n')              break;       }        *b = '\0';     return buffer;   }       J /* -----------------------------------------------------------------------    __WriteBuffer()  0    Writes out the special internal output buffer      Returns: 	 	0	All OK  	1	OtherwiseM    ----------------------------------------------------------------------- */ 3 int __WriteBuffer()				/* Output to net/terminal */    {      int status = 0; a     LOG(10,"__WriteBuffer:  Entered, OutputBufferCounter =%d\r\n", OutputBufferCounter, 0, 0, 0);   "     if ( OutputBufferCounter > 0 )       if (isserver) 	         { V           LOG(10,"__WriteBuffer: tcp_sout (length=%d)\r\n",OutputBufferCounter,0,0,0);h           status = (tcp_sout(NETstream,OutputBuffer,(unsigned long)OutputBufferCounter) == NIL ? 1 : 0);Z           LOG(10,"__WriteBuffer: tcp_sout, status = %d, errno = %d\r\n",status,errno,0,0);	         } 
       else	         { Y           LOG(10,"__WriteBuffer: fputs write (length=%d)\r\n",OutputBufferCounter,0,0,0); 3           OutputBuffer[OutputBufferCounter] = '\0'; .           status = fputs(OutputBuffer,stdout);W           LOG(10,"__WriteBuffer: fputs status = %d, errno = %d\r\n", status,errno,0,0); 	         }   H     LOG(10,"__WriteBuffer: Exiting.. status = 0x%08x\r\n",status,0,0,0);     OutputBufferCounter = 0;     return status;   }   J /* -----------------------------------------------------------------------    special_fflush()   8    If the output buffer is not empty, force a write now.  
    Inputs: 	f	- file to flush      Returns:  	0	if OK 	1	if any write error   M    ----------------------------------------------------------------------- */  int special_fflush(f)  FILE *f;   {      if (f != stdout)       return fflush(f);         if (OutputBufferCounter > 0)        return __WriteBuffer();  
     return 0;    }     J /* -----------------------------------------------------------------------    special_putchar()  *    Adds one character to the output buffer  
    Inputs: 	c	- the character to add       Returns:  	0	if OK 	1	if any write error M    ----------------------------------------------------------------------- */ 2 int special_putchar(c)				/* Add char to buffer */ char c;    { ,     OutputBuffer[OutputBufferCounter++] = c;  7     if (c == '\n' || OutputBufferCounter >= BUFFERSIZE)  	return __WriteBuffer();  
     return 0;    }   J /* -----------------------------------------------------------------------    special_fputs()       Writes a string to the output  	    Input: $ 	string	- Pointer to buffer to write 	f	- file to be written       Returns: 
 	0	- if OK 	1	- on any write error   M    ----------------------------------------------------------------------- */ 8 int special_fputs(string,f)			/* Add string to buffer */
 char *string;  FILE *f;   {      if (f != stdout)       return fputs(string,f);        while (*string) 0       if( special_putchar(*string++) ) return 1;  
     return 0;    }     J /* -----------------------------------------------------------------------    special_puts()   ;    Writes a string to standard output followed by a newline   	    Input: $ 	string	- Pointer to buffer to write      Returns: 
 	0	- if OK 	1	- on any write error   M    ----------------------------------------------------------------------- */  int special_puts(string)
 char *string;    { &      if (special_fputs(string,stdout))        return 1;  "      return special_putchar('\n');   }     J /* -----------------------------------------------------------------------    special_fwrite()   #    Writes a chunk of data to a file   
    Inputs:* 	pointer	- pointer to start of data buffer9 	itemsize- size of one item of data (always 1 byte here ) ! 	itemcount	- No of items to write % 	f		- file to which items are written       Returns:  	n	Number of items written  M    ----------------------------------------------------------------------- */ 0 int special_fwrite(pointer,itemsize,itemcount,f) char *pointer; int itemsize, itemcount; FILE *f;   {       int n = 0;         if (f != stdout) 3        return fwrite(pointer,itemsize,itemcount,f);         while (itemcount-- > 0)        {3           if (special_putchar( *pointer++ )) break;            n++;        }        return n;   }       J /* -----------------------------------------------------------------------    special_printf()   ;    Write formatted data to the output using a format string   
    Inputs: 	fmt	- The format string.         ...	- Parameters for the format string    Returns:  	-1	- Error during output ! 	n	- Number of characters written M    ----------------------------------------------------------------------- */ ! int special_printf(char *fmt,...)    {       va_list ap;  (      char temp[20], *s, *numberstyle, t;I      static char *nfmt[2] = {"%d","%ld"};	/* print int, print long int */ -      int n=0;					/* Count of bytes output */         va_start(ap,fmt);      while ((t = *fmt++))         {           if (t != '%') 1              {special_putchar(t); n++; continue;}               numberstyle = nfmt[0];           switch (*fmt++)               {Z                 case '%': if (special_putchar('%'))                 return -1; n++; break;Z                 case 'c': if (special_putchar(va_arg(ap,char)))     return -1; n++; break;0                 case 'l': numberstyle = nfmt[1];                 case 'd': sprintf(temp,numberstyle,va_arg(ap,int)); if (special_fputs(temp,stdout)) return -1; n+=strlen(temp); break;                 case 's': s=va_arg(ap,char *);                      if (special_fputs(s,stdout))    return -1; n+=strlen(s);    break;0                 case '\0': va_end(ap); return n;                 default : LOG(10,"special_printf: invalid format code '%c'\r\n",*--fmt,0,0,0); mm_fatal("special_printf code invalid"); exit(1);              }	         }       va_end(ap);      return n;   } 7 /*  -----  END OF SPECIAL VMS PRINTING CODE  ------- */ 